/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import org.unitime.timetable.model.base.BaseVariableFixedCreditUnitConfig;

public class VariableFixedCreditUnitConfig
extends BaseVariableFixedCreditUnitConfig {
    private static final long serialVersionUID = 1L;
    public static String CREDIT_FORMAT = "variableMinMax";

    public VariableFixedCreditUnitConfig() {
    }

    public VariableFixedCreditUnitConfig(Long uniqueId) {
        super(uniqueId);
    }

    @Override
    public String creditText() {
        StringBuffer sb = new StringBuffer();
        sb.append(sCreditFormat.format(this.getMinUnits()));
        sb.append(" or ");
        sb.append(sCreditFormat.format(this.getMaxUnits()));
        sb.append(" ");
        sb.append(this.getCreditUnitType().getLabel());
        sb.append(" of ");
        sb.append(this.getCreditType().getLabel());
        return sb.toString();
    }

    @Override
    public String creditAbbv() {
        return (this.getCreditFormatAbbv() + " " + sCreditFormat.format(this.getMinUnits()) + "," + sCreditFormat.format(this.getMaxUnits()) + " " + this.getCreditUnitType().getAbbv() + " " + this.getCreditType().getAbbv()).trim();
    }

    @Override
    public Object clone() {
        VariableFixedCreditUnitConfig newCreditConfig = new VariableFixedCreditUnitConfig();
        this.baseClone(newCreditConfig);
        newCreditConfig.setMaxUnits(this.getMaxUnits());
        newCreditConfig.setMinUnits(this.getMinUnits());
        return newCreditConfig;
    }

    @Override
    public float getMinCredit() {
        return this.getMinUnits() == null ? 0.0f : this.getMinUnits().floatValue();
    }

    @Override
    public float getMaxCredit() {
        return this.getMaxUnits() == null ? 0.0f : this.getMaxUnits().floatValue();
    }
}

