/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import org.unitime.timetable.model.Settings;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.model.base.BaseManagerSettings;
import org.unitime.timetable.model.dao.ManagerSettingsDAO;
import org.unitime.timetable.model.dao.SettingsDAO;

public class ManagerSettings
extends BaseManagerSettings {
    private static final long serialVersionUID = 1L;

    public ManagerSettings() {
    }

    public ManagerSettings(Long uniqueId) {
        super(uniqueId);
    }

    public static String getValue(TimetableManager mgr, String name, String defaultValue) {
        if (mgr == null) {
            Settings s = (Settings)SettingsDAO.getInstance().getSession().createQuery("select s from Settings s where s.key = :key").setString("key", name).setCacheable(true).uniqueResult();
            return s == null ? defaultValue : s.getDefaultValue();
        }
        return ManagerSettings.getValue(mgr.getUniqueId(), name, defaultValue);
    }

    public static String getValue(TimetableManager mgr, String name) {
        return ManagerSettings.getValue(mgr, name, null);
    }

    public static String getValue(Long managerId, String name, String defaultValue) {
        if (managerId == null) {
            return defaultValue;
        }
        Settings s = (Settings)SettingsDAO.getInstance().getSession().createQuery("select s from Settings s where s.key = :key").setString("key", name).setCacheable(true).uniqueResult();
        if (s == null) {
            return defaultValue;
        }
        ManagerSettings m = (ManagerSettings)ManagerSettingsDAO.getInstance().getSession().createQuery("select m from ManagerSettings m where m.manager.uniqueId = :managerId and m.key.uniqueId = :settingsId").setLong("managerId", managerId.longValue()).setLong("settingsId", s.getUniqueId().longValue()).setCacheable(true).uniqueResult();
        return m == null ? s.getDefaultValue() : m.getValue();
    }

    public static String getValue(Long managerId, String name) {
        return ManagerSettings.getValue(managerId, name, null);
    }
}

