/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import org.unitime.timetable.model.base.BaseExamConflict;

public class ExamConflict
extends BaseExamConflict
implements Comparable<ExamConflict> {
    private static final long serialVersionUID = 1L;
    public static final int sConflictTypeDirect = 0;
    public static final int sConflictTypeMoreThanTwoADay = 1;
    public static final int sConflictTypeBackToBackDist = 2;
    public static final int sConflictTypeBackToBack = 3;
    public static String[] sConflictTypes = new String[]{"Distance", ">2 A Day", "Distance Back-To-Back", "Back-To-Back"};

    public ExamConflict() {
    }

    public ExamConflict(Long uniqueId) {
        super(uniqueId);
    }

    public boolean isDirectConflict() {
        return 0 == this.getConflictType();
    }

    public boolean isMoreThanTwoADayConflict() {
        return 1 == this.getConflictType();
    }

    public boolean isBackToBackConflict() {
        return 3 == this.getConflictType() || 2 == this.getConflictType();
    }

    public boolean isDistanceBackToBackConflict() {
        return 2 == this.getConflictType();
    }

    @Override
    public int compareTo(ExamConflict conflict) {
        int cmp = this.getConflictType().compareTo(conflict.getConflictType());
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.getNrStudents().compareTo(conflict.getNrStudents());
        if (cmp != 0) {
            return cmp;
        }
        return (this.getUniqueId() == null ? Long.valueOf(-1L) : this.getUniqueId()).compareTo(conflict.getUniqueId() == null ? -1L : conflict.getUniqueId());
    }
}

