/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import java.util.Set;
import java.util.TreeSet;
import org.hibernate.HibernateException;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.base.BaseDistributionType;
import org.unitime.timetable.model.dao.DistributionTypeDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;

public class DistributionType
extends BaseDistributionType
implements Comparable {
    private static final long serialVersionUID = 1L;
    public static String DIST_TYPE_ATTR_NAME = "distributionTypeList";

    public DistributionType() {
    }

    public DistributionType(Long uniqueId) {
        super(uniqueId);
    }

    public static Set findAll() throws HibernateException {
        return DistributionType.findAll(false, false, null);
    }

    public static Set<DistributionType> findAll(boolean instructorPrefOnly, boolean examPref, Boolean visible) throws HibernateException {
        return new TreeSet<DistributionType>(DistributionTypeDAO.getInstance().getSession().createQuery("select t from DistributionType t where t.examPref=" + examPref + (instructorPrefOnly ? " and t.instructorPref=true" : "") + (visible != null ? " and t.visible=" + visible : "")).setCacheable(true).list());
    }

    public static Set<DistributionType> findApplicable(SessionContext context, boolean instructorPrefOnly, boolean examPref, DistributionType current) throws Exception {
        TreeSet<DistributionType> types = null;
        if (context.getUser().getCurrentAuthority().hasRight(Right.DepartmentIndependent)) {
            types = DistributionType.findAll(instructorPrefOnly, examPref, true);
        } else {
            types = new TreeSet();
            TreeSet<Department> userDepartments = Department.getUserDepartments(context.getUser());
            block0: for (DistributionType dt : DistributionType.findAll(instructorPrefOnly, examPref, true)) {
                Set<Department> depts = dt.getDepartments(context.getUser().getCurrentAcademicSessionId());
                if (depts.isEmpty()) {
                    types.add(dt);
                    continue;
                }
                for (Department d : depts) {
                    if (!userDepartments.contains(d)) continue;
                    types.add(dt);
                    continue block0;
                }
            }
        }
        if (current != null && !types.contains(current)) {
            types.add(current);
        }
        return types;
    }

    public static Set findApplicable(Department dept, boolean instructorPrefOnly, boolean examPref) throws Exception {
        Set<Object> types = null;
        if (dept == null) {
            types = DistributionType.findAll(instructorPrefOnly, examPref, true);
        } else {
            types = new TreeSet();
            for (DistributionType dt : DistributionType.findAll(instructorPrefOnly, examPref, true)) {
                Set<Department> depts = dt.getDepartments(dept.getSession().getUniqueId());
                if (!depts.isEmpty() && !depts.contains(dept)) continue;
                types.add(dt);
            }
        }
        return types;
    }

    public boolean isApplicable(Department dept) {
        if (this.getDepartments().isEmpty()) {
            return true;
        }
        Set<Department> depts = this.getDepartments(dept.getSession().getUniqueId());
        return depts.isEmpty() || depts.contains(dept);
    }

    public boolean isAllowed(PreferenceLevel pref) {
        return this.getAllowedPref() == null || this.getAllowedPref().indexOf(PreferenceLevel.prolog2char(pref.getPrefProlog())) >= 0;
    }

    public Set<Department> getDepartments(Long sessionId) {
        TreeSet<Department> ret = new TreeSet<Department>();
        for (Department d : this.getDepartments()) {
            if (sessionId != null && !d.getSession().getUniqueId().equals(sessionId)) continue;
            ret.add(d);
        }
        return ret;
    }

    public int compareTo(Object o) {
        if (o == null || !(o instanceof DistributionType)) {
            return -1;
        }
        DistributionType dt = (DistributionType)o;
        int cmp = this.getLabel().compareTo(dt.getLabel());
        if (cmp != 0) {
            return cmp;
        }
        return this.getRequirementId().compareTo(dt.getRequirementId());
    }

    @Override
    public String toString() {
        return this.getLabel();
    }
}

