/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import java.util.HashSet;
import java.util.List;
import org.cpsolver.studentsct.model.Choice;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.Request;
import org.hibernate.Session;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.CourseRequest;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.StudentSectioningStatus;
import org.unitime.timetable.model.base.BaseCourseDemand;
import org.unitime.timetable.model.base.BaseCourseRequest;
import org.unitime.timetable.model.dao.CourseDemandDAO;

public class CourseDemand
extends BaseCourseDemand
implements Comparable {
    private static final long serialVersionUID = 1L;

    public CourseDemand() {
    }

    public CourseDemand(Long uniqueId) {
        super(uniqueId);
    }

    public int compareTo(Object o) {
        int cmp;
        if (o == null || !(o instanceof CourseDemand)) {
            return -1;
        }
        CourseDemand cd = (CourseDemand)o;
        int n = this.isAlternative().booleanValue() == cd.isAlternative().booleanValue() ? 0 : (cmp = this.isAlternative() != false ? 1 : -1);
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.getPriority().compareTo(cd.getPriority());
        if (cmp != 0) {
            return cmp;
        }
        return (this.getUniqueId() == null ? Long.valueOf(-1L) : this.getUniqueId()).compareTo(cd.getUniqueId() == null ? -1L : cd.getUniqueId());
    }

    public static List findAll(Long sessionId) {
        return CourseDemand.findAll(CourseDemandDAO.getInstance().getSession(), sessionId);
    }

    public static List findAll(Session hibSession, Long sessionId) {
        return hibSession.createQuery("select c from CourseDemand c where c.student.session.uniqueId=:sessionId").setLong("sessionId", sessionId.longValue()).list();
    }

    public void updatePreferences(org.cpsolver.studentsct.model.CourseRequest request, Session hibSession) {
        if (this.getCourseRequests() == null || this.getCourseRequests().isEmpty()) {
            return;
        }
        if (!request.getSelectedChoices().isEmpty() || !request.getRequiredChoices().isEmpty()) {
            for (Course course : request.getCourses()) {
                Object section;
                CourseRequestInterface.RequestedCourse rc = new CourseRequestInterface.RequestedCourse();
                HashSet<Long> im = new HashSet<Long>();
                for (Choice choice : request.getSelectedChoices()) {
                    if (!course.getOffering().equals((Object)choice.getOffering())) continue;
                    if (choice.getSectionId() != null) {
                        section = choice.getOffering().getSection(choice.getSectionId().longValue());
                        if (section == null) continue;
                        rc.setSelectedClass(section.getId(), section.getName(course.getId()), false, true);
                        continue;
                    }
                    if (choice.getConfigId() == null) continue;
                    for (Config config : choice.getOffering().getConfigs()) {
                        if (!choice.getConfigId().equals(config.getId()) || config.getInstructionalMethodId() == null || !im.add(config.getInstructionalMethodId())) continue;
                        rc.setSelectedIntructionalMethod(config.getInstructionalMethodId(), config.getInstructionalMethodName(), false, true);
                    }
                }
                for (Choice choice : request.getRequiredChoices()) {
                    if (!course.getOffering().equals((Object)choice.getOffering())) continue;
                    if (choice.getSectionId() != null) {
                        section = choice.getOffering().getSection(choice.getSectionId().longValue());
                        if (section == null) continue;
                        rc.setSelectedClass(section.getId(), section.getName(course.getId()), true, true);
                        continue;
                    }
                    if (choice.getConfigId() == null) continue;
                    for (Config config : choice.getOffering().getConfigs()) {
                        if (!choice.getConfigId().equals(config.getId()) || config.getInstructionalMethodId() == null || !im.add(config.getInstructionalMethodId())) continue;
                        rc.setSelectedIntructionalMethod(config.getInstructionalMethodId(), config.getInstructionalMethodName(), true, true);
                    }
                }
                for (CourseRequest cr : this.getCourseRequests()) {
                    if (!cr.getCourseOffering().getUniqueId().equals(course.getId())) continue;
                    cr.updatePreferences(rc, hibSession);
                }
            }
        }
    }

    public CourseOffering getFirstChoiceCourseOffering() {
        BaseCourseRequest ret = null;
        for (CourseRequest cr : this.getCourseRequests()) {
            if (ret != null && cr.getOrder() >= ret.getOrder()) continue;
            ret = cr;
        }
        return ret == null ? null : ret.getCourseOffering();
    }

    public Critical getEffectiveCritical() {
        if (this.getCriticalOverride() != null) {
            return Critical.values()[this.getCriticalOverride()];
        }
        if (this.getCritical() != null) {
            return Critical.values()[this.getCritical()];
        }
        return Critical.NORMAL;
    }

    public boolean isCriticalOrImportant() {
        switch (this.getEffectiveCritical()) {
            case CRITICAL: {
                return true;
            }
            case IMPORTANT: {
                return true;
            }
            case VITAL: {
                return true;
            }
        }
        return false;
    }

    public boolean effectiveNoSub() {
        if (this.getNoSub() == null) {
            return false;
        }
        if (this.getNoSub().booleanValue()) {
            StudentSectioningStatus status = this.getStudent().getEffectiveStatus();
            return status == null || status.hasOption(StudentSectioningStatus.Option.nosubs);
        }
        return false;
    }

    public boolean effectiveWaitList() {
        StudentSectioningStatus status;
        if (this.getWaitlist() == null) {
            return false;
        }
        if (this.getWaitlist().booleanValue() && ((status = this.getStudent().getEffectiveStatus()) == null || status.hasOption(StudentSectioningStatus.Option.waitlist))) {
            BaseCourseRequest firstRequest = null;
            if (this.getCourseRequests() != null) {
                for (CourseRequest cr : this.getCourseRequests()) {
                    if (firstRequest != null && firstRequest.getOrder() <= cr.getOrder()) continue;
                    firstRequest = cr;
                }
            }
            return firstRequest != null && firstRequest.getCourseOffering().getInstructionalOffering().effectiveWaitList();
        }
        return false;
    }

    public boolean isEnrolled(boolean checkSectionSwap) {
        for (CourseRequest cr : this.getCourseRequests()) {
            for (StudentClassEnrollment e : this.getStudent().getClassEnrollments()) {
                if (!cr.getCourseOffering().equals(e.getCourseOffering())) continue;
                return !checkSectionSwap || !e.getCourseOffering().equals(cr.getCourseDemand().getWaitListSwapWithCourseOffering()) || cr.isRequired();
            }
        }
        return false;
    }

    public CourseOffering getEnrolledCourse() {
        for (CourseRequest cr : this.getCourseRequests()) {
            for (StudentClassEnrollment e : this.getStudent().getClassEnrollments()) {
                if (!cr.getCourseOffering().equals(e.getCourseOffering())) continue;
                return cr.getCourseOffering();
            }
        }
        return null;
    }

    public boolean isEnrolledExceptForWaitListSwap() {
        for (CourseRequest cr : this.getCourseRequests()) {
            if (cr.getCourseOffering().equals(this.getWaitListSwapWithCourseOffering())) continue;
            for (StudentClassEnrollment e : this.getStudent().getClassEnrollments()) {
                if (!cr.getCourseOffering().equals(e.getCourseOffering())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isWaitListOrNoSub(OnlineSectioningInterface.WaitListMode wlMode) {
        if (wlMode == OnlineSectioningInterface.WaitListMode.WaitList) {
            return this.getWaitlist() != null && this.getWaitlist() != false;
        }
        if (wlMode == OnlineSectioningInterface.WaitListMode.NoSubs) {
            return this.getNoSub() != null && this.getNoSub() != false;
        }
        return false;
    }

    public CourseRequest getCourseRequest(Long courseOfferingId) {
        if (courseOfferingId == null || this.getCourseRequests() == null || this.getCourseRequests().isEmpty()) {
            return null;
        }
        for (CourseRequest cr : this.getCourseRequests()) {
            if (!cr.getCourseOffering().getUniqueId().equals(courseOfferingId)) continue;
            return cr;
        }
        return null;
    }

    public static enum Critical {
        NORMAL(Request.RequestPriority.Normal),
        CRITICAL(Request.RequestPriority.Critical),
        IMPORTANT(Request.RequestPriority.Important),
        VITAL(Request.RequestPriority.Vital),
        LC(Request.RequestPriority.LC);

        Request.RequestPriority iPriority;

        private Critical(Request.RequestPriority rp) {
            this.iPriority = rp;
        }

        public Request.RequestPriority toRequestPriority() {
            return this.iPriority;
        }

        public static Critical fromRequestPriority(Request.RequestPriority rp) {
            if (rp == null) {
                return NORMAL;
            }
            for (Critical c : Critical.values()) {
                if (c.toRequestPriority() != rp) continue;
                return c;
            }
            return NORMAL;
        }

        public static Critical fromText(String text) {
            if ("Critical".equalsIgnoreCase(text)) {
                return CRITICAL;
            }
            if ("Important".equalsIgnoreCase(text)) {
                return IMPORTANT;
            }
            if ("Vital".equalsIgnoreCase(text)) {
                return VITAL;
            }
            if ("LC".equalsIgnoreCase(text)) {
                return LC;
            }
            return NORMAL;
        }
    }
}

