/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import java.util.Properties;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.Configurator;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.unitime.commons.Debug;
import org.unitime.timetable.model.base.BaseApplicationConfig;
import org.unitime.timetable.model.dao.ApplicationConfigDAO;
import org.unitime.timetable.model.dao._RootDAO;

public class ApplicationConfig
extends BaseApplicationConfig {
    private static final long serialVersionUID = 1L;
    public static final String APP_CFG_ATTR_NAME = "appConfig";

    public ApplicationConfig() {
    }

    public ApplicationConfig(String key) {
        super(key);
    }

    public static ApplicationConfig getConfig(String key) {
        try {
            return (ApplicationConfig)new ApplicationConfigDAO().getSession().createCriteria(ApplicationConfig.class).add((Criterion)Restrictions.eq((String)"key", (Object)key)).setCacheable(true).uniqueResult();
        }
        catch (Exception e) {
            Debug.error(e);
            return null;
        }
    }

    public static String getConfigValue(String key, String defaultValue) {
        if (!_RootDAO.isConfigured()) {
            return defaultValue;
        }
        String value = (String)new ApplicationConfigDAO().getSession().createQuery("select c.value from ApplicationConfig c where c.key=:key").setString("key", key).setCacheable(true).uniqueResult();
        return value == null ? defaultValue : value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties toProperties() {
        Properties properties = new Properties();
        if (!_RootDAO.isConfigured()) {
            return properties;
        }
        try (Session hibSession = ApplicationConfigDAO.getInstance().createNewSession();){
            for (ApplicationConfig appcfg : ApplicationConfigDAO.getInstance().findAll(hibSession)) {
                properties.setProperty(appcfg.getKey(), appcfg.getValue() == null ? "" : appcfg.getValue());
            }
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean configureLogging() {
        if (!_RootDAO.isConfigured()) {
            return false;
        }
        try (Session hibSession = ApplicationConfigDAO.getInstance().createNewSession();){
            for (ApplicationConfig config : hibSession.createQuery("from ApplicationConfig where key like 'log4j.logger.%'").list()) {
                Level level = Level.getLevel((String)config.getValue());
                boolean root = "log4j.logger.root".equals(config.getKey());
                if (root) {
                    Configurator.setRootLevel((Level)level);
                } else {
                    Configurator.setLevel((String)config.getKey().substring("log4j.logger.".length()), (Level)level);
                }
                Debug.info("Logging level for " + (root ? "root" : config.getKey().substring("log4j.logger.".length())) + " set to " + level);
            }
        }
        return true;
    }
}

