/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.shared.PersonInterface;
import org.unitime.timetable.interfaces.ExternalUidTranslation;
import org.unitime.timetable.model.base.BaseAdvisor;
import org.unitime.timetable.model.dao.AdvisorDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.server.lookup.PeopleLookupBackend;
import org.unitime.timetable.util.NameFormat;
import org.unitime.timetable.util.NameInterface;

public class Advisor
extends BaseAdvisor
implements NameInterface,
Comparable<Advisor> {
    private static final long serialVersionUID = 1L;

    public boolean hasName() {
        return this.getLastName() != null && !this.getLastName().isEmpty();
    }

    public String getName(String instructorNameFormat) {
        return NameFormat.fromReference(instructorNameFormat).format(this);
    }

    public static Advisor findByExternalId(String externalId, Long sessionId) {
        return (Advisor)AdvisorDAO.getInstance().getSession().createQuery("from Advisor where externalUniqueId = :externalId and session.uniqueId = :sessionId").setString("externalId", externalId).setLong("sessionId", sessionId.longValue()).setCacheable(true).setMaxResults(1).uniqueResult();
    }

    @Override
    public int compareTo(Advisor advisor) {
        int cmp = NameFormat.LAST_FIRST.format(this).compareTo(NameFormat.LAST_FIRST.format(advisor));
        if (cmp != 0) {
            return cmp;
        }
        return (this.getUniqueId() == null ? Long.valueOf(-1L) : this.getUniqueId()).compareTo(advisor.getUniqueId() == null ? -1L : advisor.getUniqueId());
    }

    public boolean lookupDetails() {
        PersonInterface.LookupRequest request;
        GwtRpcResponseList<PersonInterface> response;
        if (this.getExternalUniqueId() == null) {
            return false;
        }
        ExternalUidTranslation translation = null;
        if (ApplicationProperty.ExternalUserIdTranslation.value() != null) {
            try {
                translation = (ExternalUidTranslation)Class.forName(ApplicationProperty.ExternalUserIdTranslation.value()).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String query = this.getExternalUniqueId();
        if (translation != null) {
            query = translation.translate(this.getExternalUniqueId(), ExternalUidTranslation.Source.Staff, ExternalUidTranslation.Source.LDAP);
        }
        if ((response = new PeopleLookupBackend().execute(request = new PersonInterface.LookupRequest(query, "mustHaveExternalId,session=" + this.getSession().getUniqueId() + ",source=ldap:instructors:staff"), (SessionContext)null)) != null) {
            for (PersonInterface person : response) {
                if (!this.getExternalUniqueId().equals(person.getId())) continue;
                this.setFirstName(person.getFirstName());
                this.setLastName(person.getLastName());
                this.setMiddleName(person.getMiddleName());
                this.setAcademicTitle(person.getAcademicTitle());
                this.setEmail(person.getEmail());
                return true;
            }
        }
        if (!query.equals(this.getExternalUniqueId())) {
            this.setLastName(query);
        }
        return false;
    }
}

