/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.shared;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;

public class OnlineSectioningInterface
implements IsSerializable,
Serializable {
    private static final long serialVersionUID = 1L;

    public static class AdvisorNote
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private String iDisplayString;
        private String iReplaceString;
        private int iCount;
        private Date iTimeStamp;

        public String getDisplayString() {
            return this.iDisplayString;
        }

        public void setDisplayString(String displayString) {
            this.iDisplayString = displayString;
        }

        public String getReplaceString() {
            return this.iReplaceString;
        }

        public void setReplaceString(String replaceString) {
            this.iReplaceString = replaceString;
        }

        public int getCount() {
            return this.iCount;
        }

        public void setCount(int count) {
            this.iCount = count;
        }

        public Date getTimeStamp() {
            return this.iTimeStamp;
        }

        public void setTimeStamp(Date timeStamp) {
            this.iTimeStamp = timeStamp;
        }
    }

    public static enum WaitListMode implements IsSerializable,
    Serializable
    {
        WaitList,
        NoSubs,
        None;

    }

    public static class StudentSectioningContext
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Boolean iOnline = null;
        private Boolean iSectioning = null;
        private Long iSessionId = null;
        private Long iStudentId = null;
        private String iPin = null;

        public StudentSectioningContext() {
        }

        public StudentSectioningContext(StudentSectioningContext cx) {
            this.iOnline = cx.iOnline;
            this.iSectioning = cx.iSectioning;
            this.iSessionId = cx.iSessionId;
            this.iStudentId = cx.iStudentId;
            this.iPin = cx.iPin;
        }

        public void setSessionId(Long sessionId) {
            this.iSessionId = sessionId;
        }

        public Long getSessionId() {
            return this.iSessionId;
        }

        public Long getAcademicSessionId() {
            return this.iSessionId;
        }

        public void setAcademicSessionId(Long sessionId) {
            this.iSessionId = sessionId;
        }

        public void setStudentId(Long studentId) {
            this.iStudentId = studentId;
        }

        public Long getStudentId() {
            return this.iStudentId;
        }

        public boolean hasOnline() {
            return this.iOnline != null;
        }

        public boolean isOnline() {
            return this.iOnline != null && this.iOnline != false;
        }

        public void setOnline(boolean online) {
            this.iOnline = online;
        }

        public boolean hasSectioning() {
            return this.iSectioning != null;
        }

        public boolean isSectioning() {
            return this.iSectioning != null && this.iSectioning != false;
        }

        public void setSectioning(boolean sectioning) {
            this.iSectioning = sectioning;
        }

        public void setPin(String pin) {
            this.iPin = pin;
        }

        public String getPin() {
            return this.iPin;
        }

        public boolean hasPin() {
            return this.iPin != null && !this.iPin.isEmpty();
        }
    }

    public static class AdvisorCourseRequestSubmission
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private byte[] iPdf;
        private boolean iUpdated = false;
        private String iName = null;
        private String iLink = null;

        public byte[] getPdf() {
            return this.iPdf;
        }

        public void setPdf(byte[] pdf) {
            this.iPdf = pdf;
        }

        public String getName() {
            return this.iName;
        }

        public boolean hasName() {
            return this.iName != null && !this.iName.isEmpty();
        }

        public void setName(String name) {
            this.iName = name;
        }

        public String getLink() {
            return this.iLink;
        }

        public boolean hasLink() {
            return this.iLink != null && !this.iLink.isEmpty();
        }

        public void setLink(String link) {
            this.iLink = link;
        }

        public boolean isUpdated() {
            return this.iUpdated;
        }

        public void setUpdated(boolean updated) {
            this.iUpdated = updated;
        }
    }

    public static class AdvisingStudentDetails
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Long iStudentId;
        private Long iSessionId;
        private String iStudentName;
        private String iStudentExternalId;
        private String iStudentEmail;
        private String iSessionName;
        private String iAdvisorEmail;
        private StudentStatusInfo iCurrentStatus;
        private Set<StudentStatusInfo> iAvailableStatuses;
        private boolean iCanUpdate;
        private boolean iDegreePlan;
        private boolean iCanEmail = false;
        private CourseRequestInterface iRequest = null;
        private CourseRequestInterface iStudentRequest = null;
        private String iEmailOptionalToggleCaption = null;
        private boolean iEmailOptionalToggleDefault = false;
        private WaitListMode iMode = null;
        private boolean iCanRequire = false;
        private Set<Long> iAdvisorWaitListedCourseIds = null;
        private Integer iCriticalCheck = null;

        public AdvisingStudentDetails() {
        }

        public AdvisingStudentDetails(AdvisingStudentDetails clone) {
            this.iSessionId = clone.iSessionId;
            this.iStudentId = clone.iStudentId;
            this.iStudentName = clone.iStudentName;
            this.iStudentExternalId = clone.iStudentExternalId;
            this.iStudentEmail = clone.iStudentEmail;
            this.iSessionName = clone.iSessionName;
            this.iAdvisorEmail = clone.iAdvisorEmail;
            this.iCurrentStatus = clone.iCurrentStatus;
            this.iCanUpdate = clone.iCanUpdate;
            this.iDegreePlan = clone.iDegreePlan;
            this.iCanEmail = clone.iCanEmail;
            this.iEmailOptionalToggleCaption = clone.iEmailOptionalToggleCaption;
            this.iEmailOptionalToggleDefault = clone.iEmailOptionalToggleDefault;
            this.iMode = clone.iMode;
            this.iCanRequire = clone.iCanRequire;
            this.iAvailableStatuses = clone.iAvailableStatuses;
            this.iStudentRequest = clone.iStudentRequest;
            this.iAdvisorWaitListedCourseIds = clone.iAdvisorWaitListedCourseIds;
            this.iCriticalCheck = clone.iCriticalCheck;
        }

        public Long getStudentId() {
            return this.iStudentId;
        }

        public void setStudentId(Long studentId) {
            this.iStudentId = studentId;
        }

        public Long getSessionId() {
            return this.iSessionId;
        }

        public void setSessionId(Long sessionId) {
            this.iSessionId = sessionId;
        }

        public String getStudentName() {
            return this.iStudentName;
        }

        public void setStudentName(String name) {
            this.iStudentName = name;
        }

        public String getStudentExternalId() {
            return this.iStudentExternalId;
        }

        public void setStudentExternalId(String id) {
            this.iStudentExternalId = id;
        }

        public String getStudentEmail() {
            return this.iStudentEmail;
        }

        public void setStudentEmail(String email) {
            this.iStudentEmail = email;
        }

        public String getSessionName() {
            return this.iSessionName;
        }

        public void setSessionName(String name) {
            this.iSessionName = name;
        }

        public boolean hasAdvisorEmail() {
            return this.iAdvisorEmail != null && !this.iAdvisorEmail.isEmpty();
        }

        public String getAdvisorEmail() {
            return this.iAdvisorEmail;
        }

        public void setAdvisorEmail(String email) {
            this.iAdvisorEmail = email;
        }

        public StudentStatusInfo getStatus() {
            return this.iCurrentStatus;
        }

        public void setStatus(StudentStatusInfo status) {
            this.iCurrentStatus = status;
        }

        public StudentStatusInfo getStatus(String reference) {
            if (reference == null) {
                return null;
            }
            if (this.iCurrentStatus != null && this.iCurrentStatus.getReference().equals(reference)) {
                return this.iCurrentStatus;
            }
            if (this.iAvailableStatuses != null) {
                for (StudentStatusInfo info : this.iAvailableStatuses) {
                    if (!reference.equals(info.getReference())) continue;
                    return info;
                }
            }
            return null;
        }

        public boolean hasStatuses() {
            return this.iAvailableStatuses != null && !this.iAvailableStatuses.isEmpty();
        }

        public void addStatus(StudentStatusInfo status) {
            if (this.iAvailableStatuses == null) {
                this.iAvailableStatuses = new TreeSet<StudentStatusInfo>();
            }
            this.iAvailableStatuses.add(status);
        }

        public Set<StudentStatusInfo> getStatuses() {
            return this.iAvailableStatuses;
        }

        public boolean isCanUpdate() {
            return this.iCanUpdate;
        }

        public void setCanUpdate(boolean canUpdate) {
            this.iCanUpdate = canUpdate;
        }

        public boolean isCanEmail() {
            return this.iCanEmail;
        }

        public void setCanEmail(boolean canEmail) {
            this.iCanEmail = canEmail;
        }

        public boolean isDegreePlan() {
            return this.iDegreePlan;
        }

        public void setDegreePlan(boolean dp) {
            this.iDegreePlan = dp;
        }

        public CourseRequestInterface getRequest() {
            return this.iRequest;
        }

        public void setRequest(CourseRequestInterface request) {
            this.iRequest = request;
        }

        public CourseRequestInterface getStudentRequest() {
            return this.iStudentRequest;
        }

        public boolean hasStudentRequest() {
            return this.iStudentRequest != null && !this.iStudentRequest.isEmpty();
        }

        public void setStudentRequest(CourseRequestInterface request) {
            this.iStudentRequest = request;
        }

        public boolean hasEmailOptionalToggleCaption() {
            return this.iEmailOptionalToggleCaption != null && !this.iEmailOptionalToggleCaption.isEmpty();
        }

        public String getEmailOptionalToggleCaption() {
            return this.iEmailOptionalToggleCaption;
        }

        public void setEmailOptionalToggleCaption(String captionIfOptional) {
            this.iEmailOptionalToggleCaption = captionIfOptional;
        }

        public boolean getEmailOptionalToggleDefault() {
            return this.iEmailOptionalToggleDefault;
        }

        public void setEmailOptionalToggleDefault(boolean defaultValue) {
            this.iEmailOptionalToggleDefault = defaultValue;
        }

        public WaitListMode getWaitListMode() {
            if (this.iMode == null) {
                return WaitListMode.None;
            }
            return this.iMode;
        }

        public void setWaitListMode(WaitListMode mode) {
            this.iMode = mode;
        }

        public boolean isCanRequire() {
            return this.iCanRequire;
        }

        public void setCanRequire(boolean canRequire) {
            this.iCanRequire = canRequire;
        }

        public Set<Long> getAdvisorWaitListedCourseIds() {
            return this.iAdvisorWaitListedCourseIds;
        }

        public void setAdvisorWaitListedCourseIds(Set<Long> advisorWaitListedCourseIds) {
            this.iAdvisorWaitListedCourseIds = advisorWaitListedCourseIds;
        }

        public void setCriticalCheck(Integer check) {
            this.iCriticalCheck = check;
        }

        public Integer getCriticalCheck() {
            return this.iCriticalCheck;
        }

        public boolean hasCriticalCheck() {
            return this.iCriticalCheck != null && this.iCriticalCheck > 0;
        }

        public boolean isCriticalCheckCritical() {
            return this.iCriticalCheck != null && this.iCriticalCheck == 1;
        }

        public boolean isCriticalCheckImportant() {
            return this.iCriticalCheck != null && this.iCriticalCheck == 2;
        }

        public boolean isCriticalCheckVital() {
            return this.iCriticalCheck != null && this.iCriticalCheck == 3;
        }
    }

    public static class StudentInfo
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Long iStudentId;
        private Long iSessionId;
        private String iStudentName;
        private String iStudentExternalId;
        private String iStudentEmail;
        private String iSessionName;

        public Long getStudentId() {
            return this.iStudentId;
        }

        public void setStudentId(Long studentId) {
            this.iStudentId = studentId;
        }

        public Long getSessionId() {
            return this.iSessionId;
        }

        public void setSessionId(Long sessionId) {
            this.iSessionId = sessionId;
        }

        public String getStudentName() {
            return this.iStudentName;
        }

        public void setStudentName(String name) {
            this.iStudentName = name;
        }

        public String getStudentExternalId() {
            return this.iStudentExternalId;
        }

        public void setStudentExternalId(String id) {
            this.iStudentExternalId = id;
        }

        public String getStudentEmail() {
            return this.iStudentEmail;
        }

        public void setStudentEmail(String email) {
            this.iStudentEmail = email;
        }

        public String getSessionName() {
            return this.iSessionName;
        }

        public void setSessionName(String name) {
            this.iSessionName = name;
        }
    }

    public static class GradeMode
    implements IsSerializable,
    Serializable,
    Comparable<GradeMode> {
        private static final long serialVersionUID = 1L;
        private String iCode;
        private String iLabel;
        private boolean iHonor;

        public GradeMode() {
        }

        public GradeMode(String code, String label, boolean honor) {
            this.iCode = code;
            this.iLabel = label;
            this.iHonor = honor;
        }

        public void setCode(String code) {
            this.iCode = code;
        }

        public String getCode() {
            return this.iCode;
        }

        public void setLabel(String label) {
            this.iLabel = label;
        }

        public String getLabel() {
            return this.iLabel;
        }

        public void setHonor(boolean honor) {
            this.iHonor = honor;
        }

        public boolean isHonor() {
            return this.iHonor;
        }

        public int hashCode() {
            return this.getCode().hashCode();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof GradeMode)) {
                return false;
            }
            return this.getCode().equals(((GradeMode)o).getCode());
        }

        @Override
        public int compareTo(GradeMode m) {
            return this.getLabel().compareToIgnoreCase(m.getLabel());
        }
    }

    public static class GradeModes
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        Map<String, GradeMode> iModes = new HashMap<String, GradeMode>();
        private Map<String, Float> iCreditHours = new HashMap<String, Float>();
        private Float iCurrentCredit = null;

        public boolean hasGradeModes() {
            return !this.iModes.isEmpty();
        }

        public void addGradeMode(String sectionId, GradeMode mode) {
            this.iModes.put(sectionId, mode);
        }

        public GradeMode getGradeMode(ClassAssignmentInterface.ClassAssignment a) {
            if (a.getExternalId() == null) {
                return null;
            }
            if (a.getParentSection() != null && a.getParentSection().equals(a.getSection())) {
                return null;
            }
            return this.iModes.get(a.getExternalId());
        }

        public GradeMode getGradeMode(String sectionId) {
            if (this.iModes == null) {
                return null;
            }
            return this.iModes.get(sectionId);
        }

        public Map<String, GradeMode> toMap() {
            return this.iModes;
        }

        public Map<String, Float> getCreditHours() {
            return this.iCreditHours;
        }

        public boolean hasCreditHours() {
            return this.iCreditHours != null && !this.iCreditHours.isEmpty();
        }

        public Float getCreditHour(ClassAssignmentInterface.ClassAssignment a) {
            if (a.getExternalId() == null) {
                return null;
            }
            if (a.getParentSection() != null && a.getParentSection().equals(a.getSection())) {
                return null;
            }
            return this.iCreditHours.get(a.getExternalId());
        }

        public Float getCreditHour(String sectionId) {
            if (this.iCreditHours == null) {
                return null;
            }
            return this.iCreditHours.get(sectionId);
        }

        public void addCreditHour(String sectionId, Float credit) {
            if (credit == null) {
                this.iCreditHours.remove(sectionId);
            } else {
                this.iCreditHours.put(sectionId, credit);
            }
        }

        public boolean hasCurrentCredit() {
            return this.iCurrentCredit != null && this.iCurrentCredit.floatValue() > 0.0f;
        }

        public void setCurrentCredit(Float curCredit) {
            this.iCurrentCredit = curCredit;
        }

        public Float getCurrentCredit() {
            return this.iCurrentCredit;
        }
    }

    public static class StudentStatusInfo
    implements IsSerializable,
    Serializable,
    Comparable<StudentStatusInfo> {
        private static final long serialVersionUID = 1L;
        private Long iUniqueId;
        private String iReference;
        private String iLabel;
        private boolean iAssistantPage = false;
        private boolean iRequestsPage = false;
        private boolean iRegStudent = false;
        private boolean iRegAdvisor = false;
        private boolean iRegAdmin = false;
        private boolean iEnrlStudent = false;
        private boolean iEnrlAdvisor = false;
        private boolean iEnrlAdmin = false;
        private boolean iWaitList = false;
        private boolean iNoSubs = false;
        private boolean iEmail = false;
        private boolean iCanRequire = false;
        private boolean iSpecReg = false;
        private boolean iReqValidation = false;
        private boolean iNoSchedule = false;
        private boolean iReSchedule = false;
        private String iCourseTypes;
        private String iEffectiveStart;
        private String iEffectiveStop;
        private String iMessage;
        private String iFallback;
        private boolean iCanUseAssitant = false;
        private boolean iCanRegister = false;

        public void setUniqueId(Long id) {
            this.iUniqueId = id;
        }

        public Long getUniqueId() {
            return this.iUniqueId;
        }

        public void setReference(String reference) {
            this.iReference = reference;
        }

        public String getReference() {
            return this.iReference;
        }

        public void setLabel(String label) {
            this.iLabel = label;
        }

        public String getLabel() {
            return this.iLabel;
        }

        public void setCanAccessAssistantPage(boolean assistantPage) {
            this.iAssistantPage = assistantPage;
        }

        public boolean isCanAccessAssistantPage() {
            return this.iAssistantPage;
        }

        public void setCanAccessRequestsPage(boolean requestPage) {
            this.iRequestsPage = requestPage;
        }

        public boolean isCanAccessRequestsPage() {
            return this.iRequestsPage;
        }

        public void setCanStudentRegister(boolean regStudent) {
            this.iRegStudent = regStudent;
        }

        public boolean isCanStudentRegister() {
            return this.iRegStudent;
        }

        public void setCanAdvisorRegister(boolean regAdvisor) {
            this.iRegAdvisor = regAdvisor;
        }

        public boolean isCanAdvisorRegister() {
            return this.iRegAdvisor;
        }

        public void setCanAdminRegister(boolean regAdmin) {
            this.iRegAdmin = regAdmin;
        }

        public boolean isCanAdminRegister() {
            return this.iRegAdmin;
        }

        public void setCanStudentEnroll(boolean enrlStudent) {
            this.iEnrlStudent = enrlStudent;
        }

        public boolean isCanStudentEnroll() {
            return this.iEnrlStudent;
        }

        public void setCanAdvisorEnroll(boolean enrlAdvisor) {
            this.iEnrlAdvisor = enrlAdvisor;
        }

        public boolean isCanAdvisorEnroll() {
            return this.iEnrlAdvisor;
        }

        public void setCanAdminEnroll(boolean enrlAdmin) {
            this.iEnrlAdmin = enrlAdmin;
        }

        public boolean isCanAdminEnroll() {
            return this.iEnrlAdmin;
        }

        public void setWaitList(boolean waitlist) {
            this.iWaitList = waitlist;
        }

        public boolean isWaitList() {
            return this.iWaitList;
        }

        public void setNoSubs(boolean noSubs) {
            this.iNoSubs = noSubs;
        }

        public boolean isNoSubs() {
            return this.iNoSubs;
        }

        public void setEmail(boolean email) {
            this.iEmail = email;
        }

        public boolean isEmail() {
            return this.iEmail;
        }

        public void setCanRequire(boolean canRequire) {
            this.iCanRequire = canRequire;
        }

        public boolean isCanRequire() {
            return this.iCanRequire;
        }

        public void setSpecialRegistration(boolean specReg) {
            this.iSpecReg = specReg;
        }

        public boolean isSpecialRegistration() {
            return this.iSpecReg;
        }

        public void setRequestValiadtion(boolean reqVal) {
            this.iReqValidation = reqVal;
        }

        public boolean isRequestValiadtion() {
            return this.iReqValidation;
        }

        public void setNoSchedule(boolean noSchedule) {
            this.iNoSchedule = noSchedule;
        }

        public boolean isNoSchedule() {
            return this.iNoSchedule;
        }

        public void setReSchedule(boolean reSchedule) {
            this.iReSchedule = reSchedule;
        }

        public boolean isReSchedule() {
            return this.iReSchedule;
        }

        public void setAllEnabled() {
            this.iAssistantPage = true;
            this.iRequestsPage = true;
            this.iRegStudent = true;
            this.iRegAdvisor = true;
            this.iRegAdmin = true;
            this.iEnrlStudent = true;
            this.iEnrlAdvisor = true;
            this.iEnrlAdmin = true;
            this.iWaitList = true;
            this.iEmail = true;
            this.iCanRequire = true;
        }

        public void setCourseTypes(String courseTypes) {
            this.iCourseTypes = courseTypes;
        }

        public boolean hasCourseTypes() {
            return this.iCourseTypes != null && !this.iCourseTypes.isEmpty();
        }

        public String getCourseTypes() {
            return this.iCourseTypes;
        }

        public void setEffectiveStart(String start) {
            this.iEffectiveStart = start;
        }

        public boolean hasEffectiveStart() {
            return this.iEffectiveStart != null && !this.iEffectiveStart.isEmpty();
        }

        public String getEffectiveStart() {
            return this.iEffectiveStart;
        }

        public void setEffectiveStop(String stop) {
            this.iEffectiveStop = stop;
        }

        public boolean hasEffectiveStop() {
            return this.iEffectiveStop != null && !this.iEffectiveStop.isEmpty();
        }

        public String getEffectiveStop() {
            return this.iEffectiveStop;
        }

        public void setMessage(String message) {
            this.iMessage = message;
        }

        public boolean hasMessage() {
            return this.iMessage != null && !this.iMessage.isEmpty();
        }

        public String getMessage() {
            return this.iMessage;
        }

        public void setFallback(String fallback) {
            this.iFallback = fallback;
        }

        public boolean hasFallback() {
            return this.iFallback != null && !this.iFallback.isEmpty();
        }

        public String getFallback() {
            return this.iFallback;
        }

        public void setCanUseAssistant(boolean canUseAssistant) {
            this.iCanUseAssitant = canUseAssistant;
        }

        public boolean isCanUseAssistant() {
            return this.iCanUseAssitant;
        }

        public void setCanRegister(boolean canRegister) {
            this.iCanRegister = canRegister;
        }

        public boolean isCanRegister() {
            return this.iCanRegister;
        }

        public String toString() {
            return this.getReference();
        }

        public int hashCode() {
            return this.getReference().hashCode();
        }

        @Override
        public int compareTo(StudentStatusInfo status) {
            return this.getReference().compareTo(status.getReference());
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof StudentStatusInfo)) {
                return false;
            }
            StudentStatusInfo s = (StudentStatusInfo)o;
            return (this.getUniqueId() == null ? -1L : this.getUniqueId()) == (s.getUniqueId() == null ? -1L : s.getUniqueId());
        }
    }

    public static class StudentGroupInfo
    implements IsSerializable,
    Serializable,
    Comparable<StudentGroupInfo> {
        private static final long serialVersionUID = 1L;
        private Long iUniqueId;
        private String iReference;
        private String iLabel;
        private String iType;

        public StudentGroupInfo() {
        }

        public StudentGroupInfo(Long id, String reference, String label, String type) {
            this.iUniqueId = id;
            this.iReference = reference;
            this.iLabel = label;
            this.iType = type;
        }

        public void setUniqueId(Long id) {
            this.iUniqueId = id;
        }

        public Long getUniqueId() {
            return this.iUniqueId;
        }

        public void setReference(String reference) {
            this.iReference = reference;
        }

        public String getReference() {
            return this.iReference;
        }

        public void setLabel(String label) {
            this.iLabel = label;
        }

        public String getLabel() {
            return this.iLabel;
        }

        public void setType(String type) {
            this.iType = type;
        }

        public boolean hasType() {
            return this.iType != null && !this.iType.isEmpty();
        }

        public String getType() {
            return this.iType;
        }

        public String toString() {
            return this.getReference();
        }

        public int hashCode() {
            return this.getReference().hashCode();
        }

        @Override
        public int compareTo(StudentGroupInfo status) {
            int cmp = (this.hasType() ? this.getType() : "").compareTo(status.hasType() ? status.getType() : "");
            if (cmp != 0) {
                return cmp;
            }
            return this.getReference().compareTo(status.getReference());
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof StudentGroupInfo)) {
                return false;
            }
            return this.getUniqueId().equals(((StudentGroupInfo)o).getUniqueId());
        }
    }

    public static class SectioningProperties
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Long iSessionId = null;
        private boolean iAdmin = false;
        private boolean iAdvisor = false;
        private boolean iEmail = false;
        private boolean iMassCancel = false;
        private boolean iChangeStatus = false;
        private boolean iRequestUpdate = false;
        private boolean iReloadStudent = false;
        private boolean iChangeLog = false;
        private boolean iCheckStudentOverrides = false;
        private boolean iValidateStudentOverrides = false;
        private boolean iRecheckCriticalCourses = false;
        private boolean iAdvisorCourseRequests = false;
        private Set<StudentGroupInfo> iEditableGroups = null;
        private String iEmailOptionalToggleCaption = null;
        private boolean iEmailOptionalToggleDefault = false;

        public void setSessionId(Long sessionId) {
            this.iSessionId = sessionId;
        }

        public Long getSessionId() {
            return this.iSessionId;
        }

        public boolean isAdmin() {
            return this.iAdmin;
        }

        public boolean isAdvisor() {
            return this.iAdvisor;
        }

        public boolean isAdminOrAdvisor() {
            return this.iAdmin || this.iAdvisor;
        }

        public void setAdmin(boolean admin) {
            this.iAdmin = admin;
        }

        public void setAdvisor(boolean advisor) {
            this.iAdvisor = advisor;
        }

        public void setEmail(boolean email) {
            this.iEmail = email;
        }

        public boolean isEmail() {
            return this.iEmail;
        }

        public void setMassCancel(boolean massCancel) {
            this.iMassCancel = massCancel;
        }

        public boolean isMassCancel() {
            return this.iMassCancel;
        }

        public void setChangeStatus(boolean changeStatus) {
            this.iChangeStatus = changeStatus;
        }

        public boolean isChangeStatus() {
            return this.iChangeStatus;
        }

        public void setRequestUpdate(boolean requestUpdate) {
            this.iRequestUpdate = requestUpdate;
        }

        public boolean isRequestUpdate() {
            return this.iRequestUpdate;
        }

        public void setReloadStudent(boolean reloadStudent) {
            this.iReloadStudent = reloadStudent;
        }

        public boolean isReloadStudent() {
            return this.iReloadStudent;
        }

        public void setCheckStudentOverrides(boolean checkOverrides) {
            this.iCheckStudentOverrides = checkOverrides;
        }

        public boolean isCheckStudentOverrides() {
            return this.iCheckStudentOverrides;
        }

        public void setValidateStudentOverrides(boolean validateOverrides) {
            this.iValidateStudentOverrides = validateOverrides;
        }

        public boolean isValidateStudentOverrides() {
            return this.iValidateStudentOverrides;
        }

        public void setRecheckCriticalCourses(boolean recheckCriticalCourses) {
            this.iRecheckCriticalCourses = recheckCriticalCourses;
        }

        public boolean isRecheckCriticalCourses() {
            return this.iRecheckCriticalCourses;
        }

        public void setAdvisorCourseRequests(boolean advisorCourseRequests) {
            this.iAdvisorCourseRequests = advisorCourseRequests;
        }

        public boolean isAdvisorCourseRequests() {
            return this.iAdvisorCourseRequests;
        }

        public void setChangeLog(boolean changeLog) {
            this.iChangeLog = changeLog;
        }

        public boolean isChangeLog() {
            return this.iChangeLog;
        }

        public boolean isCanSelectStudent() {
            return this.iEmail || this.iMassCancel || this.iChangeStatus || this.iRequestUpdate || this.iCheckStudentOverrides || this.iValidateStudentOverrides || this.iReloadStudent;
        }

        public boolean hasEditableGroups() {
            return this.iEditableGroups != null && !this.iEditableGroups.isEmpty();
        }

        public Set<StudentGroupInfo> getEditableGroups() {
            return this.iEditableGroups;
        }

        public void setEditableGroups(Set<StudentGroupInfo> groups) {
            this.iEditableGroups = groups;
        }

        public void addEditableGroup(StudentGroupInfo group) {
            if (this.iEditableGroups == null) {
                this.iEditableGroups = new TreeSet<StudentGroupInfo>();
            }
            this.iEditableGroups.add(group);
        }

        public boolean hasEmailOptionalToggleCaption() {
            return this.iEmailOptionalToggleCaption != null && !this.iEmailOptionalToggleCaption.isEmpty();
        }

        public String getEmailOptionalToggleCaption() {
            return this.iEmailOptionalToggleCaption;
        }

        public void setEmailOptionalToggleCaption(String captionIfOptional) {
            this.iEmailOptionalToggleCaption = captionIfOptional;
        }

        public boolean getEmailOptionalToggleDefault() {
            return this.iEmailOptionalToggleDefault;
        }

        public void setEmailOptionalToggleDefault(boolean defaultValue) {
            this.iEmailOptionalToggleDefault = defaultValue;
        }
    }

    public static class EligibilityCheck
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private int iFlags = 0;
        private String iMessage = null;
        private String iCheckboxMessage = null;
        private Long iSessionId = null;
        private Long iStudentId = null;
        private Set<String> iOverrides = null;
        private String iOverrideRequestDisclaimer = null;
        private GradeModes iGradeModes = null;
        private Float iMaxCredit = null;
        private Set<Long> iAdvisorWaitListedCourseIds = null;

        public EligibilityCheck() {
        }

        public EligibilityCheck(String message, EligibilityFlag ... flags) {
            this.iMessage = message;
            for (EligibilityFlag flag : flags) {
                this.setFlag(flag, true);
            }
        }

        public EligibilityCheck(EligibilityFlag ... flags) {
            for (EligibilityFlag flag : flags) {
                this.setFlag(flag, true);
            }
        }

        public void setFlag(EligibilityFlag flag, boolean set) {
            if (set && !this.hasFlag(flag)) {
                this.iFlags += flag.flag();
            }
            if (!set && this.hasFlag(flag)) {
                this.iFlags -= flag.flag();
            }
        }

        public boolean hasFlag(EligibilityFlag flag) {
            return (this.iFlags & flag.flag()) != 0;
        }

        public boolean hasFlag(EligibilityFlag ... flags) {
            for (EligibilityFlag flag : flags) {
                if ((this.iFlags & flag.flag()) == 0) continue;
                return true;
            }
            return false;
        }

        public void setMessage(String message) {
            this.iMessage = message;
        }

        public boolean hasMessage() {
            return this.iMessage != null && !this.iMessage.isEmpty();
        }

        public String getMessage() {
            return this.iMessage;
        }

        public void setCheckboxMessage(String message) {
            this.iCheckboxMessage = message;
        }

        public boolean hasCheckboxMessage() {
            return this.iCheckboxMessage != null && !this.iCheckboxMessage.isEmpty();
        }

        public String getCheckboxMessage() {
            return this.iCheckboxMessage;
        }

        public void setOverrideRequestDisclaimer(String message) {
            this.iOverrideRequestDisclaimer = message;
        }

        public String getOverrideRequestDisclaimer() {
            return this.iOverrideRequestDisclaimer;
        }

        public boolean hasOverrideRequestDisclaimer() {
            return this.iOverrideRequestDisclaimer != null && !this.iOverrideRequestDisclaimer.isEmpty();
        }

        public void setSessionId(Long sessionId) {
            this.iSessionId = sessionId;
        }

        public Long getSessionId() {
            return this.iSessionId;
        }

        public void setStudentId(Long studentId) {
            this.iStudentId = studentId;
        }

        public Long getStudentId() {
            return this.iStudentId;
        }

        public boolean hasMaxCredit() {
            return this.iMaxCredit != null && this.iMaxCredit.floatValue() > 0.0f;
        }

        public void setMaxCredit(Float maxCredit) {
            this.iMaxCredit = maxCredit;
        }

        public Float getMaxCredit() {
            return this.iMaxCredit;
        }

        public boolean hasCurrentCredit() {
            return this.iGradeModes != null && this.iGradeModes.hasCurrentCredit();
        }

        public void setCurrentCredit(Float curCredit) {
            if (this.iGradeModes == null) {
                this.iGradeModes = new GradeModes();
            }
            this.iGradeModes.setCurrentCredit(curCredit);
        }

        public Float getCurrentCredit() {
            if (this.iGradeModes == null) {
                return null;
            }
            return this.iGradeModes.getCurrentCredit();
        }

        public boolean hasOverride(String errorCode) {
            if (errorCode == null || errorCode.isEmpty()) {
                return true;
            }
            return this.iOverrides != null && this.iOverrides.contains(errorCode);
        }

        public void setOverrides(Collection<String> overrides) {
            this.iOverrides = overrides == null ? null : new HashSet<String>(overrides);
        }

        public boolean hasGradeModes() {
            return this.iGradeModes != null && this.iGradeModes.hasGradeModes();
        }

        public void addGradeMode(String sectionId, String code, String label, boolean honor) {
            if (this.iGradeModes == null) {
                this.iGradeModes = new GradeModes();
            }
            this.iGradeModes.addGradeMode(sectionId, new GradeMode(code, label, honor));
        }

        public GradeMode getGradeMode(ClassAssignmentInterface.ClassAssignment section) {
            if (this.iGradeModes == null) {
                return null;
            }
            return this.iGradeModes.getGradeMode(section);
        }

        public GradeModes getGradeModes() {
            return this.iGradeModes;
        }

        public boolean hasCreditHours() {
            return this.iGradeModes != null && this.iGradeModes.hasCreditHours();
        }

        public Float getCreditHour(ClassAssignmentInterface.ClassAssignment section) {
            if (this.iGradeModes == null || section == null) {
                return null;
            }
            return this.iGradeModes.getCreditHour(section);
        }

        public void addCreditHour(String sectionId, Float credit) {
            if (this.iGradeModes == null) {
                this.iGradeModes = new GradeModes();
            }
            this.iGradeModes.addCreditHour(sectionId, credit);
        }

        public Set<Long> getAdvisorWaitListedCourseIds() {
            return this.iAdvisorWaitListedCourseIds;
        }

        public void setAdvisorWaitListedCourseIds(Set<Long> advisorWaitListedCourseIds) {
            this.iAdvisorWaitListedCourseIds = advisorWaitListedCourseIds;
        }

        public static enum EligibilityFlag implements IsSerializable
        {
            IS_ADMIN,
            IS_ADVISOR,
            IS_GUEST,
            CAN_USE_ASSISTANT,
            CAN_ENROLL,
            PIN_REQUIRED,
            CAN_WAITLIST,
            CAN_NO_SUBS,
            RECHECK_AFTER_ENROLLMENT,
            RECHECK_BEFORE_ENROLLMENT,
            CAN_RESET,
            CONFIRM_DROP,
            QUICK_ADD_DROP,
            ALTERNATIVES_DROP,
            GWT_CONFIRMATIONS,
            DEGREE_PLANS,
            CAN_REGISTER,
            NO_REQUEST_ARROWS,
            CAN_SPECREG,
            HAS_SPECREG,
            SR_TIME_CONF,
            SR_LIMIT_CONF,
            CAN_REQUIRE,
            CAN_CHANGE_GRADE_MODE,
            CAN_CHANGE_VAR_CREDIT,
            CAN_REQUEST_VAR_TITLE_COURSE,
            SR_CHANGE_NOTE,
            HAS_ADVISOR_REQUESTS,
            SR_LINK_CONF,
            SR_EXTENDED,
            WAIT_LIST_VALIDATION,
            SHOW_SCHEDULING_PREFS,
            SR_NOTE_PER_COURSE;


            public int flag() {
                return 1 << this.ordinal();
            }
        }
    }
}

