/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.widgets;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HasEnabled;
import com.google.gwt.user.client.ui.HasValue;
import java.util.ArrayList;
import java.util.List;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;

public class FreeTimePicker
extends Grid
implements HasValue<List<CourseRequestInterface.FreeTime>>,
HasEnabled {
    public static final StudentSectioningConstants CONSTANTS = (StudentSectioningConstants)GWT.create(StudentSectioningConstants.class);
    public static final StudentSectioningMessages MESSAGES = (StudentSectioningMessages)GWT.create(StudentSectioningMessages.class);
    private boolean[][] iSelected;
    private long[][] iLastSelectedTime;
    private long iTime = 0L;
    private boolean iEnabled = true;
    private int iDownDay = -1;
    private int iDownPeriod = -1;
    private int iOverDay = -1;
    private int iOverPeriod = -1;

    public FreeTimePicker() {
        super(1 + CONSTANTS.freeTimeDays().length, CONSTANTS.freeTimePeriods());
        int i;
        this.setStyleName("unitime-FreeTimePicker");
        this.sinkEvents(4);
        this.sinkEvents(8);
        this.sinkEvents(1);
        this.sinkEvents(16);
        this.sinkEvents(32);
        this.setCellPadding(2);
        this.setCellSpacing(0);
        this.iSelected = new boolean[CONSTANTS.freeTimeDays().length][CONSTANTS.freeTimePeriods() - 1];
        this.iLastSelectedTime = new long[CONSTANTS.freeTimeDays().length][CONSTANTS.freeTimePeriods() - 1];
        this.setHTML(0, 0, "&nbsp;");
        this.getCellFormatter().setStyleName(0, 0, "corner");
        ToolBox.disableTextSelectInternal((com.google.gwt.dom.client.Element)this.getCellFormatter().getElement(0, 0));
        for (i = 0; i < CONSTANTS.freeTimeDays().length; ++i) {
            this.setText(1 + i, 0, CONSTANTS.freeTimeDays()[i]);
            this.getCellFormatter().setStyleName(1 + i, 0, "vertical-header");
            ToolBox.disableTextSelectInternal((com.google.gwt.dom.client.Element)this.getCellFormatter().getElement(1 + i, 0));
        }
        for (i = 0; i < CONSTANTS.freeTimePeriods() - 1; ++i) {
            this.setText(0, 1 + i, this.toString(i));
            this.getCellFormatter().setStyleName(0, 1 + i, "horizontal-header");
            ToolBox.disableTextSelectInternal((com.google.gwt.dom.client.Element)this.getCellFormatter().getElement(0, 1 + i));
        }
        for (int d = 0; d < CONSTANTS.freeTimeDays().length; ++d) {
            for (int p = 0; p < CONSTANTS.freeTimePeriods() - 1; ++p) {
                this.iSelected[d][p] = false;
                this.iLastSelectedTime[d][p] = 0L;
                this.setHTML(1 + d, 1 + p, "&nbsp;");
                this.getCellFormatter().setStyleName(1 + d, 1 + p, "slot");
                ToolBox.disableTextSelectInternal(this.td(d, p));
            }
        }
        this.update();
    }

    public void onBrowserEvent(Event event) {
        Element td = this.getEventTargetCell(event);
        if (td == null) {
            return;
        }
        Element tr = DOM.getParent((com.google.gwt.dom.client.Element)td);
        Element body = DOM.getParent((com.google.gwt.dom.client.Element)tr);
        int row = DOM.getChildIndex((com.google.gwt.dom.client.Element)body, (com.google.gwt.dom.client.Element)tr);
        int col = DOM.getChildIndex((com.google.gwt.dom.client.Element)tr, (com.google.gwt.dom.client.Element)td);
        if (row == 0 || col == 0) {
            return;
        }
        this.processMouseEvent(DOM.eventGetType((Event)event), row - 1, col - 1);
    }

    public boolean isSelected(int day, int period) {
        return this.iSelected[day][period];
    }

    private com.google.gwt.dom.client.Element td(int day, int period) {
        return this.getCellFormatter().getElement(day + 1, period + 1);
    }

    private String bg(int day, int period) {
        boolean mwf;
        boolean bl = mwf = day % 2 == 0;
        boolean odd = mwf ? period % 4 <= 1 : period % 6 > 2;
        boolean block = false;
        if (this.iDownDay >= 0 && this.iOverDay >= 0) {
            boolean mwfDown;
            int d0 = this.iDownDay < this.iOverDay ? this.iDownDay : this.iOverDay;
            int d1 = this.iDownDay < this.iOverDay ? this.iOverDay : this.iDownDay;
            int p0 = this.iDownPeriod < this.iOverPeriod ? this.iDownPeriod : this.iOverPeriod;
            int p1 = this.iDownPeriod < this.iOverPeriod ? this.iOverPeriod : this.iDownPeriod;
            boolean bl2 = mwfDown = this.iDownDay % 2 == 0;
            if (d0 <= day && day <= d1 && p0 <= period && period <= p1 && (d1 - d0 <= 1 || mwfDown == mwf)) {
                block = true;
            }
        }
        int r = 255;
        int g = 255;
        int b = 255;
        if (this.isSelected(day, period)) {
            b -= 55;
            g -= 55;
        } else if (mwf) {
            r -= odd ? 15 : 30;
            g -= odd ? 15 : 30;
        } else {
            r -= odd ? 15 : 30;
            b -= odd ? 15 : 30;
        }
        if (block) {
            r -= 25;
            g -= 25;
            b -= 25;
        }
        return "#" + (r < 16 ? "0" : "") + Integer.toHexString(r) + (g < 16 ? "0" : "") + Integer.toHexString(g) + (b < 16 ? "0" : "") + Integer.toHexString(b);
    }

    public int toSlot(int period) {
        return 6 * (period + 15);
    }

    public int toPeriod(int slot) {
        int p = slot / 6 - 15;
        if (p < 0) {
            return 0;
        }
        if (p >= CONSTANTS.freeTimePeriods()) {
            return CONSTANTS.freeTimePeriods() - 1;
        }
        return p;
    }

    public String toString(int period) {
        int slot = this.toSlot(period);
        int h = slot / 12;
        int m = 5 * (slot % 12);
        if (CONSTANTS.useAmPm()) {
            return (h > 12 ? h - 12 : h) + ":" + (m < 10 ? "0" : "") + m + (h == 24 ? "a" : (h >= 12 ? "p" : "a"));
        }
        return h + ":" + (m < 10 ? "0" : "") + m;
    }

    private CourseRequestInterface.FreeTime generateOneFreeTime(boolean[][] s) {
        for (int p0 = 0; p0 < CONSTANTS.freeTimePeriods() - 1; ++p0) {
            for (int d0 = 0; d0 < CONSTANTS.freeTimeDays().length; ++d0) {
                int d;
                if (!s[d0][p0]) continue;
                int lastP1 = p0;
                block2: for (int p1 = p0 + 1; p1 < CONSTANTS.freeTimePeriods() - 1; ++p1) {
                    for (d = 0; d < CONSTANTS.freeTimeDays().length; ++d) {
                        if (s[d][p0] && !s[d][p1]) break block2;
                    }
                    lastP1 = p1;
                    for (d = 0; d < CONSTANTS.freeTimeDays().length; ++d) {
                        if (!s[d][p0]) continue;
                        s[d][p1] = false;
                    }
                }
                CourseRequestInterface.FreeTime ft = new CourseRequestInterface.FreeTime();
                for (d = 0; d < CONSTANTS.freeTimeDays().length; ++d) {
                    if (!s[d][p0]) continue;
                    ft.addDay(d);
                    s[d][p0] = false;
                }
                ft.setStart(this.toSlot(p0));
                ft.setLength(this.toSlot(lastP1 + 1) - this.toSlot(p0));
                return ft;
            }
        }
        return null;
    }

    private boolean generateOnePriority(boolean[][] s, int priority) {
        for (int p0 = 0; p0 < CONSTANTS.freeTimePeriods() - 1; ++p0) {
            for (int d0 = 0; d0 < CONSTANTS.freeTimeDays().length; ++d0) {
                boolean mwf0;
                if (!s[d0][p0]) continue;
                boolean bl = mwf0 = d0 % 2 == 0;
                boolean odd0 = mwf0 ? p0 % 4 <= 1 : p0 % 6 > 2;
                int first = 0;
                for (int i = 0; i < CONSTANTS.freeTimeOneDay150().length; ++i) {
                    if (Integer.parseInt(CONSTANTS.freeTimeOneDay150()[i]) > p0) continue;
                    first = Integer.parseInt(CONSTANTS.freeTimeOneDay150()[i]);
                }
                if (mwf0) {
                    int p1;
                    boolean hasM = false;
                    boolean hasF = false;
                    boolean hasS = false;
                    boolean hasT = false;
                    boolean allTheSame = true;
                    for (p1 = first; p1 < Math.min(first + 6, CONSTANTS.freeTimePeriods() - 1); ++p1) {
                        if (s[0][p1]) {
                            hasM = true;
                        }
                        if (s[4][p1]) {
                            hasF = true;
                        }
                        if (p1 - first >= 2 && p1 - first < 4 && (s[0][p1] || s[2][p1] || s[4][p1])) {
                            hasS = true;
                        }
                        if (p1 - first >= 4 && (s[0][p1] || s[2][p1] || s[4][p1])) {
                            hasT = true;
                        }
                        if (d0 != 0 && s[0][p1]) {
                            allTheSame = false;
                        }
                        if (d0 != 2 && s[2][p1]) {
                            allTheSame = false;
                        }
                        if (d0 == 4 || !s[4][p1]) continue;
                        allTheSame = false;
                    }
                    if ((!hasM || !hasT || !hasF) && hasS && hasT || allTheSame && (hasS || hasT)) {
                        for (p1 = first; p1 < Math.min(first + 6, CONSTANTS.freeTimePeriods() - 1); ++p1) {
                            if (!s[d0][p1]) continue;
                            this.setText(1 + d0, 1 + p1, String.valueOf(priority));
                            s[d0][p1] = false;
                        }
                        return true;
                    }
                } else {
                    int p1;
                    boolean allTheSame = true;
                    boolean hasT = false;
                    for (p1 = first; p1 < Math.min(first + 6, CONSTANTS.freeTimePeriods() - 1); ++p1) {
                        if (p1 - first >= 4 && (s[1][p1] || s[3][p1])) {
                            hasT = true;
                        }
                        if (d0 != 1 && s[1][p1]) {
                            allTheSame = false;
                        }
                        if (d0 == 3 || !s[3][p1]) continue;
                        allTheSame = false;
                    }
                    if (allTheSame || hasT && 3 * (first / 3) != first) {
                        for (p1 = first; p1 < Math.min(first + 6, CONSTANTS.freeTimePeriods() - 1); ++p1) {
                            if (!s[d0][p1]) continue;
                            this.setText(1 + d0, 1 + p1, String.valueOf(priority));
                            s[d0][p1] = false;
                        }
                        return true;
                    }
                }
                block7: for (int p1 = p0; p1 < CONSTANTS.freeTimePeriods() - 1; ++p1) {
                    for (int d1 = 0; d1 < CONSTANTS.freeTimeDays().length; ++d1) {
                        boolean odd1;
                        boolean mwf1;
                        boolean bl2 = mwf1 = d1 % 2 == 0;
                        boolean bl3 = mwf1 ? p1 % 4 <= 1 : (odd1 = p1 % 6 > 2);
                        if (mwf0 == mwf1 && odd0 != odd1) break block7;
                        if (!s[d1][p1] || mwf0 != mwf1 || odd0 != odd1) continue;
                        this.setText(1 + d1, 1 + p1, String.valueOf(priority));
                        s[d1][p1] = false;
                    }
                }
                return true;
            }
        }
        return false;
    }

    public void generatePriorities() {
        boolean[][] s = new boolean[CONSTANTS.freeTimeDays().length][CONSTANTS.freeTimePeriods() - 1];
        for (int d = 0; d < CONSTANTS.freeTimeDays().length; ++d) {
            for (int p = 0; p < CONSTANTS.freeTimePeriods() - 1; ++p) {
                s[d][p] = this.iSelected[d][p];
                if (this.iSelected[d][p]) continue;
                this.setHTML(1 + d, 1 + p, "&nbsp;");
            }
        }
        int priority = 1;
        while (this.generateOnePriority(s, priority)) {
            ++priority;
        }
    }

    public void update() {
        for (int d = 0; d < CONSTANTS.freeTimeDays().length; ++d) {
            for (int p = 0; p < CONSTANTS.freeTimePeriods() - 1; ++p) {
                this.td(d, p).getStyle().setBackgroundColor(this.bg(d, p));
            }
        }
    }

    private void processMouseEvent(int eventType, int day, int period) {
        if (!this.isEnabled()) {
            return;
        }
        switch (eventType) {
            case 4: {
                this.iDownDay = day;
                this.iDownPeriod = period;
                this.iOverDay = day;
                this.iOverPeriod = period;
                break;
            }
            case 8: {
                if (this.iDownDay >= 0 && this.iOverDay >= 0) {
                    int d0 = this.iDownDay < this.iOverDay ? this.iDownDay : this.iOverDay;
                    int d1 = this.iDownDay < this.iOverDay ? this.iOverDay : this.iDownDay;
                    int p0 = this.iDownPeriod < this.iOverPeriod ? this.iDownPeriod : this.iOverPeriod;
                    int p1 = this.iDownPeriod < this.iOverPeriod ? this.iOverPeriod : this.iDownPeriod;
                    boolean allSelected = true;
                    boolean mwfDown = this.iDownDay % 2 == 0;
                    block6: for (int d = d0; d <= d1; ++d) {
                        if (d1 - d0 > 0 && d % 2 == 0 != mwfDown) continue;
                        for (int p = p0; p <= p1; ++p) {
                            if (this.iSelected[d][p]) continue;
                            allSelected = false;
                            break block6;
                        }
                    }
                    long ts = this.iTime++;
                    for (int d = d0; d <= d1; ++d) {
                        if (d1 - d0 > 1 && d % 2 == 0 != mwfDown) continue;
                        for (int p = p0; p <= p1; ++p) {
                            this.iSelected[d][p] = !allSelected;
                            this.iLastSelectedTime[d][p] = ts;
                        }
                    }
                }
                this.iDownDay = -1;
                this.iDownPeriod = -1;
                this.iOverDay = -1;
                this.iOverPeriod = -1;
                this.generatePriorities();
                ValueChangeEvent.fire((HasValueChangeHandlers)this, (Object)this.getValue());
                break;
            }
            case 16: {
                this.iOverDay = day;
                this.iOverPeriod = period;
                break;
            }
            case 32: {
                this.iOverDay = -1;
                this.iOverPeriod = -1;
            }
        }
        this.update();
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<List<CourseRequestInterface.FreeTime>> handler) {
        return this.addHandler((EventHandler)handler, ValueChangeEvent.getType());
    }

    public List<CourseRequestInterface.FreeTime> getValue() {
        boolean[][] s = new boolean[CONSTANTS.freeTimeDays().length][CONSTANTS.freeTimePeriods() - 1];
        for (int d = 0; d < CONSTANTS.freeTimeDays().length; ++d) {
            for (int p = 0; p < CONSTANTS.freeTimePeriods() - 1; ++p) {
                s[d][p] = this.iSelected[d][p];
            }
        }
        ArrayList<CourseRequestInterface.FreeTime> ret = new ArrayList<CourseRequestInterface.FreeTime>();
        CourseRequestInterface.FreeTime ft = null;
        while ((ft = this.generateOneFreeTime(s)) != null) {
            ret.add(ft);
        }
        return ret;
    }

    public void setValue(List<CourseRequestInterface.FreeTime> value) {
        this.setValue(value, false);
    }

    public void setValue(List<CourseRequestInterface.FreeTime> value, boolean fireEvents) {
        if (value == null || value.isEmpty()) {
            for (int d = 0; d < CONSTANTS.freeTimeDays().length; ++d) {
                for (int p = 0; p < CONSTANTS.freeTimePeriods() - 1; ++p) {
                    this.iSelected[d][p] = false;
                    this.td(d, p).getStyle().setBackgroundColor(this.bg(d, p));
                    this.setHTML(1 + d, 1 + p, "&nbsp;");
                }
            }
        } else {
            for (int d = 0; d < CONSTANTS.freeTimeDays().length; ++d) {
                for (int p = 0; p < CONSTANTS.freeTimePeriods() - 1; ++p) {
                    this.iSelected[d][p] = false;
                }
            }
            for (CourseRequestInterface.FreeTime f : value) {
                for (int day : f.getDays()) {
                    if (day >= CONSTANTS.freeTimeDays().length) continue;
                    for (int p = this.toPeriod(f.getStart()); p < this.toPeriod(f.getStart() + f.getLength()); ++p) {
                        this.iSelected[day][p] = true;
                    }
                }
            }
            this.generatePriorities();
            this.update();
        }
        if (fireEvents) {
            ValueChangeEvent.fire((HasValueChangeHandlers)this, (Object)this.getValue());
        }
    }

    public boolean isEnabled() {
        return this.iEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.iEnabled = enabled;
    }
}

