/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.solver;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasValue;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Comparator;
import org.unitime.timetable.gwt.client.GwtHint;
import org.unitime.timetable.gwt.client.TimeHint;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.rooms.RoomHint;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeFrameDialog;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.client.widgets.UniTimeTableHeader;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.GwtResources;
import org.unitime.timetable.gwt.shared.TableInterface;

public class DataTable
extends UniTimeTable<TableInterface.TableRowInterface>
implements HasValue<Integer>,
SimpleForm.HasMobileScroll {
    private Integer iValue = null;
    private static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private static final GwtResources RESOURCES = (GwtResources)GWT.create(GwtResources.class);

    public DataTable(TableInterface table) {
        this.addStyleName("unitime-DataTable");
        if (table != null) {
            this.populate(table);
        }
        this.addMouseClickListener(new UniTimeTable.MouseClickListener<TableInterface.TableRowInterface>(){

            @Override
            public void onMouseClick(UniTimeTable.TableEvent<TableInterface.TableRowInterface> event) {
                if (event.getData() != null && event.getData().hasLink()) {
                    DataTable.this.clearHover();
                    GwtHint.hideHint();
                    if (event.getData().getLinkName() != null) {
                        UniTimeFrameDialog.openDialog(event.getData().getLinkName(), event.getData().getLink(), "900", "85%");
                    } else {
                        ToolBox.open(GWT.getHostPageBaseURL() + event.getData().getLink());
                    }
                }
            }
        });
    }

    public void populate(TableInterface table) {
        this.clearTable();
        ArrayList<UniTimeTableHeader> header = new ArrayList<UniTimeTableHeader>();
        for (final TableInterface.TableHeaderIterface th : table.getHeader()) {
            final UniTimeTableHeader h = new UniTimeTableHeader(th.getName());
            if (th.isComparable()) {
                h.addOperation(new UniTimeTableHeader.Operation(){

                    public void execute() {
                        boolean asc = h.getOrder() == null ? true : h.getOrder() == false;
                        DataTable.this.setValue(asc ? 1 + h.getColumn() : -1 - h.getColumn(), true);
                    }

                    @Override
                    public boolean isApplicable() {
                        return DataTable.this.getRowCount() > 1;
                    }

                    @Override
                    public boolean hasSeparator() {
                        return false;
                    }

                    @Override
                    public String getName() {
                        return MESSAGES.opSortBy(th.getName());
                    }
                });
            }
            if (th.getAlignment() != null) {
                switch (th.getAlignment()) {
                    case CENTER: {
                        h.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
                        break;
                    }
                    case LEFT: {
                        h.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_LEFT);
                        break;
                    }
                    case RIGHT: {
                        h.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
                    }
                }
            }
            header.add(h);
        }
        this.addRow(null, header);
        for (TableInterface.TableRowInterface row : table.getRows()) {
            ArrayList<DataTableCell> line = new ArrayList<DataTableCell>();
            int idx = 0;
            for (TableInterface.TableCellInterface cell : row.getCells()) {
                line.add(new DataTableCell(table.getHeader(idx++), cell));
            }
            int rowIdx = this.addRow(row, line);
            if (!row.isSelected()) continue;
            this.getRowFormatter().setStyleName(rowIdx, "unitime-TableRowSelected");
        }
        for (int i = 0; i < table.getHeader().length; ++i) {
            if (table.getHeader(i).isVisible()) continue;
            this.setColumnVisible(i, false);
        }
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<Integer> handler) {
        return this.addHandler((EventHandler)handler, ValueChangeEvent.getType());
    }

    public Integer getValue() {
        return this.iValue;
    }

    public void setValue(Integer value) {
        this.setValue(value, false);
    }

    public void setValue(Integer value, boolean fireEvents) {
        int column;
        UniTimeTableHeader h;
        this.iValue = value;
        if (value != null && value != 0 && (h = this.getHeader(column = value > 0 ? value - 1 : -value.intValue() - 1)) != null) {
            this.sort(h, new Comparator<TableInterface.TableRowInterface>(){

                @Override
                public int compare(TableInterface.TableRowInterface r1, TableInterface.TableRowInterface r2) {
                    return r1.compareTo(r2, column, true);
                }
            }, value > 0);
        }
        if (fireEvents) {
            ValueChangeEvent.fire((HasValueChangeHandlers)this, (Object)this.getValue());
        }
    }

    public static class DataTableCell
    extends P
    implements UniTimeTable.HasCellAlignment {
        private TableInterface.TableHeaderIterface iHeader;

        public DataTableCell(TableInterface.TableHeaderIterface header, TableInterface.TableCellInterface cell) {
            super(new String[0]);
            Long classId;
            TableInterface.TableCellMulti multi;
            TableInterface.TableCellTime time;
            this.iHeader = header;
            if (cell.hasStyleName()) {
                this.addStyleName(cell.getStyleName());
            }
            if (cell.isUnderlined()) {
                this.addStyleName("underlined");
            }
            if (cell.hasColor()) {
                this.getElement().getStyle().setColor(cell.getColor());
            }
            if (cell instanceof TableInterface.TableCellTime && (time = (TableInterface.TableCellTime)cell).hasId()) {
                this.addMouseOverHandler(new MouseOverHandler(){

                    public void onMouseOver(MouseOverEvent event) {
                        TimeHint.showHint((Element)this.getElement(), time.getId());
                    }
                });
                this.addMouseOutHandler(new MouseOutHandler(){

                    public void onMouseOut(MouseOutEvent event) {
                        TimeHint.hideHint();
                    }
                });
            }
            if (cell instanceof TableInterface.TableCellRooms) {
                this.addStyleName("collection");
                TableInterface.TableCellRooms rooms = (TableInterface.TableCellRooms)cell;
                for (int index = 0; index < rooms.getNrRooms(); ++index) {
                    final P room = new P("item");
                    room.setText(rooms.getName(index) + (index + 1 < rooms.getNrRooms() ? "," : ""));
                    room.getElement().getStyle().setColor(rooms.getColor(index));
                    final String id = rooms.getId(index);
                    final String preference = rooms.getPreference(index);
                    if (id != null) {
                        room.addMouseOverHandler(new MouseOverHandler(){

                            public void onMouseOver(MouseOverEvent event) {
                                RoomHint.showHint((Element)room.getElement(), Long.parseLong(id), preference, null, true);
                            }
                        });
                        room.addMouseOutHandler(new MouseOutHandler(){

                            public void onMouseOut(MouseOutEvent event) {
                                RoomHint.hideHint();
                            }
                        });
                    }
                    this.add((Widget)room);
                }
                return;
            }
            if (cell instanceof TableInterface.TableCellItems) {
                this.addStyleName("collection");
                TableInterface.TableCellItems instructors = (TableInterface.TableCellItems)cell;
                for (int index = 0; index < instructors.getNrItems(); ++index) {
                    P instructor = new P("item");
                    instructor.setText(instructors.getFormattedValue(index) + (index + 1 < instructors.getNrItems() ? "," : ""));
                    if (instructors.getColor(index) != null) {
                        instructor.getElement().getStyle().setColor(instructors.getColor(index));
                    }
                    this.add((Widget)instructor);
                }
                return;
            }
            if (cell instanceof TableInterface.TableCellMultiLine) {
                this.addStyleName("multiline");
                multi = (TableInterface.TableCellMultiLine)cell;
                for (int index = 0; index < multi.getNrChunks(); ++index) {
                    this.add((Widget)new DataTableCell(header, multi.get(index)));
                }
                return;
            }
            if (cell instanceof TableInterface.TableCellMulti) {
                this.addStyleName("multi");
                multi = (TableInterface.TableCellMulti)cell;
                for (int index = 0; index < multi.getNrChunks(); ++index) {
                    P chunk = new P("chunk");
                    TableInterface.TableCellInterface m = multi.get(index);
                    if (m.hasStyleName()) {
                        chunk.addStyleName(m.getStyleName());
                    }
                    if (m.hasColor()) {
                        chunk.getElement().getStyle().setColor(m.getColor());
                    }
                    chunk.setText(m.getFormattedValue());
                    this.add((Widget)chunk);
                }
                return;
            }
            if (cell instanceof TableInterface.TableCellChange) {
                this.addStyleName("change");
                TableInterface.TableCellChange change = (TableInterface.TableCellChange)cell;
                if (change.getFirst() != null && change.getSecond() != null && change.getFirst().compareTo(change.getSecond()) == 0) {
                    this.add((Widget)new DataTableCell(header, change.getFirst()));
                    return;
                }
                if (change.getFirst() == null) {
                    P notAssigned = new P("not-assigned");
                    notAssigned.setText(MESSAGES.notAssigned());
                    this.add((Widget)notAssigned);
                } else {
                    this.add((Widget)new DataTableCell(header, change.getFirst()));
                }
                P arrow = new P("arrow");
                arrow.setHTML(MESSAGES.assignmentArrow());
                this.add((Widget)arrow);
                if (change.getSecond() == null) {
                    P notAssigned = new P("not-assigned");
                    notAssigned.setText(MESSAGES.notAssigned());
                    this.add((Widget)notAssigned);
                } else {
                    this.add((Widget)new DataTableCell(header, change.getSecond()));
                }
                return;
            }
            if (cell instanceof TableInterface.TableCellBoolean) {
                Boolean value = (Boolean)((TableInterface.TableCellBoolean)cell).getValue();
                if (value != null && value.booleanValue()) {
                    this.add((Widget)new Image(RESOURCES.on()));
                } else if (value != null && !value.booleanValue()) {
                    this.add((Widget)new Image(RESOURCES.off()));
                } else {
                    this.setHTML(cell.getFormattedValue());
                }
            } else {
                this.setHTML(cell.getFormattedValue());
            }
            if (cell instanceof TableInterface.TableCellClassName && ((TableInterface.TableCellClassName)cell).hasAlternatives()) {
                this.addStyleName("collection");
                for (String name : ((TableInterface.TableCellClassName)cell).getAlternatives()) {
                    P alternative = new P("alternative");
                    alternative.setText(name);
                    this.add((Widget)alternative);
                }
            }
            if (cell instanceof TableInterface.TableCellClickableClassName && (classId = ((TableInterface.TableCellClickableClassName)cell).getClassId()) != null) {
                this.addStyleName("clickable");
                this.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        UniTimeFrameDialog.openDialog(MESSAGES.dialogSuggestions(), "gwt.jsp?page=suggestions&menu=hide&id=" + classId, "900", "90%");
                    }
                });
            }
        }

        @Override
        public HasHorizontalAlignment.HorizontalAlignmentConstant getCellAlignment() {
            if (this.iHeader == null || this.iHeader.getAlignment() == null) {
                return HasHorizontalAlignment.ALIGN_LEFT;
            }
            switch (this.iHeader.getAlignment()) {
                case CENTER: {
                    return HasHorizontalAlignment.ALIGN_CENTER;
                }
                case LEFT: {
                    return HasHorizontalAlignment.ALIGN_LEFT;
                }
                case RIGHT: {
                    return HasHorizontalAlignment.ALIGN_RIGHT;
                }
            }
            return HasHorizontalAlignment.ALIGN_LEFT;
        }
    }
}

