/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.sectioning;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.TakesValue;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import org.unitime.timetable.gwt.client.events.SingleDateSelector;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeDialogBox;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.resources.GwtAriaMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningResources;
import org.unitime.timetable.gwt.shared.AcademicSessionProvider;
import org.unitime.timetable.gwt.shared.StudentSchedulingPreferencesInterface;

public class StudentSchedulingPreferencesDialog
extends UniTimeDialogBox
implements TakesValue<StudentSchedulingPreferencesInterface> {
    protected static StudentSectioningMessages MESSAGES = (StudentSectioningMessages)GWT.create(StudentSectioningMessages.class);
    protected static StudentSectioningConstants CONSTANTS = (StudentSectioningConstants)GWT.create(StudentSectioningConstants.class);
    protected static final StudentSectioningResources RESOURCES = (StudentSectioningResources)GWT.create(StudentSectioningResources.class);
    protected static final GwtAriaMessages ARIA = (GwtAriaMessages)GWT.create(GwtAriaMessages.class);
    private SimpleForm iForm;
    private UniTimeHeaderPanel iFooter;
    private SingleDateSelector iDateFrom;
    private SingleDateSelector iDateTo;
    private int iDatesLine;
    private ListBox iModality;
    private ListBox iBackToBack;
    private P iModalityDesc;
    private P iBackToBackDesc;
    private StudentSchedulingPreferencesInterface iPreferences;
    private HTML iCustomNote;

    public StudentSchedulingPreferencesDialog(AcademicSessionProvider sessionProvider) {
        super(true, false);
        this.setEscapeToHide(true);
        this.addStyleName("unitime-StudentSchedulingPreferencesDialog");
        this.setHTML("<img src='" + RESOURCES.preferences().getSafeUri().asString() + "' class='gwt-Image'></img><span class='gwt-Label' style='padding-left: 5px; vertical-align: top;'>" + MESSAGES.dialogStudentSchedulingPreferences() + "</span>");
        this.iForm = new SimpleForm();
        this.iModality = new ListBox();
        this.iModality.addItem(MESSAGES.itemSchedulingModalityNoPreference(), "NoPreference");
        this.iModality.addItem(MESSAGES.itemSchedulingModalityPreferFaceToFace(), "DiscouragedOnline");
        this.iModality.addItem(MESSAGES.itemSchedulingModalityPreferOnline(), "PreferredOnline");
        this.iModality.addItem(MESSAGES.itemSchedulingModalityRequireOnline(), "RequiredOnline");
        this.iModality.addStyleName("selection");
        AbsolutePanel p = new AbsolutePanel();
        p.setStyleName("modality");
        p.add((Widget)this.iModality);
        this.iModalityDesc = new P("description");
        this.iModalityDesc.setText(MESSAGES.descSchedulingModalityPreferFaceToFace());
        p.add((Widget)this.iModalityDesc);
        this.iModality.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                StudentSchedulingPreferencesDialog.this.modalityChanged();
            }
        });
        this.iForm.addRow(MESSAGES.propSchedulingPrefModality(), (Widget)p);
        this.iBackToBack = new ListBox();
        this.iBackToBack.addItem(MESSAGES.itemSchedulingBackToBackNoPreference(), "NoPreference");
        this.iBackToBack.addItem(MESSAGES.itemSchedulingBackToBackPrefer(), "PreferBackToBack");
        this.iBackToBack.addItem(MESSAGES.itemSchedulingBackToBackDiscourage(), "DiscourageBackToBack");
        this.iBackToBack.addStyleName("selection");
        AbsolutePanel q = new AbsolutePanel();
        q.setStyleName("back-to-back");
        q.add((Widget)this.iBackToBack);
        this.iBackToBackDesc = new P("description");
        this.iBackToBackDesc.setText(MESSAGES.descSchedulingBackToBackNoPreference());
        q.add((Widget)this.iBackToBackDesc);
        this.iBackToBack.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                StudentSchedulingPreferencesDialog.this.backToBackChanged();
            }
        });
        this.iForm.addRow(MESSAGES.propSchedulingPrefBackToBack(), (Widget)q);
        AbsolutePanel m = new AbsolutePanel();
        m.setStyleName("dates");
        P from = new P("from");
        from.setText(MESSAGES.propSchedulingPrefDatesFrom());
        m.add((Widget)from);
        this.iDateFrom = new SingleDateSelector(sessionProvider);
        m.add((Widget)this.iDateFrom);
        P to = new P("to");
        to.setText(MESSAGES.propSchedulingPrefDatesTo());
        m.add((Widget)to);
        this.iDateTo = new SingleDateSelector(sessionProvider);
        m.add((Widget)this.iDateTo);
        P desc = new P("description");
        desc.setText(MESSAGES.propSchedulingPrefDatesDescription());
        m.add((Widget)desc);
        this.iDatesLine = this.iForm.addRow(MESSAGES.propSchedulingPrefDates(), (Widget)m);
        this.iCustomNote = new HTML();
        this.iCustomNote.addStyleName("custom-note");
        this.iCustomNote.setText("");
        this.iCustomNote.setVisible(false);
        this.iForm.addRow((Widget)this.iCustomNote);
        this.iFooter = new UniTimeHeaderPanel();
        this.iFooter.addButton("apply", MESSAGES.buttonSchedulingPrefApply(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                StudentSchedulingPreferencesDialog.this.doApply();
            }
        });
        this.iFooter.addButton("close", MESSAGES.buttonSchedulingPrefClose(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                StudentSchedulingPreferencesDialog.this.hide();
            }
        });
        this.iForm.addBottomRow((Widget)this.iFooter);
        this.setWidget((Widget)this.iForm);
    }

    protected void modalityChanged() {
        if ("DiscouragedOnline".equals(this.iModality.getSelectedValue())) {
            this.iModalityDesc.setText(MESSAGES.descSchedulingModalityPreferFaceToFace());
        } else if ("PreferredOnline".equals(this.iModality.getSelectedValue())) {
            this.iModalityDesc.setText(MESSAGES.descSchedulingModalityPreferOnline());
        } else if ("RequiredOnline".equals(this.iModality.getSelectedValue())) {
            this.iModalityDesc.setText(MESSAGES.descSchedulingModalityRequireOnline());
        } else if ("NoPreference".equals(this.iModality.getSelectedValue())) {
            this.iModalityDesc.setText(MESSAGES.descSchedulingModalityNoPreference());
        }
    }

    protected void backToBackChanged() {
        if ("PreferBackToBack".equals(this.iBackToBack.getSelectedValue())) {
            this.iBackToBackDesc.setText(MESSAGES.descSchedulingBackToBackPrefer());
        } else if ("DiscourageBackToBack".equals(this.iBackToBack.getSelectedValue())) {
            this.iBackToBackDesc.setText(MESSAGES.descSchedulingBackToBackDiscourage());
        } else if ("NoPreference".equals(this.iBackToBack.getSelectedValue())) {
            this.iBackToBackDesc.setText(MESSAGES.descSchedulingBackToBackNoPreference());
        }
    }

    @Override
    public void center() {
        super.center();
        this.iModality.setFocus(true);
    }

    protected void doApply() {
        this.hide();
    }

    public StudentSchedulingPreferencesInterface getValue() {
        this.iPreferences.setClassModality(StudentSchedulingPreferencesInterface.ClassModality.valueOf(this.iModality.getSelectedValue()));
        this.iPreferences.setScheduleGaps(StudentSchedulingPreferencesInterface.ScheduleGaps.valueOf(this.iBackToBack.getSelectedValue()));
        this.iPreferences.setClassDateFrom(this.iPreferences.isAllowClassDates() ? this.iDateFrom.getValueInServerTimeZone() : null);
        this.iPreferences.setClassDateTo(this.iPreferences.isAllowClassDates() ? this.iDateTo.getValueInServerTimeZone() : null);
        return new StudentSchedulingPreferencesInterface(this.iPreferences);
    }

    public void setValue(StudentSchedulingPreferencesInterface value) {
        int i;
        this.iPreferences = value;
        this.iForm.getRowFormatter().setVisible(this.iDatesLine, this.iPreferences.isAllowClassDates());
        this.iModality.clear();
        this.iModality.addItem(MESSAGES.itemSchedulingModalityNoPreference(), "NoPreference");
        this.iModality.addItem(MESSAGES.itemSchedulingModalityPreferFaceToFace(), "DiscouragedOnline");
        this.iModality.addItem(MESSAGES.itemSchedulingModalityPreferOnline(), "PreferredOnline");
        if (this.iPreferences.isAllowRequireOnline()) {
            this.iModality.addItem(MESSAGES.itemSchedulingModalityRequireOnline(), "RequiredOnline");
        }
        if (this.iPreferences.getClassModality() != null) {
            for (i = 0; i < this.iModality.getItemCount(); ++i) {
                if (!this.iPreferences.getClassModality().name().equals(this.iModality.getValue(i))) continue;
                this.iModality.setSelectedIndex(i);
                this.modalityChanged();
                break;
            }
        }
        if (this.iPreferences.getScheduleGaps() != null) {
            for (i = 0; i < this.iBackToBack.getItemCount(); ++i) {
                if (!this.iPreferences.getScheduleGaps().name().equals(this.iBackToBack.getValue(i))) continue;
                this.iBackToBack.setSelectedIndex(i);
                this.backToBackChanged();
                break;
            }
        }
        this.iDateFrom.setValueInServerTimeZone(this.iPreferences.isAllowRequireOnline() ? this.iPreferences.getClassDateFrom() : null);
        this.iDateTo.setValueInServerTimeZone(this.iPreferences.isAllowRequireOnline() ? this.iPreferences.getClassDateTo() : null);
        if (this.iPreferences.hasCustomNote()) {
            this.iCustomNote.setHTML(this.iPreferences.getCustomNote());
            this.iCustomNote.setVisible(true);
        } else {
            this.iCustomNote.setHTML("");
            this.iCustomNote.setVisible(false);
        }
    }
}

