/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.sectioning;

import com.google.gwt.user.client.Cookies;
import java.util.Date;

public class SectioningStatusCookie {
    private static SectioningStatusCookie sInstance = null;
    private int iOnlineTab = 0;
    private int iBashTab = 0;
    private String iOnlineQuery = "";
    private String iBashQuery = "";
    private int[] iSortBy = new int[]{0, 0, 0, 0, 0, 0};
    private int iStudentTab = 2;
    private String[] iSortByGroup = new String[]{"", ""};
    private boolean iEmailIncludeCourseRequests = false;
    private boolean iEmailIncludeClassSchedule = true;
    private boolean iEmailAdvisorRequests = false;
    private String iEmailSubject = "";
    private String iEmailCC = "";
    private boolean iAdvisorRequestsEmailStudent;
    private Boolean iOptionalEmailToggle = null;

    private SectioningStatusCookie() {
        try {
            String cookie = Cookies.getCookie((String)"UniTime:StudentStatus");
            if (cookie != null) {
                String[] params = cookie.split("\\|");
                int idx = 0;
                this.iOnlineTab = Integer.parseInt(params[idx++]);
                this.iOnlineQuery = params[idx++];
                this.iBashTab = Integer.parseInt(params[idx++]);
                this.iBashQuery = params[idx++];
                for (int i = 0; i < this.iSortBy.length; ++i) {
                    this.iSortBy[i] = Integer.parseInt(params[idx++]);
                }
                this.iStudentTab = Integer.parseInt(params[idx++]);
                this.iSortByGroup[0] = params[idx++];
                this.iSortByGroup[1] = params[idx++];
                this.iEmailIncludeCourseRequests = "1".equals(params[idx++]);
                this.iEmailIncludeClassSchedule = "1".equals(params[idx++]);
                this.iEmailCC = params[idx++];
                this.iEmailSubject = params[idx++];
                this.iEmailAdvisorRequests = "1".equals(params[idx++]);
                this.iAdvisorRequestsEmailStudent = "1".equals(params[idx++]);
                this.iOptionalEmailToggle = SectioningStatusCookie.parseBoolean(params[idx++]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static Boolean parseBoolean(String value) {
        if ("1".equals(value)) {
            return true;
        }
        if ("0".equals(value)) {
            return false;
        }
        return null;
    }

    public static SectioningStatusCookie getInstance() {
        if (sInstance == null) {
            sInstance = new SectioningStatusCookie();
        }
        return sInstance;
    }

    private void save() {
        String cookie = this.iOnlineTab + "|" + this.iOnlineQuery + "|" + this.iBashTab + "|" + this.iBashQuery;
        for (int i = 0; i < this.iSortBy.length; ++i) {
            cookie = cookie + "|" + this.iSortBy[i];
        }
        cookie = cookie + "|" + this.iStudentTab;
        cookie = cookie + "|" + this.iSortByGroup[0] + "|" + this.iSortByGroup[1];
        cookie = cookie + "|" + (this.iEmailIncludeCourseRequests ? "1" : "0") + "|" + (this.iEmailIncludeClassSchedule ? "1" : "0") + "|" + (this.iEmailCC == null ? "" : this.iEmailCC) + "|" + (this.iEmailSubject == null ? "" : this.iEmailSubject) + "|" + (this.iEmailAdvisorRequests ? "1" : "0") + "|" + (this.iAdvisorRequestsEmailStudent ? "1" : "0") + "|" + (this.iOptionalEmailToggle == null ? "N" : (this.iOptionalEmailToggle != false ? "1" : "0"));
        Date expires = new Date(new Date().getTime() + 604800000L);
        Cookies.setCookie((String)"UniTime:StudentStatus", (String)cookie, (Date)expires);
    }

    public String getQuery(boolean online) {
        return online ? this.iOnlineQuery : this.iBashQuery;
    }

    public int getTab(boolean online) {
        return online ? this.iOnlineTab : this.iBashTab;
    }

    public void setQueryTab(boolean online, String query, int tab) {
        if (online) {
            this.iOnlineQuery = query;
            this.iOnlineTab = tab;
        } else {
            this.iBashQuery = query;
            this.iBashTab = tab;
        }
        this.save();
    }

    public int getSortBy(boolean online, int tab) {
        return this.iSortBy[online ? tab : 3 + tab];
    }

    public void setSortBy(boolean online, int tab, int ord) {
        this.iSortBy[online ? tab : 3 + tab] = ord;
        this.save();
    }

    public void setSortBy(boolean online, int tab, int ord, String group) {
        this.iSortBy[online ? tab : 3 + tab] = ord;
        this.iSortByGroup[online ? 0 : 1] = group;
        this.save();
    }

    public String getSortByGroup(boolean online) {
        return this.iSortByGroup[online ? 0 : 1];
    }

    public int getStudentTab() {
        return this.iStudentTab;
    }

    public void setStudentTab(int tab) {
        this.iStudentTab = tab;
        this.save();
    }

    public boolean isEmailIncludeCourseRequests() {
        return this.iEmailIncludeCourseRequests;
    }

    public boolean isEmailIncludeClassSchedule() {
        return this.iEmailIncludeClassSchedule;
    }

    public boolean isEmailIncludeAdvisorRequests() {
        return this.iEmailAdvisorRequests;
    }

    public String getEmailCC() {
        return this.iEmailCC;
    }

    public boolean hasEmailCC() {
        return this.iEmailCC != null && !this.iEmailCC.isEmpty();
    }

    public String getEmailSubject() {
        return this.iEmailSubject;
    }

    public boolean hasEmailSubject() {
        return this.iEmailSubject != null && !this.iEmailSubject.isEmpty();
    }

    public void setEmailDefaults(boolean includeCourseRequests, boolean includeClassSchedule, boolean includeAdvisorRequests, String cc, String subject, Boolean optionalEmailToggle) {
        this.iEmailIncludeCourseRequests = includeCourseRequests;
        this.iEmailIncludeClassSchedule = includeClassSchedule;
        this.iEmailAdvisorRequests = includeAdvisorRequests;
        this.iEmailCC = cc;
        this.iEmailSubject = subject;
        if (optionalEmailToggle != null) {
            this.iOptionalEmailToggle = optionalEmailToggle;
        }
        this.save();
    }

    public void setEmailCC(String cc) {
        this.iEmailCC = cc;
        this.save();
    }

    public boolean isAdvisorRequestsEmailStudent() {
        return this.iAdvisorRequestsEmailStudent;
    }

    public void setAdvisorRequestsEmailStudent(boolean email) {
        this.iAdvisorRequestsEmailStudent = email;
        this.save();
    }

    public boolean isOptionalEmailToggle(boolean defaultValue) {
        return this.iOptionalEmailToggle == null ? defaultValue : this.iOptionalEmailToggle;
    }
}

