/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.sectioning;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.SuggestOracle;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.Map;
import org.unitime.timetable.gwt.client.aria.AriaButton;
import org.unitime.timetable.gwt.client.aria.AriaStatus;
import org.unitime.timetable.gwt.client.aria.AriaSuggestArea;
import org.unitime.timetable.gwt.client.aria.AriaTabBar;
import org.unitime.timetable.gwt.client.aria.AriaTextArea;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.UniTimeDialogBox;
import org.unitime.timetable.gwt.resources.GwtAriaMessages;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningResources;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;

public class CourseRequestsConfirmationDialog
extends UniTimeDialogBox {
    protected static StudentSectioningConstants CONSTANTS = (StudentSectioningConstants)GWT.create(StudentSectioningConstants.class);
    protected static GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    protected static StudentSectioningResources RESOURCES = (StudentSectioningResources)GWT.create(StudentSectioningResources.class);
    protected static StudentSectioningMessages SCT_MESSAGES = (StudentSectioningMessages)GWT.create(StudentSectioningMessages.class);
    protected static GwtAriaMessages ARIA = (GwtAriaMessages)GWT.create(GwtAriaMessages.class);
    private AriaButton iYes;
    private AriaButton iNo;
    private AsyncCallback<Boolean> iCommand;
    private String iMessage;
    private boolean iValue = false;
    private AriaTextArea iNote = null;
    private AriaSuggestArea iNoteSuggestions = null;
    private Image iImage;
    private CheckBox iCheckBox = null;
    private AriaTabBar iCoursesTab = null;
    private P iCoursesTabScroll = null;
    private Map<Integer, CourseRequestInterface.CourseMessage> iCourse2message = null;

    public CourseRequestsConfirmationDialog(CourseRequestInterface.CheckCoursesResponse response, int confirm, AsyncCallback<Boolean> callback) {
        super(true, true);
        this.addStyleName("unitime-CourseRequestsConfirmationDialog");
        this.setText(response.getConfirmationTitle(confirm, MESSAGES.dialogConfirmation()));
        this.iMessage = response.getConfirmations(confirm, " \n");
        this.iCommand = callback;
        P panel = new P("unitime-ConfirmationPanel");
        P bd = new P("body-panel");
        panel.add((Widget)bd);
        P ic = new P("icon-panel");
        bd.add((Widget)ic);
        this.iImage = new Image(RESOURCES.statusWarning());
        ic.add((Widget)this.iImage);
        P cp = new P("content-panel");
        bd.add((Widget)cp);
        P mp = new P("message-panel");
        cp.add((Widget)mp);
        P ctab = null;
        String last = null;
        for (final CourseRequestInterface.CourseMessage cm : response.getMessages()) {
            if (confirm != cm.getConfirm()) continue;
            if (cm.hasCourse() && "REQUEST_NOTE".equals(cm.getCode())) {
                if (this.iCourse2message == null) {
                    this.iCourse2message = new HashMap<Integer, CourseRequestInterface.CourseMessage>();
                    this.iCoursesTab = new AriaTabBar();
                    this.iCoursesTab.addStyleName("notes-tab");
                    this.iCoursesTabScroll = new P("notes-scroll");
                    this.iCoursesTabScroll.add((Widget)this.iCoursesTab);
                    this.iCoursesTabScroll.getElement().getStyle().clearPosition();
                    this.iCoursesTabScroll.getElement().getStyle().clearOverflow();
                    this.iNote = new AriaTextArea();
                    this.iNote.setStyleName("unitime-TextArea");
                    this.iNote.addStyleName("request-notes");
                    this.iNote.setVisibleLines(5);
                    this.iNote.setCharacterWidth(80);
                    this.iNote.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

                        public void onValueChange(ValueChangeEvent<String> event) {
                            CourseRequestInterface.CourseMessage message = (CourseRequestInterface.CourseMessage)CourseRequestsConfirmationDialog.this.iCourse2message.get(CourseRequestsConfirmationDialog.this.iCoursesTab.getSelectedTab());
                            message.setMessage((String)event.getValue());
                        }
                    });
                    this.iNote.addKeyDownHandler(new KeyDownHandler(){

                        public void onKeyDown(KeyDownEvent event) {
                            if (CourseRequestsConfirmationDialog.this.iNoteSuggestions.isSuggestionListShowing()) {
                                return;
                            }
                            if (event.getNativeEvent().getKeyCode() == 9 && event.getNativeEvent().getShiftKey()) {
                                if (CourseRequestsConfirmationDialog.this.iCoursesTab.getSelectedTab() > 0) {
                                    ((CourseRequestInterface.CourseMessage)CourseRequestsConfirmationDialog.this.iCourse2message.get(CourseRequestsConfirmationDialog.this.iCoursesTab.getSelectedTab())).setMessage(CourseRequestsConfirmationDialog.this.iNote.getText());
                                    CourseRequestsConfirmationDialog.this.iCoursesTab.selectTab(CourseRequestsConfirmationDialog.this.iCoursesTab.getSelectedTab() - 1, true);
                                    event.preventDefault();
                                }
                            } else if (event.getNativeEvent().getKeyCode() == 9 && CourseRequestsConfirmationDialog.this.iCoursesTab.getSelectedTab() + 1 < CourseRequestsConfirmationDialog.this.iCoursesTab.getTabCount()) {
                                ((CourseRequestInterface.CourseMessage)CourseRequestsConfirmationDialog.this.iCourse2message.get(CourseRequestsConfirmationDialog.this.iCoursesTab.getSelectedTab())).setMessage(CourseRequestsConfirmationDialog.this.iNote.getText());
                                CourseRequestsConfirmationDialog.this.iCoursesTab.selectTab(CourseRequestsConfirmationDialog.this.iCoursesTab.getSelectedTab() + 1, true);
                                event.preventDefault();
                            }
                        }
                    });
                    this.iNoteSuggestions = new AriaSuggestArea(this.iNote, cm.getSuggestions());
                    this.iNoteSuggestions.addStyleName("request-note");
                    this.iNoteSuggestions.setTabPreventDefault(true);
                    this.iNoteSuggestions.addSelectionHandler(new SelectionHandler<SuggestOracle.Suggestion>(){

                        public void onSelection(SelectionEvent<SuggestOracle.Suggestion> event) {
                            CourseRequestInterface.CourseMessage message = (CourseRequestInterface.CourseMessage)CourseRequestsConfirmationDialog.this.iCourse2message.get(CourseRequestsConfirmationDialog.this.iCoursesTab.getSelectedTab());
                            message.setMessage(((SuggestOracle.Suggestion)event.getSelectedItem()).getReplacementString());
                            String text = CourseRequestsConfirmationDialog.this.iNote.getText();
                            if (text.indexOf(60) >= 0 && text.indexOf(62) > text.indexOf(60)) {
                                CourseRequestsConfirmationDialog.this.iNote.setSelectionRange(text.indexOf(60), text.indexOf(62) - text.indexOf(60) + 1);
                            }
                        }
                    });
                    this.iCoursesTab.addSelectionHandler((SelectionHandler)new SelectionHandler<Integer>(){

                        public void onSelection(SelectionEvent<Integer> event) {
                            CourseRequestsConfirmationDialog.this.iCoursesTab.getTabElement((Integer)event.getSelectedItem()).scrollIntoView();
                            CourseRequestInterface.CourseMessage message = (CourseRequestInterface.CourseMessage)CourseRequestsConfirmationDialog.this.iCourse2message.get(event.getSelectedItem());
                            boolean show = CourseRequestsConfirmationDialog.this.iNoteSuggestions.isSuggestionListShowing();
                            if (show) {
                                CourseRequestsConfirmationDialog.this.iNoteSuggestions.hideSuggestionList();
                            }
                            CourseRequestsConfirmationDialog.this.iNoteSuggestions.setSuggestions(message.getSuggestions());
                            CourseRequestsConfirmationDialog.this.iNote.setText(message.getMessage() == null ? "" : message.getMessage());
                            if (show) {
                                CourseRequestsConfirmationDialog.this.iNoteSuggestions.showSuggestions(CourseRequestsConfirmationDialog.this.iNote.getText());
                            }
                            CourseRequestsConfirmationDialog.this.iNote.setAriaLabel(ARIA.requestNoteFor(message.getCourse()));
                            AriaStatus.getInstance().setHTML(ARIA.requestNoteFor(message.getCourse()));
                        }
                    });
                    if (cm.getMessage() != null) {
                        this.iNote.setText(cm.getMessage());
                    }
                    mp.add((Widget)this.iCoursesTabScroll);
                    mp.add((Widget)this.iNoteSuggestions);
                }
                this.iCourse2message.put(this.iCourse2message.size(), cm);
                this.iCoursesTab.addTab(cm.getCourse());
                if (this.iCourse2message.size() != 1) continue;
                this.iCoursesTab.selectTab(0);
                continue;
            }
            if (cm.hasCourse()) {
                if (ctab == null) {
                    ctab = new P("course-table");
                    last = null;
                }
                P cn = new P("course-name");
                if (last == null || !last.equals(cm.getCourse())) {
                    cn.setText(cm.getCourse());
                }
                P m = new P("course-message");
                m.setText(SCT_MESSAGES.courseMessage(cm.getMessage()));
                P crow = new P("course-row");
                if (last == null || !last.equals(cm.getCourse())) {
                    crow.addStyleName("first-course-line");
                }
                crow.add((Widget)cn);
                crow.add((Widget)m);
                ctab.add((Widget)crow);
                last = cm.getCourse();
                continue;
            }
            if ("REQUEST_NOTE".equals(cm.getCode())) {
                this.iNote = new AriaTextArea();
                this.iNote.setStyleName("unitime-TextArea");
                this.iNote.addStyleName("request-note");
                this.iNote.setVisibleLines(5);
                this.iNote.setCharacterWidth(80);
                if (cm.getMessage() != null) {
                    this.iNote.setText(cm.getMessage());
                }
                this.iNote.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

                    public void onValueChange(ValueChangeEvent<String> event) {
                        cm.setMessage((String)event.getValue());
                    }
                });
                if (cm.hasSuggestions()) {
                    this.iNoteSuggestions = new AriaSuggestArea(this.iNote, cm.getSuggestions());
                    this.iNoteSuggestions.addStyleName("request-note");
                    this.iNoteSuggestions.addSelectionHandler(new SelectionHandler<SuggestOracle.Suggestion>(){

                        public void onSelection(SelectionEvent<SuggestOracle.Suggestion> event) {
                            cm.setMessage(((SuggestOracle.Suggestion)event.getSelectedItem()).getReplacementString());
                            String text = CourseRequestsConfirmationDialog.this.iNote.getText();
                            if (text.indexOf(60) >= 0 && text.indexOf(62) > text.indexOf(60)) {
                                CourseRequestsConfirmationDialog.this.iNote.setSelectionRange(text.indexOf(60), text.indexOf(62) - text.indexOf(60) + 1);
                            }
                        }
                    });
                    mp.add((Widget)this.iNoteSuggestions);
                    continue;
                }
                mp.add((Widget)this.iNote);
                continue;
            }
            if ("CHECK_BOX".equals(cm.getCode())) {
                if (ctab != null) {
                    mp.add((Widget)ctab);
                    ctab = null;
                }
                this.iCheckBox = new CheckBox(cm.getMessage());
                this.iCheckBox.addStyleName("message");
                mp.add((Widget)this.iCheckBox);
                continue;
            }
            if (ctab != null) {
                mp.add((Widget)ctab);
                ctab = null;
            }
            P m = new P("message");
            m.setHTML(cm.getMessage());
            mp.add((Widget)m);
        }
        if (ctab != null) {
            mp.add((Widget)ctab);
            ctab = null;
        }
        P bp = new P("buttons-panel");
        panel.add((Widget)bp);
        this.iYes = new AriaButton(response.getConfirmationYesButton(confirm, MESSAGES.buttonConfirmYes()));
        this.iYes.addStyleName("yes");
        String yesTitle = response.getConfirmationYesButtonTitle(confirm, null);
        if (yesTitle != null && !yesTitle.isEmpty()) {
            this.iYes.setTitle(yesTitle);
        }
        bp.add((Widget)this.iYes);
        this.iYes.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                CourseRequestsConfirmationDialog.this.submit();
            }
        });
        if (this.iCheckBox != null) {
            this.iYes.setEnabled(false);
            this.iCheckBox.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                public void onValueChange(ValueChangeEvent<Boolean> event) {
                    CourseRequestsConfirmationDialog.this.iYes.setEnabled((Boolean)event.getValue());
                }
            });
        }
        this.iNo = new AriaButton(response.getConfirmationNoButton(confirm, MESSAGES.buttonConfirmNo()));
        this.iNo.addStyleName("no");
        String noTitle = response.getConfirmationNoButtonTitle(confirm, null);
        if (noTitle != null && !noTitle.isEmpty()) {
            this.iNo.setTitle(noTitle);
        }
        bp.add((Widget)this.iNo);
        this.iNo.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                CourseRequestsConfirmationDialog.this.hide();
            }
        });
        this.addCloseHandler((CloseHandler)new CloseHandler<PopupPanel>(){

            public void onClose(CloseEvent<PopupPanel> event) {
                if (CourseRequestsConfirmationDialog.this.iCommand != null) {
                    Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                        public void execute() {
                            CourseRequestsConfirmationDialog.this.iCommand.onSuccess((Object)CourseRequestsConfirmationDialog.this.iValue);
                        }
                    });
                }
            }
        });
        this.setWidget((Widget)panel);
    }

    public CourseRequestsConfirmationDialog withImage(ImageResource image) {
        if (image != null) {
            this.iImage.setResource(image);
        }
        return this;
    }

    @Override
    public void center() {
        super.center();
        if (this.iMessage != null && !this.iMessage.isEmpty()) {
            AriaStatus.getInstance().setText(ARIA.dialogOpened(this.getText()) + " " + this.iMessage + " " + ARIA.confirmationEnterToAcceptEscapeToReject());
        }
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                if (CourseRequestsConfirmationDialog.this.iNote != null) {
                    CourseRequestsConfirmationDialog.this.iNote.setFocus(true);
                } else {
                    CourseRequestsConfirmationDialog.this.iYes.setFocus(true);
                }
            }
        });
    }

    protected void submit() {
        this.iValue = true;
        this.hide();
    }

    public String getNote() {
        return this.iNote == null ? null : this.iNote.getText();
    }

    public static void confirm(CourseRequestInterface.CheckCoursesResponse response, int confirm, AsyncCallback<Boolean> callback) {
        new CourseRequestsConfirmationDialog(response, confirm, callback).center();
    }

    public static void confirm(CourseRequestInterface.CheckCoursesResponse response, int confirm, ImageResource image, AsyncCallback<Boolean> callback) {
        new CourseRequestsConfirmationDialog(response, confirm, callback).withImage(image).center();
    }
}

