/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.rooms;

import java.util.Comparator;
import java.util.Iterator;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.gwt.shared.RoomInterface;

public class RoomGroupsComparator
implements Comparator<RoomInterface.GroupInterface> {
    private RoomInterface.RoomGroupsColumn iColumn;
    private boolean iAsc;

    public RoomGroupsComparator(RoomInterface.RoomGroupsColumn column, boolean asc) {
        this.iColumn = column;
        this.iAsc = asc;
    }

    public int compareById(RoomInterface.GroupInterface r1, RoomInterface.GroupInterface r2) {
        return this.compare(r1.getId(), r2.getId());
    }

    public int compareByName(RoomInterface.GroupInterface r1, RoomInterface.GroupInterface r2) {
        return this.compare(r1.getLabel(), r2.getLabel());
    }

    public int compareByAbbreviation(RoomInterface.GroupInterface r1, RoomInterface.GroupInterface r2) {
        return this.compare(r1.getAbbreviation(), r2.getAbbreviation());
    }

    public int compareByDefault(RoomInterface.GroupInterface r1, RoomInterface.GroupInterface r2) {
        return this.compare(r1.isDefault(), r2.isDefault());
    }

    public int compareByDepartment(RoomInterface.GroupInterface r1, RoomInterface.GroupInterface r2) {
        return this.compare(r1.getDepartment() == null ? null : r1.getDepartment().getExtAbbreviationWhenExist(), r2.getDepartment() == null ? null : r2.getDepartment().getExtAbbreviationWhenExist());
    }

    public int compareByDescription(RoomInterface.GroupInterface r1, RoomInterface.GroupInterface r2) {
        return this.compare(r1.getDescription(), r2.getDescription());
    }

    public int compareByRooms(RoomInterface.GroupInterface r1, RoomInterface.GroupInterface r2) {
        if (r1.hasRooms()) {
            if (r2.hasRooms()) {
                Iterator<EventInterface.FilterRpcResponse.Entity> i1 = r1.getRooms().iterator();
                Iterator<EventInterface.FilterRpcResponse.Entity> i2 = r2.getRooms().iterator();
                while (i1.hasNext() && i2.hasNext()) {
                    int cmp = this.compare(i1.next().getName(), i2.next().getName());
                    if (cmp == 0) continue;
                    return cmp;
                }
                if (i1.hasNext()) {
                    return i2.hasNext() ? 0 : 1;
                }
                return i2.hasNext() ? -1 : 0;
            }
            return 1;
        }
        return r2.hasRooms() ? -1 : 0;
    }

    protected int compareByColumn(RoomInterface.GroupInterface r1, RoomInterface.GroupInterface r2) {
        switch (this.iColumn) {
            case NAME: {
                return this.compareByName(r1, r2);
            }
            case ABBREVIATION: {
                return this.compareByAbbreviation(r1, r2);
            }
            case DEFAULT: {
                return this.compareByDefault(r1, r2);
            }
            case DEPARTMENT: {
                return this.compareByDepartment(r1, r2);
            }
            case DESCRIPTION: {
                return this.compareByDescription(r1, r2);
            }
            case ROOMS: {
                return this.compareByRooms(r1, r2);
            }
        }
        return this.compareByName(r1, r2);
    }

    public static boolean isApplicable(RoomInterface.RoomGroupsColumn column) {
        switch (column) {
            case NAME: 
            case ABBREVIATION: 
            case DEFAULT: 
            case DEPARTMENT: 
            case DESCRIPTION: 
            case ROOMS: {
                return true;
            }
        }
        return false;
    }

    @Override
    public int compare(RoomInterface.GroupInterface r1, RoomInterface.GroupInterface r2) {
        int cmp = this.compareByColumn(r1, r2);
        if (cmp == 0) {
            cmp = this.compareByName(r1, r2);
        }
        if (cmp == 0) {
            cmp = this.compareById(r1, r2);
        }
        return this.iAsc ? cmp : -cmp;
    }

    @Override
    protected int compare(String s1, String s2) {
        if (s1 == null || s1.isEmpty()) {
            return s2 == null || s2.isEmpty() ? 0 : 1;
        }
        return s2 == null || s2.isEmpty() ? -1 : s1.compareToIgnoreCase(s2);
    }

    @Override
    protected int compare(Number n1, Number n2) {
        return n1 == null ? (n2 == null ? 0 : -1) : (n2 == null ? 1 : Double.compare(n1.doubleValue(), n2.doubleValue()));
    }

    @Override
    protected int compare(Boolean b1, Boolean b2) {
        return b1 == null ? (b2 == null ? 0 : -1) : (b2 == null ? 1 : (b1.booleanValue() == b2.booleanValue() ? 0 : (b1 != false ? 1 : -1)));
    }
}

