/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.rooms;

import com.google.gwt.aria.client.Roles;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.http.client.URL;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.TakesValue;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.MenuItem;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.unitime.timetable.gwt.client.Client;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.aria.AriaButton;
import org.unitime.timetable.gwt.client.events.AcademicSessionSelectionBox;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.page.UniTimePageHeader;
import org.unitime.timetable.gwt.client.page.UniTimePageLabel;
import org.unitime.timetable.gwt.client.rooms.RoomCookie;
import org.unitime.timetable.gwt.client.rooms.RoomFeatureEdit;
import org.unitime.timetable.gwt.client.rooms.RoomFeaturesComparator;
import org.unitime.timetable.gwt.client.rooms.RoomFeaturesTable;
import org.unitime.timetable.gwt.client.rooms.RoomFilterBox;
import org.unitime.timetable.gwt.client.rooms.RoomHint;
import org.unitime.timetable.gwt.client.rooms.RoomsPage;
import org.unitime.timetable.gwt.client.rooms.RoomsTable;
import org.unitime.timetable.gwt.client.widgets.FilterBox;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.client.widgets.UniTimeTableHeader;
import org.unitime.timetable.gwt.command.client.GwtRpcResponse;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.GwtResources;
import org.unitime.timetable.gwt.shared.AcademicSessionProvider;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.gwt.shared.RoomInterface;

public class RoomFeaturesPage
extends Composite {
    protected static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    protected static final GwtResources RESOURCES = (GwtResources)GWT.create(GwtResources.class);
    protected static final GwtConstants CONSTANTS = (GwtConstants)GWT.create(GwtConstants.class);
    protected static GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private AcademicSessionProvider iSession = null;
    private RoomFilterBox iFilter = null;
    private AriaButton iSearch = null;
    private AriaButton iNew = null;
    private AriaButton iMore = null;
    private SimpleForm iFeaturesPanel = null;
    private SimplePanel iRootPanel;
    private SimplePanel iPanel = null;
    private HorizontalPanel iFilterPanel = null;
    private RoomInterface.RoomPropertiesInterface iProperties = null;
    private UniTimeHeaderPanel iGlobalFeaturesHeader = null;
    private RoomFeaturesTable iGlobalFeaturesTable = null;
    private int iGlobalFeaturesRow = -1;
    private UniTimeHeaderPanel iDepartmentalFeaturesHeader = null;
    private RoomFeaturesTable iDepartmentalFeaturesTable = null;
    private int iDepartmentalFeaturesRow = -1;
    private RoomInterface.RoomsPageMode iMode = RoomInterface.RoomsPageMode.COURSES;
    private UniTimeHeaderPanel iHeaderPanel = null;
    private RoomsPage.HistoryToken iHistoryToken = null;
    private RoomFeatureEdit iRoomFeatureEdit = null;
    private boolean iInitialized = false;

    public RoomFeaturesPage() {
        if (Window.Location.getParameter((String)"mode") != null) {
            this.iMode = RoomInterface.RoomsPageMode.valueOf(Window.Location.getParameter((String)"mode").toUpperCase());
        }
        this.iHistoryToken = new RoomsPage.HistoryToken(this.iMode);
        this.iPanel = new SimplePanel();
        this.iFeaturesPanel = new SimpleForm();
        this.iFeaturesPanel.setWidth("100%");
        ClickHandler clickSearch = new ClickHandler(){

            public void onClick(ClickEvent event) {
                RoomFeaturesPage.this.changeUrl();
                RoomFeaturesPage.this.search(null);
            }
        };
        ClickHandler clickMore = new ClickHandler(){

            public void onClick(ClickEvent event) {
                final PopupPanel popup = new PopupPanel(true);
                UniTimeTableHeader.MenuBarWithAccessKeys menu = new UniTimeTableHeader.MenuBarWithAccessKeys();
                if (RoomFeaturesPage.this.iProperties != null && RoomFeaturesPage.this.iProperties.isCanSaveFilterDefaults()) {
                    MenuItem item = new MenuItem(MESSAGES.buttonClear(), true, (Scheduler.ScheduledCommand)new Command(){

                        public void execute() {
                            popup.hide();
                            RoomFeaturesPage.this.iFilter.setValue(RoomFeaturesPage.this.iHistoryToken.getDefaultParameter("q", ""), true);
                            RoomFeaturesPage.this.hideResults();
                            RoomFeaturesPage.this.changeUrl();
                        }
                    });
                    Roles.getMenuitemRole().setAriaLabelProperty((Element)item.getElement(), UniTimeHeaderPanel.stripAccessKey(MESSAGES.buttonClear()));
                    menu.addItem(item);
                    menu.addSeparator();
                }
                MenuBar sortItems = new MenuBar(true);
                for (final RoomInterface.RoomFeaturesColumn column : RoomInterface.RoomFeaturesColumn.values()) {
                    if (!RoomFeaturesComparator.isApplicable(column) || (RoomFeaturesPage.this.iGlobalFeaturesTable.getRowCount() <= 1 || RoomFeaturesPage.this.iGlobalFeaturesTable.getNbrCells(column) == 0) && (RoomFeaturesPage.this.iDepartmentalFeaturesTable.getRowCount() <= 1 || RoomFeaturesPage.this.iDepartmentalFeaturesTable.getNbrCells(column) == 0)) continue;
                    String name = RoomFeaturesPage.this.iGlobalFeaturesTable.getColumnName(column, 0).replace("<br>", " ");
                    MenuItem item = new MenuItem(name, true, (Scheduler.ScheduledCommand)new Command(){

                        public void execute() {
                            popup.hide();
                            int sortBy = RoomCookie.getInstance().getRoomFeaturesSortBy();
                            sortBy = sortBy == 1 + column.ordinal() || sortBy == -1 - column.ordinal() ? -sortBy : 1 + column.ordinal();
                            RoomCookie.getInstance().setSortRoomFeaturesBy(sortBy);
                            RoomFeaturesPage.this.iGlobalFeaturesTable.setSortBy(sortBy);
                            RoomFeaturesPage.this.iDepartmentalFeaturesTable.setSortBy(sortBy);
                        }
                    });
                    Roles.getMenuitemRole().setAriaLabelProperty((Element)item.getElement(), UniTimeHeaderPanel.stripAccessKey(MESSAGES.opSortBy(name)));
                    sortItems.addItem(item);
                }
                MenuItem sortMenu = new MenuItem(MESSAGES.opSort(), sortItems);
                sortMenu.getElement().getStyle().setCursor(Style.Cursor.POINTER);
                menu.addItem(sortMenu);
                MenuBar deptItems = new MenuBar(true);
                for (final RoomsTable.DeptMode d : RoomsTable.DeptMode.values()) {
                    String name = RoomCookie.getInstance().getDeptMode() == d.ordinal() ? MESSAGES.opUncheck(d.getName()) : MESSAGES.opCheck(d.getName());
                    MenuItem item = new MenuItem(name, true, (Scheduler.ScheduledCommand)new Command(){

                        public void execute() {
                            popup.hide();
                            RoomCookie.getInstance().setDeptMode(d.ordinal());
                            RoomFeaturesPage.this.iGlobalFeaturesTable.refreshTable();
                            RoomFeaturesPage.this.iDepartmentalFeaturesTable.refreshTable();
                        }
                    });
                    Roles.getMenuitemRole().setAriaLabelProperty((Element)item.getElement(), d.getName());
                    deptItems.addItem(item);
                }
                MenuItem deptMenu = new MenuItem(MESSAGES.opDepartmentFormat(), deptItems);
                deptMenu.getElement().getStyle().setCursor(Style.Cursor.POINTER);
                menu.addItem(deptMenu);
                if (RoomFeaturesPage.this.iProperties.isCanExportRoomFeatures()) {
                    menu.addSeparator();
                    MenuItem exportPdf = new MenuItem(MESSAGES.opExportPDF(), true, (Scheduler.ScheduledCommand)new Command(){

                        public void execute() {
                            popup.hide();
                            RoomFeaturesPage.this.export("roomfeatures.pdf");
                        }
                    });
                    Roles.getMenuitemRole().setAriaLabelProperty((Element)exportPdf.getElement(), MESSAGES.opExportPDF());
                    menu.addItem(exportPdf);
                    MenuItem exportCsv = new MenuItem(MESSAGES.opExportCSV(), true, (Scheduler.ScheduledCommand)new Command(){

                        public void execute() {
                            popup.hide();
                            RoomFeaturesPage.this.export("roomfeatures.csv");
                        }
                    });
                    Roles.getMenuitemRole().setAriaLabelProperty((Element)exportCsv.getElement(), MESSAGES.opExportCSV());
                    menu.addItem(exportCsv);
                }
                popup.add((Widget)menu);
                popup.showRelativeTo((UIObject)event.getSource());
                menu.focus();
            }
        };
        ClickHandler clickNew = new ClickHandler(){

            public void onClick(ClickEvent event) {
                RoomFeaturesPage.this.edit(null);
            }
        };
        this.iRoomFeatureEdit = new RoomFeatureEdit(this.iMode){

            @Override
            protected void onShow() {
                RoomHint.hideHint();
                RoomFeaturesPage.this.iRootPanel.setWidget((Widget)RoomFeaturesPage.this.iRoomFeatureEdit);
                RoomFeaturesPage.this.changeUrl();
            }

            @Override
            protected void onHide(boolean refresh, RoomInterface.FeatureInterface feature) {
                RoomFeaturesPage.this.iRootPanel.setWidget((Widget)RoomFeaturesPage.this.iFeaturesPanel);
                UniTimePageLabel.getInstance().setPageName(MESSAGES.pageRoomFeatures());
                RoomFeaturesPage.this.changeUrl();
                if (refresh && (RoomFeaturesPage.this.iFeaturesPanel.getRowFormatter().isVisible(RoomFeaturesPage.this.iGlobalFeaturesRow) || RoomFeaturesPage.this.iFeaturesPanel.getRowFormatter().isVisible(RoomFeaturesPage.this.iDepartmentalFeaturesRow))) {
                    RoomFeaturesPage.this.search(feature == null ? null : feature.getId());
                }
            }
        };
        if (this.iMode.hasSessionSelection()) {
            this.iHeaderPanel = new UniTimeHeaderPanel(MESSAGES.sectFilter());
            this.iFeaturesPanel.addHeaderRow((Widget)this.iHeaderPanel);
            this.iSession = new AcademicSessionSelectionBox(this.iHistoryToken.getParameter("term"), "RoomFeatures"){

                @Override
                protected void onInitializationSuccess(List<AcademicSessionSelectionBox.AcademicSession> sessions) {
                    UniTimePageHeader.getInstance().getRight().setVisible(false);
                    UniTimePageHeader.getInstance().getRight().setPreventDefault(true);
                    RoomFeaturesPage.this.setup(this.getAcademicSessionId(), CONSTANTS.searchWhenPageIsLoaded() && (RoomFeaturesPage.this.iHistoryToken.hasParameter("id") || RoomFeaturesPage.this.iHistoryToken.hasParameter("q")));
                }

                @Override
                protected void onInitializationFailure(Throwable caught) {
                    UniTimeNotifications.error(MESSAGES.failedLoadSessions(caught.getMessage()), caught);
                }
            };
            this.iSession.addAcademicSessionChangeHandler(new AcademicSessionProvider.AcademicSessionChangeHandler(){

                @Override
                public void onAcademicSessionChange(AcademicSessionProvider.AcademicSessionChangeEvent event) {
                    RoomFeaturesPage.this.setup(event.getNewAcademicSessionId(), RoomFeaturesPage.this.iDepartmentalFeaturesTable.getRowCount() > 1 || RoomFeaturesPage.this.iGlobalFeaturesTable.getRowCount() > 1);
                }
            });
            this.iFeaturesPanel.addRow(MESSAGES.propAcademicSession(), (Widget)this.iSession);
            this.iFilter = new RoomFilterBox(this.iSession);
            this.iFeaturesPanel.addRow(MESSAGES.propRoomFilter(), (Widget)this.iFilter);
            this.iHeaderPanel.addButton("search", MESSAGES.buttonSearch(), clickSearch);
            this.iHeaderPanel.addButton("more", MESSAGES.buttonMoreOperations(), clickMore);
            this.iHeaderPanel.addButton("new", MESSAGES.buttonAddNewRoom(), clickNew);
            this.iHeaderPanel.setEnabled("more", false);
            this.iHeaderPanel.setEnabled("new", false);
        } else {
            this.iFilterPanel = new HorizontalPanel();
            this.iFilterPanel.setSpacing(3);
            Label filterLabel = new Label(MESSAGES.propFilter());
            this.iFilterPanel.add((Widget)filterLabel);
            this.iFilterPanel.setCellVerticalAlignment((Widget)filterLabel, HasVerticalAlignment.ALIGN_MIDDLE);
            this.iSession = new Session();
            this.iFilter = new RoomFilterBox(this.iSession);
            this.iFilterPanel.add((Widget)this.iFilter);
            this.iSearch = new AriaButton(MESSAGES.buttonSearch());
            this.iSearch.addStyleName("unitime-NoPrint");
            this.iSearch.addClickHandler(clickSearch);
            this.iFilterPanel.add((Widget)this.iSearch);
            this.iMore = new AriaButton(MESSAGES.buttonMoreOperations());
            this.iMore.setEnabled(false);
            this.iMore.addStyleName("unitime-NoPrint");
            this.iMore.addClickHandler(clickMore);
            this.iFilterPanel.add((Widget)this.iMore);
            this.iNew = new AriaButton(MESSAGES.buttonAddNewRoomFeature());
            this.iNew.setEnabled(false);
            this.iNew.addStyleName("unitime-NoPrint");
            this.iNew.addClickHandler(clickNew);
            this.iFilterPanel.add((Widget)this.iNew);
            int filterRow = this.iFeaturesPanel.addRow((Widget)this.iFilterPanel);
            this.iFeaturesPanel.getCellFormatter().setHorizontalAlignment(filterRow, 0, HasHorizontalAlignment.ALIGN_CENTER);
            this.setup(null, CONSTANTS.searchWhenPageIsLoaded() && (this.iHistoryToken.hasParameter("id") || this.iHistoryToken.hasParameter("q")));
        }
        this.iGlobalFeaturesHeader = new UniTimeHeaderPanel(MESSAGES.headerGlobalRoomFeatures());
        this.iGlobalFeaturesRow = this.iFeaturesPanel.addHeaderRow((Widget)this.iGlobalFeaturesHeader);
        this.iGlobalFeaturesTable = new RoomFeaturesTable(true){

            @Override
            protected void doSort(RoomInterface.RoomFeaturesColumn column) {
                super.doSort(column);
                RoomFeaturesPage.this.iDepartmentalFeaturesTable.setSortBy(RoomCookie.getInstance().getRoomFeaturesSortBy());
            }
        };
        this.iFeaturesPanel.addRow((Widget)this.iGlobalFeaturesTable);
        this.iFeaturesPanel.getRowFormatter().setVisible(this.iGlobalFeaturesRow, false);
        this.iFeaturesPanel.getRowFormatter().setVisible(this.iGlobalFeaturesRow + 1, false);
        this.iDepartmentalFeaturesHeader = new UniTimeHeaderPanel(MESSAGES.headerDepartmentalRoomFeatures());
        this.iDepartmentalFeaturesRow = this.iFeaturesPanel.addHeaderRow((Widget)this.iDepartmentalFeaturesHeader);
        this.iDepartmentalFeaturesTable = new RoomFeaturesTable(false){

            @Override
            protected void doSort(RoomInterface.RoomFeaturesColumn column) {
                super.doSort(column);
                RoomFeaturesPage.this.iGlobalFeaturesTable.setSortBy(RoomCookie.getInstance().getRoomFeaturesSortBy());
            }
        };
        this.iFeaturesPanel.addRow((Widget)this.iDepartmentalFeaturesTable);
        this.iFeaturesPanel.getRowFormatter().setVisible(this.iDepartmentalFeaturesRow, false);
        this.iFeaturesPanel.getRowFormatter().setVisible(this.iDepartmentalFeaturesRow + 1, false);
        this.iRootPanel = new SimplePanel((Widget)this.iFeaturesPanel);
        this.iPanel.setWidget((Widget)this.iRootPanel);
        this.iGlobalFeaturesTable.addMouseClickListener(new UniTimeTable.MouseClickListener<RoomInterface.FeatureInterface>(){

            @Override
            public void onMouseClick(UniTimeTable.TableEvent<RoomInterface.FeatureInterface> event) {
                if (event.getData() != null && (event.getData().canEdit() || event.getData().canDelete())) {
                    RoomFeaturesPage.this.edit(event.getData());
                }
            }
        });
        this.iDepartmentalFeaturesTable.addMouseClickListener(new UniTimeTable.MouseClickListener<RoomInterface.FeatureInterface>(){

            @Override
            public void onMouseClick(UniTimeTable.TableEvent<RoomInterface.FeatureInterface> event) {
                if (event.getData() != null && (event.getData().canEdit() || event.getData().canDelete())) {
                    RoomFeaturesPage.this.edit(event.getData());
                }
            }
        });
        this.initWidget((Widget)this.iPanel);
        History.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                if (!RoomFeaturesPage.this.iInitialized) {
                    return;
                }
                RoomFeaturesPage.this.iHistoryToken.reset((String)event.getValue());
                RoomFeaturesPage.this.updateFilter(RoomFeaturesPage.this.iFeaturesPanel.getRowFormatter().isVisible(RoomFeaturesPage.this.iGlobalFeaturesRow) || RoomFeaturesPage.this.iFeaturesPanel.getRowFormatter().isVisible(RoomFeaturesPage.this.iDepartmentalFeaturesRow));
            }
        });
    }

    private void edit(RoomInterface.FeatureInterface feature) {
        if (this.iRoomFeatureEdit == null) {
            return;
        }
        FilterBox.Chip dept = this.iFilter.getChip("department");
        this.iRoomFeatureEdit.setFeature(feature, dept == null ? null : dept.getValue());
        LoadingWidget.execute(this.iFilter.getElementsRequest(), new AsyncCallback<EventInterface.FilterRpcResponse>(){

            public void onFailure(Throwable caught) {
                RoomFeaturesPage.this.iFilter.setErrorHint(MESSAGES.failedToLoadRooms(caught.getMessage()));
                UniTimeNotifications.error(MESSAGES.failedToLoadRooms(caught.getMessage()), caught);
            }

            public void onSuccess(EventInterface.FilterRpcResponse result) {
                RoomFeaturesPage.this.iFilter.clearHint();
                if (result == null || result.getResults() == null || result.getResults().isEmpty()) {
                    RoomFeaturesPage.this.iFilter.setErrorHint(MESSAGES.errorNoRoomsMatchingFilter());
                } else {
                    RoomFeaturesPage.this.iRoomFeatureEdit.setRooms(result.getResults());
                    RoomFeaturesPage.this.iRoomFeatureEdit.show();
                }
            }
        }, MESSAGES.waitLoadingRooms());
    }

    protected void setup(final Long sessionId, final boolean search) {
        LoadingWidget.getInstance().show(MESSAGES.waitLoadingPage());
        RPC.execute(new RoomInterface.RoomPropertiesRequest(sessionId, this.iMode.name()), new AsyncCallback<RoomInterface.RoomPropertiesInterface>(){

            public void onFailure(Throwable caught) {
                LoadingWidget.getInstance().hide();
                RoomFeaturesPage.this.iFilter.setErrorHint(MESSAGES.failedToInitialize(caught.getMessage()));
                UniTimeNotifications.error(MESSAGES.failedToInitialize(caught.getMessage()), caught);
                ToolBox.checkAccess(caught);
            }

            public void onSuccess(RoomInterface.RoomPropertiesInterface result) {
                LoadingWidget.getInstance().hide();
                RoomFeaturesPage.this.iProperties = result;
                RoomFeaturesPage.this.iRoomFeatureEdit.setProperties(RoomFeaturesPage.this.iProperties);
                if (RoomFeaturesPage.this.iProperties.isCanSaveFilterDefaults()) {
                    RoomFeaturesPage.this.iHistoryToken.setDefaultParameter("q", result.getFilterDefault("filter"));
                    RoomFeaturesPage.this.iFilter.setDefaultValueProvider(new TakesValue<String>(){

                        public void setValue(final String value) {
                            RPC.execute(new EventInterface.SaveFilterDefaultRpcRequest(RoomFeaturesPage.this.iMode.name() + ".filter", RoomFeaturesPage.this.iFilter.getValue()), new AsyncCallback<GwtRpcResponse>(){

                                public void onFailure(Throwable caught) {
                                    UniTimeNotifications.error(MESSAGES.failedSaveAsDefault(caught.getMessage()), caught);
                                }

                                public void onSuccess(GwtRpcResponse result) {
                                    RoomFeaturesPage.this.iHistoryToken.setDefaultParameter("q", value);
                                }
                            });
                        }

                        public String getValue() {
                            return RoomFeaturesPage.this.iHistoryToken.getDefaultParameter("q", "");
                        }
                    });
                } else {
                    if (result.hasFilterDefault("filter")) {
                        RoomFeaturesPage.this.iHistoryToken.setDefaultParameter("q", result.getFilterDefault("filter"));
                    }
                    RoomFeaturesPage.this.iFilter.setDefaultValueProvider(null);
                }
                if (RoomFeaturesPage.this.iSession instanceof Session) {
                    ((Session)RoomFeaturesPage.this.iSession).fireChange();
                }
                if (RoomFeaturesPage.this.iNew != null) {
                    RoomFeaturesPage.this.iNew.setEnabled(RoomFeaturesPage.this.iProperties.isCanAddDepartmentalRoomFeature() || RoomFeaturesPage.this.iProperties.isCanAddGlobalRoomFeature());
                }
                if (RoomFeaturesPage.this.iHeaderPanel != null) {
                    RoomFeaturesPage.this.iHeaderPanel.setEnabled("new", RoomFeaturesPage.this.iProperties.isCanAddDepartmentalRoomFeature() || RoomFeaturesPage.this.iProperties.isCanAddGlobalRoomFeature());
                }
                if (sessionId != null && RoomFeaturesPage.this.iSession instanceof AcademicSessionSelectionBox) {
                    RoomFeaturesPage.this.iHistoryToken.setParameter("term", ((AcademicSessionSelectionBox)RoomFeaturesPage.this.iSession).getAcademicSessionAbbreviation());
                    RoomFeaturesPage.this.iHistoryToken.mark();
                }
                RoomFeaturesPage.this.updateFilter(search);
                RoomFeaturesPage.this.iInitialized = true;
            }
        });
    }

    protected void updateFilter(boolean search) {
        this.iFilter.setValue(this.iHistoryToken.getParameter("q"), true);
        if (this.iSession instanceof AcademicSessionSelectionBox && this.iHistoryToken.isChanged("term", ((AcademicSessionSelectionBox)this.iSession).getAcademicSessionAbbreviation()) && this.iHistoryToken.getParameter("term") != null) {
            ((AcademicSessionSelectionBox)this.iSession).selectSession(this.iHistoryToken.getParameter("term"), null);
        }
        if (this.iHistoryToken.hasParameter("id")) {
            String id = this.iHistoryToken.getParameter("id");
            if ("add".equals(id)) {
                if (this.iProperties != null && (this.iProperties.isCanAddDepartmentalRoomFeature() || this.iProperties.isCanAddGlobalRoomFeature())) {
                    this.edit(null);
                }
            } else {
                if (this.iGlobalFeaturesTable != null) {
                    for (RoomInterface.FeatureInterface g : this.iGlobalFeaturesTable.getData()) {
                        if (!g.getId().toString().equals(id) || !g.canEdit() && !g.canDelete()) continue;
                        this.edit(g);
                    }
                }
                if (this.iDepartmentalFeaturesTable != null) {
                    for (RoomInterface.FeatureInterface g : this.iDepartmentalFeaturesTable.getData()) {
                        if (!g.getId().toString().equals(id) || !g.canEdit() && !g.canDelete()) continue;
                        this.edit(g);
                    }
                }
            }
        } else if (((Object)((Object)this.iRoomFeatureEdit)).equals(this.iRootPanel.getWidget())) {
            this.iRoomFeatureEdit.hide();
        } else if (search) {
            this.search(null);
        }
    }

    protected void changeUrl() {
        this.iHistoryToken.reset(null);
        if (this.iSession instanceof AcademicSessionSelectionBox) {
            this.iHistoryToken.setParameter("term", ((AcademicSessionSelectionBox)this.iSession).getAcademicSessionAbbreviation());
        }
        if (((Object)((Object)this.iRoomFeatureEdit)).equals(this.iRootPanel.getWidget())) {
            this.iHistoryToken.setParameter("id", this.iRoomFeatureEdit.getFeature().getId() == null ? "add" : this.iRoomFeatureEdit.getFeature().getId().toString());
        }
        this.iHistoryToken.setParameter("q", this.iFilter.getValue());
        this.iHistoryToken.mark();
        Client.fireGwtPageChanged(new Client.GwtPageChangeEvent());
    }

    protected void hideResults() {
        if (this.iMore != null) {
            this.iMore.setEnabled(false);
        }
        if (this.iHeaderPanel != null) {
            this.iHeaderPanel.setEnabled("more", false);
        }
        this.iGlobalFeaturesTable.clearTable(1);
        this.iDepartmentalFeaturesTable.clearTable(1);
        this.iFeaturesPanel.getRowFormatter().setVisible(this.iGlobalFeaturesRow, false);
        this.iFeaturesPanel.getRowFormatter().setVisible(this.iGlobalFeaturesRow + 1, false);
        this.iFeaturesPanel.getRowFormatter().setVisible(this.iDepartmentalFeaturesRow, false);
        this.iFeaturesPanel.getRowFormatter().setVisible(this.iDepartmentalFeaturesRow + 1, false);
    }

    protected void search(final Long featureId) {
        this.hideResults();
        RoomInterface.SearchRoomFeaturesRequest request = new RoomInterface.SearchRoomFeaturesRequest(this.iProperties.getAcademicSessionId());
        request.setFilter((EventInterface.RoomFilterRpcRequest)this.iFilter.getElementsRequest());
        LoadingWidget.execute(request, new AsyncCallback<GwtRpcResponseList<RoomInterface.FeatureInterface>>(){

            public void onFailure(Throwable caught) {
                RoomFeaturesPage.this.iFilter.setErrorHint(MESSAGES.failedToLoadRoomFeatures(caught.getMessage()));
                UniTimeNotifications.error(MESSAGES.failedToLoadRoomFeatures(caught.getMessage()), caught);
            }

            public void onSuccess(GwtRpcResponseList<RoomInterface.FeatureInterface> result) {
                RoomFeaturesPage.this.iFilter.clearHint();
                if (result == null || result.isEmpty()) {
                    RoomFeaturesPage.this.iFilter.setErrorHint(MESSAGES.errorNoRoomFeatures());
                } else {
                    FilterBox.Chip dept = RoomFeaturesPage.this.iFilter.getChip("department");
                    boolean skipDepartmental = false;
                    RoomInterface.RoomPropertyInterface department = null;
                    if (dept != null) {
                        for (RoomInterface.ExamTypeInterface type : RoomFeaturesPage.this.iProperties.getExamTypes()) {
                            if (!type.getReference().equals(dept.getValue())) continue;
                            skipDepartmental = true;
                            break;
                        }
                        for (RoomInterface.DepartmentInterface d : RoomFeaturesPage.this.iProperties.getDepartments()) {
                            if (!dept.getValue().equals(d.getDeptCode())) continue;
                            department = d;
                            break;
                        }
                    }
                    for (RoomInterface.FeatureInterface Feature2 : result) {
                        if (Feature2.isDepartmental()) {
                            if (skipDepartmental || department != null && !department.equals(Feature2.getDepartment()) || dept == null && !Feature2.hasRooms()) continue;
                            RoomFeaturesPage.this.iDepartmentalFeaturesTable.addFeature(Feature2);
                            continue;
                        }
                        RoomFeaturesPage.this.iGlobalFeaturesTable.addFeature(Feature2);
                    }
                    RoomFeaturesPage.this.iDepartmentalFeaturesTable.sort();
                    RoomFeaturesPage.this.iGlobalFeaturesTable.sort();
                }
                if (RoomFeaturesPage.this.iMore != null) {
                    RoomFeaturesPage.this.iMore.setEnabled(RoomFeaturesPage.this.iDepartmentalFeaturesTable.getRowCount() > 1 || RoomFeaturesPage.this.iGlobalFeaturesTable.getRowCount() > 1);
                }
                if (RoomFeaturesPage.this.iHeaderPanel != null) {
                    RoomFeaturesPage.this.iHeaderPanel.setEnabled("more", RoomFeaturesPage.this.iDepartmentalFeaturesTable.getRowCount() > 1 || RoomFeaturesPage.this.iGlobalFeaturesTable.getRowCount() > 1);
                }
                RoomFeaturesPage.this.iFeaturesPanel.getRowFormatter().setVisible(RoomFeaturesPage.this.iGlobalFeaturesRow, RoomFeaturesPage.this.iGlobalFeaturesTable.getRowCount() > 1);
                RoomFeaturesPage.this.iFeaturesPanel.getRowFormatter().setVisible(RoomFeaturesPage.this.iGlobalFeaturesRow + 1, RoomFeaturesPage.this.iGlobalFeaturesTable.getRowCount() > 1);
                RoomFeaturesPage.this.iFeaturesPanel.getRowFormatter().setVisible(RoomFeaturesPage.this.iDepartmentalFeaturesRow, RoomFeaturesPage.this.iDepartmentalFeaturesTable.getRowCount() > 1);
                RoomFeaturesPage.this.iFeaturesPanel.getRowFormatter().setVisible(RoomFeaturesPage.this.iDepartmentalFeaturesRow + 1, RoomFeaturesPage.this.iDepartmentalFeaturesTable.getRowCount() > 1);
                RoomFeaturesPage.this.iDepartmentalFeaturesTable.scrollTo(featureId);
                RoomFeaturesPage.this.iGlobalFeaturesTable.scrollTo(featureId);
            }
        }, MESSAGES.waitLoadingRoomFeatures());
    }

    protected void export(String format) {
        RPC.execute(EventInterface.EncodeQueryRpcRequest.encode(this.query(format)), new AsyncCallback<EventInterface.EncodeQueryRpcResponse>(){

            public void onFailure(Throwable caught) {
            }

            public void onSuccess(EventInterface.EncodeQueryRpcResponse result) {
                ToolBox.open(GWT.getHostPageBaseURL() + "export?q=" + result.getQuery());
            }
        });
    }

    protected String query(String format) {
        Object rooms;
        RoomCookie cookie = RoomCookie.getInstance();
        String query = "output=" + format + "&sort=" + cookie.getRoomsSortBy() + (cookie.hasMode() ? "&mode=" + cookie.getMode() : "") + "&dm=" + cookie.getDeptMode();
        if (this.iProperties.getAcademicSessionId() != null) {
            query = query + "&sid=" + this.iProperties.getAcademicSessionId();
        }
        if (((EventInterface.FilterRpcRequest)(rooms = this.iFilter.getElementsRequest())).hasOptions()) {
            for (Map.Entry<String, Set<String>> option : ((EventInterface.FilterRpcRequest)rooms).getOptions().entrySet()) {
                for (String value : option.getValue()) {
                    query = query + "&r:" + option.getKey() + "=" + URL.encodeQueryString((String)value);
                }
            }
        }
        if (((EventInterface.FilterRpcRequest)rooms).getText() != null && !((EventInterface.FilterRpcRequest)rooms).getText().isEmpty()) {
            query = query + "&r:text=" + URL.encodeQueryString((String)((EventInterface.FilterRpcRequest)rooms).getText());
        }
        return query;
    }

    private class Session
    implements AcademicSessionProvider {
        private List<AcademicSessionProvider.AcademicSessionChangeHandler> iHandlers = new ArrayList<AcademicSessionProvider.AcademicSessionChangeHandler>();

        private Session() {
        }

        @Override
        public void selectSession(Long sessionId, AsyncCallback<Boolean> callback) {
            callback.onSuccess((Object)false);
        }

        @Override
        public String getAcademicSessionName() {
            return RoomFeaturesPage.this.iProperties == null ? null : RoomFeaturesPage.this.iProperties.getAcademicSessionName();
        }

        @Override
        public Long getAcademicSessionId() {
            return RoomFeaturesPage.this.iProperties == null ? null : RoomFeaturesPage.this.iProperties.getAcademicSessionId();
        }

        @Override
        public void addAcademicSessionChangeHandler(AcademicSessionProvider.AcademicSessionChangeHandler handler) {
            this.iHandlers.add(handler);
        }

        @Override
        public AcademicSessionProvider.AcademicSessionInfo getAcademicSessionInfo() {
            return null;
        }

        protected void fireChange() {
            AcademicSessionProvider.AcademicSessionChangeEvent event = new AcademicSessionProvider.AcademicSessionChangeEvent(){

                @Override
                public Long getNewAcademicSessionId() {
                    return RoomFeaturesPage.this.iProperties == null ? null : RoomFeaturesPage.this.iProperties.getAcademicSessionId();
                }

                @Override
                public Long getOldAcademicSessionId() {
                    return null;
                }

                @Override
                public boolean isChanged() {
                    return true;
                }
            };
            for (AcademicSessionProvider.AcademicSessionChangeHandler h : this.iHandlers) {
                h.onAcademicSessionChange(event);
            }
        }
    }
}

