/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.rooms;

import com.google.gwt.core.client.Callback;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.ScriptInjector;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.rooms.MapWidget;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.resources.GwtMessages;

public class GoogleMap
extends MapWidget {
    private static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private String iApiKey = null;

    public GoogleMap(TextBox x, TextBox y, String apiKey) {
        super(x, y);
        this.setStyleName("unitime-GoogleMap");
        this.iApiKey = apiKey;
        this.iMapControl = new AbsolutePanel();
        this.iMapControl.setStyleName("control");
        TextBox searchBox = new TextBox();
        searchBox.setStyleName("unitime-TextBox");
        searchBox.addStyleName("searchBox");
        searchBox.getElement().setId("mapSearchBox");
        searchBox.setTabIndex(-1);
        this.iMapControl.add((Widget)searchBox);
        Button button = new Button(MESSAGES.buttonGeocode(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                GoogleMap.this.geocodeAddress();
            }
        });
        button.setTabIndex(-1);
        searchBox.addKeyPressHandler(new KeyPressHandler(){

            public void onKeyPress(KeyPressEvent event) {
                switch (event.getNativeEvent().getKeyCode()) {
                    case 13: {
                        event.preventDefault();
                        GoogleMap.this.geocodeAddress();
                        return;
                    }
                }
            }
        });
        button.addStyleName("geocode");
        ToolBox.setWhiteSpace(button.getElement().getStyle(), "nowrap");
        Character accessKey = UniTimeHeaderPanel.guessAccessKey(MESSAGES.buttonGeocode());
        if (accessKey != null) {
            button.setAccessKey(accessKey.charValue());
        }
        this.iMapControl.add((Widget)button);
        this.add((Widget)this.iMapControl);
        this.addGoogleMap((Element)this.getElement(), (Element)this.iMapControl.getElement());
    }

    protected native void addGoogleMap(Element var1, Element var2);

    @Override
    public native void setMarker();

    protected native void geocodeAddress();

    @Override
    public void setup() {
        ScriptInjector.fromUrl((String)("https://maps.googleapis.com/maps/api/js?" + (this.iApiKey != null && !this.iApiKey.isEmpty() ? "key=" + this.iApiKey + "&" : "") + "sensor=false&callback=setupGoogleMap")).setWindow(ScriptInjector.TOP_WINDOW).setCallback((Callback)new Callback<Void, Exception>(){

            public void onSuccess(Void result) {
            }

            public void onFailure(Exception e) {
                UniTimeNotifications.error(e.getMessage(), e);
                GoogleMap.this.setVisible(false);
                GoogleMap.this.iMapControl = null;
            }
        }).inject();
    }
}

