/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.instructor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.OptionElement;
import com.google.gwt.dom.client.SelectElement;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.NumberBox;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.client.widgets.UniTimeTableHeader;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseNull;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.GwtResources;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.InstructorInterface;
import org.unitime.timetable.gwt.shared.ReservationInterface;
import org.unitime.timetable.gwt.shared.TeachingRequestInterface;

public class SetupTeachingRequestsPage
extends SimpleForm {
    protected static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    protected static final GwtResources RESOURCES = (GwtResources)GWT.create(GwtResources.class);
    protected static final StudentSectioningMessages SECTMSG = (StudentSectioningMessages)GWT.create(StudentSectioningMessages.class);
    protected static GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private Long iOfferingId = null;
    private TeachingRequestInterface.Properties iProperties;
    private UniTimeHeaderPanel iHeader;
    private UniTimeHeaderPanel iFooter;
    private List<RequestPanel> iRequests = new ArrayList<RequestPanel>();

    public SetupTeachingRequestsPage() {
        this.addStyleName("unitime-SetupTeachingRequests");
        this.iOfferingId = Long.valueOf(Window.Location.getParameter((String)"offeringId"));
        this.iHeader = new UniTimeHeaderPanel();
        this.iHeader.addButton("add", MESSAGES.buttonAddTeachingRequest(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                RequestPanel rp = new RequestPanel(null, SetupTeachingRequestsPage.this.iRequests.size() + 1);
                SetupTeachingRequestsPage.this.iRequests.add(rp);
                int row = SetupTeachingRequestsPage.this.insertRow(SetupTeachingRequestsPage.this.getRowCount() - 1);
                SetupTeachingRequestsPage.this.getFlexCellFormatter().setColSpan(row, 0, SetupTeachingRequestsPage.this.getColSpan());
                SetupTeachingRequestsPage.this.setWidget(row, 0, (Widget)rp);
                SetupTeachingRequestsPage.this.requestsChanged();
                ToolBox.scrollToElement((Element)rp.getElement());
            }
        });
        this.iHeader.addButton("save", MESSAGES.buttonSaveTeachingRequests(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                TeachingRequestInterface.SaveRequestsRpcRequest request = new TeachingRequestInterface.SaveRequestsRpcRequest();
                request.setOfferingId(SetupTeachingRequestsPage.this.iOfferingId);
                for (RequestPanel rp : SetupTeachingRequestsPage.this.iRequests) {
                    TeachingRequestInterface.Request r = rp.getRequest();
                    if (r == null) continue;
                    request.addRequest(r);
                }
                LoadingWidget.getInstance().show(MESSAGES.waitSaveTeachingRequests(SetupTeachingRequestsPage.this.iProperties == null ? SetupTeachingRequestsPage.this.iOfferingId.toString() : SetupTeachingRequestsPage.this.iProperties.getOffering().getAbbv()));
                RPC.execute(request, new AsyncCallback<GwtRpcResponseNull>(){

                    public void onFailure(Throwable caught) {
                        LoadingWidget.getInstance().hide();
                        SetupTeachingRequestsPage.this.iHeader.setErrorMessage(MESSAGES.failedSave(caught.getMessage()));
                        UniTimeNotifications.error(MESSAGES.failedSave(caught.getMessage()), caught);
                    }

                    public void onSuccess(GwtRpcResponseNull result) {
                        LoadingWidget.getInstance().hide();
                        ToolBox.open(GWT.getHostPageBaseURL() + "instructionalOfferingDetail.action?io=" + SetupTeachingRequestsPage.this.iOfferingId + "&op=view#instructors");
                    }
                });
            }
        });
        this.iHeader.addButton("back", MESSAGES.buttonBack(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                ToolBox.open(GWT.getHostPageBaseURL() + "instructionalOfferingDetail.action?io=" + SetupTeachingRequestsPage.this.iOfferingId + "&op=view#instructors");
            }
        });
        this.iHeader.setEnabled("add", false);
        this.addHeaderRow((Widget)this.iHeader);
        this.iFooter = this.iHeader.clonePanel();
        LoadingWidget.getInstance().show(MESSAGES.waitLoadingPage());
        TeachingRequestInterface.GetRequestsRpcRequest request = new TeachingRequestInterface.GetRequestsRpcRequest();
        request.setOfferingId(this.iOfferingId);
        RPC.execute(request, new AsyncCallback<TeachingRequestInterface.GetRequestsRpcResponse>(){

            public void onFailure(Throwable caught) {
                LoadingWidget.getInstance().hide();
                SetupTeachingRequestsPage.this.iHeader.setErrorMessage(MESSAGES.failedToInitialize(caught.getMessage()));
                UniTimeNotifications.error(MESSAGES.failedToInitialize(caught.getMessage()), caught);
                ToolBox.checkAccess(caught);
            }

            public void onSuccess(TeachingRequestInterface.GetRequestsRpcResponse result) {
                LoadingWidget.getInstance().hide();
                SetupTeachingRequestsPage.this.iProperties = result;
                SetupTeachingRequestsPage.this.iHeader.setHeaderTitle(result.getOffering().getAbbv() + (result.getOffering().getName() == null ? "" : " - " + result.getOffering().getName()));
                for (TeachingRequestInterface.Request req : result.getRequests()) {
                    RequestPanel rp = new RequestPanel(req, SetupTeachingRequestsPage.this.iRequests.size() + 1);
                    SetupTeachingRequestsPage.this.iRequests.add(rp);
                    SetupTeachingRequestsPage.this.addRow((Widget)rp);
                }
                if (SetupTeachingRequestsPage.this.iRequests.isEmpty()) {
                    RequestPanel rp = new RequestPanel(null, SetupTeachingRequestsPage.this.iRequests.size() + 1);
                    SetupTeachingRequestsPage.this.iRequests.add(rp);
                    SetupTeachingRequestsPage.this.addRow((Widget)rp);
                }
                SetupTeachingRequestsPage.this.addBottomRow((Widget)SetupTeachingRequestsPage.this.iFooter);
                SetupTeachingRequestsPage.this.iHeader.setEnabled("add", true);
                SetupTeachingRequestsPage.this.requestsChanged();
            }
        });
    }

    protected void requestsChanged() {
        for (int i = 0; i < this.iRequests.size(); ++i) {
            this.iRequests.get(i).setIndex(1 + i);
        }
        if (this.iRequests.isEmpty()) {
            this.iHeader.setMessage(MESSAGES.messageNoTeachingRequests(this.iProperties == null ? this.iOfferingId.toString() : this.iProperties.getOffering().getName()));
        } else {
            this.iHeader.clearMessage();
        }
    }

    public class RequestPanel
    extends SimpleForm {
        private UniTimeHeaderPanel iRequestHead;
        private TeachingRequestInterface.Request iRequest;
        private NumberBox iNbrInstructors;
        private int iNbrInstructorsRow;
        private NumberBox iTeachingLoad;
        private CheckBox iSimple;
        private ListBox iSubpart;
        private int iSubpartRow;
        private ListBox iSameCouse;
        private ListBox iSameCommon;
        private int iSameCommonRow;
        private ListBox iResponsibility;
        private int iResponsibilityRow;
        private UniTimeTable<ReservationInterface.Clazz> iClasses;
        private int iClassesRow;
        private CheckBox iCoordinator;
        private int iCoordinatorRow;
        private NumberBox iPercentShare;
        private int iPercentShareRow;
        private UniTimeTable<ReservationInterface.Subpart> iSubparts;
        private int iSubpartsLine;
        private Map<String, UniTimeTable<TeachingRequestInterface.Preference>> iAttributes;
        private UniTimeTable<TeachingRequestInterface.Preference> iInstructors;

        RequestPanel(TeachingRequestInterface.Request request, int index) {
            TeachingRequestInterface.SingleRequest sr;
            this.removeStyleName("unitime-NotPrintableBottomLine");
            this.iRequestHead = new UniTimeHeaderPanel(MESSAGES.sectTeachingRequest(index));
            this.iRequestHead.addButton("remove", MESSAGES.buttonRemoveTeachingRequest(), new ClickHandler(){

                public void onClick(ClickEvent event) {
                    int row = SetupTeachingRequestsPage.this.getCellForEvent(event).getRowIndex();
                    if (row > 0) {
                        SetupTeachingRequestsPage.this.removeRow(row);
                        SetupTeachingRequestsPage.this.iRequests.remove((Object)RequestPanel.this);
                        SetupTeachingRequestsPage.this.requestsChanged();
                    }
                }
            });
            this.addHeaderRow((Widget)this.iRequestHead);
            this.iRequest = request;
            if (request == null) {
                this.iSimple = new CheckBox();
                this.iSimple.setValue(Boolean.valueOf(true));
                this.addRow(MESSAGES.propSetupTeachingRequestMulti(), (Widget)this.iSimple);
                this.iSimple.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                    public void onValueChange(ValueChangeEvent<Boolean> event) {
                        RequestPanel.this.simpleChanged();
                    }
                });
            }
            this.iNbrInstructors = new NumberBox();
            this.iNbrInstructors.setWidth("20px");
            this.iNbrInstructors.setDecimal(false);
            this.iNbrInstructors.setNegative(false);
            if (request != null && request instanceof TeachingRequestInterface.SingleRequest) {
                this.iNbrInstructors.setValue(((TeachingRequestInterface.SingleRequest)request).getNbrInstructors());
            } else {
                this.iNbrInstructors.setValue(1);
            }
            this.iNbrInstructorsRow = this.addRow(MESSAGES.propNbrInstructors(), (Widget)this.iNbrInstructors);
            this.getRowFormatter().setVisible(this.iNbrInstructorsRow, request != null && request instanceof TeachingRequestInterface.SingleRequest);
            this.iTeachingLoad = new NumberBox();
            this.iTeachingLoad.setWidth("50px");
            this.iTeachingLoad.setDecimal(false);
            this.iTeachingLoad.setNegative(false);
            if (request != null) {
                this.iTeachingLoad.setValue(Float.valueOf(request.getTeachingLoad()));
            }
            this.addRow(MESSAGES.propTeachingLoad(), (Widget)this.iTeachingLoad);
            this.iCoordinator = new CheckBox();
            if (request != null) {
                this.iCoordinator.setValue(Boolean.valueOf(request.isAssignCoordinator()));
            }
            this.iCoordinator.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                public void onValueChange(ValueChangeEvent<Boolean> event) {
                    RequestPanel.this.changeResponsibilities();
                }
            });
            this.iCoordinatorRow = this.addRow(MESSAGES.propAssignCoordinator(), (Widget)this.iCoordinator);
            this.getRowFormatter().setVisible(this.iCoordinatorRow, request != null && request instanceof TeachingRequestInterface.SingleRequest);
            this.iPercentShare = new NumberBox();
            this.iPercentShare.setDecimal(false);
            this.iPercentShare.setNegative(false);
            this.iPercentShare.setMaxLength(3);
            this.iPercentShare.setWidth("50px");
            if (request != null) {
                this.iPercentShare.setValue(request.getPercentShare());
            }
            this.iPercentShareRow = this.addRow(MESSAGES.propCoordinatorPercentShare(), (Widget)this.iPercentShare);
            this.getRowFormatter().setVisible(this.iPercentShareRow, this.getRowFormatter().isVisible(this.iCoordinatorRow) && this.iCoordinator.getValue() != false);
            if (!SetupTeachingRequestsPage.this.iProperties.getResponsibilities().isEmpty()) {
                this.iResponsibility = new ListBox();
                this.iResponsibilityRow = this.addRow(MESSAGES.propTeachingResponsibility(), (Widget)this.iResponsibility);
                this.changeResponsibilities();
            }
            if (request == null || request instanceof TeachingRequestInterface.MultiRequest) {
                this.iSubpart = new ListBox();
                this.iSubpart.addItem(MESSAGES.teachingRequestNoSubpart(), "-1");
                SelectElement select = (SelectElement)this.iSubpart.getElement().cast();
                for (ReservationInterface.Config config : SetupTeachingRequestsPage.this.iProperties.getOffering().getConfigs()) {
                    block1: for (ReservationInterface.Subpart subpart : config.getSubparts()) {
                        this.iSubpart.addItem(subpart.getName() + (config.hasInstructionalMethod() ? " (" + config.getInstructionalMethod() + ")" : ""), subpart.getId().toString());
                        int indent = config.getIndent(subpart);
                        if (indent > 0) {
                            ((OptionElement)select.getOptions().getItem(this.iSubpart.getItemCount() - 1)).getStyle().setPadding((double)(16 * indent), Style.Unit.PX);
                        }
                        if (request == null) continue;
                        for (ReservationInterface.Clazz clazz : subpart.getClasses()) {
                            if (((TeachingRequestInterface.MultiRequest)request).getClass(clazz.getId()) == null) continue;
                            this.iSubpart.setSelectedIndex(this.iSubpart.getItemCount() - 1);
                            continue block1;
                        }
                    }
                }
                this.iSubpart.addChangeHandler(new ChangeHandler(){

                    public void onChange(ChangeEvent event) {
                        RequestPanel.this.subpartChanged();
                    }
                });
                this.iSubpartRow = this.addRow(MESSAGES.propSchedulingSubpart(), (Widget)this.iSubpart);
            }
            if (request != null && request instanceof TeachingRequestInterface.SingleRequest && (sr = (TeachingRequestInterface.SingleRequest)request).hasInstructors()) {
                P instructors = new P("instructors");
                for (Long id : sr.getInstructorIds()) {
                    InstructorInterface instructor = SetupTeachingRequestsPage.this.iProperties.getInstructor(id);
                    if (instructor == null) continue;
                    P p = new P("instructor");
                    p.setText(instructor.getFormattedName());
                    instructors.add((Widget)p);
                }
                this.addRow(MESSAGES.propAssignedInstructor(), (Widget)instructors);
            }
            this.iClasses = new UniTimeTable();
            this.iClasses.getElement().getStyle().setWidth(100.0, Style.Unit.PCT);
            ArrayList<UniTimeTableHeader> classesHeader = new ArrayList<UniTimeTableHeader>();
            classesHeader.add(new UniTimeTableHeader("&nbsp;"));
            classesHeader.add(new UniTimeTableHeader(MESSAGES.colClass()));
            classesHeader.add(new UniTimeTableHeader(MESSAGES.colExternalId()));
            classesHeader.add(new UniTimeTableHeader(MESSAGES.colEnrollment()));
            classesHeader.add(new UniTimeTableHeader(MESSAGES.colLimit()));
            classesHeader.add(new UniTimeTableHeader(MESSAGES.colTime()));
            classesHeader.add(new UniTimeTableHeader(MESSAGES.colDate()));
            classesHeader.add(new UniTimeTableHeader(MESSAGES.colRoom()));
            classesHeader.add(new UniTimeTableHeader(MESSAGES.colInstructor()));
            classesHeader.add(new UniTimeTableHeader(MESSAGES.colAssignInstructor()));
            classesHeader.add(new UniTimeTableHeader(MESSAGES.colPercentShare()));
            classesHeader.add(new UniTimeTableHeader(MESSAGES.colInstructorLead()));
            classesHeader.add(new UniTimeTableHeader(MESSAGES.colCanOverlap()));
            classesHeader.add(new UniTimeTableHeader(MESSAGES.colCommonPart()));
            this.iClasses.addRow(null, classesHeader);
            this.iClassesRow = this.addRow(MESSAGES.propClasses(), (Widget)this.iClasses);
            if (request == null || request instanceof TeachingRequestInterface.MultiRequest) {
                this.iSubparts = new UniTimeTable();
                this.iSubparts.getElement().getStyle().setWidth(100.0, Style.Unit.PCT);
                Iterator<InstructorInterface.PreferenceInterface> subpartsHeader = new ArrayList();
                subpartsHeader.add((InstructorInterface.PreferenceInterface)((Object)new UniTimeTableHeader("&nbsp;")));
                subpartsHeader.add((InstructorInterface.PreferenceInterface)((Object)new UniTimeTableHeader(MESSAGES.colInstructionalType())));
                subpartsHeader.add((InstructorInterface.PreferenceInterface)((Object)new UniTimeTableHeader(MESSAGES.colAssignInstructor())));
                subpartsHeader.add((InstructorInterface.PreferenceInterface)((Object)new UniTimeTableHeader(MESSAGES.colPercentShare())));
                subpartsHeader.add((InstructorInterface.PreferenceInterface)((Object)new UniTimeTableHeader(MESSAGES.colInstructorLead())));
                subpartsHeader.add((InstructorInterface.PreferenceInterface)((Object)new UniTimeTableHeader(MESSAGES.colCanOverlap())));
                subpartsHeader.add((InstructorInterface.PreferenceInterface)((Object)new UniTimeTableHeader(MESSAGES.colCommonPart())));
                this.iSubparts.addRow((ReservationInterface.Subpart)null, (List<Widget>)((Object)subpartsHeader));
                this.iSubpartsLine = this.addRow(MESSAGES.propIncludeSubparts(), (Widget)this.iSubparts);
            }
            this.iSameCouse = new ListBox();
            for (InstructorInterface.PreferenceInterface preferenceInterface : SetupTeachingRequestsPage.this.iProperties.getPreferences()) {
                this.iSameCouse.addItem(preferenceInterface.getName(), preferenceInterface.getId().toString());
                if (request == null) {
                    if (!"R".equals(preferenceInterface.getCode())) continue;
                    this.iSameCouse.setSelectedIndex(this.iSameCouse.getItemCount() - 1);
                    continue;
                }
                if (request.getSameCoursePreference() != null) {
                    if (!preferenceInterface.getId().equals(request.getSameCoursePreference())) continue;
                    this.iSameCouse.setSelectedIndex(this.iSameCouse.getItemCount() - 1);
                    continue;
                }
                if (!"0".equals(preferenceInterface.getCode())) continue;
                this.iSameCouse.setSelectedIndex(this.iSameCouse.getItemCount() - 1);
            }
            this.addRow(MESSAGES.propSameCoursePreference(), (Widget)this.iSameCouse);
            this.iSameCommon = new ListBox();
            for (InstructorInterface.PreferenceInterface preferenceInterface : SetupTeachingRequestsPage.this.iProperties.getPreferences()) {
                this.iSameCommon.addItem(preferenceInterface.getName(), preferenceInterface.getId().toString());
                if (request == null) {
                    if (!"0".equals(preferenceInterface.getCode())) continue;
                    this.iSameCommon.setSelectedIndex(this.iSameCommon.getItemCount() - 1);
                    continue;
                }
                if (request.getSameCommonPreference() != null) {
                    if (!preferenceInterface.getId().equals(request.getSameCommonPreference())) continue;
                    this.iSameCommon.setSelectedIndex(this.iSameCommon.getItemCount() - 1);
                    continue;
                }
                if (!"0".equals(preferenceInterface.getCode())) continue;
                this.iSameCommon.setSelectedIndex(this.iSameCommon.getItemCount() - 1);
            }
            this.iSameCommonRow = this.addRow(MESSAGES.propSameCommonPreference(), (Widget)this.iSameCommon);
            if (!SetupTeachingRequestsPage.this.iProperties.getAttributes().isEmpty()) {
                TreeSet<String> types = new TreeSet<String>();
                for (InstructorInterface.AttributeInterface a : SetupTeachingRequestsPage.this.iProperties.getAttributes()) {
                    types.add(a.getType().getLabel());
                }
                this.iAttributes = new HashMap<String, UniTimeTable<TeachingRequestInterface.Preference>>();
                for (String type : types) {
                    this.iAttributes.put(type, new UniTimeTable());
                    if (request != null && request.hasAttributePrefernces()) {
                        for (TeachingRequestInterface.Preference p : request.getAttributePreferences()) {
                            InstructorInterface.AttributeInterface a = SetupTeachingRequestsPage.this.iProperties.getAttribute(p.getOwnerId());
                            if (a == null || !type.equals(a.getType().getLabel())) continue;
                            this.addAttributePreferenceLine(type, p);
                        }
                    }
                    this.addAttributePreferenceLine(type, null);
                    this.addRow(MESSAGES.propAttributeOfTypePrefs(type), (Widget)this.iAttributes.get(type));
                }
            }
            if (!SetupTeachingRequestsPage.this.iProperties.getInstructors().isEmpty()) {
                this.iInstructors = new UniTimeTable();
                if (request != null && request.hasInstructorPrefernces()) {
                    for (TeachingRequestInterface.Preference preference : request.getInstructorPreferences()) {
                        this.addInstructorPreferenceLine(preference);
                    }
                }
                this.addInstructorPreferenceLine(null);
                this.addRow(MESSAGES.propInstructorPrefs(), (Widget)this.iInstructors);
            }
        }

        public void setIndex(int index) {
            this.iRequestHead.setHeaderTitle(MESSAGES.sectTeachingRequest(index));
        }

        protected void addAttributePreferenceLine(final String type, TeachingRequestInterface.Preference p) {
            final UniTimeTable<TeachingRequestInterface.Preference> attributes = this.iAttributes.get(type);
            ArrayList<Object> line = new ArrayList<Object>();
            final ListBox attribute = new ListBox();
            ToolBox.setMinWidth(attribute.getElement().getStyle(), "350px");
            attribute.addItem(MESSAGES.itemSelect(), "-1");
            for (InstructorInterface.AttributeInterface attributeInterface : SetupTeachingRequestsPage.this.iProperties.getAttributes()) {
                if (!type.equals(attributeInterface.getType().getLabel())) continue;
                attribute.addItem(attributeInterface.getName(), attributeInterface.getId().toString());
                if (p == null || !p.getOwnerId().equals(attributeInterface.getId())) continue;
                attribute.setSelectedIndex(attribute.getItemCount() - 1);
            }
            line.add(attribute);
            final ListBox preference = new ListBox();
            for (InstructorInterface.PreferenceInterface x : SetupTeachingRequestsPage.this.iProperties.getPreferences()) {
                preference.addItem(x.getName(), x.getId().toString());
                if ((p == null || !p.getPreferenceId().equals(x.getId())) && (p != null || !x.getCode().equals("0"))) continue;
                preference.setSelectedIndex(preference.getItemCount() - 1);
            }
            line.add(preference);
            Image image = new Image(RESOURCES.delete());
            image.setTitle(MESSAGES.titleDeleteRow());
            image.getElement().getStyle().setCursor(Style.Cursor.POINTER);
            image.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    if (attributes.getRowCount() > 2) {
                        attributes.removeRow(attributes.getCellForEvent(event).getRowIndex());
                    } else {
                        attribute.setSelectedIndex(0);
                        preference.setSelectedIndex(3);
                    }
                }
            });
            line.add(image);
            attributes.addRow(p, line);
            attribute.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    int row = attributes.getRowForWidget((Widget)attribute);
                    if (attributes.getRowCount() - 1 == row && attribute.getSelectedIndex() > 0) {
                        RequestPanel.this.addAttributePreferenceLine(type, null);
                    }
                }
            });
        }

        protected void addInstructorPreferenceLine(TeachingRequestInterface.Preference p) {
            if (SetupTeachingRequestsPage.this.iProperties.getInstructors().isEmpty()) {
                return;
            }
            ArrayList<Object> line = new ArrayList<Object>();
            final ListBox instructor = new ListBox();
            ToolBox.setMinWidth(instructor.getElement().getStyle(), "350px");
            instructor.addItem(MESSAGES.itemSelect(), "-1");
            for (InstructorInterface instructorInterface : SetupTeachingRequestsPage.this.iProperties.getInstructors()) {
                instructor.addItem(instructorInterface.getFormattedName(), instructorInterface.getId().toString());
                if (p == null || !p.getOwnerId().equals(instructorInterface.getId())) continue;
                instructor.setSelectedIndex(instructor.getItemCount() - 1);
            }
            line.add(instructor);
            final ListBox preference = new ListBox();
            for (InstructorInterface.PreferenceInterface x : SetupTeachingRequestsPage.this.iProperties.getPreferences()) {
                preference.addItem(x.getName(), x.getId().toString());
                if ((p == null || !p.getPreferenceId().equals(x.getId())) && (p != null || !x.getCode().equals("0"))) continue;
                preference.setSelectedIndex(preference.getItemCount() - 1);
            }
            line.add(preference);
            Image image = new Image(RESOURCES.delete());
            image.setTitle(MESSAGES.titleDeleteRow());
            image.getElement().getStyle().setCursor(Style.Cursor.POINTER);
            image.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    if (RequestPanel.this.iInstructors.getRowCount() > 2) {
                        RequestPanel.this.iInstructors.removeRow(RequestPanel.this.iInstructors.getCellForEvent(event).getRowIndex());
                    } else {
                        instructor.setSelectedIndex(0);
                        preference.setSelectedIndex(3);
                    }
                }
            });
            line.add(image);
            this.iInstructors.addRow(p, line);
            instructor.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    int row = RequestPanel.this.iInstructors.getRowForWidget((Widget)instructor);
                    if (RequestPanel.this.iInstructors.getRowCount() - 1 == row && instructor.getSelectedIndex() > 0) {
                        RequestPanel.this.addInstructorPreferenceLine(null);
                    }
                }
            });
            this.simpleChanged();
        }

        protected void changeResponsibilities() {
            boolean coordinator = this.iCoordinator.getValue();
            if (this.iResponsibility != null) {
                TeachingRequestInterface.Responsibility selected;
                TeachingRequestInterface.Responsibility responsibility = selected = this.iRequest == null ? null : this.iRequest.getTeachingResponsibility();
                if (this.iResponsibility.getSelectedIndex() > 0) {
                    selected = SetupTeachingRequestsPage.this.iProperties.getResponsibility(Long.valueOf(this.iResponsibility.getSelectedValue()));
                }
                this.iResponsibility.clear();
                this.iResponsibility.addItem(MESSAGES.noTeachingResponsiblitySelected(), "-1");
                for (TeachingRequestInterface.Responsibility resp : SetupTeachingRequestsPage.this.iProperties.getResponsibilities()) {
                    if (coordinator && !resp.isCoordinator() || !coordinator && !resp.isInstructor()) continue;
                    this.iResponsibility.addItem(resp.getName(), resp.getId().toString());
                    if (selected == null || !resp.equals(selected)) continue;
                    this.iResponsibility.setSelectedIndex(this.iResponsibility.getItemCount() - 1);
                }
                this.getRowFormatter().setVisible(this.iResponsibilityRow, this.iResponsibility.getItemCount() > 1);
            }
            if (this.iPercentShare != null) {
                this.getRowFormatter().setVisible(this.iPercentShareRow, coordinator);
            }
        }

        protected void simpleChanged() {
            if (this.iSimple != null && this.iSimple.getValue().booleanValue() || this.iRequest != null && this.iRequest instanceof TeachingRequestInterface.MultiRequest) {
                this.getRowFormatter().setVisible(this.iNbrInstructorsRow, false);
                this.getRowFormatter().setVisible(this.iCoordinatorRow, false);
                if (this.iSubpart != null) {
                    this.getRowFormatter().setVisible(this.iSubpartRow, true);
                }
                if (this.iSubparts != null) {
                    this.getRowFormatter().setVisible(this.iSubpartsLine, true);
                }
                this.subpartChanged();
            } else {
                this.getRowFormatter().setVisible(this.iCoordinatorRow, true);
                this.getRowFormatter().setVisible(this.iNbrInstructorsRow, true);
                if (this.iSubpart != null) {
                    this.getRowFormatter().setVisible(this.iSubpartRow, false);
                }
                if (this.iSubparts != null) {
                    this.getRowFormatter().setVisible(this.iSubpartsLine, false);
                }
                this.iClasses.clearTable(1);
                for (ReservationInterface.Config config : SetupTeachingRequestsPage.this.iProperties.getOffering().getConfigs()) {
                    for (ReservationInterface.Subpart subpart : config.getSubparts()) {
                        if (subpart.getParentId() != null) continue;
                        this.addClasses(subpart, null);
                    }
                }
                this.iClasses.setColumnVisible(8, false);
                this.iClasses.setColumnVisible(9, true);
                this.iClasses.setColumnVisible(10, true);
                this.iClasses.setColumnVisible(11, true);
                this.iClasses.setColumnVisible(12, true);
                this.iClasses.setColumnVisible(13, true);
                this.getRowFormatter().setVisible(this.iClassesRow, this.iClasses.getRowCount() > 1);
                boolean hasExternalId = false;
                boolean hasAssignment = false;
                for (ReservationInterface.Config config : SetupTeachingRequestsPage.this.iProperties.getOffering().getConfigs()) {
                    for (ReservationInterface.Subpart subpart : config.getSubparts()) {
                        for (ReservationInterface.Clazz clazz : subpart.getClasses()) {
                            if (clazz.hasExternalId()) {
                                hasExternalId = true;
                            }
                            if (!clazz.hasTime() && !clazz.hasRoom()) continue;
                            hasAssignment = true;
                        }
                    }
                }
                this.iClasses.setColumnVisible(2, hasExternalId);
                this.iClasses.setColumnVisible(5, hasAssignment);
                this.iClasses.setColumnVisible(6, hasAssignment);
                this.iClasses.setColumnVisible(7, hasAssignment);
            }
        }

        protected void addClasses(ReservationInterface.Subpart subpart, Long parent) {
            for (ReservationInterface.Clazz clazz : subpart.getClasses()) {
                if (parent != null && !parent.equals(clazz.getParentId())) continue;
                this.addClass(clazz);
                for (ReservationInterface.Subpart child : subpart.getConfig().getSubparts()) {
                    if (!subpart.getId().equals(child.getParentId())) continue;
                    this.addClasses(child, clazz.getId());
                }
            }
        }

        protected void addClass(ReservationInterface.Clazz clazz) {
            ArrayList<Object> line = new ArrayList<Object>();
            final CheckBox select = new CheckBox();
            int indent = clazz.getSubpart().getConfig().getIndent(clazz.getSubpart());
            line.add(select);
            if (clazz.isCancelled()) {
                select.setValue(Boolean.valueOf(false));
                select.setEnabled(false);
            }
            Label name = new Label(clazz.getName());
            name.getElement().getStyle().setPaddingLeft((double)(16 * indent), Style.Unit.PX);
            line.add(name);
            line.add(new Label(clazz.hasExternalId() ? clazz.getExternalId() : ""));
            line.add(new Label(clazz.getEnrollment() == null ? "" : clazz.getEnrollment().toString()));
            line.add(new Label(clazz.getLimit() == null ? "" : clazz.getLimit().toString()));
            line.add(new HTML(clazz.hasTime() ? clazz.getTime() : SECTMSG.arrangeHours()));
            line.add(new HTML(clazz.hasDate() ? clazz.getDate() : SECTMSG.noDate()));
            line.add(new HTML(clazz.hasRoom() ? clazz.getRoom() : SECTMSG.noRoom()));
            line.add(new Label());
            TeachingRequestInterface.IncludeLine include = null;
            if (this.iRequest != null && this.iRequest instanceof TeachingRequestInterface.SingleRequest) {
                include = ((TeachingRequestInterface.SingleRequest)this.iRequest).getClazz(clazz.getId());
            }
            select.setValue(Boolean.valueOf(include != null));
            final CheckBox ass = new CheckBox();
            ass.setValue(Boolean.valueOf(include != null ? include.isAssign() : true));
            line.add(ass);
            final NumberBox share = new NumberBox();
            share.setDecimal(false);
            share.setNegative(false);
            share.setWidth("50px");
            share.setValue(include != null ? include.getShare() : 100);
            line.add((Object)share);
            final CheckBox lead = new CheckBox();
            lead.setValue(Boolean.valueOf(include != null ? include.isLead() : true));
            line.add(lead);
            final CheckBox overlap = new CheckBox();
            overlap.setValue(Boolean.valueOf(include != null ? include.isCanOverlap() : false));
            line.add(overlap);
            final CheckBox common = new CheckBox();
            common.setValue(Boolean.valueOf(include != null ? include.isCommon() : false));
            line.add(common);
            ass.setVisible(select.getValue().booleanValue());
            share.setVisible(select.getValue() != false && ass.getValue() != false);
            lead.setVisible(select.getValue() != false && ass.getValue() != false);
            overlap.setVisible(select.getValue().booleanValue());
            common.setVisible(select.getValue().booleanValue());
            select.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                public void onValueChange(ValueChangeEvent<Boolean> event) {
                    ass.setVisible(((Boolean)event.getValue()).booleanValue());
                    share.setVisible(select.getValue() != false && ass.getValue() != false);
                    lead.setVisible(select.getValue() != false && ass.getValue() != false);
                    overlap.setVisible(select.getValue().booleanValue());
                    common.setVisible(select.getValue().booleanValue());
                }
            });
            ass.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                public void onValueChange(ValueChangeEvent<Boolean> event) {
                    share.setVisible(select.getValue() != false && ass.getValue() != false);
                    lead.setVisible(select.getValue() != false && ass.getValue() != false);
                }
            });
            if (clazz.isCancelled()) {
                for (Widget widget : line) {
                    widget.addStyleName("cancelled");
                }
            }
            this.iClasses.addRow(clazz, line);
        }

        /*
         * WARNING - void declaration
         */
        protected void subpartChanged() {
            if (this.iSubpart.getSelectedIndex() == 0) {
                this.getRowFormatter().setVisible(this.iSameCommonRow, false);
                this.getRowFormatter().setVisible(this.iClassesRow, false);
                this.getRowFormatter().setVisible(this.iSubpartsLine, false);
            } else {
                this.getRowFormatter().setVisible(this.iSameCommonRow, false);
                this.getRowFormatter().setVisible(this.iClassesRow, true);
                this.getRowFormatter().setVisible(this.iSubpartsLine, false);
                this.iClasses.clearTable(1);
                this.iSubparts.clearTable(1);
                Long subpartId = Long.valueOf(this.iSubpart.getSelectedValue());
                for (ReservationInterface.Config config : SetupTeachingRequestsPage.this.iProperties.getOffering().getConfigs()) {
                    for (ReservationInterface.Subpart subpart : config.getSubparts()) {
                        if (!subpartId.equals(subpart.getId())) continue;
                        boolean hasInstructor = false;
                        boolean hasExternalId = false;
                        boolean hasAssignment = false;
                        for (ReservationInterface.Clazz clazz : subpart.getClasses()) {
                            if (clazz.hasExternalId()) {
                                hasExternalId = true;
                            }
                            if (clazz.hasTime() || clazz.hasRoom()) {
                                hasAssignment = true;
                            }
                            ArrayList<Object> line = new ArrayList<Object>();
                            NumberBox ch = new NumberBox();
                            ch.setWidth("20px");
                            line.add((Object)ch);
                            line.add(new Label(clazz.getName()));
                            line.add(new Label(clazz.hasExternalId() ? clazz.getExternalId() : ""));
                            line.add(new Label(clazz.getEnrollment() == null ? "" : clazz.getEnrollment().toString()));
                            line.add(new Label(clazz.getLimit() == null ? "" : clazz.getLimit().toString()));
                            line.add(new HTML(clazz.hasTime() ? clazz.getTime() : SECTMSG.arrangeHours()));
                            line.add(new HTML(clazz.hasDate() ? clazz.getDate() : SECTMSG.noDate()));
                            line.add(new HTML(clazz.hasRoom() ? clazz.getRoom() : SECTMSG.noRoom()));
                            TeachingRequestInterface.RequestedClass rc = null;
                            if (this.iRequest != null && this.iRequest instanceof TeachingRequestInterface.MultiRequest) {
                                rc = ((TeachingRequestInterface.MultiRequest)this.iRequest).getClass(clazz.getId());
                            }
                            if (this.iRequest == null) {
                                ch.setValue(clazz.isCancelled() ? 0 : 1);
                            } else if (rc != null) {
                                ch.setValue(rc.getNbrInstructors());
                            }
                            if (rc != null && rc.hasInstructors()) {
                                P instructors = new P("instructors");
                                for (Long id : rc.getInstructorIds()) {
                                    InstructorInterface i = SetupTeachingRequestsPage.this.iProperties.getInstructor(id);
                                    if (i == null) continue;
                                    P p = new P("instructor");
                                    p.setText(i.getFormattedName());
                                    instructors.add((Widget)p);
                                }
                                hasInstructor = true;
                                line.add((Object)instructors);
                            } else {
                                line.add(new Label());
                            }
                            if (clazz.isCancelled()) {
                                for (Widget widget : line) {
                                    widget.addStyleName("cancelled");
                                }
                            }
                            this.iClasses.addRow(clazz, line);
                        }
                        this.iClasses.setColumnVisible(2, hasExternalId);
                        this.iClasses.setColumnVisible(5, hasAssignment);
                        this.iClasses.setColumnVisible(6, hasAssignment);
                        this.iClasses.setColumnVisible(7, hasAssignment);
                        this.iClasses.setColumnVisible(8, hasInstructor);
                        this.iClasses.setColumnVisible(9, false);
                        this.iClasses.setColumnVisible(10, false);
                        this.iClasses.setColumnVisible(11, false);
                        this.iClasses.setColumnVisible(12, false);
                        this.iClasses.setColumnVisible(13, false);
                        boolean hasSameCommon = false;
                        for (ReservationInterface.Subpart s : config.getSubparts()) {
                            void var15_27;
                            ArrayList<Object> line = new ArrayList<Object>();
                            final CheckBox select = new CheckBox();
                            line.add(select);
                            TeachingRequestInterface.IncludeLine include = null;
                            if (this.iRequest != null && this.iRequest instanceof TeachingRequestInterface.MultiRequest) {
                                include = ((TeachingRequestInterface.MultiRequest)this.iRequest).getSubpart(s.getId());
                            }
                            if (s.equals(subpart)) {
                                select.setValue(Boolean.valueOf(true));
                                select.setEnabled(false);
                            } else {
                                select.setValue(Boolean.valueOf(include != null));
                            }
                            String string = s.getName();
                            boolean defaultOverlap = false;
                            if (!s.equals(subpart)) {
                                if (config.isParent(s, subpart)) {
                                    if (s.getClasses().size() < subpart.getClasses().size()) {
                                        hasSameCommon = true;
                                    }
                                    String string2 = MESSAGES.subpartNameParent(s.getName());
                                } else if (config.isParent(subpart, s)) {
                                    int[] minMax = config.countChildClasses(subpart, s);
                                    if (minMax != null) {
                                        if (minMax[0] == minMax[1]) {
                                            if (minMax[0] == 1) {
                                                String string3 = MESSAGES.subpartNameOneChildClass(s.getName());
                                            } else {
                                                String string4 = MESSAGES.subpartNameChildrenClases(s.getName(), minMax[0]);
                                            }
                                        } else {
                                            String string5 = MESSAGES.subpartNameChildrenClasesRange(s.getName(), minMax[0], minMax[1]);
                                        }
                                    }
                                } else if (s.getClasses().size() == 1) {
                                    String string6 = MESSAGES.subpartNameNoRelationSingleClass(s.getName());
                                } else {
                                    String string7 = MESSAGES.subpartNameNoRelationClasses(s.getName(), s.getClasses().size());
                                    defaultOverlap = true;
                                }
                            }
                            line.add(new Label((String)var15_27));
                            final CheckBox ass = new CheckBox();
                            ass.setValue(Boolean.valueOf(include != null ? include.isAssign() : s.equals(subpart) || config.isParent(subpart, s)));
                            line.add(ass);
                            final NumberBox share = new NumberBox();
                            share.setDecimal(false);
                            share.setNegative(false);
                            share.setWidth("50px");
                            share.setValue(include != null ? include.getShare() : (s.equals(subpart) || config.isParent(subpart, s) ? 100 : 0));
                            line.add((Object)share);
                            final CheckBox lead = new CheckBox();
                            lead.setValue(Boolean.valueOf(include != null ? include.isLead() : true));
                            line.add(lead);
                            final CheckBox overlap = new CheckBox();
                            overlap.setValue(Boolean.valueOf(include != null ? include.isCanOverlap() : defaultOverlap));
                            line.add(overlap);
                            final CheckBox common = new CheckBox();
                            common.setValue(Boolean.valueOf(include != null ? include.isCommon() : !s.equals(subpart) && !config.isParent(subpart, s)));
                            line.add(common);
                            ass.setVisible(select.getValue().booleanValue());
                            share.setVisible(select.getValue() != false && ass.getValue() != false);
                            lead.setVisible(select.getValue() != false && ass.getValue() != false);
                            overlap.setVisible(select.getValue().booleanValue());
                            common.setVisible(select.getValue().booleanValue());
                            select.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                                public void onValueChange(ValueChangeEvent<Boolean> event) {
                                    ass.setVisible(((Boolean)event.getValue()).booleanValue());
                                    share.setVisible(select.getValue() != false && ass.getValue() != false);
                                    lead.setVisible(select.getValue() != false && ass.getValue() != false);
                                    overlap.setVisible(select.getValue().booleanValue());
                                    common.setVisible(select.getValue().booleanValue());
                                }
                            });
                            ass.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                                public void onValueChange(ValueChangeEvent<Boolean> event) {
                                    share.setVisible(select.getValue() != false && ass.getValue() != false);
                                    lead.setVisible(select.getValue() != false && ass.getValue() != false);
                                }
                            });
                            this.iSubparts.addRow(s, line);
                        }
                        this.getRowFormatter().setVisible(this.iSubpartsLine, !config.getSubparts().isEmpty());
                        this.getRowFormatter().setVisible(this.iSameCommonRow, hasSameCommon);
                    }
                }
            }
        }

        public TeachingRequestInterface.Request getRequest() {
            Integer shr;
            TeachingRequestInterface.IncludeLine include;
            CheckBox common;
            CheckBox canOverlap;
            CheckBox lead;
            NumberBox share;
            CheckBox assign;
            NumberBox select;
            ReservationInterface.Clazz clazz;
            int i;
            TeachingRequestInterface.Request r;
            TeachingRequestInterface.Request ret = null;
            if (this.iRequest != null && this.iRequest instanceof TeachingRequestInterface.SingleRequest || this.iSimple != null && !this.iSimple.getValue().booleanValue()) {
                r = new TeachingRequestInterface.SingleRequest();
                if (this.iRequest != null && this.iRequest instanceof TeachingRequestInterface.SingleRequest) {
                    ((TeachingRequestInterface.SingleRequest)r).setInstructorIds(((TeachingRequestInterface.SingleRequest)this.iRequest).getInstructorIds());
                    ((TeachingRequestInterface.SingleRequest)r).setRequestId(((TeachingRequestInterface.SingleRequest)this.iRequest).getRequestId());
                }
                ((TeachingRequestInterface.SingleRequest)r).setNbrInstructors(this.iNbrInstructors.toInteger() == null ? 1 : this.iNbrInstructors.toInteger());
                r.setAssignCoordinator(this.iCoordinator.getValue());
                r.setPercentShare(this.iPercentShare.toInteger());
                for (i = 1; i < this.iClasses.getRowCount(); ++i) {
                    clazz = this.iClasses.getData(i);
                    if (clazz == null || !(select = (CheckBox)this.iClasses.getWidget(i, 0)).getValue().booleanValue()) continue;
                    assign = (CheckBox)this.iClasses.getWidget(i, 9);
                    share = (NumberBox)this.iClasses.getWidget(i, 10);
                    lead = (CheckBox)this.iClasses.getWidget(i, 11);
                    canOverlap = (CheckBox)this.iClasses.getWidget(i, 12);
                    common = (CheckBox)this.iClasses.getWidget(i, 13);
                    include = new TeachingRequestInterface.IncludeLine();
                    include.setAssign(assign.getValue());
                    include.setCanOverlap(canOverlap.getValue());
                    shr = share.toInteger();
                    include.setShare(shr == null ? 0 : shr);
                    include.setOwnerId(clazz.getId());
                    include.setLead(lead.getValue());
                    include.setCommon(common.getValue());
                    ((TeachingRequestInterface.SingleRequest)r).addClass(include);
                }
                if (((TeachingRequestInterface.SingleRequest)r).getClasses().isEmpty() && !r.isAssignCoordinator()) {
                    return null;
                }
                ret = r;
            } else {
                if (this.iSubpart.getSelectedIndex() == 0) {
                    return null;
                }
                r = new TeachingRequestInterface.MultiRequest();
                r.setAssignCoordinator(false);
                r.setPercentShare(0);
                for (i = 1; i < this.iClasses.getRowCount(); ++i) {
                    TeachingRequestInterface.RequestedClass old;
                    clazz = this.iClasses.getData(i);
                    if (clazz == null || (select = (NumberBox)this.iClasses.getWidget(i, 0)).toInteger() == null || select.toInteger() <= 0) continue;
                    TeachingRequestInterface.RequestedClass rc = new TeachingRequestInterface.RequestedClass();
                    rc.setClassId(clazz.getId());
                    rc.setNbrInstructors(select.toInteger());
                    if (this.iRequest != null && this.iRequest instanceof TeachingRequestInterface.MultiRequest && (old = ((TeachingRequestInterface.MultiRequest)this.iRequest).getClass(clazz.getId())) != null) {
                        rc.setInstructorIds(old.getInstructorIds());
                        rc.setRequestId(old.getRequestId());
                    }
                    ((TeachingRequestInterface.MultiRequest)r).addClass(rc);
                }
                for (i = 1; i < this.iSubparts.getRowCount(); ++i) {
                    ReservationInterface.Subpart subpart = this.iSubparts.getData(i);
                    if (subpart == null || !(select = (CheckBox)this.iSubparts.getWidget(i, 0)).getValue().booleanValue()) continue;
                    assign = (CheckBox)this.iSubparts.getWidget(i, 2);
                    share = (NumberBox)this.iSubparts.getWidget(i, 3);
                    lead = (CheckBox)this.iSubparts.getWidget(i, 4);
                    canOverlap = (CheckBox)this.iSubparts.getWidget(i, 5);
                    common = (CheckBox)this.iSubparts.getWidget(i, 6);
                    include = new TeachingRequestInterface.IncludeLine();
                    include.setAssign(assign.getValue());
                    include.setCanOverlap(canOverlap.getValue());
                    shr = share.toInteger();
                    include.setShare(shr == null ? 0 : shr);
                    include.setOwnerId(subpart.getId());
                    include.setLead(lead.getValue());
                    include.setCommon(common.getValue());
                    ((TeachingRequestInterface.MultiRequest)r).addSubpart(include);
                }
                if (((TeachingRequestInterface.MultiRequest)r).getClasses().isEmpty() || ((TeachingRequestInterface.MultiRequest)r).getSubparts().isEmpty()) {
                    return null;
                }
                ret = r;
            }
            Double tl = this.iTeachingLoad.toDouble();
            ret.setTeachingLoad(tl == null ? 0.0f : tl.floatValue());
            if (this.iResponsibility != null && this.iResponsibility.getSelectedIndex() > 0) {
                ret.setTeachingResponsibility(SetupTeachingRequestsPage.this.iProperties.getResponsibility(Long.valueOf(this.iResponsibility.getSelectedValue())));
            }
            ret.setSameCoursePreference(Long.valueOf(this.iSameCouse.getSelectedValue()));
            ret.setSameCommonPreference(Long.valueOf(this.iSameCommon.getSelectedValue()));
            if (this.iAttributes != null) {
                for (UniTimeTable<TeachingRequestInterface.Preference> attributes : this.iAttributes.values()) {
                    for (int i2 = 0; i2 < attributes.getRowCount(); ++i2) {
                        ListBox attribute = (ListBox)attributes.getWidget(i2, 0);
                        ListBox preference = (ListBox)attributes.getWidget(i2, 1);
                        if (attribute.getSelectedIndex() <= 0) continue;
                        TeachingRequestInterface.Preference p = new TeachingRequestInterface.Preference();
                        p.setPreferenceId(Long.valueOf(preference.getSelectedValue()));
                        p.setOwnerId(Long.valueOf(attribute.getSelectedValue()));
                        ret.addAttributePreference(p);
                    }
                }
            }
            if (this.iInstructors != null) {
                for (int i3 = 0; i3 < this.iInstructors.getRowCount(); ++i3) {
                    ListBox instructor = (ListBox)this.iInstructors.getWidget(i3, 0);
                    ListBox preference = (ListBox)this.iInstructors.getWidget(i3, 1);
                    if (instructor.getSelectedIndex() <= 0) continue;
                    TeachingRequestInterface.Preference p = new TeachingRequestInterface.Preference();
                    p.setPreferenceId(Long.valueOf(preference.getSelectedValue()));
                    p.setOwnerId(Long.valueOf(instructor.getSelectedValue()));
                    ret.addInstructorPreference(p);
                }
            }
            return ret;
        }
    }
}

