/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.events;

import com.google.gwt.aria.client.Id;
import com.google.gwt.aria.client.Roles;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.event.dom.client.HasAllFocusHandlers;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.HasValue;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.unitime.timetable.gwt.client.aria.AriaStatus;
import org.unitime.timetable.gwt.client.aria.AriaTextBox;
import org.unitime.timetable.gwt.client.aria.HasAriaLabel;
import org.unitime.timetable.gwt.client.events.SingleDateSelector;
import org.unitime.timetable.gwt.client.widgets.UniTimeWidget;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtAriaMessages;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.AcademicSessionProvider;
import org.unitime.timetable.gwt.shared.EventInterface;

public class SessionDatesSelector
extends Composite
implements HasValue<List<Date>>,
Focusable {
    private static final GwtAriaMessages ARIA = (GwtAriaMessages)GWT.create(GwtAriaMessages.class);
    private static final GwtConstants CONSTANTS = (GwtConstants)GWT.create(GwtConstants.class);
    private static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private static final GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    AcademicSessionProvider iAcademicSession;
    UniTimeWidget<DatesPanel> iPanel;
    private int iSessionYear = 1900;
    private boolean iCanSelectPast = false;

    public SessionDatesSelector(AcademicSessionProvider session) {
        this.iAcademicSession = session;
        this.iPanel = new UniTimeWidget<DatesPanel>(new DatesPanel());
        this.initWidget((Widget)this.iPanel);
        this.iAcademicSession.addAcademicSessionChangeHandler(new AcademicSessionProvider.AcademicSessionChangeHandler(){

            @Override
            public void onAcademicSessionChange(AcademicSessionProvider.AcademicSessionChangeEvent event) {
                if (event.isChanged()) {
                    SessionDatesSelector.this.init(event.getNewAcademicSessionId());
                }
            }
        });
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                SessionDatesSelector.this.init(SessionDatesSelector.this.iAcademicSession.getAcademicSessionId());
            }
        });
    }

    public SessionDatesSelector(List<EventInterface.SessionMonth> months) {
        this.iPanel = new UniTimeWidget<DatesPanel>(new DatesPanel());
        this.initWidget((Widget)this.iPanel);
        this.init(months);
    }

    public boolean isCanSelectPast() {
        return this.iCanSelectPast;
    }

    public void setCanSelectPast(boolean canSelectPast) {
        this.iCanSelectPast = canSelectPast;
    }

    public void init(Long sessionId) {
        if (sessionId == null) {
            this.iPanel.setHint(MESSAGES.hintNoSession());
        } else {
            this.iPanel.setHint(MESSAGES.waitLoadingDataForSession(this.iAcademicSession.getAcademicSessionName()));
            RPC.execute(new EventInterface.RequestSessionDetails(sessionId), new AsyncCallback<GwtRpcResponseList<EventInterface.SessionMonth>>(){

                public void onFailure(Throwable caught) {
                    SessionDatesSelector.this.iPanel.setErrorHint(caught.getMessage());
                }

                public void onSuccess(GwtRpcResponseList<EventInterface.SessionMonth> result) {
                    SessionDatesSelector.this.iPanel.clearHint();
                    SessionDatesSelector.this.init(result);
                }
            });
        }
    }

    public void init(List<EventInterface.SessionMonth> months) {
        this.iPanel.getWidget().clear();
        int firstOutside = -1;
        int start = -1;
        int end = -1;
        int finals = -1;
        int midterms = -1;
        int firstHoliday = -1;
        int firstBreak = -1;
        int today = -1;
        int firstPast = -1;
        int firstEventDate = -1;
        int firstClassDate = -1;
        int idx = 0;
        P lastWeek = null;
        for (EventInterface.SessionMonth month : months) {
            SingleMonth m = new SingleMonth(month, this.isCanSelectPast(), idx++, lastWeek);
            lastWeek = m.getWeeks().get(m.getWeeks().size() - 1);
            if (lastWeek.getDays().size() == 7) {
                lastWeek = null;
            }
            this.iPanel.getWidget().add((Widget)m);
            if (start < 0) {
                start = month.getFirst(EventInterface.SessionMonth.Flag.START);
            }
            if (end < 0) {
                end = month.getFirst(EventInterface.SessionMonth.Flag.END);
            }
            if (finals < 0) {
                finals = month.getFirst(EventInterface.SessionMonth.Flag.FINALS);
            }
            if (midterms < 0) {
                midterms = month.getFirst(EventInterface.SessionMonth.Flag.MIDTERMS);
            }
            if (firstHoliday < 0) {
                firstHoliday = month.getFirst(EventInterface.SessionMonth.Flag.HOLIDAY);
            }
            if (firstBreak < 0) {
                firstBreak = month.getFirst(EventInterface.SessionMonth.Flag.BREAK);
            }
            if (firstOutside < 0) {
                firstOutside = month.getFirst(EventInterface.SessionMonth.Flag.DISABLED);
            }
            if (firstPast < 0) {
                firstPast = month.getFirst(EventInterface.SessionMonth.Flag.PAST);
            }
            if (firstEventDate < 0) {
                firstEventDate = month.getFirst(EventInterface.SessionMonth.Flag.DATE_MAPPING_EVENT);
            }
            if (firstClassDate < 0) {
                firstClassDate = month.getFirst(EventInterface.SessionMonth.Flag.DATE_MAPPING_CLASS);
            }
            if (month.getYear() == Integer.parseInt(DateTimeFormat.getFormat((String)"yyyy").format(new Date())) && month.getMonth() + 1 == Integer.parseInt(DateTimeFormat.getFormat((String)"MM").format(new Date()))) {
                today = Integer.parseInt(DateTimeFormat.getFormat((String)"dd").format(new Date()));
            }
            if (month.getFirst(EventInterface.SessionMonth.Flag.START) < 0) continue;
            this.iSessionYear = month.getYear();
        }
        this.iPanel.getWidget().add((Widget)new Legend(firstOutside, start, finals, midterms, firstHoliday, firstBreak, this.iCanSelectPast ? -1 : firstPast, today, firstClassDate, firstEventDate));
        this.iPanel.getWidget().setCursor(new Date());
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<List<Date>> handler) {
        return this.addHandler((EventHandler)handler, ValueChangeEvent.getType());
    }

    private int dayOfYear(int year, int month, int day) {
        int dayOfYear = SingleDateSelector.dayOfYear(year, month, day);
        if (year < this.iSessionYear) {
            dayOfYear -= SingleDateSelector.dayOfYear(year, 12, 31);
        } else if (year > this.iSessionYear) {
            dayOfYear += SingleDateSelector.dayOfYear(this.iSessionYear, 12, 31);
        }
        return dayOfYear;
    }

    public List<Date> getValue() {
        ArrayList<Date> ret = new ArrayList<Date>();
        DateTimeFormat df = DateTimeFormat.getFormat((String)"yyyy/MM/dd");
        for (int i = 0; i < this.iPanel.getWidget().getWidgetCount(); ++i) {
            Widget w = this.iPanel.getWidget().getWidget(i);
            if (!(w instanceof SingleMonth)) continue;
            SingleMonth s = (SingleMonth)w;
            for (D d : s.getDays()) {
                if (!d.getValue().booleanValue()) continue;
                ret.add(df.parse(s.getYear() + "/" + (1 + s.getMonth()) + "/" + (1 + d.getNumber())));
            }
        }
        return ret;
    }

    public int getSelectedDaysCount() {
        int ret = 0;
        for (int i = 0; i < this.iPanel.getWidget().getWidgetCount(); ++i) {
            Widget w = this.iPanel.getWidget().getWidget(i);
            if (!(w instanceof SingleMonth)) continue;
            SingleMonth s = (SingleMonth)w;
            for (D d : s.getDays()) {
                if (!d.getValue().booleanValue()) continue;
                ++ret;
            }
        }
        return ret;
    }

    public List<Integer> getSelectedDays() {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        for (int i = 0; i < this.iPanel.getWidget().getWidgetCount(); ++i) {
            Widget w = this.iPanel.getWidget().getWidget(i);
            if (!(w instanceof SingleMonth)) continue;
            SingleMonth s = (SingleMonth)w;
            for (D d : s.getDays()) {
                if (!d.getValue().booleanValue()) continue;
                ret.add(this.dayOfYear(s.getYear(), 1 + s.getMonth(), 1 + d.getNumber()));
            }
        }
        return ret;
    }

    public Date getDate(int day) {
        return SingleDateSelector.dayOfYear(this.iSessionYear, day);
    }

    public void setValue(List<Date> value) {
        this.setValue(value, false);
    }

    public void setValue(List<Date> value, boolean fireEvents) {
        for (int i = 0; i < this.iPanel.getWidget().getWidgetCount(); ++i) {
            Widget w = this.iPanel.getWidget().getWidget(i);
            if (!(w instanceof SingleMonth)) continue;
            SingleMonth s = (SingleMonth)w;
            for (D d : s.getDays()) {
                d.setValue(false);
            }
            if (value == null) continue;
            for (Date date : value) {
                if (s.getYear() != Integer.parseInt(DateTimeFormat.getFormat((String)"yyyy").format(date)) || s.getMonth() + 1 != Integer.parseInt(DateTimeFormat.getFormat((String)"MM").format(date))) continue;
                s.get(Integer.parseInt(DateTimeFormat.getFormat((String)"dd").format(date)) - 1).setValue(true);
            }
        }
        if (fireEvents) {
            ValueChangeEvent.fire((HasValueChangeHandlers)this, (Object)this.getValue());
        }
    }

    public void clearMessage() {
        this.iPanel.clearHint();
    }

    public void setMessage(String message) {
        this.iPanel.setHint(message);
    }

    public void setError(String message) {
        this.iPanel.setErrorHint(message);
    }

    public boolean isEnabled(Date date) {
        int year = Integer.parseInt(DateTimeFormat.getFormat((String)"yyyy").format(date));
        int month = Integer.parseInt(DateTimeFormat.getFormat((String)"MM").format(date));
        int day = Integer.parseInt(DateTimeFormat.getFormat((String)"dd").format(date));
        for (int i = 0; i < this.iPanel.getWidget().getWidgetCount(); ++i) {
            SingleMonth s;
            Widget w = this.iPanel.getWidget().getWidget(i);
            if (!(w instanceof SingleMonth) || (s = (SingleMonth)w).getYear() != year || s.getMonth() + 1 != month) continue;
            return s.get(day - 1).isEnabled();
        }
        return false;
    }

    public boolean hasFlag(Date date, EventInterface.SessionMonth.Flag flag) {
        int year = Integer.parseInt(DateTimeFormat.getFormat((String)"yyyy").format(date));
        int month = Integer.parseInt(DateTimeFormat.getFormat((String)"MM").format(date));
        int day = Integer.parseInt(DateTimeFormat.getFormat((String)"dd").format(date));
        for (int i = 0; i < this.iPanel.getWidget().getWidgetCount(); ++i) {
            SingleMonth s;
            Widget w = this.iPanel.getWidget().getWidget(i);
            if (!(w instanceof SingleMonth) || (s = (SingleMonth)w).getYear() != year || s.getMonth() + 1 != month) continue;
            return s.get(day - 1).hasFlag(flag);
        }
        return false;
    }

    public int getTabIndex() {
        return this.iPanel.getWidget().getTabIndex();
    }

    public void setAccessKey(char key) {
        this.iPanel.getWidget().setAccessKey(key);
    }

    public void setFocus(boolean focused) {
        this.iPanel.getWidget().setFocus(focused);
    }

    public void setTabIndex(int index) {
        this.iPanel.getWidget().setTabIndex(index);
    }

    public static class DatesPanel
    extends AbsolutePanel
    implements Focusable,
    HasAllFocusHandlers {
        private int iMonth = -1;
        private int iDow = -1;
        private int iWeek = -1;
        private AriaTextBox iText = null;
        private boolean iHasFocus = false;

        public DatesPanel() {
            this.setStyleName("unitime-DateSelector");
            this.iText = new AriaTextBox();
            this.iText.addStyleName("text");
            this.iText.addKeyUpHandler(new KeyUpHandler(){

                public void onKeyUp(KeyUpEvent event) {
                    switch (event.getNativeKeyCode()) {
                        case 39: {
                            this.moveLeftOrRight(false);
                            break;
                        }
                        case 37: {
                            this.moveLeftOrRight(true);
                            break;
                        }
                        case 38: {
                            this.moveUpOrDown(true);
                            break;
                        }
                        case 40: {
                            this.moveUpOrDown(false);
                            break;
                        }
                        case 32: {
                            if (!iText.getValue().isEmpty()) break;
                            this.select();
                            break;
                        }
                        case 13: {
                            if (!iText.getValue().isEmpty() && this.parseText(iText.getValue(), true)) break;
                            this.select();
                        }
                    }
                }
            });
            this.iText.addKeyDownHandler(new KeyDownHandler(){

                public void onKeyDown(KeyDownEvent event) {
                    switch (event.getNativeEvent().getKeyCode()) {
                        case 37: 
                        case 38: 
                        case 39: 
                        case 40: {
                            event.preventDefault();
                        }
                    }
                }
            });
            this.iText.addKeyPressHandler(new KeyPressHandler(){

                public void onKeyPress(KeyPressEvent event) {
                    switch (event.getNativeEvent().getKeyCode()) {
                        case 32: {
                            if (iText.getValue().isEmpty()) {
                                event.preventDefault();
                            }
                            return;
                        }
                        case 13: {
                            event.preventDefault();
                            return;
                        }
                    }
                    Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                        public void execute() {
                            this.parseText(iText.getValue(), false);
                        }
                    });
                }
            });
            this.iText.addFocusHandler(new FocusHandler(){

                public void onFocus(FocusEvent event) {
                    iHasFocus = true;
                    String selection = this.toAriaString();
                    if (iMonth >= 0) {
                        this.addCursorStyleName(iMonth, iDow, iWeek);
                        if (selection.isEmpty()) {
                            iText.setAriaLabel(ARIA.datesSelectionNoSelection(iText.getAriaLabel()));
                        } else {
                            iText.setAriaLabel(ARIA.datesSelectionWithSelection(selection, iText.getAriaLabel()));
                        }
                    } else if (selection.isEmpty()) {
                        iText.setAriaLabel(ARIA.datesSelection());
                    } else {
                        iText.setAriaLabel(ARIA.datesSelectionWithSelectionNoCursor(selection));
                    }
                }
            });
            this.iText.addBlurHandler(new BlurHandler(){

                public void onBlur(BlurEvent event) {
                    if (iMonth >= 0) {
                        this.removeCursorStyleName(iMonth, iDow, iWeek);
                    }
                    iHasFocus = false;
                }
            });
            this.add((Widget)this.iText);
            this.sinkEvents(4);
        }

        public void onBrowserEvent(Event event) {
            switch (DOM.eventGetType((Event)event)) {
                case 4: {
                    if (this.iHasFocus) break;
                    this.iText.setFocus(true);
                }
            }
        }

        public void clear() {
            super.clear();
            this.iMonth = -1;
            this.iDow = -1;
            this.iWeek = -1;
            this.add((Widget)this.iText);
        }

        private void setCursor(Date date) {
            int dateYear = Integer.parseInt(DateTimeFormat.getFormat((String)"yyyy").format(date));
            int dateMonth = Integer.parseInt(DateTimeFormat.getFormat((String)"MM").format(date)) - 1;
            int dateDay = Integer.parseInt(DateTimeFormat.getFormat((String)"dd").format(new Date())) - 1;
            SingleMonth lastMonth = null;
            for (int i = 0; i < this.getWidgetCount() - 2; ++i) {
                if (!(this.getWidget(1 + i) instanceof SingleMonth)) continue;
                SingleMonth m = (SingleMonth)this.getWidget(1 + i);
                if (i == 0 && dateYear < m.getYear() || dateYear == m.getYear() && dateMonth < m.getMonth()) {
                    D last = null;
                    for (D d : m.getDays()) {
                        if (!d.isEnabled()) continue;
                        last = d;
                    }
                    if (last != null) {
                        this.iMonth = i;
                        this.iDow = last.getDow();
                        this.iWeek = last.getWeek();
                        last.addStyleName("cursor");
                        return;
                    }
                }
                if (m.getYear() == dateYear && m.getMonth() == dateMonth) {
                    D d = m.getDays().get(dateDay);
                    if (d.isEnabled()) {
                        this.iMonth = i;
                        this.iDow = d.getDow();
                        this.iWeek = d.getWeek();
                        d.addStyleName("cursor");
                        return;
                    }
                    D first = null;
                    D last = null;
                    for (D x : m.getDays()) {
                        if (!x.isEnabled()) continue;
                        if (first == null) {
                            first = x;
                        }
                        last = x;
                    }
                    if (first != null && dateDay < first.getNumber()) {
                        this.iMonth = i;
                        this.iDow = first.getDow();
                        this.iWeek = first.getWeek();
                        first.addStyleName("cursor");
                        return;
                    }
                    if (last != null) {
                        this.iMonth = i;
                        this.iDow = last.getDow();
                        this.iWeek = last.getWeek();
                        last.addStyleName("cursor");
                        return;
                    }
                }
                lastMonth = m;
            }
            D last = null;
            for (D d : lastMonth.getDays()) {
                if (!d.isEnabled()) continue;
                last = d;
            }
            if (last != null) {
                this.iMonth = this.getWidgetIndex((Widget)lastMonth) - 1;
                this.iDow = last.getDow();
                this.iWeek = last.getWeek();
                last.addStyleName("cursor");
                return;
            }
        }

        public void setCursor(int ... cursor) {
            if (this.iMonth >= 0) {
                this.removeCursorStyleName(this.iMonth, this.iDow, this.iWeek);
            }
            if (cursor == null) {
                this.iMonth = -1;
                this.iDow = -1;
                this.iWeek = -1;
            } else {
                this.iMonth = cursor[0];
                this.iDow = cursor[1];
                this.iWeek = cursor[2];
                if (this.iMonth >= 0) {
                    this.addCursorStyleName(this.iMonth, this.iDow, this.iWeek);
                }
            }
        }

        private void addCursorStyleName(int month, int dow, int week) {
            if (!this.iHasFocus) {
                return;
            }
            SingleMonth m = (SingleMonth)this.getWidget(1 + month);
            if (dow >= 0) {
                if (week >= 0) {
                    for (D d : m.getDays()) {
                        if (d.getWeek() != week || d.getDow() != dow) continue;
                        d.addStyleName("cursor");
                        this.iText.setAriaLabel(d.getValue() != false ? ARIA.datesSelected(d.getAriaLabel()) : d.getAriaLabel());
                    }
                } else {
                    P p = m.getDays((7 - SingleDateSelector.startingDayOfWeek() + dow) % 7);
                    p.addStyleName("cursor");
                    this.iText.setAriaLabel(p.getAriaLabel());
                }
            } else if (week >= 0) {
                P p = m.getWeeks().get(week);
                p.addStyleName("cursor");
                this.iText.setAriaLabel(p.getAriaLabel());
            } else {
                P p = m.getCorner();
                p.addStyleName("cursor");
                this.iText.setAriaLabel(p.getAriaLabel());
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private String getAriaString(int month, int dow, int week) {
            SingleMonth m = (SingleMonth)this.getWidget(1 + month);
            if (dow >= 0) {
                D d;
                if (week < 0) {
                    P p = m.getDays((7 - SingleDateSelector.startingDayOfWeek() + dow) % 7);
                    return p.getAriaLabel();
                }
                Iterator<D> iterator = m.getDays().iterator();
                do {
                    if (iterator.hasNext()) continue;
                    return "";
                } while ((d = iterator.next()).getWeek() != week || d.getDow() != dow);
                return d.getAriaLabel();
            }
            if (week >= 0) {
                P p = m.getWeeks().get(week);
                return p.getAriaLabel();
            }
            P p = m.getCorner();
            return p.getAriaLabel();
        }

        private void removeCursorStyleName(int month, int dow, int week) {
            SingleMonth m = (SingleMonth)this.getWidget(1 + month);
            if (dow >= 0) {
                if (week >= 0) {
                    for (D d : m.getDays()) {
                        if (d.getWeek() != week || d.getDow() != dow) continue;
                        d.removeStyleName("cursor");
                    }
                } else {
                    m.getDays((7 - SingleDateSelector.startingDayOfWeek() + dow) % 7).removeStyleName("cursor");
                }
            } else if (week >= 0) {
                m.getWeeks().get(week).removeStyleName("cursor");
            } else {
                m.getCorner().removeStyleName("cursor");
            }
        }

        private void moveUpOrDown(boolean up) {
            if (this.iMonth >= 0) {
                this.removeCursorStyleName(this.iMonth, this.iDow, this.iWeek);
            } else {
                block0: for (int i = 0; i < this.getWidgetCount() - 2; ++i) {
                    if (!(this.getWidget(1 + i) instanceof SingleMonth)) continue;
                    SingleMonth m = (SingleMonth)this.getWidget(1 + i);
                    for (D d : m.getDays()) {
                        if (!d.isEnabled()) continue;
                        this.iDow = d.getDow();
                        if (up) continue;
                        break block0;
                    }
                }
            }
            int[] first = null;
            int[] last = null;
            int[] current = null;
            int[] previous = null;
            int[] next = null;
            int startingDayOfWeek = SingleDateSelector.startingDayOfWeek();
            for (int x = -1; x < 7; ++x) {
                int k = x < 0 ? x : (x + startingDayOfWeek) % 7;
                for (int i = 0; i < this.getWidgetCount() - 2; ++i) {
                    if (!(this.getWidget(1 + i) instanceof SingleMonth)) continue;
                    SingleMonth m = (SingleMonth)this.getWidget(1 + i);
                    for (int j = -1; j < m.getWeeks().size(); ++j) {
                        boolean enabled = false;
                        for (D d : m.getDays()) {
                            if (j != -1 && j != d.getWeek() || k != -1 && k != d.getDow() || !d.isEnabled()) continue;
                            enabled = true;
                            break;
                        }
                        if (enabled && first == null) {
                            first = new int[]{i, j, k};
                        }
                        if (enabled) {
                            last = new int[]{i, j, k};
                        }
                        if (i == this.iMonth && j == this.iWeek && k == this.iDow) {
                            current = new int[]{i, j, k};
                            continue;
                        }
                        if (current == null) {
                            if (!enabled) continue;
                            previous = new int[]{i, j, k};
                            continue;
                        }
                        if (next != null || !enabled) continue;
                        next = new int[]{i, j, k};
                    }
                }
            }
            if (up) {
                if (previous != null) {
                    this.iMonth = previous[0];
                    this.iWeek = previous[1];
                    this.iDow = previous[2];
                } else {
                    this.iMonth = last[0];
                    this.iWeek = last[1];
                    this.iDow = last[2];
                }
            } else if (next != null) {
                this.iMonth = next[0];
                this.iWeek = next[1];
                this.iDow = next[2];
            } else {
                this.iMonth = first[0];
                this.iWeek = first[1];
                this.iDow = first[2];
            }
            this.addCursorStyleName(this.iMonth, this.iDow, this.iWeek);
        }

        private void moveLeftOrRight(boolean left) {
            if (this.iMonth >= 0) {
                this.removeCursorStyleName(this.iMonth, this.iDow, this.iWeek);
            } else {
                for (int i = 0; i < this.getWidgetCount() - 2; ++i) {
                    if (!(this.getWidget(i) instanceof SingleMonth)) continue;
                    SingleMonth m = (SingleMonth)this.getWidget(1 + i);
                    boolean enabled = false;
                    for (D d : m.getDays()) {
                        if (!d.isEnabled()) continue;
                        enabled = true;
                        break;
                    }
                    if (!enabled) continue;
                    this.iMonth = i;
                    if (!left) break;
                }
            }
            int[] first = null;
            int[] last = null;
            int[] current = null;
            int[] previous = null;
            int[] next = null;
            int startingDayOfWeek = SingleDateSelector.startingDayOfWeek();
            for (int i = 0; i < this.getWidgetCount() - 2; ++i) {
                if (!(this.getWidget(1 + i) instanceof SingleMonth)) continue;
                SingleMonth m = (SingleMonth)this.getWidget(1 + i);
                for (int j = -1; j < m.getWeeks().size(); ++j) {
                    for (int x = -1; x < 7; ++x) {
                        int k = x < 0 ? x : (x + startingDayOfWeek) % 7;
                        boolean enabled = false;
                        for (D d : m.getDays()) {
                            if (j != -1 && j != d.getWeek() || k != -1 && k != d.getDow() || !d.isEnabled()) continue;
                            enabled = true;
                            break;
                        }
                        if (enabled && first == null) {
                            first = new int[]{i, j, k};
                        }
                        if (enabled) {
                            last = new int[]{i, j, k};
                        }
                        if (i == this.iMonth && j == this.iWeek && k == this.iDow) {
                            current = new int[]{i, j, k};
                            continue;
                        }
                        if (current == null) {
                            if (!enabled) continue;
                            previous = new int[]{i, j, k};
                            continue;
                        }
                        if (next != null || !enabled) continue;
                        next = new int[]{i, j, k};
                    }
                }
            }
            if (left) {
                if (previous != null) {
                    this.iMonth = previous[0];
                    this.iWeek = previous[1];
                    this.iDow = previous[2];
                } else {
                    this.iMonth = last[0];
                    this.iWeek = last[1];
                    this.iDow = last[2];
                }
            } else if (next != null) {
                this.iMonth = next[0];
                this.iWeek = next[1];
                this.iDow = next[2];
            } else {
                this.iMonth = first[0];
                this.iWeek = first[1];
                this.iDow = first[2];
            }
            this.addCursorStyleName(this.iMonth, this.iDow, this.iWeek);
        }

        private boolean hasUnselectedDays(SelectionMode mode) {
            if (this.iMonth < 0) {
                return false;
            }
            SingleMonth m = (SingleMonth)this.getWidget(1 + this.iMonth);
            for (D d : m.getDays()) {
                if (this.iWeek != -1 && this.iWeek != d.getWeek() || this.iDow != -1 && this.iDow != d.getDow() || !d.isEnabled() || !mode.hasFlag(SelectionFlag.IncludeNoClasses) && !d.isClassDay() || !mode.hasFlag(SelectionFlag.IncludePast) && d.isPast() || !mode.hasFlag(SelectionFlag.IncludeWeekend) && d.isWeekend() || !mode.hasFlag(SelectionFlag.IncludeVacation) && d.isVacation() || d.getValue().booleanValue()) continue;
                return true;
            }
            return false;
        }

        public void setAllSelected(boolean selected, SelectionMode mode) {
            if (this.iMonth < 0) {
                return;
            }
            SingleMonth m = (SingleMonth)this.getWidget(1 + this.iMonth);
            boolean skipNoClass = false;
            boolean skipPast = false;
            boolean skipVacation = false;
            boolean skipWeekend = false;
            if (this.iWeek < 0) {
                for (D d : m.getDays()) {
                    if (this.iWeek != -1 && this.iWeek != d.getWeek() || this.iDow != -1 && this.iDow != d.getDow() || !d.isEnabled()) continue;
                    if (!mode.hasFlag(SelectionFlag.IncludeNoClasses) && !d.isClassDay()) {
                        skipNoClass = true;
                        continue;
                    }
                    if (!mode.hasFlag(SelectionFlag.IncludePast) && d.isPast()) {
                        skipPast = true;
                        continue;
                    }
                    if (!mode.hasFlag(SelectionFlag.IncludeWeekend) && d.isWeekend()) {
                        skipWeekend = true;
                        continue;
                    }
                    if (!mode.hasFlag(SelectionFlag.IncludeVacation) && d.isVacation()) {
                        skipVacation = true;
                        continue;
                    }
                    d.setValue(selected, true);
                }
            } else {
                for (D d : m.getWeeks().get(this.iWeek).getDays()) {
                    if (this.iDow != -1 && this.iDow != d.getDow() || !d.isEnabled()) continue;
                    if (!mode.hasFlag(SelectionFlag.IncludeNoClasses) && !d.isClassDay()) {
                        skipNoClass = true;
                        continue;
                    }
                    if (!mode.hasFlag(SelectionFlag.IncludePast) && d.isPast()) {
                        skipPast = true;
                        continue;
                    }
                    if (!mode.hasFlag(SelectionFlag.IncludeWeekend) && d.isWeekend()) {
                        skipWeekend = true;
                        continue;
                    }
                    if (!mode.hasFlag(SelectionFlag.IncludeVacation) && d.isVacation()) {
                        skipVacation = true;
                        continue;
                    }
                    d.setValue(selected, true);
                }
            }
            String aria = this.getAriaString(this.iMonth, this.iDow, this.iWeek);
            if (selected) {
                if (this.iDow < 0 || this.iWeek < 0) {
                    if (!mode.hasFlag(SelectionFlag.IncludeNoClasses) && skipNoClass) {
                        if (mode.hasFlag(SelectionFlag.IncludePast) || !skipPast) {
                            AriaStatus.getInstance().setHTML(ARIA.datesSelectedAllClassDays(aria));
                        } else {
                            AriaStatus.getInstance().setHTML(ARIA.datesSelectedAllClassDaysFuture(aria));
                        }
                    } else if (mode.hasFlag(SelectionFlag.IncludeWeekend) || !skipWeekend) {
                        if (mode.hasFlag(SelectionFlag.IncludeVacation) || !skipVacation) {
                            AriaStatus.getInstance().setHTML(ARIA.datesSelectedAll(aria));
                        } else {
                            AriaStatus.getInstance().setHTML(ARIA.datesSelectedAllButVacations(aria));
                        }
                    } else if (mode.hasFlag(SelectionFlag.IncludePast) || !skipPast) {
                        AriaStatus.getInstance().setHTML(ARIA.datesSelectedWorkDays(aria));
                    } else {
                        AriaStatus.getInstance().setHTML(ARIA.datesSelectedWorkDaysFuture(aria));
                    }
                } else {
                    AriaStatus.getInstance().setHTML(ARIA.datesSelected(aria));
                }
            } else {
                AriaStatus.getInstance().setHTML(ARIA.datesUnselected(aria));
            }
        }

        private void select() {
            this.iText.setValue("");
            SelectionMode mode = null;
            for (SelectionMode m : SelectionMode.values()) {
                if (!this.hasUnselectedDays(m)) continue;
                mode = m;
                break;
            }
            if (mode != null) {
                this.setAllSelected(true, mode);
            } else {
                this.setAllSelected(false, SelectionMode.All);
            }
        }

        private void select(List<D> days) {
            this.iText.setValue("");
            String aria = "";
            boolean unselected = false;
            for (D d : days) {
                if (d.getValue().booleanValue()) continue;
                unselected = true;
                break;
            }
            for (D d : days) {
                d.setValue(unselected, true);
                if (!aria.isEmpty()) {
                    aria = aria + ", ";
                }
                aria = aria + d.getAriaLabel();
            }
            if (unselected) {
                AriaStatus.getInstance().setHTML(ARIA.datesSelected(aria));
            } else {
                AriaStatus.getInstance().setHTML(ARIA.datesUnselected(aria));
            }
        }

        private String toAriaString() {
            String aria = "";
            for (int i = 0; i < this.getWidgetCount() - 2; ++i) {
                if (!(this.getWidget(1 + i) instanceof SingleMonth)) continue;
                SingleMonth m = (SingleMonth)this.getWidget(1 + i);
                for (D d : m.getDays()) {
                    if (!d.getValue().booleanValue()) continue;
                    if (!aria.isEmpty()) {
                        aria = aria + ", ";
                    }
                    aria = aria + d.getAriaLabel();
                }
            }
            return aria;
        }

        private boolean parseText(String text, boolean select) {
            String[] tokens;
            if (text == null || text.isEmpty()) {
                return false;
            }
            if (text.endsWith("?")) {
                String aria = this.toAriaString();
                if (aria.isEmpty()) {
                    AriaStatus.getInstance().setHTML(ARIA.datesNothingSelected());
                } else {
                    AriaStatus.getInstance().setHTML(ARIA.datesSelected(aria));
                }
                this.iText.setValue("");
                return false;
            }
            int pMonth = -1;
            Object pDow = -1;
            Object pWeek = -1;
            int dCnt = -1;
            boolean wk = false;
            boolean dayFirst = CONSTANTS.firstDayThenMonth();
            if (text.contains(".")) {
                dayFirst = true;
            }
            if (text.contains("/")) {
                dayFirst = false;
            }
            Integer day = null;
            block9: for (String token : tokens = text.split("[\\./\\- ]")) {
                SingleMonth m;
                if (token.isEmpty()) continue;
                if (pDow < 0) {
                    for (int d = 0; d < 7; ++d) {
                        if (!CONSTANTS.longDays()[d].toLowerCase().startsWith(token.toLowerCase())) continue;
                        pDow = d;
                        continue block9;
                    }
                }
                Integer number = null;
                try {
                    number = Integer.parseInt(token);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (day == null && number != null && tokens.length > 1 && dayFirst && pMonth < 0 && number >= 1 && number <= 31) {
                    day = number;
                    continue;
                }
                if (pMonth < 0) {
                    for (int i = 0; i < this.getWidgetCount() - 2; ++i) {
                        if (!(this.getWidget(1 + i) instanceof SingleMonth)) continue;
                        m = (SingleMonth)this.getWidget(1 + i);
                        if ((number == null || m.getMonth() + 1 != number) && !m.getName().toLowerCase().startsWith(token.toLowerCase())) continue;
                        pMonth = i;
                        if (day == null || pWeek >= 0 && pDow >= 0) continue block9;
                        Object first = null;
                        int[] last = null;
                        for (D d : m.getDays()) {
                            if (!d.isEnabled()) continue;
                            if (first == null) {
                                first = new int[]{d.getNumber(), d.getDow(), d.getWeek()};
                            }
                            last = new int[]{d.getNumber(), d.getDow(), d.getWeek()};
                            if (d.getNumber() + 1 != day) continue;
                            pWeek = d.getWeek();
                            pDow = d.getDow();
                            day = null;
                            continue block9;
                        }
                        if (first == null) continue block9;
                        if (day < first[0]) {
                            pDow = first[2];
                            pWeek = first[3];
                            continue block9;
                        }
                        pDow = last[2];
                        pWeek = last[3];
                        continue block9;
                    }
                }
                if (pMonth < 0 && number != null && day == null) {
                    for (int i = 0; i < this.getWidgetCount() - 2; ++i) {
                        if (!(this.getWidget(1 + i) instanceof SingleMonth)) continue;
                        m = (SingleMonth)this.getWidget(1 + i);
                        for (P p : m.getWeeks()) {
                            if (!p.getCaption().equals(token)) continue;
                            pMonth = i;
                            pWeek = m.getWeeks().indexOf(p);
                            wk = true;
                            continue block9;
                        }
                    }
                }
                if (pMonth >= 0 && (pWeek < 0 || pDow < 0) && number != null) {
                    SingleMonth m2 = (SingleMonth)this.getWidget(1 + pMonth);
                    int[] first = null;
                    int[] last = null;
                    for (D d : m2.getDays()) {
                        if (!d.isEnabled()) continue;
                        if (first == null) {
                            first = new int[]{d.getNumber(), d.getDow(), d.getWeek()};
                        }
                        last = new int[]{d.getNumber(), d.getDow(), d.getWeek()};
                        if (d.getNumber() + 1 != number) continue;
                        pWeek = d.getWeek();
                        pDow = d.getDow();
                        continue block9;
                    }
                    if (first != null) {
                        if (number < first[0]) {
                            pDow = first[2];
                            pWeek = first[3];
                            continue;
                        }
                        pDow = last[2];
                        pWeek = last[3];
                        continue;
                    }
                }
                if (number != null && number >= 1) {
                    dCnt = number;
                    continue;
                }
                if (token.length() < 2) continue;
                try {
                    char last = token.charAt(token.length() - 1);
                    number = Integer.parseInt(token.substring(0, token.length() - 1));
                    if (number < 1) continue;
                    switch (last) {
                        case 'x': {
                            dCnt = number;
                            break;
                        }
                        case 'w': {
                            dCnt = number;
                            wk = true;
                            break;
                        }
                        case 'd': {
                            dCnt = number;
                            wk = false;
                            break;
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            boolean cursor = false;
            if (pMonth >= 0) {
                this.setCursor(new int[]{pMonth, pDow, pWeek});
                cursor = true;
            } else if (pDow >= 0 && this.iMonth >= 0) {
                this.setCursor(new int[]{this.iMonth, pDow, pWeek});
                cursor = true;
            }
            if (select && cursor) {
                if (dCnt < 0) {
                    this.select();
                } else if (dCnt > 0) {
                    ArrayList<D> days = new ArrayList<D>();
                    boolean match = false;
                    for (int i = this.iMonth; i < this.getWidgetCount() - 2; ++i) {
                        if (!(this.getWidget(1 + i) instanceof SingleMonth)) continue;
                        SingleMonth m = (SingleMonth)this.getWidget(1 + i);
                        for (D d : m.getDays()) {
                            if (!(match || this.iDow >= 0 && d.getDow() != this.iDow || this.iWeek >= 0 && d.getWeek() != this.iWeek)) {
                                match = true;
                            }
                            if (!match || !d.isEnabled() || dCnt <= 0 || wk && d.getDow() != this.iDow) continue;
                            days.add(d);
                            --dCnt;
                        }
                    }
                    this.select(days);
                }
            }
            return cursor;
        }

        public HandlerRegistration addFocusHandler(FocusHandler handler) {
            return this.iText.addFocusHandler(handler);
        }

        public HandlerRegistration addBlurHandler(BlurHandler handler) {
            return this.iText.addBlurHandler(handler);
        }

        public int getTabIndex() {
            return this.iText.getTabIndex();
        }

        public void setAccessKey(char key) {
            this.iText.setAccessKey(key);
        }

        public void setFocus(boolean focused) {
            this.iText.setFocus(focused);
        }

        public void setTabIndex(int index) {
            this.iText.setTabIndex(index);
        }
    }

    public class Legend
    extends AbsolutePanel {
        public Legend(int firstOutside, int start, int finals, int midterms, int firstHoliday, int firstBreak, int firstPast, int today, int firstClassDate, int firstEventDate) {
            this.addStyleName("legend");
            P box = new P(null, new String[]{"box"});
            this.add((Widget)box);
            P line = new P(null, new String[]{"row"});
            line.add((Widget)new P(null, new String[]{"cell", "selected", "first"}));
            line.add((Widget)new P(MESSAGES.legendSelected(), new String[]{"title"}));
            box.add((Widget)line);
            line = new P(null, new String[]{"row"});
            line.add((Widget)new P(null, new String[]{"cell"}));
            line.add((Widget)new P(MESSAGES.legendNotSelected(), new String[]{"title"}));
            box.add((Widget)line);
            if (firstOutside >= 0) {
                line = new P(null, new String[]{"row"});
                line.add((Widget)new P(String.valueOf(firstOutside + 1), new String[]{"cell", "disabled"}));
                line.add((Widget)new P(MESSAGES.legendNotInSession(), new String[]{"title"}));
                box.add((Widget)line);
            }
            if (firstPast >= 0) {
                line = new P(null, new String[]{"row"});
                line.add((Widget)new P(String.valueOf(firstPast + 1), new String[]{"cell", "disabled", "past"}));
                line.add((Widget)new P(MESSAGES.legendPast(), new String[]{"title"}));
                box.add((Widget)line);
            }
            if (start >= 0) {
                line = new P(null, new String[]{"row"});
                line.add((Widget)new P(String.valueOf(start + 1), new String[]{"cell", "start"}));
                line.add((Widget)new P(MESSAGES.legendClassesStartOrEnd(), new String[]{"title"}));
                box.add((Widget)line);
            }
            if (finals >= 0) {
                line = new P(null, new String[]{"row"});
                line.add((Widget)new P(String.valueOf(finals + 1), new String[]{"cell", "exam"}));
                line.add((Widget)new P(MESSAGES.legendFinals(), new String[]{"title"}));
                box.add((Widget)line);
            }
            if (midterms >= 0) {
                line = new P(null, new String[]{"row"});
                line.add((Widget)new P(String.valueOf(finals + 1), new String[]{"cell", "midterm"}));
                line.add((Widget)new P(MESSAGES.legendMidterms(), new String[]{"title"}));
                box.add((Widget)line);
            }
            if (firstHoliday >= 0) {
                line = new P(null, new String[]{"row"});
                line.add((Widget)new P(String.valueOf(firstHoliday + 1), new String[]{"cell", "holiday"}));
                line.add((Widget)new P(MESSAGES.legendHoliday(), new String[]{"title"}));
                box.add((Widget)line);
            }
            if (firstBreak >= 0) {
                line = new P(null, new String[]{"row"});
                line.add((Widget)new P(String.valueOf(firstBreak + 1), new String[]{"cell", "break"}));
                line.add((Widget)new P(MESSAGES.legendBreak(), new String[]{"title"}));
                box.add((Widget)line);
            }
            if (firstClassDate >= 0) {
                line = new P(null, new String[]{"row"});
                line.add((Widget)new P(String.valueOf(firstClassDate + 1), new String[]{"cell", "classDate"}));
                line.add((Widget)new P(MESSAGES.legendDateMappingClassDate(), new String[]{"title"}));
                box.add((Widget)line);
            }
            if (firstEventDate >= 0) {
                line = new P(null, new String[]{"row"});
                line.add((Widget)new P(String.valueOf(firstEventDate + 1), new String[]{"cell", "eventDate"}));
                line.add((Widget)new P(MESSAGES.legendDateMappingEventDate(), new String[]{"title"}));
                box.add((Widget)line);
            }
            if (today >= 1) {
                line = new P(null, new String[]{"row"});
                line.add((Widget)new P(String.valueOf(today), new String[]{"cell", "today"}));
                line.add((Widget)new P(MESSAGES.legendToday(), new String[]{"title"}));
                box.add((Widget)line);
            }
        }
    }

    public class SingleMonth
    extends AbsolutePanel {
        private EventInterface.SessionMonth iSessionMonth;
        private List<D> iDays = new ArrayList<D>();
        private P[] iWeekDays = new P[7];
        private List<P> iWeeks = new ArrayList<P>();
        private P iCorner = null;

        public SingleMonth(EventInterface.SessionMonth month, boolean canSelectPast, int index, P previousWeek) {
            this.iSessionMonth = month;
            this.addStyleName("month");
            P name = new P(SingleDateSelector.monthName(this.iSessionMonth.getYear(), this.iSessionMonth.getMonth() + 1), new String[]{"label"});
            this.add((Widget)name);
            name.getElement().setId(DOM.createUniqueId());
            Roles.getGridRole().set((Element)this.getElement());
            Roles.getGridRole().setAriaLabelledbyProperty((Element)this.getElement(), new Id[]{Id.of((Element)name.getElement())});
            P box = new P(null, new String[]{"box"});
            this.add((Widget)box);
            P header = new P(null, new String[]{"row"});
            box.add((Widget)header);
            this.iCorner = new P(null, new int[]{index, -1, -1}, new String[]{"cell", "corner", "clickable"});
            this.iCorner.setAriaLabel(SingleDateSelector.monthName(this.iSessionMonth.getYear(), this.iSessionMonth.getMonth() + 1));
            header.add((Widget)this.iCorner);
            Roles.getRowheaderRole().set((Element)this.iCorner.getElement());
            int firstDayOfWeek = SingleDateSelector.firstDayOfWeek(this.iSessionMonth.getYear(), this.iSessionMonth.getMonth() + 1);
            int weekNumber = SingleDateSelector.weekNumber(this.iSessionMonth.getYear(), this.iSessionMonth.getMonth() + 1);
            int nrDays = SingleDateSelector.daysInMonth(this.iSessionMonth.getYear(), this.iSessionMonth.getMonth() + 1);
            int startDayOfWeek = SingleDateSelector.startingDayOfWeek();
            for (int i = 0; i < 7; ++i) {
                this.iWeekDays[i] = new P(CONSTANTS.days()[(i + startDayOfWeek) % 7], new int[]{index, (i + startDayOfWeek) % 7, -1}, new String[]{"cell", "dow", "clickable"});
                this.iWeekDays[i].setAriaLabel(ARIA.datesDayOfWeekSelection(CONSTANTS.longDays()[(i + startDayOfWeek) % 7], SingleDateSelector.monthName(this.iSessionMonth.getYear(), this.iSessionMonth.getMonth() + 1)));
                Roles.getColumnheaderRole().set((Element)this.iWeekDays[i].getElement());
                header.add((Widget)this.iWeekDays[i]);
            }
            P line = new P(null, new String[]{"row"});
            box.add((Widget)line);
            P week = new P(String.valueOf(weekNumber++), new int[]{index, -1, this.iWeeks.size()}, new String[]{"cell", "week", "clickable"});
            Roles.getRowheaderRole().set((Element)week.getElement());
            boolean weekAria = false;
            line.add((Widget)week);
            this.iWeeks.add(week);
            if (previousWeek != null) {
                for (D d : previousWeek.getDays()) {
                    week.addDay(d);
                }
                week.setAriaLabel(previousWeek.getAriaLabel());
                weekAria = true;
            }
            int idx = 0;
            int blanks = (firstDayOfWeek + 7 - startDayOfWeek) % 7;
            for (int i = 0; i < blanks; ++i) {
                line.add((Widget)new P(null, new String[]{"cell", i + 1 == blanks ? "last-blank" : "blank"}));
                ++idx;
            }
            int today = -1;
            if (month.getYear() == Integer.parseInt(DateTimeFormat.getFormat((String)"yyyy").format(new Date())) && month.getMonth() + 1 == Integer.parseInt(DateTimeFormat.getFormat((String)"MM").format(new Date()))) {
                today = Integer.parseInt(DateTimeFormat.getFormat((String)"dd").format(new Date())) - 1;
            }
            ValueChangeHandler<Boolean> onChange = new ValueChangeHandler<Boolean>(){

                public void onValueChange(ValueChangeEvent<Boolean> event) {
                    SingleMonth.this.fireDaySelected(((D)event.getSource()).getNumber());
                }
            };
            DateTimeFormat df = DateTimeFormat.getFormat((String)"yyyy/MM/dd");
            for (int i = 0; i < nrDays; ++i) {
                if (i > 0 && idx % 7 == 0) {
                    if (idx == 7 && this.iSessionMonth.getMonth() == 0 && weekNumber > 50) {
                        weekNumber = 1;
                    }
                    line = new P(null, new String[]{"row"});
                    box.add((Widget)line);
                    week = new P(String.valueOf(weekNumber++), new int[]{index, -1, this.iWeeks.size()}, new String[]{"cell", "week", "clickable"});
                    Roles.getRowheaderRole().set((Element)week.getElement());
                    weekAria = false;
                    line.add((Widget)week);
                    this.iWeeks.add(week);
                    previousWeek = null;
                }
                Date date = df.parse(this.getYear() + "/" + (1 + this.getMonth()) + "/" + (1 + i));
                D d = new D(i, this.iSessionMonth.getFlags(i), new int[]{index, (idx + startDayOfWeek) % 7, this.iWeeks.size() - 1}, false, new String[]{"cell", SingleDateSelector.isWeekend((idx + startDayOfWeek) % 7) ? "weekend" : "day", "clickable"});
                Roles.getGridcellRole().set((Element)d.getElement());
                line.add((Widget)d);
                d.addValueChangeHandler(onChange);
                this.iCorner.addDay(d);
                this.iWeekDays[idx % 7].addDay(d);
                if (!weekAria) {
                    week.setAriaLabel(ARIA.datesWeekSelection(weekNumber - 1, DateTimeFormat.getFormat((String)CONSTANTS.weekSelectionDateFormat()).format(date)));
                    weekAria = true;
                }
                d.setAriaLabel(DateTimeFormat.getFormat((String)CONSTANTS.dateSelectionDateFormat()).format(date));
                week.addDay(d);
                if (previousWeek != null) {
                    previousWeek.addDay(d);
                }
                this.iDays.add(d);
                ++idx;
                if (today == i) {
                    d.addStyleName("today");
                }
                if (this.iSessionMonth.hasFlag(i, EventInterface.SessionMonth.Flag.START)) {
                    d.addStyleName("start");
                    d.setAriaLabel(d.getAriaLabel() + " " + MESSAGES.legendClassesStart());
                } else if (this.iSessionMonth.hasFlag(i, EventInterface.SessionMonth.Flag.END)) {
                    d.addStyleName("start");
                    d.setAriaLabel(d.getAriaLabel() + " " + MESSAGES.legendClassesEnd());
                } else if (this.iSessionMonth.hasFlag(i, EventInterface.SessionMonth.Flag.FINALS)) {
                    d.addStyleName("exam");
                    d.setAriaLabel(d.getAriaLabel() + " " + MESSAGES.legendFinals());
                } else if (this.iSessionMonth.hasFlag(i, EventInterface.SessionMonth.Flag.MIDTERMS)) {
                    d.addStyleName("midterm");
                    d.setAriaLabel(d.getAriaLabel() + " " + MESSAGES.legendMidterms());
                } else if (this.iSessionMonth.hasFlag(i, EventInterface.SessionMonth.Flag.HOLIDAY)) {
                    d.addStyleName("holiday");
                    d.setAriaLabel(d.getAriaLabel() + " " + MESSAGES.legendHoliday());
                } else if (this.iSessionMonth.hasFlag(i, EventInterface.SessionMonth.Flag.BREAK)) {
                    d.addStyleName("break");
                    d.setAriaLabel(d.getAriaLabel() + " " + MESSAGES.legendBreak());
                }
                if (this.iSessionMonth.hasFlag(i, EventInterface.SessionMonth.Flag.DATE_MAPPING_CLASS)) {
                    d.addStyleName("classDate");
                } else if (this.iSessionMonth.hasFlag(i, EventInterface.SessionMonth.Flag.DATE_MAPPING_EVENT)) {
                    d.addStyleName("eventDate");
                }
                if (this.iSessionMonth.hasFlag(i, EventInterface.SessionMonth.Flag.SELECTED)) {
                    d.setValue(true);
                }
                if (this.iSessionMonth.hasFlag(i, EventInterface.SessionMonth.Flag.DISABLED)) {
                    d.setEnabled(false);
                }
                if (!this.iSessionMonth.hasFlag(i, EventInterface.SessionMonth.Flag.PAST)) continue;
                d.addStyleName("past");
                if (canSelectPast) continue;
                d.setEnabled(false);
            }
        }

        public D get(int day) {
            return this.iDays.get(day);
        }

        protected void fireDaySelected(int day) {
        }

        public List<P> getWeeks() {
            return this.iWeeks;
        }

        public P getDays(int dayOfWeek) {
            return this.iWeekDays[dayOfWeek];
        }

        public List<D> getDays() {
            return this.iDays;
        }

        public P getCorner() {
            return this.iCorner;
        }

        public int getYear() {
            return this.iSessionMonth.getYear();
        }

        public int getMonth() {
            return this.iSessionMonth.getMonth();
        }

        public String getName() {
            return SingleDateSelector.monthName(this.iSessionMonth.getYear(), this.iSessionMonth.getMonth() + 1);
        }
    }

    public class D
    extends AbsolutePanel
    implements HasValue<Boolean>,
    HasAriaLabel {
        private boolean iSelected = false;
        private boolean iEnabled = true;
        private int iFlag;
        private int iNumber;
        private int[] iCursor;

        private D(int number, int flag, int[] cursor, boolean selected, String ... styles) {
            this.iNumber = number;
            this.iFlag = flag;
            this.iCursor = cursor;
            this.iSelected = selected;
            this.getElement().setInnerHTML(String.valueOf(1 + number));
            for (String style : styles) {
                if (style == null || style.isEmpty()) continue;
                this.addStyleName(style);
            }
            if (this.iSelected) {
                this.addStyleName("selected");
            }
            this.sinkEvents(4);
        }

        public boolean isEnabled() {
            return this.iEnabled;
        }

        public void setEnabled(boolean enabled) {
            if (this.iEnabled == enabled) {
                return;
            }
            this.iEnabled = enabled;
            if (this.iEnabled) {
                this.addStyleName("clickable");
                this.removeStyleName("disabled");
            } else {
                this.removeStyleName("clickable");
                this.addStyleName("disabled");
            }
        }

        public boolean hasFlag(EventInterface.SessionMonth.Flag flag) {
            return (this.iFlag & flag.flag()) != 0;
        }

        public boolean isVacation() {
            return this.hasFlag(EventInterface.SessionMonth.Flag.BREAK) || this.hasFlag(EventInterface.SessionMonth.Flag.HOLIDAY);
        }

        public boolean isPast() {
            return this.hasFlag(EventInterface.SessionMonth.Flag.PAST);
        }

        public boolean isClassDay() {
            return this.hasFlag(EventInterface.SessionMonth.Flag.CLASSES);
        }

        public boolean isWeekend() {
            return SingleDateSelector.isWeekend(this.getDow());
        }

        public void onBrowserEvent(Event event) {
            switch (DOM.eventGetType((Event)event)) {
                case 4: {
                    if (this.isEnabled()) {
                        this.setValue(this.getValue() == false, true);
                        SessionDatesSelector.this.iPanel.getWidget().setCursor(this.iCursor);
                    }
                    event.preventDefault();
                }
            }
            super.onBrowserEvent(event);
        }

        public int getNumber() {
            return this.iNumber;
        }

        public int getDow() {
            return this.iCursor[1];
        }

        public int getWeek() {
            return this.iCursor[2];
        }

        public int getMonth() {
            return this.iCursor[0];
        }

        public String toString() {
            return String.valueOf(1 + this.getNumber());
        }

        public HandlerRegistration addValueChangeHandler(ValueChangeHandler<Boolean> handler) {
            return this.addHandler((EventHandler)handler, ValueChangeEvent.getType());
        }

        public Boolean getValue() {
            return this.iSelected;
        }

        public void setValue(Boolean value) {
            this.setValue(value, false);
        }

        public void setValue(Boolean value, boolean fireEvents) {
            if (this.iSelected == value || value == null || !this.isEnabled()) {
                return;
            }
            this.iSelected = value;
            if (this.iSelected) {
                this.addStyleName("selected");
            } else {
                this.removeStyleName("selected");
            }
            if (fireEvents) {
                ValueChangeEvent.fire((HasValueChangeHandlers)this, (Object)this.getValue());
            }
        }

        @Override
        public String getAriaLabel() {
            return Roles.getTextboxRole().getAriaLabelProperty((Element)this.getElement());
        }

        @Override
        public void setAriaLabel(String text) {
            if (text == null || text.isEmpty()) {
                Roles.getTextboxRole().removeAriaLabelProperty((Element)this.getElement());
            } else {
                Roles.getTextboxRole().setAriaLabelProperty((Element)this.getElement(), text);
            }
        }
    }

    public class P
    extends AbsolutePanel
    implements HasAriaLabel {
        private String iCaption;
        private int[] iCursor = null;
        private List<D> iDays = new ArrayList<D>();

        private P(String caption, int[] cursor, String ... styles) {
            this.iCaption = caption;
            this.iCursor = cursor;
            if (caption != null) {
                this.getElement().setInnerHTML(caption);
            }
            for (String style : styles) {
                if (style == null || style.isEmpty()) continue;
                this.addStyleName(style);
            }
            this.sinkEvents(4);
        }

        private P(String caption, String ... styles) {
            this(caption, (int[])null, styles);
        }

        public void addDay(D d) {
            this.iDays.add(d);
        }

        public boolean hasUnselectedDays(SelectionMode mode) {
            for (D d : this.iDays) {
                if (!d.isEnabled() || !mode.hasFlag(SelectionFlag.IncludeNoClasses) && !d.isClassDay() || !mode.hasFlag(SelectionFlag.IncludePast) && d.isPast() || !mode.hasFlag(SelectionFlag.IncludeWeekend) && d.isWeekend() || !mode.hasFlag(SelectionFlag.IncludeVacation) && d.isVacation() || d.getValue().booleanValue()) continue;
                return true;
            }
            return false;
        }

        public void setAllSelected(boolean selected, SelectionMode mode) {
            for (D d : this.iDays) {
                if (!d.isEnabled() || !mode.hasFlag(SelectionFlag.IncludeNoClasses) && !d.isClassDay() || !mode.hasFlag(SelectionFlag.IncludePast) && d.isPast() || !mode.hasFlag(SelectionFlag.IncludeWeekend) && d.isWeekend() || !mode.hasFlag(SelectionFlag.IncludeVacation) && d.isVacation()) continue;
                d.setValue(selected, true);
            }
        }

        public void onBrowserEvent(Event event) {
            switch (DOM.eventGetType((Event)event)) {
                case 4: {
                    SelectionMode mode = null;
                    for (SelectionMode m : SelectionMode.values()) {
                        if (!this.hasUnselectedDays(m)) continue;
                        mode = m;
                        break;
                    }
                    if (mode != null) {
                        this.setAllSelected(true, mode);
                    } else {
                        this.setAllSelected(false, SelectionMode.All);
                    }
                    if (this.iCursor != null) {
                        SessionDatesSelector.this.iPanel.getWidget().setCursor(this.iCursor);
                    }
                    event.preventDefault();
                }
            }
            super.onBrowserEvent(event);
        }

        public String getCaption() {
            return this.iCaption;
        }

        public List<D> getDays() {
            return this.iDays;
        }

        public String toString() {
            return this.getCaption() + " " + this.iDays;
        }

        @Override
        public String getAriaLabel() {
            return Roles.getTextboxRole().getAriaLabelProperty((Element)this.getElement());
        }

        @Override
        public void setAriaLabel(String text) {
            if (text == null || text.isEmpty()) {
                Roles.getTextboxRole().removeAriaLabelProperty((Element)this.getElement());
            } else {
                Roles.getTextboxRole().setAriaLabelProperty((Element)this.getElement(), text);
            }
        }
    }

    public static enum SelectionMode {
        FutureClassDays(new SelectionFlag[0]),
        FutureWorking(SelectionFlag.IncludeNoClasses),
        AllWorking(SelectionFlag.IncludeNoClasses, SelectionFlag.IncludePast),
        AllWorkingAndWeekend(SelectionFlag.IncludeNoClasses, SelectionFlag.IncludePast, SelectionFlag.IncludeWeekend),
        All(SelectionFlag.IncludeNoClasses, SelectionFlag.IncludePast, SelectionFlag.IncludeWeekend, SelectionFlag.IncludeVacation);

        private int iFlags = 0;

        private SelectionMode(SelectionFlag ... flags) {
            for (SelectionFlag flag : flags) {
                this.iFlags = flag.set(this.iFlags);
            }
        }

        public boolean hasFlag(SelectionFlag flag) {
            return flag.in(this.iFlags);
        }
    }

    public static enum SelectionFlag {
        IncludePast,
        IncludeWeekend,
        IncludeVacation,
        IncludeNoClasses;


        public int flag() {
            return 1 << this.ordinal();
        }

        public boolean in(int flags) {
            return (flags & this.flag()) != 0;
        }

        public int set(int flags) {
            return this.in(flags) ? flags : flags + this.flag();
        }

        public int clear(int flags) {
            return this.in(flags) ? flags - this.flag() : flags;
        }
    }
}

