/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.events;

import com.google.gwt.aria.client.Id;
import com.google.gwt.aria.client.Roles;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.http.client.URL;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.TakesValue;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DockPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.MenuItem;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.SuggestBox;
import com.google.gwt.user.client.ui.SuggestOracle;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.unitime.timetable.gwt.client.Client;
import org.unitime.timetable.gwt.client.Lookup;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.aria.AriaTabBar;
import org.unitime.timetable.gwt.client.events.AcademicSessionSelectionBox;
import org.unitime.timetable.gwt.client.events.ApproveDialog;
import org.unitime.timetable.gwt.client.events.EventAdd;
import org.unitime.timetable.gwt.client.events.EventComparator;
import org.unitime.timetable.gwt.client.events.EventCookie;
import org.unitime.timetable.gwt.client.events.EventDetail;
import org.unitime.timetable.gwt.client.events.EventFilterBox;
import org.unitime.timetable.gwt.client.events.EventMeetingTable;
import org.unitime.timetable.gwt.client.events.RoomFilterBox;
import org.unitime.timetable.gwt.client.events.StartEndTimeSelector;
import org.unitime.timetable.gwt.client.events.TimeGrid;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.page.UniTimePageHeader;
import org.unitime.timetable.gwt.client.page.UniTimePageLabel;
import org.unitime.timetable.gwt.client.widgets.FilterBox;
import org.unitime.timetable.gwt.client.widgets.IntervalSelector;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.ServerDateTimeFormat;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.TimeSelector;
import org.unitime.timetable.gwt.client.widgets.UniTimeDialogBox;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.client.widgets.UniTimeWidget;
import org.unitime.timetable.gwt.client.widgets.WeekSelector;
import org.unitime.timetable.gwt.command.client.GwtRpcResponse;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtAriaMessages;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.AcademicSessionProvider;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.gwt.shared.PersonInterface;

public class EventResourceTimetable
extends Composite
implements EventMeetingTable.MeetingFilter,
EventAdd.EventPropertiesProvider,
AcademicSessionSelectionBox.AcademicSessionFilter {
    private static GwtAriaMessages ARIA = (GwtAriaMessages)GWT.create(GwtAriaMessages.class);
    private static final GwtConstants CONSTANTS = (GwtConstants)GWT.create(GwtConstants.class);
    private static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private static final GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private SimplePanel iRootPanel;
    private EventDetail iEventDetail;
    private EventAdd iEventAdd;
    private SimpleForm iPanel;
    private SimpleForm iFilter;
    private DockPanel iDockPanel;
    private SimplePanel iGridOrTablePanel;
    private UniTimeHeaderPanel iHeader;
    private UniTimeHeaderPanel iFooter;
    private UniTimeHeaderPanel iFilterHeader;
    private TimeGrid iTimeGrid;
    private EventMeetingTable iTable;
    private ScrollPanel iTablePanel;
    private EventInterface.ResourceInterface iResource;
    private List<EventInterface> iData;
    private WeekSelector iWeekPanel;
    private RoomSelector iRoomPanel;
    private AcademicSessionSelectionBox iSession;
    private ListBox iResourceTypes;
    private SuggestBox iResources;
    private int iResourcesRow = -1;
    private EventFilterBox iEvents = null;
    private RoomFilterBox iRooms = null;
    private String iLocDate = null;
    private String iLocRoom = null;
    private TimeGrid.MeetingClickHandler iMeetingClickHandler;
    private Lookup iLookup;
    private AriaTabBar iTabBar;
    private ApproveDialog iApproveDialog;
    private int iSessionRow = -1;
    private Set<Integer> iMatchingWeeks = new HashSet<Integer>();
    private Set<Long> iMatchingRooms = new HashSet<Long>();
    private EventInterface.EventPropertiesRpcResponse iProperties = null;
    private HistoryToken iHistoryToken = null;
    private PageType iType = null;
    private boolean iInitialized = false;
    private List<EventInterface> iBack = new ArrayList<EventInterface>();
    private List<EventInterface.SessionMonth> iSessionMonths = null;

    public EventResourceTimetable(PageType type) {
        this.iHistoryToken = new HistoryToken(type);
        this.iType = type;
        this.iFilter = new SimpleForm(2);
        this.iFilter.removeStyleName("unitime-NotPrintableBottomLine");
        this.iFilter.getColumnFormatter().setWidth(0, "120px");
        this.iFilterHeader = new UniTimeHeaderPanel(MESSAGES.sectFilter());
        this.iLookup = new Lookup();
        this.iLookup.setOptions("mustHaveExternalId");
        this.iLookup.addValueChangeHandler(new ValueChangeHandler<PersonInterface>(){

            public void onValueChange(ValueChangeEvent<PersonInterface> event) {
                if (event.getValue() != null) {
                    EventResourceTimetable.this.iResources.setText(((PersonInterface)event.getValue()).getId());
                    EventResourceTimetable.this.resourceTypeChanged(true);
                }
            }
        });
        this.iFilterHeader.addButton("lookup", MESSAGES.buttonLookup(), 75, new ClickHandler(){

            public void onClick(ClickEvent event) {
                EventResourceTimetable.this.iLookup.center();
            }
        });
        this.iFilterHeader.setEnabled("lookup", false);
        this.iFilterHeader.addButton("add", MESSAGES.buttonAddEvent(), 75, new ClickHandler(){

            public void onClick(ClickEvent event) {
                EventResourceTimetable.this.iEventAdd.setEvent(null);
                EventResourceTimetable.this.iEventAdd.show();
            }
        });
        this.iFilterHeader.setEnabled("add", false);
        this.iFilter.addHeaderRow((Widget)this.iFilterHeader);
        this.iFilterHeader.addButton("clear", MESSAGES.buttonClear(), 75, new ClickHandler(){

            public void onClick(ClickEvent event) {
                String typeString;
                EventResourceTimetable.this.iEvents.setValue(EventResourceTimetable.this.iHistoryToken.getDefaultParameter("events", ""), true);
                EventResourceTimetable.this.iRooms.setValue(EventResourceTimetable.this.iHistoryToken.getDefaultParameter("rooms", ""), true);
                if (!"true".equals(EventResourceTimetable.this.iHistoryToken.getParameter("fixedType", "false")) && (typeString = EventResourceTimetable.this.iHistoryToken.getDefaultParameter("type", "room")) != null) {
                    for (int idx = 0; idx < EventResourceTimetable.this.iResourceTypes.getItemCount(); ++idx) {
                        if (!EventResourceTimetable.this.iResourceTypes.getValue(idx).equalsIgnoreCase(typeString)) continue;
                        EventResourceTimetable.this.iResourceTypes.setSelectedIndex(idx);
                    }
                }
                EventResourceTimetable.this.iResources.setValue(EventResourceTimetable.this.iHistoryToken.getDefaultParameter("name", ""));
                EventResourceTimetable.this.iLocRoom = EventResourceTimetable.this.iHistoryToken.getDefaultParameter("room", "");
                EventResourceTimetable.this.iLocDate = EventResourceTimetable.this.iHistoryToken.getDefaultParameter("date", "");
                EventResourceTimetable.this.hideResults();
                EventResourceTimetable.this.changeUrl();
                UniTimePageLabel.getInstance().setPageName(EventResourceTimetable.this.getPageName());
                EventResourceTimetable.this.resourceTypeChanged(false);
            }
        });
        this.iFilterHeader.setEnabled("clear", "true".equals(this.iHistoryToken.getParameter("showClear", "true")));
        this.iFilterHeader.addButton("search", MESSAGES.buttonSearch(), 75, new ClickHandler(){

            public void onClick(ClickEvent event) {
                EventResourceTimetable.this.resourceTypeChanged(true);
            }
        });
        this.iSession = new AcademicSessionSelectionBox(this.iHistoryToken.getParameter("term"), "Events"){

            @Override
            protected void onInitializationSuccess(List<AcademicSessionSelectionBox.AcademicSession> sessions) {
                EventResourceTimetable.this.iFilter.setVisible(sessions != null && !sessions.isEmpty());
                UniTimePageHeader.getInstance().getRight().setVisible(false);
                UniTimePageHeader.getInstance().getRight().setPreventDefault(true);
            }

            @Override
            protected void onInitializationFailure(Throwable caught) {
                UniTimeNotifications.error(MESSAGES.failedLoadSessions(caught.getMessage()), caught);
            }
        };
        this.iSession.setFilter(this);
        this.iSessionRow = this.iFilter.addRow(MESSAGES.propAcademicSession(), (Widget)this.iSession);
        this.iEvents = new EventFilterBox(this.iSession);
        if ("true".equals(this.iHistoryToken.getParameter("showFilter", "true"))) {
            this.iFilter.addRow(MESSAGES.propEventFilter(), (Widget)this.iEvents);
        }
        this.iRooms = new RoomFilterBox(this.iSession);
        if ("true".equals(this.iHistoryToken.getParameter("showFilter", "true"))) {
            this.iFilter.addRow(MESSAGES.propRoomFilter(), (Widget)this.iRooms);
        }
        this.iResourceTypes = new ListBox();
        for (EventInterface.ResourceType resource : EventInterface.ResourceType.values()) {
            if (!resource.isVisible()) continue;
            this.iResourceTypes.addItem(resource.getResourceType(CONSTANTS), resource.name());
        }
        this.iResourceTypes.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                EventResourceTimetable.this.iResources.setText("");
                UniTimePageLabel.getInstance().setPageName(EventResourceTimetable.this.getPageName());
                EventResourceTimetable.this.hideResults();
                if (EventResourceTimetable.this.iProperties != null) {
                    EventResourceTimetable.this.resourceTypeChanged(EventResourceTimetable.this.isShowingResults());
                }
            }
        });
        int row = this.iFilter.addRow(MESSAGES.propResourceType(), (Widget)this.iResourceTypes);
        if ("true".equals(this.iHistoryToken.getParameter("fixedType", "false"))) {
            this.iFilter.getRowFormatter().setVisible(row, false);
        }
        this.iResources = new SuggestBox(new SuggestOracle(){

            public void requestDefaultSuggestions(SuggestOracle.Request request, SuggestOracle.Callback callback) {
                this.requestSuggestions(request, callback);
            }

            public void requestSuggestions(final SuggestOracle.Request request, final SuggestOracle.Callback callback) {
                if (EventResourceTimetable.this.iSession.getAcademicSessionId() != null) {
                    RPC.execute(EventInterface.ResourceLookupRpcRequest.findResources(EventResourceTimetable.this.iSession.getAcademicSessionId(), EventInterface.ResourceType.valueOf(EventResourceTimetable.this.iResourceTypes.getValue(EventResourceTimetable.this.iResourceTypes.getSelectedIndex())), request.getQuery(), request.getLimit()), new AsyncCallback<GwtRpcResponseList<EventInterface.ResourceInterface>>(){

                        public void onFailure(final Throwable caught) {
                            ArrayList<1> suggestions = new ArrayList<1>();
                            suggestions.add(new SuggestOracle.Suggestion(){

                                public String getDisplayString() {
                                    return "<font color='red'>" + caught.getMessage() + "</font>";
                                }

                                public String getReplacementString() {
                                    return "";
                                }
                            });
                            callback.onSuggestionsReady(request, new SuggestOracle.Response(suggestions));
                            ToolBox.checkAccess(caught);
                        }

                        public void onSuccess(GwtRpcResponseList<EventInterface.ResourceInterface> result) {
                            ArrayList<ResourceSuggestion> suggestions = new ArrayList<ResourceSuggestion>();
                            for (EventInterface.ResourceInterface resource : result) {
                                suggestions.add(new ResourceSuggestion(resource));
                            }
                            callback.onSuggestionsReady(request, new SuggestOracle.Response(suggestions));
                        }
                    });
                }
            }

            public boolean isDisplayStringHTML() {
                return true;
            }
        });
        this.iResources.getValueBox().addFocusHandler(new FocusHandler(){

            public void onFocus(FocusEvent event) {
                EventResourceTimetable.this.iResources.showSuggestionList();
            }
        });
        this.iResourcesRow = this.iFilter.addRow(MESSAGES.propResource(), (Widget)this.iResources);
        this.iResources.addSelectionHandler((SelectionHandler)new SelectionHandler<SuggestOracle.Suggestion>(){

            public void onSelection(SelectionEvent<SuggestOracle.Suggestion> event) {
                if (event.getSelectedItem() instanceof ResourceSuggestion) {
                    EventResourceTimetable.this.resourceChanged(((ResourceSuggestion)event.getSelectedItem()).getResource());
                }
            }
        });
        this.iFilter.getRowFormatter().setVisible(this.iResourcesRow, false);
        this.iResourceTypes.setSelectedIndex(EventInterface.ResourceType.ROOM.ordinal());
        this.iPanel = new SimpleForm(2);
        this.iPanel.removeStyleName("unitime-NotPrintableBottomLine");
        this.iPanel.addRow((Widget)this.iFilter);
        this.iHeader = new UniTimeHeaderPanel();
        this.iPanel.addHeaderRow((Widget)this.iHeader);
        this.iWeekPanel = new WeekSelector(this.iSession);
        this.iWeekPanel.addValueChangeHandler(new ValueChangeHandler<IntervalSelector.Interval>(){

            public void onValueChange(ValueChangeEvent<IntervalSelector.Interval> e) {
                EventResourceTimetable.this.iLocDate = EventResourceTimetable.this.iWeekPanel.getSelection();
                EventResourceTimetable.this.tabOrDataChanged(true);
            }
        });
        this.iWeekPanel.setFilter(new IntervalSelector.Filter<EventInterface.WeekInterface>(){

            @Override
            public boolean filter(EventInterface.WeekInterface week) {
                return !EventResourceTimetable.this.iMatchingWeeks.contains(week.getDayOfYear());
            }

            @Override
            public boolean isEmpty() {
                return EventResourceTimetable.this.iMatchingWeeks.isEmpty();
            }
        });
        this.iRoomPanel = new RoomSelector();
        this.iRoomPanel.setFilter(new IntervalSelector.Filter<EventInterface.ResourceInterface>(){

            @Override
            public boolean filter(EventInterface.ResourceInterface room) {
                return !EventResourceTimetable.this.iMatchingRooms.contains(room.getId());
            }

            @Override
            public boolean isEmpty() {
                return EventResourceTimetable.this.iMatchingRooms.isEmpty();
            }
        });
        this.iTabBar = new AriaTabBar();
        this.iTabBar.addTab(MESSAGES.tabGrid(), true);
        this.iTabBar.addTab(MESSAGES.tabEventTable(), true);
        this.iTabBar.addTab(MESSAGES.tabMeetingTable(), true);
        this.iTabBar.addSelectionHandler((SelectionHandler)new SelectionHandler<Integer>(){

            public void onSelection(SelectionEvent<Integer> event) {
                EventResourceTimetable.this.tabOrDataChanged(true);
            }
        });
        this.iGridOrTablePanel = new SimplePanel();
        this.iGridOrTablePanel.setStyleName("unitime-TabPanel");
        final Character gridAccessKey = UniTimeHeaderPanel.guessAccessKey(MESSAGES.tabGrid());
        final Character eventsAccessKey = UniTimeHeaderPanel.guessAccessKey(MESSAGES.tabEventTable());
        final Character meetingsAccessKey = UniTimeHeaderPanel.guessAccessKey(MESSAGES.tabMeetingTable());
        if (gridAccessKey != null || eventsAccessKey != null || meetingsAccessKey != null) {
            RootPanel.get().addDomHandler((EventHandler)new KeyUpHandler(){

                public void onKeyUp(KeyUpEvent event) {
                    if (!EventResourceTimetable.this.iRootPanel.getWidget().equals((Object)EventResourceTimetable.this.iPanel)) {
                        return;
                    }
                    int tab = -1;
                    if (gridAccessKey != null && event.getNativeEvent().getCtrlKey() && (event.getNativeKeyCode() == gridAccessKey.charValue() || event.getNativeKeyCode() == Character.toUpperCase(gridAccessKey.charValue()))) {
                        tab = 0;
                    }
                    if (eventsAccessKey != null && event.getNativeEvent().getCtrlKey() && (event.getNativeKeyCode() == eventsAccessKey.charValue() || event.getNativeKeyCode() == Character.toUpperCase(eventsAccessKey.charValue()))) {
                        tab = 1;
                    }
                    if (meetingsAccessKey != null && event.getNativeEvent().getCtrlKey() && (event.getNativeKeyCode() == meetingsAccessKey.charValue() || event.getNativeKeyCode() == Character.toUpperCase(meetingsAccessKey.charValue()))) {
                        tab = 2;
                    }
                    if (tab >= 0) {
                        EventResourceTimetable.this.iTabBar.selectTab(tab);
                        event.preventDefault();
                    }
                }
            }, KeyUpEvent.getType());
        }
        this.iDockPanel = new DockPanel();
        this.iDockPanel.setStyleName("unitime-EventResults");
        this.iDockPanel.setSpacing(0);
        this.iDockPanel.add((Widget)this.iGridOrTablePanel, DockPanel.SOUTH);
        this.iDockPanel.add((Widget)this.iRoomPanel, DockPanel.WEST);
        this.iDockPanel.setCellHorizontalAlignment((Widget)this.iRoomPanel, HasHorizontalAlignment.ALIGN_LEFT);
        this.iDockPanel.add((Widget)this.iTabBar, DockPanel.CENTER);
        this.iDockPanel.setCellVerticalAlignment((Widget)this.iTabBar, HasVerticalAlignment.ALIGN_BOTTOM);
        this.iDockPanel.setCellHorizontalAlignment((Widget)this.iTabBar, HasHorizontalAlignment.ALIGN_CENTER);
        this.iDockPanel.add((Widget)this.iWeekPanel, DockPanel.EAST);
        this.iDockPanel.setCellHorizontalAlignment((Widget)this.iWeekPanel, HasHorizontalAlignment.ALIGN_RIGHT);
        Roles.getTabpanelRole().set((Element)this.iDockPanel.getElement());
        Roles.getTabpanelRole().setAriaOwnsProperty((Element)this.iDockPanel.getElement(), new Id[]{Id.of((Element)this.iTabBar.getElement())});
        this.iPanel.addRow((Widget)this.iDockPanel);
        this.hideResults();
        this.iFooter = this.iHeader.clonePanel();
        this.iPanel.addRow((Widget)this.iFooter);
        this.iRootPanel = new SimplePanel((Widget)this.iPanel);
        this.initWidget((Widget)this.iRootPanel);
        this.iRoomPanel.addValueChangeHandler(new ValueChangeHandler<IntervalSelector.Interval>(){

            public void onValueChange(ValueChangeEvent<IntervalSelector.Interval> e) {
                EventResourceTimetable.this.iLocRoom = EventResourceTimetable.this.iRoomPanel.getSelection();
                EventResourceTimetable.this.tabOrDataChanged(true);
            }
        });
        for (int i = 1; i < this.iPanel.getRowCount(); ++i) {
            this.iPanel.getRowFormatter().setVisible(i, false);
        }
        this.iHeader.addButton("add", MESSAGES.buttonAddEvent(), 75, new ClickHandler(){

            public void onClick(ClickEvent event) {
                EventResourceTimetable.this.iEventAdd.setEvent(null);
                EventResourceTimetable.this.iEventAdd.show();
            }
        });
        this.iHeader.setEnabled("add", false);
        this.iHeader.addButton("print", MESSAGES.buttonPrint(), 75, new ClickHandler(){

            public void onClick(ClickEvent clickEvent) {
                Integer slot;
                FilterBox.Chip before;
                Integer slot2;
                final EventMeetingTable table = new EventMeetingTable(EventResourceTimetable.this.getSelectedTab() <= 1 ? EventMeetingTable.Mode.ListOfEvents : EventMeetingTable.Mode.ListOfMeetings, false, EventResourceTimetable.this);
                table.setMeetingFilter(EventResourceTimetable.this);
                table.setShowMainContact(EventResourceTimetable.this.iProperties != null && EventResourceTimetable.this.iProperties.isCanLookupMainContact());
                table.setShowMeetingContacts(EventResourceTimetable.this.iProperties != null && EventResourceTimetable.this.iProperties.isCanViewMeetingContacts());
                table.setEvents(EventResourceTimetable.this.iData);
                table.setSortBy(EventResourceTimetable.this.iTable.getSortBy());
                table.getElement().getStyle().setWidth(1040.0, Style.Unit.PX);
                int firstSlot = 12 + CONSTANTS.eventStartDefault();
                int lastSlot = CONSTANTS.eventStopDefault();
                boolean skipDays = EventResourceTimetable.this.iEvents.hasChip(new FilterBox.Chip("day", null));
                boolean[] hasDay = new boolean[7];
                for (int i = 0; i < 7; ++i) {
                    int dayInv = (7 + i - EventResourceTimetable.this.getFirstDayOfWeek()) % 7;
                    hasDay[i] = dayInv < 5 ? !skipDays || EventResourceTimetable.this.iEvents.hasChip(new FilterBox.Chip("day", CONSTANTS.longDays()[i])) : EventResourceTimetable.this.iEvents.hasChip(new FilterBox.Chip("day", CONSTANTS.longDays()[i]));
                }
                for (EventInterface event : EventResourceTimetable.this.iData) {
                    if (event.getType() == EventInterface.EventType.Unavailabile && !EventResourceTimetable.this.iEvents.hasChip(new FilterBox.Chip("type", "Not Available"))) continue;
                    for (EventInterface.MeetingInterface meetingInterface : event.getMeetings()) {
                        if (EventResourceTimetable.this.filterEvent(event, meetingInterface) || meetingInterface.getApprovalStatus() != EventInterface.ApprovalStatus.Pending && meetingInterface.getApprovalStatus() != EventInterface.ApprovalStatus.Approved) continue;
                        if (firstSlot > meetingInterface.getStartSlot()) {
                            firstSlot = meetingInterface.getStartSlot();
                        }
                        if (lastSlot < meetingInterface.getEndSlot()) {
                            lastSlot = meetingInterface.getEndSlot();
                        }
                        hasDay[meetingInterface.getDayOfWeek()] = true;
                    }
                }
                FilterBox.Chip after = EventResourceTimetable.this.iEvents.getChip("after");
                if (after != null && (slot2 = TimeSelector.TimeUtils.parseTime(CONSTANTS, after.getValue(), null)) != null && firstSlot > slot2) {
                    firstSlot = slot2;
                }
                if ((before = EventResourceTimetable.this.iEvents.getChip("before")) != null && (slot = TimeSelector.TimeUtils.parseTime(CONSTANTS, before.getValue(), Math.min(firstSlot, CONSTANTS.eventStartDefault()))) != null && lastSlot < slot) {
                    lastSlot = slot;
                }
                int nrDays = 0;
                for (boolean d : hasDay) {
                    if (!d) continue;
                    ++nrDays;
                }
                int[] nArray = new int[nrDays];
                int d = 0;
                for (int i = 0; i < 7; ++i) {
                    int day = (i + EventResourceTimetable.this.getFirstDayOfWeek()) % 7;
                    if (!hasDay[day]) continue;
                    nArray[d++] = day;
                }
                int firstHour = firstSlot / 12;
                int maxFirstHour = CONSTANTS.eventStartDefault() / 12;
                int minLastHour = (11 + CONSTANTS.eventStopDefault()) / 12;
                int lastHour = 1 + (lastSlot - 1) / 12;
                if (firstHour <= maxFirstHour && firstHour > 0 && firstSlot % 12 < 6) {
                    --firstHour;
                }
                HashMap<Long, String> colors = new HashMap<Long, String>();
                final TimeGrid tg = new TimeGrid(colors, nArray, 1000 / nrDays, 55, true, false, firstHour < maxFirstHour ? firstHour : maxFirstHour, lastHour > minLastHour ? lastHour : minLastHour, EventResourceTimetable.this);
                tg.setShowRoomNote(true);
                tg.setResourceType(EventResourceTimetable.this.getResourceType());
                tg.setSelectedWeeks(EventResourceTimetable.this.iWeekPanel.getSelected());
                tg.setRoomResources(EventResourceTimetable.this.iRoomPanel.getSelected());
                tg.setMode(EventResourceTimetable.this.gridMode());
                tg.showVerticalSplit();
                for (EventInterface event : EventResourceTimetable.this.sortedEvents()) {
                    ArrayList<EventInterface.MeetingInterface> meetings = new ArrayList<EventInterface.MeetingInterface>();
                    for (EventInterface.MeetingInterface meeting : event.getMeetings()) {
                        if (meeting.getApprovalStatus() != EventInterface.ApprovalStatus.Pending && meeting.getApprovalStatus() != EventInterface.ApprovalStatus.Approved || meeting.getMeetingDate() == null || EventResourceTimetable.this.filterEvent(event, meeting)) continue;
                        meetings.add(meeting);
                    }
                    if (meetings.isEmpty()) continue;
                    tg.addEvent(event, meetings);
                }
                if (EventResourceTimetable.this.iWeekPanel.getValue() != null) {
                    tg.labelDays((EventInterface.WeekInterface)EventResourceTimetable.this.iWeekPanel.getValue().getFirst(), (EventInterface.WeekInterface)EventResourceTimetable.this.iWeekPanel.getValue().getLast());
                }
                com.google.gwt.user.client.Element headerRow = table.getRowFormatter().getElement(0);
                com.google.gwt.user.client.Element tableElement = table.getElement();
                com.google.gwt.user.client.Element thead = DOM.createTHead();
                tableElement.insertFirst((Node)thead);
                headerRow.getParentElement().removeChild((Node)headerRow);
                thead.appendChild((Node)headerRow);
                ToolBox.print(new ToolBox.Page(){

                    @Override
                    public String getName() {
                        return EventResourceTimetable.this.iHeader.getHeaderTitle();
                    }

                    @Override
                    public String getUser() {
                        return EventResourceTimetable.this.iRoomPanel.getValue().toString();
                    }

                    @Override
                    public String getSession() {
                        return EventResourceTimetable.this.iWeekPanel.getValue().toString();
                    }

                    @Override
                    public Element getBody() {
                        return tg.getElement();
                    }
                }, new ToolBox.Page(){

                    @Override
                    public String getName() {
                        return EventResourceTimetable.this.iHeader.getHeaderTitle();
                    }

                    @Override
                    public String getUser() {
                        return EventResourceTimetable.this.iRoomPanel.getValue().toString();
                    }

                    @Override
                    public String getSession() {
                        return EventResourceTimetable.this.iWeekPanel.getValue().toString();
                    }

                    @Override
                    public Element getBody() {
                        return table.getElement();
                    }
                });
            }
        });
        this.iHeader.addButton("export", MESSAGES.buttonExport(), 75, new ClickHandler(){

            public void onClick(ClickEvent clickEvent) {
                if (EventResourceTimetable.this.iProperties != null && EventResourceTimetable.this.iProperties.isCanExportCSV()) {
                    final PopupPanel popup = new PopupPanel(true);
                    MenuBar menu = new MenuBar(true);
                    MenuItem exportPdf = new MenuItem(MESSAGES.opExportPDF(), true, (Scheduler.ScheduledCommand)new Command(){

                        public void execute() {
                            popup.hide();
                            EventResourceTimetable.this.export("output=" + (EventResourceTimetable.this.getSelectedTab() <= 1 ? "events" : "meetings") + ".pdf&flags=" + EventCookie.getInstance().getFlags(), true);
                        }
                    });
                    exportPdf.getElement().getStyle().setCursor(Style.Cursor.POINTER);
                    menu.addItem(exportPdf);
                    MenuItem exportCsv = new MenuItem(MESSAGES.opExportCSV(), true, (Scheduler.ScheduledCommand)new Command(){

                        public void execute() {
                            popup.hide();
                            EventResourceTimetable.this.export("output=" + (EventResourceTimetable.this.getSelectedTab() <= 1 ? "events" : "meetings") + ".csv&flags=" + EventCookie.getInstance().getFlags(), true);
                        }
                    });
                    exportCsv.getElement().getStyle().setCursor(Style.Cursor.POINTER);
                    menu.addItem(exportCsv);
                    MenuItem exportXls = new MenuItem(MESSAGES.opExportXLS(), true, (Scheduler.ScheduledCommand)new Command(){

                        public void execute() {
                            popup.hide();
                            EventResourceTimetable.this.export("output=" + (EventResourceTimetable.this.getSelectedTab() <= 1 ? "events" : "meetings") + ".xls&flags=" + EventCookie.getInstance().getFlags(), true);
                        }
                    });
                    exportXls.getElement().getStyle().setCursor(Style.Cursor.POINTER);
                    menu.addItem(exportXls);
                    MenuItem exportIcs = new MenuItem(MESSAGES.opExportICalendar(), true, (Scheduler.ScheduledCommand)new Command(){

                        public void execute() {
                            popup.hide();
                            EventResourceTimetable.this.copyToClipboard("output=events.ics" + (EventResourceTimetable.this.iType == PageType.Personal ? "&e:flag=All+Sessions" : ""), EventResourceTimetable.this.iType == PageType.Personal);
                        }
                    });
                    exportIcs.getElement().getStyle().setCursor(Style.Cursor.POINTER);
                    menu.addItem(exportIcs);
                    popup.add((Widget)menu);
                    popup.showRelativeTo((UIObject)clickEvent.getSource());
                    menu.focus();
                } else {
                    EventResourceTimetable.this.export("output=events.ics", false);
                }
            }
        });
        this.iHeader.addButton("operations", MESSAGES.buttonMoreOperations(), 75, new ClickHandler(){

            public void onClick(ClickEvent event) {
                PopupPanel popup = new PopupPanel(true);
                EventResourceTimetable.this.iTable.getHeader(0).setMenu(popup);
                popup.showRelativeTo((UIObject)event.getSource());
                ((MenuBar)popup.getWidget()).focus();
            }
        });
        this.iHeader.setEnabled("print", false);
        this.iHeader.setEnabled("export", false);
        this.iHeader.setEnabled("operations", false);
        this.iSession.addAcademicSessionChangeHandler(new AcademicSessionProvider.AcademicSessionChangeHandler(){

            @Override
            public void onAcademicSessionChange(AcademicSessionProvider.AcademicSessionChangeEvent event) {
                EventResourceTimetable.this.loadProperties((AsyncCallback<EventInterface.EventPropertiesRpcResponse>)((AsyncCallback)new AsyncCallback<EventInterface.EventPropertiesRpcResponse>(){

                    public void onFailure(Throwable caught) {
                    }

                    public void onSuccess(EventInterface.EventPropertiesRpcResponse result) {
                        if (!EventResourceTimetable.this.iInitialized) {
                            EventResourceTimetable.this.setup(true);
                        } else {
                            EventResourceTimetable.this.resourceTypeChanged(EventResourceTimetable.this.isShowingResults());
                        }
                    }
                }));
            }
        });
        this.iEventDetail = new EventDetail(this){

            @Override
            protected void onHide() {
                EventResourceTimetable.this.iRootPanel.setWidget((Widget)EventResourceTimetable.this.iPanel);
                UniTimePageLabel.getInstance().setPageName(EventResourceTimetable.this.getPageName());
                if (!EventResourceTimetable.this.isShowingResults()) {
                    EventResourceTimetable.this.resourceTypeChanged(true);
                }
                EventResourceTimetable.this.changeUrl();
            }

            @Override
            protected void onShow() {
                EventResourceTimetable.this.iBack.clear();
                if (EventResourceTimetable.this.iTable != null) {
                    EventResourceTimetable.this.iTable.clearHover();
                }
                EventResourceTimetable.this.iRootPanel.setWidget((Widget)EventResourceTimetable.this.iEventDetail);
                EventResourceTimetable.this.changeUrl();
            }

            @Override
            protected void edit() {
                super.hide();
                EventResourceTimetable.this.iEventAdd.setEvent(this.getEvent());
                EventResourceTimetable.this.iEventAdd.show();
            }

            @Override
            protected EventInterface getPrevious(Long eventId) {
                return EventResourceTimetable.this.iTable.previous(eventId);
            }

            @Override
            protected EventInterface getNext(Long eventId) {
                return EventResourceTimetable.this.iTable.next(eventId);
            }

            @Override
            protected void previous(final EventInterface event) {
                EventResourceTimetable.this.iBack.add(this.getEvent());
                LoadingWidget.execute(EventInterface.EventDetailRpcRequest.requestEventDetails(EventResourceTimetable.this.iSession.getAcademicSessionId(), event.getId()), new AsyncCallback<EventInterface>(){

                    public void onFailure(Throwable caught) {
                        UniTimeNotifications.error(MESSAGES.failedLoad(event.getName(), caught.getMessage()), caught);
                    }

                    public void onSuccess(EventInterface result) {
                        LoadingWidget.getInstance().hide();
                        this.setEvent(result);
                        EventResourceTimetable.this.changeUrl();
                    }
                }, MESSAGES.waitLoading(event.getName()));
            }

            @Override
            protected void next(EventInterface event) {
                this.previous(event);
            }

            @Override
            public void hide() {
                if (!EventResourceTimetable.this.iBack.isEmpty()) {
                    EventInterface last = (EventInterface)EventResourceTimetable.this.iBack.remove(EventResourceTimetable.this.iBack.size() - 1);
                    this.setEvent(last);
                } else {
                    super.hide();
                }
            }

            @Override
            protected void onApprovalOrReject(Long eventId, EventInterface event) {
                if (EventResourceTimetable.this.iData != null) {
                    EventResourceTimetable.this.populate(EventResourceTimetable.this.tinker(new GwtRpcResponseList(EventResourceTimetable.this.iData), eventId, event));
                }
            }
        };
        this.iEventAdd = new EventAdd(this.iSession, this){

            @Override
            protected void onHide() {
                EventResourceTimetable.this.iSession.setFilter(EventResourceTimetable.this);
                EventResourceTimetable.this.iFilter.setWidget(EventResourceTimetable.this.iSessionRow, 1, (Widget)EventResourceTimetable.this.iSession);
                EventInterface modified = EventResourceTimetable.this.iEventAdd.getEvent();
                final EventInterface detail = EventResourceTimetable.this.iEventDetail.getEvent();
                EventInterface saved = EventResourceTimetable.this.iEventAdd.getSavedEvent();
                if (saved != null) {
                    if (EventResourceTimetable.this.iData != null) {
                        EventResourceTimetable.this.populate(EventResourceTimetable.this.tinker(new GwtRpcResponseList(EventResourceTimetable.this.iData), saved.getId() == null ? modified.getId() : saved.getId(), saved));
                    }
                    if (saved.getId() != null) {
                        EventResourceTimetable.this.iEventDetail.setEvent(saved);
                        EventResourceTimetable.this.iEventDetail.show();
                    } else {
                        EventResourceTimetable.this.iRootPanel.setWidget((Widget)EventResourceTimetable.this.iPanel);
                        UniTimePageLabel.getInstance().setPageName(EventResourceTimetable.this.getPageName());
                    }
                } else if (modified != null && detail != null && detail.getId().equals(modified.getId())) {
                    LoadingWidget.execute(EventInterface.EventDetailRpcRequest.requestEventDetails(EventResourceTimetable.this.iSession.getAcademicSessionId(), modified.getId()), new AsyncCallback<EventInterface>(){

                        public void onFailure(Throwable caught) {
                            UniTimeNotifications.error(MESSAGES.failedLoad(detail.getName(), caught.getMessage()), caught);
                        }

                        public void onSuccess(EventInterface result) {
                            LoadingWidget.getInstance().hide();
                            if (result == null) {
                                EventResourceTimetable.this.iRootPanel.setWidget((Widget)EventResourceTimetable.this.iPanel);
                                UniTimePageLabel.getInstance().setPageName(EventResourceTimetable.this.getPageName());
                            } else {
                                EventResourceTimetable.this.iEventDetail.setEvent(result);
                                EventResourceTimetable.this.iEventDetail.show();
                            }
                        }
                    }, MESSAGES.waitLoading(detail.getName()));
                } else {
                    EventResourceTimetable.this.iRootPanel.setWidget((Widget)EventResourceTimetable.this.iPanel);
                    UniTimePageLabel.getInstance().setPageName(EventResourceTimetable.this.getPageName());
                }
                EventResourceTimetable.this.changeUrl();
            }

            @Override
            protected void onShow() {
                if (EventResourceTimetable.this.iTable != null) {
                    EventResourceTimetable.this.iTable.clearHover();
                }
                EventResourceTimetable.this.iRootPanel.setWidget((Widget)EventResourceTimetable.this.iEventAdd);
                EventResourceTimetable.this.changeUrl();
            }
        };
        this.iMeetingClickHandler = new TimeGrid.MeetingClickHandler(){

            @Override
            public void onMeetingClick(final TimeGrid.MeetingClickEvent event) {
                if (!event.getEvent().isCanView()) {
                    return;
                }
                LoadingWidget.execute(EventInterface.EventDetailRpcRequest.requestEventDetails(EventResourceTimetable.this.iSession.getAcademicSessionId(), event.getEvent().getId()), new AsyncCallback<EventInterface>(){

                    public void onFailure(Throwable caught) {
                        UniTimeNotifications.error(MESSAGES.failedLoad(event.getEvent().getName(), caught.getMessage()), caught);
                    }

                    public void onSuccess(EventInterface result) {
                        LoadingWidget.getInstance().hide();
                        EventResourceTimetable.this.iEventDetail.setEvent(result);
                        EventResourceTimetable.this.iEventDetail.show();
                    }
                }, MESSAGES.waitLoading(event.getEvent().getName()));
            }
        };
        this.iTable = new EventMeetingTable(EventMeetingTable.Mode.ListOfEvents, true, this){

            @Override
            protected void onSortByChanded(EventComparator.EventMeetingSortBy sortBy, boolean asc) {
                EventResourceTimetable.this.changeUrl();
            }

            @Override
            protected void onColumnShownOrHid(int eventCookieFlags) {
                EventResourceTimetable.this.changeUrl();
            }
        };
        this.iTable.setMeetingFilter(this);
        this.iTable.addMouseClickListener(new UniTimeTable.MouseClickListener<EventMeetingTable.EventMeetingRow>(){

            @Override
            public void onMouseClick(UniTimeTable.TableEvent<EventMeetingTable.EventMeetingRow> event) {
                if (event.getData() == null) {
                    return;
                }
                final EventInterface e = event.getData().getEvent();
                if (e == null || !e.isCanView()) {
                    return;
                }
                LoadingWidget.execute(EventInterface.EventDetailRpcRequest.requestEventDetails(EventResourceTimetable.this.iSession.getAcademicSessionId(), e.getId()), new AsyncCallback<EventInterface>(){

                    public void onFailure(Throwable caught) {
                        UniTimeNotifications.error(MESSAGES.failedLoad(e.getName(), caught.getMessage()), caught);
                    }

                    public void onSuccess(EventInterface result) {
                        LoadingWidget.getInstance().hide();
                        EventResourceTimetable.this.iEventDetail.setEvent(result);
                        EventResourceTimetable.this.iEventDetail.show();
                    }
                }, MESSAGES.waitLoading(e.getName()));
            }
        });
        this.iTablePanel = new ScrollPanel((Widget)this.iTable);
        this.iTablePanel.addStyleName("scroll-panel");
        this.iApproveDialog = new ApproveDialog(this){

            @Override
            protected void onSubmit(EventInterface.SaveOrApproveEventRpcRequest.Operation operation, List<EventMeetingTable.EventMeetingRow> data, String message, boolean emailConfirmation) {
                HashMap<EventInterface, List<EventInterface.MeetingInterface>> event2meetings = new HashMap<EventInterface, List<EventInterface.MeetingInterface>>();
                ArrayList<EventInterface> events = new ArrayList<EventInterface>();
                for (EventMeetingTable.EventMeetingRow row : data) {
                    if (row.getMeeting() != null) {
                        ArrayList<EventInterface.MeetingInterface> meetings = (ArrayList<EventInterface.MeetingInterface>)event2meetings.get(row.getEvent());
                        if (meetings == null) {
                            meetings = new ArrayList<EventInterface.MeetingInterface>();
                            event2meetings.put(row.getEvent(), meetings);
                            events.add(row.getEvent());
                        }
                        meetings.add(row.getMeeting());
                        continue;
                    }
                    events.add(row.getEvent());
                }
                this.onSubmit(operation, events.iterator(), event2meetings, message, emailConfirmation, new GwtRpcResponseList<EventInterface>(EventResourceTimetable.this.iData));
            }

            protected void onSubmit(final EventInterface.SaveOrApproveEventRpcRequest.Operation operation, final Iterator<EventInterface> events, final Map<EventInterface, List<EventInterface.MeetingInterface>> event2meetings, final String message, final boolean emailConfirmation, final GwtRpcResponseList<EventInterface> data) {
                if (events.hasNext()) {
                    final EventInterface event = events.next();
                    List<EventInterface.MeetingInterface> meetings = event2meetings.get(event);
                    if (meetings == null) {
                        meetings = new ArrayList<EventInterface.MeetingInterface>();
                        for (EventInterface.MeetingInterface meeting : event.getMeetings()) {
                            switch (operation) {
                                case APPROVE: 
                                case REJECT: {
                                    if (!meeting.isCanApprove() || EventResourceTimetable.this.filter(event, meeting)) break;
                                    meetings.add(meeting);
                                    break;
                                }
                                case CANCEL: {
                                    if (!meeting.isCanCancel() || EventResourceTimetable.this.filter(event, meeting)) break;
                                    meetings.add(meeting);
                                    break;
                                }
                                case INQUIRE: {
                                    if (!meeting.isCanInquire() || EventResourceTimetable.this.filter(event, meeting)) break;
                                    meetings.add(meeting);
                                }
                            }
                        }
                    }
                    if (meetings.isEmpty()) {
                        this.onSubmit(operation, events, event2meetings, message, emailConfirmation, data);
                    } else {
                        switch (operation) {
                            case APPROVE: {
                                LoadingWidget.getInstance().show(MESSAGES.waitForApproval(event.getName()));
                                break;
                            }
                            case INQUIRE: {
                                LoadingWidget.getInstance().show(MESSAGES.waitForInquiry(event.getName()));
                                break;
                            }
                            case REJECT: {
                                LoadingWidget.getInstance().show(MESSAGES.waitForRejection(event.getName()));
                                break;
                            }
                            case CANCEL: {
                                LoadingWidget.getInstance().show(MESSAGES.waitForCancellation(event.getName()));
                            }
                        }
                        RPC.execute(EventInterface.ApproveEventRpcRequest.createRequest(operation, EventResourceTimetable.this.iSession.getAcademicSessionId(), event, meetings, message, emailConfirmation), new AsyncCallback<EventInterface.SaveOrApproveEventRpcResponse>(){

                            public void onFailure(Throwable caught) {
                                LoadingWidget.getInstance().hide();
                                UniTimeNotifications.error(caught);
                                this.onSubmit(operation, events, event2meetings, message, emailConfirmation, data);
                            }

                            public void onSuccess(EventInterface.SaveOrApproveEventRpcResponse result) {
                                LoadingWidget.getInstance().hide();
                                if (result.hasMessages()) {
                                    for (EventInterface.MessageInterface m : result.getMessages()) {
                                        if (m.isError()) {
                                            UniTimeNotifications.warn(m.getMessage());
                                            continue;
                                        }
                                        if (m.isWarning()) {
                                            UniTimeNotifications.error(m.getMessage());
                                            continue;
                                        }
                                        UniTimeNotifications.info(m.getMessage());
                                    }
                                }
                                switch (operation) {
                                    case APPROVE: 
                                    case REJECT: 
                                    case CANCEL: {
                                        EventResourceTimetable.this.tinker(data, event.getId(), result.getEvent());
                                    }
                                }
                                this.onSubmit(operation, events, event2meetings, message, emailConfirmation, data);
                            }
                        });
                    }
                } else {
                    LoadingWidget.getInstance().hide();
                    EventResourceTimetable.this.populate(data);
                }
            }
        };
        this.iTable.setOperation(EventMeetingTable.OperationType.Approve, this.iApproveDialog);
        this.iTable.setOperation(EventMeetingTable.OperationType.Reject, this.iApproveDialog);
        this.iTable.setOperation(EventMeetingTable.OperationType.Inquire, this.iApproveDialog);
        this.iTable.setOperation(EventMeetingTable.OperationType.Cancel, this.iApproveDialog);
        History.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                if (EventResourceTimetable.this.iInitialized) {
                    if ("event=add".equals(event.getValue())) {
                        EventResourceTimetable.this.iHistoryToken.parse((String)event.getValue());
                    } else {
                        EventResourceTimetable.this.iHistoryToken.reset((String)event.getValue());
                    }
                    EventResourceTimetable.this.setup(false);
                    if (LoadingWidget.getInstance().isShowing()) {
                        LoadingWidget.getInstance().hide();
                    }
                }
            }
        });
    }

    private int getSelectedTab() {
        return this.iTabBar.getSelectedTab();
    }

    private void tabOrDataChanged(boolean keepSelection) {
        if (this.iTimeGrid != null) {
            this.iTimeGrid.hideSelectionPopup();
        }
        if (this.iTable != null) {
            this.iTable.clearHover();
        }
        if (this.getSelectedTab() == 0) {
            Integer slot;
            FilterBox.Chip before;
            Integer slot2;
            int nrDays = 4;
            int firstSlot = 12 + CONSTANTS.eventStartDefault();
            int lastSlot = CONSTANTS.eventStopDefault();
            for (EventInterface event : this.iData) {
                if (event.getType() == EventInterface.EventType.Unavailabile && !this.iEvents.hasChip(new FilterBox.Chip("type", "Not Available"))) continue;
                for (EventInterface.MeetingInterface meeting : event.getMeetings()) {
                    if (this.filterEvent(event, meeting) || meeting.getApprovalStatus() != EventInterface.ApprovalStatus.Pending && meeting.getApprovalStatus() != EventInterface.ApprovalStatus.Approved) continue;
                    if (firstSlot > meeting.getStartSlot()) {
                        firstSlot = meeting.getStartSlot();
                    }
                    if (lastSlot < meeting.getEndSlot()) {
                        lastSlot = meeting.getEndSlot();
                    }
                    int day = (meeting.getDayOfWeek() + this.getFirstDayOfWeek()) % 7;
                    nrDays = Math.max(nrDays, day);
                }
            }
            FilterBox.Chip after = this.iEvents.getChip("after");
            if (after != null && (slot2 = TimeSelector.TimeUtils.parseTime(CONSTANTS, after.getValue(), null)) != null && firstSlot > slot2) {
                firstSlot = slot2;
            }
            if ((before = this.iEvents.getChip("before")) != null && (slot = TimeSelector.TimeUtils.parseTime(CONSTANTS, before.getValue(), Math.min(firstSlot, CONSTANTS.eventStartDefault()))) != null && lastSlot < slot) {
                lastSlot = slot;
            }
            int[] days = new int[++nrDays];
            for (int i = 0; i < days.length; ++i) {
                days[i] = (i + this.getFirstDayOfWeek()) % 7;
            }
            int firstHour = firstSlot / 12;
            int lastHour = 1 + (lastSlot - 1) / 12;
            int maxFirstHour = CONSTANTS.eventStartDefault() / 12;
            int minLastHour = (11 + CONSTANTS.eventStopDefault()) / 12;
            if (firstHour <= maxFirstHour && firstHour > 0 && firstSlot % 12 < 6) {
                --firstHour;
            }
            HashMap<Long, String> colors = new HashMap<Long, String>();
            List<EventInterface.SelectionInterface> selections = null;
            if (this.iTimeGrid != null) {
                if (keepSelection) {
                    selections = this.iTimeGrid.getSelections();
                }
                this.iTimeGrid.destroy();
            }
            this.iTimeGrid = new TimeGrid(colors, days, (int)(0.9 * (double)ToolBox.getClientWidth() / (double)nrDays), false, false, firstHour < maxFirstHour ? firstHour : maxFirstHour, lastHour > minLastHour ? lastHour : minLastHour, this);
            this.iTimeGrid.setShowRoomNote(true);
            this.iTimeGrid.addMeetingClickHandler(this.iMeetingClickHandler);
            this.iTimeGrid.clear();
            this.iTimeGrid.setResourceType(this.getResourceType());
            this.iTimeGrid.setSelectedWeeks(this.iWeekPanel.getSelected());
            this.iTimeGrid.setRoomResources(this.iRoomPanel.getSelected());
            if (selections != null) {
                this.iTimeGrid.getSelections().addAll(selections);
            }
            this.iTimeGrid.setMode(this.gridMode());
            int first = this.iWeekPanel.getFirstDayOfYear();
            int last = this.iWeekPanel.getLastDayOfYear();
            for (EventInterface event : this.sortedEvents()) {
                ArrayList<EventInterface.MeetingInterface> meetings = new ArrayList<EventInterface.MeetingInterface>();
                for (EventInterface.MeetingInterface meeting : event.getMeetings()) {
                    if (meeting.getApprovalStatus() != EventInterface.ApprovalStatus.Pending && meeting.getApprovalStatus() != EventInterface.ApprovalStatus.Approved || meeting.getMeetingDate() == null || this.filterEvent(event, meeting) || first > meeting.getDayOfYear() || meeting.getDayOfYear() > last) continue;
                    meetings.add(meeting);
                }
                if (meetings.isEmpty()) continue;
                this.iTimeGrid.addEvent(event, meetings);
            }
            this.iTimeGrid.shrink(this.iEvents.hasChip(new FilterBox.Chip("day", null)), this.iEvents.hasChip(new FilterBox.Chip("type", "Not Available")), this.iEvents.hasChip(new FilterBox.Chip("day", CONSTANTS.longDays()[0])), this.iEvents.hasChip(new FilterBox.Chip("day", CONSTANTS.longDays()[1])), this.iEvents.hasChip(new FilterBox.Chip("day", CONSTANTS.longDays()[2])), this.iEvents.hasChip(new FilterBox.Chip("day", CONSTANTS.longDays()[3])), this.iEvents.hasChip(new FilterBox.Chip("day", CONSTANTS.longDays()[4])), this.iEvents.hasChip(new FilterBox.Chip("day", CONSTANTS.longDays()[5])), this.iEvents.hasChip(new FilterBox.Chip("day", CONSTANTS.longDays()[6])));
            List selected = this.iWeekPanel.getSelected();
            if (selected != null && !selected.isEmpty()) {
                this.iTimeGrid.labelDays((EventInterface.WeekInterface)selected.get(0), selected.size() == 1 ? null : (EventInterface.WeekInterface)selected.get(selected.size() - 1));
            }
            this.iGridOrTablePanel.setWidget((Widget)this.iTimeGrid);
        } else {
            this.iTable.setMode(this.getSelectedTab() == 1 ? EventMeetingTable.Mode.ListOfEvents : EventMeetingTable.Mode.ListOfMeetings);
            this.iTable.setEvents(this.iData);
            this.iGridOrTablePanel.setWidget((Widget)this.iTablePanel);
        }
        this.iHeader.setHeaderTitle(this.name(this.getSelectedTab()));
        this.changeUrl();
    }

    private void setup(boolean init) {
        if (init) {
            this.iInitialized = true;
        }
        boolean reload = init;
        boolean isDefault = true;
        if (this.iHistoryToken.isChanged("events", "", this.iEvents.getValue())) {
            this.iEvents.setValue(this.iHistoryToken.getParameter("events", ""), true);
            reload = true;
            if (!this.iEvents.getValue().equals("")) {
                isDefault = false;
            }
        }
        if (this.iHistoryToken.isChanged("type", "room", this.iResourceTypes.getValue(this.iResourceTypes.getSelectedIndex()).toLowerCase())) {
            String typeString = this.iHistoryToken.getParameter("type", "room");
            if (typeString != null) {
                for (int idx = 0; idx < this.iResourceTypes.getItemCount(); ++idx) {
                    if (!this.iResourceTypes.getValue(idx).equalsIgnoreCase(typeString)) continue;
                    this.iResourceTypes.setSelectedIndex(idx);
                }
            }
            reload = true;
        }
        if (this.iHistoryToken.isChanged("rooms", this.getResourceType() == EventInterface.ResourceType.ROOM ? "flag:Event" : "", this.iRooms.getValue())) {
            this.iRooms.setValue(this.iHistoryToken.getParameter("rooms", this.getResourceType() == EventInterface.ResourceType.ROOM ? "flag:Event" : ""), true);
            reload = true;
            if (!this.iRooms.getValue().equals(this.getResourceType() == EventInterface.ResourceType.ROOM ? "flag:Event" : "")) {
                isDefault = false;
            }
        }
        if (this.iHistoryToken.isChanged("name", "", this.iResources.getText())) {
            this.iResources.setText(this.iHistoryToken.getParameter("name", ""));
            boolean bl = reload = this.getResourceType() != EventInterface.ResourceType.ROOM;
            if (!this.iResources.getText().equals("")) {
                isDefault = false;
            }
        }
        UniTimePageLabel.getInstance().setPageName(this.getPageName());
        if (this.iHistoryToken.isChanged("tab", "0", String.valueOf(this.getSelectedTab()))) {
            this.iTabBar.selectTab(Integer.parseInt(this.iHistoryToken.getParameter("tab", "0")), this.isShowingResults());
        }
        boolean fireWeekPanel = false;
        boolean fireRoomPanel = false;
        if (this.iHistoryToken.isChanged("date", this.iLocDate)) {
            this.iLocDate = this.iHistoryToken.getParameter("date");
            if (this.iWeekPanel.hasValues()) {
                this.iWeekPanel.setValue(this.iWeekPanel.parse(this.iLocDate));
                this.iWeekPanel.setFilterEnabled(!this.iMatchingWeeks.isEmpty());
                fireWeekPanel = this.isShowingResults();
            }
        }
        if (this.iHistoryToken.isChanged("room", this.iLocRoom)) {
            this.iLocRoom = this.iHistoryToken.getParameter("room");
            if (this.iRoomPanel.hasValues()) {
                this.iRoomPanel.setFilterEnabled(!this.iMatchingRooms.isEmpty());
                this.iRoomPanel.setValue(this.iRoomPanel.parse(this.iLocRoom));
                fireRoomPanel = this.isShowingResults();
            }
        }
        if (this.iHistoryToken.hasParameter("sort")) {
            this.iTable.setSortBy(this.iHistoryToken.getParameter("sort"));
        }
        if (this.iHistoryToken.hasParameter("event")) {
            if (this.iHistoryToken.isChanged("term", this.iSession.getAcademicSessionAbbreviation()) && this.iHistoryToken.getParameter("term") != null) {
                this.iSession.selectSession(this.iHistoryToken.getParameter("term"), null);
            }
            if ("add".equals(this.iHistoryToken.getParameter("event"))) {
                this.iEventAdd.setEvent(null);
                this.iEventAdd.show();
            } else {
                new Timer(){

                    public void run() {
                        if (EventResourceTimetable.this.iProperties == null) {
                            this.schedule(500);
                            return;
                        }
                        Long eventId = Long.valueOf(EventResourceTimetable.this.iHistoryToken.getParameter("event"));
                        LoadingWidget.execute(EventInterface.EventDetailRpcRequest.requestEventDetails(EventResourceTimetable.this.iSession.getAcademicSessionId(), eventId), new AsyncCallback<EventInterface>(){

                            public void onFailure(Throwable caught) {
                                UniTimeNotifications.error(MESSAGES.failedLoad(MESSAGES.anEvent(), caught.getMessage()), caught);
                            }

                            public void onSuccess(EventInterface result) {
                                LoadingWidget.getInstance().hide();
                                EventResourceTimetable.this.iEventDetail.setEvent(result);
                                EventResourceTimetable.this.iEventDetail.show();
                            }
                        }, MESSAGES.waitLoading(MESSAGES.anEvent()));
                    }
                }.schedule(200);
            }
        } else {
            this.iRootPanel.setWidget((Widget)this.iPanel);
            if (this.iHistoryToken.hasParameter("term") && this.iHistoryToken.isChanged("term", this.iSession.getAcademicSessionAbbreviation())) {
                this.iSession.selectSession(this.iHistoryToken.getParameter("term"), null);
            } else if (reload && this.iProperties != null) {
                this.resourceTypeChanged(this.isShowingResults() || !isDefault && CONSTANTS.searchWhenPageIsLoaded());
            }
        }
        if (fireWeekPanel) {
            ValueChangeEvent.fire((HasValueChangeHandlers)this.iWeekPanel, (Object)this.iWeekPanel.getValue());
        }
        if (fireRoomPanel) {
            ValueChangeEvent.fire((HasValueChangeHandlers)this.iRoomPanel, (Object)this.iRoomPanel.getValue());
        }
    }

    private Collection<EventInterface> sortedEvents() {
        TreeSet<EventInterface> data = new TreeSet<EventInterface>(new Comparator<EventInterface>(){

            @Override
            public int compare(EventInterface e1, EventInterface e2) {
                int cmp = Integer.valueOf(e1.getMeetings().first().getDayOfYear()).compareTo(e2.getMeetings().first().getDayOfYear());
                if (cmp != 0) {
                    return cmp;
                }
                cmp = Integer.valueOf(e1.getMeetings().first().getStartSlot()).compareTo(e2.getMeetings().first().getStartSlot());
                if (cmp != 0) {
                    return cmp;
                }
                return e1.compareTo(e2);
            }
        });
        data.addAll(this.iData);
        return data;
    }

    public EventInterface.ResourceType getResourceType() {
        if (this.iResourceTypes.getSelectedIndex() < 0) {
            return null;
        }
        return EventInterface.ResourceType.valueOf(this.iResourceTypes.getValue(this.iResourceTypes.getSelectedIndex()));
    }

    public String getResourceName() {
        if (!(this.getResourceType() != EventInterface.ResourceType.PERSON || this.iProperties != null && this.iProperties.isCanLookupPeople())) {
            return "";
        }
        return this.iResources.getText() == null || this.iResources.getText().isEmpty() ? null : this.iResources.getText();
    }

    private void resourceTypeChanged(boolean loadData) {
        EventInterface.ResourceType type = this.getResourceType();
        if (type == null) {
            UniTimeNotifications.warn(MESSAGES.warnNoResourceType());
            return;
        }
        if (type == EventInterface.ResourceType.ROOM) {
            this.iFilter.getRowFormatter().setVisible(this.iResourcesRow, false);
            this.iFilterHeader.setEnabled("lookup", false);
            if (loadData) {
                if (this.iSession.getAcademicSessionId() == null) {
                    UniTimeNotifications.warn(MESSAGES.warnNoSession());
                } else if (this.iProperties == null) {
                    UniTimeNotifications.warn(MESSAGES.warnNoEventProperties(this.iSession.getAcademicSessionName()));
                } else {
                    EventInterface.ResourceInterface resource = new EventInterface.ResourceInterface();
                    resource.setType(EventInterface.ResourceType.ROOM);
                    resource.setName(this.iRooms.getValue());
                    this.resourceChanged(resource);
                }
            }
        } else {
            this.iFilter.getRowFormatter().setVisible(this.iResourcesRow, type != EventInterface.ResourceType.PERSON);
            ((Label)this.iFilter.getWidget(this.iResourcesRow, 0)).setText(type.getName(CONSTANTS) + ":");
            this.iFilterHeader.setEnabled("lookup", this.iProperties != null && this.iProperties.isCanLookupPeople() && this.getResourceType() == EventInterface.ResourceType.PERSON);
            if (this.getResourceName() != null || type == EventInterface.ResourceType.PERSON && loadData) {
                if (this.iSession.getAcademicSessionId() == null) {
                    UniTimeNotifications.warn(MESSAGES.warnNoSession());
                } else if (this.iProperties == null) {
                    UniTimeNotifications.warn(MESSAGES.warnNoEventProperties(this.iSession.getAcademicSessionName()));
                } else {
                    LoadingWidget.execute(EventInterface.ResourceLookupRpcRequest.findResource(this.iSession.getAcademicSessionId(), type, this.getResourceName()), new AsyncCallback<GwtRpcResponseList<EventInterface.ResourceInterface>>(){

                        public void onFailure(Throwable caught) {
                            UniTimeNotifications.error(MESSAGES.failedLoad(EventResourceTimetable.this.getResourceName(), caught.getMessage()), caught);
                            EventResourceTimetable.this.hideResults();
                        }

                        public void onSuccess(GwtRpcResponseList<EventInterface.ResourceInterface> result) {
                            EventResourceTimetable.this.resourceChanged((EventInterface.ResourceInterface)result.get(0));
                        }
                    }, MESSAGES.waitLoading(type.getName(CONSTANTS) + (type != EventInterface.ResourceType.PERSON ? " " + this.getResourceName() : "")));
                }
            } else if (this.getResourceName() == null && loadData) {
                UniTimeNotifications.warn(MESSAGES.warnNoResourceName(CONSTANTS.resourceName()[this.getResourceType().ordinal()].toLowerCase()));
                this.iResources.setFocus(true);
            }
        }
        if (!loadData) {
            this.iData = null;
            this.hideResults();
        }
    }

    private GwtRpcResponseList<EventInterface> tinker(GwtRpcResponseList<EventInterface> data, Long oldEventId, EventInterface newEvent) {
        Iterator i = data.iterator();
        while (i.hasNext()) {
            EventInterface event = (EventInterface)i.next();
            if (event.getId().equals(oldEventId)) {
                i.remove();
                continue;
            }
            if (event.hasConflicts()) {
                Iterator<EventInterface> j = event.getConflicts().iterator();
                while (j.hasNext()) {
                    if (!j.next().getId().equals(oldEventId)) continue;
                    j.remove();
                }
            }
            if (newEvent == null || newEvent.getId() == null || !event.inConflict(newEvent)) continue;
            event.addConflict(event.createConflictingEvent(newEvent));
        }
        if (newEvent != null && newEvent.getId() != null) {
            data.add(newEvent);
        }
        return data;
    }

    private void resourceChanged(final EventInterface.ResourceInterface resource) {
        this.iResource = resource;
        LoadingWidget.execute(this.iRooms.getElementsRequest(), new AsyncCallback<EventInterface.FilterRpcResponse>(){

            public void onFailure(Throwable caught) {
                UniTimeNotifications.error(MESSAGES.failedLoad(resource.getType() == EventInterface.ResourceType.ROOM ? MESSAGES.resourceRoom().toLowerCase() : resource.getName(), caught.getMessage()), caught);
                EventResourceTimetable.this.hideResults();
            }

            public void onSuccess(EventInterface.FilterRpcResponse result) {
                if (result == null) {
                    return;
                }
                ArrayList<EventInterface.ResourceInterface> rooms = new ArrayList<EventInterface.ResourceInterface>();
                if (result.hasResults()) {
                    for (EventInterface.FilterRpcResponse.Entity room : result.getResults()) {
                        rooms.add(new EventInterface.ResourceInterface(room));
                    }
                }
                Collections.sort(rooms);
                EventResourceTimetable.this.iRoomPanel.setValues(rooms);
                if (!result.hasResults() || result.getResults().isEmpty()) {
                    UniTimeNotifications.error(MESSAGES.errorNoMatchingRooms());
                    EventResourceTimetable.this.hideResults();
                    return;
                }
                LoadingWidget.execute(EventInterface.EventLookupRpcRequest.findEvents(EventResourceTimetable.this.iSession.getAcademicSessionId(), EventResourceTimetable.this.iResource, (EventInterface.EventFilterRpcRequest)EventResourceTimetable.this.iEvents.getElementsRequest(), (EventInterface.RoomFilterRpcRequest)EventResourceTimetable.this.iRooms.getElementsRequest(), CONSTANTS.maxMeetings()), new AsyncCallback<GwtRpcResponseList<EventInterface>>(){

                    public void onSuccess(GwtRpcResponseList<EventInterface> result) {
                        if (result != null) {
                            EventResourceTimetable.this.populate(result);
                        }
                        EventResourceTimetable.this.iApproveDialog.reset(EventResourceTimetable.this.iProperties);
                    }

                    public void onFailure(Throwable caught) {
                        UniTimeNotifications.error(MESSAGES.failedLoad(resource.getType() == EventInterface.ResourceType.ROOM ? MESSAGES.resourceRoom().toLowerCase() : resource.getName(), caught.getMessage()), caught);
                        EventResourceTimetable.this.hideResults();
                    }
                }, MESSAGES.waitLoadingTimetable(resource.getType() == EventInterface.ResourceType.ROOM ? MESSAGES.resourceRoom().toLowerCase() : resource.getName(), EventResourceTimetable.this.iSession.getAcademicSessionName()));
            }
        }, MESSAGES.waitLoadingTimetable(resource.getType() == EventInterface.ResourceType.ROOM ? MESSAGES.resourceRoom().toLowerCase() : resource.getName(), this.iSession.getAcademicSessionName()));
    }

    private void populate(GwtRpcResponseList<EventInterface> result) {
        this.iData = result;
        if (this.iData.isEmpty()) {
            UniTimeNotifications.warn(MESSAGES.failedNoEvents());
        }
        Collections.sort(this.iData);
        this.iMatchingRooms.clear();
        int nrMeetings = 0;
        for (EventInterface event : this.iData) {
            for (EventInterface.MeetingInterface meeting : event.getMeetings()) {
                if (meeting.getLocation() == null) continue;
                this.iMatchingRooms.add(meeting.getLocation().getId());
            }
            nrMeetings += event.getMeetings().size();
        }
        this.iRoomPanel.setValue(this.iRoomPanel.parse(this.iLocRoom));
        this.iRoomPanel.setFilterEnabled(!this.iMatchingRooms.isEmpty());
        this.iMatchingWeeks.clear();
        for (EventInterface.WeekInterface week : this.iWeekPanel.getValues()) {
            boolean hasEvents = false;
            block3: for (EventInterface event : this.iData) {
                for (EventInterface.MeetingInterface meeting : event.getMeetings()) {
                    if (meeting.getDayOfYear() < week.getDayOfYear() || meeting.getDayOfYear() >= week.getDayOfYear() + 7) continue;
                    hasEvents = true;
                    break block3;
                }
            }
            if (!hasEvents) continue;
            this.iMatchingWeeks.add(week.getDayOfYear());
        }
        this.iWeekPanel.setValue(this.iWeekPanel.parse(this.iLocDate));
        this.iWeekPanel.setFilterEnabled(!this.iMatchingWeeks.isEmpty());
        if (nrMeetings > CONSTANTS.maxMeetings()) {
            this.iHeader.setErrorMessage(MESSAGES.warnTooManyMeetings(CONSTANTS.maxMeetings()));
        } else {
            this.iHeader.clearMessage();
        }
        this.tabOrDataChanged(false);
        this.showResults();
        this.changeUrl();
    }

    private String name(int tab) {
        String resource = this.iResource.getType() == EventInterface.ResourceType.ROOM ? (this.iRoomPanel.getValue() != null && this.iRoomPanel.getValue().isOne() ? ((EventInterface.ResourceInterface)this.iRoomPanel.getValue().getFirst()).getName() : (this.iRoomPanel.getValues() != null && this.iRoomPanel.getValues().size() == 1 ? ((EventInterface.ResourceInterface)this.iRoomPanel.getValues().get(0)).getName() : MESSAGES.resourceRoom())) : this.iResource.getNameWithHint(MESSAGES);
        String session = this.iSession.getAcademicSessionName();
        if (this.iWeekPanel.getValue() != null && !this.iWeekPanel.getValue().isAll()) {
            session = this.iWeekPanel.getValue().toString().toLowerCase();
        }
        switch (tab) {
            case 0: {
                return MESSAGES.sectTimetable(resource, session);
            }
            case 1: {
                return MESSAGES.sectEventList(resource, session);
            }
            case 2: {
                return MESSAGES.sectMeetingList(resource, session);
            }
        }
        return null;
    }

    @Override
    public boolean filter(EventInterface event, EventInterface.MeetingInterface meeting) {
        if (event != null && event.getType() == EventInterface.EventType.Unavailabile && !this.iEvents.hasChip(new FilterBox.Chip("type", "Not Available"))) {
            return true;
        }
        return this.filterEvent(event, meeting);
    }

    public boolean filterEvent(EventInterface event, EventInterface.MeetingInterface meeting) {
        if (!(event == null || event.getType() != EventInterface.EventType.Unavailabile || this.iEvents.hasChip(new FilterBox.Chip("type", "Not Available")) || this.getResourceType() == EventInterface.ResourceType.ROOM && this.gridMode() == TimeGrid.Mode.OVERLAP)) {
            return true;
        }
        if (this.iWeekPanel.getValue() != null && !this.iWeekPanel.getValue().isAll()) {
            int firstDayOfYear = ((EventInterface.WeekInterface)this.iWeekPanel.getValue().getFirst()).getDayOfYear();
            int lastDayOfYear = (this.iWeekPanel.getValue().isOne() ? (EventInterface.WeekInterface)this.iWeekPanel.getValue().getFirst() : (EventInterface.WeekInterface)this.iWeekPanel.getValue().getLast()).getDayOfYear() + 6;
            if (meeting.getMeetingDate() == null || meeting.getDayOfYear() < firstDayOfYear || meeting.getDayOfYear() > lastDayOfYear) {
                return true;
            }
        }
        if (this.iRoomPanel.getValue() != null && !this.iRoomPanel.getValue().isAll()) {
            if (this.iRoomPanel.getValue().isOne()) {
                if (!((EventInterface.ResourceInterface)this.iRoomPanel.getValue().getFirst()).getName().equals(meeting.getLocationName()) && !((EventInterface.ResourceInterface)this.iRoomPanel.getValue().getFirst()).sameLocationOrPartition(meeting.getLocation())) {
                    return true;
                }
            } else {
                if (((EventInterface.ResourceInterface)this.iRoomPanel.getValue().getFirst()).getName().compareTo(meeting.getLocationName()) > 0) {
                    return true;
                }
                if (((EventInterface.ResourceInterface)this.iRoomPanel.getValue().getLast()).getName().compareTo(meeting.getLocationName()) < 0) {
                    return true;
                }
            }
        }
        return false;
    }

    private TimeGrid.Mode gridMode() {
        if ("0".equals(this.iHistoryToken.getParameter("eq"))) {
            return TimeGrid.Mode.FILLSPACE;
        }
        switch (this.iResource.getType()) {
            case ROOM: {
                return this.iRoomPanel.isOne() || this.iWeekPanel.isOne() && this.iRoomPanel.getSelected().size() <= 20 ? TimeGrid.Mode.OVERLAP : TimeGrid.Mode.PROPORTIONAL;
            }
            case PERSON: {
                return TimeGrid.Mode.OVERLAP;
            }
            case GROUP: {
                if (!CONSTANTS.timeGridStudentGroupDoesNotOverlap()) break;
                return TimeGrid.Mode.OVERLAP;
            }
        }
        return this.iRoomPanel.isOne() || this.iWeekPanel.isOne() && this.iRoomPanel.getSelected().size() <= 10 ? TimeGrid.Mode.OVERLAP : TimeGrid.Mode.PROPORTIONAL;
    }

    protected String query(String extra, boolean includeRoomWeekFilter) {
        Object rooms;
        String query = "sid=" + this.iSession.getAcademicSessionId() + (this.iResource == null || this.iResource.getType() == null ? "" : "&type=" + this.iResource.getType().toString().toLowerCase()) + (this.iResource == null || this.iResource.getId() == null ? "" : "&id=" + this.iResource.getId()) + (this.iResource == null || this.iResource.getExternalId() == null ? "" : "&ext=" + this.iResource.getExternalId());
        Object events = this.iEvents.getElementsRequest();
        if (includeRoomWeekFilter) {
            if (this.iWeekPanel.getValue() != null && !this.iWeekPanel.getValue().isAll()) {
                ((EventInterface.FilterRpcRequest)events).setOption("from", String.valueOf(((EventInterface.WeekInterface)this.iWeekPanel.getValue().getFirst()).getDayOfYear()));
                ((EventInterface.FilterRpcRequest)events).setOption("to", String.valueOf((this.iWeekPanel.getValue().isOne() ? (EventInterface.WeekInterface)this.iWeekPanel.getValue().getFirst() : (EventInterface.WeekInterface)this.iWeekPanel.getValue().getLast()).getDayOfYear() + 6));
            }
            if (this.iRoomPanel.getValue() != null && !this.iRoomPanel.getValue().isAll()) {
                for (EventInterface.ResourceInterface resourceInterface : this.iRoomPanel.getSelected()) {
                    ((EventInterface.FilterRpcRequest)events).addOption("room", resourceInterface.getId().toString());
                }
            } else {
                rooms = this.iRooms.getElementsRequest();
                if (((EventInterface.FilterRpcRequest)rooms).hasOptions()) {
                    for (Map.Entry<String, Set<String>> option : ((EventInterface.FilterRpcRequest)rooms).getOptions().entrySet()) {
                        for (String value : option.getValue()) {
                            query = query + "&r:" + option.getKey() + "=" + URL.encodeQueryString((String)value);
                        }
                    }
                }
                if (((EventInterface.FilterRpcRequest)rooms).getText() != null && !((EventInterface.FilterRpcRequest)rooms).getText().isEmpty()) {
                    query = query + "&r:text=" + URL.encodeQueryString((String)((EventInterface.FilterRpcRequest)rooms).getText());
                }
            }
        } else {
            rooms = this.iRooms.getElementsRequest();
            if (((EventInterface.FilterRpcRequest)rooms).hasOptions()) {
                for (Map.Entry<String, Set<String>> option : ((EventInterface.FilterRpcRequest)rooms).getOptions().entrySet()) {
                    for (String value : option.getValue()) {
                        query = query + "&r:" + option.getKey() + "=" + URL.encodeQueryString((String)value);
                    }
                }
            }
            if (((EventInterface.FilterRpcRequest)rooms).getText() != null && !((EventInterface.FilterRpcRequest)rooms).getText().isEmpty()) {
                query = query + "&r:text=" + URL.encodeQueryString((String)((EventInterface.FilterRpcRequest)rooms).getText());
            }
        }
        if (((EventInterface.FilterRpcRequest)events).hasOptions()) {
            for (Map.Entry entry : ((EventInterface.FilterRpcRequest)events).getOptions().entrySet()) {
                for (String value : (Set)entry.getValue()) {
                    query = query + "&e:" + (String)entry.getKey() + "=" + URL.encodeQueryString((String)value);
                }
            }
        }
        if (((EventInterface.FilterRpcRequest)events).getText() != null && !((EventInterface.FilterRpcRequest)events).getText().isEmpty()) {
            query = query + "&e:text=" + URL.encodeQueryString((String)((EventInterface.FilterRpcRequest)events).getText());
        }
        if (this.iTable.hasSortBy()) {
            query = query + "&sort=" + this.iTable.getSortBy();
        }
        if (extra != null && !extra.isEmpty()) {
            query = query + "&" + extra;
        }
        if (this.iEvents.hasChip(new FilterBox.Chip("type", "Not Available")) || this.getResourceType() == EventInterface.ResourceType.ROOM && this.gridMode() == TimeGrid.Mode.OVERLAP) {
            query = query + "&ua=1";
        }
        return query;
    }

    protected void export(String format, boolean includeRoomWeekFilter) {
        RPC.execute(EventInterface.EncodeQueryRpcRequest.encode(this.query(format, includeRoomWeekFilter)), new AsyncCallback<EventInterface.EncodeQueryRpcResponse>(){

            public void onFailure(Throwable caught) {
            }

            public void onSuccess(EventInterface.EncodeQueryRpcResponse result) {
                ToolBox.open(GWT.getHostPageBaseURL() + "export?q=" + result.getQuery());
            }
        });
    }

    protected void copyToClipboard(String format, final boolean personal) {
        RPC.execute(EventInterface.EncodeQueryRpcRequest.encode(this.query(format, false), true), new AsyncCallback<EventInterface.EncodeQueryRpcResponse>(){

            public void onFailure(Throwable caught) {
            }

            public void onSuccess(final EventInterface.EncodeQueryRpcResponse result) {
                final UniTimeDialogBox dialog = new UniTimeDialogBox(true, false);
                dialog.setText(MESSAGES.opExportICalendar());
                dialog.setEscapeToHide(true);
                SimpleForm form = new SimpleForm();
                HTML description = null;
                description = personal ? new HTML(MESSAGES.exportICalendarDescriptionPersonal(), true) : new HTML(MESSAGES.exportICalendarDescriptionOther(EventResourceTimetable.this.iSession.getAcademicSessionName()), true);
                description.getElement().getStyle().setProperty("max-width", "500px");
                form.addRow((Widget)description);
                final TextArea ta = new TextArea();
                ta.setStyleName("unitime-TextArea");
                ta.setVisibleLines(5);
                ta.setCharacterWidth(80);
                ta.setText(GWT.getHostPageBaseURL() + (result.hasHash() ? "export?x=" + result.getHash() : "export?q=" + result.getQuery()));
                UniTimeWidget<TextArea> w = new UniTimeWidget<TextArea>(ta);
                w.setHint(MESSAGES.hintCtrlCToCopy());
                form.addRow((Widget)w);
                w.getElement().getStyle().setMarginBottom(5.0, Style.Unit.PX);
                HTML message = new HTML(MESSAGES.exportICalendarDownload(MESSAGES.buttonDownload()), true);
                message.getElement().getStyle().setProperty("max-width", "500px");
                form.addRow((Widget)message);
                UniTimeHeaderPanel h = new UniTimeHeaderPanel();
                h.addButton("download", MESSAGES.buttonDownload(), new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        ToolBox.open(GWT.getHostPageBaseURL() + "export?q=" + result.getQuery());
                        dialog.hide();
                    }
                });
                h.addButton("close", MESSAGES.buttonClose(), new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        dialog.hide();
                    }
                });
                form.addBottomRow((Widget)h);
                dialog.setWidget((Widget)form);
                Scheduler.get().scheduleDeferred((Scheduler.ScheduledCommand)new Command(){

                    public void execute() {
                        ta.setFocus(true);
                        ta.selectAll();
                    }
                });
                dialog.center();
            }
        });
    }

    private static native void nativeCopyToClipboard(Element var0);

    protected void changeUrl() {
        if (this.iTimeGrid != null) {
            RPC.execute(EventInterface.EncodeQueryRpcRequest.encode(this.query("output=events.ics", true)), new AsyncCallback<EventInterface.EncodeQueryRpcResponse>(){

                public void onFailure(Throwable caught) {
                    EventResourceTimetable.this.iHeader.setEnabled("export", false);
                    EventResourceTimetable.this.iHeader.setEnabled("operations", false);
                }

                public void onSuccess(EventInterface.EncodeQueryRpcResponse result) {
                    EventResourceTimetable.this.iHeader.setEnabled("export", true);
                    EventResourceTimetable.this.iHeader.setEnabled("operations", EventResourceTimetable.this.getSelectedTab() > 0);
                }
            });
        }
        this.iHistoryToken.reset(null);
        this.iHistoryToken.setParameter("term", this.iSession.getAcademicSessionAbbreviation());
        this.iHistoryToken.setParameter("type", this.iResourceTypes.getValue(this.iResourceTypes.getSelectedIndex()).toLowerCase());
        if (this.iResource != null && this.iResource.getAbbreviation() != null && this.iResource.getType() != EventInterface.ResourceType.PERSON) {
            this.iHistoryToken.setParameter("name", this.iResource.getAbbreviation());
        }
        if (this.iLocDate != null) {
            this.iHistoryToken.setParameter("date", this.iLocDate);
        }
        this.iHistoryToken.setParameter("events", this.iEvents.getValue().trim());
        this.iHistoryToken.setParameter("rooms", this.iRooms.getValue().trim());
        if (this.iLocRoom != null) {
            this.iHistoryToken.setParameter("room", this.iLocRoom);
        }
        this.iHistoryToken.setParameter("tab", String.valueOf(this.getSelectedTab()));
        if (((Object)((Object)this.iEventDetail)).equals(this.iRootPanel.getWidget())) {
            this.iHistoryToken.setParameter("event", this.iEventDetail.getEvent().getId());
        } else if (this.iEventAdd.equals(this.iRootPanel.getWidget())) {
            Long id = this.iEventAdd.getEventId();
            this.iHistoryToken.setParameter("event", id == null ? "add" : id.toString());
        }
        if (this.iTable.hasSortBy()) {
            this.iHistoryToken.setParameter("sort", this.iTable.getSortBy());
        }
        this.iHistoryToken.mark();
        Client.fireGwtPageChanged(new Client.GwtPageChangeEvent());
    }

    private void hideResults() {
        for (int i = 1; i < this.iPanel.getRowCount(); ++i) {
            this.iPanel.getRowFormatter().setVisible(i, false);
        }
        this.iHeader.setEnabled("print", false);
        this.iHeader.setEnabled("export", false);
        this.iHeader.setEnabled("operations", false);
        if (this.iFooter != null) {
            this.iFooter.clearMessage();
        }
    }

    private void showResults() {
        for (int i = 1; i < this.iPanel.getRowCount(); ++i) {
            this.iPanel.getRowFormatter().setVisible(i, true);
        }
        this.iHeader.setEnabled("print", true);
        this.iHeader.setEnabled("export", this.iTable.getRowCount() > 1);
        this.iHeader.setEnabled("operations", this.getSelectedTab() > 0 && this.iTable.getRowCount() > 1);
        if (this.iFooter != null) {
            this.iFooter.clearMessage();
            if (this.getResourceType() == EventInterface.ResourceType.PERSON && this.iData != null && this.iProperties != null && this.iProperties.isStudent()) {
                boolean multiRoom = false;
                block1: for (EventInterface e : this.iData) {
                    if (e.getType() != EventInterface.EventType.Class && e.getType() != EventInterface.EventType.FinalExam && e.getType() != EventInterface.EventType.MidtermExam) continue;
                    EventInterface.MeetingInterface last = null;
                    for (EventInterface.MeetingInterface m : e.getMeetings()) {
                        if (last != null && last.overlapsWith(m) && last.hasLocation() && m.hasLocation() && !last.getLocation().equals(m.getLocation())) {
                            multiRoom = true;
                            break block1;
                        }
                        last = m;
                    }
                }
                if (multiRoom) {
                    this.iFooter.setMessage(MESSAGES.warnMultiRoomClassOrExam());
                }
            }
        }
    }

    private boolean isShowingResults() {
        return ((Object)((Object)this.iPanel)).equals(this.iRootPanel.getWidget()) && this.iPanel.getRowFormatter().isVisible(1);
    }

    private void loadProperties(final AsyncCallback<EventInterface.EventPropertiesRpcResponse> callback) {
        this.iProperties = null;
        this.iSessionMonths = null;
        this.iTable.setShowMainContact(false);
        this.iTable.setShowMeetingContacts(false);
        this.iFilterHeader.setEnabled("lookup", false);
        this.iFilterHeader.setEnabled("add", false);
        this.iFooter.setEnabled("add", false);
        if (this.iSession.getAcademicSessionId() != null) {
            RPC.execute(EventInterface.EventPropertiesRpcRequest.requestEventProperties(this.iSession.getAcademicSessionId(), this.iType.name()), new AsyncCallback<EventInterface.EventPropertiesRpcResponse>(){

                public void onFailure(Throwable caught) {
                    UniTimeNotifications.error(MESSAGES.failedLoad(EventResourceTimetable.this.iSession.getAcademicSessionName(), caught.getMessage()), caught);
                    if (callback != null) {
                        callback.onFailure(caught);
                    }
                }

                public void onSuccess(final EventInterface.EventPropertiesRpcResponse result) {
                    if (result.isCanSaveFilterDefaults() && "true".equals(EventResourceTimetable.this.iHistoryToken.getParameter("showFilter", "true"))) {
                        EventResourceTimetable.this.iHistoryToken.setDefaultParameter("events", result.getFilterDefault("events"));
                        EventResourceTimetable.this.iEvents.setDefaultValueProvider(new TakesValue<String>(){

                            public void setValue(final String value) {
                                RPC.execute(new EventInterface.SaveFilterDefaultRpcRequest(EventResourceTimetable.this.iType.name() + ".events", EventResourceTimetable.this.iEvents.getValue()), new AsyncCallback<GwtRpcResponse>(){

                                    public void onFailure(Throwable caught) {
                                        UniTimeNotifications.error(MESSAGES.failedSaveAsDefault(caught.getMessage()), caught);
                                    }

                                    public void onSuccess(GwtRpcResponse result) {
                                        EventResourceTimetable.this.iHistoryToken.setDefaultParameter("events", value);
                                    }
                                });
                            }

                            public String getValue() {
                                return EventResourceTimetable.this.iHistoryToken.getDefaultParameter("events", "");
                            }
                        });
                        EventResourceTimetable.this.iHistoryToken.setDefaultParameter("rooms", result.getFilterDefault("rooms"));
                        EventResourceTimetable.this.iRooms.setDefaultValueProvider(new TakesValue<String>(){

                            public void setValue(final String value) {
                                RPC.execute(new EventInterface.SaveFilterDefaultRpcRequest(EventResourceTimetable.this.iType.name() + ".rooms", EventResourceTimetable.this.iRooms.getValue()), new AsyncCallback<GwtRpcResponse>(){

                                    public void onFailure(Throwable caught) {
                                        UniTimeNotifications.error(MESSAGES.failedSaveAsDefault(caught.getMessage()), caught);
                                    }

                                    public void onSuccess(GwtRpcResponse result) {
                                        EventResourceTimetable.this.iHistoryToken.setDefaultParameter("rooms", value);
                                    }
                                });
                            }

                            public String getValue() {
                                return EventResourceTimetable.this.iHistoryToken.getDefaultParameter("rooms", "");
                            }
                        });
                    }
                    RPC.execute(new EventInterface.RequestSessionDetails(EventResourceTimetable.this.iSession.getAcademicSessionId()), new AsyncCallback<GwtRpcResponseList<EventInterface.SessionMonth>>(){

                        public void onFailure(Throwable caught) {
                            UniTimeNotifications.error(MESSAGES.failedLoad(EventResourceTimetable.this.iSession.getAcademicSessionName(), caught.getMessage()), caught);
                            if (callback != null) {
                                callback.onFailure(caught);
                            }
                        }

                        public void onSuccess(GwtRpcResponseList<EventInterface.SessionMonth> months) {
                            EventResourceTimetable.this.iProperties = result;
                            EventResourceTimetable.this.iSessionMonths = months;
                            EventResourceTimetable.this.iEvents.setOtherVisible(result.isCanLookupMainContact() || result.isCanLookupPeople());
                            EventResourceTimetable.this.iFilterHeader.setEnabled("lookup", result.isCanLookupPeople() && EventResourceTimetable.this.getResourceType() == EventInterface.ResourceType.PERSON);
                            EventResourceTimetable.this.iFilterHeader.setEnabled("add", result.isCanAddEvent() && "true".equals(EventResourceTimetable.this.iHistoryToken.getParameter("addEvent", "true")));
                            EventResourceTimetable.this.iFooter.setEnabled("add", result.isCanAddEvent() && "true".equals(EventResourceTimetable.this.iHistoryToken.getParameter("addEvent", "true")));
                            EventResourceTimetable.this.iEventAdd.setup(result);
                            EventResourceTimetable.this.iTable.setShowMainContact(result.isCanLookupMainContact());
                            EventResourceTimetable.this.iTable.setShowMeetingContacts(result.isCanViewMeetingContacts());
                            EventResourceTimetable.this.iApproveDialog.reset(result);
                            if (callback != null) {
                                callback.onSuccess((Object)result);
                            }
                        }
                    });
                }
            });
            this.iLookup.setOptions("mustHaveExternalId,session=" + this.iSession.getAcademicSessionId());
        } else {
            this.iLookup.setOptions("mustHaveExternalId");
        }
    }

    @Override
    public Long getSessionId() {
        return this.iSession.getAcademicSessionId();
    }

    @Override
    public EventInterface.EventPropertiesRpcResponse getProperties() {
        return this.iProperties;
    }

    @Override
    public List<EventInterface.SelectionInterface> getSelection() {
        return this.iTimeGrid == null ? null : this.iTimeGrid.getSelections();
    }

    @Override
    public String getRoomFilter() {
        return this.iRooms.getValue();
    }

    @Override
    public List<Date> getSelectedDates() {
        return null;
    }

    @Override
    public StartEndTimeSelector.StartEndTime getSelectedTime() {
        return null;
    }

    @Override
    public EventInterface.ContactInterface getMainContact() {
        return this.iLookup.getValue() != null ? new EventInterface.ContactInterface(this.iLookup.getValue()) : (this.iProperties == null ? null : this.iProperties.getMainContact());
    }

    @Override
    public boolean isTooEarly(int startSlot, int endSlot) {
        if (this.iProperties == null || !this.iProperties.hasTooEarlySlot()) {
            return false;
        }
        return startSlot > 0 && startSlot <= this.iProperties.getTooEarlySlot() || startSlot == 0 && endSlot <= this.iProperties.getTooEarlySlot();
    }

    @Override
    public int getFirstDayOfWeek() {
        if (this.iProperties == null || this.iProperties.getFirstDayOfWeek() == null) {
            return 0;
        }
        return this.iProperties.getFirstDayOfWeek();
    }

    @Override
    public boolean isCanEmailStudents() {
        if (this.iProperties == null) {
            return false;
        }
        return this.iProperties.getCanEmailStudents();
    }

    public String getPageName() {
        String pageName = this.iHistoryToken.getParameter("title", "Events");
        EventInterface.ResourceType resource = this.getResourceType();
        if (!"true".equals(this.iHistoryToken.getParameter("fixedTitle")) && resource != null) {
            pageName = resource.getPageName();
        }
        return pageName;
    }

    @Override
    public boolean accept(AcademicSessionSelectionBox.AcademicSession session) {
        String filter = this.iHistoryToken.getParameter("filter");
        if ("classes".equals(filter)) {
            return session.has(AcademicSessionSelectionBox.AcademicSession.Flag.HasClasses);
        }
        if ("exams".equals(filter)) {
            return session.has(AcademicSessionSelectionBox.AcademicSession.Flag.HasFinalExams) || session.has(AcademicSessionSelectionBox.AcademicSession.Flag.HasMidtermExams);
        }
        if ("events".equals(filter)) {
            return session.has(AcademicSessionSelectionBox.AcademicSession.Flag.HasEvents);
        }
        if ("person".equals(filter)) {
            return session.has(AcademicSessionSelectionBox.AcademicSession.Flag.HasClasses) || session.has(AcademicSessionSelectionBox.AcademicSession.Flag.HasFinalExams) || session.has(AcademicSessionSelectionBox.AcademicSession.Flag.HasMidtermExams);
        }
        return true;
    }

    @Override
    public EventInterface.SessionMonth.Flag getDateFlag(EventInterface.EventType type, Date date) {
        if (this.iSessionMonths == null || this.iSessionMonths.isEmpty()) {
            return null;
        }
        if (date == null) {
            return null;
        }
        int m = Integer.parseInt(ServerDateTimeFormat.getFormat("MM").format(date));
        for (EventInterface.SessionMonth month : this.iSessionMonths) {
            if (m != month.getMonth() + 1) continue;
            int d = Integer.parseInt(ServerDateTimeFormat.getFormat("dd").format(date)) - 1;
            if (month.hasFlag(d, EventInterface.SessionMonth.Flag.FINALS) && type != EventInterface.EventType.FinalExam) {
                return EventInterface.SessionMonth.Flag.FINALS;
            }
            if (month.hasFlag(d, EventInterface.SessionMonth.Flag.BREAK)) {
                return EventInterface.SessionMonth.Flag.BREAK;
            }
            if (month.hasFlag(d, EventInterface.SessionMonth.Flag.WEEKEND)) {
                return EventInterface.SessionMonth.Flag.WEEKEND;
            }
            if (month.hasFlag(d, EventInterface.SessionMonth.Flag.HOLIDAY)) {
                return EventInterface.SessionMonth.Flag.HOLIDAY;
            }
            if (month.hasFlag(d, EventInterface.SessionMonth.Flag.MIDTERMS) && type != EventInterface.EventType.MidtermExam) {
                return EventInterface.SessionMonth.Flag.MIDTERMS;
            }
            return null;
        }
        return null;
    }

    public static class HistoryToken {
        private String iType = null;
        private Map<String, String> iParams = new HashMap<String, String>();
        private Map<String, String> iDefaults = new HashMap<String, String>();

        public HistoryToken(PageType type) {
            this.iType = type.name();
            if (type.getParams() != null) {
                int i = 0;
                while (1 + i < type.getParams().length) {
                    this.iDefaults.put(type.getParams()[i], type.getParams()[i + 1]);
                    i += 2;
                }
            }
            for (Map.Entry params : Window.Location.getParameterMap().entrySet()) {
                this.iDefaults.put((String)params.getKey(), (String)((List)params.getValue()).get(0));
            }
            String cookie = EventCookie.getInstance().getHash(this.iType);
            if (cookie != null) {
                for (String pair : cookie.split("\\&")) {
                    String key;
                    int idx = pair.indexOf(61);
                    if (idx < 0 || Window.Location.getParameter((String)(key = pair.substring(0, idx))) != null) continue;
                    this.iParams.put(key, URL.decodeQueryString((String)pair.substring(idx + 1)));
                }
            }
            this.parse(History.getToken());
        }

        public void reset(String token) {
            this.iParams.clear();
            this.parse(token);
        }

        public void parse(String token) {
            if (token != null && !token.isEmpty()) {
                for (String pair : token.split("\\&")) {
                    int idx = pair.indexOf(61);
                    if (idx < 0) continue;
                    this.iParams.put(pair.substring(0, idx), URL.decodeQueryString((String)pair.substring(idx + 1)));
                }
            }
        }

        public void setParameter(String key, String value) {
            if (value == null) {
                this.iParams.remove(key);
            } else {
                String defaultValue = this.iDefaults.get(key);
                if (value.equals(defaultValue)) {
                    this.iParams.remove(key);
                } else {
                    this.iParams.put(key, value);
                }
            }
        }

        public void setParameter(String key, Long value) {
            this.setParameter(key, value == null ? null : value.toString());
        }

        public String toString() {
            return this.toString(null);
        }

        public String toString(String skip) {
            String ret = "";
            for (String key : new TreeSet<String>(this.iParams.keySet())) {
                if (key.equals(skip)) continue;
                if (!ret.isEmpty()) {
                    ret = ret + "&";
                }
                ret = ret + key + "=" + URL.encodeQueryString((String)this.iParams.get(key));
            }
            return ret;
        }

        public String getParameter(String key, String defaultValue) {
            String value = this.getParameter(key);
            return value == null ? defaultValue : value;
        }

        public String getParameter(String key) {
            String value = this.iParams.get(key);
            return value == null ? this.iDefaults.get(key) : value;
        }

        public String getDefaultParameter(String key, String defaultValue) {
            String value = this.iDefaults.get(key);
            return value == null ? defaultValue : value;
        }

        public void setDefaultParameter(String key, String value) {
            if (value != null) {
                this.iDefaults.put(key, value);
            }
        }

        public boolean hasParameter(String key) {
            return this.getParameter(key) != null;
        }

        public boolean isChanged(String key, String value) {
            String v = this.getParameter(key);
            return v == null ? value != null : !v.equals(value);
        }

        public boolean isChanged(String key, String defaultValue, String value) {
            String v = this.getParameter(key);
            return v == null ? !defaultValue.equals(value) : !v.equals(value);
        }

        public void mark() {
            String token = this.toString();
            if (!History.getToken().equals(token)) {
                History.newItem((String)token, (boolean)false);
            }
            EventCookie.getInstance().setHash(this.iType, this.toString("event"));
        }
    }

    private class RoomSelector
    extends IntervalSelector<EventInterface.ResourceInterface> {
        public RoomSelector() {
            super(true);
            this.addValueChangeHandler(new ValueChangeHandler<IntervalSelector.Interval>(){

                public void onValueChange(ValueChangeEvent<IntervalSelector.Interval> event) {
                    RoomSelector.this.setAriaLabel(ARIA.roomSelection(RoomSelector.this.toAriaString()));
                }
            });
            this.addFocusHandler(new FocusHandler(){

                public void onFocus(FocusEvent event) {
                    RoomSelector.this.setAriaLabel(ARIA.roomSelection(RoomSelector.this.toAriaString()));
                }
            });
        }

        @Override
        public IntervalSelector.Interval parse(String query) {
            if (query == null || query.isEmpty() || this.getValues() == null) {
                return new IntervalSelector.Interval(this);
            }
            IntervalSelector.Interval ret = null;
            for (int i = 0; i < this.getValues().size(); ++i) {
                EventInterface.ResourceInterface first = (EventInterface.ResourceInterface)this.getValues().get(i);
                if (query.equalsIgnoreCase(first.getName())) {
                    return new IntervalSelector.Interval(this, first);
                }
                for (int j = i + 1; j < this.getValues().size(); ++j) {
                    EventInterface.ResourceInterface last = (EventInterface.ResourceInterface)this.getValues().get(j);
                    if (query.equalsIgnoreCase(first.getName() + "-" + last.getName()) || query.equalsIgnoreCase(first.getName() + " - " + last.getName())) {
                        return new IntervalSelector.Interval(this, first, last);
                    }
                    if (this.filter(first) || this.filter(last)) continue;
                    if (query.toLowerCase().startsWith(first.getName().toLowerCase()) && ((first.getName() + "-" + last.getName()).toLowerCase().startsWith(query.toLowerCase()) || (first.getName() + " - " + last.getName()).toLowerCase().startsWith(query.toLowerCase()))) {
                        ret = new IntervalSelector.Interval(this, first, last);
                    }
                    if (!query.toLowerCase().startsWith(first.getName().toLowerCase()) || last.getName().indexOf(32) < 0) continue;
                    String building = last.getName().substring(0, last.getName().lastIndexOf(32));
                    String room = last.getName().substring(last.getName().lastIndexOf(32) + 1);
                    if (!first.getName().startsWith(building + " ") || !(first.getName() + "-" + room).toLowerCase().startsWith(query.toLowerCase()) && !(first.getName() + " - " + room).toLowerCase().startsWith(query.toLowerCase())) continue;
                    ret = new IntervalSelector.Interval(this, first, last);
                }
            }
            if (ret != null) {
                return ret;
            }
            EventInterface.ResourceInterface first = null;
            EventInterface.ResourceInterface last = null;
            for (EventInterface.ResourceInterface e : this.getValues()) {
                if (this.isFilterEnabled() && this.filter(e)) continue;
                if (e.getName().equalsIgnoreCase(query)) {
                    return new IntervalSelector.Interval(this, e);
                }
                if (e.getName().toLowerCase().startsWith(query.toLowerCase())) {
                    if (first == null) {
                        first = e;
                    }
                    last = e;
                    continue;
                }
                if (first == null) continue;
                return new IntervalSelector.Interval(this, first, last);
            }
            if (first != null) {
                return new IntervalSelector.Interval(this, first, last);
            }
            return new IntervalSelector.Interval(this);
        }

        @Override
        protected String getDisplayString(IntervalSelector.Interval interval) {
            if (interval == null || interval.isAll()) {
                return interval.isEnableFilter() ? MESSAGES.itemAllRoomsWithFilter() : MESSAGES.itemAllRooms();
            }
            if (interval.isOne()) {
                String hint = ((EventInterface.ResourceInterface)interval.getFirst()).getRoomType() + (((EventInterface.ResourceInterface)interval.getFirst()).hasSize() ? ", " + MESSAGES.hintRoomCapacity("" + ((EventInterface.ResourceInterface)interval.getFirst()).getSize()) : "") + (((EventInterface.ResourceInterface)interval.getFirst()).hasDistance() ? ", " + MESSAGES.hintRoomDistance("" + Math.round(((EventInterface.ResourceInterface)interval.getFirst()).getDistance())) : "");
                return ((EventInterface.ResourceInterface)interval.getFirst()).getName() + " <span class='item-hint'>" + hint + "</span>";
            }
            return "&nbsp;&nbsp;&nbsp;" + ((EventInterface.ResourceInterface)interval.getFirst()).getName() + " - " + ((EventInterface.ResourceInterface)interval.getLast()).getName();
        }

        @Override
        protected String getReplaceString(IntervalSelector.Interval interval) {
            if (interval == null || interval.isAll()) {
                return interval.isEnableFilter() ? MESSAGES.itemAllRoomsWithFilter() : MESSAGES.itemAllRooms();
            }
            return interval.isOne() ? ((EventInterface.ResourceInterface)interval.getFirst()).getName() : ((EventInterface.ResourceInterface)interval.getFirst()).getName() + " - " + ((EventInterface.ResourceInterface)interval.getLast()).getName();
        }

        public String getSelection() {
            if (this.getValue() == null || this.getValue().isAll()) {
                return "";
            }
            return this.getValue().isOne() ? ((EventInterface.ResourceInterface)this.getValue().getFirst()).getName() : ((EventInterface.ResourceInterface)this.getValue().getFirst()).getName() + "-" + ((EventInterface.ResourceInterface)this.getValue().getLast()).getName();
        }

        @Override
        public void setValue(IntervalSelector.Interval value, boolean fireEvents) {
            if (value != null && (value.getFirst() != null && this.filter(value.getFirst()) || value.getLast() != null && this.filter(value.getLast()))) {
                this.setFilterEnabled(false);
            }
            super.setValue(value, fireEvents);
        }
    }

    public static class ResourceSuggestion
    implements SuggestOracle.Suggestion {
        private EventInterface.ResourceInterface iResource;

        public ResourceSuggestion(EventInterface.ResourceInterface resource) {
            this.iResource = resource;
        }

        public EventInterface.ResourceInterface getResource() {
            return this.iResource;
        }

        public String getDisplayString() {
            if (this.iResource.hasTitle()) {
                return this.iResource.getTitle();
            }
            if (this.iResource.hasAbbreviation() && !this.iResource.getAbbreviation().equals(this.iResource.getName())) {
                return this.iResource.getAbbreviation() + " - " + this.iResource.getName();
            }
            return this.iResource.hasAbbreviation() ? this.iResource.getAbbreviation() : this.iResource.getName();
        }

        public String getReplacementString() {
            return this.iResource.hasAbbreviation() ? this.iResource.getAbbreviation() : this.iResource.getName();
        }
    }

    public static enum PageType {
        Timetable("tab", "0", "title", EventResourceTimetable.access$000().pageEventTimetable(), "rooms", "", "showClear", "true"),
        Events("filter", "events", "rooms", "flag:Event", "events", "mode:\"My Events\"", "type", "room", "title", EventResourceTimetable.access$000().pageEvents(), "fixedTitle", "true", "fixedType", "true", "tab", "1", "showClear", "true", "saveAsDefault", "events,rooms"),
        RoomTimetable("type", "room", "fixedType", "true", "title", EventResourceTimetable.access$000().pageRoomTimetable(), "showClear", "true"),
        Classes("type", "subject", "fixedType", "true", "events", "type:Class", "tab", "1", "filter", "classes", "rooms", "", "title", EventResourceTimetable.access$000().pageClasses(), "fixedTitle", "true", "addEvent", "false", "showFilter", "false", "showClear", "false"),
        Exams("type", "subject", "fixedType", "true", "events", "type:\"Final Exam\" type:\"Midterm Exam\"", "tab", "1", "filter", "exams", "rooms", "", "title", EventResourceTimetable.access$000().pageExaminations(), "fixedTitle", "true", "addEvent", "false", "showFilter", "false", "showClear", "false"),
        Personal("type", "person", "fixedType", "true", "events", "", "filter", "person", "rooms", "", "title", EventResourceTimetable.access$000().pagePersonalTimetable(), "addEvent", "false", "fixedTitle", "true", "showFilter", "false", "showClear", "false"),
        Availability("title", EventResourceTimetable.access$000().pageEventRoomAvailability(), "rooms", "flag:Event");

        String[] iParams = null;

        private PageType(String ... params) {
            this.iParams = params;
        }

        public String[] getParams() {
            return this.iParams;
        }
    }
}

