/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.events;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasValue;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.unitime.timetable.gwt.client.GwtHint;
import org.unitime.timetable.gwt.client.Lookup;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.events.EventAdd;
import org.unitime.timetable.gwt.client.events.EventComparator;
import org.unitime.timetable.gwt.client.events.EventCookie;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.sectioning.CourseDetailsWidget;
import org.unitime.timetable.gwt.client.widgets.NumberBox;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.ServerDateTimeFormat;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.TimeSelector;
import org.unitime.timetable.gwt.client.widgets.UniTimeDialogBox;
import org.unitime.timetable.gwt.client.widgets.UniTimeFrameDialog;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.client.widgets.UniTimeTableHeader;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtAriaMessages;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.gwt.shared.PersonInterface;

public class EventMeetingTable
extends UniTimeTable<EventMeetingRow>
implements HasValue<List<EventMeetingRow>> {
    private static GwtAriaMessages ARIA = (GwtAriaMessages)GWT.create(GwtAriaMessages.class);
    private static final GwtConstants CONSTANTS = (GwtConstants)GWT.create(GwtConstants.class);
    private static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    protected static GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private static DateTimeFormat sDateFormatApproval = DateTimeFormat.getFormat((String)CONSTANTS.eventDateFormat());
    private static DateTimeFormat sDateFormatExpiration = ServerDateTimeFormat.getFormat(CONSTANTS.eventDateFormat());
    private static DateTimeFormat sDateFormatShort = ServerDateTimeFormat.getFormat(CONSTANTS.eventDateFormatShort());
    private static DateTimeFormat sDateFormatLong = ServerDateTimeFormat.getFormat(CONSTANTS.eventDateFormatLong());
    private static DateTimeFormat sDateFormatMeeting = ServerDateTimeFormat.getFormat(CONSTANTS.meetingDateFormat());
    private static DateTimeFormat sDateFormatAria = ServerDateTimeFormat.getFormat(CONSTANTS.dateSelectionDateFormat());
    private Mode iMode = null;
    private boolean iShowMainContact = false;
    private EventComparator.EventMeetingSortBy iSortBy = null;
    private boolean iAsc = true;
    private boolean iSelectable = true;
    private boolean iEditable = false;
    private Map<OperationType, Implementation> iImplementations = new HashMap<OperationType, Implementation>();
    private MeetingFilter iMeetingFilter = null;
    private EventAdd.EventPropertiesProvider iPropertiesProvider = null;
    private boolean iShowMeetingContacts = false;

    public EventMeetingTable(Mode mode, boolean selectable, EventAdd.EventPropertiesProvider properties) {
        this.setStyleName("unitime-EventMeetings");
        this.iMode = mode;
        this.iSelectable = selectable;
        this.iPropertiesProvider = properties;
        if (this.getRowCount() > 0) {
            this.clearTable();
        }
        ArrayList<UniTimeTableHeader> header = new ArrayList<UniTimeTableHeader>();
        UniTimeTableHeader hTimes = new UniTimeTableHeader("&otimes;", HasHorizontalAlignment.ALIGN_CENTER);
        header.add(hTimes);
        hTimes.addOperation(new UniTimeTableHeader.Operation(){

            public void execute() {
                for (int row = 1; row < EventMeetingTable.this.getRowCount(); ++row) {
                    Widget w = EventMeetingTable.this.getWidget(row, 0);
                    if (w == null || !(w instanceof CheckBox)) continue;
                    CheckBox ch = (CheckBox)w;
                    ch.setValue(Boolean.valueOf(true));
                }
            }

            @Override
            public boolean isApplicable() {
                for (int row = 1; row < EventMeetingTable.this.getRowCount(); ++row) {
                    CheckBox ch;
                    Widget w = EventMeetingTable.this.getWidget(row, 0);
                    if (w == null || !(w instanceof CheckBox) || (ch = (CheckBox)w).getValue().booleanValue()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public boolean hasSeparator() {
                return false;
            }

            @Override
            public String getName() {
                return MESSAGES.opSelectAll();
            }
        });
        hTimes.addOperation(new UniTimeTableHeader.Operation(){

            public void execute() {
                for (int row = 1; row < EventMeetingTable.this.getRowCount(); ++row) {
                    Widget w = EventMeetingTable.this.getWidget(row, 0);
                    if (w == null || !(w instanceof CheckBox)) continue;
                    CheckBox ch = (CheckBox)w;
                    ch.setValue(Boolean.valueOf(((EventMeetingRow)EventMeetingTable.this.getData(row)).inConflict()));
                }
            }

            @Override
            public boolean isApplicable() {
                for (int row = 1; row < EventMeetingTable.this.getRowCount(); ++row) {
                    Widget w = EventMeetingTable.this.getWidget(row, 0);
                    if (w == null || !(w instanceof CheckBox) || !((EventMeetingRow)EventMeetingTable.this.getData(row)).inConflict()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public boolean hasSeparator() {
                return false;
            }

            @Override
            public String getName() {
                return MESSAGES.opSelectAllConflicting();
            }
        });
        hTimes.addOperation(new UniTimeTableHeader.Operation(){

            public void execute() {
                for (int row = 1; row < EventMeetingTable.this.getRowCount(); ++row) {
                    Widget w = EventMeetingTable.this.getWidget(row, 0);
                    if (w == null || !(w instanceof CheckBox)) continue;
                    CheckBox ch = (CheckBox)w;
                    ch.setValue(Boolean.valueOf(false));
                }
            }

            @Override
            public boolean isApplicable() {
                for (int row = 1; row < EventMeetingTable.this.getRowCount(); ++row) {
                    CheckBox ch;
                    Widget w = EventMeetingTable.this.getWidget(row, 0);
                    if (w == null || !(w instanceof CheckBox) || !(ch = (CheckBox)w).getValue().booleanValue()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public boolean hasSeparator() {
                return false;
            }

            @Override
            public String getName() {
                return MESSAGES.opClearSelection();
            }
        });
        hTimes.addOperation(new UniTimeTableHeader.Operation(){

            public void execute() {
                EventMeetingTable.this.getOperation(OperationType.AddMeetings).execute(EventMeetingTable.this, OperationType.AddMeetings, null);
            }

            @Override
            public boolean isApplicable() {
                return EventMeetingTable.this.hasOperation(OperationType.AddMeetings);
            }

            @Override
            public boolean hasSeparator() {
                return true;
            }

            @Override
            public String getName() {
                return MESSAGES.opAddMeetings();
            }
        });
        hTimes.addOperation(new EventMeetingOperation(){

            @Override
            public boolean hasSeparator() {
                return false;
            }

            @Override
            public String getName() {
                return this.hasSelection() ? MESSAGES.opDeleteSelectedMeetings() : MESSAGES.opDeleteNewMeetings();
            }

            @Override
            public boolean isApplicable(EventMeetingRow row) {
                return EventMeetingTable.this.isEditable() && row.isCanDelete();
            }

            @Override
            public void execute(int row, EventMeetingRow event) {
                while (row + 1 < EventMeetingTable.this.getRowCount() && ((EventMeetingRow)EventMeetingTable.this.getData(row + 1)).hasParent()) {
                    EventMeetingTable.this.removeRow(row + 1);
                }
                if (((EventMeetingRow)EventMeetingTable.this.getData(row)).getMeeting().getId() == null) {
                    EventMeetingTable.this.removeRow(row);
                } else {
                    EventInterface.MeetingInterface meeting = ((EventMeetingRow)EventMeetingTable.this.getData(row)).getMeeting();
                    meeting.setApprovalStatus(EventInterface.ApprovalStatus.Deleted);
                    meeting.setCanApprove(false);
                    meeting.setCanCancel(false);
                    meeting.setCanInquire(false);
                    meeting.setCanEdit(false);
                    meeting.setCanDelete(false);
                    EventMeetingTable.this.getRowFormatter().addStyleName(row, "deleted-row");
                    EventMeetingTable.this.setWidget(row, 0, (Widget)new HTML("&nbsp;"));
                    HTML approval = (HTML)EventMeetingTable.this.getWidget(row, EventMeetingTable.this.getHeader(MESSAGES.colApproval()).getColumn());
                    approval.setStyleName("deleted-meeting");
                    approval.setText(MESSAGES.approvalDeleted());
                    ValueChangeEvent.fire((HasValueChangeHandlers)EventMeetingTable.this, (Object)EventMeetingTable.this.getValue());
                }
            }

            @Override
            public void execute() {
                super.execute();
                if (EventMeetingTable.this.hasOperation(OperationType.Delete)) {
                    EventMeetingTable.this.getOperation(OperationType.Delete).execute(EventMeetingTable.this, OperationType.Delete, null);
                }
            }
        });
        hTimes.addOperation(new EventMeetingOperation(){

            @Override
            public boolean hasSeparator() {
                return true;
            }

            @Override
            public boolean allMustMatch(boolean hasSelection) {
                return false;
            }

            @Override
            public String getName() {
                return this.hasSelection() ? MESSAGES.opInquireSelectedMeetings() : MESSAGES.opInquireAllMeetings();
            }

            @Override
            public boolean isApplicable(EventMeetingRow row) {
                return EventMeetingTable.this.hasOperation(OperationType.Inquire) && row.isCanInquire();
            }

            @Override
            public void execute(int row, EventMeetingRow event) {
            }

            @Override
            public void execute() {
                EventMeetingTable.this.getOperation(OperationType.Inquire).execute(EventMeetingTable.this, OperationType.Inquire, this.data());
            }

            @Override
            public boolean allowNoSelection() {
                return EventMeetingTable.this.getMode().hasFlag(ModeFlag.AllowApproveAll);
            }
        });
        hTimes.addOperation(new EventMeetingOperation(){

            @Override
            public boolean hasSeparator() {
                return false;
            }

            @Override
            public String getName() {
                return this.hasSelection() ? MESSAGES.opApproveSelectedMeetings() : MESSAGES.opApproveAllMeetings();
            }

            @Override
            public boolean isApplicable(EventMeetingRow row) {
                return EventMeetingTable.this.hasOperation(OperationType.Approve) && row.isCanApprove();
            }

            @Override
            public void execute(int row, EventMeetingRow event) {
            }

            @Override
            public void execute() {
                EventMeetingTable.this.getOperation(OperationType.Approve).execute(EventMeetingTable.this, OperationType.Approve, this.data());
            }

            @Override
            public boolean allowNoSelection() {
                return EventMeetingTable.this.getMode().hasFlag(ModeFlag.AllowApproveAll);
            }
        });
        hTimes.addOperation(new EventMeetingOperation(){

            @Override
            public boolean hasSeparator() {
                return false;
            }

            @Override
            public String getName() {
                if (EventMeetingTable.this.hasOperation(OperationType.Delete)) {
                    return this.hasSelection() ? MESSAGES.opCancelSelectedMeetingsNoPopup() : MESSAGES.opCancelAllMeetingsNoPopup();
                }
                return this.hasSelection() ? MESSAGES.opCancelSelectedMeetings() : MESSAGES.opCancelAllMeetings();
            }

            @Override
            public boolean isApplicable(EventMeetingRow row) {
                return EventMeetingTable.this.hasOperation(OperationType.Cancel) && row.isCanCancel() || EventMeetingTable.this.isEditable() && row.isCanCancel();
            }

            @Override
            public void execute(int row, EventMeetingRow event) {
                if (EventMeetingTable.this.isEditable()) {
                    while (row + 1 < EventMeetingTable.this.getRowCount() && ((EventMeetingRow)EventMeetingTable.this.getData(row + 1)).hasParent()) {
                        EventMeetingTable.this.removeRow(row + 1);
                    }
                    if (((EventMeetingRow)EventMeetingTable.this.getData(row)).getMeeting().getId() == null) {
                        EventMeetingTable.this.removeRow(row);
                    } else {
                        ((EventMeetingRow)EventMeetingTable.this.getData(row)).getMeeting().setApprovalStatus(EventInterface.ApprovalStatus.Cancelled);
                        EventMeetingTable.this.getRowFormatter().addStyleName(row, "cancelled-row");
                        EventMeetingTable.this.setWidget(row, 0, (Widget)new HTML("&nbsp;"));
                        HTML approval = (HTML)EventMeetingTable.this.getWidget(row, EventMeetingTable.this.getHeader(MESSAGES.colApproval()).getColumn());
                        approval.setStyleName("cancelled-meeting");
                        approval.setText(MESSAGES.approvalCancelled());
                        ValueChangeEvent.fire((HasValueChangeHandlers)EventMeetingTable.this, (Object)EventMeetingTable.this.getValue());
                    }
                }
            }

            @Override
            public void execute() {
                super.execute();
                if (EventMeetingTable.this.hasOperation(OperationType.Cancel)) {
                    EventMeetingTable.this.getOperation(OperationType.Cancel).execute(EventMeetingTable.this, OperationType.Cancel, this.data());
                }
            }

            @Override
            public boolean allowNoSelection() {
                return EventMeetingTable.this.getMode().hasFlag(ModeFlag.AllowApproveAll);
            }
        });
        hTimes.addOperation(new EventMeetingOperation(){

            @Override
            public boolean hasSeparator() {
                return false;
            }

            @Override
            public String getName() {
                return this.hasSelection() ? MESSAGES.opRejectSelectedMeetings() : MESSAGES.opRejectAllMeetings();
            }

            @Override
            public boolean isApplicable(EventMeetingRow row) {
                return EventMeetingTable.this.hasOperation(OperationType.Reject) && row.isCanApprove();
            }

            @Override
            public void execute(int row, EventMeetingRow event) {
            }

            @Override
            public void execute() {
                EventMeetingTable.this.getOperation(OperationType.Reject).execute(EventMeetingTable.this, OperationType.Reject, this.data());
            }

            @Override
            public boolean allowNoSelection() {
                return EventMeetingTable.this.getMode().hasFlag(ModeFlag.AllowApproveAll);
            }
        });
        hTimes.addOperation(new EventMeetingOperation(){

            @Override
            public void execute() {
                EventMeetingTable.this.getOperation(OperationType.Modify).execute(EventMeetingTable.this, OperationType.Modify, this.data());
            }

            @Override
            public String getName() {
                return MESSAGES.opModifyMeetings();
            }

            @Override
            public boolean isApplicable() {
                Integer start = null;
                Integer end = null;
                boolean hasSelection = this.hasSelection();
                if (hasSelection) {
                    for (int row = 1; row < EventMeetingTable.this.getRowCount(); ++row) {
                        CheckBox ch;
                        Widget w = EventMeetingTable.this.getWidget(row, 0);
                        if (w == null || !(w instanceof CheckBox) || !(ch = (CheckBox)w).getValue().booleanValue()) continue;
                        EventMeetingRow e = (EventMeetingRow)EventMeetingTable.this.getData(row);
                        if (!this.isApplicable(e)) {
                            return false;
                        }
                        if (start == null) {
                            start = e.getMeeting().getStartSlot();
                            end = e.getMeeting().getEndSlot();
                            continue;
                        }
                        if (start.intValue() == e.getMeeting().getStartSlot() && end.intValue() == e.getMeeting().getEndSlot()) continue;
                        return false;
                    }
                    return true;
                }
                if (this.allowNoSelection()) {
                    boolean canSelect = false;
                    for (int row = 1; row < EventMeetingTable.this.getRowCount(); ++row) {
                        Widget w = EventMeetingTable.this.getWidget(row, 0);
                        if (w == null || !(w instanceof CheckBox)) continue;
                        EventMeetingRow e = (EventMeetingRow)EventMeetingTable.this.getData(row);
                        if (!this.isApplicable(e)) {
                            return false;
                        }
                        if (start == null) {
                            start = e.getMeeting().getStartSlot();
                            end = e.getMeeting().getEndSlot();
                        } else if (start.intValue() != e.getMeeting().getStartSlot() || end.intValue() != e.getMeeting().getEndSlot()) {
                            return false;
                        }
                        canSelect = true;
                    }
                    return canSelect;
                }
                return false;
            }

            @Override
            public boolean allMustMatch(boolean hasSelection) {
                return true;
            }

            @Override
            public boolean isApplicable(EventMeetingRow data) {
                return EventMeetingTable.this.isEditable() && EventMeetingTable.this.hasOperation(OperationType.Modify) && data.getMeeting() != null && (data.getMeeting().getId() == null || data.getMeeting().isCanDelete() || data.getMeeting().isCanCancel());
            }

            @Override
            public void execute(int row, EventMeetingRow data) {
            }
        });
        hTimes.addOperation(new EventMeetingOperation(){

            @Override
            public void execute() {
                Integer so = null;
                Integer eo = null;
                boolean soSame = true;
                boolean eoSame = true;
                for (EventMeetingRow r : this.data()) {
                    EventInterface.MeetingInterface m = r.getMeeting();
                    if (so == null) {
                        so = m.getStartOffset();
                    } else if (m.getStartOffset() != so.intValue()) {
                        soSame = false;
                    }
                    if (eo == null) {
                        eo = -m.getEndOffset();
                        continue;
                    }
                    if (-m.getEndOffset() == eo) continue;
                    eoSame = false;
                }
                final UniTimeDialogBox dialog = new UniTimeDialogBox(true, false);
                SimpleForm simple = new SimpleForm();
                simple.removeStyleName("unitime-NotPrintableBottomLine");
                final NumberBox setupTime = new NumberBox();
                if (soSame && so != null) {
                    setupTime.setValue(so);
                }
                simple.addRow(MESSAGES.propSetupTime(), (Widget)setupTime);
                final NumberBox teardownTime = new NumberBox();
                if (eoSame && eo != null) {
                    teardownTime.setValue(eo);
                }
                simple.addRow(MESSAGES.propTeardownTime(), (Widget)teardownTime);
                UniTimeHeaderPanel footer = new UniTimeHeaderPanel();
                footer.addButton("ok", MESSAGES.buttonOk(), 75, new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        int colSetup = EventMeetingTable.this.getHeader(MESSAGES.colSetupTimeShort()).getColumn();
                        int colTear = EventMeetingTable.this.getHeader(MESSAGES.colTeardownTimeShort()).getColumn();
                        int colPubl = EventMeetingTable.this.getHeader(MESSAGES.colPublishedTime()).getColumn();
                        for (Integer row : this.rows()) {
                            EventInterface.MeetingInterface meeting = ((EventMeetingRow)EventMeetingTable.this.getData(row)).getMeeting();
                            if (setupTime.toInteger() != null) {
                                meeting.setStartOffset(setupTime.toInteger());
                            }
                            if (teardownTime.toInteger() != null) {
                                meeting.setEndOffset(-teardownTime.toInteger().intValue());
                            }
                            ((UniTimeTable.NumberCell)EventMeetingTable.this.getWidget(row, colSetup)).setText(String.valueOf(meeting.getStartOffset()));
                            ((UniTimeTable.NumberCell)EventMeetingTable.this.getWidget(row, colTear)).setText(String.valueOf(-meeting.getEndOffset()));
                            ((Label)EventMeetingTable.this.getWidget(row, colPubl)).setText(meeting.getMeetingTime(CONSTANTS));
                        }
                        dialog.hide();
                    }
                });
                footer.addButton("cancel", MESSAGES.buttonCancel(), 75, new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        dialog.hide();
                    }
                });
                simple.addBottomRow((Widget)footer);
                dialog.setWidget((Widget)simple);
                dialog.setText(MESSAGES.dlgChangeOffsets());
                dialog.setEscapeToHide(true);
                dialog.center();
            }

            @Override
            public String getName() {
                return MESSAGES.opChangeOffsets();
            }

            @Override
            public boolean isApplicable(EventMeetingRow data) {
                return EventMeetingTable.this.isEditable() && data.getMeeting() != null && (data.getMeeting().getId() == null || data.getMeeting().isCanEdit());
            }

            @Override
            public void execute(int row, EventMeetingRow data) {
            }
        });
        hTimes.addOperation(new EventMeetingOperation(){
            Lookup iLookup = null;

            @Override
            public String getName() {
                return MESSAGES.opAddMeetingContact();
            }

            @Override
            public boolean isApplicable(EventMeetingRow data) {
                return EventMeetingTable.this.iPropertiesProvider.getProperties().isCanEditMeetingContacts() && EventMeetingTable.this.isEditable() && data.getMeeting() != null && (data.getMeeting().getId() == null || data.getMeeting().isCanEdit());
            }

            @Override
            public void execute(int row, EventMeetingRow event) {
            }

            @Override
            public void execute() {
                if (this.iLookup == null) {
                    this.iLookup = new Lookup();
                    this.iLookup.addValueChangeHandler(new ValueChangeHandler<PersonInterface>(){

                        public void onValueChange(ValueChangeEvent<PersonInterface> event) {
                            int colMeetingContacts = EventMeetingTable.this.getHeader(MESSAGES.colMeetingContacts()).getColumn();
                            if (event.getValue() != null) {
                                EventInterface.ContactInterface contact = new EventInterface.ContactInterface((PersonInterface)event.getValue());
                                for (Integer row : this.rows()) {
                                    EventInterface.MeetingInterface meeting = ((EventMeetingRow)EventMeetingTable.this.getData(row)).getMeeting();
                                    meeting.addMeetingContact(contact);
                                    ((HTML)EventMeetingTable.this.getWidget(row, colMeetingContacts)).setHTML(meeting.getMeetingContacts(CONSTANTS.meetingContactsSeparator(), MESSAGES));
                                }
                                EventMeetingTable.this.setColumnVisible(colMeetingContacts, true);
                            }
                        }
                    });
                }
                this.iLookup.setOptions("mustHaveExternalId" + (EventMeetingTable.this.iPropertiesProvider.getSessionId() == null ? "" : ",session=" + EventMeetingTable.this.iPropertiesProvider.getSessionId()));
                this.iLookup.center();
            }
        });
        hTimes.addOperation(new EventMeetingOperation(){

            @Override
            public String getName() {
                return MESSAGES.opRemoveMeetingContact();
            }

            @Override
            public boolean isApplicable(EventMeetingRow data) {
                return EventMeetingTable.this.iPropertiesProvider.getProperties().isCanEditMeetingContacts() && EventMeetingTable.this.isColumnVisible(EventMeetingTable.this.getHeader(MESSAGES.colMeetingContacts()).getColumn()) && EventMeetingTable.this.isEditable() && data.getMeeting() != null && (data.getMeeting().getId() == null || data.getMeeting().isCanEdit());
            }

            @Override
            public void execute(int row, EventMeetingRow event) {
            }

            @Override
            public void execute() {
                final TreeSet<EventInterface.ContactInterface> contacts = new TreeSet<EventInterface.ContactInterface>();
                for (Integer row : this.rows()) {
                    EventInterface.MeetingInterface meeting = ((EventMeetingRow)EventMeetingTable.this.getData(row)).getMeeting();
                    if (!meeting.hasMeetingContacts()) continue;
                    contacts.addAll(meeting.getMeetingContacts());
                }
                if (contacts.isEmpty()) {
                    UniTimeNotifications.warn(MESSAGES.warnSelectedMeetingsHaveNoMeetingContacts());
                } else if (contacts.size() == 1) {
                    EventInterface.ContactInterface contact = (EventInterface.ContactInterface)contacts.first();
                    int colMeetingContacts = EventMeetingTable.this.getHeader(MESSAGES.colMeetingContacts()).getColumn();
                    for (Integer row : this.rows()) {
                        EventInterface.MeetingInterface meeting = ((EventMeetingRow)EventMeetingTable.this.getData(row)).getMeeting();
                        if (!meeting.hasMeetingContacts()) continue;
                        meeting.getMeetingContacts().remove(contact);
                        ((HTML)EventMeetingTable.this.getWidget(row, colMeetingContacts)).setHTML(meeting.getMeetingContacts(CONSTANTS.meetingContactsSeparator(), MESSAGES));
                    }
                } else {
                    final UniTimeDialogBox dialog = new UniTimeDialogBox(true, false);
                    final ListBox list = new ListBox();
                    list.setMultipleSelect(true);
                    for (EventInterface.ContactInterface contact : contacts) {
                        list.addItem(contact.getName(MESSAGES));
                    }
                    ToolBox.setMinWidth(list.getElement().getStyle(), "200px");
                    SimpleForm simple = new SimpleForm();
                    simple.removeStyleName("unitime-NotPrintableBottomLine");
                    simple.addRow(MESSAGES.propMeetingContacts(), (Widget)list);
                    UniTimeHeaderPanel footer = new UniTimeHeaderPanel();
                    footer.addButton("selected", MESSAGES.buttonRemoveSelected(), 75, new ClickHandler(){

                        public void onClick(ClickEvent event) {
                            int colMeetingContacts = EventMeetingTable.this.getHeader(MESSAGES.colMeetingContacts()).getColumn();
                            for (Integer row : this.rows()) {
                                EventInterface.MeetingInterface meeting = ((EventMeetingRow)EventMeetingTable.this.getData(row)).getMeeting();
                                if (!meeting.hasMeetingContacts()) continue;
                                int i = 0;
                                for (EventInterface.ContactInterface contact : contacts) {
                                    if (!list.isItemSelected(i++)) continue;
                                    meeting.getMeetingContacts().remove(contact);
                                }
                                ((HTML)EventMeetingTable.this.getWidget(row, colMeetingContacts)).setHTML(meeting.getMeetingContacts(CONSTANTS.meetingContactsSeparator(), MESSAGES));
                            }
                            dialog.hide();
                        }
                    });
                    footer.addButton("all", MESSAGES.buttonRemoveAll(), 75, new ClickHandler(){

                        public void onClick(ClickEvent event) {
                            int colMeetingContacts = EventMeetingTable.this.getHeader(MESSAGES.colMeetingContacts()).getColumn();
                            for (Integer row : this.rows()) {
                                EventInterface.MeetingInterface meeting = ((EventMeetingRow)EventMeetingTable.this.getData(row)).getMeeting();
                                if (meeting.hasMeetingContacts()) {
                                    meeting.getMeetingContacts().clear();
                                }
                                ((HTML)EventMeetingTable.this.getWidget(row, colMeetingContacts)).setHTML(meeting.getMeetingContacts(CONSTANTS.meetingContactsSeparator(), MESSAGES));
                            }
                            dialog.hide();
                        }
                    });
                    footer.addButton("cancel", MESSAGES.buttonCancel(), 75, new ClickHandler(){

                        public void onClick(ClickEvent event) {
                            dialog.hide();
                        }
                    });
                    simple.addBottomRow((Widget)footer);
                    dialog.setWidget((Widget)simple);
                    dialog.setText(MESSAGES.dlgRemoveMeetingContacts());
                    dialog.setEscapeToHide(true);
                    dialog.setEnterToSubmit(new Command(){

                        public void execute() {
                            int colMeetingContacts = EventMeetingTable.this.getHeader(MESSAGES.colMeetingContacts()).getColumn();
                            for (Integer row : this.rows()) {
                                EventInterface.MeetingInterface meeting = ((EventMeetingRow)EventMeetingTable.this.getData(row)).getMeeting();
                                if (!meeting.hasMeetingContacts()) continue;
                                int i = 0;
                                for (EventInterface.ContactInterface contact : contacts) {
                                    if (!list.isItemSelected(i++)) continue;
                                    meeting.getMeetingContacts().remove(contact);
                                }
                                ((HTML)EventMeetingTable.this.getWidget(row, colMeetingContacts)).setHTML(meeting.getMeetingContacts(CONSTANTS.meetingContactsSeparator(), MESSAGES));
                            }
                            dialog.hide();
                        }
                    });
                    dialog.center();
                    list.setFocus(true);
                }
            }
        });
        UniTimeTableHeader hName = new UniTimeTableHeader(MESSAGES.colName());
        header.add(hName);
        UniTimeTableHeader hSection = new UniTimeTableHeader(MESSAGES.colSection(), HasHorizontalAlignment.ALIGN_RIGHT);
        header.add(hSection);
        UniTimeTableHeader hType = new UniTimeTableHeader(MESSAGES.colType());
        header.add(hType);
        UniTimeTableHeader hTitle = new UniTimeTableHeader(MESSAGES.colTitle());
        header.add(hTitle);
        UniTimeTableHeader hNote = new UniTimeTableHeader(MESSAGES.colNote());
        header.add(hNote);
        UniTimeTableHeader hDate = new UniTimeTableHeader(MESSAGES.colDate());
        header.add(hDate);
        UniTimeTableHeader hTimePub = new UniTimeTableHeader(MESSAGES.colPublishedTime());
        header.add(hTimePub);
        UniTimeTableHeader hTimeAll = new UniTimeTableHeader(MESSAGES.colAllocatedTime());
        header.add(hTimeAll);
        UniTimeTableHeader hTimeSetup = new UniTimeTableHeader(MESSAGES.colSetupTimeShort(), HasHorizontalAlignment.ALIGN_RIGHT);
        header.add(hTimeSetup);
        UniTimeTableHeader hTimeTeardown = new UniTimeTableHeader(MESSAGES.colTeardownTimeShort(), HasHorizontalAlignment.ALIGN_RIGHT);
        header.add(hTimeTeardown);
        UniTimeTableHeader hLocation = new UniTimeTableHeader(MESSAGES.colLocation());
        header.add(hLocation);
        UniTimeTableHeader hCapacity = new UniTimeTableHeader(MESSAGES.colCapacity(), HasHorizontalAlignment.ALIGN_RIGHT);
        header.add(hCapacity);
        UniTimeTableHeader hMeetingContacts = new UniTimeTableHeader(MESSAGES.colMeetingContacts());
        header.add(hMeetingContacts);
        UniTimeTableHeader hEnrollment = new UniTimeTableHeader(MESSAGES.colEnrollment(), HasHorizontalAlignment.ALIGN_RIGHT);
        header.add(hEnrollment);
        UniTimeTableHeader hLimit = new UniTimeTableHeader(MESSAGES.colLimit(), HasHorizontalAlignment.ALIGN_RIGHT);
        header.add(hLimit);
        UniTimeTableHeader hSponsor = new UniTimeTableHeader(MESSAGES.colSponsorOrInstructor());
        header.add(hSponsor);
        UniTimeTableHeader hRequestedServices = new UniTimeTableHeader(MESSAGES.colRequestedServices());
        header.add(hRequestedServices);
        UniTimeTableHeader hContact = new UniTimeTableHeader(MESSAGES.colMainContact());
        header.add(hContact);
        UniTimeTableHeader hApproval = new UniTimeTableHeader(MESSAGES.colApproval());
        header.add(hApproval);
        UniTimeTableHeader hLastChange = new UniTimeTableHeader(MESSAGES.colLastChange());
        header.add(hLastChange);
        this.addRow(null, header);
        final UniTimeTableHeader.Operation titleOp = this.addHideOperation(hTitle, EventInterface.EventFlag.SHOW_TITLE, new Check(){

            @Override
            public boolean isChecked() {
                return true;
            }
        });
        final UniTimeTableHeader.Operation noteOp = this.addHideOperation(hNote, EventInterface.EventFlag.SHOW_NOTE, new Check(){

            @Override
            public boolean isChecked() {
                return !titleOp.isApplicable();
            }
        });
        this.addHideOperation(hTimePub, EventInterface.EventFlag.SHOW_PUBLISHED_TIME, new Check(){

            @Override
            public boolean isChecked() {
                return !titleOp.isApplicable() && !noteOp.isApplicable();
            }
        });
        this.addHideOperation(hTimeAll, EventInterface.EventFlag.SHOW_ALLOCATED_TIME);
        this.addHideOperation(hTimeSetup, EventInterface.EventFlag.SHOW_SETUP_TIME);
        this.addHideOperation(hTimeTeardown, EventInterface.EventFlag.SHOW_TEARDOWN_TIME);
        this.addHideOperation(hCapacity, EventInterface.EventFlag.SHOW_CAPACITY);
        this.addHideOperation(hMeetingContacts, EventInterface.EventFlag.SHOW_MEETING_CONTACTS);
        this.addHideOperation(hEnrollment, EventInterface.EventFlag.SHOW_ENROLLMENT);
        this.addHideOperation(hLimit, EventInterface.EventFlag.SHOW_LIMIT);
        this.addHideOperation(hSponsor, EventInterface.EventFlag.SHOW_SPONSOR);
        this.addHideOperation(hRequestedServices, EventInterface.EventFlag.SHOW_REQUESTED_SERVICES);
        this.addHideOperation(hContact, EventInterface.EventFlag.SHOW_MAIN_CONTACT);
        this.addHideOperation(hApproval, EventInterface.EventFlag.SHOW_APPROVAL);
        this.addHideOperation(hLastChange, EventInterface.EventFlag.SHOW_LAST_CHANGE);
        UniTimeTableHeader.AriaOperation hideDuplicitiesForMeetings = new UniTimeTableHeader.AriaOperation(){

            @Override
            public boolean isApplicable() {
                return EventMeetingTable.this.iMode.hasFlag(ModeFlag.CanHideDuplicitiesForMeetings);
            }

            @Override
            public boolean hasSeparator() {
                return true;
            }

            public void execute() {
                EventCookie.getInstance().setHideDuplicitiesForMeetings(!EventCookie.getInstance().isHideDuplicitiesForMeetings());
                int colDate = EventMeetingTable.this.getHeader(MESSAGES.colDate()).getColumn();
                int colApproval = EventMeetingTable.this.getHeader(MESSAGES.colApproval()).getColumn();
                for (int row = 1; row < EventMeetingTable.this.getRowCount(); ++row) {
                    EventMeetingRow data = (EventMeetingRow)EventMeetingTable.this.getData(row);
                    if (data == null) continue;
                    EventInterface event = data.getEvent();
                    String[] mtgs = new String[]{"", "", "", "", "", "", "", ""};
                    String prevApproval = null;
                    String[] prev = null;
                    String prevSpan = null;
                    String approval = "";
                    boolean globalUnavailability = event != null && event.getId() != null && event.getId() < 0L && event.getType() == EventInterface.EventType.Unavailabile;
                    for (EventInterface.MultiMeetingInterface m : EventInterface.getMultiMeetings(data.getMeetings(EventMeetingTable.this.getMeetingFilter()), true, globalUnavailability ? null : EventMeetingTable.this.iPropertiesProvider, event == null ? null : event.getType(), EventMeetingTable.this.iShowMeetingContacts)) {
                        String[] stringArray = new String[8];
                        stringArray[0] = m.isArrangeHours() ? (event.hasMessage() ? event.getMessage() : CONSTANTS.arrangeHours()) : m.getDays(EventMeetingTable.this.iPropertiesProvider.getFirstDayOfWeek(), CONSTANTS) + " " + (m.getNrMeetings() == 1 ? sDateFormatLong.format(m.getFirstMeetingDate()) : sDateFormatShort.format(m.getFirstMeetingDate()) + " - " + sDateFormatLong.format(m.getLastMeetingDate()));
                        stringArray[1] = m.isArrangeHours() && event.hasMessage() ? CONSTANTS.arrangeHours() : m.getMeetings().first().getMeetingTime(CONSTANTS);
                        stringArray[2] = m.getMeetings().first().getAllocatedTime(CONSTANTS);
                        stringArray[3] = String.valueOf(m.getMeetings().first().getStartOffset());
                        stringArray[4] = String.valueOf(-m.getMeetings().first().getEndOffset());
                        stringArray[5] = m.getLocationNameWithHint(MESSAGES);
                        stringArray[6] = m.getMeetings().first().getLocation() == null ? "" : (m.getMeetings().first().getLocation().hasSize() ? m.getMeetings().first().getLocation().getSize().toString() : MESSAGES.notApplicable());
                        stringArray[7] = EventMeetingTable.this.iShowMeetingContacts ? m.getMeetingContacts(CONSTANTS.meetingContactsSeparator(), MESSAGES) : "";
                        String[] mtg = stringArray;
                        if (!m.isArrangeHours() && !m.isPast()) {
                            Enum dateFlag;
                            Enum enum_ = globalUnavailability || EventMeetingTable.this.iPropertiesProvider == null ? null : (dateFlag = EventMeetingTable.this.iPropertiesProvider.getDateFlag(event == null ? null : event.getType(), m.getFirstMeetingDate()));
                            if (dateFlag != null) {
                                switch (23.$SwitchMap$org$unitime$timetable$gwt$shared$EventInterface$SessionMonth$Flag[dateFlag.ordinal()]) {
                                    case 1: {
                                        mtg[0] = "<span class='finals' title=\"" + MESSAGES.hintFinals() + "\">" + mtg[0] + "</span>";
                                        break;
                                    }
                                    case 2: {
                                        mtg[0] = "<span class='midterms' title=\"" + MESSAGES.hintMidterms() + "\">" + mtg[0] + "</span>";
                                        break;
                                    }
                                    case 3: {
                                        mtg[0] = "<span class='break' title=\"" + MESSAGES.hintBreak() + "\">" + mtg[0] + "</span>";
                                        break;
                                    }
                                    case 4: {
                                        mtg[0] = "<span class='holiday' title=\"" + MESSAGES.hintHoliday() + "\">" + mtg[0] + "</span>";
                                        break;
                                    }
                                    case 5: {
                                        mtg[0] = "<span class='weekend' title=\"" + MESSAGES.hintWeekend() + "\">" + mtg[0] + "</span>";
                                    }
                                }
                            }
                        }
                        if (!m.isArrangeHours() && EventMeetingTable.this.iPropertiesProvider != null && EventMeetingTable.this.iPropertiesProvider.isTooEarly(m.getMeetings().first().getStartSlot(), m.getMeetings().first().getEndSlot())) {
                            for (int i = 1; i <= 2; ++i) {
                                mtg[i] = "<span class='early' title=\"" + MESSAGES.hintTooEarly() + "\">" + mtg[i] + "</span>";
                            }
                        }
                        String span = "";
                        if (m.getApprovalStatus() == EventInterface.ApprovalStatus.Cancelled) {
                            span = "cancelled-meeting";
                        } else if (m.getApprovalStatus() == EventInterface.ApprovalStatus.Rejected) {
                            span = "rejected-meeting";
                        } else if (m.isPast()) {
                            span = "past-meeting";
                        } else if (m.hasStyle()) {
                            span = m.getStyle();
                        }
                        for (int i = 0; i < mtgs.length; ++i) {
                            int n = i;
                            mtgs[n] = mtgs[n] + (mtgs[i].isEmpty() ? "" : "<br>") + (prev != null && span.equals(prevSpan) && prev[i == 6 ? i - 1 : i].equals(mtg[i == 6 ? i - 1 : i]) && (i != 7 || !mtg[i].isEmpty()) ? MESSAGES.repeatingSymbol() : (!span.isEmpty() ? "<span class='" + span + "'>" : "") + mtg[i] + (!span.isEmpty() ? "</span>" : ""));
                        }
                        String thisApproval = m.getApprovalStatus() == EventInterface.ApprovalStatus.Approved ? sDateFormatApproval.format(m.getApprovalDate()) : (m.getApprovalStatus() == EventInterface.ApprovalStatus.Cancelled ? MESSAGES.approvalCancelled() : (m.getApprovalStatus() == EventInterface.ApprovalStatus.Rejected ? MESSAGES.approvalRejected() : ""));
                        approval = approval + (approval.isEmpty() ? "" : "<br>") + (prev != null && span.equals(prevSpan) && prevApproval.equals(thisApproval) ? MESSAGES.repeatingSymbol() : (m.getApprovalStatus() == EventInterface.ApprovalStatus.Approved ? (m.isPast() ? "<span class='past-meeting'>" + sDateFormatApproval.format(m.getApprovalDate()) + "</span>" : sDateFormatApproval.format(m.getApprovalDate())) : (m.getApprovalStatus() == EventInterface.ApprovalStatus.Cancelled ? "<span class='cancelled-meeting'>" + MESSAGES.approvalCancelled() + "</span>" : (m.getApprovalStatus() == EventInterface.ApprovalStatus.Rejected ? "<span class='rejected-meeting'>" + MESSAGES.approvalRejected() + "</span>" : (event != null && event.getType() == EventInterface.EventType.Unavailabile ? "" : (m.getFirstMeetingDate() == null ? "" : (m.isPast() ? "<span class='not-approved-past'>" + MESSAGES.approvalNotApprovedPast() + "</span>" : (event != null && event.getExpirationDate() != null ? "<span class='not-approved'>" + MESSAGES.approvalExpire(sDateFormatExpiration.format(event.getExpirationDate())) + "</span>" : "<span class='not-approved'>" + MESSAGES.approvalNotApproved() + "</span>"))))))));
                        if (!EventCookie.getInstance().isHideDuplicitiesForMeetings()) continue;
                        prev = mtg;
                        prevSpan = span;
                        prevApproval = thisApproval;
                    }
                    for (int i = 0; i < mtgs.length; ++i) {
                        if (i == 3 || i == 4 || i == 6) {
                            EventMeetingTable.this.setWidget(row, colDate + i, (Widget)new UniTimeTable.NumberCell(mtgs[i]));
                            continue;
                        }
                        EventMeetingTable.this.setWidget(row, colDate + i, (Widget)new HTML(mtgs[i], false));
                    }
                    EventMeetingTable.this.setWidget(row, colApproval, (Widget)new HTML(approval == null ? "" : approval, false));
                }
            }

            @Override
            public String getName() {
                return EventCookie.getInstance().isHideDuplicitiesForMeetings() ? MESSAGES.opUncheck(MESSAGES.opHideRepeatingInformation()) : MESSAGES.opCheck(MESSAGES.opHideRepeatingInformation());
            }

            @Override
            public String getAriaLabel() {
                return EventCookie.getInstance().isHideDuplicitiesForMeetings() ? ARIA.opUncheck(MESSAGES.opHideRepeatingInformation()) : ARIA.opCheck(MESSAGES.opHideRepeatingInformation());
            }
        };
        hDate.addOperation(hideDuplicitiesForMeetings);
        hTimePub.addOperation(hideDuplicitiesForMeetings);
        hTimeAll.addOperation(hideDuplicitiesForMeetings);
        hTimeSetup.addOperation(hideDuplicitiesForMeetings);
        hTimeTeardown.addOperation(hideDuplicitiesForMeetings);
        hLocation.addOperation(hideDuplicitiesForMeetings);
        hCapacity.addOperation(hideDuplicitiesForMeetings);
        hApproval.addOperation(hideDuplicitiesForMeetings);
        hMeetingContacts.addOperation(hideDuplicitiesForMeetings);
        this.addSortByOperation(hName, EventComparator.EventMeetingSortBy.NAME);
        this.addSortByOperation(hSection, EventComparator.EventMeetingSortBy.SECTION);
        this.addSortByOperation(hType, EventComparator.EventMeetingSortBy.TYPE);
        this.addSortByOperation(hTitle, EventComparator.EventMeetingSortBy.TITLE);
        this.addSortByOperation(hNote, EventComparator.EventMeetingSortBy.NOTE);
        this.addSortByOperation(hDate, EventComparator.EventMeetingSortBy.DATE);
        this.addSortByOperation(hTimePub, EventComparator.EventMeetingSortBy.PUBLISHED_TIME);
        this.addSortByOperation(hTimeAll, EventComparator.EventMeetingSortBy.ALLOCATED_TIME);
        this.addSortByOperation(hTimeSetup, EventComparator.EventMeetingSortBy.SETUP_TIME);
        this.addSortByOperation(hTimeTeardown, EventComparator.EventMeetingSortBy.TEARDOWN_TIME);
        this.addSortByOperation(hLocation, EventComparator.EventMeetingSortBy.LOCATION);
        this.addSortByOperation(hCapacity, EventComparator.EventMeetingSortBy.CAPACITY);
        this.addSortByOperation(hMeetingContacts, EventComparator.EventMeetingSortBy.MEETING_CONTACTS);
        this.addSortByOperation(hEnrollment, EventComparator.EventMeetingSortBy.ENROLLMENT);
        this.addSortByOperation(hLimit, EventComparator.EventMeetingSortBy.LIMIT);
        this.addSortByOperation(hSponsor, EventComparator.EventMeetingSortBy.SPONSOR);
        this.addSortByOperation(hRequestedServices, EventComparator.EventMeetingSortBy.SERVICES);
        this.addSortByOperation(hContact, EventComparator.EventMeetingSortBy.MAIN_CONTACT);
        this.addSortByOperation(hApproval, EventComparator.EventMeetingSortBy.APPROVAL);
        this.addSortByOperation(hLastChange, EventComparator.EventMeetingSortBy.LAST_CHANGE);
        hTimes.addOperation(new UniTimeTableHeader.AriaOperation(){

            public void execute() {
                EventCookie.getInstance().setAutomaticallyApproveNewMeetings(!EventCookie.getInstance().isAutomaticallyApproveNewMeetings());
                for (int row = 1; row < EventMeetingTable.this.getRowCount(); ++row) {
                    EventMeetingRow data = (EventMeetingRow)EventMeetingTable.this.getData(row);
                    if (!data.hasMeeting() || data.getMeeting().getId() != null || !data.getMeeting().isCanApprove() && !data.getMeeting().isAutomaticallyApproved() || !data.hasEvent() || data.getEvent().getType() != EventInterface.EventType.Special && data.getEvent().getType() != EventInterface.EventType.Course) continue;
                    HTML approval = (HTML)EventMeetingTable.this.getWidget(row, EventMeetingTable.this.getHeader(MESSAGES.colApproval()).getColumn());
                    if (EventCookie.getInstance().isAutomaticallyApproveNewMeetings() || data.getMeeting().isAutomaticallyApproved()) {
                        approval.setStyleName("new-approved-meeting");
                        approval.setText(MESSAGES.approvelNewApprovedMeeting());
                        continue;
                    }
                    approval.setStyleName("new-meeting");
                    approval.setText(MESSAGES.approvalNewMeeting());
                }
                ValueChangeEvent.fire((HasValueChangeHandlers)EventMeetingTable.this, (Object)EventMeetingTable.this.getValue());
            }

            @Override
            public boolean isApplicable() {
                for (int row = 1; row < EventMeetingTable.this.getRowCount(); ++row) {
                    EventMeetingRow data = (EventMeetingRow)EventMeetingTable.this.getData(row);
                    if (!data.hasMeeting() || data.getMeeting().getId() != null || !data.getMeeting().isCanApprove() || !data.hasEvent() || data.getEvent().getType() != EventInterface.EventType.Special && data.getEvent().getType() != EventInterface.EventType.Course) continue;
                    return true;
                }
                return false;
            }

            @Override
            public boolean hasSeparator() {
                return true;
            }

            @Override
            public String getName() {
                return EventCookie.getInstance().isAutomaticallyApproveNewMeetings() ? MESSAGES.opUncheck(MESSAGES.opAutomaticApproval()) : MESSAGES.opCheck(MESSAGES.opAutomaticApproval());
            }

            @Override
            public String getAriaLabel() {
                return EventCookie.getInstance().isAutomaticallyApproveNewMeetings() ? ARIA.opUncheck(MESSAGES.opAutomaticApproval()) : ARIA.opCheck(MESSAGES.opAutomaticApproval());
            }
        });
        for (int i = 0; i < this.getCellCount(0); ++i) {
            this.getCellFormatter().setStyleName(0, i, "unitime-ClickableTableHeaderNoBorderLine");
        }
        this.resetColumnVisibility();
    }

    public Mode getMode() {
        return this.iMode;
    }

    public void setMode(Mode mode) {
        this.iMode = mode;
    }

    public void setSelectable(boolean selectable) {
        this.iSelectable = selectable;
    }

    public boolean isSelectable() {
        return this.iSelectable;
    }

    public void setEditable(boolean editable) {
        this.iEditable = editable;
    }

    public boolean isEditable() {
        return this.iEditable;
    }

    public MeetingFilter getMeetingFilter() {
        return this.iMeetingFilter;
    }

    public void setMeetingFilter(MeetingFilter filter) {
        this.iMeetingFilter = filter;
    }

    public void setShowMainContact(boolean show) {
        this.iShowMainContact = show;
    }

    public boolean isShowMainContact() {
        return this.iShowMainContact;
    }

    public void setShowMeetingContacts(boolean show) {
        this.iShowMeetingContacts = show;
    }

    public boolean isShowMeetingContacts() {
        return this.iShowMeetingContacts;
    }

    public void setOperation(OperationType operation, Implementation command) {
        if (command == null) {
            this.iImplementations.remove((Object)operation);
        } else {
            this.iImplementations.put(operation, command);
        }
    }

    public Implementation getOperation(OperationType operation) {
        return this.iImplementations.get((Object)operation);
    }

    public boolean hasOperation(OperationType operation) {
        return this.getOperation(operation) != null;
    }

    protected boolean isSelectable(EventMeetingRow data) {
        return this.hasOperation(OperationType.Approve) && data.isCanApprove() || this.hasOperation(OperationType.Cancel) && data.isCanCancel() && (!this.getMode().hasFlag(ModeFlag.ShowEventDetails) || this.isShowMainContact()) || this.hasOperation(OperationType.Inquire) && data.isCanInquire() || this.isEditable() && (data.isEditable() || data.isCanCancel() || data.isCanDelete());
    }

    /*
     * WARNING - void declaration
     */
    public void add(EventMeetingRow data) {
        block147: {
            EventInterface event;
            block148: {
                EventInterface.MeetingInterface meeting;
                block149: {
                    EventInterface.MeetingConflictInterface conflict;
                    if (!this.getMode().hasFlag(ModeFlag.ShowMeetings) && data.getMeetings(this.getMeetingFilter()).isEmpty()) {
                        return;
                    }
                    ArrayList<Object> row = new ArrayList<Object>();
                    event = data.getEvent();
                    meeting = data.getMeeting();
                    EventInterface.MeetingConflictInterface meetingConflictInterface = conflict = meeting instanceof EventInterface.MeetingConflictInterface ? (EventInterface.MeetingConflictInterface)meeting : null;
                    if (conflict != null && conflict.getType() == EventInterface.EventType.Message && this.getMode().hasFlag(ModeFlag.ShowEventDetails)) {
                        return;
                    }
                    if (data.hasParent()) {
                        if (conflict != null && conflict.getType() == EventInterface.EventType.Message) {
                            row.add(new UniTimeTable.CenterredCell(MESSAGES.signMessage()));
                        } else {
                            row.add(new UniTimeTable.CenterredCell(MESSAGES.signConflict()));
                        }
                    } else if (!this.isSelectable()) {
                        row.add(new HTML(MESSAGES.signSelected()));
                    } else if (this.isSelectable(data)) {
                        UniTimeTable.CheckBoxCell check = new UniTimeTable.CheckBoxCell();
                        check.setAriaLabel(data.toAriaString(this.getMode().hasFlag(ModeFlag.ShowEventDetails)));
                        row.add(check);
                        if (!this.isColumnVisible(0)) {
                            this.setColumnVisible(0, true);
                        }
                    } else {
                        row.add(new HTML("&nbsp;"));
                    }
                    if (event != null && event.getType() != null) {
                        if (event.hasCourseNames()) {
                            ArrayList<P> name = new ArrayList<P>();
                            ArrayList<String> section = new ArrayList<String>();
                            ArrayList<String> title = new ArrayList<String>();
                            if (event.getType() == EventInterface.EventType.Course) {
                                name.add(new CourseName(null, event.getName(), new String[0]));
                                section.add("&nbsp;");
                            }
                            int idx = 0;
                            for (String string : event.getCourseNames()) {
                                Long courseId = event.getCourseId(idx++);
                                if (name.isEmpty()) {
                                    name.add(new CourseName(courseId, string, new String[0]));
                                    continue;
                                }
                                if (event.getInstruction() != null || event.getType() == EventInterface.EventType.Course) {
                                    name.add(new CourseName(courseId, string, "no-control"));
                                    continue;
                                }
                                name.add(new CourseName(courseId, string, new String[0]));
                            }
                            if (event.hasExternalIds()) {
                                for (String string : event.getExternalIds()) {
                                    if (section.isEmpty()) {
                                        section.add(string);
                                        continue;
                                    }
                                    if (event.getInstruction() != null || event.getType() == EventInterface.EventType.Course) {
                                        section.add("<span class='no-control'>" + string + "</span>");
                                        continue;
                                    }
                                    section.add(string);
                                }
                            } else if (event.hasSectionNumber()) {
                                section.clear();
                                section.add(event.getSectionNumber());
                            }
                            if (event.hasCourseTitles()) {
                                String last = null;
                                for (String ct : event.getCourseTitles()) {
                                    if (last != null && !last.isEmpty() && last.equals(ct)) {
                                        ct = "";
                                    } else {
                                        last = ct;
                                    }
                                    if (title.isEmpty()) {
                                        title.add(ct);
                                        continue;
                                    }
                                    if (event.getInstruction() != null || event.getType() == EventInterface.EventType.Course) {
                                        title.add("<span class='no-control'>" + ct + "</span>");
                                        continue;
                                    }
                                    title.add(ct);
                                }
                            }
                            row.add(new MultiLinePCell(name));
                            row.add(new MultiLineNumberCell(section));
                            row.add(new Label(event.getInstruction() == null ? event.getType().getAbbreviation(CONSTANTS) : event.getInstruction(), false));
                            row.add(new MultiLineStringCell(title));
                            if (event.hasEventNote() && this.getMode().hasFlag(ModeFlag.ShowEventDetails)) {
                                MultiLineStringCell note = new MultiLineStringCell(event.getEventNote("\n").split("\\n"));
                                note.setTitle(event.getEventNote("\n"));
                                note.addStyleName("note");
                                note.getElement().getStyle().clearWhiteSpace();
                                row.add(note);
                            } else {
                                row.add(new HTML("&nbsp;"));
                            }
                            if (!section.isEmpty() && !this.isColumnVisible(this.getHeader(MESSAGES.colSection()).getColumn()) && EventCookie.getInstance().get(EventInterface.EventFlag.SHOW_TITLE) && this.getMode().hasFlag(ModeFlag.ShowOptionalColumns) && !this.getMode().hasFlag(ModeFlag.HideTitle)) {
                                this.setColumnVisible(this.getHeader(MESSAGES.colSection()).getColumn(), true);
                            }
                            if (!title.isEmpty() && !this.isColumnVisible(this.getHeader(MESSAGES.colTitle()).getColumn()) && EventCookie.getInstance().get(EventInterface.EventFlag.SHOW_TITLE) && this.getMode().hasFlag(ModeFlag.ShowOptionalColumns) && !this.getMode().hasFlag(ModeFlag.HideTitle)) {
                                this.setColumnVisible(this.getHeader(MESSAGES.colTitle()).getColumn(), true);
                            }
                            if (event.hasEventNote() && !this.isColumnVisible(this.getHeader(MESSAGES.colNote()).getColumn()) && EventCookie.getInstance().get(EventInterface.EventFlag.SHOW_NOTE) && this.getMode().hasFlag(ModeFlag.ShowOptionalColumns) && !this.getMode().hasFlag(ModeFlag.HideTitle)) {
                                this.setColumnVisible(this.getHeader(MESSAGES.colNote()).getColumn(), true);
                            }
                        } else {
                            row.add(new HTML(event.getName()));
                            row.add(new HTML("&nbsp;"));
                            row.add(new Label(event.getType().getAbbreviation(CONSTANTS), false));
                            row.add(new HTML("&nbsp;"));
                            if (event.hasEventNote() && this.getMode().hasFlag(ModeFlag.ShowEventDetails)) {
                                MultiLineStringCell note = new MultiLineStringCell(event.getEventNote("\n").split("\\n"));
                                note.setTitle(event.getEventNote("\n"));
                                note.addStyleName("note");
                                note.getElement().getStyle().clearWhiteSpace();
                                row.add(note);
                            } else {
                                row.add(new HTML("&nbsp;"));
                            }
                            if (event.hasEventNote() && !this.isColumnVisible(this.getHeader(MESSAGES.colNote()).getColumn()) && EventCookie.getInstance().get(EventInterface.EventFlag.SHOW_NOTE) && this.getMode().hasFlag(ModeFlag.ShowOptionalColumns) && !this.getMode().hasFlag(ModeFlag.HideTitle)) {
                                this.setColumnVisible(this.getHeader(MESSAGES.colNote()).getColumn(), true);
                            }
                        }
                    } else if (conflict != null) {
                        row.add(new HTML(conflict.getName()));
                        row.add(new HTML("&nbsp;"));
                        row.add(new HTML(conflict.getType().getAbbreviation(CONSTANTS), false));
                        row.add(new HTML("&nbsp;"));
                        row.add(new HTML("&nbsp;"));
                    } else {
                        row.add(new HTML());
                        row.add(new HTML());
                        row.add(new HTML());
                        row.add(new HTML());
                        row.add(new HTML());
                    }
                    String approval = "";
                    boolean allCancelledOrRejected = false;
                    if (meeting != null) {
                        if (conflict != null && (conflict.getType() == EventInterface.EventType.Message || conflict.getType() == EventInterface.EventType.Unavailabile) && conflict.isAllDay() && !this.getMode().hasFlag(ModeFlag.ShowEventDetails)) {
                            row.add(new HTMLWithColSpan(conflict.getName(), true, 5));
                            ((Widget)row.get(row.size() - 1)).addStyleName("indent");
                        } else {
                            if (conflict != null && !this.getMode().hasFlag(ModeFlag.ShowEventDetails)) {
                                row.add(new HTML(conflict.getType() == EventInterface.EventType.Unavailabile || conflict.getType() == EventInterface.EventType.Message ? conflict.getName() : MESSAGES.conflictWith(conflict.getName()), false));
                                ((Widget)row.get(row.size() - 1)).addStyleName("indent");
                            } else if (meeting.isArrangeHours()) {
                                if (event.hasMessage()) {
                                    row.add(new Label(event.getMessage()));
                                } else {
                                    row.add(new Label(CONSTANTS.arrangeHours()));
                                }
                            } else {
                                Enum dateFlag;
                                Label meetingDate = new Label(sDateFormatMeeting.format(meeting.getMeetingDate()), false);
                                Enum enum_ = this.iPropertiesProvider == null ? null : (dateFlag = this.iPropertiesProvider.getDateFlag(event == null ? null : event.getType(), meeting.getMeetingDate()));
                                if (dateFlag != null) {
                                    switch (23.$SwitchMap$org$unitime$timetable$gwt$shared$EventInterface$SessionMonth$Flag[dateFlag.ordinal()]) {
                                        case 1: {
                                            meetingDate.setTitle(MESSAGES.hintFinals());
                                            meetingDate.addStyleName("finals");
                                            break;
                                        }
                                        case 3: {
                                            meetingDate.setTitle(MESSAGES.hintBreak());
                                            meetingDate.addStyleName("break");
                                            break;
                                        }
                                        case 4: {
                                            meetingDate.setTitle(MESSAGES.hintHoliday());
                                            meetingDate.addStyleName("holiday");
                                            break;
                                        }
                                        case 5: {
                                            meetingDate.setTitle(MESSAGES.hintWeekend());
                                            meetingDate.addStyleName("weekend");
                                            break;
                                        }
                                        case 2: {
                                            meetingDate.setTitle(MESSAGES.hintMidterms());
                                            meetingDate.addStyleName("midterms");
                                        }
                                    }
                                }
                                row.add(meetingDate);
                            }
                            Label meetingTime = new Label(meeting.getMeetingTime(CONSTANTS), false);
                            Label allocatedTime = new Label(meeting.getAllocatedTime(CONSTANTS), false);
                            if (!meeting.isArrangeHours() && this.iPropertiesProvider != null && this.iPropertiesProvider.isTooEarly(meeting.getStartSlot(), meeting.getEndSlot())) {
                                meetingTime.setTitle(MESSAGES.hintTooEarly());
                                meetingTime.addStyleName("early");
                                allocatedTime.setTitle(MESSAGES.hintTooEarly());
                                allocatedTime.addStyleName("early");
                            }
                            if (meeting.isArrangeHours() && event.hasMessage()) {
                                meetingTime = new Label(CONSTANTS.arrangeHours(), false);
                            }
                            row.add(meetingTime);
                            row.add(allocatedTime);
                            row.add(new UniTimeTable.NumberCell(meeting.getStartOffset()));
                            row.add(new UniTimeTable.NumberCell(-meeting.getEndOffset()));
                        }
                        if (meeting.getLocation() == null) {
                            if (data.hasParent() && data.getParent().hasMeeting() && data.getParent().getMeeting().getLocation() != null) {
                                row.add(new HTML(data.getParent().getMeeting().getLocationNameWithHint(MESSAGES), false));
                                row.add(new UniTimeTable.NumberCell(data.getParent().getMeeting().getLocation().getSize() == null ? MESSAGES.notApplicable() : data.getParent().getMeeting().getLocation().getSize().toString()));
                            } else {
                                row.add(new Label(""));
                                row.add(new Label(""));
                            }
                        } else {
                            row.add(new HTML(meeting.getLocationNameWithHint(MESSAGES), false));
                            row.add(new UniTimeTable.NumberCell(meeting.getLocation().getSize() == null ? MESSAGES.notApplicable() : meeting.getLocation().getSize().toString()));
                        }
                        if (this.iShowMeetingContacts) {
                            row.add(new HTML(meeting.getMeetingContacts(CONSTANTS.meetingContactsSeparator(), MESSAGES), false));
                            if (meeting.hasMeetingContacts() && !this.isColumnVisible(this.getHeader(MESSAGES.colMeetingContacts()).getColumn()) && EventCookie.getInstance().get(EventInterface.EventFlag.SHOW_MEETING_CONTACTS) && this.getMode().hasFlag(ModeFlag.ShowOptionalColumns)) {
                                this.setColumnVisible(this.getHeader(MESSAGES.colMeetingContacts()).getColumn(), true);
                            }
                        } else {
                            row.add(new HTML(""));
                        }
                        if (meeting.isPast() || data.hasParent() && data.getParent().hasMeeting() && data.getParent().getMeeting().isPast()) {
                            for (int i = row.size() - 8; i < row.size(); ++i) {
                                ((Widget)row.get(i)).addStyleName("past-meeting");
                            }
                        } else if (meeting.hasStyle() || data.hasParent() && data.getParent().hasMeeting() && data.getParent().getMeeting().hasStyle()) {
                            for (int i = row.size() - 8; i < row.size(); ++i) {
                                ((Widget)row.get(i)).addStyleName(meeting.getStyle());
                            }
                        }
                    } else {
                        String[] mtgs = new String[]{"", "", "", "", "", "", "", ""};
                        String prevApproval = null;
                        String[] prev = null;
                        Object var11_36 = null;
                        allCancelledOrRejected = true;
                        boolean globalUnavailability = event != null && event.getId() != null && event.getId() < 0L && event.getType() == EventInterface.EventType.Unavailabile;
                        for (EventInterface.MultiMeetingInterface m : EventInterface.getMultiMeetings(data.getMeetings(this.getMeetingFilter()), true, globalUnavailability ? null : this.iPropertiesProvider, event == null ? null : event.getType(), this.iShowMeetingContacts)) {
                            void var11_37;
                            String[] stringArray = new String[8];
                            stringArray[0] = m.isArrangeHours() ? (event.hasMessage() ? event.getMessage() : CONSTANTS.arrangeHours()) : m.getDays(this.iPropertiesProvider.getFirstDayOfWeek(), CONSTANTS) + " " + (m.getNrMeetings() == 1 ? sDateFormatLong.format(m.getFirstMeetingDate()) : sDateFormatShort.format(m.getFirstMeetingDate()) + " - " + sDateFormatLong.format(m.getLastMeetingDate()));
                            stringArray[1] = m.isArrangeHours() && event.hasMessage() ? CONSTANTS.arrangeHours() : m.getMeetings().first().getMeetingTime(CONSTANTS);
                            stringArray[2] = m.getMeetings().first().getAllocatedTime(CONSTANTS);
                            stringArray[3] = String.valueOf(m.getMeetings().first().getStartOffset());
                            stringArray[4] = String.valueOf(-m.getMeetings().first().getEndOffset());
                            stringArray[5] = m.getLocationNameWithHint(MESSAGES);
                            stringArray[6] = m.getMeetings().first().getLocation() == null ? "" : (m.getMeetings().first().getLocation().hasSize() ? m.getMeetings().first().getLocation().getSize().toString() : MESSAGES.notApplicable());
                            stringArray[7] = this.iShowMeetingContacts ? m.getMeetingContacts(CONSTANTS.meetingContactsSeparator(), MESSAGES) : "";
                            String[] mtg = stringArray;
                            if (!m.isArrangeHours() && !m.isPast()) {
                                Enum dateFlag;
                                Enum enum_ = globalUnavailability || this.iPropertiesProvider == null ? null : (dateFlag = this.iPropertiesProvider.getDateFlag(event == null ? null : event.getType(), m.getFirstMeetingDate()));
                                if (dateFlag != null) {
                                    switch (23.$SwitchMap$org$unitime$timetable$gwt$shared$EventInterface$SessionMonth$Flag[dateFlag.ordinal()]) {
                                        case 1: {
                                            mtg[0] = "<span class='finals' title=\"" + MESSAGES.hintFinals() + "\">" + mtg[0] + "</span>";
                                            break;
                                        }
                                        case 2: {
                                            mtg[0] = "<span class='midterms' title=\"" + MESSAGES.hintMidterms() + "\">" + mtg[0] + "</span>";
                                            break;
                                        }
                                        case 3: {
                                            mtg[0] = "<span class='break' title=\"" + MESSAGES.hintBreak() + "\">" + mtg[0] + "</span>";
                                            break;
                                        }
                                        case 4: {
                                            mtg[0] = "<span class='holiday' title=\"" + MESSAGES.hintHoliday() + "\">" + mtg[0] + "</span>";
                                            break;
                                        }
                                        case 5: {
                                            mtg[0] = "<span class='weekend' title=\"" + MESSAGES.hintWeekend() + "\">" + mtg[0] + "</span>";
                                        }
                                    }
                                }
                            }
                            if (!m.isArrangeHours() && this.iPropertiesProvider != null && this.iPropertiesProvider.isTooEarly(m.getMeetings().first().getStartSlot(), m.getMeetings().first().getEndSlot())) {
                                for (int i = 1; i <= 2; ++i) {
                                    mtg[i] = "<span class='early' title=\"" + MESSAGES.hintTooEarly() + "\">" + mtg[i] + "</span>";
                                }
                            }
                            String span = "";
                            if (m.getApprovalStatus() == EventInterface.ApprovalStatus.Cancelled) {
                                span = "cancelled-meeting";
                            } else if (m.getApprovalStatus() == EventInterface.ApprovalStatus.Rejected) {
                                span = "rejected-meeting";
                            } else if (m.isPast()) {
                                span = "past-meeting";
                            } else if (m.hasStyle()) {
                                span = m.getStyle();
                            }
                            for (int i = 0; i < mtgs.length; ++i) {
                                int n = i;
                                mtgs[n] = mtgs[n] + (mtgs[i].isEmpty() ? "" : "<br>") + (prev != null && span.equals(var11_37) && prev[i == 6 ? i - 1 : i].equals(mtg[i == 6 ? i - 1 : i]) && (i != 7 || !mtg[i].isEmpty()) ? MESSAGES.repeatingSymbol() : (!span.isEmpty() ? "<span class='" + span + "'>" : "") + mtg[i] + (!span.isEmpty() ? "</span>" : ""));
                            }
                            String thisApproval = m.getApprovalStatus() == EventInterface.ApprovalStatus.Approved ? sDateFormatApproval.format(m.getApprovalDate()) : (m.getApprovalStatus() == EventInterface.ApprovalStatus.Cancelled ? MESSAGES.approvalCancelled() : (m.getApprovalStatus() == EventInterface.ApprovalStatus.Rejected ? MESSAGES.approvalRejected() : ""));
                            approval = approval + (approval.isEmpty() ? "" : "<br>") + (prev != null && span.equals(var11_37) && prevApproval.equals(thisApproval) ? MESSAGES.repeatingSymbol() : (m.getApprovalStatus() == EventInterface.ApprovalStatus.Approved ? (m.isPast() ? "<span class='past-meeting'>" + sDateFormatApproval.format(m.getApprovalDate()) + "</span>" : sDateFormatApproval.format(m.getApprovalDate())) : (m.getApprovalStatus() == EventInterface.ApprovalStatus.Cancelled ? "<span class='cancelled-meeting'>" + MESSAGES.approvalCancelled() + "</span>" : (m.getApprovalStatus() == EventInterface.ApprovalStatus.Rejected ? "<span class='rejected-meeting'>" + MESSAGES.approvalRejected() + "</span>" : (event != null && event.getType() == EventInterface.EventType.Unavailabile ? "" : (m.getFirstMeetingDate() == null ? "" : (m.isPast() ? "<span class='not-approved-past'>" + MESSAGES.approvalNotApprovedPast() + "</span>" : (event != null && event.getExpirationDate() != null ? "<span class='not-approved'>" + MESSAGES.approvalExpire(sDateFormatExpiration.format(event.getExpirationDate())) + "</span>" : "<span class='not-approved'>" + MESSAGES.approvalNotApproved() + "</span>"))))))));
                            if (EventCookie.getInstance().isHideDuplicitiesForMeetings()) {
                                prev = mtg;
                                String string = span;
                                prevApproval = thisApproval;
                            }
                            if (m.getApprovalStatus() != EventInterface.ApprovalStatus.Cancelled && m.getApprovalStatus() != EventInterface.ApprovalStatus.Rejected) {
                                allCancelledOrRejected = false;
                            }
                            if (!m.hasMeetingContacts() || this.isColumnVisible(this.getHeader(MESSAGES.colMeetingContacts()).getColumn()) || !EventCookie.getInstance().get(EventInterface.EventFlag.SHOW_MEETING_CONTACTS) || !this.getMode().hasFlag(ModeFlag.ShowOptionalColumns)) continue;
                            this.setColumnVisible(this.getHeader(MESSAGES.colMeetingContacts()).getColumn(), true);
                        }
                        for (int i = 0; i < mtgs.length; ++i) {
                            if (i == 3 || i == 4 || i == 6) {
                                row.add(new UniTimeTable.NumberCell(mtgs[i]));
                                continue;
                            }
                            row.add(new HTML(mtgs[i], false));
                        }
                    }
                    if (event != null && event.hasEnrollment()) {
                        row.add(new UniTimeTable.NumberCell(event.getEnrollment().toString()));
                    } else {
                        row.add(new HTML("&nbsp;"));
                    }
                    if (event != null && event.hasMaxCapacity()) {
                        row.add(new UniTimeTable.NumberCell(event.getMaxCapacity().toString()));
                    } else {
                        row.add(new HTML("&nbsp;"));
                    }
                    if (event != null && event.hasInstructors()) {
                        if (this.getMode().hasFlag(ModeFlag.ShowEventDetails)) {
                            ArrayList<String> names = new ArrayList<String>();
                            for (EventInterface.ContactInterface instructor : event.getInstructors()) {
                                names.add(instructor.getName(MESSAGES));
                            }
                            row.add(new MultiLineStringCell(names));
                        } else {
                            row.add(new HTML(event.getInstructorNames("<br>", MESSAGES), false));
                        }
                    } else if (event != null && event.hasSponsor()) {
                        row.add(new Label(event.getSponsor().getName()));
                    } else {
                        row.add(new HTML("&nbsp;"));
                    }
                    if (event != null && event.hasRequestedServices()) {
                        if (this.getMode().hasFlag(ModeFlag.ShowEventDetails)) {
                            ArrayList<String> names = new ArrayList<String>();
                            for (EventInterface.EventServiceProviderInterface service : event.getRequestedServices()) {
                                names.add(service.getLabel());
                            }
                            row.add(new MultiLineStringCell(names));
                        } else {
                            row.add(new HTML(event.getRequestedServices("<br>"), false));
                        }
                        if (!this.isColumnVisible(this.getHeader(MESSAGES.colRequestedServices()).getColumn()) && EventCookie.getInstance().get(EventInterface.EventFlag.SHOW_REQUESTED_SERVICES) && this.getMode().hasFlag(ModeFlag.ShowEventDetails)) {
                            this.setColumnVisible(this.getHeader(MESSAGES.colRequestedServices()).getColumn(), true);
                        }
                    } else {
                        row.add(new HTML("&nbsp;"));
                    }
                    if (event != null && this.iShowMainContact) {
                        row.add(new HTML(event.hasContact() ? event.getContact().getName(MESSAGES) : "&nbsp;"));
                        if (!this.isColumnVisible(this.getHeader(MESSAGES.colMainContact()).getColumn()) && EventCookie.getInstance().get(EventInterface.EventFlag.SHOW_MAIN_CONTACT) && this.getMode().hasFlag(ModeFlag.ShowOptionalColumns)) {
                            switch (event.getType()) {
                                case Course: 
                                case Special: {
                                    this.setColumnVisible(this.getHeader(MESSAGES.colMainContact()).getColumn(), true);
                                }
                            }
                        }
                    } else {
                        row.add(new HTML("&nbsp;"));
                    }
                    if (meeting != null) {
                        boolean past;
                        boolean bl = past = meeting.isPast() || data.hasParent() && data.getParent().hasMeeting() && data.getParent().getMeeting().isPast();
                        row.add(new HTML(conflict != null && (conflict.getType() == EventInterface.EventType.Unavailabile || conflict.getType() == EventInterface.EventType.Message) ? "" : (meeting.getApprovalStatus() == EventInterface.ApprovalStatus.Deleted ? "<span class='deleted-meeting'>" + MESSAGES.approvalDeleted() + "</span>" : (meeting.getApprovalStatus() == EventInterface.ApprovalStatus.Cancelled ? "<span class='cancelled-meeting'>" + MESSAGES.approvalCancelled() + "</span>" : (meeting.getApprovalStatus() == EventInterface.ApprovalStatus.Rejected ? "<span class='rejected-meeting'>" + MESSAGES.approvalRejected() + "</span>" : (meeting.getMeetingDate() == null ? "" : (meeting.getId() == null ? (event != null && event.getType() == EventInterface.EventType.Unavailabile ? (event.getId() != null && event.getId() < 0L ? "" : "<span class='new-meeting'>" + MESSAGES.approvalNewUnavailabiliyMeeting() + "</span>") : (event != null && (event.getType() == EventInterface.EventType.Class || event.getType() == EventInterface.EventType.FinalExam || event.getType() == EventInterface.EventType.MidtermExam) ? "<span class='new-approved-meeting'>" + MESSAGES.approvelNewApprovedMeeting() + "</span>" : (meeting.isAutomaticallyApproved() || meeting.isCanApprove() && EventCookie.getInstance().isAutomaticallyApproveNewMeetings() ? "<span class='new-approved-meeting'>" + MESSAGES.approvelNewApprovedMeeting() + "</span>" : "<span class='new-meeting'>" + MESSAGES.approvalNewMeeting() + "</span>"))) : (meeting.isApproved() ? (past ? "<span class='past-meeting'>" + sDateFormatApproval.format(meeting.getApprovalDate()) + "</span>" : sDateFormatApproval.format(meeting.getApprovalDate())) : (past ? "<span class='not-approved-past'>" + MESSAGES.approvalNotApprovedPast() + "</span>" : (event != null && event.getExpirationDate() != null ? "<span class='not-approved'>" + MESSAGES.approvalExpire(sDateFormatExpiration.format(event.getExpirationDate())) + "</span>" : "<span class='not-approved'>" + MESSAGES.approvalNotApproved() + "</span>"))))))))));
                    } else {
                        row.add(new HTML(approval == null ? "" : approval, false));
                    }
                    if (event != null && event.getLastNote() != null && this.iShowMainContact) {
                        EventInterface.NoteInterface note = event.getLastNote();
                        row.add(new Label(sDateFormatApproval.format(note.getDate()) + " " + note.getType().getName()));
                    } else {
                        row.add(new HTML("&nbsp;"));
                    }
                    if (!this.getMode().hasFlag(ModeFlag.MustShowApproval) && !this.isColumnVisible(this.getHeader(MESSAGES.colApproval()).getColumn()) && EventCookie.getInstance().get(EventInterface.EventFlag.SHOW_APPROVAL) && event != null) {
                        switch (event.getType()) {
                            case Course: 
                            case Special: {
                                this.setColumnVisible(this.getHeader(MESSAGES.colApproval()).getColumn(), true);
                            }
                        }
                    }
                    int rowNumber = this.addRow(data, row);
                    if (meeting != null) {
                        this.getRowFormatter().addStyleName(rowNumber, meeting.getApprovalStatus() == EventInterface.ApprovalStatus.Deleted ? "deleted-row" : (meeting.getApprovalStatus() == EventInterface.ApprovalStatus.Cancelled ? "cancelled-row" : (meeting.getApprovalStatus() == EventInterface.ApprovalStatus.Rejected ? "rejected-row" : "meeting-row")));
                    } else if (event != null) {
                        this.getRowFormatter().addStyleName(rowNumber, allCancelledOrRejected ? "event-cancelled-row" : "event-row");
                    }
                    if (data.hasParent()) {
                        ((Widget)row.get(1)).addStyleName("indent");
                        if (conflict != null && conflict.getType() == EventInterface.EventType.Message) {
                            this.getRowFormatter().addStyleName(rowNumber, "message-row");
                            for (int i = 0; i < this.getCellCount(rowNumber); ++i) {
                                this.getCellFormatter().addStyleName(rowNumber, i, "message-cell");
                            }
                        } else {
                            this.getRowFormatter().addStyleName(rowNumber, "conflict-row");
                            for (int i = 0; i < this.getCellCount(rowNumber); ++i) {
                                this.getCellFormatter().addStyleName(rowNumber, i, "conflict-cell");
                            }
                        }
                    } else if (meeting != null) {
                        for (int i = 0; i < this.getCellCount(rowNumber); ++i) {
                            this.getCellFormatter().addStyleName(rowNumber, i, "meeting-cell");
                        }
                    } else if (event != null) {
                        for (int i = 0; i < this.getCellCount(rowNumber); ++i) {
                            this.getCellFormatter().addStyleName(rowNumber, i, "event-cell");
                        }
                    }
                    if (data.hasParent()) break block147;
                    if (meeting == null) break block148;
                    if (meeting.getApprovalStatus() != EventInterface.ApprovalStatus.Pending && meeting.getApprovalStatus() != EventInterface.ApprovalStatus.Approved) break block147;
                    if (!meeting.hasConflicts()) break block149;
                    for (EventInterface.MeetingConflictInterface cMeeting : meeting.getConflicts()) {
                        this.add(new EventMeetingRow(null, cMeeting, data));
                    }
                    break block147;
                }
                if (!event.hasConflicts()) break block147;
                for (EventInterface cEvent : event.getConflicts()) {
                    if (!cEvent.hasMeetings()) continue;
                    for (EventInterface.MeetingInterface cMeeting : cEvent.getMeetings()) {
                        if (!meeting.inConflict(cMeeting)) continue;
                        this.add(new EventMeetingRow(cEvent, cMeeting, data));
                    }
                }
                break block147;
            }
            if (event != null && event.hasConflicts()) {
                for (EventInterface cEvent : event.getConflicts()) {
                    this.add(new EventMeetingRow(cEvent, null, data));
                }
            }
        }
    }

    private Set<Integer> getEventColumns() {
        HashSet<Integer> cols = new HashSet<Integer>();
        cols.add(this.getHeader(MESSAGES.colName()).getColumn());
        cols.add(this.getHeader(MESSAGES.colSection()).getColumn());
        cols.add(this.getHeader(MESSAGES.colTitle()).getColumn());
        cols.add(this.getHeader(MESSAGES.colNote()).getColumn());
        cols.add(this.getHeader(MESSAGES.colType()).getColumn());
        cols.add(this.getHeader(MESSAGES.colEnrollment()).getColumn());
        cols.add(this.getHeader(MESSAGES.colLimit()).getColumn());
        cols.add(this.getHeader(MESSAGES.colSponsorOrInstructor()).getColumn());
        cols.add(this.getHeader(MESSAGES.colRequestedServices()).getColumn());
        cols.add(this.getHeader(MESSAGES.colMainContact()).getColumn());
        cols.add(this.getHeader(MESSAGES.colLastChange()).getColumn());
        return cols;
    }

    public void resetColumnVisibility() {
        if (this.getRowCount() <= 1) {
            this.setColumnVisible(0, false);
            this.setColumnVisible(this.getHeader(MESSAGES.colSection()).getColumn(), false);
            this.setColumnVisible(this.getHeader(MESSAGES.colTitle()).getColumn(), false);
            this.setColumnVisible(this.getHeader(MESSAGES.colNote()).getColumn(), false);
            this.setColumnVisible(this.getHeader(MESSAGES.colMainContact()).getColumn(), false);
            this.setColumnVisible(this.getHeader(MESSAGES.colApproval()).getColumn(), this.getMode().hasFlag(ModeFlag.MustShowApproval));
            this.setColumnVisible(this.getHeader(MESSAGES.colLastChange()).getColumn(), false);
            this.setColumnVisible(this.getHeader(MESSAGES.colRequestedServices()).getColumn(), false);
            this.setColumnVisible(this.getHeader(MESSAGES.colMeetingContacts()).getColumn(), false);
        }
        this.setColumnVisible(this.getHeader(MESSAGES.colName()).getColumn(), this.getMode().hasFlag(ModeFlag.ShowEventDetails));
        this.setColumnVisible(this.getHeader(MESSAGES.colType()).getColumn(), this.getMode().hasFlag(ModeFlag.ShowEventDetails));
        if (this.getMode().hasFlag(ModeFlag.ShowOptionalColumns)) {
            this.setColumnVisible(this.getHeader(MESSAGES.colPublishedTime()).getColumn(), EventCookie.getInstance().get(EventInterface.EventFlag.SHOW_PUBLISHED_TIME));
            this.setColumnVisible(this.getHeader(MESSAGES.colAllocatedTime()).getColumn(), EventCookie.getInstance().get(EventInterface.EventFlag.SHOW_ALLOCATED_TIME));
            this.setColumnVisible(this.getHeader(MESSAGES.colSetupTimeShort()).getColumn(), EventCookie.getInstance().get(EventInterface.EventFlag.SHOW_SETUP_TIME));
            this.setColumnVisible(this.getHeader(MESSAGES.colTeardownTimeShort()).getColumn(), EventCookie.getInstance().get(EventInterface.EventFlag.SHOW_TEARDOWN_TIME));
            this.setColumnVisible(this.getHeader(MESSAGES.colLimit()).getColumn(), this.getMode().hasFlag(ModeFlag.ShowEventDetails) && EventCookie.getInstance().get(EventInterface.EventFlag.SHOW_LIMIT));
            this.setColumnVisible(this.getHeader(MESSAGES.colEnrollment()).getColumn(), this.getMode().hasFlag(ModeFlag.ShowEventDetails) && EventCookie.getInstance().get(EventInterface.EventFlag.SHOW_ENROLLMENT));
            this.setColumnVisible(this.getHeader(MESSAGES.colCapacity()).getColumn(), EventCookie.getInstance().get(EventInterface.EventFlag.SHOW_CAPACITY));
            this.setColumnVisible(this.getHeader(MESSAGES.colSponsorOrInstructor()).getColumn(), this.getMode().hasFlag(ModeFlag.ShowEventDetails) && EventCookie.getInstance().get(EventInterface.EventFlag.SHOW_SPONSOR));
            this.setColumnVisible(this.getHeader(MESSAGES.colLastChange()).getColumn(), this.isShowMainContact() && this.getMode().hasFlag(ModeFlag.ShowEventDetails) && EventCookie.getInstance().get(EventInterface.EventFlag.SHOW_LAST_CHANGE));
        } else {
            this.setColumnVisible(this.getHeader(MESSAGES.colPublishedTime()).getColumn(), EventCookie.getInstance().get(EventInterface.EventFlag.SHOW_PUBLISHED_TIME));
            this.setColumnVisible(this.getHeader(MESSAGES.colAllocatedTime()).getColumn(), !EventCookie.getInstance().get(EventInterface.EventFlag.SHOW_PUBLISHED_TIME));
            this.setColumnVisible(this.getHeader(MESSAGES.colSetupTimeShort()).getColumn(), false);
            this.setColumnVisible(this.getHeader(MESSAGES.colTeardownTimeShort()).getColumn(), false);
            this.setColumnVisible(this.getHeader(MESSAGES.colLimit()).getColumn(), false);
            this.setColumnVisible(this.getHeader(MESSAGES.colEnrollment()).getColumn(), false);
            this.setColumnVisible(this.getHeader(MESSAGES.colCapacity()).getColumn(), false);
            this.setColumnVisible(this.getHeader(MESSAGES.colSponsorOrInstructor()).getColumn(), false);
            this.setColumnVisible(this.getHeader(MESSAGES.colRequestedServices()).getColumn(), false);
            this.setColumnVisible(this.getHeader(MESSAGES.colMainContact()).getColumn(), false);
            this.setColumnVisible(this.getHeader(MESSAGES.colTitle()).getColumn(), false);
            this.setColumnVisible(this.getHeader(MESSAGES.colNote()).getColumn(), false);
            this.setColumnVisible(this.getHeader(MESSAGES.colApproval()).getColumn(), this.getMode().hasFlag(ModeFlag.MustShowApproval));
            this.setColumnVisible(this.getHeader(MESSAGES.colLastChange()).getColumn(), false);
            this.setColumnVisible(this.getHeader(MESSAGES.colMeetingContacts()).getColumn(), false);
        }
    }

    public boolean hasSortBy() {
        return this.iSortBy != null;
    }

    public String getSortBy() {
        return this.iSortBy == null ? null : (this.iAsc ? "" : "-") + this.iSortBy.ordinal();
    }

    public void setSortBy(String sortBy) {
        if (sortBy == null || sortBy.isEmpty()) {
            this.iSortBy = null;
        } else if (sortBy.startsWith("+")) {
            this.iAsc = true;
            this.iSortBy = EventComparator.EventMeetingSortBy.values()[Integer.parseInt(sortBy.substring(1))];
        } else if (sortBy.startsWith("-")) {
            this.iAsc = false;
            this.iSortBy = EventComparator.EventMeetingSortBy.values()[Integer.parseInt(sortBy.substring(1))];
        } else {
            this.iAsc = true;
            this.iSortBy = sortBy == null ? null : EventComparator.EventMeetingSortBy.values()[Integer.parseInt(sortBy)];
        }
        this.sort();
    }

    protected void addSortByOperation(final UniTimeTableHeader header, final EventComparator.EventMeetingSortBy sortBy) {
        header.addOperation(new UniTimeTableHeader.Operation(){

            public void execute() {
                if (header.getOrder() != null) {
                    EventMeetingTable.this.iAsc = header.getOrder() == false;
                } else {
                    EventMeetingTable.this.iAsc = true;
                }
                EventMeetingTable.this.iSortBy = sortBy;
                EventMeetingTable.this.sort();
                EventMeetingTable.this.onSortByChanded(sortBy, EventMeetingTable.this.iAsc);
            }

            @Override
            public boolean isApplicable() {
                return EventMeetingTable.this.getRowCount() > 1;
            }

            @Override
            public boolean hasSeparator() {
                return true;
            }

            @Override
            public String getName() {
                return MESSAGES.opSortBy(header.getHTML());
            }
        });
    }

    protected void onSortByChanded(EventComparator.EventMeetingSortBy sortBy, boolean asc) {
    }

    protected void onColumnShownOrHid(int eventCookieFlags) {
    }

    protected UniTimeTableHeader.Operation addHideOperation(UniTimeTableHeader header, EventInterface.EventFlag flag) {
        return this.addHideOperation(header, flag, null);
    }

    protected UniTimeTableHeader.Operation addHideOperation(final UniTimeTableHeader header, final EventInterface.EventFlag flag, final Check separator) {
        UniTimeTableHeader.AriaOperation op = new UniTimeTableHeader.AriaOperation(){

            public void execute() {
                UniTimeTableHeader other;
                boolean visible = EventMeetingTable.this.isColumnVisible(header.getColumn());
                EventMeetingTable.this.setColumnVisible(header.getColumn(), !visible);
                EventCookie.getInstance().set(flag, !visible);
                if (flag == EventInterface.EventFlag.SHOW_ALLOCATED_TIME && visible) {
                    UniTimeTableHeader other2 = EventMeetingTable.this.getHeader(MESSAGES.colPublishedTime());
                    if (!EventMeetingTable.this.isColumnVisible(other2.getColumn())) {
                        EventMeetingTable.this.setColumnVisible(other2.getColumn(), true);
                        EventCookie.getInstance().set(EventInterface.EventFlag.SHOW_PUBLISHED_TIME, true);
                    }
                } else if (flag == EventInterface.EventFlag.SHOW_PUBLISHED_TIME && visible && !EventMeetingTable.this.isColumnVisible((other = EventMeetingTable.this.getHeader(MESSAGES.colAllocatedTime())).getColumn())) {
                    EventMeetingTable.this.setColumnVisible(other.getColumn(), true);
                    EventCookie.getInstance().set(EventInterface.EventFlag.SHOW_ALLOCATED_TIME, true);
                }
                EventMeetingTable.this.onColumnShownOrHid(EventCookie.getInstance().getFlags());
            }

            @Override
            public boolean isApplicable() {
                switch (flag) {
                    case SHOW_MAIN_CONTACT: 
                    case SHOW_LAST_CHANGE: {
                        return EventMeetingTable.this.iShowMainContact && EventMeetingTable.this.getMode().hasFlag(ModeFlag.ShowEventDetails);
                    }
                    case SHOW_LIMIT: 
                    case SHOW_ENROLLMENT: 
                    case SHOW_SPONSOR: 
                    case SHOW_NOTE: 
                    case SHOW_REQUESTED_SERVICES: {
                        return EventMeetingTable.this.getMode().hasFlag(ModeFlag.ShowEventDetails);
                    }
                    case SHOW_TITLE: {
                        return EventMeetingTable.this.isColumnVisible(EventMeetingTable.this.getHeader(MESSAGES.colSection()).getColumn());
                    }
                    case SHOW_APPROVAL: {
                        return !EventMeetingTable.this.getMode().hasFlag(ModeFlag.MustShowApproval);
                    }
                    case SHOW_MEETING_CONTACTS: {
                        return EventMeetingTable.this.iShowMeetingContacts;
                    }
                }
                return true;
            }

            @Override
            public boolean hasSeparator() {
                return separator != null && separator.isChecked();
            }

            @Override
            public String getName() {
                return EventMeetingTable.this.isColumnVisible(header.getColumn()) ? MESSAGES.opHide(header.getHTML()) : MESSAGES.opShow(header.getHTML());
            }

            @Override
            public String getAriaLabel() {
                return EventMeetingTable.this.isColumnVisible(header.getColumn()) ? ARIA.opHide(header.getHTML()) : ARIA.opShow(header.getHTML());
            }
        };
        this.getHeader(null).addOperation(op);
        this.getHeader(MESSAGES.colName()).addOperation(this.ifNotSelectable(op));
        switch (flag) {
            case SHOW_ALLOCATED_TIME: 
            case SHOW_PUBLISHED_TIME: 
            case SHOW_SETUP_TIME: 
            case SHOW_TEARDOWN_TIME: {
                this.getHeader(MESSAGES.colAllocatedTime()).addOperation(op);
                this.getHeader(MESSAGES.colPublishedTime()).addOperation(op);
                this.getHeader(MESSAGES.colSetupTimeShort()).addOperation(op);
                this.getHeader(MESSAGES.colTeardownTimeShort()).addOperation(op);
                break;
            }
            case SHOW_LIMIT: 
            case SHOW_ENROLLMENT: 
            case SHOW_CAPACITY: {
                this.getHeader(MESSAGES.colLocation()).addOperation(op);
                header.addOperation(op);
                break;
            }
            case SHOW_MAIN_CONTACT: 
            case SHOW_LAST_CHANGE: {
                this.getHeader(MESSAGES.colApproval()).addOperation(op);
                header.addOperation(op);
                break;
            }
            case SHOW_SPONSOR: {
                this.getHeader(MESSAGES.colApproval()).addOperation(op);
                header.addOperation(op);
                break;
            }
            case SHOW_TITLE: {
                this.getHeader(MESSAGES.colSection()).addOperation(op);
                this.getHeader(MESSAGES.colType()).addOperation(op);
                header.addOperation(op);
                break;
            }
            default: {
                header.addOperation(op);
            }
        }
        return op;
    }

    private UniTimeTableHeader.Operation ifNotSelectable(final UniTimeTableHeader.Operation op) {
        return new UniTimeTableHeader.Operation(){

            public void execute() {
                op.execute();
            }

            @Override
            public String getName() {
                return op.getName();
            }

            @Override
            public boolean isApplicable() {
                return op.isApplicable() && !EventMeetingTable.this.isColumnVisible(EventMeetingTable.this.getHeader(null).getColumn());
            }

            @Override
            public boolean hasSeparator() {
                return op.hasSeparator();
            }
        };
    }

    public void sort() {
        if (this.iSortBy != null) {
            UniTimeTableHeader header = null;
            switch (this.iSortBy) {
                case NAME: {
                    header = this.getHeader(MESSAGES.colName());
                    break;
                }
                case SECTION: {
                    header = this.getHeader(MESSAGES.colSection());
                    break;
                }
                case TYPE: {
                    header = this.getHeader(MESSAGES.colType());
                    break;
                }
                case DATE: {
                    header = this.getHeader(MESSAGES.colDate());
                    break;
                }
                case PUBLISHED_TIME: {
                    header = this.getHeader(MESSAGES.colPublishedTime());
                    break;
                }
                case ALLOCATED_TIME: {
                    header = this.getHeader(MESSAGES.colAllocatedTime());
                    break;
                }
                case SETUP_TIME: {
                    header = this.getHeader(MESSAGES.colSetupTimeShort());
                    break;
                }
                case TEARDOWN_TIME: {
                    header = this.getHeader(MESSAGES.colTeardownTimeShort());
                    break;
                }
                case LOCATION: {
                    header = this.getHeader(MESSAGES.colLocation());
                    break;
                }
                case CAPACITY: {
                    header = this.getHeader(MESSAGES.colCapacity());
                    break;
                }
                case SPONSOR: {
                    header = this.getHeader(MESSAGES.colSponsorOrInstructor());
                    break;
                }
                case MAIN_CONTACT: {
                    header = this.getHeader(MESSAGES.colMainContact());
                    break;
                }
                case APPROVAL: {
                    header = this.getHeader(MESSAGES.colApproval());
                    break;
                }
                case LIMIT: {
                    header = this.getHeader(MESSAGES.colLimit());
                    break;
                }
                case ENROLLMENT: {
                    header = this.getHeader(MESSAGES.colEnrollment());
                    break;
                }
                case TITLE: {
                    header = this.getHeader(MESSAGES.colTitle());
                    break;
                }
                case NOTE: {
                    header = this.getHeader(MESSAGES.colNote());
                    break;
                }
                case LAST_CHANGE: {
                    header = this.getHeader(MESSAGES.colLastChange());
                    break;
                }
                case MEETING_CONTACTS: {
                    header = this.getHeader(MESSAGES.colMeetingContacts());
                    break;
                }
                case SERVICES: {
                    header = this.getHeader(MESSAGES.colRequestedServices());
                }
            }
            this.sort(header, new Comparator<EventMeetingRow>(){

                @Override
                public int compare(EventMeetingRow o1, EventMeetingRow o2) {
                    int cmp = EventMeetingTable.this.compareRows(o1.hasParent() ? o1.getParent() : o1, o2.hasParent() ? o2.getParent() : o2);
                    if (cmp != 0) {
                        return cmp;
                    }
                    return EventMeetingTable.this.compareRows(o1.hasParent() ? o1 : null, o2.hasParent() ? o2 : null);
                }
            }, this.iAsc);
        }
        if (this.getMode().hasFlag(ModeFlag.ShowMeetings) && this.getMode().hasFlag(ModeFlag.ShowEventDetails)) {
            Long eventId = null;
            Long conflictId = null;
            Set<Integer> eventCols = this.getEventColumns();
            int line = 0;
            for (int row = 1; row < this.getRowCount(); ++row) {
                Widget w;
                boolean hasNext;
                EventMeetingRow data = (EventMeetingRow)this.getData(row);
                EventMeetingRow next = row + 1 < this.getRowCount() ? (EventMeetingRow)this.getData(row + 1) : null;
                boolean bl = hasNext = next != null && data.hasParent() == next.hasParent() && data.getEventId().equals(next.getEventId());
                if (!data.hasParent()) {
                    if (eventId == null || !eventId.equals(data.getEventId())) {
                        line = 0;
                        for (int col = 0; col < this.getCellCount(row); ++col) {
                            this.getCellFormatter().addStyleName(row, col, "event-cell");
                        }
                        for (int col : eventCols) {
                            w = this.getWidget(row, col);
                            if (w instanceof MultiLineCell) {
                                ((MultiLineCell)w).showLine(line, hasNext);
                                continue;
                            }
                            w.setVisible(true);
                        }
                    } else {
                        for (int col = 0; col < this.getCellCount(row); ++col) {
                            this.getCellFormatter().removeStyleName(row, col, "event-cell");
                        }
                        for (int col : eventCols) {
                            w = this.getWidget(row, col);
                            if (w instanceof MultiLineCell) {
                                ((MultiLineCell)w).showLine(line, hasNext);
                                continue;
                            }
                            w.setVisible(false);
                        }
                    }
                } else if (conflictId == null || !conflictId.equals(data.getEventId())) {
                    line = 0;
                    for (int col : eventCols) {
                        w = this.getWidget(row, col);
                        if (w instanceof MultiLineCell) {
                            ((MultiLineCell)w).showLine(line, hasNext);
                            continue;
                        }
                        w.setVisible(true);
                    }
                } else {
                    for (int col : eventCols) {
                        w = this.getWidget(row, col);
                        if (w instanceof MultiLineCell) {
                            ((MultiLineCell)w).showLine(line, hasNext);
                            continue;
                        }
                        w.setVisible(false);
                    }
                }
                eventId = data.hasParent() ? null : data.getEventId();
                conflictId = data.hasParent() ? data.getEventId() : null;
                ++line;
            }
        }
    }

    protected int compareRows(EventMeetingRow r1, EventMeetingRow r2) {
        int cmp;
        Iterator<EventInterface.MeetingInterface> i2;
        int cmp2;
        if (r1 == null) {
            return r2 == null ? 0 : -1;
        }
        if (r2 == null) {
            return 1;
        }
        if (r1.hasEvent() && r2.hasEvent() && (cmp2 = EventComparator.compareEvents(r1.getEvent(), r2.getEvent(), this.iSortBy)) != 0) {
            return cmp2;
        }
        if (r1.hasMeeting() && r2.hasMeeting()) {
            cmp2 = EventComparator.compareMeetings(r1.getMeeting(), r2.getMeeting(), this.iSortBy);
            if (cmp2 != 0) {
                return cmp2;
            }
        } else {
            Iterator<EventInterface.MeetingInterface> i1 = r1.getMeetings(this.getMeetingFilter()).iterator();
            i2 = r2.getMeetings(this.getMeetingFilter()).iterator();
            while (i1.hasNext() && i2.hasNext()) {
                cmp = EventComparator.compareMeetings(i1.next(), i2.next(), this.iSortBy);
                if (cmp == 0) continue;
                return cmp;
            }
        }
        if (r1.hasEvent() && r2.hasEvent() && (cmp = EventComparator.compareFallback(r1.getEvent(), r2.getEvent())) != 0) {
            return cmp;
        }
        if (r1.hasMeeting() && r2.hasMeeting()) {
            cmp = EventComparator.compareFallback(r1.getMeeting(), r2.getMeeting());
            if (cmp != 0) {
                return cmp;
            }
        } else {
            Iterator<EventInterface.MeetingInterface> i1 = r1.getMeetings(this.getMeetingFilter()).iterator();
            i2 = r2.getMeetings(this.getMeetingFilter()).iterator();
            while (i1.hasNext() && i2.hasNext()) {
                cmp = EventComparator.compareFallback(i1.next(), i2.next());
                if (cmp == 0) continue;
                return cmp;
            }
            if (i1.hasNext() && !i2.hasNext()) {
                return 1;
            }
            if (!i1.hasNext() && i2.hasNext()) {
                return -1;
            }
        }
        if (r1.hasMeeting() && r2.hasMeeting()) {
            return r1.getMeeting().compareTo(r2.getMeeting());
        }
        if (r1.hasEvent() && r2.hasEvent()) {
            return r1.getEvent().compareTo(r2.getEvent());
        }
        return 0;
    }

    public EventInterface next(Long eventId) {
        boolean next = false;
        for (int row = 1; row < this.getRowCount(); ++row) {
            EventMeetingRow data = (EventMeetingRow)this.getData(row);
            if (data.hasParent()) continue;
            if (next && !eventId.equals(data.getEventId())) {
                return data.getEvent();
            }
            if (!eventId.equals(data.getEvent().getId())) continue;
            next = true;
        }
        return null;
    }

    public EventInterface previous(Long eventId) {
        EventInterface prev = null;
        for (int row = 1; row < this.getRowCount(); ++row) {
            EventMeetingRow data = (EventMeetingRow)this.getData(row);
            if (data.hasParent()) continue;
            if (eventId.equals(data.getEventId())) {
                return prev;
            }
            prev = data.getEvent();
        }
        return null;
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<List<EventMeetingRow>> handler) {
        return this.addHandler((EventHandler)handler, ValueChangeEvent.getType());
    }

    public List<EventMeetingRow> getValue() {
        ArrayList<EventMeetingRow> value = new ArrayList<EventMeetingRow>();
        for (int row = 1; row < this.getRowCount(); ++row) {
            EventMeetingRow data = (EventMeetingRow)this.getData(row);
            if (data == null || data.hasParent()) continue;
            value.add(data);
        }
        return value;
    }

    public List<EventInterface.MeetingInterface> getMeetings() {
        ArrayList<EventInterface.MeetingInterface> meetings = new ArrayList<EventInterface.MeetingInterface>();
        for (int row = 1; row < this.getRowCount(); ++row) {
            EventMeetingRow data = (EventMeetingRow)this.getData(row);
            if (data == null || !data.hasMeeting() || data.hasParent()) continue;
            meetings.add(data.getMeeting());
        }
        return meetings;
    }

    public List<EventInterface> getEvents() {
        ArrayList<EventInterface> events = new ArrayList<EventInterface>();
        for (int row = 1; row < this.getRowCount(); ++row) {
            EventMeetingRow data = (EventMeetingRow)this.getData(row);
            if (data == null || !data.hasEvent() || data.hasParent()) continue;
            events.add(data.getEvent());
        }
        return events;
    }

    public Map<EventInterface, List<EventInterface.MeetingInterface>> getEventMeetings() {
        HashMap<EventInterface, List<EventInterface.MeetingInterface>> event2meetings = new HashMap<EventInterface, List<EventInterface.MeetingInterface>>();
        for (int row = 1; row < this.getRowCount(); ++row) {
            EventMeetingRow data = (EventMeetingRow)this.getData(row);
            if (data == null || data.hasParent() || !data.hasEvent()) continue;
            ArrayList<EventInterface.MeetingInterface> meetings = (ArrayList<EventInterface.MeetingInterface>)event2meetings.get(data.getEvent());
            if (meetings == null) {
                meetings = new ArrayList<EventInterface.MeetingInterface>();
                event2meetings.put(data.getEvent(), meetings);
            }
            if (data.hasMeeting()) {
                meetings.add(data.getMeeting());
                continue;
            }
            meetings.addAll(data.getMeetings(this.getMeetingFilter()));
        }
        return event2meetings;
    }

    public void setValue(List<EventMeetingRow> value) {
        this.setValue(value, false);
    }

    public void setValue(List<EventMeetingRow> value, boolean fireEvents) {
        this.clearTable(1);
        this.resetColumnVisibility();
        if (value != null) {
            for (EventMeetingRow row : value) {
                this.add(row);
            }
        }
        this.sort();
        if (fireEvents) {
            ValueChangeEvent.fire((HasValueChangeHandlers)this, value);
        }
    }

    public void setEvents(Collection<EventInterface> events) {
        this.setEvents(events, false);
    }

    public void setEvents(Collection<EventInterface> events, boolean fireEvents) {
        ArrayList<EventMeetingRow> rows = new ArrayList<EventMeetingRow>();
        if (events != null) {
            for (EventInterface event : events) {
                if (this.getMode().hasFlag(ModeFlag.ShowMeetings)) {
                    for (EventInterface.MeetingInterface meeting : event.getMeetings()) {
                        if (this.getMeetingFilter() != null && this.getMeetingFilter().filter(event, meeting)) continue;
                        rows.add(new EventMeetingRow(event, meeting));
                    }
                    continue;
                }
                rows.add(new EventMeetingRow(event, null));
            }
        }
        this.setValue(rows, fireEvents);
    }

    public void setMeetings(EventInterface event, Collection<EventInterface.MeetingInterface> meetings) {
        this.setMeetings(event, meetings, false);
    }

    public void setMeetings(EventInterface event, Collection<EventInterface.MeetingInterface> meetings, boolean fireEvents) {
        ArrayList<EventMeetingRow> rows = new ArrayList<EventMeetingRow>();
        if (this.getMode().hasFlag(ModeFlag.ShowMeetings)) {
            for (EventInterface.MeetingInterface meeting : meetings) {
                rows.add(new EventMeetingRow(event, meeting));
            }
        } else {
            rows.add(new EventMeetingRow(event, null));
        }
        this.setValue(rows, fireEvents);
    }

    private class CourseName
    extends P {
        private CourseDetailsWidget.CourseDetailsRpcResponse iDetails;

        public CourseName(final Long id, String name, String ... styles) {
            super(styles);
            this.iDetails = null;
            this.setText(name);
            if (id != null) {
                this.addMouseOverHandler(new MouseOverHandler(){

                    public void onMouseOver(MouseOverEvent event) {
                        if (CourseName.this.iDetails == null) {
                            RPC.execute(new CourseDetailsWidget.CourseDetailsRpcRequest(id), new AsyncCallback<CourseDetailsWidget.CourseDetailsRpcResponse>(){

                                public void onFailure(Throwable caught) {
                                    CourseName.this.iDetails = new CourseDetailsWidget.CourseDetailsRpcResponse();
                                }

                                public void onSuccess(CourseDetailsWidget.CourseDetailsRpcResponse result) {
                                    CourseName.this.iDetails = result;
                                    CourseName.this.showDetails();
                                }
                            });
                        } else {
                            CourseName.this.showDetails();
                        }
                    }
                });
                this.addMouseOutHandler(new MouseOutHandler(){

                    public void onMouseOut(MouseOutEvent event) {
                        CourseName.this.hideDetails();
                    }
                });
                this.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        if (CourseName.this.iDetails == null) {
                            RPC.execute(new CourseDetailsWidget.CourseDetailsRpcRequest(id), new AsyncCallback<CourseDetailsWidget.CourseDetailsRpcResponse>(){

                                public void onFailure(Throwable caught) {
                                    CourseName.this.iDetails = new CourseDetailsWidget.CourseDetailsRpcResponse();
                                }

                                public void onSuccess(CourseDetailsWidget.CourseDetailsRpcResponse result) {
                                    CourseName.this.iDetails = result;
                                    CourseName.this.openLink();
                                }
                            });
                        } else {
                            CourseName.this.openLink();
                        }
                        event.stopPropagation();
                    }
                });
            }
        }

        protected void showDetails() {
            if (this.iDetails != null && this.iDetails.hasDetails()) {
                HTML details = new HTML(this.iDetails.getDetails());
                details.setStyleName("unitime-CourseDetailsPopup");
                GwtHint.showHint((Element)this.getElement(), (Widget)details);
            }
        }

        protected void hideDetails() {
            if (this.iDetails != null && this.iDetails.hasDetails()) {
                GwtHint.hideHint();
            }
        }

        protected void openLink() {
            if (this.iDetails != null && this.iDetails.hasLink()) {
                EventMeetingTable.this.clearHover();
                GwtHint.hideHint();
                UniTimeFrameDialog.openDialog(MESSAGES.courseCatalogDialog(this.getText()), this.iDetails.getLink(), null, null, false);
            }
        }
    }

    public static class HTMLWithColSpan
    extends HTML
    implements UniTimeTable.HasColSpan {
        private int iColspan = 1;

        public HTMLWithColSpan(String html, boolean wordWrap, int colspan) {
            super(html, wordWrap);
            this.iColspan = colspan;
        }

        @Override
        public int getColSpan() {
            return this.iColspan;
        }
    }

    public static interface Check {
        public boolean isChecked();
    }

    public static interface Implementation {
        public void execute(EventMeetingTable var1, OperationType var2, List<EventMeetingRow> var3);
    }

    public static interface MeetingFilter {
        public boolean filter(EventInterface var1, EventInterface.MeetingInterface var2);
    }

    private static class MultiLineNumberCell
    extends MultiLineStringCell
    implements UniTimeTable.HasCellAlignment {
        public MultiLineNumberCell(List<String> value) {
            super(value);
        }

        @Override
        public HasHorizontalAlignment.HorizontalAlignmentConstant getCellAlignment() {
            return HasHorizontalAlignment.ALIGN_RIGHT;
        }
    }

    private static class MultiLinePCell
    extends P
    implements MultiLineCell {
        List<P> iValue;

        public MultiLinePCell(List<P> value) {
            super("multiple-lines");
            this.iValue = value;
            this.showLine(0, false);
        }

        public MultiLinePCell(P ... values) {
            super("multiple-lines");
            this.iValue = new ArrayList<P>();
            for (P value : values) {
                this.iValue.add(value);
            }
            this.showLine(0, false);
        }

        @Override
        public void showLine(int line, boolean hasNext) {
            this.clear();
            this.add((Widget)(line >= 0 && line < this.iValue.size() ? (Widget)this.iValue.get(line) : new P("blank-line")));
            if (!hasNext && line >= 0 && line + 1 < this.iValue.size()) {
                for (int i = line + 1; i < this.iValue.size(); ++i) {
                    this.add((Widget)this.iValue.get(i));
                }
            }
        }
    }

    private static class MultiLineStringCell
    extends HTML
    implements MultiLineCell {
        List<String> iValue;

        public MultiLineStringCell(List<String> value) {
            this.setWordWrap(false);
            this.iValue = value;
            this.showLine(0, false);
        }

        public MultiLineStringCell(String ... values) {
            this.setWordWrap(false);
            this.iValue = new ArrayList<String>();
            for (String value : values) {
                this.iValue.add(value);
            }
            this.showLine(0, false);
        }

        @Override
        public void showLine(int line, boolean hasNext) {
            String html;
            String string = html = line >= 0 && line < this.iValue.size() ? this.iValue.get(line) : "";
            if (!hasNext && line >= 0 && line + 1 < this.iValue.size()) {
                for (int i = line + 1; i < this.iValue.size(); ++i) {
                    html = html + "<br>" + this.iValue.get(i);
                }
            }
            this.setHTML(html);
        }
    }

    private static interface MultiLineCell {
        public void showLine(int var1, boolean var2);
    }

    public static class EventMeetingRow {
        EventInterface iEvent;
        EventInterface.MeetingInterface iMeeting;
        EventMeetingRow iParent;

        EventMeetingRow(EventInterface event, EventInterface.MeetingInterface meeting, EventMeetingRow parent) {
            this.iEvent = event;
            this.iMeeting = meeting;
            this.iParent = parent;
        }

        EventMeetingRow(EventInterface event, EventInterface.MeetingInterface meeting) {
            this(event, meeting, null);
        }

        public boolean hasEvent() {
            return this.iEvent != null;
        }

        public EventInterface getEvent() {
            return this.iEvent;
        }

        public Long getEventId() {
            if (this.iEvent != null) {
                return this.iEvent.getId();
            }
            if (this.iMeeting != null && this.iMeeting instanceof EventInterface.MeetingConflictInterface) {
                return ((EventInterface.MeetingConflictInterface)this.iMeeting).getEventId();
            }
            return null;
        }

        public boolean hasMeeting() {
            return this.iMeeting != null;
        }

        public EventInterface.MeetingInterface getMeeting() {
            if (this.iMeeting != null && this.iMeeting.getId() == null) {
                if (this.iMeeting.isAutomaticallyApproved() || EventCookie.getInstance().isAutomaticallyApproveNewMeetings() && this.iMeeting.isCanApprove()) {
                    this.iMeeting.setApprovalStatus(EventInterface.ApprovalStatus.Approved);
                } else {
                    this.iMeeting.setApprovalStatus(EventInterface.ApprovalStatus.Pending);
                }
            }
            return this.iMeeting;
        }

        public boolean hasParent() {
            return this.iParent != null;
        }

        public EventMeetingRow getParent() {
            return this.iParent;
        }

        public boolean inConflict() {
            if (this.iMeeting != null && this.iMeeting.inConflict()) {
                return true;
            }
            if (this.iEvent != null && this.iEvent.hasConflicts()) {
                if (this.iMeeting == null) {
                    return true;
                }
                for (EventInterface conflict : this.iEvent.getConflicts()) {
                    if (conflict.getType() == EventInterface.EventType.Message || !conflict.inConflict(this.iMeeting)) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean isCanApprove() {
            if (this.iMeeting != null) {
                return this.iMeeting.isCanApprove();
            }
            if (this.iEvent != null && this.iEvent.hasMeetings()) {
                for (EventInterface.MeetingInterface meeting : this.iEvent.getMeetings()) {
                    if (!meeting.isCanApprove()) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean isCanInquire() {
            if (this.iMeeting != null) {
                return this.iMeeting.isCanInquire();
            }
            if (this.iEvent != null && this.iEvent.hasMeetings()) {
                for (EventInterface.MeetingInterface meeting : this.iEvent.getMeetings()) {
                    if (!meeting.isCanInquire()) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean isCanCancel() {
            if (this.iMeeting != null) {
                return this.iMeeting.isCanCancel();
            }
            if (this.iEvent != null && this.iEvent.hasMeetings()) {
                for (EventInterface.MeetingInterface meeting : this.iEvent.getMeetings()) {
                    if (!meeting.isCanCancel()) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean isCanDelete() {
            if (this.iMeeting != null) {
                return this.iMeeting.isCanDelete();
            }
            if (this.iEvent != null && this.iEvent.hasMeetings()) {
                for (EventInterface.MeetingInterface meeting : this.iEvent.getMeetings()) {
                    if (!meeting.isCanDelete()) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean isEditable() {
            return this.iMeeting != null && (this.iMeeting.getId() == null || this.iMeeting.isCanEdit());
        }

        public List<EventInterface.MeetingInterface> getMeetings(MeetingFilter filter) {
            ArrayList<EventInterface.MeetingInterface> meetings = new ArrayList<EventInterface.MeetingInterface>();
            if (this.iMeeting != null) {
                if (filter == null || !filter.filter(this.iParent == null ? this.iEvent : this.iParent.iEvent, this.iMeeting)) {
                    meetings.add(this.iMeeting);
                }
            } else if (this.iEvent != null && this.iEvent.hasMeetings()) {
                for (EventInterface.MeetingInterface meeting : this.iEvent.getMeetings()) {
                    if (filter != null && filter.filter(this.iParent == null ? this.iEvent : this.iParent.iEvent, meeting)) continue;
                    meetings.add(meeting);
                }
            }
            return meetings;
        }

        public String toAriaString(boolean includeEventInfo) {
            String label = "";
            if (includeEventInfo && this.hasEvent()) {
                label = label + (this.getEvent().getType() == null || this.getEvent().getType() == EventInterface.EventType.Unavailabile ? "" : this.getEvent().getType().getAbbreviation(CONSTANTS));
                if (this.getEvent().getName() != null) {
                    label = label + " " + this.getEvent().getName();
                }
            }
            if (this.hasMeeting() && this.getMeeting().getMeetingDate() != null) {
                String room = "";
                String hint = "";
                if (this.getMeeting().getLocation() != null) {
                    room = this.getMeeting().getLocation().getName();
                    if (this.getMeeting().getLocation().hasRoomType()) {
                        hint = this.getMeeting().getLocation().getRoomType();
                    }
                }
                label = label + ARIA.dateTimeRoomSelection(sDateFormatAria.format(this.getMeeting().getMeetingDate()), TimeSelector.TimeUtils.slot2aria(this.getMeeting().getStartSlot()), TimeSelector.TimeUtils.slot2aria(this.getMeeting().getEndSlot()), room, hint);
            }
            return label;
        }
    }

    protected abstract class EventMeetingOperation
    implements UniTimeTableHeader.Operation {
        protected EventMeetingOperation() {
        }

        public void execute() {
            block3: {
                block2: {
                    if (!this.hasSelection()) break block2;
                    for (int row = EventMeetingTable.this.getRowCount() - 1; row >= 1; --row) {
                        EventMeetingRow e;
                        CheckBox ch;
                        Widget w = EventMeetingTable.this.getWidget(row, 0);
                        if (w == null || !(w instanceof CheckBox) || !(ch = (CheckBox)w).getValue().booleanValue() || !this.isApplicable(e = (EventMeetingRow)EventMeetingTable.this.getData(row))) continue;
                        this.execute(row, e);
                    }
                    break block3;
                }
                if (!this.allowNoSelection()) break block3;
                for (int row = EventMeetingTable.this.getRowCount() - 1; row >= 1; --row) {
                    EventMeetingRow e;
                    Widget w = EventMeetingTable.this.getWidget(row, 0);
                    if (w == null || !(w instanceof CheckBox) || !this.isApplicable(e = (EventMeetingRow)EventMeetingTable.this.getData(row))) continue;
                    this.execute(row, e);
                }
            }
        }

        public boolean hasSelection() {
            for (int row = 1; row < EventMeetingTable.this.getRowCount(); ++row) {
                CheckBox ch;
                Widget w = EventMeetingTable.this.getWidget(row, 0);
                if (w == null || !(w instanceof CheckBox) || !(ch = (CheckBox)w).getValue().booleanValue()) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isApplicable() {
            boolean hasSelection = this.hasSelection();
            boolean allMustMatch = this.allMustMatch(hasSelection);
            if (hasSelection) {
                for (int row = 1; row < EventMeetingTable.this.getRowCount(); ++row) {
                    CheckBox ch;
                    Widget w = EventMeetingTable.this.getWidget(row, 0);
                    if (w == null || !(w instanceof CheckBox) || !(ch = (CheckBox)w).getValue().booleanValue()) continue;
                    EventMeetingRow e = (EventMeetingRow)EventMeetingTable.this.getData(row);
                    if (this.isApplicable(e)) {
                        if (allMustMatch) continue;
                        return true;
                    }
                    if (!allMustMatch) continue;
                    return false;
                }
                return allMustMatch;
            }
            if (this.allowNoSelection()) {
                for (int row = 1; row < EventMeetingTable.this.getRowCount(); ++row) {
                    Widget w = EventMeetingTable.this.getWidget(row, 0);
                    if (w == null || !(w instanceof CheckBox)) continue;
                    EventMeetingRow e = (EventMeetingRow)EventMeetingTable.this.getData(row);
                    if (this.isApplicable(e)) {
                        if (allMustMatch) continue;
                        return true;
                    }
                    if (!allMustMatch) continue;
                    return false;
                }
                return allMustMatch;
            }
            return false;
        }

        public List<EventMeetingRow> data() {
            ArrayList<EventMeetingRow> data;
            block3: {
                block2: {
                    data = new ArrayList<EventMeetingRow>();
                    if (!this.hasSelection()) break block2;
                    for (int row = 1; row < EventMeetingTable.this.getRowCount(); ++row) {
                        EventMeetingRow e;
                        CheckBox ch;
                        Widget w = EventMeetingTable.this.getWidget(row, 0);
                        if (w == null || !(w instanceof CheckBox) || !(ch = (CheckBox)w).getValue().booleanValue() || !this.isApplicable(e = (EventMeetingRow)EventMeetingTable.this.getData(row))) continue;
                        data.add(e);
                    }
                    break block3;
                }
                if (!this.allowNoSelection()) break block3;
                for (int row = 1; row < EventMeetingTable.this.getRowCount(); ++row) {
                    EventMeetingRow e;
                    Widget w = EventMeetingTable.this.getWidget(row, 0);
                    if (w == null || !(w instanceof CheckBox) || !this.isApplicable(e = (EventMeetingRow)EventMeetingTable.this.getData(row))) continue;
                    data.add(e);
                }
            }
            return data;
        }

        public List<Integer> rows() {
            ArrayList<Integer> rows;
            block3: {
                block2: {
                    rows = new ArrayList<Integer>();
                    if (!this.hasSelection()) break block2;
                    for (int row = 1; row < EventMeetingTable.this.getRowCount(); ++row) {
                        EventMeetingRow e;
                        CheckBox ch;
                        Widget w = EventMeetingTable.this.getWidget(row, 0);
                        if (w == null || !(w instanceof CheckBox) || !(ch = (CheckBox)w).getValue().booleanValue() || !this.isApplicable(e = (EventMeetingRow)EventMeetingTable.this.getData(row))) continue;
                        rows.add(row);
                    }
                    break block3;
                }
                if (!this.allowNoSelection()) break block3;
                for (int row = 1; row < EventMeetingTable.this.getRowCount(); ++row) {
                    EventMeetingRow e;
                    Widget w = EventMeetingTable.this.getWidget(row, 0);
                    if (w == null || !(w instanceof CheckBox) || !this.isApplicable(e = (EventMeetingRow)EventMeetingTable.this.getData(row))) continue;
                    rows.add(row);
                }
            }
            return rows;
        }

        public boolean allMustMatch(boolean hasSelection) {
            return hasSelection;
        }

        public boolean allowNoSelection() {
            return true;
        }

        public abstract boolean isApplicable(EventMeetingRow var1);

        public abstract void execute(int var1, EventMeetingRow var2);

        @Override
        public boolean hasSeparator() {
            return false;
        }
    }

    public static enum OperationType {
        Approve,
        Reject,
        Inquire,
        AddMeetings,
        Cancel,
        Delete,
        Modify;

    }

    public static enum Mode {
        ListOfEvents(ModeFlag.ShowEventDetails, ModeFlag.ShowOptionalColumns, ModeFlag.CanHideDuplicitiesForMeetings),
        ListOfMeetings(ModeFlag.ShowEventDetails, ModeFlag.ShowMeetings, ModeFlag.ShowOptionalColumns),
        MeetingsOfAnEvent(ModeFlag.ShowMeetings, ModeFlag.ShowOptionalColumns, ModeFlag.MustShowApproval, ModeFlag.AllowApproveAll, ModeFlag.HideTitle),
        ApprovalOfEvents(ModeFlag.ShowEventDetails, ModeFlag.MustShowApproval),
        ApprovalOfMeetings(ModeFlag.ShowEventDetails, ModeFlag.ShowMeetings, ModeFlag.MustShowApproval),
        ApprovalOfSingleEventMeetings(ModeFlag.ShowMeetings, ModeFlag.MustShowApproval);

        private int iFlags = 0;

        private Mode(ModeFlag ... flags) {
            for (ModeFlag flag : flags) {
                this.iFlags = flag.set(this.iFlags);
            }
        }

        public boolean hasFlag(ModeFlag flag) {
            return flag.in(this.iFlags);
        }
    }

    public static enum ModeFlag {
        ShowEventDetails,
        ShowMeetings,
        ShowOptionalColumns,
        MustShowApproval,
        AllowApproveAll,
        HideTitle,
        CanHideDuplicitiesForMeetings;


        public int flag() {
            return 1 << this.ordinal();
        }

        public boolean in(int flags) {
            return (flags & this.flag()) != 0;
        }

        public int set(int flags) {
            return this.in(flags) ? flags : flags + this.flag();
        }

        public int clear(int flags) {
            return this.in(flags) ? flags - this.flag() : flags;
        }
    }
}

