/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.events;

import com.google.gwt.user.client.Cookies;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.unitime.timetable.gwt.shared.EventInterface;

public class EventCookie {
    private int iFlags = EventInterface.sDefaultEventFlags;
    private Map<String, String> iHash = new HashMap<String, String>();
    private boolean iShowDeltedMeetings = true;
    private int iSortRoomsBy = -1;
    private boolean iRoomsHorizontal = true;
    private boolean iExpandRoomConflicts = false;
    private static EventCookie sInstance = null;
    private boolean iAutomaticallyApproveNewMeetings = false;
    private boolean iHideDuplicitiesForMeetings = false;

    private EventCookie() {
        try {
            String cookie = Cookies.getCookie((String)"UniTime:Event");
            if (cookie != null) {
                String[] params = cookie.split("\\|");
                int idx = 0;
                this.iFlags = Integer.parseInt(params[idx++]);
                this.iShowDeltedMeetings = "T".equals(params[idx++]);
                this.iSortRoomsBy = Integer.valueOf(params[idx++]);
                this.iRoomsHorizontal = !"F".equals(params[idx++]);
                this.iExpandRoomConflicts = "T".equals(params[idx++]);
                this.iAutomaticallyApproveNewMeetings = "T".equals(params[idx++]);
                this.iHideDuplicitiesForMeetings = "T".equals(params[idx++]);
                while (idx < params.length) {
                    String hash = params[idx++];
                    int colon = hash.indexOf(58);
                    this.iHash.put(hash.substring(0, colon), hash.substring(colon + 1));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void save() {
        String cookie = String.valueOf(this.iFlags) + "|" + (this.iShowDeltedMeetings ? "T" : "F") + "|" + this.iSortRoomsBy + "|" + (this.iRoomsHorizontal ? "T" : "F") + "|" + (this.iExpandRoomConflicts ? "T" : "F") + "|" + (this.iAutomaticallyApproveNewMeetings ? "T" : "F") + "|" + (this.iHideDuplicitiesForMeetings ? "T" : "F");
        for (Map.Entry<String, String> entry : this.iHash.entrySet()) {
            cookie = cookie + "|" + entry.getKey() + ":" + entry.getValue();
        }
        Date expires = new Date(new Date().getTime() + 604800000L);
        Cookies.setCookie((String)"UniTime:Event", (String)cookie, (Date)expires);
    }

    public static EventCookie getInstance() {
        if (sInstance == null) {
            sInstance = new EventCookie();
        }
        return sInstance;
    }

    public boolean get(EventInterface.EventFlag f) {
        return f.in(this.iFlags);
    }

    public void set(EventInterface.EventFlag f, boolean value) {
        this.iFlags = value ? f.set(this.iFlags) : f.clear(this.iFlags);
        this.save();
    }

    public int getFlags() {
        return this.iFlags;
    }

    public boolean hasHash(String type) {
        String hash = this.getHash(type);
        return hash != null && !hash.isEmpty();
    }

    public String getHash(String type) {
        return this.iHash.get(type);
    }

    public void setHash(String type, String hash) {
        this.iHash.put(type, hash);
        this.save();
    }

    public boolean isShowDeletedMeetings() {
        return this.iShowDeltedMeetings;
    }

    public void setShowDeletedMeetings(boolean show) {
        this.iShowDeltedMeetings = show;
        this.save();
    }

    public int getRoomsSortBy() {
        return this.iSortRoomsBy;
    }

    public void setSortRoomsBy(int sortRoomsBy) {
        this.iSortRoomsBy = sortRoomsBy;
        this.save();
    }

    public boolean areRoomsHorizontal() {
        return this.iRoomsHorizontal;
    }

    public void setRoomsHorizontal(boolean roomsHorizontal) {
        this.iRoomsHorizontal = roomsHorizontal;
        this.save();
    }

    public boolean isExpandRoomConflicts() {
        return this.iExpandRoomConflicts;
    }

    public void setExpandRoomConflicts(boolean expandRoomConflicts) {
        this.iExpandRoomConflicts = expandRoomConflicts;
        this.save();
    }

    public boolean isAutomaticallyApproveNewMeetings() {
        return this.iAutomaticallyApproveNewMeetings;
    }

    public void setAutomaticallyApproveNewMeetings(boolean autoApprove) {
        this.iAutomaticallyApproveNewMeetings = autoApprove;
        this.save();
    }

    public boolean isHideDuplicitiesForMeetings() {
        return this.iHideDuplicitiesForMeetings;
    }

    public void setHideDuplicitiesForMeetings(boolean hideDuplicitiesForMeetings) {
        this.iHideDuplicitiesForMeetings = hideDuplicitiesForMeetings;
        this.save();
    }
}

