/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.events;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.DoubleClickEvent;
import com.google.gwt.event.dom.client.DoubleClickHandler;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.events.EventAdd;
import org.unitime.timetable.gwt.client.events.EventMeetingTable;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeDialogBox;
import org.unitime.timetable.gwt.client.widgets.UniTimeFileUpload;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.EventInterface;

public abstract class ApproveDialog
extends UniTimeDialogBox
implements EventMeetingTable.Implementation {
    private static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private SimpleForm iForm;
    private TextArea iNotes;
    private EventMeetingTable iTable;
    private ListBox iStandardNotes;
    private UniTimeFileUpload iFileUpload;
    private UniTimeHeaderPanel iFooter;
    private CheckBox iEmailConfirmation;
    private Button iStandardNotesSelection;

    public ApproveDialog(EventAdd.EventPropertiesProvider properties) {
        super(true, false);
        this.addStyleName("unitime-ApproveDialog");
        this.iTable = new EventMeetingTable(EventMeetingTable.Mode.ApprovalOfSingleEventMeetings, false, properties);
        this.iForm = new SimpleForm();
        if (this.iTable instanceof Widget) {
            ScrollPanel scroll = new ScrollPanel((Widget)this.iTable);
            scroll.addStyleName("scroll");
            this.iForm.addRow(MESSAGES.propMeetings(), (Widget)scroll);
        }
        P notes = new P("standard-notes");
        this.iStandardNotes = new ListBox();
        this.iStandardNotes.setVisibleItemCount(4);
        this.iStandardNotesSelection = new Button(MESSAGES.buttonSelect());
        ToolBox.setWhiteSpace(this.iStandardNotesSelection.getElement().getStyle(), "nowrap");
        Character accessKey = UniTimeHeaderPanel.guessAccessKey(MESSAGES.buttonSelect());
        if (accessKey != null) {
            this.iStandardNotesSelection.setAccessKey(accessKey.charValue());
        }
        this.iStandardNotesSelection.setEnabled(false);
        notes.add((Widget)this.iStandardNotes);
        notes.add((Widget)this.iStandardNotesSelection);
        this.iForm.addRow(MESSAGES.propStandardNotes(), (Widget)notes);
        this.iStandardNotes.addDoubleClickHandler(new DoubleClickHandler(){

            public void onDoubleClick(DoubleClickEvent event) {
                if (ApproveDialog.this.iStandardNotes.getItemCount() <= 0) {
                    return;
                }
                String text = ApproveDialog.this.iNotes.getText();
                if (!text.isEmpty() && !text.endsWith("\n")) {
                    text = text + "\n";
                }
                text = text + ApproveDialog.this.iStandardNotes.getValue(ApproveDialog.this.iStandardNotes.getSelectedIndex());
                ApproveDialog.this.iNotes.setText(text);
            }
        });
        this.iStandardNotes.addKeyPressHandler(new KeyPressHandler(){

            public void onKeyPress(KeyPressEvent event) {
                if (event.getNativeEvent().getKeyCode() == 13) {
                    String text = ApproveDialog.this.iNotes.getText();
                    if (!text.isEmpty() && !text.endsWith("\n")) {
                        text = text + "\n";
                    }
                    text = text + ApproveDialog.this.iStandardNotes.getValue(ApproveDialog.this.iStandardNotes.getSelectedIndex());
                    ApproveDialog.this.iNotes.setText(text);
                    event.preventDefault();
                    event.stopPropagation();
                }
            }
        });
        this.iStandardNotes.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                ApproveDialog.this.iStandardNotesSelection.setEnabled(ApproveDialog.this.iStandardNotes.getSelectedIndex() >= 0);
            }
        });
        this.iStandardNotesSelection.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (ApproveDialog.this.iStandardNotes.getSelectedIndex() >= 0) {
                    String text = ApproveDialog.this.iNotes.getText();
                    if (!text.isEmpty() && !text.endsWith("\n")) {
                        text = text + "\n";
                    }
                    text = text + ApproveDialog.this.iStandardNotes.getValue(ApproveDialog.this.iStandardNotes.getSelectedIndex());
                    ApproveDialog.this.iNotes.setText(text);
                }
                Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                    public void execute() {
                        ApproveDialog.this.iNotes.setFocus(true);
                    }
                });
            }
        });
        this.iNotes = new TextArea();
        this.iNotes.setStyleName("unitime-TextArea");
        this.iNotes.setVisibleLines(5);
        this.iNotes.setCharacterWidth(80);
        this.iForm.addRow(MESSAGES.propNotes(), (Widget)this.iNotes);
        this.iFileUpload = new UniTimeFileUpload();
        this.iForm.addRow(MESSAGES.propAttachment(), (Widget)this.iFileUpload);
        this.iFooter = new UniTimeHeaderPanel();
        this.iFooter.addButton("approve", MESSAGES.opApproveMeetings(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                ApproveDialog.this.onSubmit(EventInterface.SaveOrApproveEventRpcRequest.Operation.APPROVE, (List<EventMeetingTable.EventMeetingRow>)ApproveDialog.this.iTable.getValue(), ApproveDialog.this.iNotes.getText(), ApproveDialog.this.isSendEmailConformation());
                ApproveDialog.this.hide();
            }
        });
        this.iFooter.addButton("inquire", MESSAGES.opInquireMeetings(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                ApproveDialog.this.onSubmit(EventInterface.SaveOrApproveEventRpcRequest.Operation.INQUIRE, (List<EventMeetingTable.EventMeetingRow>)ApproveDialog.this.iTable.getValue(), ApproveDialog.this.iNotes.getText(), ApproveDialog.this.isSendEmailConformation());
                ApproveDialog.this.hide();
            }
        });
        this.iFooter.addButton("reject", MESSAGES.opRejectMeetings(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                ApproveDialog.this.onSubmit(EventInterface.SaveOrApproveEventRpcRequest.Operation.REJECT, (List<EventMeetingTable.EventMeetingRow>)ApproveDialog.this.iTable.getValue(), ApproveDialog.this.iNotes.getText(), ApproveDialog.this.isSendEmailConformation());
                ApproveDialog.this.hide();
            }
        });
        this.iFooter.addButton("cancel", MESSAGES.opCancelMeetings(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                ApproveDialog.this.onSubmit(EventInterface.SaveOrApproveEventRpcRequest.Operation.CANCEL, (List<EventMeetingTable.EventMeetingRow>)ApproveDialog.this.iTable.getValue(), ApproveDialog.this.iNotes.getText(), ApproveDialog.this.isSendEmailConformation());
                ApproveDialog.this.hide();
            }
        });
        this.iFooter.addButton("back", MESSAGES.opBack(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                ApproveDialog.this.hide();
            }
        });
        this.iEmailConfirmation = new CheckBox(MESSAGES.checkSendEmailConfirmation(), true);
        this.iEmailConfirmation.addStyleName("toggle");
        this.iFooter.insertRight((Widget)this.iEmailConfirmation, true);
        this.iForm.addBottomRow((Widget)this.iFooter);
        this.addCloseHandler((CloseHandler)new CloseHandler<PopupPanel>(){

            public void onClose(CloseEvent<PopupPanel> event) {
                RootPanel.getBodyElement().getStyle().setOverflow(Style.Overflow.AUTO);
            }
        });
        this.setWidget((Widget)this.iForm);
    }

    protected abstract void onSubmit(EventInterface.SaveOrApproveEventRpcRequest.Operation var1, List<EventMeetingTable.EventMeetingRow> var2, String var3, boolean var4);

    public void reset(EventInterface.EventPropertiesRpcResponse properties) {
        this.iNotes.setText("");
        this.iEmailConfirmation.setValue(Boolean.valueOf(properties == null || properties.isEmailConfirmation()));
        this.iEmailConfirmation.setVisible(properties == null || properties.hasEmailConfirmation());
        this.iStandardNotes.clear();
        this.iForm.getRowFormatter().setVisible(this.iForm.getRow(MESSAGES.propStandardNotes()), properties != null && properties.hasStandardNotes());
        if (properties != null && properties.hasStandardNotes()) {
            for (EventInterface.StandardEventNoteInterface note : properties.getStandardNotes()) {
                this.iStandardNotes.addItem(note.toString(), note.getNote());
            }
        }
        this.iFileUpload.reset();
    }

    public void show(List<EventMeetingTable.EventMeetingRow> meetings, EventInterface.SaveOrApproveEventRpcRequest.Operation operation) {
        this.iTable.setValue(meetings);
        switch (operation) {
            case APPROVE: {
                this.setText(MESSAGES.dialogApprove());
                break;
            }
            case REJECT: {
                this.setText(MESSAGES.dialogReject());
                break;
            }
            case INQUIRE: {
                this.setText(MESSAGES.dialogInquire());
                break;
            }
            case CANCEL: {
                this.setText(MESSAGES.dialogCancel());
            }
        }
        this.iFooter.setEnabled("approve", operation == EventInterface.SaveOrApproveEventRpcRequest.Operation.APPROVE);
        this.iFooter.setEnabled("reject", operation == EventInterface.SaveOrApproveEventRpcRequest.Operation.REJECT);
        this.iFooter.setEnabled("inquire", operation == EventInterface.SaveOrApproveEventRpcRequest.Operation.INQUIRE);
        this.iFooter.setEnabled("cancel", operation == EventInterface.SaveOrApproveEventRpcRequest.Operation.CANCEL);
        this.iFileUpload.check();
        this.center();
        if (this.iStandardNotes.getItemCount() == 0) {
            this.iNotes.setFocus(true);
        } else {
            this.iStandardNotes.setFocus(true);
        }
        RootPanel.getBodyElement().getStyle().setOverflow(Style.Overflow.HIDDEN);
    }

    public String getNote() {
        return this.iNotes.getText();
    }

    public boolean isSendEmailConformation() {
        return !this.iEmailConfirmation.isVisible() || this.iEmailConfirmation.getValue() != false;
    }

    @Override
    public void execute(final EventMeetingTable source, EventMeetingTable.OperationType operation, List<EventMeetingTable.EventMeetingRow> selection) {
        switch (source.getMode()) {
            case ListOfEvents: {
                this.iTable.setMode(EventMeetingTable.Mode.ApprovalOfEvents);
                break;
            }
            case ListOfMeetings: {
                this.iTable.setMode(EventMeetingTable.Mode.ApprovalOfMeetings);
                break;
            }
            case MeetingsOfAnEvent: {
                this.iTable.setMode(EventMeetingTable.Mode.ApprovalOfSingleEventMeetings);
            }
        }
        switch (operation) {
            case Approve: 
            case Reject: {
                this.iTable.setMeetingFilter(new EventMeetingTable.MeetingFilter(){

                    @Override
                    public boolean filter(EventInterface event, EventInterface.MeetingInterface meeting) {
                        return !meeting.isCanApprove() || source.getMeetingFilter() != null && source.getMeetingFilter().filter(event, meeting);
                    }
                });
                break;
            }
            case Inquire: {
                this.iTable.setMeetingFilter(new EventMeetingTable.MeetingFilter(){

                    @Override
                    public boolean filter(EventInterface event, EventInterface.MeetingInterface meeting) {
                        return !meeting.isCanInquire() || source.getMeetingFilter() != null && source.getMeetingFilter().filter(event, meeting);
                    }
                });
                break;
            }
            case Cancel: {
                this.iTable.setMeetingFilter(new EventMeetingTable.MeetingFilter(){

                    @Override
                    public boolean filter(EventInterface event, EventInterface.MeetingInterface meeting) {
                        return !meeting.isCanCancel() || source.getMeetingFilter() != null && source.getMeetingFilter().filter(event, meeting);
                    }
                });
            }
        }
        switch (operation) {
            case Approve: {
                this.show(selection, EventInterface.SaveOrApproveEventRpcRequest.Operation.APPROVE);
                break;
            }
            case Reject: {
                this.show(selection, EventInterface.SaveOrApproveEventRpcRequest.Operation.REJECT);
                break;
            }
            case Cancel: {
                this.show(selection, EventInterface.SaveOrApproveEventRpcRequest.Operation.CANCEL);
                break;
            }
            case Inquire: {
                this.show(selection, EventInterface.SaveOrApproveEventRpcRequest.Operation.INQUIRE);
            }
        }
    }
}

