/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.departments;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.TakesValue;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeConfirmationDialog;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.client.widgets.UniTimeWidget;
import org.unitime.timetable.gwt.command.client.GwtRpcRequest;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.DepartmentInterface;

public class DepartmentsEdit
extends Composite
implements TakesValue<DepartmentInterface> {
    protected static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    protected static GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private SimpleForm iForm;
    private UniTimeHeaderPanel iHeader;
    private UniTimeHeaderPanel iFooter;
    private UniTimeWidget<TextBox> iName;
    private UniTimeWidget<TextBox> iAbbreviation;
    private UniTimeWidget<TextBox> iExternalManagerAbbreviation;
    private UniTimeWidget<TextBox> iExternalManagerName;
    private UniTimeWidget<TextBox> iDistPrefPriority;
    private UniTimeWidget<CheckBox> iExternalManager;
    private UniTimeWidget<Label> iAcademicSession;
    private UniTimeWidget<TextBox> iDeptCode;
    private UniTimeWidget<ListBox> iStatusType;
    private ListBox[] iCurrentDependentOptions;
    private ListBox[] iCurrentStatusTypeOptions;
    private List<String> iCurrentDependentDepartments = new ArrayList<String>();
    private List<String> iCurrentDependentStatuses = new ArrayList<String>();
    private TextBox iExternalId;
    private UniTimeWidget<CheckBox> iAllowReqTime;
    private UniTimeWidget<CheckBox> iAllowReqRoom;
    private UniTimeWidget<CheckBox> iAllowReqDist;
    private UniTimeWidget<CheckBox> iAllowEvents;
    private UniTimeWidget<CheckBox> iInheritInstructorPreferences;
    private UniTimeWidget<CheckBox> iAllowStudentScheduling;
    private UniTimeWidget<CheckBox> iExternalFundingDept;
    private UniTimeHeaderPanel controlDeptHeaderPanel;
    private VerticalPanel iControlDeptMainPanel;
    private FlexTable iControlDeptFlexTable;
    private DepartmentInterface iDepartment = null;
    private int iExtManagerAbbvLine = 0;
    private DepartmentInterface.DepartmentPropertiesInterface iDepartmentProperties;

    public DepartmentsEdit() {
        this.iForm = new SimpleForm();
        this.iForm.addStyleName("unitime-Dept");
        this.iHeader = new UniTimeHeaderPanel();
        this.iHeader.addButton("save", MESSAGES.buttonSave(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (!DepartmentsEdit.this.validate()) {
                    return;
                }
                UpdateDepartmentRequest request = new UpdateDepartmentRequest();
                request.setAction(DepartmentInterface.UpdateDepartmentAction.CREATE);
                request.setDepartment(DepartmentsEdit.this.getValue());
                LoadingWidget.getInstance().show(MESSAGES.waitPlease());
                RPC.execute(request, new AsyncCallback<DepartmentInterface>(){

                    public void onFailure(Throwable caught) {
                        LoadingWidget.getInstance().hide();
                        DepartmentsEdit.this.iHeader.setErrorMessage(MESSAGES.failedCreate(MESSAGES.objectDepartment(), caught.getMessage()));
                        UniTimeNotifications.error(MESSAGES.failedCreate(MESSAGES.objectDepartment(), caught.getMessage()), caught);
                    }

                    public void onSuccess(DepartmentInterface result) {
                        LoadingWidget.getInstance().hide();
                        DepartmentsEdit.this.onBack(true, result.getId());
                    }
                });
            }
        });
        this.iHeader.addButton("update", MESSAGES.buttonUpdate(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (!DepartmentsEdit.this.validate()) {
                    return;
                }
                UpdateDepartmentRequest request = new UpdateDepartmentRequest();
                request.setAction(DepartmentInterface.UpdateDepartmentAction.UPDATE);
                request.setDepartment(DepartmentsEdit.this.getValue());
                LoadingWidget.getInstance().show(MESSAGES.waitPlease());
                RPC.execute(request, new AsyncCallback<DepartmentInterface>(){

                    public void onFailure(Throwable caught) {
                        LoadingWidget.getInstance().hide();
                        DepartmentsEdit.this.iHeader.setErrorMessage(MESSAGES.failedUpdate(MESSAGES.objectDepartment(), caught.getMessage()));
                        UniTimeNotifications.error(MESSAGES.failedUpdate(MESSAGES.objectDepartment(), caught.getMessage()), caught);
                    }

                    public void onSuccess(DepartmentInterface result) {
                        LoadingWidget.getInstance().hide();
                        DepartmentsEdit.this.onBack(true, result.getId());
                    }
                });
            }
        });
        this.iHeader.addButton("delete", MESSAGES.buttonDelete(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                UniTimeConfirmationDialog.confirm(MESSAGES.confirmDepartmentDelete(), new Command(){

                    public void execute() {
                        UpdateDepartmentRequest request = new UpdateDepartmentRequest();
                        request.setAction(DepartmentInterface.UpdateDepartmentAction.DELETE);
                        request.setDepartment(DepartmentsEdit.this.getValue());
                        LoadingWidget.getInstance().show(MESSAGES.waitPlease());
                        RPC.execute(request, new AsyncCallback<DepartmentInterface>(){

                            public void onFailure(Throwable caught) {
                                LoadingWidget.getInstance().hide();
                                DepartmentsEdit.this.iHeader.setErrorMessage(MESSAGES.failedDelete(MESSAGES.objectDepartment(), caught.getMessage()));
                                UniTimeNotifications.error(MESSAGES.failedDelete(MESSAGES.objectDepartment(), caught.getMessage()), caught);
                            }

                            public void onSuccess(DepartmentInterface result) {
                                LoadingWidget.getInstance().hide();
                                DepartmentsEdit.this.onBack(true, null);
                            }
                        });
                    }
                });
            }
        });
        this.iHeader.addButton("back", MESSAGES.buttonBack(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                DepartmentsEdit.this.onBack(false, DepartmentsEdit.this.iDepartment.getId());
            }
        });
        this.iForm.addHeaderRow((Widget)this.iHeader);
        this.iAcademicSession = new UniTimeWidget<Label>(new Label());
        this.iAcademicSession.getWidget().setStyleName("unitime-Label");
        this.iForm.addRow(MESSAGES.propAcademicSession(), (Widget)this.iAcademicSession);
        this.iDeptCode = new UniTimeWidget<TextBox>(new TextBox());
        this.iDeptCode.getWidget().setStyleName("unitime-TextBox");
        this.iDeptCode.getWidget().setMaxLength(50);
        this.iDeptCode.getWidget().setWidth("200px");
        this.iDeptCode.getWidget().addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                DepartmentsEdit.this.iDeptCode.clearHint();
                DepartmentsEdit.this.iHeader.clearMessage();
            }
        });
        this.iForm.addRow(MESSAGES.propDeptCode(), (Widget)this.iDeptCode);
        this.iAbbreviation = new UniTimeWidget<TextBox>(new TextBox());
        this.iAbbreviation.getWidget().setStyleName("unitime-TextBox");
        this.iAbbreviation.getWidget().setMaxLength(20);
        this.iAbbreviation.getWidget().setWidth("100px");
        this.iAbbreviation.getWidget().addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                DepartmentsEdit.this.iAbbreviation.clearHint();
                DepartmentsEdit.this.iHeader.clearMessage();
            }
        });
        this.iForm.addRow(MESSAGES.propAbbreviation(), (Widget)this.iAbbreviation);
        this.iName = new UniTimeWidget<TextBox>(new TextBox());
        this.iName.getWidget().setStyleName("unitime-TextBox");
        this.iName.getWidget().setMaxLength(100);
        this.iName.getWidget().setWidth("600px");
        this.iName.getWidget().addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                DepartmentsEdit.this.iName.clearHint();
                DepartmentsEdit.this.iHeader.clearMessage();
            }
        });
        this.iForm.addRow(MESSAGES.propName(), (Widget)this.iName);
        this.iStatusType = new UniTimeWidget<ListBox>(new ListBox());
        this.iStatusType.getWidget().setMultipleSelect(false);
        this.iStatusType.getWidget().setWidth("300px");
        this.iStatusType.getWidget().setStyleName("gwt-SuggestBox");
        this.iStatusType.getWidget().setVisibleItemCount(1);
        this.iForm.addRow(MESSAGES.propDepartmentStatus(), (Widget)this.iStatusType);
        this.iExternalId = new TextBox();
        this.iExternalId.setStyleName("unitime-TextBox");
        this.iExternalId.setMaxLength(40);
        this.iExternalId.setWidth("200px");
        this.iForm.addRow(MESSAGES.propExternalId(), (Widget)this.iExternalId);
        this.iExternalManager = new UniTimeWidget<CheckBox>(new CheckBox());
        this.iForm.addRow(MESSAGES.propExternalManager(), (Widget)this.iExternalManager);
        this.iExternalManager.getWidget().addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                if (((Boolean)event.getValue()).booleanValue()) {
                    ((TextBox)DepartmentsEdit.this.iExternalManagerAbbreviation.getWidget()).setEnabled(true);
                    ((TextBox)DepartmentsEdit.this.iExternalManagerName.getWidget()).setEnabled(true);
                    DepartmentsEdit.this.iForm.getRowFormatter().setVisible(DepartmentsEdit.this.iExtManagerAbbvLine, true);
                    DepartmentsEdit.this.iForm.getRowFormatter().setVisible(DepartmentsEdit.this.iExtManagerAbbvLine + 1, true);
                } else {
                    ((TextBox)DepartmentsEdit.this.iExternalManagerAbbreviation.getWidget()).setText("");
                    ((TextBox)DepartmentsEdit.this.iExternalManagerName.getWidget()).setText("");
                    ((TextBox)DepartmentsEdit.this.iExternalManagerAbbreviation.getWidget()).setEnabled(false);
                    ((TextBox)DepartmentsEdit.this.iExternalManagerName.getWidget()).setEnabled(false);
                    DepartmentsEdit.this.iForm.getRowFormatter().setVisible(DepartmentsEdit.this.iExtManagerAbbvLine, false);
                    DepartmentsEdit.this.iForm.getRowFormatter().setVisible(DepartmentsEdit.this.iExtManagerAbbvLine + 1, false);
                }
            }
        });
        this.iExternalManagerAbbreviation = new UniTimeWidget<TextBox>(new TextBox());
        this.iExternalManagerAbbreviation.getWidget().setStyleName("unitime-TextBox");
        this.iExternalManagerAbbreviation.getWidget().setMaxLength(10);
        this.iExternalManagerAbbreviation.getWidget().setWidth("100px");
        this.iExternalManagerAbbreviation.getWidget().addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                DepartmentsEdit.this.iExternalManagerAbbreviation.clearHint();
                DepartmentsEdit.this.iHeader.clearMessage();
            }
        });
        this.iExtManagerAbbvLine = this.iForm.addRow(MESSAGES.propExternalManagerAbbreviation(), (Widget)this.iExternalManagerAbbreviation);
        this.iExternalManagerName = new UniTimeWidget<TextBox>(new TextBox());
        this.iExternalManagerName.getWidget().setStyleName("unitime-TextBox");
        this.iExternalManagerName.getWidget().setMaxLength(30);
        this.iExternalManagerName.getWidget().setWidth("200px");
        this.iExternalManagerName.getWidget().addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                DepartmentsEdit.this.iExternalManagerName.clearHint();
                DepartmentsEdit.this.iHeader.clearMessage();
            }
        });
        this.iForm.addRow(MESSAGES.propExternalManagerName(), (Widget)this.iExternalManagerName);
        this.iDistPrefPriority = new UniTimeWidget<TextBox>(new TextBox());
        this.iDistPrefPriority.getWidget().setStyleName("unitime-TextBox");
        this.iDistPrefPriority.getWidget().setMaxLength(100);
        this.iDistPrefPriority.getWidget().setWidth("100px");
        this.iDistPrefPriority.getWidget().addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                DepartmentsEdit.this.iDistPrefPriority.clearHint();
                DepartmentsEdit.this.iHeader.clearMessage();
            }
        });
        this.iForm.addRow(MESSAGES.propPrefPriority(), (Widget)this.iDistPrefPriority);
        this.iAllowReqTime = new UniTimeWidget<CheckBox>(new CheckBox());
        this.iAllowReqTime.getWidget().setValue(Boolean.valueOf(false));
        this.iForm.addRow(MESSAGES.propAllowReqTime(), (Widget)this.iAllowReqTime);
        this.iAllowReqRoom = new UniTimeWidget<CheckBox>(new CheckBox());
        this.iAllowReqRoom.getWidget().setValue(Boolean.valueOf(false));
        this.iForm.addRow(MESSAGES.propAllowReqRoom(), (Widget)this.iAllowReqRoom);
        this.iAllowReqDist = new UniTimeWidget<CheckBox>(new CheckBox());
        this.iAllowReqDist.getWidget().setValue(Boolean.valueOf(false));
        this.iForm.addRow(MESSAGES.propAllowReqDist(), (Widget)this.iAllowReqDist);
        this.iInheritInstructorPreferences = new UniTimeWidget<CheckBox>(new CheckBox());
        this.iInheritInstructorPreferences.getWidget().setValue(Boolean.valueOf(false));
        this.iForm.addRow(MESSAGES.propInheritInstructorPref(), (Widget)this.iInheritInstructorPreferences);
        this.iAllowEvents = new UniTimeWidget<CheckBox>(new CheckBox());
        this.iAllowEvents.getWidget().setValue(Boolean.valueOf(false));
        this.iForm.addRow(MESSAGES.propAllowEvents(), (Widget)this.iAllowEvents);
        this.iAllowStudentScheduling = new UniTimeWidget<CheckBox>(new CheckBox());
        this.iAllowStudentScheduling.getWidget().setValue(Boolean.valueOf(false));
        this.iForm.addRow(MESSAGES.propAllowStudentScheduling(), (Widget)this.iAllowStudentScheduling);
        this.iExternalFundingDept = new UniTimeWidget<CheckBox>(new CheckBox());
        this.iExternalFundingDept.getWidget().setValue(Boolean.valueOf(false));
        this.iForm.addRow(MESSAGES.propExternalFundingDept(), (Widget)this.iExternalFundingDept);
        this.controlDeptHeaderPanel = new UniTimeHeaderPanel(MESSAGES.sectControllingDepartmentStatuses());
        this.controlDeptHeaderPanel.addButton("Add Status", MESSAGES.buttonDependentAddStatus(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                DepartmentsEdit.this.addNewRow(DepartmentsEdit.this.iDepartment);
            }
        });
        this.controlDeptHeaderPanel.addButton("Delete All", MESSAGES.buttonDependentDeleteAll(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                DepartmentsEdit.this.deleteAllDependentDepartments();
            }
        });
        this.iForm.addHeaderRow((Widget)this.controlDeptHeaderPanel);
        this.iControlDeptMainPanel = new VerticalPanel();
        this.iControlDeptFlexTable = new FlexTable();
        this.iControlDeptMainPanel.add((Widget)this.iControlDeptFlexTable);
        this.iForm.addRow((Widget)this.iControlDeptMainPanel);
        this.iControlDeptFlexTable.getElement().getStyle().setPaddingBottom(20.0, Style.Unit.PX);
        this.iFooter = this.iHeader.clonePanel();
        this.iForm.addBottomRow((Widget)this.iFooter);
        this.initWidget((Widget)this.iForm);
    }

    protected void onBack(boolean refresh, Long DepartmentId) {
    }

    protected boolean isAbbreviationUnique(DepartmentInterface Department2) {
        return true;
    }

    protected boolean isDeptCodeUnique(DepartmentInterface Department2) {
        return true;
    }

    public void setValue(DepartmentInterface department) {
        this.iDeptCode.clearHint();
        this.iAbbreviation.clearHint();
        this.iName.clearHint();
        this.iExternalManagerAbbreviation.clearHint();
        this.iExternalManagerName.clearHint();
        this.iDistPrefPriority.clearHint();
        this.iHeader.clearMessage();
        this.iDeptCode.getWidget().setText("");
        this.iAbbreviation.getWidget().setText("");
        this.iName.getWidget().setText("");
        this.iExternalId.setText("");
        this.iDistPrefPriority.getWidget().setText("");
        this.iExternalManagerAbbreviation.getWidget().setText("");
        this.iExternalManagerName.getWidget().setText("");
        this.iExternalManagerAbbreviation.getWidget().setEnabled(false);
        this.iExternalManagerName.getWidget().setEnabled(false);
        this.iForm.getRowFormatter().setVisible(this.iExtManagerAbbvLine, false);
        this.iForm.getRowFormatter().setVisible(this.iExtManagerAbbvLine + 1, false);
        this.iStatusType.getWidget().clear();
        this.iAbbreviation.clearHint();
        this.iHeader.clearMessage();
        this.iAllowReqTime.getWidget().setValue(Boolean.valueOf(false));
        this.iAllowReqRoom.getWidget().setValue(Boolean.valueOf(false));
        this.iAllowReqDist.getWidget().setValue(Boolean.valueOf(false));
        this.iInheritInstructorPreferences.getWidget().setValue(Boolean.valueOf(true));
        this.iAllowEvents.getWidget().setValue(Boolean.valueOf(false));
        this.iAllowStudentScheduling.getWidget().setValue(Boolean.valueOf(true));
        this.iExternalFundingDept.getWidget().setValue(Boolean.valueOf(false));
        this.iControlDeptFlexTable.removeAllRows();
        this.iControlDeptFlexTable.clear();
        this.iCurrentDependentDepartments.clear();
        this.iCurrentDependentStatuses.clear();
        this.iControlDeptFlexTable.setText(0, 0, MESSAGES.colControllingDepartment());
        FlexTable.FlexCellFormatter cellFormatter = this.iControlDeptFlexTable.getFlexCellFormatter();
        cellFormatter.setStyleName(0, 0, "department-StatusItalics");
        cellFormatter.setStyleName(0, 1, "department-StatusItalics");
        if (department == null) {
            this.controlDeptHeaderPanel.setVisible(false);
            this.iControlDeptMainPanel.setVisible(false);
            this.iExternalManager.getWidget().setEnabled(true);
            this.iExternalManager.getWidget().setValue(Boolean.valueOf(false));
            this.iHeader.setHeaderTitle(MESSAGES.sectAddDepartment());
            this.iHeader.setEnabled("save", true);
            this.iHeader.setEnabled("update", false);
            this.iHeader.setEnabled("delete", false);
            this.iHeader.setEnabled("back", true);
            this.iDepartment = new DepartmentInterface();
            this.iStatusType.getWidget().addItem(MESSAGES.propDepartmentStatusDefault(), "-1");
            for (DepartmentInterface.StatusOption option : this.iDepartmentProperties.getStatusOptions()) {
                this.iStatusType.getWidget().addItem(option.getLabel(), option.getReference());
            }
            this.iAcademicSession.getWidget().setText(this.iDepartmentProperties.getAcademicSessionName() == null ? "" : this.iDepartmentProperties.getAcademicSessionName());
            if (!this.iDepartmentProperties.isCoursesFundingDepartmentsEnabled()) {
                int rowNum = this.iForm.getRow(MESSAGES.propExternalFundingDept().replace("<br>", ""));
                this.iForm.getRowFormatter().setVisible(rowNum, false);
            }
        } else {
            this.iControlDeptFlexTable.setText(0, 1, MESSAGES.propStatusManagedBy((department.getDeptCode() == null ? "" : department.getDeptCode()) + " - " + (department.getName() == null ? "" : department.getName())));
            this.iHeader.setHeaderTitle(MESSAGES.sectEditDepartment());
            this.iHeader.setEnabled("save", false);
            this.iHeader.setEnabled("update", this.iDepartmentProperties.getCanEdit());
            this.iHeader.setEnabled("delete", this.iDepartmentProperties.getCanDelete());
            this.iHeader.setEnabled("back", true);
            this.iDeptCode.getWidget().setText(department.getDeptCode() == null ? "" : department.getDeptCode());
            this.iAbbreviation.getWidget().setText(department.getAbbreviation() == null ? "" : department.getAbbreviation());
            this.iName.getWidget().setText(department.getName() == null ? "" : department.getName());
            this.iExternalManager.getWidget().setEnabled(this.iDepartmentProperties.isCanChangeExtManager());
            this.iAcademicSession.getWidget().setText(department.getAcademicSessionName() == null ? "" : department.getAcademicSessionName());
            this.iExternalId.setText(department.getExternalId() == null ? "" : department.getExternalId());
            this.iDistPrefPriority.getWidget().setText(department.getDistributionPrefPriority() == null ? "0" : department.getDistributionPrefPriority().toString());
            this.iExternalManager.getWidget().setValue(department.getExternalManager());
            this.iExternalManagerAbbreviation.getWidget().setValue((Object)department.getExternalMgrAbbv());
            this.iExternalManagerName.getWidget().setValue((Object)department.getExternalMgrLabel());
            this.iExternalManagerAbbreviation.getWidget().setEnabled(department.getExternalManager().booleanValue());
            this.iExternalManagerName.getWidget().setEnabled(department.getExternalManager().booleanValue());
            this.iForm.getRowFormatter().setVisible(this.iExtManagerAbbvLine, department.getExternalManager().booleanValue());
            this.iForm.getRowFormatter().setVisible(this.iExtManagerAbbvLine + 1, department.getExternalManager().booleanValue());
            this.iStatusType.getWidget().clear();
            this.iStatusType.getWidget().addItem(MESSAGES.propDepartmentStatusDefault(), "-1");
            for (DepartmentInterface.StatusOption option : this.iDepartmentProperties.getStatusOptions()) {
                this.iStatusType.getWidget().addItem(option.getLabel(), option.getReference());
            }
            if (department.getStatusTypeCode() != null) {
                this.setSelectedValue(this.iStatusType.getWidget(), department.getStatusTypeCode());
            }
            this.iAllowReqTime.getWidget().setValue(department.getAllowReqTime());
            this.iAllowReqRoom.getWidget().setValue(department.getAllowReqRoom());
            this.iAllowReqDist.getWidget().setValue(department.getAllowReqDistribution());
            this.iInheritInstructorPreferences.getWidget().setValue(department.getInheritInstructorPreferences());
            this.iAllowEvents.getWidget().setValue(department.getAllowEvents());
            this.iAllowStudentScheduling.getWidget().setValue(department.getAllowStudentScheduling());
            if (!department.isExternalManager().booleanValue()) {
                this.controlDeptHeaderPanel.setVisible(false);
                this.iControlDeptMainPanel.setVisible(false);
            } else {
                this.controlDeptHeaderPanel.setVisible(true);
                this.iControlDeptMainPanel.setVisible(true);
            }
            this.iExternalFundingDept.getWidget().setValue(department.getExternalFundingDept());
            if (!this.iDepartmentProperties.isCoursesFundingDepartmentsEnabled()) {
                int rowNum = this.iForm.getRow(MESSAGES.propExternalFundingDept().replace("<br>", ""));
                this.iForm.getRowFormatter().setVisible(rowNum, false);
            }
            if (department.getExternalManager().booleanValue()) {
                for (String entry : department.getDependentDepartments()) {
                    this.iCurrentDependentDepartments.add(entry);
                }
                this.iCurrentDependentStatuses.clear();
                for (String entry : department.getDependentStatuses()) {
                    this.iCurrentDependentStatuses.add(entry);
                }
                if (!this.iCurrentDependentDepartments.isEmpty()) {
                    this.iCurrentDependentOptions = new ListBox[this.iCurrentDependentDepartments.size()];
                    this.iCurrentStatusTypeOptions = new ListBox[this.iCurrentDependentDepartments.size()];
                    for (int i = 0; i < this.iCurrentDependentDepartments.size(); ++i) {
                        this.iCurrentStatusTypeOptions[i] = this.statusOptions(department);
                        this.iCurrentDependentOptions[i] = this.departmentOptions(department);
                        this.setSelectedValue(this.iCurrentStatusTypeOptions[i], this.iCurrentDependentStatuses.get(i));
                        this.setSelectedValue(this.iCurrentDependentOptions[i], this.iCurrentDependentDepartments.get(i));
                        int numRows = this.iControlDeptFlexTable.getRowCount();
                        this.iControlDeptFlexTable.setWidget(numRows, 0, (Widget)this.iCurrentDependentOptions[i]);
                        this.iControlDeptFlexTable.setWidget(numRows, 1, (Widget)this.iCurrentStatusTypeOptions[i]);
                        Button deleteStatusButton = new Button(MESSAGES.buttonDeleteLine());
                        deleteStatusButton.addClickHandler(new ClickHandler(){

                            public void onClick(ClickEvent event) {
                                int receiverRowIndex = DepartmentsEdit.this.iControlDeptFlexTable.getCellForEvent(event).getRowIndex();
                                DepartmentsEdit.this.iControlDeptFlexTable.removeRow(receiverRowIndex);
                            }
                        });
                        this.iControlDeptFlexTable.setWidget(i + 1, 2, (Widget)deleteStatusButton);
                    }
                }
            }
            this.iDepartment = department;
            this.addNewRow(this.iDepartment);
            this.addNewRow(this.iDepartment);
        }
    }

    public DepartmentInterface getValue() {
        this.iDepartment.setName(this.iName.getWidget().getText());
        this.iDepartment.setDeptCode(this.iDeptCode.getWidget().getText());
        this.iDepartment.setAbbreviation(this.iAbbreviation.getWidget().getText());
        this.iDepartment.setExternalId(this.iExternalId.getValue());
        this.iDepartment.setExternalManager(this.iExternalManager.getWidget().getValue());
        this.iDepartment.setExternalMgrLabel(this.iExternalManagerName.getWidget().getValue());
        this.iDepartment.setExternalMgrAbbv(this.iExternalManagerAbbreviation.getWidget().getValue());
        this.iDepartment.setStatusTypeStr(this.iStatusType.getWidget().getSelectedValue());
        this.iDepartment.setAllowReqRoom(this.iAllowReqRoom.getWidget().getValue());
        this.iDepartment.setAllowReqDistribution((boolean)this.iAllowReqDist.getWidget().getValue());
        this.iDepartment.setAllowReqTime((boolean)this.iAllowReqTime.getWidget().getValue());
        this.iDepartment.setAllowReqRoom((boolean)this.iAllowReqRoom.getWidget().getValue());
        this.iDepartment.setExternalFundingDept((boolean)this.iExternalFundingDept.getWidget().getValue());
        this.iDepartment.setAllowEvents((boolean)this.iAllowEvents.getWidget().getValue());
        this.iDepartment.setInheritInstructorPreferences((boolean)this.iInheritInstructorPreferences.getWidget().getValue());
        this.iDepartment.setAllowEvents((boolean)this.iAllowEvents.getWidget().getValue());
        this.iDepartment.setAllowStudentScheduling((boolean)this.iAllowStudentScheduling.getWidget().getValue());
        try {
            this.iDepartment.setDistributionPrefPriority(Integer.valueOf(this.iDistPrefPriority.getWidget().getText()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        ArrayList<String> dependentDepartmentIds = new ArrayList<String>();
        ArrayList<String> dependentStatuses = new ArrayList<String>();
        int rows = this.iControlDeptFlexTable.getRowCount();
        for (int row = 1; row < rows; ++row) {
            ListBox dept = (ListBox)this.iControlDeptFlexTable.getWidget(row, 0);
            ListBox status = (ListBox)this.iControlDeptFlexTable.getWidget(row, 1);
            if (dept == null) continue;
            if (dept.getSelectedValue() != null && dept.getSelectedValue() != "") {
                dependentDepartmentIds.add(dept.getSelectedValue());
            }
            if (status.getSelectedValue() == null || status.getSelectedValue() == "") continue;
            dependentStatuses.add(status.getSelectedValue());
        }
        this.iDepartment.setDependentDepartments(dependentDepartmentIds);
        this.iDepartment.setDependentStatuses(dependentStatuses);
        return this.iDepartment;
    }

    protected boolean validate() {
        boolean ok = true;
        if (this.iAbbreviation.getWidget().getText().isEmpty()) {
            this.iAbbreviation.setErrorHint(MESSAGES.errorAbbreviationIsEmpty());
            if (ok) {
                this.iHeader.setErrorMessage(MESSAGES.errorAbbreviationIsEmpty());
            }
            ok = false;
        } else if (!this.isAbbreviationUnique(this.getValue())) {
            this.iAbbreviation.setErrorHint(MESSAGES.errorAbbreviationMustBeUnique());
            if (ok) {
                this.iHeader.setErrorMessage(MESSAGES.errorAbbreviationMustBeUnique());
            }
            ok = false;
        }
        if (this.iName.getWidget().getText().trim().isEmpty()) {
            this.iName.setErrorHint(MESSAGES.errorNameIsEmpty());
            if (ok) {
                this.iHeader.setErrorMessage(MESSAGES.errorNameIsEmpty());
            }
            ok = false;
        }
        if (this.iDeptCode.getWidget().getText().isEmpty()) {
            this.iDeptCode.setErrorHint(MESSAGES.errorDeptCodeIsEmpty());
            if (ok) {
                this.iHeader.setErrorMessage(MESSAGES.errorDeptCodeIsEmpty());
            }
            ok = false;
        } else if (!this.isDeptCodeUnique(this.getValue())) {
            this.iDeptCode.setErrorHint(MESSAGES.errorDeptCodeMustBeUnique());
            if (ok) {
                this.iHeader.setErrorMessage(MESSAGES.errorDeptCodeMustBeUnique());
            }
            ok = false;
        }
        if (this.iExternalManager.getWidget().getValue().booleanValue() && (this.iExternalManagerName.getWidget().getText().isEmpty() || this.iExternalManagerName.getWidget().getText().length() == 0)) {
            this.iExternalManagerName.setErrorHint(MESSAGES.errorRequired(MESSAGES.fieldExternalManagerName()));
            if (ok) {
                this.iHeader.setErrorMessage(MESSAGES.errorRequired(MESSAGES.fieldExternalManagerName()));
            }
            ok = false;
        }
        if (!(this.iExternalManager.getWidget().getValue().booleanValue() || this.iExternalManagerName.getWidget().getText().isEmpty() && this.iExternalManagerName.getWidget().getText().trim().length() <= 0)) {
            this.iExternalManagerName.setErrorHint(MESSAGES.errorGeneric(MESSAGES.errorExternalManagerNameUse()));
            if (ok) {
                this.iHeader.setErrorMessage(MESSAGES.errorGeneric(MESSAGES.errorExternalManagerNameUse()));
            }
            ok = false;
        }
        if (this.iExternalManager.getWidget().getValue().booleanValue() && (this.iExternalManagerAbbreviation.getWidget().getText().isEmpty() || this.iExternalManagerAbbreviation.getWidget().getText().length() == 0)) {
            this.iExternalManagerAbbreviation.setErrorHint(MESSAGES.errorRequired(MESSAGES.fieldExternalManagerAbbreviation()));
            if (ok) {
                this.iHeader.setErrorMessage(MESSAGES.errorRequired(MESSAGES.fieldExternalManagerAbbreviation()));
            }
            ok = false;
        }
        if (!(this.iExternalManager.getWidget().getValue().booleanValue() || this.iExternalManagerAbbreviation.getWidget().getText().isEmpty() && this.iExternalManagerAbbreviation.getWidget().getText().trim().length() <= 0)) {
            this.iExternalManagerAbbreviation.setErrorHint(MESSAGES.errorGeneric(MESSAGES.errorExternalManagerAbbreviationUse()));
            if (ok) {
                this.iHeader.setErrorMessage(MESSAGES.errorGeneric(MESSAGES.errorExternalManagerAbbreviationUse()));
            }
            ok = false;
        }
        return ok;
    }

    public DepartmentInterface getiDepartment() {
        return this.iDepartment;
    }

    public void setiDepartment(DepartmentInterface iDepartment) {
        this.iDepartment = iDepartment;
    }

    public void show() {
        Window.scrollTo((int)0, (int)0);
    }

    public ListBox statusOptions(DepartmentInterface department) {
        ListBox statusTypeOptions = new ListBox();
        statusTypeOptions.setMultipleSelect(false);
        statusTypeOptions.setWidth("300px");
        statusTypeOptions.setStyleName("gwt-SuggestBox");
        statusTypeOptions.setVisibleItemCount(1);
        statusTypeOptions.addItem(MESSAGES.propDefaultDependentStatus(), "");
        for (DepartmentInterface.StatusOption option : this.iDepartmentProperties.getStatusOptions()) {
            statusTypeOptions.addItem(option.getLabel(), option.getReference());
        }
        return statusTypeOptions;
    }

    private void setSelectedValue(ListBox lBox, String str) {
        String text = str;
        int indexToFind = -1;
        for (int i = 0; i < lBox.getItemCount(); ++i) {
            if (!lBox.getValue(i).equals(text)) continue;
            indexToFind = i;
            break;
        }
        lBox.setSelectedIndex(indexToFind);
    }

    public ListBox departmentOptions(DepartmentInterface department) {
        ListBox departmentOptions = new ListBox();
        departmentOptions.setMultipleSelect(false);
        departmentOptions.setWidth("300px");
        departmentOptions.setStyleName("unitime-TextBox");
        departmentOptions.setVisibleItemCount(1);
        departmentOptions.addItem(MESSAGES.propDefaultDependentDepartment(), "");
        for (DepartmentInterface.DepartmentOption dept : this.iDepartmentProperties.getExtDepartmentOptions()) {
            departmentOptions.addItem(dept.getLabel(), dept.getId().toString());
        }
        return departmentOptions;
    }

    public void addNewRow(DepartmentInterface department) {
        Button deleteStatusButton = new Button("Delete");
        int row = this.iControlDeptFlexTable.getRowCount();
        deleteStatusButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                int receiverRowIndex = DepartmentsEdit.this.iControlDeptFlexTable.getCellForEvent(event).getRowIndex();
                DepartmentsEdit.this.iControlDeptFlexTable.removeRow(receiverRowIndex);
            }
        });
        this.iControlDeptFlexTable.setWidget(row, 2, (Widget)deleteStatusButton);
        this.iControlDeptFlexTable.setWidget(row, 1, (Widget)this.statusOptions(department));
        this.iControlDeptFlexTable.setWidget(row, 0, (Widget)this.departmentOptions(department));
    }

    public void deleteAllDependentDepartments() {
        while (this.iControlDeptFlexTable.getRowCount() > 1) {
            this.iControlDeptFlexTable.removeRow(1);
        }
    }

    public void setProperties(DepartmentInterface.DepartmentPropertiesInterface departmentProperties) {
        this.iDepartmentProperties = departmentProperties;
    }

    public static class UpdateDepartmentRequest
    implements GwtRpcRequest<DepartmentInterface> {
        private DepartmentInterface.UpdateDepartmentAction iAction;
        private DepartmentInterface iDepartment;

        public DepartmentInterface.UpdateDepartmentAction getAction() {
            return this.iAction;
        }

        public void setAction(DepartmentInterface.UpdateDepartmentAction action) {
            this.iAction = action;
        }

        public DepartmentInterface getDepartment() {
            return this.iDepartment;
        }

        public void setDepartment(DepartmentInterface department) {
            this.iDepartment = department;
        }
    }
}

