/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.admin;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.TakesValue;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import org.unitime.timetable.gwt.client.admin.TaskExecutionsTable;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.ServerDateTimeFormat;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.TimeSelector;
import org.unitime.timetable.gwt.client.widgets.UniTimeConfirmationDialog;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.ScriptInterface;
import org.unitime.timetable.gwt.shared.TaskInterface;

public class TaskDetail
extends SimpleForm
implements TakesValue<TaskInterface> {
    protected static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private static final GwtConstants CONSTANTS = (GwtConstants)GWT.create(GwtConstants.class);
    private final GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private static DateTimeFormat sDateFormatMeeting = ServerDateTimeFormat.getFormat(CONSTANTS.meetingDateFormat());
    private UniTimeHeaderPanel iHeader = new UniTimeHeaderPanel();
    private UniTimeHeaderPanel iFooter;
    private UniTimeHeaderPanel iLogHeader;
    private TaskInterface iTask;
    private TaskExecutionsTable iExecutions;
    private int iLogRow;
    private HTML iLog;

    public TaskDetail() {
        this.iHeader.addButton("edit", MESSAGES.buttonEditTask(), 75, new ClickHandler(){

            public void onClick(ClickEvent event) {
                TaskDetail.this.doEdit();
            }
        });
        this.iHeader.addButton("delete", MESSAGES.buttonDeleteTask(), 75, new ClickHandler(){

            public void onClick(ClickEvent event) {
                UniTimeConfirmationDialog.confirm(MESSAGES.confirmDeleteTask(), new Command(){

                    public void execute() {
                        LoadingWidget.getInstance().show(MESSAGES.waitDelete(TaskDetail.this.getValue().getName()));
                        TaskDetail.this.RPC.execute(new TaskInterface.DeleteTaskDetailsRpcRequest(TaskDetail.this.getValue().getId()), new AsyncCallback<TaskInterface>(){

                            public void onFailure(Throwable caught) {
                                LoadingWidget.getInstance().hide();
                                TaskDetail.this.iHeader.setErrorMessage(MESSAGES.failedDelete(TaskDetail.this.getValue().getName(), caught.getMessage()));
                                UniTimeNotifications.error(MESSAGES.failedDelete(TaskDetail.this.getValue().getName(), caught.getMessage()), caught);
                            }

                            public void onSuccess(TaskInterface result) {
                                LoadingWidget.getInstance().hide();
                                TaskDetail.this.doBack();
                            }
                        });
                    }
                });
            }
        });
        this.iHeader.addButton("back", MESSAGES.buttonBack(), 75, new ClickHandler(){

            public void onClick(ClickEvent event) {
                TaskDetail.this.doBack();
            }
        });
        this.iFooter = this.iHeader.clonePanel();
        this.iExecutions = new TaskExecutionsTable();
        this.iExecutions.setAllowSelection(true);
        this.iExecutions.setAllowMultiSelect(false);
        this.iExecutions.addMouseClickListener(new UniTimeTable.MouseClickListener<TaskInterface.TaskExecutionInterface>(){

            @Override
            public void onMouseClick(UniTimeTable.TableEvent<TaskInterface.TaskExecutionInterface> event) {
                if (TaskDetail.this.iExecutions.getSelectedRow() > 0) {
                    final TaskInterface.TaskExecutionInterface execution = (TaskInterface.TaskExecutionInterface)TaskDetail.this.iExecutions.getData(TaskDetail.this.iExecutions.getSelectedRow());
                    TaskDetail.this.RPC.execute(new TaskInterface.GetTaskExecutionLogRpcRequest(execution.getId()), new AsyncCallback<TaskInterface.TaskExecutionLogInterface>(){

                        public void onFailure(Throwable caught) {
                            UniTimeNotifications.error(MESSAGES.failedLoadData(caught.getMessage()), caught);
                            TaskDetail.this.getRowFormatter().setVisible(TaskDetail.this.iLogRow, false);
                            TaskDetail.this.getRowFormatter().setVisible(TaskDetail.this.iLogRow + 1, false);
                        }

                        public void onSuccess(TaskInterface.TaskExecutionLogInterface result) {
                            if (result != null && result.hasLog()) {
                                TaskDetail.this.iLogHeader.setHeaderTitle(MESSAGES.sectScriptLog(sDateFormatMeeting.format(execution.getExecutionDate()) + " " + execution.getExecutionTime(CONSTANTS)));
                                TaskDetail.this.iLog.setHTML(result.getLog());
                                TaskDetail.this.getRowFormatter().setVisible(TaskDetail.this.iLogRow, true);
                                TaskDetail.this.getRowFormatter().setVisible(TaskDetail.this.iLogRow + 1, true);
                            } else {
                                TaskDetail.this.getRowFormatter().setVisible(TaskDetail.this.iLogRow, false);
                                TaskDetail.this.getRowFormatter().setVisible(TaskDetail.this.iLogRow + 1, false);
                            }
                        }
                    });
                } else {
                    TaskDetail.this.getRowFormatter().setVisible(TaskDetail.this.iLogRow, false);
                    TaskDetail.this.getRowFormatter().setVisible(TaskDetail.this.iLogRow + 1, false);
                }
            }
        });
        this.iLogHeader = new UniTimeHeaderPanel();
        this.iLog = new HTML();
    }

    protected void doBack() {
    }

    protected void doEdit() {
    }

    public void setValue(TaskInterface task) {
        this.iTask = task;
        this.clear();
        this.iHeader.setHeaderTitle(this.iTask.getName());
        this.iHeader.clearMessage();
        this.iHeader.setEnabled("edit", this.iTask.canEdit());
        this.iHeader.setEnabled("delete", this.iTask.canEdit());
        this.addHeaderRow((Widget)this.iHeader);
        this.addRow(MESSAGES.propScript(), (Widget)new Label(this.iTask.getScript().getName()));
        this.addRow(MESSAGES.propTaskOwner(), (Widget)new Label(this.iTask.getOwner().getFormattedName(false)));
        if (this.iTask.getScript().getDescription() != null && !this.iTask.getScript().getDescription().isEmpty()) {
            this.addRow(MESSAGES.propDescription(), (Widget)new HTML(this.iTask.getScript().getDescription()));
        }
        if (this.iTask.getScript().hasParameters()) {
            for (ScriptInterface.ScriptParameterInterface parameter : this.iTask.getScript().getParameters()) {
                String value = this.iTask.getParameter(parameter.getName());
                if (value == null) {
                    value = parameter.getValue();
                }
                if (value == null) {
                    value = parameter.getDefaultValue();
                }
                if (parameter.hasOptions() && value != null && !value.isEmpty()) {
                    if (parameter.isMultiSelect()) {
                        String ids = value;
                        value = "";
                        for (String id : ids.split(",")) {
                            value = value + (value.isEmpty() ? "" : "<br>") + parameter.getOption(id);
                        }
                    } else {
                        value = parameter.getOption(value);
                    }
                }
                if ("slot".equalsIgnoreCase(parameter.getType()) || "time".equalsIgnoreCase(parameter.getType()) && value != null && !value.isEmpty()) {
                    try {
                        value = TimeSelector.TimeUtils.slot2time(Integer.parseInt(value));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ("file".equalsIgnoreCase(parameter.getType()) && value != null) {
                    this.addRow(parameter.getLabel() + ":", (Widget)new Anchor(value, GWT.getHostPageBaseURL() + "taskfile?t=" + this.iTask.getId()));
                    continue;
                }
                this.addRow(parameter.getLabel() + ":", (Widget)new HTML(value == null ? "<i>" + MESSAGES.notSet() + "</i>" : value));
            }
        }
        if (this.iTask.getEmail() != null && !this.iTask.getEmail().isEmpty()) {
            this.addRow(MESSAGES.propEmail(), (Widget)new HTML(this.iTask.getEmail().replace("\n", "<br>")));
        }
        this.addHeaderRow(MESSAGES.sectTaskExecutions());
        this.iExecutions.setValue(this.iTask.getExecutions());
        this.addRow((Widget)this.iExecutions);
        this.iLogRow = this.addHeaderRow((Widget)this.iLogHeader);
        this.iLog.setHTML("");
        this.addRow((Widget)this.iLog);
        this.getRowFormatter().setVisible(this.iLogRow, false);
        this.getRowFormatter().setVisible(this.iLogRow + 1, false);
        this.addBottomRow((Widget)this.iFooter);
    }

    public TaskInterface getValue() {
        return this.iTask;
    }
}

