/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import org.unitime.localization.impl.Localization;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.form.UniTimeForm;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.dao.SubjectAreaDAO;

public class SubjectAreaEditForm
implements UniTimeForm {
    private static final long serialVersionUID = -8093172074512485680L;
    protected static final GwtMessages MSG = Localization.create(GwtMessages.class);
    private Long uniqueId;
    private String abbv;
    private String title;
    private String externalId;
    private Long department;

    public SubjectAreaEditForm() {
        this.reset();
    }

    @Override
    public void validate(UniTimeAction action) {
        if (UniTimeAction.stripAccessKey(MSG.buttonDelete()).equals(action.getOp())) {
            SubjectArea sa = (SubjectArea)new SubjectAreaDAO().get(this.getUniqueId());
            if (sa.hasOfferedCourses()) {
                action.addFieldError("form.uniqueId", MSG.errorCannotDeleteSubjectAreaWithClasses());
            }
        } else {
            if (this.abbv == null || this.abbv.trim().isEmpty()) {
                action.addFieldError("form.abbv", MSG.errorRequired(MSG.fieldAbbreviation()));
            }
            if (this.title == null || this.title.trim().isEmpty()) {
                action.addFieldError("form.title", MSG.errorRequired(MSG.fieldTitle()));
            }
            if (this.department == null || this.department <= 0L) {
                action.addFieldError("form.department", MSG.errorRequired(MSG.fieldDepartment()));
            }
            if (!action.hasFieldErrors()) {
                Long sessionId = action.getSessionContext().getUser().getCurrentAcademicSessionId();
                SubjectArea sa = SubjectArea.findByAbbv(sessionId, this.abbv);
                if (this.uniqueId == null && sa != null) {
                    action.addFieldError("form.abbv", MSG.errorMustBeUnique(MSG.fieldAbbreviation()));
                }
                if (this.uniqueId != null && sa != null && !sa.getUniqueId().equals(this.uniqueId)) {
                    action.addFieldError("form.abbv", MSG.errorMustBeUnique(MSG.fieldAbbreviation()));
                }
            }
        }
    }

    @Override
    public void reset() {
        this.uniqueId = null;
        this.abbv = null;
        this.title = null;
        this.externalId = null;
        this.department = null;
    }

    public String getAbbv() {
        return this.abbv;
    }

    public void setAbbv(String abbv) {
        this.abbv = abbv;
    }

    public Long getDepartment() {
        return this.department;
    }

    public void setDepartment(Long department) {
        this.department = department;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Long getUniqueId() {
        return this.uniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.uniqueId = uniqueId != null && uniqueId <= 0L ? null : uniqueId;
    }
}

