/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import java.util.ArrayList;
import java.util.Collection;
import org.hibernate.type.StringType;
import org.hibernate.type.Type;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.RollForwardSessionAction;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.form.UniTimeForm;
import org.unitime.timetable.model.Building;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.LearningManagementSystemInfo;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.PointInTimeData;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.TimePattern;
import org.unitime.timetable.model.dao.ClassInstructorDAO;
import org.unitime.timetable.model.dao.CourseOfferingDAO;
import org.unitime.timetable.model.dao.CourseRequestDAO;
import org.unitime.timetable.model.dao.CurriculumDAO;
import org.unitime.timetable.model.dao.DepartmentalInstructorDAO;
import org.unitime.timetable.model.dao.ExamDAO;
import org.unitime.timetable.model.dao.ExamPeriodDAO;
import org.unitime.timetable.model.dao.LastLikeCourseDemandDAO;
import org.unitime.timetable.model.dao.OfferingCoordinatorDAO;
import org.unitime.timetable.model.dao.RoomFeatureDAO;
import org.unitime.timetable.model.dao.RoomGroupDAO;
import org.unitime.timetable.model.dao.StudentClassEnrollmentDAO;
import org.unitime.timetable.model.dao.TeachingRequestDAO;
import org.unitime.timetable.model.dao.TimetableManagerDAO;
import org.unitime.timetable.util.SessionRollForward;

public class RollForwardSessionForm
implements UniTimeForm {
    private static final long serialVersionUID = 7553214589949959977L;
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    private Collection<SubjectArea> subjectAreas;
    private String[] subjectAreaIds;
    private String buttonAction;
    private Collection<Session> toSessions;
    private Collection<Session> fromSessions;
    private Collection<PointInTimeData> fromPointInTimeDataSnapshots;
    private Long sessionToRollForwardTo;
    private Boolean rollForwardDatePatterns;
    private Long sessionToRollDatePatternsForwardFrom;
    private Boolean rollForwardTimePatterns;
    private Long sessionToRollTimePatternsForwardFrom;
    private Boolean rollForwardDepartments;
    private Long sessionToRollDeptsFowardFrom;
    private Boolean rollForwardManagers;
    private Long sessionToRollManagersForwardFrom;
    private Boolean rollForwardRoomData;
    private Long sessionToRollRoomDataForwardFrom;
    private Collection<Department> departments;
    private String[] rollForwardDepartmentIds;
    private Boolean rollForwardSubjectAreas;
    private Long sessionToRollSubjectAreasForwardFrom;
    private Boolean rollForwardInstructorData;
    private Long sessionToRollInstructorDataForwardFrom;
    private Boolean rollForwardCourseOfferings;
    private Long sessionToRollCourseOfferingsForwardFrom;
    private String[] rollForwardSubjectAreaIds;
    private Boolean rollForwardClassInstructors;
    private String[] rollForwardClassInstrSubjectIds;
    private Boolean addNewCourseOfferings;
    private String[] addNewCourseOfferingsSubjectIds;
    private Boolean rollForwardExamConfiguration;
    private Long sessionToRollExamConfigurationForwardFrom;
    private Boolean rollForwardMidtermExams;
    private Boolean rollForwardFinalExams;
    private Boolean rollForwardStudents;
    private String rollForwardStudentsMode;
    private Long pointInTimeSnapshotToRollCourseEnrollmentsForwardFrom;
    private String subpartLocationPrefsAction;
    private String subpartTimePrefsAction;
    private String classPrefsAction;
    private String rollForwardDistributions;
    private String cancelledClassAction;
    private Boolean rollForwardCurricula;
    private Long sessionToRollCurriculaForwardFrom;
    private String midtermExamsPrefsAction;
    private String finalExamsPrefsAction;
    private Boolean rollForwardSessionConfig;
    private Long sessionToRollSessionConfigForwardFrom;
    private Boolean rollForwardLearningManagementSystems;
    private Long sessionToRollLearningManagementSystemsForwardFrom;
    private Boolean rollForwardWaitListsProhibitedOverrides;
    private Boolean rollForwardReservations;
    private Long sessionToRollReservationsForwardFrom;
    private String[] rollForwardReservationsSubjectIds;
    private Boolean rollForwardCourseReservations;
    private Boolean rollForwardCurriculumReservations;
    private Boolean rollForwardGroupReservations;
    private String expirationCourseReservations;
    private String expirationCurriculumReservations;
    private String expirationGroupReservations;
    private Boolean createStudentGroupsIfNeeded;
    private Boolean rollForwardOfferingCoordinators;
    private String[] rollForwardOfferingCoordinatorsSubjectIds;
    private Boolean rollForwardTeachingRequests;
    private String[] rollForwardTeachingRequestsSubjectIds;
    private Boolean rollForwardPeriodicTasks;
    private Long sessionToRollPeriodicTasksFrom;
    private String startDateCourseReservations;
    private String startDateCurriculumReservations;
    private String startDateGroupReservations;

    public RollForwardSessionForm() {
        this.reset();
    }

    @Override
    public void validate(UniTimeAction action) {
    }

    private void validateRollForwardSessionHasNoDataOfType(RollForwardSessionAction.RollForwardErrors action, Session sessionToRollForwardTo, String rollForwardType, Collection checkCollection) {
        if (checkCollection != null && !checkCollection.isEmpty()) {
            action.addFieldError("sessionHasData", MSG.errorRollForwardNoData(rollForwardType, sessionToRollForwardTo.getLabel()));
        }
    }

    protected void validateRollForward(RollForwardSessionAction.RollForwardErrors action, Session sessionToRollForwardTo, Long sessionIdToRollForwardFrom, String rollForwardType, Collection checkCollection) {
        this.validateRollForwardSessionHasNoDataOfType(action, sessionToRollForwardTo, rollForwardType, checkCollection);
        Session sessionToRollForwardFrom = Session.getSessionById(sessionIdToRollForwardFrom);
        if (sessionToRollForwardFrom == null) {
            action.addFieldError("mustSelectSession", MSG.errorRollForwardMissingFromSession(rollForwardType));
        }
        if (sessionToRollForwardFrom.equals(sessionToRollForwardTo)) {
            action.addFieldError("sessionsMustBeDifferent", MSG.errorRollForwardSessionsMustBeDifferent(rollForwardType, sessionToRollForwardTo.getLabel()));
        }
    }

    public void validateLearningManagementSystemRollForward(Session toAcadSession, RollForwardSessionAction.RollForwardErrors action) {
        if (this.getRollForwardLearningManagementSystems().booleanValue()) {
            this.validateRollForward(action, toAcadSession, this.getSessionToRollLearningManagementSystemsForwardFrom(), MSG.rollForwardLMSInfo(), LearningManagementSystemInfo.findAll(toAcadSession.getUniqueId()));
        }
    }

    public void validateDatePatternRollForward(Session toAcadSession, RollForwardSessionAction.RollForwardErrors action) {
        if (this.getRollForwardDatePatterns().booleanValue()) {
            this.validateRollForward(action, toAcadSession, this.getSessionToRollDatePatternsForwardFrom(), MSG.rollForwardDatePatterns(), DatePattern.findAll(toAcadSession, true, null, null));
        }
    }

    public void validateTimePatternRollForward(Session toAcadSession, RollForwardSessionAction.RollForwardErrors action) {
        if (this.getRollForwardTimePatterns().booleanValue()) {
            this.validateRollForward(action, toAcadSession, this.getSessionToRollTimePatternsForwardFrom(), MSG.rollForwardTimePatterns(), TimePattern.findAll(toAcadSession, null));
        }
    }

    public void validateDepartmentRollForward(Session toAcadSession, RollForwardSessionAction.RollForwardErrors action) {
        if (this.getRollForwardDepartments().booleanValue()) {
            this.validateRollForward(action, toAcadSession, this.getSessionToRollDeptsFowardFrom(), MSG.rollForwardDepartments(), Department.findAll(toAcadSession.getUniqueId()));
        }
    }

    public void validateManagerRollForward(Session toAcadSession, RollForwardSessionAction.RollForwardErrors action) {
        if (this.getRollForwardManagers().booleanValue()) {
            TimetableManagerDAO tmDao = new TimetableManagerDAO();
            this.validateRollForward(action, toAcadSession, this.getSessionToRollManagersForwardFrom(), MSG.rollForwardManagers(), tmDao.getQuery("from TimetableManager tm inner join tm.departments d where d.session.uniqueId =" + toAcadSession.getUniqueId().toString()).list());
        }
    }

    public void validateBuildingAndRoomRollForward(Session toAcadSession, RollForwardSessionAction.RollForwardErrors action) {
        if (this.getRollForwardRoomData().booleanValue()) {
            this.validateRollForward(action, toAcadSession, this.getSessionToRollRoomDataForwardFrom(), MSG.rollForwardBuildings(), new ArrayList());
            this.validateRollForwardSessionHasNoDataOfType(action, toAcadSession, MSG.rollForwardBuildings(), Building.findAll(toAcadSession.getUniqueId()));
            this.validateRollForwardSessionHasNoDataOfType(action, toAcadSession, MSG.rollForwardRooms(), Location.findAll(toAcadSession.getUniqueId()));
            RoomFeatureDAO rfDao = new RoomFeatureDAO();
            this.validateRollForwardSessionHasNoDataOfType(action, toAcadSession, MSG.rollForwardRoomsFeatures(), rfDao.getQuery("from RoomFeature rf where rf.department.session.uniqueId = " + toAcadSession.getUniqueId().toString()).list());
            RoomGroupDAO rgDao = new RoomGroupDAO();
            this.validateRollForwardSessionHasNoDataOfType(action, toAcadSession, MSG.rollForwardRoomsGroups(), rgDao.getQuery("from RoomGroup rg where rg.session.uniqueId = " + toAcadSession.getUniqueId().toString() + " and rg.global = false").list());
        }
    }

    public void validateSubjectAreaRollForward(Session toAcadSession, RollForwardSessionAction.RollForwardErrors action) {
        if (this.getRollForwardSubjectAreas().booleanValue()) {
            this.validateRollForward(action, toAcadSession, this.getSessionToRollSubjectAreasForwardFrom(), MSG.rollForwardSubjectAreas(), SubjectArea.getSubjectAreaList(toAcadSession.getUniqueId()));
        }
    }

    public void validateInstructorDataRollForward(Session toAcadSession, RollForwardSessionAction.RollForwardErrors action) {
        if (this.getRollForwardInstructorData().booleanValue()) {
            DepartmentalInstructorDAO diDao = new DepartmentalInstructorDAO();
            this.validateRollForward(action, toAcadSession, this.getSessionToRollInstructorDataForwardFrom(), MSG.rollForwardInstructors(), diDao.getQuery("from DepartmentalInstructor di where di.department.session.uniqueId = " + toAcadSession.getUniqueId().toString()).list());
        }
    }

    public void validateCourseOfferingRollForward(Session toAcadSession, RollForwardSessionAction.RollForwardErrors action) {
        if (this.getRollForwardCourseOfferings().booleanValue()) {
            if (this.getSubpartLocationPrefsAction() != null && !this.getSubpartLocationPrefsAction().equalsIgnoreCase(SessionRollForward.DO_NOT_ROLL_ACTION) && !this.getSubpartLocationPrefsAction().equalsIgnoreCase(SessionRollForward.ROLL_PREFS_ACTION)) {
                action.addFieldError("invalidSubpartLocationAction", MSG.errorRollForwardInvalidSubpartLocationAction(this.getSubpartLocationPrefsAction()));
            }
            if (this.getSubpartTimePrefsAction() != null && !this.getSubpartTimePrefsAction().equalsIgnoreCase(SessionRollForward.DO_NOT_ROLL_ACTION) && !this.getSubpartTimePrefsAction().equalsIgnoreCase(SessionRollForward.ROLL_PREFS_ACTION)) {
                action.addFieldError("invalidSubpartTimeAction", MSG.errorRollForwardInvalidSubpartTimeAction(this.getSubpartLocationPrefsAction()));
            }
            if (!(this.getClassPrefsAction() == null || this.getClassPrefsAction().equalsIgnoreCase(SessionRollForward.DO_NOT_ROLL_ACTION) || this.getClassPrefsAction().equalsIgnoreCase(SessionRollForward.PUSH_UP_ACTION) || this.getClassPrefsAction().equalsIgnoreCase(SessionRollForward.ROLL_PREFS_ACTION))) {
                action.addFieldError("invalidClassAction", MSG.errorRollForwardInvalidClassAction(this.getClassPrefsAction()));
            }
            if (!(this.getRollForwardDistributions() == null || this.getRollForwardDistributions().equalsIgnoreCase(SessionRollForward.DistributionMode.ALL.name()) || this.getRollForwardDistributions().equalsIgnoreCase(SessionRollForward.DistributionMode.MIXED.name()) || this.getRollForwardDistributions().equalsIgnoreCase(SessionRollForward.DistributionMode.SUBPART.name()) || this.getRollForwardDistributions().equalsIgnoreCase(SessionRollForward.DistributionMode.NONE.name()))) {
                action.addFieldError("invalidDistributionAction", MSG.errorRollForwardInvalidDistributionAction(this.getRollForwardDistributions()));
            }
            if (!(this.getCancelledClassAction() == null || this.getCancelledClassAction().equalsIgnoreCase(SessionRollForward.CancelledClassAction.KEEP.name()) || this.getCancelledClassAction().equalsIgnoreCase(SessionRollForward.CancelledClassAction.REOPEN.name()) || this.getCancelledClassAction().equalsIgnoreCase(SessionRollForward.CancelledClassAction.SKIP.name()))) {
                action.addFieldError("invalidCancelAction", MSG.errorRollForwardInvalidCancelAction(this.getCancelledClassAction()));
            }
            this.validateRollForward(action, toAcadSession, this.getSessionToRollCourseOfferingsForwardFrom(), MSG.rollForwardCourseOfferings(), new ArrayList());
            CourseOfferingDAO coDao = new CourseOfferingDAO();
            for (int i = 0; i < this.getRollForwardSubjectAreaIds().length; ++i) {
                String queryStr = "from CourseOffering co where co.subjectArea.session.uniqueId = " + toAcadSession.getUniqueId().toString() + " and co.isControl = true and co.subjectArea.uniqueId  = '" + this.getRollForwardSubjectAreaIds()[i] + "'";
                this.validateRollForwardSessionHasNoDataOfType(action, toAcadSession, MSG.rollForwardCourseOfferings() + ": " + this.getRollForwardSubjectAreaIds()[i], coDao.getQuery(queryStr).list());
            }
        }
    }

    public void validateClassInstructorRollForward(Session toAcadSession, RollForwardSessionAction.RollForwardErrors action) {
        if (this.getRollForwardClassInstructors().booleanValue()) {
            this.validateRollForward(action, toAcadSession, this.getSessionToRollCourseOfferingsForwardFrom(), MSG.rollForwardClassInstructors(), new ArrayList());
            ClassInstructorDAO ciDao = new ClassInstructorDAO();
            for (int i = 0; i < this.getRollForwardClassInstrSubjectIds().length; ++i) {
                String queryStr = "from ClassInstructor c  inner join c.classInstructing.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings as co where c.classInstructing.schedulingSubpart.instrOfferingConfig.instructionalOffering.session.uniqueId = " + toAcadSession.getUniqueId().toString() + " and co.isControl = true and co.subjectArea.uniqueId  = '" + this.getRollForwardClassInstrSubjectIds()[i] + "'";
                this.validateRollForwardSessionHasNoDataOfType(action, toAcadSession, MSG.rollForwardClassInstructors() + ": " + this.getRollForwardClassInstrSubjectIds()[i], ciDao.getQuery(queryStr).list());
            }
        }
    }

    public void validateOfferingCoordinatorsRollForward(Session toAcadSession, RollForwardSessionAction.RollForwardErrors action) {
        if (this.getRollForwardOfferingCoordinators().booleanValue()) {
            this.validateRollForward(action, toAcadSession, this.getSessionToRollCourseOfferingsForwardFrom(), MSG.rollForwardOfferingCoordinators(), new ArrayList());
            OfferingCoordinatorDAO ocDao = OfferingCoordinatorDAO.getInstance();
            for (int i = 0; i < this.getRollForwardOfferingCoordinatorsSubjectIds().length; ++i) {
                String queryStr = "from OfferingCoordinator c inner join c.offering.courseOfferings as co where c.offering.session.uniqueId = " + toAcadSession.getUniqueId().toString() + " and co.isControl = true and co.subjectArea.uniqueId  = '" + this.getRollForwardOfferingCoordinatorsSubjectIds()[i] + "'";
                this.validateRollForwardSessionHasNoDataOfType(action, toAcadSession, MSG.rollForwardOfferingCoordinators() + ": " + this.getRollForwardOfferingCoordinatorsSubjectIds()[i], ocDao.getQuery(queryStr).list());
            }
        }
    }

    public void validateExamConfigurationRollForward(Session toAcadSession, RollForwardSessionAction.RollForwardErrors action) {
        if (this.getRollForwardExamConfiguration().booleanValue()) {
            ExamPeriodDAO epDao = new ExamPeriodDAO();
            this.validateRollForward(action, toAcadSession, this.getSessionToRollExamConfigurationForwardFrom(), MSG.rollForwardExamConfiguration(), epDao.getQuery("from ExamPeriod ep where ep.session.uniqueId = " + toAcadSession.getUniqueId().toString()).list());
        }
    }

    public void validateMidtermExamRollForward(Session toAcadSession, RollForwardSessionAction.RollForwardErrors action) {
        if (this.getRollForwardMidtermExams().booleanValue()) {
            ExamDAO eDao = new ExamDAO();
            this.validateRollForwardSessionHasNoDataOfType(action, toAcadSession, MSG.rollForwardMidtermExams(), eDao.getQuery("from Exam e where e.session.uniqueId = " + toAcadSession.getUniqueId().toString() + " and e.examType.type = " + 1).list());
        }
    }

    public void validateFinalExamRollForward(Session toAcadSession, RollForwardSessionAction.RollForwardErrors action) {
        if (this.getRollForwardFinalExams().booleanValue()) {
            ExamDAO epDao = new ExamDAO();
            this.validateRollForwardSessionHasNoDataOfType(action, toAcadSession, MSG.rollForwardFinalExams(), epDao.getQuery("from Exam e where e.session.uniqueId = " + toAcadSession.getUniqueId().toString() + " and e.examType.type = " + 0).list());
        }
    }

    public void validateLastLikeDemandRollForward(Session toAcadSession, RollForwardSessionAction.RollForwardErrors action) {
        if (this.getRollForwardStudents().booleanValue()) {
            if (this.getRollForwardStudentsMode().equals(SessionRollForward.StudentEnrollmentMode.LAST_LIKE.name())) {
                this.validateRollForwardSessionHasNoDataOfType(action, toAcadSession, MSG.rollForwardLastLikeStudentCourseRequests(), LastLikeCourseDemandDAO.getInstance().getQuery("from LastLikeCourseDemand d where d.subjectArea.session.uniqueId = " + toAcadSession.getUniqueId().toString()).list());
            } else if (this.getRollForwardStudentsMode().equals(SessionRollForward.StudentEnrollmentMode.STUDENT_CLASS_ENROLLMENTS.name())) {
                this.validateRollForwardSessionHasNoDataOfType(action, toAcadSession, MSG.rollForwardStudentClassEnrollments(), StudentClassEnrollmentDAO.getInstance().getQuery("from StudentClassEnrollment d where d.courseOffering.subjectArea.session.uniqueId = " + toAcadSession.getUniqueId().toString()).list());
            } else if (this.getRollForwardStudentsMode().equals(SessionRollForward.StudentEnrollmentMode.STUDENT_COURSE_REQUESTS.name())) {
                this.validateRollForwardSessionHasNoDataOfType(action, toAcadSession, MSG.rollForwardCourseRequests(), CourseRequestDAO.getInstance().getQuery("from CourseRequest r where r.courseOffering.subjectArea.session.uniqueId = " + toAcadSession.getUniqueId().toString()).list());
            } else if (this.getRollForwardStudentsMode().equals(SessionRollForward.StudentEnrollmentMode.POINT_IN_TIME_CLASS_ENROLLMENTS.name())) {
                this.validateRollForwardSessionHasNoDataOfType(action, toAcadSession, MSG.rollForwardPITStudentClassEnrollments(), StudentClassEnrollmentDAO.getInstance().getQuery("from PitStudentClassEnrollment d where d.pitCourseOffering.subjectArea.session.uniqueId = " + toAcadSession.getUniqueId().toString()).list());
            } else {
                action.addFieldError("invalidCancelAction", MSG.errorRollForwardInvalidCourseDemandAction(this.getRollForwardStudentsMode()));
            }
        }
    }

    public void validateCurriculaRollForward(Session toAcadSession, RollForwardSessionAction.RollForwardErrors action) {
        if (this.getRollForwardCurricula().booleanValue()) {
            CurriculumDAO curDao = new CurriculumDAO();
            this.validateRollForward(action, toAcadSession, this.getSessionToRollCurriculaForwardFrom(), MSG.rollForwardCurricula(), curDao.getQuery("from Curriculum c where c.department.session.uniqueId = " + toAcadSession.getUniqueId().toString()).list());
        }
    }

    public void validatePeriodicTasksForward(Session toAcadSession, RollForwardSessionAction.RollForwardErrors action) {
        if (this.getRollForwardPeriodicTasks().booleanValue()) {
            this.validateRollForward(action, toAcadSession, this.getSessionToRollCurriculaForwardFrom(), MSG.rollForwardScheduledTasks(), null);
        }
    }

    public void validateSessionToRollForwardTo(RollForwardSessionAction.RollForwardErrors action) {
        Session toAcadSession = Session.getSessionById(this.getSessionToRollForwardTo());
        if (toAcadSession == null) {
            action.addFieldError("mustSelectSession", MSG.errorRollForwardMissingToSession());
            return;
        }
        this.validateDepartmentRollForward(toAcadSession, action);
        this.validateManagerRollForward(toAcadSession, action);
        this.validateBuildingAndRoomRollForward(toAcadSession, action);
        this.validateDatePatternRollForward(toAcadSession, action);
        this.validateTimePatternRollForward(toAcadSession, action);
        this.validateLearningManagementSystemRollForward(toAcadSession, action);
        this.validateSubjectAreaRollForward(toAcadSession, action);
        this.validateCourseOfferingRollForward(toAcadSession, action);
        this.validateTeachingRequestsRollForward(toAcadSession, action);
        this.validateClassInstructorRollForward(toAcadSession, action);
        this.validateOfferingCoordinatorsRollForward(toAcadSession, action);
        this.validateExamConfigurationRollForward(toAcadSession, action);
        this.validateMidtermExamRollForward(toAcadSession, action);
        this.validateFinalExamRollForward(toAcadSession, action);
        this.validateLastLikeDemandRollForward(toAcadSession, action);
        this.validateCurriculaRollForward(toAcadSession, action);
        this.validatePeriodicTasksForward(toAcadSession, action);
    }

    @Override
    public void reset() {
        this.subjectAreas = new ArrayList<SubjectArea>();
        this.subjectAreaIds = new String[0];
        this.fromSessions = null;
        this.toSessions = null;
        this.sessionToRollForwardTo = null;
        this.rollForwardDatePatterns = false;
        this.sessionToRollDatePatternsForwardFrom = null;
        this.rollForwardTimePatterns = false;
        this.sessionToRollTimePatternsForwardFrom = null;
        this.rollForwardDepartments = false;
        this.sessionToRollDeptsFowardFrom = null;
        this.rollForwardManagers = false;
        this.sessionToRollManagersForwardFrom = null;
        this.rollForwardRoomData = false;
        this.sessionToRollRoomDataForwardFrom = null;
        this.setDepartments(new ArrayList<Department>());
        this.setRollForwardDepartmentIds(new String[0]);
        this.rollForwardSubjectAreas = false;
        this.sessionToRollSubjectAreasForwardFrom = null;
        this.rollForwardInstructorData = false;
        this.sessionToRollInstructorDataForwardFrom = null;
        this.rollForwardCourseOfferings = false;
        this.sessionToRollCourseOfferingsForwardFrom = null;
        this.rollForwardSubjectAreaIds = new String[0];
        this.rollForwardClassInstructors = false;
        this.rollForwardClassInstrSubjectIds = new String[0];
        this.addNewCourseOfferings = false;
        this.addNewCourseOfferingsSubjectIds = new String[0];
        this.rollForwardExamConfiguration = false;
        this.sessionToRollExamConfigurationForwardFrom = null;
        this.rollForwardMidtermExams = false;
        this.rollForwardFinalExams = false;
        this.rollForwardStudents = false;
        this.rollForwardStudentsMode = null;
        this.pointInTimeSnapshotToRollCourseEnrollmentsForwardFrom = null;
        this.setFromPointInTimeDataSnapshots(new ArrayList<PointInTimeData>());
        this.subpartLocationPrefsAction = null;
        this.subpartTimePrefsAction = null;
        this.classPrefsAction = null;
        this.rollForwardDistributions = null;
        this.cancelledClassAction = null;
        this.rollForwardCurricula = false;
        this.sessionToRollCurriculaForwardFrom = null;
        this.finalExamsPrefsAction = null;
        this.midtermExamsPrefsAction = null;
        this.rollForwardSessionConfig = false;
        this.sessionToRollSessionConfigForwardFrom = null;
        this.rollForwardReservations = false;
        this.sessionToRollReservationsForwardFrom = null;
        this.rollForwardReservationsSubjectIds = new String[0];
        this.rollForwardCurriculumReservations = false;
        this.rollForwardCourseReservations = false;
        this.rollForwardGroupReservations = false;
        this.expirationCourseReservations = null;
        this.expirationCurriculumReservations = null;
        this.expirationGroupReservations = null;
        this.createStudentGroupsIfNeeded = false;
        this.rollForwardTeachingRequests = false;
        this.rollForwardTeachingRequestsSubjectIds = new String[0];
        this.rollForwardOfferingCoordinators = false;
        this.rollForwardOfferingCoordinatorsSubjectIds = new String[0];
        this.rollForwardPeriodicTasks = false;
        this.sessionToRollPeriodicTasksFrom = null;
        this.startDateCourseReservations = null;
        this.startDateCurriculumReservations = null;
        this.startDateGroupReservations = null;
        this.rollForwardLearningManagementSystems = false;
        this.sessionToRollLearningManagementSystemsForwardFrom = null;
        this.rollForwardWaitListsProhibitedOverrides = false;
    }

    public String getButtonAction() {
        return this.buttonAction;
    }

    public void setButtonAction(String buttonAction) {
        this.buttonAction = buttonAction;
    }

    public String[] getSubjectAreaIds() {
        return this.subjectAreaIds;
    }

    public void setSubjectAreaIds(String[] subjectAreaIds) {
        this.subjectAreaIds = subjectAreaIds;
    }

    public Collection<SubjectArea> getSubjectAreas() {
        return this.subjectAreas;
    }

    public void setSubjectAreas(Collection<SubjectArea> subjectAreas) {
        this.subjectAreas = subjectAreas;
    }

    public Boolean getRollForwardCourseOfferings() {
        return this.rollForwardCourseOfferings;
    }

    public void setRollForwardCourseOfferings(Boolean rollForwardCourseOfferings) {
        this.rollForwardCourseOfferings = rollForwardCourseOfferings;
    }

    public Boolean getRollForwardDatePatterns() {
        return this.rollForwardDatePatterns;
    }

    public void setRollForwardDatePatterns(Boolean rollForwardDatePatterns) {
        this.rollForwardDatePatterns = rollForwardDatePatterns;
    }

    public Boolean getRollForwardDepartments() {
        return this.rollForwardDepartments;
    }

    public void setRollForwardDepartments(Boolean rollForwardDepartments) {
        this.rollForwardDepartments = rollForwardDepartments;
    }

    public Boolean getRollForwardInstructorData() {
        return this.rollForwardInstructorData;
    }

    public void setRollForwardInstructorData(Boolean rollForwardInstructorData) {
        this.rollForwardInstructorData = rollForwardInstructorData;
    }

    public Boolean getRollForwardManagers() {
        return this.rollForwardManagers;
    }

    public void setRollForwardManagers(Boolean rollForwardManagers) {
        this.rollForwardManagers = rollForwardManagers;
    }

    public Boolean getRollForwardRoomData() {
        return this.rollForwardRoomData;
    }

    public void setRollForwardRoomData(Boolean rollForwardRoomData) {
        this.rollForwardRoomData = rollForwardRoomData;
    }

    public String[] getRollForwardSubjectAreaIds() {
        return this.rollForwardSubjectAreaIds;
    }

    public void setRollForwardSubjectAreaIds(String[] rollForwardSubjectAreaIds) {
        this.rollForwardSubjectAreaIds = rollForwardSubjectAreaIds;
    }

    public Boolean getRollForwardSubjectAreas() {
        return this.rollForwardSubjectAreas;
    }

    public void setRollForwardSubjectAreas(Boolean rollForwardSubjectAreas) {
        this.rollForwardSubjectAreas = rollForwardSubjectAreas;
    }

    public Long getSessionToRollCourseOfferingsForwardFrom() {
        return this.sessionToRollCourseOfferingsForwardFrom;
    }

    public void setSessionToRollCourseOfferingsForwardFrom(Long sessionToRollCourseOfferingsForwardFrom) {
        this.sessionToRollCourseOfferingsForwardFrom = sessionToRollCourseOfferingsForwardFrom;
    }

    public Long getSessionToRollDatePatternsForwardFrom() {
        return this.sessionToRollDatePatternsForwardFrom;
    }

    public void setSessionToRollDatePatternsForwardFrom(Long sessionToRollDatePatternsForwardFrom) {
        this.sessionToRollDatePatternsForwardFrom = sessionToRollDatePatternsForwardFrom;
    }

    public Long getSessionToRollDeptsFowardFrom() {
        return this.sessionToRollDeptsFowardFrom;
    }

    public void setSessionToRollDeptsFowardFrom(Long sessionToRollDeptsFowardFrom) {
        this.sessionToRollDeptsFowardFrom = sessionToRollDeptsFowardFrom;
    }

    public Long getSessionToRollForwardTo() {
        return this.sessionToRollForwardTo;
    }

    public void setSessionToRollForwardTo(Long sessionToRollForwardTo) {
        this.sessionToRollForwardTo = sessionToRollForwardTo;
    }

    public Long getSessionToRollInstructorDataForwardFrom() {
        return this.sessionToRollInstructorDataForwardFrom;
    }

    public void setSessionToRollInstructorDataForwardFrom(Long sessionToRollInstructorDataForwardFrom) {
        this.sessionToRollInstructorDataForwardFrom = sessionToRollInstructorDataForwardFrom;
    }

    public Long getSessionToRollManagersForwardFrom() {
        return this.sessionToRollManagersForwardFrom;
    }

    public void setSessionToRollManagersForwardFrom(Long sessionToRollManagersForwardFrom) {
        this.sessionToRollManagersForwardFrom = sessionToRollManagersForwardFrom;
    }

    public Long getSessionToRollRoomDataForwardFrom() {
        return this.sessionToRollRoomDataForwardFrom;
    }

    public void setSessionToRollRoomDataForwardFrom(Long sessionToRollRoomDataForwardFrom) {
        this.sessionToRollRoomDataForwardFrom = sessionToRollRoomDataForwardFrom;
    }

    public Collection<Department> getDepartments() {
        return this.departments;
    }

    public void setFromPointInTimeDataSnapshots(Collection<PointInTimeData> fromPointInTimeDataSnapshots) {
        this.fromPointInTimeDataSnapshots = fromPointInTimeDataSnapshots;
    }

    public Collection<PointInTimeData> getFromPointInTimeDataSnapshots() {
        return this.fromPointInTimeDataSnapshots;
    }

    public void setDepartments(Collection<Department> departments) {
        this.departments = departments;
    }

    public String[] getRollForwardDepartmentIds() {
        return this.rollForwardDepartmentIds;
    }

    public void setRollForwardDepartmentIds(String[] rollForwardDepartmentIds) {
        this.rollForwardDepartmentIds = rollForwardDepartmentIds;
    }

    public Long getSessionToRollSubjectAreasForwardFrom() {
        return this.sessionToRollSubjectAreasForwardFrom;
    }

    public void setSessionToRollSubjectAreasForwardFrom(Long sessionToRollSubjectAreasForwardFrom) {
        this.sessionToRollSubjectAreasForwardFrom = sessionToRollSubjectAreasForwardFrom;
    }

    public Collection<Session> getFromSessions() {
        return this.fromSessions;
    }

    public void setFromSessions(Collection<Session> fromSessions) {
        this.fromSessions = fromSessions;
    }

    public Boolean getRollForwardTimePatterns() {
        return this.rollForwardTimePatterns;
    }

    public void setRollForwardTimePatterns(Boolean rollForwardTimePatterns) {
        this.rollForwardTimePatterns = rollForwardTimePatterns;
    }

    public Long getSessionToRollTimePatternsForwardFrom() {
        return this.sessionToRollTimePatternsForwardFrom;
    }

    public void setSessionToRollTimePatternsForwardFrom(Long sessionToRollTimePatternsForwardFrom) {
        this.sessionToRollTimePatternsForwardFrom = sessionToRollTimePatternsForwardFrom;
    }

    public Boolean getRollForwardClassInstructors() {
        return this.rollForwardClassInstructors;
    }

    public void setRollForwardClassInstructors(Boolean rollForwardClassInstructors) {
        this.rollForwardClassInstructors = rollForwardClassInstructors;
    }

    public String[] getRollForwardClassInstrSubjectIds() {
        return this.rollForwardClassInstrSubjectIds;
    }

    public void setRollForwardClassInstrSubjectIds(String[] rollForwardClassInstrSubjectIds) {
        this.rollForwardClassInstrSubjectIds = rollForwardClassInstrSubjectIds;
    }

    public Boolean getRollForwardOfferingCoordinators() {
        return this.rollForwardOfferingCoordinators;
    }

    public void setRollForwardOfferingCoordinators(Boolean rollForwardOfferingCoordinators) {
        this.rollForwardOfferingCoordinators = rollForwardOfferingCoordinators;
    }

    public String[] getRollForwardOfferingCoordinatorsSubjectIds() {
        return this.rollForwardOfferingCoordinatorsSubjectIds;
    }

    public void setRollForwardOfferingCoordinatorsSubjectIds(String[] rollForwardOfferingCoordinatorsSubjectIds) {
        this.rollForwardOfferingCoordinatorsSubjectIds = rollForwardOfferingCoordinatorsSubjectIds;
    }

    public Collection<Session> getToSessions() {
        return this.toSessions;
    }

    public void setToSessions(Collection<Session> toSessions) {
        this.toSessions = toSessions;
    }

    public Boolean getAddNewCourseOfferings() {
        return this.addNewCourseOfferings;
    }

    public void setAddNewCourseOfferings(Boolean addNewCourseOfferings) {
        this.addNewCourseOfferings = addNewCourseOfferings;
    }

    public String[] getAddNewCourseOfferingsSubjectIds() {
        return this.addNewCourseOfferingsSubjectIds;
    }

    public void setAddNewCourseOfferingsSubjectIds(String[] addNewCourseOfferingsSubjectIds) {
        this.addNewCourseOfferingsSubjectIds = addNewCourseOfferingsSubjectIds;
    }

    public Boolean getRollForwardExamConfiguration() {
        return this.rollForwardExamConfiguration;
    }

    public void setRollForwardExamConfiguration(Boolean rollForwardExamConfiguration) {
        this.rollForwardExamConfiguration = rollForwardExamConfiguration;
    }

    public Boolean getRollForwardMidtermExams() {
        return this.rollForwardMidtermExams;
    }

    public void setRollForwardMidtermExams(Boolean rollForwardMidtermExams) {
        this.rollForwardMidtermExams = rollForwardMidtermExams;
    }

    public Boolean getRollForwardFinalExams() {
        return this.rollForwardFinalExams;
    }

    public void setRollForwardFinalExams(Boolean rollForwardFinalExams) {
        this.rollForwardFinalExams = rollForwardFinalExams;
    }

    public Long getSessionToRollExamConfigurationForwardFrom() {
        return this.sessionToRollExamConfigurationForwardFrom;
    }

    public void setSessionToRollExamConfigurationForwardFrom(Long sessionToRollExamConfigurationForwardFrom) {
        this.sessionToRollExamConfigurationForwardFrom = sessionToRollExamConfigurationForwardFrom;
    }

    public Boolean getRollForwardStudents() {
        return this.rollForwardStudents;
    }

    public void setRollForwardStudents(Boolean rollForwardStudents) {
        this.rollForwardStudents = rollForwardStudents;
    }

    public String getRollForwardStudentsMode() {
        return this.rollForwardStudentsMode;
    }

    public void setRollForwardStudentsMode(String rollForwardStudentsMode) {
        this.rollForwardStudentsMode = rollForwardStudentsMode;
    }

    public Long getPointInTimeSnapshotToRollCourseEnrollmentsForwardFrom() {
        return this.pointInTimeSnapshotToRollCourseEnrollmentsForwardFrom;
    }

    public void setPointInTimeSnapshotToRollCourseEnrollmentsForwardFrom(Long pointInTimeSnapshotToRollCourseEnrollmentsForwardFrom) {
        this.pointInTimeSnapshotToRollCourseEnrollmentsForwardFrom = pointInTimeSnapshotToRollCourseEnrollmentsForwardFrom;
    }

    public Boolean getRollForwardCurricula() {
        return this.rollForwardCurricula;
    }

    public void setRollForwardCurricula(Boolean rollForwardCurricula) {
        this.rollForwardCurricula = rollForwardCurricula;
    }

    public Long getSessionToRollCurriculaForwardFrom() {
        return this.sessionToRollCurriculaForwardFrom;
    }

    public void setSessionToRollCurriculaForwardFrom(Long sessionToRollCurriculaForwardFrom) {
        this.sessionToRollCurriculaForwardFrom = sessionToRollCurriculaForwardFrom;
    }

    public Boolean getRollForwardSessionConfig() {
        return this.rollForwardSessionConfig;
    }

    public void setRollForwardSessionConfig(Boolean rollForwardSessionConfig) {
        this.rollForwardSessionConfig = rollForwardSessionConfig;
    }

    public Long getSessionToRollSessionConfigForwardFrom() {
        return this.sessionToRollSessionConfigForwardFrom;
    }

    public void setSessionToRollSessionConfigForwardFrom(Long sessionToRollSessionConfigForwardFrom) {
        this.sessionToRollSessionConfigForwardFrom = sessionToRollSessionConfigForwardFrom;
    }

    public String getSubpartLocationPrefsAction() {
        return this.subpartLocationPrefsAction;
    }

    public void setSubpartLocationPrefsAction(String subpartLocationPrefsAction) {
        this.subpartLocationPrefsAction = subpartLocationPrefsAction;
    }

    public String getSubpartTimePrefsAction() {
        return this.subpartTimePrefsAction;
    }

    public void setSubpartTimePrefsAction(String subpartTimePrefsAction) {
        this.subpartTimePrefsAction = subpartTimePrefsAction;
    }

    public String getClassPrefsAction() {
        return this.classPrefsAction;
    }

    public void setClassPrefsAction(String classPrefsAction) {
        this.classPrefsAction = classPrefsAction;
    }

    public String getRollForwardDistributions() {
        return this.rollForwardDistributions;
    }

    public void setRollForwardDistributions(String rollForwardDistributions) {
        this.rollForwardDistributions = rollForwardDistributions;
    }

    public String getCancelledClassAction() {
        return this.cancelledClassAction;
    }

    public void setCancelledClassAction(String cancelledClassAction) {
        this.cancelledClassAction = cancelledClassAction;
    }

    public String getMidtermExamsPrefsAction() {
        return this.midtermExamsPrefsAction;
    }

    public void setMidtermExamsPrefsAction(String midtermExamsPrefsAction) {
        this.midtermExamsPrefsAction = midtermExamsPrefsAction;
    }

    public String getFinalExamsPrefsAction() {
        return this.finalExamsPrefsAction;
    }

    public void setFinalExamsPrefsAction(String finalExamsPrefsAction) {
        this.finalExamsPrefsAction = finalExamsPrefsAction;
    }

    public boolean getRollForwardReservations() {
        return this.rollForwardReservations;
    }

    public void setRollForwardReservations(boolean rollForwardReservations) {
        this.rollForwardReservations = rollForwardReservations;
    }

    public Long getSessionToRollReservationsForwardFrom() {
        return this.sessionToRollReservationsForwardFrom;
    }

    public void setSessionToRollReservationsForwardFrom(Long sessionToRollReservationsForwardFrom) {
        this.sessionToRollReservationsForwardFrom = sessionToRollReservationsForwardFrom;
    }

    public String[] getRollForwardReservationsSubjectIds() {
        return this.rollForwardReservationsSubjectIds;
    }

    public void setRollForwardReservationsSubjectIds(String[] rollForwardReservationsSubjectIds) {
        this.rollForwardReservationsSubjectIds = rollForwardReservationsSubjectIds;
    }

    public boolean getRollForwardCourseReservations() {
        return this.rollForwardCourseReservations;
    }

    public void setRollForwardCourseReservations(boolean rollForwardCourseReservations) {
        this.rollForwardCourseReservations = rollForwardCourseReservations;
    }

    public boolean getRollForwardCurriculumReservations() {
        return this.rollForwardCurriculumReservations;
    }

    public void setRollForwardCurriculumReservations(boolean rollForwardCurriculumReservations) {
        this.rollForwardCurriculumReservations = rollForwardCurriculumReservations;
    }

    public boolean getRollForwardGroupReservations() {
        return this.rollForwardGroupReservations;
    }

    public void setRollForwardGroupReservations(boolean rollForwardGroupReservations) {
        this.rollForwardGroupReservations = rollForwardGroupReservations;
    }

    public String getExpirationCourseReservations() {
        return this.expirationCourseReservations;
    }

    public void setExpirationCourseReservations(String expirationCourseReservations) {
        this.expirationCourseReservations = expirationCourseReservations;
    }

    public String getExpirationCurriculumReservations() {
        return this.expirationCurriculumReservations;
    }

    public void setExpirationCurriculumReservations(String expirationCurriculumReservations) {
        this.expirationCurriculumReservations = expirationCurriculumReservations;
    }

    public String getExpirationGroupReservations() {
        return this.expirationGroupReservations;
    }

    public void setExpirationGroupReservations(String expirationGroupReservations) {
        this.expirationGroupReservations = expirationGroupReservations;
    }

    public boolean getCreateStudentGroupsIfNeeded() {
        return this.createStudentGroupsIfNeeded;
    }

    public void setCreateStudentGroupsIfNeeded(boolean createStudentGroupsIfNeeded) {
        this.createStudentGroupsIfNeeded = createStudentGroupsIfNeeded;
    }

    public String getStartDateCourseReservations() {
        return this.startDateCourseReservations;
    }

    public void setStartDateCourseReservations(String startDateCourseReservations) {
        this.startDateCourseReservations = startDateCourseReservations;
    }

    public String getStartDateCurriculumReservations() {
        return this.startDateCurriculumReservations;
    }

    public void setStartDateCurriculumReservations(String startDateCurriculumReservations) {
        this.startDateCurriculumReservations = startDateCurriculumReservations;
    }

    public String getStartDateGroupReservations() {
        return this.startDateGroupReservations;
    }

    public void setStartDateGroupReservations(String startDateGroupReservations) {
        this.startDateGroupReservations = startDateGroupReservations;
    }

    public void copyTo(RollForwardSessionForm form) {
        form.subjectAreaIds = this.subjectAreaIds;
        form.buttonAction = this.buttonAction;
        form.sessionToRollForwardTo = this.sessionToRollForwardTo;
        form.rollForwardDatePatterns = this.rollForwardDatePatterns;
        form.sessionToRollDatePatternsForwardFrom = this.sessionToRollDatePatternsForwardFrom;
        form.rollForwardTimePatterns = this.rollForwardTimePatterns;
        form.sessionToRollTimePatternsForwardFrom = this.sessionToRollTimePatternsForwardFrom;
        form.rollForwardDepartments = this.rollForwardDepartments;
        form.sessionToRollDeptsFowardFrom = this.sessionToRollDeptsFowardFrom;
        form.rollForwardManagers = this.rollForwardManagers;
        form.sessionToRollManagersForwardFrom = this.sessionToRollManagersForwardFrom;
        form.rollForwardRoomData = this.rollForwardRoomData;
        form.rollForwardDepartmentIds = this.rollForwardDepartmentIds;
        form.sessionToRollRoomDataForwardFrom = this.sessionToRollRoomDataForwardFrom;
        form.rollForwardSubjectAreas = this.rollForwardSubjectAreas;
        form.sessionToRollSubjectAreasForwardFrom = this.sessionToRollSubjectAreasForwardFrom;
        form.rollForwardInstructorData = this.rollForwardInstructorData;
        form.sessionToRollInstructorDataForwardFrom = this.sessionToRollInstructorDataForwardFrom;
        form.rollForwardCourseOfferings = this.rollForwardCourseOfferings;
        form.sessionToRollCourseOfferingsForwardFrom = this.sessionToRollCourseOfferingsForwardFrom;
        form.rollForwardSubjectAreaIds = this.rollForwardSubjectAreaIds;
        form.rollForwardClassInstructors = this.rollForwardClassInstructors;
        form.rollForwardClassInstrSubjectIds = this.rollForwardClassInstrSubjectIds;
        form.addNewCourseOfferings = this.addNewCourseOfferings;
        form.addNewCourseOfferingsSubjectIds = this.addNewCourseOfferingsSubjectIds;
        form.rollForwardExamConfiguration = this.rollForwardExamConfiguration;
        form.sessionToRollExamConfigurationForwardFrom = this.sessionToRollExamConfigurationForwardFrom;
        form.rollForwardMidtermExams = this.rollForwardMidtermExams;
        form.rollForwardFinalExams = this.rollForwardFinalExams;
        form.rollForwardStudents = this.rollForwardStudents;
        form.rollForwardStudentsMode = this.rollForwardStudentsMode;
        form.pointInTimeSnapshotToRollCourseEnrollmentsForwardFrom = this.pointInTimeSnapshotToRollCourseEnrollmentsForwardFrom;
        form.subpartLocationPrefsAction = this.subpartLocationPrefsAction;
        form.subpartTimePrefsAction = this.subpartTimePrefsAction;
        form.classPrefsAction = this.classPrefsAction;
        form.cancelledClassAction = this.cancelledClassAction;
        form.rollForwardCurricula = this.rollForwardCurricula;
        form.sessionToRollCurriculaForwardFrom = this.sessionToRollCurriculaForwardFrom;
        form.midtermExamsPrefsAction = this.midtermExamsPrefsAction;
        form.finalExamsPrefsAction = this.finalExamsPrefsAction;
        form.rollForwardSessionConfig = this.rollForwardSessionConfig;
        form.sessionToRollSessionConfigForwardFrom = this.sessionToRollSessionConfigForwardFrom;
        form.rollForwardReservations = this.rollForwardReservations;
        form.sessionToRollReservationsForwardFrom = this.sessionToRollReservationsForwardFrom;
        form.rollForwardReservationsSubjectIds = this.rollForwardReservationsSubjectIds;
        form.rollForwardCurriculumReservations = this.rollForwardCurriculumReservations;
        form.rollForwardCourseReservations = this.rollForwardCourseReservations;
        form.rollForwardGroupReservations = this.rollForwardGroupReservations;
        form.expirationCourseReservations = this.expirationCourseReservations;
        form.expirationCurriculumReservations = this.expirationCurriculumReservations;
        form.expirationGroupReservations = this.expirationGroupReservations;
        form.createStudentGroupsIfNeeded = this.createStudentGroupsIfNeeded;
        form.rollForwardOfferingCoordinators = this.rollForwardOfferingCoordinators;
        form.rollForwardOfferingCoordinatorsSubjectIds = this.rollForwardOfferingCoordinatorsSubjectIds;
        form.rollForwardTeachingRequests = this.rollForwardTeachingRequests;
        form.rollForwardTeachingRequestsSubjectIds = this.rollForwardTeachingRequestsSubjectIds;
        form.rollForwardDistributions = this.rollForwardDistributions;
        form.rollForwardPeriodicTasks = this.rollForwardPeriodicTasks;
        form.sessionToRollPeriodicTasksFrom = this.sessionToRollPeriodicTasksFrom;
        form.startDateCourseReservations = this.startDateCourseReservations;
        form.startDateCurriculumReservations = this.startDateCurriculumReservations;
        form.startDateGroupReservations = this.startDateGroupReservations;
        form.rollForwardLearningManagementSystems = this.rollForwardLearningManagementSystems;
        form.sessionToRollLearningManagementSystemsForwardFrom = this.sessionToRollLearningManagementSystemsForwardFrom;
        form.rollForwardWaitListsProhibitedOverrides = this.rollForwardWaitListsProhibitedOverrides;
    }

    public Boolean getRollForwardTeachingRequests() {
        return this.rollForwardTeachingRequests;
    }

    public void setRollForwardTeachingRequests(Boolean rollForwardTeachingRequests) {
        this.rollForwardTeachingRequests = rollForwardTeachingRequests;
    }

    public String[] getRollForwardTeachingRequestsSubjectIds() {
        return this.rollForwardTeachingRequestsSubjectIds;
    }

    public void setRollForwardTeachingRequestsSubjectIds(String[] rollForwardTeachingRequestsSubjectIds) {
        this.rollForwardTeachingRequestsSubjectIds = rollForwardTeachingRequestsSubjectIds;
    }

    public void validateTeachingRequestsRollForward(Session toAcadSession, RollForwardSessionAction.RollForwardErrors action) {
        if (this.getRollForwardTeachingRequests().booleanValue()) {
            if (this.getRollForwardOfferingCoordinatorsSubjectIds() == null || this.getRollForwardOfferingCoordinatorsSubjectIds().length == 0) {
                action.addFieldError("mustSelectDepartment", MSG.errorRollForwardGeneric(MSG.rollForwardTeachingRequests(), MSG.infoNoSubjectAreaSelected()));
            } else {
                this.validateRollForward(action, toAcadSession, this.getSessionToRollInstructorDataForwardFrom(), MSG.rollForwardTeachingRequests(), TeachingRequestDAO.getInstance().getQuery("select tr from TeachingRequest tr inner join tr.offering.courseOfferings co where co.isControl = true and cast(co.subjectArea.uniqueId as string) in :subjectIds").setParameterList("subjectIds", (Object[])this.getRollForwardOfferingCoordinatorsSubjectIds(), (Type)new StringType()).list());
            }
        }
    }

    public Boolean getRollForwardPeriodicTasks() {
        return this.rollForwardPeriodicTasks;
    }

    public void setRollForwardPeriodicTasks(Boolean rollForwardPeriodicTasks) {
        this.rollForwardPeriodicTasks = rollForwardPeriodicTasks;
    }

    public Long getSessionToRollPeriodicTasksFrom() {
        return this.sessionToRollPeriodicTasksFrom;
    }

    public void setSessionToRollPeriodicTasksFrom(Long sessionToRollPeriodicTasksFrom) {
        this.sessionToRollPeriodicTasksFrom = sessionToRollPeriodicTasksFrom;
    }

    public Boolean getRollForwardLearningManagementSystems() {
        return this.rollForwardLearningManagementSystems;
    }

    public void setRollForwardLearningManagementSystems(Boolean rollForwardLearningManagementSystems) {
        this.rollForwardLearningManagementSystems = rollForwardLearningManagementSystems;
    }

    public Long getSessionToRollLearningManagementSystemsForwardFrom() {
        return this.sessionToRollLearningManagementSystemsForwardFrom;
    }

    public void setSessionToRollLearningManagementSystemsForwardFrom(Long sessionToRollLearningManagementSystemsForwardFrom) {
        this.sessionToRollLearningManagementSystemsForwardFrom = sessionToRollLearningManagementSystemsForwardFrom;
    }

    public Boolean getRollForwardWaitListsProhibitedOverrides() {
        return this.rollForwardWaitListsProhibitedOverrides;
    }

    public void setRollForwardWaitListsProhibitedOverrides(Boolean rollForwardWaitListsProhibitedOverrides) {
        this.rollForwardWaitListsProhibitedOverrides = rollForwardWaitListsProhibitedOverrides;
    }

    public Object clone() {
        RollForwardSessionForm form = new RollForwardSessionForm();
        this.copyTo(form);
        return form;
    }

    public int getDepartmentsListSize() {
        return Math.min(7, this.getDepartments().size());
    }

    public int getSubjectAreasListSize() {
        return Math.min(7, this.getSubjectAreas().size());
    }
}

