/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.form.UniTimeForm;
import org.unitime.timetable.model.ContactCategory;
import org.unitime.timetable.model.dao.ContactCategoryDAO;
import org.unitime.timetable.util.IdValue;

public class InquiryForm
implements UniTimeForm {
    private static final long serialVersionUID = -2461671741219768003L;
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    private String iOp;
    private String iSubject;
    private String iMessage;
    private long iType;
    private List<String> carbonCopy;
    private List<String> carbonCopyName;
    private String puid = null;
    private boolean iNoRole;
    private transient File iFile;
    private String iFileContentType;
    private String iFileFileName;

    public InquiryForm() {
        this.reset();
    }

    @Override
    public void validate(UniTimeAction action) {
        if (this.iType < 0L) {
            action.addFieldError("form.type", MSG.errorInquiryPleaseSpecifyCategory());
        }
        if (this.iMessage.trim().length() == 0) {
            action.addFieldError("form.message", MSG.errorInquiryMessageRequired());
        }
    }

    @Override
    public void reset() {
        this.iOp = null;
        this.iSubject = null;
        this.iMessage = null;
        this.iType = -1L;
        this.puid = null;
        this.carbonCopy = new ArrayList<String>();
        this.carbonCopyName = new ArrayList<String>();
        this.iFile = null;
        this.iFileContentType = null;
        this.iFileFileName = null;
    }

    public String getOp() {
        return this.iOp;
    }

    public void setOp(String op) {
        this.iOp = op;
    }

    public String getSubject() {
        return this.iSubject;
    }

    public void setSubject(String subject) {
        this.iSubject = subject;
    }

    public String getMessage() {
        return this.iMessage;
    }

    public void setMessage(String message) {
        this.iMessage = message;
    }

    public long getType() {
        return this.iType;
    }

    public void setType(long type) {
        this.iType = type;
    }

    public String getTypeMsg(long type) {
        ContactCategory cc = (ContactCategory)ContactCategoryDAO.getInstance().get(type);
        return cc.getLabel();
    }

    public List<IdValue> getTypeOptions() {
        ArrayList<IdValue> ret = new ArrayList<IdValue>();
        for (ContactCategory cc : ContactCategoryDAO.getInstance().getSession().createQuery("from ContactCategory order by reference").setCacheable(true).list()) {
            if (cc.getHasRole().booleanValue() && this.iNoRole) continue;
            ret.add(new IdValue(cc.getUniqueId(), cc.getLabel()));
        }
        return ret;
    }

    public void updateMessage() {
        if (this.iMessage != null && !this.iMessage.isEmpty()) {
            String message = null;
            boolean eq = false;
            for (ContactCategory cc : ContactCategoryDAO.getInstance().getSession().createQuery("from ContactCategory order by reference").setCacheable(true).list()) {
                if (cc.getMessage() != null && cc.getMessage().replaceAll("\\s+", "").equals(this.iMessage.replaceAll("\\s+", ""))) {
                    eq = true;
                }
                if (!cc.getUniqueId().equals(this.iType)) continue;
                message = cc.getMessage();
            }
            if (!eq) {
                return;
            }
            this.iMessage = message;
        } else {
            ContactCategory cc = (ContactCategory)ContactCategoryDAO.getInstance().get(this.iType);
            this.iMessage = cc == null ? null : cc.getMessage();
        }
    }

    public String getPuid() {
        return this.puid;
    }

    public void setPuid(String puid) {
        this.puid = puid != null && puid.trim().length() == 0 ? null : puid;
    }

    public boolean getNoRole() {
        return this.iNoRole;
    }

    public void setNoRole(boolean noRole) {
        this.iNoRole = noRole;
    }

    public List<String> getCarbonCopy() {
        return this.carbonCopy;
    }

    public void setCarbonCopy(List<String> carbonCopy) {
        this.carbonCopy = carbonCopy;
    }

    public String getCarbonCopy(int key) {
        return this.carbonCopy.get(key);
    }

    public void setCarbonCopy(int key, String value) {
        this.carbonCopy.set(key, value);
    }

    public List<String> getCarbonCopyName() {
        return this.carbonCopyName;
    }

    public void setCarbonCopyName(List<String> carbonCopyName) {
        this.carbonCopyName = carbonCopyName;
    }

    public String getCarbonCopyName(int key) {
        return this.carbonCopyName.get(key);
    }

    public void setCarbonCopyName(int key, String value) {
        this.carbonCopyName.set(key, value);
    }

    public void addToCarbonCopyName(String email, String name) {
        this.carbonCopy.add(email);
        this.carbonCopyName.add(name);
    }

    public void removeCarbonCopy(int rowNum) {
        if (rowNum >= 0) {
            this.carbonCopy.remove(rowNum);
            this.carbonCopyName.remove(rowNum);
        }
    }

    public File getFile() {
        return this.iFile;
    }

    public void setFile(File file) {
        this.iFile = file;
    }

    public String getFileContentType() {
        return this.iFileContentType;
    }

    public void setFileContentType(String contentType) {
        this.iFileContentType = contentType;
    }

    public String getFileFileName() {
        return this.iFileFileName;
    }

    public void setFileFileName(String fileName) {
        this.iFileFileName = fileName;
    }
}

