/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.ExaminationMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.form.PreferencesForm;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.ExamOwner;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.comparators.ClassComparator;
import org.unitime.timetable.model.comparators.InstrOfferingConfigComparator;
import org.unitime.timetable.model.comparators.SchedulingSubpartComparator;
import org.unitime.timetable.model.dao.Class_DAO;
import org.unitime.timetable.model.dao.CourseOfferingDAO;
import org.unitime.timetable.model.dao.DepartmentalInstructorDAO;
import org.unitime.timetable.model.dao.InstrOfferingConfigDAO;
import org.unitime.timetable.model.dao.SchedulingSubpartDAO;
import org.unitime.timetable.util.IdValue;

public class ExamEditForm
extends PreferencesForm {
    private static final long serialVersionUID = -5083087578026654516L;
    protected static ExaminationMessages EXMSG = Localization.create(ExaminationMessages.class);
    private String examId;
    private String label;
    private String name;
    private String note;
    private Integer maxNbrRooms;
    private Integer length;
    private String size;
    private String sizeNote;
    private String seatingType;
    private String printOffset;
    private List<String> instructors;
    private List<Long> subjectArea;
    private List<Long> courseNbr;
    private List<Long> itype;
    private List<Long> classNumber;
    private Collection<SubjectArea> subjectAreas;
    private Long examType;
    private String avgPeriod;
    private boolean clone;
    private String accommodation;

    public String getExamId() {
        return this.examId;
    }

    public void setExamId(String examId) {
        this.examId = examId;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public Integer getMaxNbrRooms() {
        return this.maxNbrRooms;
    }

    public void setMaxNbrRooms(Integer maxNbrRooms) {
        this.maxNbrRooms = maxNbrRooms;
    }

    public Integer getLength() {
        return this.length;
    }

    public void setLength(Integer length) {
        this.length = length;
    }

    public String getSize() {
        return this.size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public String getSizeNote() {
        return this.sizeNote;
    }

    public void setSizeNote(String sizeNote) {
        this.sizeNote = sizeNote;
    }

    public String getPrintOffset() {
        return this.printOffset;
    }

    public void setPrintOffset(String printOffset) {
        this.printOffset = printOffset;
    }

    public String getSeatingType() {
        return this.seatingType;
    }

    public void setSeatingType(String seatingType) {
        this.seatingType = seatingType;
    }

    public String[] getSeatingTypes() {
        return new String[]{MSG.examSeatingTypeNormal(), MSG.examSeatingTypeExam()};
    }

    public int getSeatingTypeIdx() {
        if (MSG.examSeatingTypeNormal().equals(this.seatingType)) {
            return 0;
        }
        return 1;
    }

    public boolean isExamSeating() {
        return this.getSeatingTypeIdx() == 1;
    }

    public String[] getObjectTypes() {
        return ExamOwner.sOwnerTypes;
    }

    public ExamEditForm() {
        this.reset();
    }

    public List<String> getInstructors() {
        return this.instructors;
    }

    public String getInstructors(int idx) {
        return this.instructors.get(idx);
    }

    public void setInstructors(int idx, String value) {
        this.instructors.set(idx, value);
    }

    public void setInstructors(List<String> instructors) {
        this.instructors = instructors;
    }

    public List<Long> getSubjectArea() {
        return this.subjectArea;
    }

    public List<Long> getSubjectAreaList() {
        return this.getSubjectArea();
    }

    public Long getSubjectArea(int idx) {
        return this.subjectArea.get(idx);
    }

    public void setSubjectArea(int idx, Long id) {
        this.subjectArea.set(idx, id);
    }

    public void setSubjectArea(List<Long> subjectArea) {
        this.subjectArea = subjectArea;
    }

    public List<Long> getCourseNbr() {
        return this.courseNbr;
    }

    public Long getCourseNbr(int idx) {
        return this.courseNbr.get(idx);
    }

    public void setCourseNbr(int idx, Long id) {
        this.courseNbr.set(idx, id);
    }

    public void setCourseNbr(List<Long> courseNbr) {
        this.courseNbr = courseNbr;
    }

    public List<Long> getItype() {
        return this.itype;
    }

    public Long getItype(int idx) {
        return this.itype.get(idx);
    }

    public void setItype(int idx, Long id) {
        this.itype.set(idx, id);
    }

    public void setItype(List<Long> itype) {
        this.itype = itype;
    }

    public List<Long> getClassNumber() {
        return this.classNumber;
    }

    public Long getClassNumber(int idx) {
        return this.classNumber.get(idx);
    }

    public void setClassNumber(int idx, Long id) {
        this.classNumber.set(idx, id);
    }

    public void setClassNumber(List<Long> classNumber) {
        this.classNumber = classNumber;
    }

    public void deleteExamOwner(int idx) {
        this.getSubjectArea().remove(idx);
        this.getCourseNbr().remove(idx);
        this.getItype().remove(idx);
        this.getClassNumber().remove(idx);
    }

    public void addExamOwner(ExamOwner owner) {
        if (owner == null) {
            this.getSubjectArea().add(-1L);
            this.getCourseNbr().add(-1L);
            this.getItype().add(-1L);
            this.getClassNumber().add(-1L);
        } else {
            switch (owner.getOwnerType()) {
                case 3: {
                    Class_ clazz = (Class_)owner.getOwnerObject();
                    this.getSubjectArea().add(clazz.getSchedulingSubpart().getControllingCourseOffering().getSubjectArea().getUniqueId());
                    this.getCourseNbr().add(clazz.getSchedulingSubpart().getControllingCourseOffering().getUniqueId());
                    this.getItype().add(clazz.getSchedulingSubpart().getUniqueId());
                    this.getClassNumber().add(clazz.getUniqueId());
                    break;
                }
                case 2: {
                    InstrOfferingConfig config = (InstrOfferingConfig)owner.getOwnerObject();
                    this.getSubjectArea().add(config.getControllingCourseOffering().getSubjectArea().getUniqueId());
                    this.getCourseNbr().add(config.getControllingCourseOffering().getUniqueId());
                    this.getItype().add(-config.getUniqueId().longValue());
                    this.getClassNumber().add(-1L);
                    break;
                }
                case 1: {
                    CourseOffering course = (CourseOffering)owner.getOwnerObject();
                    this.getSubjectArea().add(course.getSubjectArea().getUniqueId());
                    this.getCourseNbr().add(course.getUniqueId());
                    this.getItype().add(Long.MIN_VALUE);
                    this.getClassNumber().add(-1L);
                    break;
                }
                case 0: {
                    InstructionalOffering offering = (InstructionalOffering)owner.getOwnerObject();
                    this.getSubjectArea().add(offering.getControllingCourseOffering().getSubjectArea().getUniqueId());
                    this.getCourseNbr().add(offering.getControllingCourseOffering().getUniqueId());
                    this.getItype().add(-9223372036854775807L);
                    this.getClassNumber().add(-1L);
                }
            }
        }
    }

    public Collection getSubjectAreas() {
        return this.subjectAreas;
    }

    public void setSubjectAreas(Collection subjectAreas) {
        this.subjectAreas = subjectAreas;
    }

    public Collection getCourseNbrs(int idx) {
        Vector<IdValue> ret = new Vector<IdValue>();
        boolean contains = false;
        if (this.getSubjectArea(idx) >= 0L) {
            Iterator i = new CourseOfferingDAO().getSession().createQuery("select co.uniqueId, co.courseNbr, co.title from CourseOffering co where co.subjectArea.uniqueId = :subjectAreaId and co.instructionalOffering.notOffered = false order by co.courseNbr ").setFetchSize(200).setCacheable(true).setLong("subjectAreaId", this.getSubjectArea(idx).longValue()).iterate();
            while (i.hasNext()) {
                Object[] o = (Object[])i.next();
                ret.add(new IdValue((Long)o[0], (String)o[1] + " - " + (String)o[2]));
                if (!o[0].equals(this.getCourseNbr(idx))) continue;
                contains = true;
            }
        }
        if (!contains) {
            this.setCourseNbr(idx, -1L);
        }
        if (ret.size() == 1) {
            this.setCourseNbr(idx, ((IdValue)ret.firstElement()).getId());
        } else {
            ret.insertElementAt(new IdValue(-1L, "-"), 0);
        }
        return ret;
    }

    public Collection getItypes(int idx) {
        Vector<IdValue> ret = new Vector<IdValue>();
        boolean contains = false;
        if (this.getCourseNbr(idx) >= 0L) {
            CourseOffering course = (CourseOffering)new CourseOfferingDAO().get(this.getCourseNbr(idx));
            if (course.isIsControl().booleanValue()) {
                ret.add(new IdValue(-9223372036854775807L, "Offering"));
            }
            ret.add(new IdValue(Long.MIN_VALUE, "Course"));
            if (!course.isIsControl().booleanValue()) {
                this.setItype(idx, Long.MIN_VALUE);
                return ret;
            }
            TreeSet configs = new TreeSet(new InstrOfferingConfigComparator(null));
            configs.addAll(new InstrOfferingConfigDAO().getSession().createQuery("select distinct c from InstrOfferingConfig c inner join c.instructionalOffering.courseOfferings co where co.uniqueId = :courseOfferingId").setFetchSize(200).setCacheable(true).setLong("courseOfferingId", course.getUniqueId().longValue()).list());
            if (!configs.isEmpty()) {
                ret.add(new IdValue(-9223372036854775806L, "-- Configurations --"));
                for (InstrOfferingConfig c : configs) {
                    if (c.getUniqueId().equals(this.getItype(idx))) {
                        contains = true;
                    }
                    ret.add(new IdValue(-c.getUniqueId().longValue(), c.getName() + (c.getInstructionalMethod() == null ? "" : " (" + c.getInstructionalMethod().getLabel() + ")")));
                }
            }
            TreeSet subparts = new TreeSet(new SchedulingSubpartComparator(null));
            subparts.addAll(new SchedulingSubpartDAO().getSession().createQuery("select distinct s from SchedulingSubpart s inner join s.instrOfferingConfig.instructionalOffering.courseOfferings co where co.uniqueId = :courseOfferingId").setFetchSize(200).setCacheable(true).setLong("courseOfferingId", course.getUniqueId().longValue()).list());
            if (!configs.isEmpty() && !subparts.isEmpty()) {
                ret.add(new IdValue(-9223372036854775806L, "-- Subparts --"));
            }
            for (SchedulingSubpart s : subparts) {
                Long sid = s.getUniqueId();
                String name = s.getItype().getAbbv();
                String sufix = s.getSchedulingSubpartSuffix();
                while (s.getParentSubpart() != null) {
                    name = "\u00a0\u00a0\u00a0\u00a0" + name;
                    s = s.getParentSubpart();
                }
                if (s.getInstrOfferingConfig().getInstructionalOffering().getInstrOfferingConfigs().size() > 1) {
                    name = name + " [" + s.getInstrOfferingConfig().getName() + "]";
                }
                if (sid.equals(this.getItype(idx))) {
                    contains = true;
                }
                ret.add(new IdValue(sid, name + (sufix == null || sufix.length() == 0 ? "" : " (" + sufix + ")")));
            }
        } else {
            ret.addElement(new IdValue(0L, "N/A"));
        }
        if (!contains) {
            this.setItype(idx, ((IdValue)ret.firstElement()).getId());
        }
        return ret;
    }

    public ExamOwner getExamOwner(int idx) {
        if (this.getSubjectArea(idx) < 0L || this.getCourseNbr(idx) < 0L) {
            return null;
        }
        CourseOffering course = (CourseOffering)new CourseOfferingDAO().get(this.getCourseNbr(idx));
        if (course == null) {
            return null;
        }
        if (this.getItype(idx) == Long.MIN_VALUE) {
            ExamOwner owner = new ExamOwner();
            owner.setOwner(course);
            return owner;
        }
        if (this.getItype(idx) == -9223372036854775807L || this.getItype(idx) == -9223372036854775806L) {
            ExamOwner owner = new ExamOwner();
            owner.setOwner(course.getInstructionalOffering());
            return owner;
        }
        if (this.getItype(idx) < 0L) {
            InstrOfferingConfig config = (InstrOfferingConfig)new InstrOfferingConfigDAO().get(-this.getItype(idx).longValue());
            if (config == null) {
                return null;
            }
            ExamOwner owner = new ExamOwner();
            owner.setOwner(config);
            return owner;
        }
        if (this.getClassNumber(idx) >= 0L) {
            Class_ clazz = (Class_)new Class_DAO().get(this.getClassNumber(idx));
            if (clazz == null) {
                return null;
            }
            ExamOwner owner = new ExamOwner();
            owner.setOwner(clazz);
            return owner;
        }
        return null;
    }

    public void setExamOwners(Exam exam) {
        if (exam.getOwners() == null) {
            exam.setOwners(new HashSet<ExamOwner>());
        }
        exam.getOwners().clear();
        for (int idx = 0; idx < this.getSubjectAreaList().size(); ++idx) {
            ExamOwner owner = this.getExamOwner(idx);
            if (owner == null) continue;
            exam.getOwners().add(owner);
            owner.setExam(exam);
        }
    }

    public Collection getClassNumbers(int idx) {
        CourseOffering co;
        Vector<IdValue> ret = new Vector<IdValue>();
        boolean contains = false;
        SchedulingSubpart subpart = this.getItype(idx) > 0L ? (SchedulingSubpart)new SchedulingSubpartDAO().get(this.getItype(idx)) : null;
        CourseOffering courseOffering = co = this.getItype(idx) > 0L ? (CourseOffering)new CourseOfferingDAO().get(this.getCourseNbr(idx)) : null;
        if (subpart != null) {
            TreeSet<Class_> classes = new TreeSet<Class_>(new ClassComparator(5));
            classes.addAll(new Class_DAO().getSession().createQuery("select distinct c from Class_ c where c.schedulingSubpart.uniqueId=:schedulingSubpartId").setFetchSize(200).setCacheable(true).setLong("schedulingSubpartId", this.getItype(idx).longValue()).list());
            for (Class_ c : classes) {
                if (c.getUniqueId().equals(this.getClassNumber(idx))) {
                    contains = true;
                }
                String extId = c.getClassSuffix(co);
                ret.add(new IdValue(c.getUniqueId(), c.getSectionNumberString() + (extId == null || extId.isEmpty() || extId.equalsIgnoreCase(c.getSectionNumberString()) ? "" : " - " + extId)));
            }
        }
        if (ret.isEmpty()) {
            ret.add(new IdValue(-1L, "N/A"));
        }
        if (!contains) {
            this.setClassNumber(idx, -1L);
        }
        if (ret.size() == 1) {
            this.setClassNumber(idx, ((IdValue)ret.firstElement()).getId());
        } else {
            ret.insertElementAt(new IdValue(-1L, "-"), 0);
        }
        return ret;
    }

    @Override
    public void addBlankPrefRows() {
        super.addBlankPrefRows();
    }

    public Long getExamType() {
        return this.examType;
    }

    public void setExamType(Long examType) {
        this.examType = examType;
    }

    public String getAvgPeriod() {
        return this.avgPeriod;
    }

    public void setAvgPeriod(String avgPeriod) {
        this.avgPeriod = avgPeriod;
    }

    public String getEmail(String instructorId) {
        DepartmentalInstructor instructor = (DepartmentalInstructor)new DepartmentalInstructorDAO().get(Long.valueOf(instructorId));
        return instructor.getEmail() == null ? "" : instructor.getEmail();
    }

    public boolean getClone() {
        return this.clone;
    }

    public void setClone(boolean clone) {
        this.clone = clone;
    }

    public String getAccommodation() {
        return this.accommodation;
    }

    public void setAccommodation(String accommodation) {
        this.accommodation = accommodation;
    }

    @Override
    public void reset() {
        this.examId = null;
        this.name = null;
        this.note = null;
        this.maxNbrRooms = 1;
        this.length = null;
        this.size = null;
        this.sizeNote = null;
        this.printOffset = null;
        this.avgPeriod = null;
        this.seatingType = MSG.examSeatingTypeExam();
        this.instructors = new ArrayList<String>();
        this.subjectArea = new ArrayList<Long>();
        this.courseNbr = new ArrayList<Long>();
        this.itype = new ArrayList<Long>();
        this.classNumber = new ArrayList<Long>();
        this.examType = null;
        this.clone = false;
        this.accommodation = null;
        super.reset();
    }

    @Override
    public void validate(UniTimeAction action) {
        super.validate(action);
        if (this.maxNbrRooms != null && this.maxNbrRooms < 0) {
            action.addFieldError("form.maxNbrRooms", EXMSG.errorNegativeMaxNbrRooms());
        }
        if (this.length == null || this.length < 0) {
            action.addFieldError("form.length", EXMSG.errorZeroExamLength());
        }
        if (this.size != null && this.size.length() > 0) {
            try {
                Integer.parseInt(this.size);
            }
            catch (NumberFormatException e) {
                action.addFieldError("form.size", EXMSG.errorExamSizeNotNumber());
            }
        }
        if (this.printOffset != null && this.printOffset.length() > 0) {
            try {
                Integer.parseInt(this.printOffset);
            }
            catch (NumberFormatException e) {
                action.addFieldError("form.printOffset", EXMSG.errorExamPrintOffsetNotNumber());
            }
        }
        if (this.note != null && this.note.length() > 999) {
            action.addFieldError("note", "Note is too long.");
        }
        if (this.instructors != null && this.instructors.size() > 0 && !this.checkPrefs(this.instructors)) {
            action.addFieldError("form.instructors", EXMSG.errorDuplicateExamInstructors());
        }
        boolean hasOwner = false;
        if (this.getSubjectAreaList() != null) {
            for (int idx = 0; idx < this.getSubjectAreaList().size(); ++idx) {
                ExamOwner owner = this.getExamOwner(idx);
                if (owner == null) continue;
                hasOwner = true;
                break;
            }
        }
        if (!hasOwner) {
            action.addFieldError("form.owners", EXMSG.errorNoExamOwners());
        }
    }
}

