/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import java.util.ArrayList;
import java.util.List;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.form.UniTimeForm;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DistributionType;
import org.unitime.timetable.model.PreferenceLevel;

public class DistributionTypeEditForm
implements UniTimeForm {
    private static final long serialVersionUID = 3252210646873060656L;
    private DistributionType iDistributionType;
    private String iOp = null;
    private List<Long> iDepartmentIds = new ArrayList<Long>();
    private Long iDepartmentId;

    public DistributionTypeEditForm() {
        this.reset();
    }

    @Override
    public void reset() {
        this.iOp = null;
        this.iDistributionType = new DistributionType();
        this.iDepartmentId = null;
        this.iDepartmentIds.clear();
    }

    @Override
    public void validate(UniTimeAction action) {
    }

    public void setDistributionType(DistributionType distributionType, Long sessionId) {
        this.iDistributionType = distributionType;
        this.iDepartmentIds.clear();
        for (Department d : distributionType.getDepartments(sessionId)) {
            this.iDepartmentIds.add(d.getUniqueId());
        }
    }

    public DistributionType getDistributionType() {
        return this.iDistributionType;
    }

    public void setSequencingRequired(boolean sequencingRequired) {
        this.iDistributionType.setSequencingRequired(sequencingRequired);
    }

    public boolean isSequencingRequired() {
        return this.iDistributionType.isSequencingRequired();
    }

    public void setRequirementId(String requirementId) {
        Integer reqId = Integer.valueOf(requirementId);
        this.iDistributionType.setRequirementId(reqId);
    }

    public String getRequirementId() {
        if (this.iDistributionType.getRequirementId() == null) {
            return "";
        }
        return this.iDistributionType.getRequirementId().toString();
    }

    public String getOp() {
        return this.iOp;
    }

    public void setOp(String op) {
        this.iOp = op;
    }

    public String getAbbreviation() {
        return this.iDistributionType.getAbbreviation();
    }

    public void setAbbreviation(String abbreviation) {
        this.iDistributionType.setAbbreviation(abbreviation);
    }

    public boolean isInstructorPref() {
        return this.iDistributionType.isInstructorPref() == null ? false : this.iDistributionType.isInstructorPref();
    }

    public void setInstructorPref(boolean instructorPref) {
        this.iDistributionType.setInstructorPref(instructorPref);
    }

    public boolean isExamPref() {
        return this.iDistributionType.isExamPref() == null ? false : this.iDistributionType.isExamPref();
    }

    public void setExamPref(boolean examPref) {
        this.iDistributionType.setExamPref(examPref);
    }

    public String getAllowedPref() {
        return this.iDistributionType.getAllowedPref();
    }

    public void setAllowedPref(String allowedPref) {
        this.iDistributionType.setAllowedPref(allowedPref);
    }

    public String getDescription() {
        return this.iDistributionType.getDescr();
    }

    public void setDescription(String description) {
        this.iDistributionType.setDescr(description);
    }

    public boolean isVisible() {
        return this.iDistributionType.isVisible();
    }

    public void setVisible(boolean visible) {
        this.iDistributionType.setVisible(visible);
    }

    public Long getUniqueId() {
        return this.iDistributionType.getUniqueId();
    }

    public void setUniqueId(Long uniqueId) {
        this.iDistributionType.setUniqueId(uniqueId);
    }

    public String getReference() {
        return this.iDistributionType.getReference();
    }

    public void setReference(String reference) {
        this.iDistributionType.setReference(reference);
    }

    public String getLabel() {
        return this.iDistributionType.getLabel();
    }

    public void setLabel(String label) {
        this.iDistributionType.setLabel(label);
    }

    public List<Long> getDepartmentIds() {
        return this.iDepartmentIds;
    }

    public void setDepartmentIds(List<Long> departmentIds) {
        this.iDepartmentIds = departmentIds;
    }

    public Long getDepartmentIds(int idx) {
        return this.iDepartmentIds.get(idx);
    }

    public void setDepartmentIds(int idx, Long departmentId) {
        this.iDepartmentIds.add(idx, departmentId);
    }

    public Long getDepartmentId() {
        return this.iDepartmentId;
    }

    public void setDepartmentId(Long deptId) {
        this.iDepartmentId = deptId;
    }

    public Boolean getAllowedPreference(int prefId) {
        PreferenceLevel pref = PreferenceLevel.getPreferenceLevel(prefId);
        return this.iDistributionType.getAllowedPref() != null && this.iDistributionType.getAllowedPref().indexOf(PreferenceLevel.prolog2char(pref.getPrefProlog())) >= 0;
    }

    public void setAllowedPreference(int prefId, Boolean value) {
        PreferenceLevel pref = PreferenceLevel.getPreferenceLevel(prefId);
        String original = this.iDistributionType.getAllowedPref();
        String allowedPref = "";
        for (PreferenceLevel p : PreferenceLevel.getPreferenceLevelList()) {
            char ch = PreferenceLevel.prolog2char(p.getPrefProlog());
            if (p.equals(pref)) {
                if (!value.booleanValue()) continue;
                allowedPref = allowedPref + ch;
                continue;
            }
            if (original == null || original.indexOf(ch) < 0) continue;
            allowedPref = allowedPref + ch;
        }
        this.iDistributionType.setAllowedPref(allowedPref);
    }
}

