/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.form.UniTimeForm;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.TeachingClassRequest;
import org.unitime.timetable.model.TeachingResponsibility;
import org.unitime.timetable.model.base.BaseClassInstructor;
import org.unitime.timetable.model.comparators.InstructorComparator;
import org.unitime.timetable.model.dao.Class_DAO;
import org.unitime.timetable.model.dao.DepartmentalInstructorDAO;
import org.unitime.timetable.model.dao.InstrOfferingConfigDAO;
import org.unitime.timetable.model.dao.TeachingResponsibilityDAO;
import org.unitime.timetable.solver.ClassAssignmentProxy;

public class ClassInstructorAssignmentForm
implements UniTimeForm {
    private static final long serialVersionUID = -203441190483028649L;
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    private String op;
    private Long subjectAreaId;
    private Long instrOfferingId;
    private String instrOfferingName;
    private Integer instrOffrConfigLimit;
    private Long instrOffrConfigId;
    private String deletedInstrRowNum;
    private String nextId;
    private String previousId;
    private ClassAssignmentProxy proxy;
    private String addInstructorId;
    private Boolean displayExternalId;
    private String defaultTeachingResponsibilityId;
    private String coordinators;
    private List<String> classIds;
    private List<String> classLabels;
    private List<String> classLabelIndents;
    private List<String> instructorUids;
    private List<String> percentShares;
    private List<Boolean> leadFlags;
    private List<Boolean> displayFlags;
    private List<String> times;
    private List<String> rooms;
    private List<Boolean> allowDeletes;
    private List<String> readOnlyClasses;
    private List<Boolean> classHasErrors;
    private List<Boolean> showDisplay;
    private List<String> externalIds;
    private List<String> responsibilities;

    @Override
    public void reset() {
        this.op = "";
        this.previousId = null;
        this.nextId = null;
        this.subjectAreaId = 0L;
        this.instrOfferingId = 0L;
        this.instrOfferingName = null;
        this.instrOffrConfigLimit = 0;
        this.instrOffrConfigId = 0L;
        this.deletedInstrRowNum = null;
        this.displayExternalId = false;
        this.coordinators = null;
        TeachingResponsibility tr = TeachingResponsibility.getDefaultInstructorTeachingResponsibility();
        this.defaultTeachingResponsibilityId = tr == null ? "" : tr.getUniqueId().toString();
        this.proxy = null;
        this.resetLists();
    }

    private void resetLists() {
        this.classIds = new ArrayList<String>();
        this.classLabels = new ArrayList<String>();
        this.classLabelIndents = new ArrayList<String>();
        this.instructorUids = new ArrayList<String>();
        this.percentShares = new ArrayList<String>();
        this.leadFlags = new ArrayList<Boolean>();
        this.displayFlags = new ArrayList<Boolean>();
        this.times = new ArrayList<String>();
        this.rooms = new ArrayList<String>();
        this.allowDeletes = new ArrayList<Boolean>();
        this.readOnlyClasses = new ArrayList<String>();
        this.classHasErrors = new ArrayList<Boolean>();
        this.showDisplay = new ArrayList<Boolean>();
        this.externalIds = new ArrayList<String>();
        this.responsibilities = new ArrayList<String>();
    }

    @Override
    public void validate(UniTimeAction action) {
        for (int i = 0; i < this.classIds.size(); ++i) {
            String classId = this.classIds.get(i);
            String instrUid = this.instructorUids.get(i);
            String resp = this.responsibilities.get(i);
            for (int j = i + 1; j < this.classIds.size(); ++j) {
                if (this.instructorUids.get(j).length() <= 0 || !this.classIds.get(j).equals(classId) || !this.instructorUids.get(j).equals(instrUid) || !this.responsibilities.get(j).equals(resp)) continue;
                action.addFieldError("duplicateInstructor", MSG.errorDuplicateInstructorForClass());
                this.classHasErrors.set(j, true);
            }
        }
    }

    public void addToClasses(Class_ cls, Boolean isReadOnly, String indent, String nameFormat) {
        ArrayList<ClassInstructor> instructors = new ArrayList<ClassInstructor>(cls.getClassInstructors());
        InstructorComparator ic = new InstructorComparator();
        if (ApplicationProperty.InstructorsDropdownFollowNameFormatting.isTrue()) {
            ic.setNameFormat(nameFormat);
        }
        Collections.sort(instructors, ic);
        ClassInstructor instructor = null;
        int i = 0;
        do {
            if (instructors.size() > 0) {
                instructor = instructors.get(i);
            }
            if (i == 0) {
                this.classLabels.add(cls.htmlLabel());
                this.showDisplay.add(true);
                this.times.add(cls.buildAssignedTimeHtml(this.getProxy()));
                this.rooms.add(cls.buildAssignedRoomHtml(this.getProxy()));
                this.externalIds.add(cls.getClassSuffix() == null ? "" : cls.getClassSuffix());
            } else {
                this.classLabels.add("");
                this.showDisplay.add(false);
                this.times.add("");
                this.rooms.add("");
                this.externalIds.add("");
            }
            this.classLabelIndents.add(indent);
            this.classIds.add(cls.getUniqueId().toString());
            this.readOnlyClasses.add(isReadOnly.toString());
            this.classHasErrors.add(false);
            this.displayFlags.add(cls.isDisplayInstructor());
            if (instructors.size() > 0) {
                this.instructorUids.add(instructor.getInstructor().getUniqueId().toString());
                this.percentShares.add(instructor.getPercentShare().toString());
                this.leadFlags.add(instructor.isLead());
                this.responsibilities.add(instructor.getResponsibility() == null ? "" : instructor.getResponsibility().getUniqueId().toString());
            } else {
                this.instructorUids.add("");
                this.percentShares.add("100");
                this.leadFlags.add(true);
                this.responsibilities.add(this.getDefaultTeachingResponsibilityId());
            }
            this.allowDeletes.add(instructors.size() > 1);
        } while (++i < instructors.size());
    }

    public void deleteInstructor() {
        int index;
        int firstIndex;
        for (firstIndex = index = Integer.parseInt(this.deletedInstrRowNum); firstIndex > 0 && this.classIds.get(firstIndex - 1).equals(this.classIds.get(index)); --firstIndex) {
        }
        int lastIndex = index;
        while (lastIndex + 1 < this.classIds.size() && this.classIds.get(lastIndex + 1).equals(this.classIds.get(index))) {
            ++lastIndex;
        }
        this.classIds.remove(index);
        this.classLabels.remove(index == firstIndex ? index + 1 : index);
        this.classLabelIndents.remove(index == firstIndex ? index + 1 : index);
        this.classHasErrors.remove(index);
        this.instructorUids.remove(index);
        this.percentShares.remove(index);
        if (index < this.leadFlags.size()) {
            this.leadFlags.remove(index);
        }
        this.responsibilities.remove(index);
        this.times.remove(index == firstIndex ? index + 1 : index);
        this.rooms.remove(index == firstIndex ? index + 1 : index);
        this.allowDeletes.remove(index);
        if (firstIndex + 1 == lastIndex) {
            this.allowDeletes.set(firstIndex, Boolean.FALSE);
        }
        if ((index == firstIndex ? index + 1 : index) < this.displayFlags.size()) {
            this.displayFlags.remove(index == firstIndex ? index + 1 : index);
        }
        this.showDisplay.remove(index == firstIndex ? index + 1 : index);
        this.readOnlyClasses.remove(index);
        this.externalIds.remove(index == firstIndex ? index + 1 : index);
    }

    public void addInstructor() {
        int pos = Integer.valueOf(this.getAddInstructorId());
        this.classLabels.add(pos + 1, "");
        this.showDisplay.add(pos + 1, Boolean.FALSE);
        this.times.add(pos + 1, "");
        this.rooms.add(pos + 1, "");
        this.classLabelIndents.add(pos + 1, this.classLabelIndents.get(pos));
        this.classIds.add(pos + 1, this.classIds.get(pos));
        this.readOnlyClasses.add(pos + 1, this.readOnlyClasses.get(pos));
        this.classHasErrors.add(pos + 1, Boolean.FALSE);
        this.displayFlags.add(pos + 1, this.displayFlags.get(pos));
        this.instructorUids.add(pos + 1, "");
        this.percentShares.add(pos + 1, "0");
        this.allowDeletes.set(pos, Boolean.TRUE);
        this.allowDeletes.add(pos + 1, Boolean.TRUE);
        this.externalIds.add(pos + 1, "");
        this.leadFlags.add(pos + 1, this.leadFlags.get(pos));
        this.responsibilities.add(pos + 1, this.defaultTeachingResponsibilityId);
    }

    public void updateClasses() throws Exception {
        InstrOfferingConfig config = (InstrOfferingConfig)InstrOfferingConfigDAO.getInstance().get(this.instrOffrConfigId);
        boolean assignTeachingRequest = Department.isInstructorSchedulingCommitted(config.getInstructionalOffering().getControllingCourseOffering().getDepartment().getUniqueId());
        Class_DAO cdao = new Class_DAO();
        int i = 0;
        while (i < this.classIds.size()) {
            boolean sameClass;
            if ("true".equals(this.getReadOnlyClasses().get(i))) {
                ++i;
                continue;
            }
            String classId = this.classIds.get(i);
            Class_ c = (Class_)cdao.get(Long.valueOf(classId));
            Session hibSession = cdao.getSession();
            Transaction tx = hibSession.beginTransaction();
            HashSet<ClassInstructor> classInstrs = new HashSet<ClassInstructor>(c.getClassInstructors());
            c.setDisplayInstructor(this.getDisplayFlags().get(i));
            while (i < this.classIds.size() && (sameClass = this.classIds.get(i).equals(classId))) {
                String instrId = this.getInstructorUids().get(i);
                if (instrId.length() > 0 && !"-".equals(instrId)) {
                    String pctShare = this.getPercentShares().get(i);
                    Boolean lead = this.getLeadFlags().get(i);
                    String responsibility = this.getResponsibilities().get(i);
                    DepartmentalInstructor deptInstr = (DepartmentalInstructor)new DepartmentalInstructorDAO().get(Long.valueOf(instrId));
                    BaseClassInstructor classInstr = null;
                    Iterator<Object> j = classInstrs.iterator();
                    while (j.hasNext()) {
                        ClassInstructor adept = (ClassInstructor)j.next();
                        if (!adept.getInstructor().equals(deptInstr)) continue;
                        classInstr = adept;
                        j.remove();
                        break;
                    }
                    if (classInstr == null) {
                        classInstr = new ClassInstructor();
                        deptInstr.getClasses().add((ClassInstructor)classInstr);
                        c.getClassInstructors().add((ClassInstructor)classInstr);
                        classInstr.setClassInstructing(c);
                        classInstr.setInstructor(deptInstr);
                        if (assignTeachingRequest) {
                            for (TeachingClassRequest tcr : c.getTeachingRequests()) {
                                if (!tcr.getAssignInstructor().booleanValue() || !tcr.getTeachingRequest().getAssignedInstructors().contains(deptInstr)) continue;
                                classInstr.setTeachingRequest(tcr.getTeachingRequest());
                                break;
                            }
                        }
                    }
                    classInstr.setLead(lead);
                    classInstr.setPercentShare(Integer.valueOf(pctShare));
                    try {
                        classInstr.setResponsibility((TeachingResponsibility)TeachingResponsibilityDAO.getInstance().get(Long.valueOf(responsibility)));
                    }
                    catch (NumberFormatException e) {
                        classInstr.setResponsibility(null);
                    }
                    hibSession.saveOrUpdate((Object)deptInstr);
                }
                ++i;
            }
            for (ClassInstructor ci : classInstrs) {
                DepartmentalInstructor instr = ci.getInstructor();
                instr.getClasses().remove(ci);
                c.getClassInstructors().remove(ci);
                hibSession.saveOrUpdate((Object)instr);
                hibSession.delete((Object)ci);
            }
            try {
                hibSession.saveOrUpdate((Object)c);
                tx.commit();
            }
            catch (Exception e) {
                tx.rollback();
                throw e;
            }
        }
    }

    public void unassignAllInstructors() throws Exception {
        Class_DAO cdao = new Class_DAO();
        for (int i = 0; i < this.classIds.size(); ++i) {
            if ("true".equals(this.getReadOnlyClasses().get(i))) {
                ++i;
                continue;
            }
            String classId = this.classIds.get(i);
            Class_ c = (Class_)cdao.get(Long.valueOf(classId));
            Session hibSession = cdao.getSession();
            Transaction tx = hibSession.beginTransaction();
            try {
                c.deleteClassInstructors(hibSession);
                hibSession.saveOrUpdate((Object)c);
                tx.commit();
                continue;
            }
            catch (Exception e) {
                tx.rollback();
                throw e;
            }
        }
        this.getInstructorUids().clear();
    }

    public String getOp() {
        return this.op;
    }

    public void setOp(String op) {
        this.op = op;
    }

    public List<Boolean> getAllowDeletes() {
        return this.allowDeletes;
    }

    public void setAllowDeletes(List<Boolean> allowDeletes) {
        this.allowDeletes = allowDeletes;
    }

    public void setAllowDeletes(int key, Boolean value) {
        this.allowDeletes.set(key, value);
    }

    public Boolean getAllowDeletes(int key) {
        return this.allowDeletes.get(key);
    }

    public List<String> getClassIds() {
        return this.classIds;
    }

    public void setClassIds(List<String> classIds) {
        this.classIds = classIds;
    }

    public void setClassIds(int key, String value) {
        this.classIds.set(key, value);
    }

    public String getClassIds(int key) {
        return this.classIds.get(key);
    }

    public List<String> getClassLabelIndents() {
        return this.classLabelIndents;
    }

    public void setClassLabelIndents(List<String> classLabelIndents) {
        this.classLabelIndents = classLabelIndents;
    }

    public void setClassLabelIndents(int key, String value) {
        this.classLabelIndents.set(key, value);
    }

    public String getClassLabelIndents(int key) {
        return this.classLabelIndents.get(key);
    }

    public List<String> getClassLabels() {
        return this.classLabels;
    }

    public void setClassLabels(List<String> classLabels) {
        this.classLabels = classLabels;
    }

    public void setClassLabels(int key, String value) {
        this.classLabels.set(key, value);
    }

    public String getClassLabels(int key) {
        return this.classLabels.get(key);
    }

    public List<Boolean> getDisplayFlags() {
        return this.displayFlags;
    }

    public void setDisplayFlags(List<Boolean> displayFlags) {
        this.displayFlags = displayFlags;
    }

    public void setDisplayFlags(int key, Boolean value) {
        this.displayFlags.set(key, value);
    }

    public Boolean getDisplayFlags(int key) {
        return this.displayFlags.get(key);
    }

    public List<String> getInstructorUids() {
        return this.instructorUids;
    }

    public void setInstructorUids(List<String> instructorUids) {
        this.instructorUids = instructorUids;
    }

    public void setInstructorUids(int key, String value) {
        this.instructorUids.set(key, value);
    }

    public String getInstructorUids(int key) {
        return this.instructorUids.get(key);
    }

    public List<Boolean> getLeadFlags() {
        return this.leadFlags;
    }

    public void setLeadFlags(List<Boolean> leadFlags) {
        this.leadFlags = leadFlags;
    }

    public void setLeadFlags(int key, Boolean value) {
        this.leadFlags.set(key, value);
    }

    public Boolean getLeadFlags(int key) {
        return this.leadFlags.get(key);
    }

    public List<String> getPercentShares() {
        return this.percentShares;
    }

    public void setPercentShares(List<String> percentShares) {
        this.percentShares = percentShares;
    }

    public void setPercentShares(int key, String value) {
        this.percentShares.set(key, value);
    }

    public String getPercentShares(int key) {
        return this.percentShares.get(key);
    }

    public List<String> getRooms() {
        return this.rooms;
    }

    public void setRooms(List<String> rooms) {
        this.rooms = rooms;
    }

    public void setRooms(int key, String value) {
        this.rooms.set(key, value);
    }

    public String getRooms(int key) {
        return this.rooms.get(key);
    }

    public List<String> getTimes() {
        return this.times;
    }

    public void setTimes(List<String> times) {
        this.times = times;
    }

    public void setTimes(int key, String value) {
        this.times.set(key, value);
    }

    public String getTimes(int key) {
        return this.times.get(key);
    }

    public Long getInstrOfferingId() {
        return this.instrOfferingId;
    }

    public void setInstrOfferingId(Long instrOfferingId) {
        this.instrOfferingId = instrOfferingId;
    }

    public String getInstrOfferingName() {
        return this.instrOfferingName;
    }

    public void setInstrOfferingName(String instrOfferingName) {
        this.instrOfferingName = instrOfferingName;
    }

    public Long getInstrOffrConfigId() {
        return this.instrOffrConfigId;
    }

    public void setInstrOffrConfigId(Long instrOffrConfigId) {
        this.instrOffrConfigId = instrOffrConfigId;
    }

    public Integer getInstrOffrConfigLimit() {
        return this.instrOffrConfigLimit;
    }

    public void setInstrOffrConfigLimit(Integer instrOffrConfigLimit) {
        this.instrOffrConfigLimit = instrOffrConfigLimit;
    }

    public List<String> getReadOnlyClasses() {
        return this.readOnlyClasses;
    }

    public void setReadOnlyClasses(List<String> readOnlyClasses) {
        this.readOnlyClasses = readOnlyClasses;
    }

    public void setReadOnlyClasses(int key, String value) {
        this.readOnlyClasses.set(key, value);
    }

    public String getReadOnlyClasses(int key) {
        return this.readOnlyClasses.get(key);
    }

    public List<Boolean> getClassHasErrors() {
        return this.classHasErrors;
    }

    public void setClassHasErrors(List<Boolean> classHasErrors) {
        this.classHasErrors = classHasErrors;
    }

    public void setClassHasErrors(int key, Boolean value) {
        this.classHasErrors.set(key, value);
    }

    public Boolean getClassHasErrors(int key) {
        return this.classHasErrors.get(key);
    }

    public Long getSubjectAreaId() {
        return this.subjectAreaId;
    }

    public void setSubjectAreaId(Long subjectAreaId) {
        this.subjectAreaId = subjectAreaId;
    }

    public ClassAssignmentProxy getProxy() {
        return this.proxy;
    }

    public void setProxy(ClassAssignmentProxy proxy) {
        this.proxy = proxy;
    }

    public String getNextId() {
        return this.nextId;
    }

    public void setNextId(String nextId) {
        this.nextId = nextId;
    }

    public String getPreviousId() {
        return this.previousId;
    }

    public void setPreviousId(String previousId) {
        this.previousId = previousId;
    }

    public String getDeletedInstrRowNum() {
        return this.deletedInstrRowNum;
    }

    public void setDeletedInstrRowNum(String deletedInstrRowNum) {
        this.deletedInstrRowNum = deletedInstrRowNum;
    }

    public List<Boolean> getShowDisplay() {
        return this.showDisplay;
    }

    public void setShowDisplay(List<Boolean> showDisplay) {
        this.showDisplay = showDisplay;
    }

    public void setShowDisplay(int key, Boolean value) {
        this.showDisplay.set(key, value);
    }

    public Boolean getShowDisplay(int key) {
        return this.showDisplay.get(key);
    }

    public String getAddInstructorId() {
        return this.addInstructorId;
    }

    public void setAddInstructorId(String addInstructorId) {
        this.addInstructorId = addInstructorId;
    }

    public List<String> getExternalIds() {
        return this.externalIds;
    }

    public void setExternalIds(List<String> externalIds) {
        this.externalIds = externalIds;
    }

    public void setExternalIds(int key, String value) {
        this.externalIds.set(key, value);
    }

    public String getExternalIds(int key) {
        return this.externalIds.get(key);
    }

    public Boolean getDisplayExternalId() {
        return this.displayExternalId;
    }

    public void setDisplayExternalId(Boolean displayExternalId) {
        this.displayExternalId = displayExternalId;
    }

    public List<String> getResponsibilities() {
        return this.responsibilities;
    }

    public void setResponsibilities(List<String> responsibilities) {
        this.responsibilities = responsibilities;
    }

    public void setResponsibilities(int key, String value) {
        this.responsibilities.set(key, value);
    }

    public String getResponsibilities(int key) {
        return this.responsibilities.get(key);
    }

    public String getDefaultTeachingResponsibilityId() {
        return this.defaultTeachingResponsibilityId;
    }

    public void setDefaultTeachingResponsibilityId(String defaultTeachingResponsibilityId) {
        this.defaultTeachingResponsibilityId = defaultTeachingResponsibilityId;
    }

    public String getCoordinators() {
        return this.coordinators;
    }

    public void setCoordinators(String coordinators) {
        this.coordinators = coordinators;
    }
}

