/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.export.instructors;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.TreeSet;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.export.CSVPrinter;
import org.unitime.timetable.export.ExportHelper;
import org.unitime.timetable.export.Exporter;
import org.unitime.timetable.gwt.client.instructor.TeachingAssignmentsPage;
import org.unitime.timetable.gwt.client.instructor.TeachingAssignmentsTable;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.InstructorInterface;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.server.instructor.TeachingAssignmentsBackend;
import org.unitime.timetable.util.Formats;

@Service(value="org.unitime.timetable.export.Exporter:teaching-assignments.csv")
public class TeachingAssignmentsExportCSV
implements Exporter {
    protected static final GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    protected static final StudentSectioningMessages SECTMSG = Localization.create(StudentSectioningMessages.class);
    protected static final GwtConstants CONSTANTS = Localization.create(GwtConstants.class);

    @Override
    public String reference() {
        return "teaching-assignments.csv";
    }

    @Override
    public void export(ExportHelper helper) throws IOException {
        int sort;
        Department department;
        Long sessionId;
        InstructorInterface.TeachingAssignmentsPageRequest request = new InstructorInterface.TeachingAssignmentsPageRequest();
        Enumeration<String> e = helper.getParameterNames();
        while (e.hasMoreElements()) {
            String command = e.nextElement();
            if (command.equals("r:text")) {
                request.getFilter().setText(helper.getParameter("r:text"));
                continue;
            }
            if (!command.startsWith("r:")) continue;
            for (String value : helper.getParameterValues(command)) {
                request.getFilter().addOption(command.substring(2), value);
            }
        }
        if (helper.getParameter("departmentId") != null) {
            request.getFilter().setOption("departmentId", helper.getParameter("departmentId"));
        } else if (helper.getParameter("department") != null) {
            sessionId = helper.getAcademicSessionId();
            if (sessionId == null) {
                throw new IllegalArgumentException("Academic session not provided, please set the term parameter.");
            }
            department = Department.findByDeptCode(helper.getParameter("department"), sessionId);
            if (department == null) {
                throw new IllegalArgumentException("Department " + helper.getParameter("department") + " does not exist.");
            }
            request.getFilter().setOption("departmentId", department.getUniqueId().toString());
        } else if (helper.getParameter("deptCode") != null) {
            sessionId = helper.getAcademicSessionId();
            if (sessionId == null) {
                throw new IllegalArgumentException("Academic session not provided, please set the term parameter.");
            }
            department = Department.findByDeptCode(helper.getParameter("deptCode"), sessionId);
            if (department == null) {
                throw new IllegalArgumentException("Department " + helper.getParameter("deptCode") + " does not exist.");
            }
            request.getFilter().setOption("departmentId", department.getUniqueId().toString());
        }
        ArrayList<TeachingAssignmentsPage.SingleTeachingAssingment> list = new ArrayList<TeachingAssignmentsPage.SingleTeachingAssingment>();
        boolean hasRequests = false;
        for (InstructorInterface.InstructorInfo instructor : new TeachingAssignmentsBackend().execute(request, helper.getSessionContext())) {
            if (instructor.getAssignedRequests().isEmpty()) {
                list.add(new TeachingAssignmentsPage.SingleTeachingAssingment(instructor, null));
                continue;
            }
            for (InstructorInterface.TeachingRequestInfo req : instructor.getAssignedRequests()) {
                if (!req.isMatchingFilter()) continue;
                list.add(new TeachingAssignmentsPage.SingleTeachingAssingment(instructor, req));
                hasRequests = true;
            }
        }
        if (helper.getParameter("sort") != null && (sort = Integer.parseInt(helper.getParameter("sort"))) != 0) {
            TeachingAssignmentsTable.TableComparator cmp = new TeachingAssignmentsTable.TableComparator(TeachingAssignmentsTable.COLUMN.values()[Math.abs(sort) - 1]);
            Collections.sort(list, sort < 0 ? Collections.reverseOrder(cmp) : cmp);
        }
        int cookie = 65535;
        if (helper.getParameter("columns") != null) {
            cookie = Integer.parseInt(helper.getParameter("columns"));
        }
        this.export(request, list, helper, hasRequests, cookie);
    }

    protected void export(InstructorInterface.TeachingAssignmentsPageRequest request, List<TeachingAssignmentsPage.SingleTeachingAssingment> list, ExportHelper helper, boolean hasRequests, int cookie) throws IOException {
        CSVPrinter out = new CSVPrinter(helper, false);
        helper.setup(out.getContentType(), this.reference(), false);
        ArrayList<Column> columns = new ArrayList<Column>();
        for (TeachingAssignmentsTable.COLUMN column : TeachingAssignmentsTable.COLUMN.values()) {
            int nrCells = this.getNbrCells(column);
            for (int idx = 0; idx < nrCells; ++idx) {
                Column c = new Column(column, idx);
                if (!this.isColumnVisible(c, hasRequests, cookie)) continue;
                columns.add(c);
            }
        }
        String[] header = new String[columns.size()];
        for (int i = 0; i < columns.size(); ++i) {
            header[i] = this.getColumnName((Column)columns.get(i)).replace("<br>", "\n");
        }
        out.printHeader(header);
        out.flush();
        InstructorInterface.InstructorInfo last = null;
        for (TeachingAssignmentsPage.SingleTeachingAssingment a : list) {
            int i;
            String[] row = new String[columns.size()];
            if (last != null && last.equals(a.getInstructor())) {
                for (i = 0; i < columns.size(); ++i) {
                    row[i] = ((Column)columns.get(i)).getColumn().isHasRequest() ? this.getCell(a.getRequest(), a.getInstructor(), (Column)columns.get(i)) : null;
                }
            } else {
                for (i = 0; i < columns.size(); ++i) {
                    row[i] = this.getCell(a.getRequest(), a.getInstructor(), (Column)columns.get(i));
                }
            }
            out.printLine(row);
            out.flush();
            last = a.getInstructor();
        }
        out.flush();
        out.close();
    }

    public int getNbrCells(TeachingAssignmentsTable.COLUMN column) {
        return 1;
    }

    public boolean isColumnVisible(Column column, boolean hasRequests, int cookie) {
        boolean visible;
        boolean bl = visible = !column.getColumn().isCanHide() || (cookie & 1 << column.getColumn().ordinal()) != 0;
        if (!hasRequests && column.getColumn().isHasRequest()) {
            visible = false;
        }
        return visible;
    }

    public String getColumnName(Column column) {
        switch (column.getColumn()) {
            case COURSE: {
                return MESSAGES.colCourse();
            }
            case SECTION: {
                return MESSAGES.colSection();
            }
            case TIME: {
                return MESSAGES.colTime();
            }
            case DATE: {
                return MESSAGES.colDate();
            }
            case ROOM: {
                return MESSAGES.colRoom();
            }
            case LOAD: {
                return MESSAGES.colTeachingLoad();
            }
            case ATTRIBUTE_PREFS: {
                return MESSAGES.colAttributePreferences();
            }
            case INSTRUCTOR_PREFS: {
                return MESSAGES.colInstructorPreferences();
            }
            case EXTERNAL_ID: {
                return MESSAGES.colExternalId();
            }
            case NAME: {
                return MESSAGES.colNamePerson();
            }
            case ATTRIBUTES: {
                return MESSAGES.colAttributes();
            }
            case COURSE_PREF: {
                return MESSAGES.colCoursePreferences();
            }
            case DISTRIBUTION_PREF: {
                return MESSAGES.colDistributionPreferences();
            }
            case TIME_PREF: {
                return MESSAGES.colTimePreferences();
            }
            case ASSIGNED_LOAD: {
                return MESSAGES.colAssignedLoad();
            }
            case OBJECTIVES: {
                return MESSAGES.colObjectives();
            }
        }
        return column.getColumn().name();
    }

    public String getCell(InstructorInterface.TeachingRequestInfo request, InstructorInterface.InstructorInfo instructor, Column column) {
        switch (column.getColumn()) {
            case COURSE: {
                if (request == null) {
                    return null;
                }
                return request.getCourse().getCourseName();
            }
            case SECTION: {
                if (request == null) {
                    return null;
                }
                String sections = "";
                for (InstructorInterface.SectionInfo s : request.getSections()) {
                    sections = sections + (sections.isEmpty() ? "" : "\n") + s.getSectionType() + (s.getExternalId() == null ? "" : " " + s.getExternalId());
                }
                return sections;
            }
            case TIME: {
                if (request == null) {
                    return null;
                }
                String times = "";
                for (InstructorInterface.SectionInfo s : request.getSections()) {
                    times = times + (times.isEmpty() ? "" : "\n") + (s.getTime() == null ? SECTMSG.arrangeHours() : s.getTime());
                }
                return times;
            }
            case DATE: {
                if (request == null) {
                    return null;
                }
                String dates = "";
                for (InstructorInterface.SectionInfo s : request.getSections()) {
                    dates = dates + (dates.isEmpty() ? "" : "\n") + (s.getDate() == null ? SECTMSG.noDate() : s.getDate());
                }
                return dates;
            }
            case ROOM: {
                if (request == null) {
                    return null;
                }
                String rooms = "";
                for (InstructorInterface.SectionInfo s : request.getSections()) {
                    rooms = rooms + (rooms.isEmpty() ? "" : "\n") + (s.getRoom() == null ? SECTMSG.noRoom() : s.getRoom());
                }
                return rooms;
            }
            case LOAD: {
                if (request == null) {
                    return null;
                }
                return Formats.getNumberFormat(CONSTANTS.teachingLoadFormat()).format(Float.valueOf(request.getLoad()));
            }
            case EXTERNAL_ID: {
                return instructor == null ? null : instructor.getExternalId();
            }
            case NAME: {
                return instructor == null ? null : instructor.getInstructorName();
            }
            case ATTRIBUTE_PREFS: {
                if (request == null) {
                    return null;
                }
                return this.preferences(request.getAttributePreferences());
            }
            case INSTRUCTOR_PREFS: {
                if (request == null) {
                    return null;
                }
                return this.preferences(request.getInstructorPreferences());
            }
            case COURSE_PREF: {
                return this.preferences(instructor.getCoursePreferences());
            }
            case DISTRIBUTION_PREF: {
                return this.preferences(instructor.getDistributionPreferences());
            }
            case TIME_PREF: {
                return this.preferences(instructor.getTimePreferences());
            }
            case ATTRIBUTES: {
                String attributes = "";
                for (InstructorInterface.AttributeInterface attribute : instructor.getAttributes()) {
                    attributes = attributes + (attributes.isEmpty() ? "" : "\n") + attribute.getName() + (attribute.hasType() ? " (" + attribute.getType().getLabel() + ")" : "");
                }
                return attributes;
            }
            case ASSIGNED_LOAD: {
                return Formats.getNumberFormat(CONSTANTS.teachingLoadFormat()).format(Float.valueOf(instructor.getAssignedLoad())) + " / " + Formats.getNumberFormat(CONSTANTS.teachingLoadFormat()).format(Float.valueOf(instructor.getMaxLoad()));
            }
            case OBJECTIVES: {
                if (request == null) {
                    return null;
                }
                String objectives = "";
                for (String key : new TreeSet<String>(request.getValues().keySet())) {
                    Double value = request.getValues().get(key);
                    if (value == null || Math.abs(value) < 0.001) continue;
                    objectives = objectives + (objectives.isEmpty() ? "" : "\n") + key + ": " + (value > 0.0 ? "+" : "") + Formats.getNumberFormat(CONSTANTS.teachingLoadFormat()).format(value);
                }
                return objectives;
            }
        }
        return null;
    }

    public String preferences(List<InstructorInterface.PreferenceInfo> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        String ret = "";
        for (InstructorInterface.PreferenceInfo pref : list) {
            ret = ret + (ret.isEmpty() ? "" : "\n") + PreferenceLevel.prolog2abbv(pref.getPreference()) + " " + pref.getOwnerName();
        }
        return ret;
    }

    protected static class Column {
        private TeachingAssignmentsTable.COLUMN iColumn;
        private int iIndex;

        Column(TeachingAssignmentsTable.COLUMN column, int index) {
            this.iColumn = column;
            this.iIndex = index;
        }

        public int getIndex() {
            return this.iIndex;
        }

        public TeachingAssignmentsTable.COLUMN getColumn() {
            return this.iColumn;
        }
    }
}

