/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.export.hql;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.hibernate.MappingException;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.type.CollectionType;
import org.hibernate.type.Type;
import org.springframework.stereotype.Service;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.events.EventAction;
import org.unitime.timetable.export.BufferedPrinter;
import org.unitime.timetable.export.CSVPrinter;
import org.unitime.timetable.export.ExportHelper;
import org.unitime.timetable.export.Exporter;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.PageAccessException;
import org.unitime.timetable.gwt.shared.SavedHQLException;
import org.unitime.timetable.gwt.shared.SavedHQLInterface;
import org.unitime.timetable.model.SavedHQL;
import org.unitime.timetable.model.SavedHQLParameter;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.SavedHQLDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao._RootDAO;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.AccessDeniedException;
import org.unitime.timetable.util.Formats;

@Service(value="org.unitime.timetable.export.Exporter:hql-report.csv")
public class SavedHqlExportToCSV
implements Exporter {
    protected static GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    private static Log sLog = LogFactory.getLog(SavedHqlExportToCSV.class);

    @Override
    public String reference() {
        return "hql-report.csv";
    }

    @Override
    public void export(ExportHelper helper) throws IOException {
        Long sessionId = helper.getAcademicSessionId();
        if (sessionId == null) {
            throw new IllegalArgumentException("Academic session not provided, please set the term parameter.");
        }
        Session session = (Session)SessionDAO.getInstance().get(sessionId);
        if (session == null) {
            throw new IllegalArgumentException("Given academic session no longer exists.");
        }
        EventAction.EventContext context = new EventAction.EventContext(helper.getSessionContext(), helper.getAcademicSessionId());
        context.checkPermission(helper.getAcademicSessionId(), Right.HQLReports);
        String report = helper.getParameter("report");
        if (report == null) {
            throw new IllegalArgumentException("No report provided, please set the report parameter.");
        }
        SavedHQL hql = null;
        try {
            hql = (SavedHQL)SavedHQLDAO.getInstance().get(Long.valueOf(report));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (hql == null) {
            hql = (SavedHQL)SavedHQLDAO.getInstance().getSession().createQuery("from SavedHQL where name = :name").setString("name", report).setMaxResults(1).uniqueResult();
        }
        if (hql == null) {
            throw new IllegalArgumentException("Report " + report + " does not exist.");
        }
        ArrayList<SavedHQLInterface.IdValue> params = new ArrayList<SavedHQLInterface.IdValue>();
        if (helper.getParameter("params") != null) {
            String[] p = helper.getParameter("params").split(":");
            int i = 0;
            for (SavedHQL.Option o : SavedHQL.Option.values()) {
                if (!o.allowSingleSelection() && !o.allowMultiSelection() || !hql.getQuery().contains("%" + o.name() + "%")) continue;
                SavedHQLInterface.IdValue v = new SavedHQLInterface.IdValue();
                v.setValue(o.name());
                v.setText((String)(i < p.length ? p[i] : ""));
                params.add(v);
                ++i;
            }
        }
        for (SavedHQL.Option option : SavedHQL.Option.values()) {
            SavedHQLInterface.IdValue v;
            if (!hql.getQuery().contains("%" + option.name() + "%")) continue;
            if (option.allowMultiSelection()) {
                String[] values = helper.getParameterValues(option.name());
                if (values == null || values.length <= 0) continue;
                v = new SavedHQLInterface.IdValue();
                v.setValue(option.name());
                String text = "";
                for (String value : values) {
                    Long id = option.lookupValue(context.getUser(), value);
                    if (id == null) {
                        try {
                            id = Long.valueOf(value);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    if (id == null) continue;
                    text = text + (text.isEmpty() ? "" : ",") + id;
                }
                v.setText(text);
                params.add(v);
                continue;
            }
            String value = helper.getParameter(option.name());
            if (value == null) continue;
            v = new SavedHQLInterface.IdValue();
            v.setValue(option.name());
            Long id = option.lookupValue(context.getUser(), value);
            if (id == null) {
                try {
                    id = Long.valueOf(value);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            v.setText(id == null ? "" : id.toString());
            params.add(v);
        }
        for (SavedHQLParameter p : hql.getParameters()) {
            SavedHQLInterface.IdValue v = new SavedHQLInterface.IdValue();
            v.setValue(p.getName());
            String value = helper.getParameter(p.getName());
            v.setText(value == null ? p.getDefaultValue() : value);
            params.add(v);
        }
        boolean hasAppearancePermission = false;
        for (SavedHQL.Flag flag : SavedHQL.Flag.values()) {
            if (!hql.isSet(flag)) continue;
            if (flag.getAppearance() != null && !hasAppearancePermission && (flag.getPermission() == null || context.hasPermission(flag.getPermission()))) {
                hasAppearancePermission = true;
            }
            if (flag.getAppearance() != null || flag.getPermission() == null) continue;
            context.checkPermission(flag.getPermission());
        }
        if (!hasAppearancePermission) {
            throw new AccessDeniedException();
        }
        BufferedPrinter out = new BufferedPrinter(new CSVPrinter(helper, false));
        helper.setup(out.getContentType(), hql.getName().replace('/', '-').replace('\\', '-').replace(':', '-') + ".csv", false);
        SavedHqlExportToCSV.execute(context.getUser(), out, hql.getQuery(), params, 0, -1, hql.getParameters());
        String sort = helper.getParameter("sort");
        if (sort != null && !"0".equals(sort)) {
            final boolean asc = Integer.parseInt(sort) > 0;
            final int col = Math.abs(Integer.parseInt(sort)) - 1;
            Collections.sort(out.getBuffer(), new Comparator<String[]>(){

                int compare(String[] a, String[] b, int col2) {
                    for (int i = 0; i < a.length; ++i) {
                        int c = (col2 + i) % a.length;
                        try {
                            int cmp = Double.valueOf(a[c] == null ? "0" : a[c]).compareTo(Double.valueOf(b[c] == null ? "0" : b[c]));
                            if (cmp == 0) continue;
                            return cmp;
                        }
                        catch (NumberFormatException e) {
                            int cmp = (a[c] == null ? "" : a[c]).compareTo(b[c] == null ? "" : b[c]);
                            if (cmp == 0) continue;
                            return cmp;
                        }
                    }
                    return 0;
                }

                @Override
                public int compare(String[] a, String[] b) {
                    return asc ? this.compare(a, b, col) : this.compare(b, a, col);
                }
            });
        }
        out.close();
    }

    public static void execute(UserContext user, Exporter.Printer out, String hql, List<SavedHQLInterface.IdValue> options, int fromRow, int maxRows, Collection<SavedHQLParameter> parameters) throws SavedHQLException, PageAccessException {
        try {
            String value;
            for (SavedHQL.Option o : SavedHQL.Option.values()) {
                if (hql.indexOf("%" + o.name() + "%") < 0) continue;
                value = null;
                for (SavedHQLInterface.IdValue idValue : options) {
                    if (!o.name().equals(idValue.getValue())) continue;
                    value = idValue.getText();
                    break;
                }
                if (value == null || value.isEmpty()) {
                    Map<Long, String> vals = o.values(user);
                    if (vals == null || vals.isEmpty()) {
                        throw new SavedHQLException(MESSAGES.errorUnableToSetParameterNoValues(o.name()));
                    }
                    value = "";
                    for (Long id : vals.keySet()) {
                        if (!value.isEmpty()) {
                            value = value + ",";
                        }
                        value = value + id.toString();
                    }
                }
                hql = hql.replace("%" + o.name() + "%", "(" + value + ")");
            }
            if (hql.indexOf("%USER%") >= 0) {
                hql = hql.replace("%USER%", HibernateUtil.escapeSql(user.getExternalUserId()));
            }
            org.hibernate.Session hibSession = SavedHQLDAO.getInstance().getSession();
            Query q = hibSession.createQuery(hql);
            if (maxRows > 0) {
                q.setMaxResults(maxRows);
            }
            if (fromRow > 0) {
                q.setFirstResult(fromRow);
            }
            q.setCacheable(true);
            if (parameters != null && !parameters.isEmpty()) {
                block11: for (SavedHQLParameter parameter : parameters) {
                    SavedHQL.Option[] dateFormat;
                    value = parameter.getDefaultValue();
                    for (SavedHQLInterface.IdValue idValue : options) {
                        if (!parameter.getName().equals(idValue.getValue())) continue;
                        value = idValue.getText();
                        break;
                    }
                    if (parameter.getType().equalsIgnoreCase("boolean")) {
                        q.setBoolean(parameter.getName(), (value == null ? null : Boolean.valueOf("true".equalsIgnoreCase(value))).booleanValue());
                        continue;
                    }
                    if (parameter.getType().equalsIgnoreCase("long")) {
                        q.setLong(parameter.getName(), (value == null || value.isEmpty() ? null : Long.valueOf(value)).longValue());
                        continue;
                    }
                    if (parameter.getType().equalsIgnoreCase("int") || parameter.getType().equalsIgnoreCase("integer") || parameter.getType().equalsIgnoreCase("slot") || parameter.getType().equalsIgnoreCase("time")) {
                        q.setInteger(parameter.getName(), (value == null || value.isEmpty() ? null : Integer.valueOf(value)).intValue());
                        continue;
                    }
                    if (parameter.getType().equalsIgnoreCase("double")) {
                        q.setDouble(parameter.getName(), (value == null || value.isEmpty() ? null : Double.valueOf(value)).doubleValue());
                        continue;
                    }
                    if (parameter.getType().equalsIgnoreCase("float")) {
                        q.setFloat(parameter.getName(), (value == null || value.isEmpty() ? null : Float.valueOf(value)).floatValue());
                        continue;
                    }
                    if (parameter.getType().equalsIgnoreCase("short")) {
                        q.setShort(parameter.getName(), (value == null || value.isEmpty() ? null : Short.valueOf(value)).shortValue());
                        continue;
                    }
                    if (parameter.getType().equalsIgnoreCase("byte")) {
                        q.setByte(parameter.getName(), (value == null || value.isEmpty() ? null : Byte.valueOf(value)).byteValue());
                        continue;
                    }
                    if (parameter.getType().equalsIgnoreCase("date")) {
                        dateFormat = Formats.getDateFormat(Formats.Pattern.DATE_EVENT);
                        q.setDate(parameter.getName(), value == null || value.isEmpty() ? null : (Date)dateFormat.parse(value));
                        continue;
                    }
                    if (parameter.getType().equalsIgnoreCase("datetime") || parameter.getType().equalsIgnoreCase("timestamp")) {
                        dateFormat = Formats.getDateFormat(Formats.Pattern.DATE_TIME_STAMP);
                        q.setDate(parameter.getName(), value == null || value.isEmpty() ? null : (Date)dateFormat.parse(value));
                        continue;
                    }
                    for (SavedHQL.Option option : SavedHQL.Option.values()) {
                        if (!parameter.getType().equalsIgnoreCase(option.name())) continue;
                        if (option.allowMultiSelection()) {
                            ArrayList<Long> ids = new ArrayList<Long>();
                            if (value != null && !value.isEmpty()) {
                                for (String idStr : value.split(",")) {
                                    try {
                                        ids.add(Long.parseLong(idStr));
                                    }
                                    catch (NumberFormatException e) {
                                        Long id = option.lookupValue(user, idStr);
                                        if (id == null) continue;
                                        ids.add(id);
                                    }
                                }
                            } else {
                                Map<Long, String> vals = option.values(user);
                                if (vals != null) {
                                    ids.addAll(vals.keySet());
                                }
                            }
                            q.setParameterList(parameter.getName(), ids);
                            continue block11;
                        }
                        Long id = null;
                        try {
                            id = Long.parseLong(value);
                        }
                        catch (NumberFormatException e) {
                            id = option.lookupValue(user, value);
                        }
                        q.setLong(parameter.getName(), id == null ? -1L : id);
                        continue block11;
                    }
                    q.setString(parameter.getName(), value);
                }
            }
            int len = -1;
            for (Object o : q.list()) {
                String[] line;
                if (len < 0) {
                    len = SavedHqlExportToCSV.length(o);
                    line = new String[len];
                    SavedHqlExportToCSV.header(line, o, q.getReturnAliases());
                    if (line.length > 0 && line[0].startsWith("__")) {
                        out.hideColumn(0);
                    }
                    out.printHeader(line);
                }
                line = new String[len];
                SavedHqlExportToCSV.line(line, o, (SessionImplementor)hibSession);
                out.printLine(line);
                out.flush();
            }
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (SavedHQLException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SavedHQLException(MESSAGES.failedExecution(e.getMessage() + (e.getCause() == null ? "" : " (" + e.getCause().getMessage() + ")")));
        }
    }

    private static boolean skip(Type t, boolean lazy) {
        try {
            if (t.isCollectionType()) {
                if (!lazy) {
                    return true;
                }
                SessionFactory hibSessionFactory = new _RootDAO().getSession().getSessionFactory();
                Type w = ((CollectionType)t).getElementType((SessionFactoryImplementor)hibSessionFactory);
                Class<?> ts = w.getReturnedClass().getMethod("toString", new Class[0]).getDeclaringClass();
                return ts.equals(Object.class) || ts.getName().startsWith("org.unitime.timetable.model.base.Base");
            }
        }
        catch (MappingException e) {
            return true;
        }
        catch (NoSuchMethodException e) {
            return true;
        }
        try {
            Class<?> ts = t.getReturnedClass().getMethod("toString", new Class[0]).getDeclaringClass();
            return ts.equals(Object.class) || ts.getName().startsWith("org.unitime.timetable.model.base.Base");
        }
        catch (NoSuchMethodException e) {
            return true;
        }
    }

    private static int length(Object o) {
        if (o == null) {
            return 1;
        }
        int len = 0;
        if (o instanceof Object[]) {
            for (Object x : (Object[])o) {
                if (x == null) {
                    ++len;
                    continue;
                }
                ClassMetadata meta = SavedHQLDAO.getInstance().getSession().getSessionFactory().getClassMetadata(x.getClass());
                if (meta == null) {
                    ++len;
                    continue;
                }
                if (meta.getIdentifierPropertyName() != null) {
                    ++len;
                }
                for (int i = 0; i < meta.getPropertyNames().length; ++i) {
                    if (SavedHqlExportToCSV.skip(meta.getPropertyTypes()[i], meta.getPropertyLaziness()[i])) continue;
                    ++len;
                }
            }
        } else {
            ClassMetadata meta = SavedHQLDAO.getInstance().getSession().getSessionFactory().getClassMetadata(o.getClass());
            if (meta == null) {
                ++len;
            } else {
                if (meta.getIdentifierPropertyName() != null) {
                    ++len;
                }
                for (int i = 0; i < meta.getPropertyNames().length; ++i) {
                    if (SavedHqlExportToCSV.skip(meta.getPropertyTypes()[i], meta.getPropertyLaziness()[i])) continue;
                    ++len;
                }
            }
        }
        return len;
    }

    private static String format(String column) {
        if (column == null || column.isEmpty()) {
            return "?";
        }
        return column.substring(0, 1).toUpperCase() + column.substring(1);
    }

    private static void header(String[] ret, Object o, String[] alias) {
        if (o == null) {
            ret[0] = alias != null && alias.length >= 1 && alias[0] != null && !alias[0].isEmpty() ? alias[0] : "Result";
        } else if (o instanceof Object[]) {
            int a = 0;
            int idx = 0;
            for (Object x : (Object[])o) {
                if (x == null) {
                    ret[idx++] = alias != null && alias.length > a && alias[a] != null && !alias[a].isEmpty() ? alias[a] : "Column" + (a + 1);
                } else {
                    ClassMetadata meta = SavedHQLDAO.getInstance().getSession().getSessionFactory().getClassMetadata(x.getClass());
                    if (meta == null) {
                        ret[idx++] = alias != null && alias.length > a && alias[a] != null && !alias[a].isEmpty() ? alias[a] : "Column" + (a + 1);
                    } else {
                        if (meta.getIdentifierPropertyName() != null) {
                            ret[idx++] = meta.getIdentifierPropertyName();
                        }
                        for (int i = 0; i < meta.getPropertyNames().length; ++i) {
                            if (SavedHqlExportToCSV.skip(meta.getPropertyTypes()[i], meta.getPropertyLaziness()[i])) continue;
                            ret[idx++] = SavedHqlExportToCSV.format(meta.getPropertyNames()[i]);
                        }
                    }
                }
                ++a;
            }
        } else {
            ClassMetadata meta = SavedHQLDAO.getInstance().getSession().getSessionFactory().getClassMetadata(o.getClass());
            if (meta == null) {
                ret[0] = alias != null && alias.length >= 1 && alias[0] != null && !alias[0].isEmpty() ? alias[0] : "Result";
            } else {
                int idx = 0;
                if (meta.getIdentifierPropertyName() != null) {
                    ret[idx++] = meta.getIdentifierPropertyName();
                }
                for (int i = 0; i < meta.getPropertyNames().length; ++i) {
                    if (SavedHqlExportToCSV.skip(meta.getPropertyTypes()[i], meta.getPropertyLaziness()[i])) continue;
                    ret[idx++] = SavedHqlExportToCSV.format(meta.getPropertyNames()[i]);
                }
            }
        }
    }

    private static String toString(Object o) {
        if (o != null && o instanceof Document) {
            return ((Document)o).asXML();
        }
        return o == null ? "" : o.toString();
    }

    private static void line(String[] ret, Object o, SessionImplementor session) {
        if (o == null) {
            ret[0] = "";
        } else if (o instanceof Object[]) {
            int idx = 0;
            for (Object x : (Object[])o) {
                if (x == null) {
                    ret[idx++] = "";
                    continue;
                }
                ClassMetadata meta = SavedHQLDAO.getInstance().getSession().getSessionFactory().getClassMetadata(x.getClass());
                if (meta == null) {
                    ret[idx++] = SavedHqlExportToCSV.toString(x);
                    continue;
                }
                if (meta.getIdentifierPropertyName() != null) {
                    ret[idx++] = SavedHqlExportToCSV.toString(meta.getIdentifier(x, session));
                }
                for (int i = 0; i < meta.getPropertyNames().length; ++i) {
                    if (SavedHqlExportToCSV.skip(meta.getPropertyTypes()[i], meta.getPropertyLaziness()[i])) continue;
                    ret[idx++] = SavedHqlExportToCSV.toString(meta.getPropertyValue(x, meta.getPropertyNames()[i]));
                }
            }
        } else {
            ClassMetadata meta = SavedHQLDAO.getInstance().getSession().getSessionFactory().getClassMetadata(o.getClass());
            if (meta == null) {
                ret[0] = SavedHqlExportToCSV.toString(o);
            } else {
                int idx = 0;
                if (meta.getIdentifierPropertyName() != null) {
                    ret[idx++] = SavedHqlExportToCSV.toString(meta.getIdentifier(o, session));
                }
                for (int i = 0; i < meta.getPropertyNames().length; ++i) {
                    if (SavedHqlExportToCSV.skip(meta.getPropertyTypes()[i], meta.getPropertyLaziness()[i])) continue;
                    ret[idx++] = SavedHqlExportToCSV.toString(meta.getPropertyValue(o, meta.getPropertyNames()[i]));
                }
            }
        }
    }
}

