/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.dataexchange;

import java.util.Hashtable;
import java.util.Iterator;
import org.dom4j.Element;
import org.unitime.timetable.dataexchange.BaseImport;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.StudentAccomodation;

public class StudentAccomodationImport
extends BaseImport {
    @Override
    public void loadXml(Element root) throws Exception {
        if (!root.getName().equalsIgnoreCase("studentAccomodations")) {
            throw new Exception("Given XML file is not student accomodations load file.");
        }
        try {
            this.beginTransaction();
            String campus = root.attributeValue("campus");
            String year = root.attributeValue("year");
            String term = root.attributeValue("term");
            Session session = Session.getSessionUsingInitiativeYearTerm(campus, year, term);
            if (session == null) {
                throw new Exception("No session found for the given campus, year, and term.");
            }
            Hashtable<String, StudentAccomodation> id2accomodation = new Hashtable<String, StudentAccomodation>();
            Hashtable<String, StudentAccomodation> code2accomodation = new Hashtable<String, StudentAccomodation>();
            for (StudentAccomodation accomodation : this.getHibSession().createQuery("from StudentAccomodation where session.uniqueId=:sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
                if (accomodation.getExternalUniqueId() != null) {
                    id2accomodation.put(accomodation.getExternalUniqueId(), accomodation);
                }
                code2accomodation.put(accomodation.getAbbreviation(), accomodation);
            }
            Iterator it = root.elementIterator();
            while (it.hasNext()) {
                Element element = (Element)it.next();
                String externalId = element.attributeValue("externalId");
                String abbv = element.attributeValue("abbreviation");
                String name = element.attributeValue("name");
                StudentAccomodation accomodation = null;
                if (externalId != null) {
                    accomodation = (StudentAccomodation)id2accomodation.remove(externalId);
                }
                if (accomodation == null) {
                    accomodation = (StudentAccomodation)code2accomodation.get(abbv);
                }
                if (accomodation == null) {
                    accomodation = new StudentAccomodation();
                    accomodation.setSession(session);
                    this.info("Accomodation " + abbv + (externalId == null ? "" : " (" + externalId + ")") + " created.");
                } else {
                    this.info("Accomodation " + abbv + (externalId == null ? "" : " (" + externalId + ")") + " updated.");
                }
                accomodation.setExternalUniqueId(externalId);
                accomodation.setAbbreviation(abbv);
                accomodation.setName(name);
                this.getHibSession().saveOrUpdate((Object)accomodation);
            }
            for (StudentAccomodation accomodation : id2accomodation.values()) {
                this.info("Accomodation " + accomodation.getAbbreviation() + " (" + accomodation.getExternalUniqueId() + ") deleted.");
                this.getHibSession().delete((Object)accomodation);
            }
            this.commitTransaction();
        }
        catch (Exception e) {
            this.fatal("Exception: " + e.getMessage(), e);
            this.rollbackTransaction();
            throw e;
        }
    }
}

