/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.dataexchange;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.dom4j.Element;
import org.unitime.timetable.dataexchange.BaseImport;
import org.unitime.timetable.model.SavedHQL;
import org.unitime.timetable.model.SavedHQLParameter;

public class HQLImport
extends BaseImport {
    @Override
    public void loadXml(Element root) throws Exception {
        try {
            this.beginTransaction();
            if (root.getName().equalsIgnoreCase("report")) {
                this.importReport(root);
            } else if (root.getName().equalsIgnoreCase("reports")) {
                Iterator i = root.elementIterator("report");
                while (i.hasNext()) {
                    this.importReport((Element)i.next());
                }
            } else {
                throw new Exception("Given XML file is not a HQL report file.");
            }
            this.commitTransaction();
        }
        catch (Exception e) {
            this.fatal("Exception: " + e.getMessage(), e);
            this.rollbackTransaction();
            throw e;
        }
    }

    protected void importReport(Element reportEl) {
        String name = reportEl.attributeValue("name");
        if (name == null) {
            this.error("Attribute name is not provided.");
            return;
        }
        SavedHQL report = (SavedHQL)this.getHibSession().createQuery("from SavedHQL where name = :name").setString("name", name).setMaxResults(1).uniqueResult();
        if (report == null) {
            report = new SavedHQL();
            report.setName(name);
            report.setParameters(new HashSet<SavedHQLParameter>());
        }
        report.setType(0);
        Element flags = reportEl.element("flags");
        Iterator i = (flags == null ? reportEl : flags).elementIterator("flag");
        while (i.hasNext()) {
            Element e = (Element)i.next();
            SavedHQL.Flag flag = SavedHQL.Flag.valueOf(e.getTextTrim());
            if (flag == null) continue;
            report.set(flag);
        }
        Element queryEl = reportEl.element("query");
        if (queryEl != null) {
            report.setQuery(queryEl.getText());
        } else {
            report.setQuery(null);
        }
        Element descriptionEl = reportEl.element("description");
        if (descriptionEl != null) {
            report.setDescription(descriptionEl.getText());
        } else {
            report.setDescription(null);
        }
        HashMap<String, SavedHQLParameter> params = new HashMap<String, SavedHQLParameter>();
        for (SavedHQLParameter parameter : report.getParameters()) {
            params.put(parameter.getName(), parameter);
        }
        Iterator i2 = reportEl.elementIterator("parameter");
        while (i2.hasNext()) {
            Element paramEl = (Element)i2.next();
            String pName = paramEl.attributeValue("name");
            if (pName == null) continue;
            SavedHQLParameter parameter = (SavedHQLParameter)params.remove(pName);
            if (parameter == null) {
                parameter = new SavedHQLParameter();
                parameter.setName(pName);
                parameter.setSavedHQL(report);
                report.getParameters().add(parameter);
            }
            parameter.setLabel(paramEl.attributeValue("label"));
            parameter.setType(paramEl.attributeValue("type"));
            parameter.setDefaultValue(paramEl.attributeValue("default"));
        }
        for (SavedHQLParameter parameter : params.values()) {
            this.getHibSession().delete((Object)parameter);
            report.getParameters().remove(parameter);
        }
        this.getHibSession().saveOrUpdate((Object)report);
    }
}

