/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.api;

import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.hibernate.Session;
import org.springframework.stereotype.Service;
import org.unitime.timetable.api.ApiToken;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.model.User;
import org.unitime.timetable.model.dao._RootDAO;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.context.UniTimeUserContext;

@Service(value="apiToken")
public class UsersApiToken
implements ApiToken {
    private static SecretKey secret() throws NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] salt = new byte[]{51, 123, 9, 14, -49, 90, 88, -39};
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
        PBEKeySpec spec = new PBEKeySpec(ApplicationProperty.UrlEncoderSecret.value().toCharArray(), salt, 1024, 128);
        SecretKey key = factory.generateSecret(spec);
        return new SecretKeySpec(key.getEncoded(), "AES");
    }

    public static String encode(String text) {
        try {
            if (text == null || text.isEmpty()) {
                return null;
            }
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(1, UsersApiToken.secret());
            return new BigInteger(cipher.doFinal(text.getBytes())).toString(36);
        }
        catch (Exception e) {
            throw new GwtRpcException("Encoding failed: " + e.getMessage(), e);
        }
    }

    public static String decode(String text) {
        try {
            if (text == null || text.isEmpty()) {
                return null;
            }
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(2, UsersApiToken.secret());
            return new String(cipher.doFinal(new BigInteger(text, 36).toByteArray()));
        }
        catch (Exception e) {
            throw new GwtRpcException("Decoding failed: " + e.getMessage(), e);
        }
    }

    @Override
    public String getToken(String externalId, String secret) {
        try {
            return UsersApiToken.encode(externalId + "|" + secret);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to encode API token: " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserContext getContext(String token) {
        UniTimeUserContext uniTimeUserContext;
        String decoded = UsersApiToken.decode(token);
        int split = decoded.indexOf(124);
        String externalId = decoded.substring(0, split);
        String secret = decoded.substring(split + 1);
        Session hibSession = null;
        try {
            hibSession = new _RootDAO().createNewSession();
            User user = (User)hibSession.createQuery("select u from User u where u.externalUniqueId=:externalId").setString("externalId", externalId).setCacheable(true).setMaxResults(1).uniqueResult();
            if (user == null) {
                throw new IllegalArgumentException("Failed to decode API token: user does not exist.");
            }
            if (secret == null || !secret.equals(user.getPassword())) {
                throw new IllegalArgumentException("Failed to decode API token: secret does not match.");
            }
            uniTimeUserContext = new UniTimeUserContext(user.getExternalUniqueId(), user.getUsername(), null, user.getPassword());
        }
        catch (Throwable throwable) {
            try {
                hibSession.close();
                throw throwable;
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to decode API token: " + e.getMessage(), e);
            }
        }
        hibSession.close();
        return uniTimeUserContext;
    }

    @Override
    public String getUserId(String token) {
        try {
            String decoded = UsersApiToken.decode(token);
            int split = decoded.indexOf(124);
            String externalId = decoded.substring(0, split);
            return externalId;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to decode API token: " + e.getMessage(), e);
        }
    }
}

