/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.io.PrintWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.tiles.annotation.TilesDefinition;
import org.apache.struts2.tiles.annotation.TilesDefinitions;
import org.apache.struts2.tiles.annotation.TilesPutAttribute;
import org.cpsolver.ifs.util.DataProperties;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.unitime.commons.Debug;
import org.unitime.commons.web.WebTable;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.form.SolverSettingsForm;
import org.unitime.timetable.model.SolverParameter;
import org.unitime.timetable.model.SolverParameterDef;
import org.unitime.timetable.model.SolverParameterGroup;
import org.unitime.timetable.model.SolverPredefinedSetting;
import org.unitime.timetable.model.base.BaseSolverPredefinedSetting;
import org.unitime.timetable.model.dao.SolverParameterDAO;
import org.unitime.timetable.model.dao.SolverParameterDefDAO;
import org.unitime.timetable.model.dao.SolverParameterGroupDAO;
import org.unitime.timetable.model.dao.SolverPredefinedSettingDAO;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.ExportUtils;

@Action(value="solverSettings", results={@Result(name={"list"}, type="tiles", location="solverSettingsList.tiles"), @Result(name={"add"}, type="tiles", location="solverSettingAdd.tiles"), @Result(name={"edit"}, type="tiles", location="solverSettingEdit.tiles")})
@TilesDefinitions(value={@TilesDefinition(name="solverSettingsList.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Solver Configurations"), @TilesPutAttribute(name="body", value="/admin/solverSettings.jsp")}), @TilesDefinition(name="solverSettingAdd.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Add Solver Configuration"), @TilesPutAttribute(name="body", value="/admin/solverSettings.jsp")}), @TilesDefinition(name="solverSettingEdit.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Edit Solver Configuration"), @TilesPutAttribute(name="body", value="/admin/solverSettings.jsp")})})
public class SolverSettingsAction
extends UniTimeAction<SolverSettingsForm> {
    private static final long serialVersionUID = 2993473779756335885L;
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    protected String id = null;
    protected String op2 = null;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getOp2() {
        return this.op2;
    }

    public void setOp2(String op2) {
        this.op2 = op2;
    }

    public String execute() throws Exception {
        SolverPredefinedSetting setting;
        Session hibSession;
        SolverPredefinedSettingDAO dao;
        Transaction tx;
        if (this.form == null) {
            this.form = new SolverSettingsForm();
        }
        this.sessionContext.checkPermission(Right.SolverConfigurations);
        if (this.op == null) {
            this.op = ((SolverSettingsForm)this.form).getOp();
        }
        if (this.op2 != null && !this.op2.isEmpty()) {
            this.op = this.op2;
        }
        if (this.op == null) {
            ((SolverSettingsForm)this.form).reset();
            ((SolverSettingsForm)this.form).setOp(MSG.actionAddNewSolverConfig());
            this.op = "list";
        }
        if (MSG.actionBackToSolverConfigs().equals(this.op)) {
            ((SolverSettingsForm)this.form).reset();
            ((SolverSettingsForm)this.form).setOp(MSG.actionAddNewSolverConfig());
        }
        if (MSG.actionAddNewSolverConfig().equals(this.op)) {
            ((SolverSettingsForm)this.form).reset();
            ((SolverSettingsForm)this.form).setOp(MSG.actionSaveSolverConfig());
            ((SolverSettingsForm)this.form).loadDefaults();
        }
        if ("Refresh".equals(this.op)) {
            ((SolverSettingsForm)this.form).setOp(((SolverSettingsForm)this.form).getUniqueId() == null || ((SolverSettingsForm)this.form).getUniqueId() <= 0L ? MSG.actionSaveSolverConfig() : MSG.actionUpdateSolverConfig());
            for (SolverParameterDef def : SolverParameterDefDAO.getInstance().findAll()) {
                if (!def.isVisible().booleanValue() || !Boolean.TRUE.equals(((SolverSettingsForm)this.form).getUseDefault(def.getUniqueId())) || ((SolverSettingsForm)this.form).getParameter(def.getUniqueId()) != null) continue;
                ((SolverSettingsForm)this.form).setParameter(def.getUniqueId(), def.getDefault());
            }
        }
        if (MSG.actionSaveSolverConfig().equals(this.op) || MSG.actionUpdateSolverConfig().equals(this.op)) {
            ((SolverSettingsForm)this.form).validate(this);
            if (!this.hasFieldErrors()) {
                tx = null;
                try {
                    dao = new SolverPredefinedSettingDAO();
                    SolverParameterDAO pDao = new SolverParameterDAO();
                    Session hibSession2 = dao.getSession();
                    if (hibSession2.getTransaction() == null || !hibSession2.getTransaction().isActive()) {
                        tx = hibSession2.beginTransaction();
                    }
                    Object setting2 = null;
                    setting2 = MSG.actionSaveSolverConfig().equals(this.op) ? new SolverPredefinedSetting() : (SolverPredefinedSetting)dao.get(((SolverSettingsForm)this.form).getUniqueId(), hibSession2);
                    ((BaseSolverPredefinedSetting)setting2).setName(((SolverSettingsForm)this.form).getName());
                    ((BaseSolverPredefinedSetting)setting2).setDescription(((SolverSettingsForm)this.form).getDescription());
                    ((SolverPredefinedSetting)setting2).setAppearanceType(((SolverSettingsForm)this.form).getAppearanceType());
                    Set<SolverParameter> params = ((BaseSolverPredefinedSetting)setting2).getParameters();
                    if (params == null) {
                        params = new HashSet<SolverParameter>();
                        ((BaseSolverPredefinedSetting)setting2).setParameters(params);
                    }
                    for (SolverParameterDef def : new SolverParameterDefDAO().findAll(hibSession2)) {
                        SolverParameter param = null;
                        for (SolverParameter p : params) {
                            if (!p.getDefinition().equals(def)) continue;
                            param = p;
                            break;
                        }
                        if (!def.isVisible().booleanValue()) {
                            if (param == null) continue;
                            params.remove(param);
                            pDao.delete(param, hibSession2);
                            continue;
                        }
                        String value = ((SolverSettingsForm)this.form).getParameter(def.getUniqueId());
                        Boolean useDefault = ((SolverSettingsForm)this.form).getUseDefault(def.getUniqueId());
                        if (useDefault.booleanValue()) {
                            if (param == null) continue;
                            params.remove(param);
                            pDao.delete(param, hibSession2);
                            continue;
                        }
                        if (param == null) {
                            param = new SolverParameter();
                            param.setDefinition(def);
                        }
                        param.setValue(value == null ? def.getDefault() : value);
                        pDao.saveOrUpdate(param, hibSession2);
                        params.add(param);
                    }
                    dao.saveOrUpdate(setting2, hibSession2);
                    if (tx != null) {
                        tx.commit();
                    }
                }
                catch (Exception e) {
                    if (tx != null) {
                        tx.rollback();
                    }
                    Debug.error(e);
                }
                ((SolverSettingsForm)this.form).reset();
                ((SolverSettingsForm)this.form).setOp(MSG.actionAddNewSolverConfig());
            } else {
                ((SolverSettingsForm)this.form).setOp(this.op);
                for (SolverParameterDef def : SolverParameterDefDAO.getInstance().findAll()) {
                    if (!def.isVisible().booleanValue() || !Boolean.TRUE.equals(((SolverSettingsForm)this.form).getUseDefault(def.getUniqueId())) || ((SolverSettingsForm)this.form).getParameter(def.getUniqueId()) != null) continue;
                    ((SolverSettingsForm)this.form).setParameter(def.getUniqueId(), def.getDefault());
                }
            }
        }
        if (this.op.equals("Edit")) {
            if (this.id == null) {
                this.addFieldError("form.uniqueId", MSG.errorRequiredField("Id"));
            } else {
                tx = null;
                try {
                    dao = new SolverPredefinedSettingDAO();
                    hibSession = dao.getSession();
                    if (hibSession.getTransaction() == null || !hibSession.getTransaction().isActive()) {
                        tx = hibSession.beginTransaction();
                    }
                    if ((setting = (SolverPredefinedSetting)dao.get(Long.valueOf(this.id), hibSession)) == null) {
                        this.addFieldError("form.name", MSG.errorDoesNotExists(this.id));
                    } else {
                        ((SolverSettingsForm)this.form).reset();
                        ((SolverSettingsForm)this.form).loadDefaults();
                        ((SolverSettingsForm)this.form).setUniqueId(setting.getUniqueId());
                        ((SolverSettingsForm)this.form).setName(setting.getName());
                        ((SolverSettingsForm)this.form).setDescription(setting.getDescription());
                        ((SolverSettingsForm)this.form).setAppearanceType(setting.getAppearanceType());
                        ((SolverSettingsForm)this.form).setOp(MSG.actionUpdateSolverConfig());
                        for (SolverParameter param : setting.getParameters()) {
                            if (!param.getDefinition().isVisible().booleanValue()) continue;
                            String value = param.getValue();
                            if ("boolean".equals(param.getDefinition().getType()) && "on".equals(param.getValue())) {
                                value = "true";
                            }
                            ((SolverSettingsForm)this.form).setParameter(param.getDefinition().getUniqueId(), value);
                            ((SolverSettingsForm)this.form).setUseDefault(param.getDefinition().getUniqueId(), Boolean.FALSE);
                        }
                    }
                    if (tx != null) {
                        tx.commit();
                    }
                }
                catch (Exception e) {
                    if (tx != null) {
                        tx.rollback();
                    }
                    Debug.error(e);
                }
            }
        }
        if (MSG.actionExportSolverConfig().equals(this.op)) {
            if (((SolverSettingsForm)this.form).getUniqueId() == null) {
                this.addFieldError("form.uniqueId", MSG.errorRequiredField("Id"));
            } else {
                SolverPredefinedSettingDAO dao2 = new SolverPredefinedSettingDAO();
                Session hibSession3 = dao2.getSession();
                SolverPredefinedSetting setting3 = (SolverPredefinedSetting)dao2.get(((SolverSettingsForm)this.form).getUniqueId(), hibSession3);
                if (setting3 == null) {
                    this.addFieldError("form.name", MSG.errorDoesNotExists(String.valueOf(((SolverSettingsForm)this.form).getUniqueId())));
                } else {
                    PrintWriter pw = ExportUtils.getPlainTextWriter(this.response, setting3.getName() + ".txt");
                    DataProperties properties = null;
                    switch (setting3.getAppearanceType().getSolverType()) {
                        case STUDENT: {
                            properties = this.getStudentSectioningSolverService().createConfig(setting3.getUniqueId(), null);
                            break;
                        }
                        case EXAM: {
                            properties = this.getExaminationSolverService().createConfig(setting3.getUniqueId(), null);
                            break;
                        }
                        case INSTRUCTOR: {
                            properties = this.getInstructorSchedulingSolverService().createConfig(setting3.getUniqueId(), null);
                            break;
                        }
                        default: {
                            properties = this.getCourseTimetablingSolverService().createConfig(setting3.getUniqueId(), null);
                        }
                    }
                    pw.println("## Solver Configuration File");
                    pw.println("## Reference: " + setting3.getName());
                    pw.println("## Name: " + setting3.getDescription());
                    pw.println("## Appearance: " + SolverPredefinedSetting.Appearance.values()[setting3.getAppearance()].getLabel());
                    pw.println("## Date: " + new Date());
                    pw.println("######################################");
                    Iterator i = hibSession3.createQuery("select g from SolverParameterGroup g order by g.order").iterate();
                    while (i.hasNext()) {
                        SolverParameterGroup g = (SolverParameterGroup)i.next();
                        if (setting3.getAppearanceType() == SolverPredefinedSetting.Appearance.STUDENT_SOLVER ? g.getSolverType() != SolverParameterGroup.SolverType.STUDENT : (setting3.getAppearanceType() == SolverPredefinedSetting.Appearance.EXAM_SOLVER ? g.getSolverType() != SolverParameterGroup.SolverType.EXAM : (setting3.getAppearanceType() == SolverPredefinedSetting.Appearance.INSTRUCTOR_SOLVER ? g.getSolverType() != SolverParameterGroup.SolverType.INSTRUCTOR : g.getSolverType() != SolverParameterGroup.SolverType.COURSE))) continue;
                        pw.println();
                        pw.println("## " + g.getDescription().replaceAll("<br>", "\n#"));
                        pw.println("######################################");
                        TreeSet<SolverParameterDef> parameters = new TreeSet<SolverParameterDef>(g.getParameters());
                        for (SolverParameterDef p : parameters) {
                            String value = properties.getProperty(p.getName(), p.getDefault());
                            if (value == null) continue;
                            pw.println("## " + p.getDescription().replaceAll("<br>", "\n#"));
                            pw.println("## Type: " + p.getType());
                            if (value != null && !value.equals(p.getDefault())) {
                                pw.println("## Default: " + p.getDefault());
                            }
                            pw.println(p.getName() + "=" + properties.getProperty(p.getName(), p.getDefault()));
                            properties.remove((Object)p.getName());
                        }
                    }
                    pw.println();
                    pw.println("## Other Properties");
                    pw.println("######################################");
                    Enumeration e = properties.propertyNames();
                    while (e.hasMoreElements()) {
                        String name = (String)e.nextElement();
                        pw.println(name + "=" + properties.getProperty(name));
                    }
                    pw.flush();
                    pw.close();
                    return null;
                }
            }
        }
        if (MSG.actionDeleteSolverConfig().equals(this.op)) {
            tx = null;
            try {
                dao = new SolverPredefinedSettingDAO();
                hibSession = dao.getSession();
                if (hibSession.getTransaction() == null || !hibSession.getTransaction().isActive()) {
                    tx = hibSession.beginTransaction();
                }
                setting = (SolverPredefinedSetting)dao.get(((SolverSettingsForm)this.form).getUniqueId(), hibSession);
                dao.delete(setting, hibSession);
                if (tx != null) {
                    tx.commit();
                }
            }
            catch (Exception e) {
                if (tx != null) {
                    tx.rollback();
                }
                Debug.error(e);
            }
            ((SolverSettingsForm)this.form).reset();
            ((SolverSettingsForm)this.form).setOp(MSG.actionAddNewSolverConfig());
        }
        if (MSG.actionAddNewSolverConfig().equals(((SolverSettingsForm)this.form).getOp())) {
            return "list";
        }
        return MSG.actionSaveSolverConfig().equals(((SolverSettingsForm)this.form).getOp()) ? "add" : "edit";
    }

    public String getSolverSettingsTable() {
        Transaction tx = null;
        WebTable.setOrder(this.sessionContext, "solverSettings.ord", this.request.getParameter("ord"), 1);
        WebTable webTable = new WebTable(4, null, "solverSettings.action?ord=%%", new String[]{MSG.fieldReference(), MSG.fieldName(), MSG.fieldAppearance()}, new String[]{"left", "left", "left"}, null);
        try {
            List list;
            SolverPredefinedSettingDAO dao = new SolverPredefinedSettingDAO();
            Session hibSession = dao.getSession();
            if (hibSession.getTransaction() == null || !hibSession.getTransaction().isActive()) {
                tx = hibSession.beginTransaction();
            }
            if ((list = hibSession.createCriteria(SolverPredefinedSetting.class).list()).isEmpty()) {
                webTable.addLine(null, new String[]{MSG.infoNoSolverConfigs()}, null, null);
            } else {
                for (SolverPredefinedSetting setting : list) {
                    String onClick = "onClick=\"document.location='solverSettings.action?op=Edit&id=" + setting.getUniqueId() + "';\"";
                    webTable.addLine(onClick, new String[]{setting.getName(), setting.getDescription(), setting.getAppearanceType().getLabel()}, new Comparable[]{setting.getName(), setting.getDescription(), setting.getAppearance()});
                }
            }
            if (tx != null) {
                tx.commit();
            }
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            throw e;
        }
        return webTable.printTable(WebTable.getOrder(this.sessionContext, "solverSettings.ord"));
    }

    public List<SolverParameterGroup> getSolverParameterGroups() {
        return SolverParameterGroupDAO.getInstance().getSession().createQuery("from SolverParameterGroup order by order").list();
    }
}

