/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.text.ParseException;
import java.util.Date;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.tiles.annotation.TilesDefinition;
import org.apache.struts2.tiles.annotation.TilesDefinitions;
import org.apache.struts2.tiles.annotation.TilesPutAttribute;
import org.hibernate.Transaction;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.form.SessionEditForm;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.ClassDurationType;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.Event;
import org.unitime.timetable.model.EventContact;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.InstructionalMethod;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.StudentSectioningQueue;
import org.unitime.timetable.model.StudentSectioningStatus;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.model.dao.ClassDurationTypeDAO;
import org.unitime.timetable.model.dao.DatePatternDAO;
import org.unitime.timetable.model.dao.InstructionalMethodDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao.StudentSectioningStatusDAO;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.Formats;
import org.unitime.timetable.util.LookupTables;

@Action(value="sessionEdit", results={@Result(name={"showAdd"}, type="tiles", location="sessionAdd.tiles"), @Result(name={"showEdit"}, type="tiles", location="sessionEdit.tiles"), @Result(name={"showSessionList"}, type="redirect", location="/sessionList.action")})
@TilesDefinitions(value={@TilesDefinition(name="sessionAdd.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Add Academic Session"), @TilesPutAttribute(name="body", value="/admin/sessionEdit.jsp")}), @TilesDefinition(name="sessionEdit.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Edit Academic Session"), @TilesPutAttribute(name="body", value="/admin/sessionEdit.jsp")})})
public class SessionEditAction
extends UniTimeAction<SessionEditForm> {
    private static final long serialVersionUID = 8818504076997048439L;
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    private Long sessionId;
    private Boolean refresh;

    public Long getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(Long sessionId) {
        this.sessionId = sessionId;
    }

    public Boolean getRefresh() {
        return this.refresh;
    }

    public void setRefresh(Boolean refresh) {
        this.refresh = refresh;
    }

    public String execute() throws Exception {
        if (this.form == null) {
            this.form = new SessionEditForm();
        }
        if (MSG.actionAddAcademicSession().equals(this.op)) {
            return this.addSession();
        }
        if (MSG.actionSaveAcademicSession().equals(this.op)) {
            return this.saveSession();
        }
        if (MSG.actionUpdateAcademicSession().equals(this.op)) {
            return this.saveSession();
        }
        if ("editSession".equals(this.op)) {
            return this.editSession();
        }
        if (MSG.actionDeleteAcademicSession().equals(this.op)) {
            return this.deleteSession();
        }
        if (MSG.actionBackToAcademicSessions().equals(this.op)) {
            return this.cancelSessionEdit();
        }
        return "showSessionList";
    }

    public String editSession() throws Exception {
        Session acadSession = Session.getSessionById(this.sessionId);
        this.sessionContext.checkPermission(acadSession, Right.AcademicSessionEdit);
        ((SessionEditForm)this.form).setIncludeTestSession(this.sessionContext.hasPermission(Right.AllowTestSessions));
        ((SessionEditForm)this.form).setSession(acadSession);
        DatePattern d = acadSession.getDefaultDatePattern();
        if (d != null) {
            ((SessionEditForm)this.form).setDefaultDatePatternId(d.getUniqueId());
            ((SessionEditForm)this.form).setDefaultDatePatternLabel(d.getName());
        } else {
            ((SessionEditForm)this.form).setDefaultDatePatternId(-1L);
            ((SessionEditForm)this.form).setDefaultDatePatternLabel(MSG.infoNoDefaultDatePattern());
        }
        ((SessionEditForm)this.form).setAcademicInitiative(acadSession.getAcademicInitiative());
        ((SessionEditForm)this.form).setAcademicYear(acadSession.getAcademicYear());
        ((SessionEditForm)this.form).setAcademicTerm(acadSession.getAcademicTerm());
        Formats.Format<Date> sdf = Formats.getDateFormat(Formats.Pattern.DATE_ENTRY_FORMAT);
        ((SessionEditForm)this.form).setSessionStart(sdf.format(acadSession.getSessionBeginDateTime()));
        ((SessionEditForm)this.form).setSessionEnd(sdf.format(acadSession.getSessionEndDateTime()));
        ((SessionEditForm)this.form).setClassesEnd(sdf.format(acadSession.getClassesEndDateTime()));
        ((SessionEditForm)this.form).setExamStart(acadSession.getExamBeginDate() == null ? "" : sdf.format(acadSession.getExamBeginDate()));
        ((SessionEditForm)this.form).setEventStart(acadSession.getEventBeginDate() == null ? "" : sdf.format(acadSession.getEventBeginDate()));
        ((SessionEditForm)this.form).setEventEnd(acadSession.getEventEndDate() == null ? "" : sdf.format(acadSession.getEventEndDate()));
        LookupTables.setupDatePatterns(this.request, this.sessionId, false, Constants.BLANK_OPTION_LABEL, null, null, null);
        this.request.setAttribute("holidays", (Object)((SessionEditForm)this.form).getSession().getHolidaysHtml());
        ((SessionEditForm)this.form).setWkEnroll(acadSession.getLastWeekToEnroll());
        ((SessionEditForm)this.form).setWkChange(acadSession.getLastWeekToChange());
        ((SessionEditForm)this.form).setWkDrop(acadSession.getLastWeekToDrop());
        ((SessionEditForm)this.form).setSectStatus(acadSession.getDefaultSectioningStatus() == null ? -1L : acadSession.getDefaultSectioningStatus().getUniqueId());
        ((SessionEditForm)this.form).setDurationType(acadSession.getDefaultClassDurationType() == null ? -1L : acadSession.getDefaultClassDurationType().getUniqueId());
        ((SessionEditForm)this.form).setInstructionalMethod(acadSession.getDefaultInstructionalMethod() == null ? -1L : acadSession.getDefaultInstructionalMethod().getUniqueId());
        return "showEdit";
    }

    public String deleteSession() throws Exception {
        Long id = ((SessionEditForm)this.form).getSessionId();
        if (id.equals(this.sessionContext.getUser().getCurrentAcademicSessionId())) {
            this.addFieldError("form.sessionId", MSG.errorCannotDeleteCurrentAcademicSession());
            return "showEdit";
        }
        this.sessionContext.checkPermission(id, "Session", Right.AcademicSessionDelete);
        Session.deleteSessionById(id);
        return "showSessionList";
    }

    public String addSession() throws Exception {
        this.sessionContext.checkPermission(Right.AcademicSessionAdd);
        ((SessionEditForm)this.form).setIncludeTestSession(this.sessionContext.hasPermission(Right.AllowTestSessions));
        return "showAdd";
    }

    public String saveSession() throws Exception {
        if (((SessionEditForm)this.form).getSessionId() == null || ((SessionEditForm)this.form).getSessionId().equals(0L)) {
            this.sessionContext.checkPermission(Right.AcademicSessionAdd);
        } else {
            this.sessionContext.checkPermission(((SessionEditForm)this.form).getSessionId(), "Session", Right.AcademicSessionEdit);
        }
        if (Boolean.TRUE.equals(this.refresh)) {
            Session sessn = ((SessionEditForm)this.form).getSession();
            this.setHolidays(sessn);
            if (((SessionEditForm)this.form).getSessionId() != null) {
                LookupTables.setupDatePatterns(this.request, ((SessionEditForm)this.form).getSessionId(), false, Constants.BLANK_OPTION_LABEL, null, null, null);
                if (!this.hasFieldErrors()) {
                    this.request.setAttribute("holidays", (Object)sessn.getHolidaysHtml());
                }
                return "showEdit";
            }
            return "showAdd";
        }
        Transaction tx = null;
        org.hibernate.Session hibSession = SessionDAO.getInstance().getSession();
        try {
            EventContact contact;
            tx = hibSession.beginTransaction();
            Session sessn = ((SessionEditForm)this.form).getSession();
            if (((SessionEditForm)this.form).getSessionId() != null && !sessn.getSessionId().equals(0L)) {
                sessn = (Session)new SessionDAO().get(((SessionEditForm)this.form).getSessionId(), hibSession);
            } else {
                sessn.setSessionId(null);
            }
            ((SessionEditForm)this.form).validate(this);
            if (this.hasFieldErrors()) {
                if (sessn.getSessionId() != null) {
                    LookupTables.setupDatePatterns(this.request, sessn.getSessionId(), false, Constants.BLANK_OPTION_LABEL, null, null, null);
                    this.request.setAttribute("holidays", (Object)sessn.getHolidaysHtml());
                    return "showEdit";
                }
                this.setHolidays(sessn);
                return "showAdd";
            }
            if (((SessionEditForm)this.form).getDefaultDatePatternId() != null && ((SessionEditForm)this.form).getDefaultDatePatternId() >= 0L) {
                DatePattern d = (DatePattern)new DatePatternDAO().get(((SessionEditForm)this.form).getDefaultDatePatternId());
                sessn.setDefaultDatePattern(d);
            } else {
                sessn.setDefaultDatePattern(null);
            }
            sessn.setAcademicInitiative(((SessionEditForm)this.form).getAcademicInitiative());
            sessn.setStatusType(((SessionEditForm)this.form).getStatusType());
            this.setSessionData(sessn);
            hibSession.saveOrUpdate((Object)sessn);
            ChangeLog.addChange(hibSession, this.sessionContext, sessn, ChangeLog.Source.SESSION_EDIT, ChangeLog.Operation.UPDATE, null, null);
            if (((SessionEditForm)this.form).getSessionId() != null) {
                StudentSectioningQueue.sessionStatusChanged(hibSession, this.sessionContext.getUser(), ((SessionEditForm)this.form).getSessionId(), false);
            }
            if ((contact = EventContact.findByExternalUniqueId(this.sessionContext.getUser().getExternalUserId())) == null) {
                contact = new EventContact();
                TimetableManager manager = TimetableManager.findByExternalId(this.sessionContext.getUser().getExternalUserId());
                if (manager != null) {
                    contact.setFirstName(manager.getFirstName());
                    contact.setMiddleName(manager.getMiddleName());
                    contact.setLastName(manager.getLastName());
                    contact.setExternalUniqueId(manager.getExternalUniqueId());
                    contact.setEmailAddress(manager.getEmailAddress());
                } else {
                    String[] name = this.sessionContext.getUser().getName().split(" ");
                    String fname = name.length >= 2 ? name[0] : "";
                    String lname = name.length >= 1 ? name[name.length - 1] : this.sessionContext.getUser().getName();
                    String mname = null;
                    if (name.length >= 3) {
                        for (int i = 1; i < name.length - 1; ++i) {
                            fname = fname == null ? "" : fname + " ";
                            fname = fname + name[i];
                        }
                    }
                    contact.setFirstName(fname);
                    contact.setMiddleName(mname);
                    contact.setLastName(lname);
                    contact.setExternalUniqueId(this.sessionContext.getUser().getExternalUserId());
                    contact.setEmailAddress(this.sessionContext.getUser().getEmail());
                }
                hibSession.save((Object)contact);
            }
            if (sessn.getStatusType().isTestSession()) {
                hibSession.createQuery("delete ExamEvent where exam in (from Exam x where x.session.uniqueId = :sessionId)").setLong("sessionId", sessn.getUniqueId().longValue()).executeUpdate();
                hibSession.createQuery("delete ClassEvent where clazz in (from Class_ c where c.committedAssignment.solution.owner.session.uniqueId = :sessionId)").setLong("sessionId", sessn.getUniqueId().longValue()).executeUpdate();
            } else {
                Event event;
                for (Assignment assignment : hibSession.createQuery("select a from Class_ c inner join c.assignments a inner join a.solution s where s.commited = true and s.owner.session.uniqueId = :sessionId and c.uniqueId not in (select e.clazz.uniqueId from ClassEvent e where e.clazz.controllingDept.session.uniqueId = :sessionId)").setLong("sessionId", sessn.getUniqueId().longValue()).list()) {
                    event = assignment.generateCommittedEvent(null, true);
                    if (event != null && !event.getMeetings().isEmpty()) {
                        event.setMainContact(contact);
                        hibSession.saveOrUpdate((Object)event);
                    }
                    if (event == null || !event.getMeetings().isEmpty() || event.getUniqueId() == null) continue;
                    hibSession.delete((Object)event);
                }
                for (Exam exam : hibSession.createQuery("from Exam x where x.session.uniqueId = :sessionId and x.assignedPeriod != null and x.uniqueId not in (select e.exam.uniqueId from ExamEvent e where e.exam.session.uniqueId = :sessionId)").setLong("sessionId", sessn.getUniqueId().longValue()).list()) {
                    event = exam.generateEvent(null, true);
                    if (event == null) continue;
                    event.setEventName(exam.getLabel());
                    event.setMinCapacity(exam.getSize());
                    event.setMaxCapacity(exam.getSize());
                    event.setMainContact(contact);
                    hibSession.saveOrUpdate((Object)event);
                }
            }
            tx.commit();
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            throw e;
        }
        return "showSessionList";
    }

    private void setHolidays(Session sessn) throws ParseException {
        if (((SessionEditForm)this.form).validateDates(this)) {
            this.setSessionData(sessn);
            this.request.setAttribute("holidays", (Object)sessn.getHolidaysHtml());
        }
    }

    private void setSessionData(Session sessn) throws ParseException {
        Formats.Format<Date> sdf = Formats.getDateFormat(Formats.Pattern.DATE_ENTRY_FORMAT);
        sessn.setAcademicYear(((SessionEditForm)this.form).getAcademicYear());
        sessn.setAcademicTerm(((SessionEditForm)this.form).getAcademicTerm());
        sessn.setSessionBeginDateTime(sdf.parse(((SessionEditForm)this.form).getSessionStart()));
        sessn.setSessionEndDateTime(sdf.parse(((SessionEditForm)this.form).getSessionEnd()));
        sessn.setClassesEndDateTime(sdf.parse(((SessionEditForm)this.form).getClassesEnd()));
        sessn.setExamBeginDate(sdf.parse(((SessionEditForm)this.form).getExamStart()));
        sessn.setEventBeginDate(sdf.parse(((SessionEditForm)this.form).getEventStart()));
        sessn.setEventEndDate(sdf.parse(((SessionEditForm)this.form).getEventEnd()));
        sessn.setHolidays(this.request);
        sessn.setLastWeekToEnroll(((SessionEditForm)this.form).getWkEnroll());
        sessn.setLastWeekToChange(((SessionEditForm)this.form).getWkChange());
        sessn.setLastWeekToDrop(((SessionEditForm)this.form).getWkDrop());
        sessn.setDefaultSectioningStatus(((SessionEditForm)this.form).getSectStatus() == null || ((SessionEditForm)this.form).getSectStatus() < 0L ? null : (StudentSectioningStatus)StudentSectioningStatusDAO.getInstance().get(((SessionEditForm)this.form).getSectStatus()));
        sessn.setDefaultClassDurationType(((SessionEditForm)this.form).getDurationType() == null || ((SessionEditForm)this.form).getDurationType() < 0L ? null : (ClassDurationType)ClassDurationTypeDAO.getInstance().get(((SessionEditForm)this.form).getDurationType()));
        sessn.setDefaultInstructionalMethod(((SessionEditForm)this.form).getInstructionalMethod() == null || ((SessionEditForm)this.form).getInstructionalMethod() < 0L ? null : (InstructionalMethod)InstructionalMethodDAO.getInstance().get(((SessionEditForm)this.form).getInstructionalMethod()));
    }

    public String cancelSessionEdit() {
        return "showSessionList";
    }
}

