/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.tiles.annotation.TilesDefinition;
import org.apache.struts2.tiles.annotation.TilesPutAttribute;
import org.unitime.commons.web.WebTable;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.form.RollForwardSessionForm;
import org.unitime.timetable.gwt.command.server.GwtRpcServlet;
import org.unitime.timetable.gwt.shared.ReservationInterface;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.PointInTimeData;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.dao.PointInTimeDataDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.Formats;
import org.unitime.timetable.util.SessionRollForward;
import org.unitime.timetable.util.queue.QueueItem;

@Action(value="rollForwardSession", results={@Result(name={"displayRollForwardSessionForm"}, type="tiles", location="rollForwardSession.tiles")})
@TilesDefinition(name="rollForwardSession.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Roll Forward Session"), @TilesPutAttribute(name="body", value="/admin/rollForwardSession.jsp")})
public class RollForwardSessionAction
extends UniTimeAction<RollForwardSessionForm> {
    private static final long serialVersionUID = -5982958315864704198L;
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    private String remove;

    public String getRemove() {
        return this.remove;
    }

    public void setRemove(String remove) {
        this.remove = remove;
    }

    public String execute() throws Exception {
        WebTable queueTable;
        if (this.form == null) {
            this.form = new RollForwardSessionForm();
        }
        if (MSG.actionRollForward().equals(this.op)) {
            this.sessionContext.checkPermission(Right.SessionRollForward);
            ((RollForwardSessionForm)this.form).validate(this);
            if (!this.hasFieldErrors()) {
                this.getSolverServerService().getQueueProcessor().add(new RollForwardQueueItem((Session)SessionDAO.getInstance().get(((RollForwardSessionForm)this.form).getSessionToRollForwardTo()), this.sessionContext.getUser(), (RollForwardSessionForm)((RollForwardSessionForm)this.form).clone()));
            }
        }
        if (this.remove != null && !this.remove.isEmpty()) {
            this.getSolverServerService().getQueueProcessor().remove(this.remove);
        }
        if ((queueTable = this.getQueueTable()) != null && !queueTable.getLines().isEmpty()) {
            this.request.setAttribute("table", (Object)queueTable.printTable(WebTable.getOrder(this.sessionContext, "rollForwardSession.ord")));
        }
        this.setToFromSessionsInForm();
        ((RollForwardSessionForm)this.form).setSubjectAreas(this.getSubjectAreas(((RollForwardSessionForm)this.form).getSessionToRollForwardTo()));
        ((RollForwardSessionForm)this.form).setDepartments(this.getDepartments(((RollForwardSessionForm)this.form).getSessionToRollForwardTo()));
        ((RollForwardSessionForm)this.form).setFromPointInTimeDataSnapshots(this.getPointInTimeDataSnapshots(((RollForwardSessionForm)this.form).getSessionToRollForwardTo()));
        if (this.op == null) {
            this.setExpirationDates((RollForwardSessionForm)this.form);
        }
        if (((RollForwardSessionForm)this.form).getSubpartLocationPrefsAction() == null) {
            ((RollForwardSessionForm)this.form).setSubpartLocationPrefsAction(SessionRollForward.ROLL_PREFS_ACTION);
        }
        if (((RollForwardSessionForm)this.form).getSubpartTimePrefsAction() == null) {
            ((RollForwardSessionForm)this.form).setSubpartTimePrefsAction(SessionRollForward.ROLL_PREFS_ACTION);
        }
        if (((RollForwardSessionForm)this.form).getClassPrefsAction() == null) {
            ((RollForwardSessionForm)this.form).setClassPrefsAction(SessionRollForward.DO_NOT_ROLL_ACTION);
        }
        if (((RollForwardSessionForm)this.form).getRollForwardDistributions() == null) {
            ((RollForwardSessionForm)this.form).setRollForwardDistributions(SessionRollForward.DistributionMode.MIXED.name());
        }
        if (((RollForwardSessionForm)this.form).getCancelledClassAction() == null) {
            ((RollForwardSessionForm)this.form).setCancelledClassAction(SessionRollForward.CancelledClassAction.REOPEN.name());
        }
        if (((RollForwardSessionForm)this.form).getMidtermExamsPrefsAction() == null) {
            ((RollForwardSessionForm)this.form).setMidtermExamsPrefsAction(SessionRollForward.EXAMS_ROOM_PREFS);
        }
        if (((RollForwardSessionForm)this.form).getFinalExamsPrefsAction() == null) {
            ((RollForwardSessionForm)this.form).setFinalExamsPrefsAction(SessionRollForward.EXAMS_ROOM_PREFS);
        }
        return "displayRollForwardSessionForm";
    }

    public WebTable getQueueTable() {
        WebTable.setOrder(this.sessionContext, "rollForwardSession.ord", this.request.getParameter("ord"), 1);
        String log = this.request.getParameter("log");
        Formats.Format<Date> df = Formats.getDateFormat(Formats.Pattern.TIME_SHORT);
        List<QueueItem> queue = this.getSolverServerService().getQueueProcessor().getItems(null, null, "Roll Forward");
        if (queue.isEmpty()) {
            return null;
        }
        WebTable table = new WebTable(9, null, "rollForwardSession.action?ord=%%", new String[]{MSG.fieldQueueName(), MSG.fieldQueueStatus(), MSG.fieldQueueProgress(), MSG.fieldQueueOwner(), MSG.fieldQueueSession(), MSG.fieldQueueCreated(), MSG.fieldQueueStarted(), MSG.fieldQueueFinished(), MSG.fieldQueueOutput()}, new String[]{"left", "left", "right", "left", "left", "left", "left", "left", "center"}, new boolean[]{true, true, true, true, true, true, true, true, true});
        Date now = new Date();
        long timeToShow = 86400000L;
        for (QueueItem item : queue) {
            if (item.finished() != null && now.getTime() - item.finished().getTime() > timeToShow || item.getSession() == null) continue;
            String name = item.name();
            if (name.length() > 60) {
                name = name.substring(0, 57) + "...";
            }
            String delete = null;
            if (this.sessionContext.getUser().getExternalUserId().equals(item.getOwnerId()) && (item.started() == null || item.finished() != null)) {
                delete = "<img src='images/action_delete.png' border='0' onClick=\"if (confirm('Do you really want to remove this roll forward?')) document.location='rollForwardSession.action?remove=" + item.getId() + "'; event.cancelBubble=true;\">";
            }
            WebTable.WebTableLine line = table.addLine("onClick=\"document.location='rollForwardSession.action?log=" + item.getId() + "';\"", new String[]{name + (delete == null ? "" : " " + delete), item.status(), item.progress() <= 0.0 || item.progress() >= 1.0 ? "" : String.valueOf(Math.round(100.0 * item.progress())) + "%", item.getOwnerName(), item.getSession().getLabel(), df.format(item.created()), item.started() == null ? "" : df.format(item.started()), item.finished() == null ? "" : df.format(item.finished()), item.hasOutput() ? "<A href='" + item.getOutputLink() + "'>" + item.getOutputName().substring(item.getOutputName().lastIndexOf(46) + 1).toUpperCase() + "</A>" : ""}, new Comparable[]{Long.valueOf(item.created().getTime()), item.status(), Double.valueOf(item.progress()), item.getOwnerName(), item.getSession(), Long.valueOf(item.created().getTime()), Long.valueOf(item.started() == null ? Long.MAX_VALUE : item.started().getTime()), Long.valueOf(item.finished() == null ? Long.MAX_VALUE : item.finished().getTime()), null});
            if (log == null || !log.equals(item.getId().toString())) continue;
            this.request.setAttribute("logname", (Object)name);
            this.request.setAttribute("logid", (Object)item.getId().toString());
            this.request.setAttribute("log", (Object)item.log());
            ((RollForwardQueueItem)item).getForm().copyTo((RollForwardSessionForm)this.form);
            this.saveErrors(((RollForwardQueueItem)item).getErrors());
            line.setBgColor("rgb(168,187,225)");
        }
        return table;
    }

    protected void saveErrors(List<RollForwardError> errors) {
        if (errors != null) {
            for (RollForwardError e : errors) {
                this.addFieldError(e.getType(), e.getMessage());
            }
        }
    }

    protected void setToFromSessionsInForm() {
        ArrayList<Session> sessionList = new ArrayList<Session>();
        sessionList.addAll(Session.getAllSessions());
        ((RollForwardSessionForm)this.form).setFromSessions(new ArrayList<Session>());
        ((RollForwardSessionForm)this.form).setToSessions(new ArrayList<Session>());
        Session session = null;
        for (int i = sessionList.size() - 1; i >= 0; --i) {
            session = (Session)sessionList.get(i);
            if (session.getStatusType().isAllowRollForward()) {
                ((RollForwardSessionForm)this.form).getToSessions().add(session);
                if (((RollForwardSessionForm)this.form).getSessionToRollForwardTo() != null) continue;
                ((RollForwardSessionForm)this.form).setSessionToRollForwardTo(session.getUniqueId());
                continue;
            }
            ((RollForwardSessionForm)this.form).getFromSessions().add(session);
        }
    }

    protected Set<SubjectArea> getSubjectAreas(Long selectedSessionId) {
        Set<SubjectArea> subjects = new TreeSet<SubjectArea>();
        Session session = null;
        if (selectedSessionId == null) {
            boolean found = false;
            TreeSet<Session> allSessions = Session.getAllSessions();
            ArrayList<Session> sessionList = new ArrayList<Session>();
            sessionList.addAll(Session.getAllSessions());
            for (int i = sessionList.size() - 1; i >= 0; --i) {
                session = (Session)sessionList.get(i);
                if (!session.getStatusType().isAllowRollForward()) continue;
                found = true;
            }
            if (!found) {
                session = null;
                if (allSessions.size() > 0) {
                    session = allSessions.last();
                }
            }
        } else {
            session = Session.getSessionById(selectedSessionId);
        }
        if (session != null) {
            subjects = session.getSubjectAreas();
        }
        return subjects;
    }

    protected Set<Department> getDepartments(Long selectedSessionId) {
        Set<Department> departments = new TreeSet<Department>();
        Session session = null;
        if (selectedSessionId == null) {
            boolean found = false;
            TreeSet<Session> allSessions = Session.getAllSessions();
            ArrayList<Session> sessionList = new ArrayList<Session>();
            sessionList.addAll(Session.getAllSessions());
            for (int i = sessionList.size() - 1; i >= 0; --i) {
                session = (Session)sessionList.get(i);
                if (!session.getStatusType().isAllowRollForward()) continue;
                found = true;
            }
            if (!found) {
                session = null;
                if (allSessions.size() > 0) {
                    session = allSessions.last();
                }
            }
        } else {
            session = Session.getSessionById(selectedSessionId);
        }
        if (session != null) {
            departments = session.getDepartments();
        }
        return departments;
    }

    protected Set<PointInTimeData> getPointInTimeDataSnapshots(Long selectedSessionId) {
        TreeSet<PointInTimeData> pointInTimeDataSnapshots = new TreeSet<PointInTimeData>();
        if (selectedSessionId != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("from PointInTimeData pitd where pitd.session.uniqueId in (select distinct rfio.session ").append(" from InstructionalOffering rfio, Session s inner join s.instructionalOfferings as io ").append(" where s.uniqueId = :sessId ").append(" and rfio.uniqueId = io.uniqueIdRolledForwardFrom )").append(" and pitd.savedSuccessfully = true ");
            pointInTimeDataSnapshots.addAll(PointInTimeDataDAO.getInstance().getSession().createQuery(sb.toString()).setLong("sessId", selectedSessionId.longValue()).list());
        }
        return pointInTimeDataSnapshots;
    }

    protected void setExpirationDates(RollForwardSessionForm form) {
        if (form.getSessionToRollForwardTo() != null) {
            ReservationInterface.DefaultExpirationDates dates = GwtRpcServlet.execute(new ReservationInterface.ReservationDefaultExpirationDatesRpcRequest(form.getSessionToRollForwardTo()), this.getApplicationContext(), this.sessionContext);
            if (dates != null) {
                Formats.Format<Date> df = Formats.getDateFormat(Formats.Pattern.DATE_ENTRY_FORMAT);
                form.setExpirationCourseReservations(dates.hasExpirationDate("course") ? df.format(dates.getExpirationDate("course")) : null);
                form.setExpirationCurriculumReservations(dates.hasExpirationDate("curriculum") ? df.format(dates.getExpirationDate("curriculum")) : null);
                form.setExpirationGroupReservations(dates.hasExpirationDate("group") ? df.format(dates.getExpirationDate("group")) : null);
                form.setStartDateCourseReservations(dates.hasStartDate("course") ? df.format(dates.getStartDate("course")) : null);
                form.setStartDateCurriculumReservations(dates.hasStartDate("curriculum") ? df.format(dates.getStartDate("curriculum")) : null);
                form.setStartDateGroupReservations(dates.hasStartDate("group") ? df.format(dates.getStartDate("group")) : null);
            }
        } else {
            form.setExpirationCourseReservations(null);
            form.setExpirationCurriculumReservations(null);
            form.setExpirationGroupReservations(null);
            form.setStartDateCourseReservations(null);
            form.setStartDateCurriculumReservations(null);
            form.setStartDateGroupReservations(null);
        }
    }

    private static class RollForwardQueueItem
    extends QueueItem {
        private static final long serialVersionUID = 1L;
        private RollForwardSessionForm iForm;
        private int iProgress = 0;
        private RollForwardErrors iErrors = new RollForwardErrors();

        public RollForwardQueueItem(Session session, UserContext owner, RollForwardSessionForm form) {
            super(session, owner);
            this.iForm = form;
        }

        public RollForwardErrors getErrors() {
            return this.iErrors;
        }

        public RollForwardSessionForm getForm() {
            return this.iForm;
        }

        @Override
        public void error(Object message, Throwable t) {
            super.error(message, t);
            this.setError(t);
        }

        @Override
        protected void execute() throws Exception {
            SessionRollForward sessionRollForward = new SessionRollForward(this);
            Session toAcadSession = Session.getSessionById(this.iForm.getSessionToRollForwardTo());
            if (toAcadSession == null) {
                this.iErrors.addFieldError("mustSelectSession", MSG.errorRollForwardMissingToSession());
            }
            if (this.iErrors.isEmpty()) {
                this.iForm.validateDepartmentRollForward(toAcadSession, this.iErrors);
            }
            if (this.iErrors.isEmpty() && this.iForm.getRollForwardDepartments().booleanValue()) {
                this.setStatus(MSG.rollForwardDepartments() + " ...");
                sessionRollForward.rollDepartmentsForward(this.iErrors, this.iForm);
            }
            ++this.iProgress;
            if (this.iErrors.isEmpty() && this.iForm.getRollForwardSessionConfig().booleanValue()) {
                this.setStatus(MSG.rollForwardSessionConfiguration() + " ...");
                sessionRollForward.rollSessionConfigurationForward(this.iErrors, this.iForm);
            }
            ++this.iProgress;
            if (this.iErrors.isEmpty()) {
                this.iForm.validateManagerRollForward(toAcadSession, this.iErrors);
            }
            if (this.iErrors.isEmpty() && this.iForm.getRollForwardManagers().booleanValue()) {
                this.setStatus(MSG.rollForwardManagers() + " ...");
                sessionRollForward.rollManagersForward(this.iErrors, this.iForm);
            }
            ++this.iProgress;
            if (this.iErrors.isEmpty()) {
                this.iForm.validateBuildingAndRoomRollForward(toAcadSession, this.iErrors);
            }
            if (this.iErrors.isEmpty() && this.iForm.getRollForwardRoomData().booleanValue()) {
                this.setStatus(MSG.rollForwardRooms() + " ...");
                sessionRollForward.rollBuildingAndRoomDataForward(this.iErrors, this.iForm);
            }
            ++this.iProgress;
            if (this.iErrors.isEmpty()) {
                this.iForm.validateDatePatternRollForward(toAcadSession, this.iErrors);
            }
            if (this.iErrors.isEmpty() && this.iForm.getRollForwardDatePatterns().booleanValue()) {
                this.setStatus(MSG.rollForwardDatePatterns() + " ...");
                sessionRollForward.rollDatePatternsForward(this.iErrors, this.iForm);
            }
            ++this.iProgress;
            if (this.iErrors.isEmpty()) {
                this.iForm.validateTimePatternRollForward(toAcadSession, this.iErrors);
            }
            if (this.iErrors.isEmpty() && this.iForm.getRollForwardTimePatterns().booleanValue()) {
                this.setStatus(MSG.rollForwardTimePatterns() + " ...");
                sessionRollForward.rollTimePatternsForward(this.iErrors, this.iForm);
            }
            ++this.iProgress;
            if (this.iErrors.isEmpty()) {
                this.iForm.validateSubjectAreaRollForward(toAcadSession, this.iErrors);
            }
            if (this.iErrors.isEmpty()) {
                this.iForm.validateLearningManagementSystemRollForward(toAcadSession, this.iErrors);
            }
            if (this.iErrors.isEmpty() && this.iForm.getRollForwardLearningManagementSystems().booleanValue()) {
                this.setStatus(MSG.rollForwardLMSInfo() + " ...");
                sessionRollForward.rollLearningManagementSystemInfoForward(this.iErrors, this.iForm);
            }
            ++this.iProgress;
            if (this.iErrors.isEmpty() && this.iForm.getRollForwardSubjectAreas().booleanValue()) {
                this.setStatus(MSG.rollForwardSubjectAreas() + " ...");
                sessionRollForward.rollSubjectAreasForward(this.iErrors, this.iForm);
            }
            ++this.iProgress;
            if (this.iErrors.isEmpty() && this.iForm.getRollForwardInstructorData().booleanValue()) {
                this.setStatus(MSG.rollForwardInstructors() + " ...");
                sessionRollForward.rollInstructorDataForward(this.iErrors, this.iForm);
            }
            ++this.iProgress;
            if (this.iErrors.isEmpty()) {
                this.iForm.validateCourseOfferingRollForward(toAcadSession, this.iErrors);
            }
            if (this.iErrors.isEmpty() && this.iForm.getRollForwardCourseOfferings().booleanValue()) {
                this.setStatus(MSG.rollForwardCourseOfferings() + " ...");
                sessionRollForward.rollCourseOfferingsForward(this.iErrors, this.iForm);
            }
            ++this.iProgress;
            if (this.iErrors.isEmpty()) {
                this.iForm.validateClassInstructorRollForward(toAcadSession, this.iErrors);
            }
            if (this.iErrors.isEmpty() && this.iForm.getRollForwardClassInstructors().booleanValue()) {
                this.setStatus(MSG.rollForwardClassInstructors() + " ...");
                sessionRollForward.rollClassInstructorsForward(this.iErrors, this.iForm);
            }
            ++this.iProgress;
            if (this.iErrors.isEmpty()) {
                this.iForm.validateOfferingCoordinatorsRollForward(toAcadSession, this.iErrors);
            }
            if (this.iErrors.isEmpty() && this.iForm.getRollForwardOfferingCoordinators().booleanValue()) {
                this.setStatus(MSG.rollForwardOfferingCoordinators() + " ...");
                sessionRollForward.rollOfferingCoordinatorsForward(this.iErrors, this.iForm);
            }
            ++this.iProgress;
            if (this.iErrors.isEmpty()) {
                this.iForm.validateTeachingRequestsRollForward(toAcadSession, this.iErrors);
            }
            if (this.iErrors.isEmpty() && this.iForm.getRollForwardTeachingRequests().booleanValue()) {
                this.setStatus(MSG.rollForwardTeachingRequests() + " ...");
                sessionRollForward.rollTeachingRequestsForward(this.iErrors, this.iForm);
            }
            ++this.iProgress;
            if (this.iErrors.isEmpty() && this.iForm.getAddNewCourseOfferings().booleanValue()) {
                this.setStatus(MSG.rollForwardNewCourses() + " ...");
                sessionRollForward.addNewCourseOfferings(this.iErrors, this.iForm);
            }
            ++this.iProgress;
            if (this.iErrors.isEmpty()) {
                this.iForm.validateExamConfigurationRollForward(toAcadSession, this.iErrors);
            }
            if (this.iErrors.isEmpty() && this.iForm.getRollForwardExamConfiguration().booleanValue()) {
                this.setStatus(MSG.rollForwardExamConfiguration() + " ...");
                sessionRollForward.rollExamConfigurationDataForward(this.iErrors, this.iForm);
            }
            ++this.iProgress;
            if (this.iErrors.isEmpty()) {
                this.iForm.validateMidtermExamRollForward(toAcadSession, this.iErrors);
            }
            if (this.iErrors.isEmpty() && this.iForm.getRollForwardMidtermExams().booleanValue()) {
                this.setStatus(MSG.rollForwardMidtermExams() + " ...");
                sessionRollForward.rollMidtermExamsForward(this.iErrors, this.iForm);
            }
            ++this.iProgress;
            if (this.iErrors.isEmpty()) {
                this.iForm.validateFinalExamRollForward(toAcadSession, this.iErrors);
            }
            if (this.iErrors.isEmpty() && this.iForm.getRollForwardFinalExams().booleanValue()) {
                this.setStatus(MSG.rollForwardFinalExams() + " ...");
                sessionRollForward.rollFinalExamsForward(this.iErrors, this.iForm);
            }
            ++this.iProgress;
            if (this.iErrors.isEmpty()) {
                this.iForm.validateLastLikeDemandRollForward(toAcadSession, this.iErrors);
            }
            if (this.iErrors.isEmpty() && this.iForm.getRollForwardStudents().booleanValue()) {
                this.setStatus(MSG.rollForwardStudents() + " ...");
                sessionRollForward.rollStudentsForward(this.iErrors, this.iForm);
            }
            ++this.iProgress;
            if (this.iErrors.isEmpty()) {
                this.iForm.validateCurriculaRollForward(toAcadSession, this.iErrors);
            }
            if (this.iErrors.isEmpty() && this.iForm.getRollForwardCurricula().booleanValue()) {
                this.setStatus(MSG.rollForwardCurricula() + " ...");
                sessionRollForward.rollCurriculaForward(this.iErrors, this.iForm);
            }
            ++this.iProgress;
            if (this.iErrors.isEmpty() && this.iForm.getRollForwardReservations()) {
                this.setStatus(MSG.rollForwardReservations() + " ...");
                sessionRollForward.rollReservationsForward(this.iErrors, this.iForm);
            }
            ++this.iProgress;
            if (this.iErrors.isEmpty() && this.iForm.getRollForwardPeriodicTasks().booleanValue()) {
                this.setStatus(MSG.rollForwardScheduledTasks() + " ...");
                sessionRollForward.rollPeriodicTasksForward(this.iErrors, this.iForm);
            }
            ++this.iProgress;
            if (!this.iErrors.isEmpty()) {
                this.setError(new Exception(((RollForwardError)this.iErrors.get(0)).getMessage()));
            } else {
                this.log(MSG.logAllDone());
            }
        }

        @Override
        public String name() {
            String name;
            ArrayList<String> names = new ArrayList<String>();
            if (this.iForm.getRollForwardDepartments().booleanValue()) {
                names.add(MSG.rollForwardDepartments());
            }
            if (this.iForm.getRollForwardSessionConfig().booleanValue()) {
                names.add(MSG.rollForwardConfiguration());
            }
            if (this.iForm.getRollForwardManagers().booleanValue()) {
                names.add(MSG.rollForwardManagers());
            }
            if (this.iForm.getRollForwardRoomData().booleanValue()) {
                names.add(MSG.rollForwardRooms());
            }
            if (this.iForm.getRollForwardDatePatterns().booleanValue()) {
                names.add(MSG.rollForwardDatePatterns());
            }
            if (this.iForm.getRollForwardTimePatterns().booleanValue()) {
                names.add(MSG.rollForwardTimePatterns());
            }
            if (this.iForm.getRollForwardLearningManagementSystems().booleanValue()) {
                names.add(MSG.rollForwardLMS());
            }
            if (this.iForm.getRollForwardSubjectAreas().booleanValue()) {
                names.add(MSG.rollForwardSubjectAreas());
            }
            if (this.iForm.getRollForwardInstructorData().booleanValue()) {
                names.add(MSG.rollForwardInstructors());
            }
            if (this.iForm.getRollForwardCourseOfferings().booleanValue()) {
                names.add(MSG.rollForwardCourseOfferings());
            }
            if (this.iForm.getRollForwardClassInstructors().booleanValue()) {
                names.add(MSG.rollForwardClassInstructors());
            }
            if (this.iForm.getRollForwardOfferingCoordinators().booleanValue()) {
                names.add(MSG.rollForwardOfferingCoordinators());
            }
            if (this.iForm.getRollForwardTeachingRequests().booleanValue()) {
                names.add(MSG.rollForwardTeachingRequests());
            }
            if (this.iForm.getAddNewCourseOfferings().booleanValue()) {
                names.add(MSG.rollForwardNewCourses());
            }
            if (this.iForm.getRollForwardExamConfiguration().booleanValue()) {
                names.add(MSG.rollForwardExamConfiguration());
            }
            if (this.iForm.getRollForwardMidtermExams().booleanValue()) {
                names.add(MSG.rollForwardMidtermExams());
            }
            if (this.iForm.getRollForwardFinalExams().booleanValue()) {
                names.add(MSG.rollForwardFinalExams());
            }
            if (this.iForm.getRollForwardStudents().booleanValue()) {
                names.add(MSG.rollForwardStudents());
            }
            if (this.iForm.getRollForwardCurricula().booleanValue()) {
                names.add(MSG.rollForwardCurricula());
            }
            if (this.iForm.getRollForwardReservations()) {
                names.add(MSG.rollForwardReservations());
            }
            if (this.iForm.getRollForwardPeriodicTasks().booleanValue()) {
                names.add(MSG.rollForwardScheduledTasks());
            }
            if ((name = ((Object)names).toString().replace("[", "").replace("]", "")).length() > 50) {
                name = name.substring(0, 47) + "...";
            }
            return name;
        }

        @Override
        public double progress() {
            return 100 * this.iProgress / 14;
        }

        @Override
        public String type() {
            return "Roll Forward";
        }
    }

    public static class RollForwardErrors
    extends ArrayList<RollForwardError> {
        private static final long serialVersionUID = 6152383035137322209L;

        public void addFieldError(String type, String message) {
            this.add(new RollForwardError(type, message));
        }
    }

    public static class RollForwardError
    implements Serializable {
        private static final long serialVersionUID = -8383522549018220760L;
        private String iType;
        private String iMessage;

        RollForwardError(String type, String message) {
            this.iType = type;
            this.iMessage = message;
        }

        public String getType() {
            return this.iType;
        }

        public String getMessage() {
            return this.iMessage;
        }
    }
}

