/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.tiles.annotation.TilesDefinition;
import org.apache.struts2.tiles.annotation.TilesDefinitions;
import org.apache.struts2.tiles.annotation.TilesPutAttribute;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.unitime.commons.Debug;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.form.ItypeDescEditForm;
import org.unitime.timetable.model.ItypeDesc;
import org.unitime.timetable.model.dao.ItypeDescDAO;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.LookupTables;

@Action(value="itypeDescEdit", results={@Result(name={"edit"}, type="tiles", location="itypeDescEdit.tiles"), @Result(name={"add"}, type="tiles", location="itypeDescAdd.tiles"), @Result(name={"back"}, type="redirectAction", location="itypeDescList", params={"id", "${form.id}"})})
@TilesDefinitions(value={@TilesDefinition(name="itypeDescEdit.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Edit Instructional Type"), @TilesPutAttribute(name="body", value="/admin/itypeDescEdit.jsp")}), @TilesDefinition(name="itypeDescAdd.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Add Instructional Type"), @TilesPutAttribute(name="body", value="/admin/itypeDescEdit.jsp")})})
public class ItypeDescEditAction
extends UniTimeAction<ItypeDescEditForm> {
    private static final long serialVersionUID = -3956260021665092931L;
    protected static CourseMessages MSG = Localization.create(CourseMessages.class);
    protected Integer id;

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String execute() throws Exception {
        try {
            if (this.form == null) {
                this.form = new ItypeDescEditForm();
            }
            this.sessionContext.checkPermission(Right.InstructionalTypes);
            if (MSG.actionBackITypes().equals(this.op)) {
                return "back";
            }
            if (MSG.actionAddIType().equals(this.op)) {
                this.sessionContext.checkPermission(Right.InstructionalTypeAdd);
            }
            LookupTables.setupItypes(this.request, true);
            if (MSG.actionUpdateIType().equals(this.op) || MSG.actionSaveIType().equals(this.op)) {
                ((ItypeDescEditForm)this.form).validate(this);
                if (this.hasFieldErrors()) {
                    return MSG.actionSaveIType().equals(this.op) ? "add" : "edit";
                }
                Transaction tx = null;
                if (((ItypeDescEditForm)this.form).getUniqueId() == null || ((ItypeDescEditForm)this.form).getUniqueId() < 0) {
                    this.sessionContext.checkPermission(Right.InstructionalTypeAdd);
                } else {
                    this.sessionContext.checkPermission(((ItypeDescEditForm)this.form).getUniqueId(), "ItypeDesc", Right.InstructionalTypeEdit);
                }
                try {
                    Session hibSession = new ItypeDescDAO().getSession();
                    if (hibSession.getTransaction() == null || !hibSession.getTransaction().isActive()) {
                        tx = hibSession.beginTransaction();
                    }
                    ((ItypeDescEditForm)this.form).saveOrUpdate(hibSession);
                    if (tx != null) {
                        tx.commit();
                    }
                }
                catch (Exception e) {
                    if (tx != null) {
                        tx.rollback();
                    }
                    throw e;
                }
                return "back";
            }
            if (this.op == null) {
                this.sessionContext.checkPermission(this.id, "ItypeDesc", Right.InstructionalTypeEdit);
                this.setOp(MSG.actionUpdateIType());
                if (this.id == null) {
                    throw new Exception(MSG.errorRequiredField(MSG.fieldIType()));
                }
                ItypeDesc itype = (ItypeDesc)new ItypeDescDAO().get(Integer.valueOf(this.id));
                if (itype == null) {
                    return "back";
                }
                ((ItypeDescEditForm)this.form).load(itype);
            }
            if (MSG.actionDeleteIType().equals(this.op)) {
                Transaction tx = null;
                this.sessionContext.checkPermission(((ItypeDescEditForm)this.form).getUniqueId(), "ItypeDesc", Right.InstructionalTypeDelete);
                try {
                    Session hibSession = new ItypeDescDAO().getSession();
                    if (hibSession.getTransaction() == null || !hibSession.getTransaction().isActive()) {
                        tx = hibSession.beginTransaction();
                    }
                    ((ItypeDescEditForm)this.form).delete(hibSession);
                    tx.commit();
                }
                catch (Exception e) {
                    if (tx != null) {
                        tx.rollback();
                    }
                    throw e;
                }
                return "back";
            }
            if (MSG.actionAddIType().equals(this.op)) {
                this.setOp(MSG.actionSaveIType());
            }
            return MSG.actionSaveIType().equals(this.getOp()) ? "add" : "edit";
        }
        catch (Exception e) {
            Debug.error(e);
            throw e;
        }
    }
}

