/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.io.Serializable;
import java.util.HashSet;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.tiles.annotation.TilesDefinition;
import org.apache.struts2.tiles.annotation.TilesPutAttribute;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.unitime.commons.Debug;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.InstructorAction;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.form.InstructorEditForm;
import org.unitime.timetable.interfaces.ExternalClassEditAction;
import org.unitime.timetable.interfaces.ExternalUidLookup;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.base.BaseDepartment;
import org.unitime.timetable.model.dao.DepartmentalInstructorDAO;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.webutil.BackTracker;

@Action(value="instructorInfoEdit", results={@Result(name={"showEdit"}, type="tiles", location="instructorInfoEdit.tiles"), @Result(name={"showDetail"}, type="redirect", location="/instructorDetail.action", params={"instructorId", "${form.instructorId}"}), @Result(name={"showList"}, type="redirect", location="/instructorSearch.action")})
@TilesDefinition(name="instructorInfoEdit.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Edit Instructor"), @TilesPutAttribute(name="body", value="/user/instructorInfoEdit.jsp"), @TilesPutAttribute(name="showNavigation", value="true"), @TilesPutAttribute(name="checkRole", value="false")})
public class InstructorInfoEditAction
extends InstructorAction {
    private static final long serialVersionUID = -4279427823049903910L;
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);

    @Override
    public String execute() throws Exception {
        super.execute();
        String instructorId = this.request.getParameter("instructorId");
        if (instructorId == null) {
            instructorId = ((InstructorEditForm)this.form).getInstructorId();
        }
        if (instructorId == null || instructorId.isEmpty()) {
            throw new Exception(MSG.exceptionInstructorInfoNotSupplied());
        }
        this.sessionContext.checkPermission((Serializable)((Object)instructorId), "DepartmentalInstructor", Right.InstructorEdit);
        ((InstructorEditForm)this.form).setInstructorId(instructorId);
        if (MSG.actionBackToDetail().equals(this.op) && instructorId != null && !instructorId.isEmpty()) {
            this.response.sendRedirect(this.response.encodeURL("instructorDetail.action?instructorId=" + instructorId));
            return null;
        }
        if (MSG.actionLookupInstructor().equals(this.op)) {
            ((InstructorEditForm)this.form).validate(this);
            if (!this.hasFieldErrors()) {
                this.findMatchingInstructor();
                if (((InstructorEditForm)this.form).getMatchFound() == null || !((InstructorEditForm)this.form).getMatchFound().booleanValue()) {
                    this.addFieldError("lookup", MSG.errorNoMatchingRecordsFound());
                }
            }
            return "showEdit";
        }
        if ((MSG.actionUpdateInstructor().equals(this.op) || MSG.actionNextInstructor().equals(this.op) || MSG.actionPreviousInstructor().equals(this.op)) && instructorId != null && !instructorId.isEmpty()) {
            ((InstructorEditForm)this.form).validate(this);
            if (!this.hasFieldErrors() && this.isDeptInstructorUnique()) {
                this.doUpdate();
                if (MSG.actionNextInstructor().equals(this.op)) {
                    this.response.sendRedirect(this.response.encodeURL("instructorInfoEdit.action?instructorId=" + ((InstructorEditForm)this.form).getNextId()));
                    return null;
                }
                if (MSG.actionPreviousInstructor().equals(this.op)) {
                    this.response.sendRedirect(this.response.encodeURL("instructorInfoEdit.action?instructorId=" + ((InstructorEditForm)this.form).getPreviousId()));
                    return null;
                }
                return "showDetail";
            }
            if (!this.hasFieldErrors()) {
                this.addFieldError("uniqueId", MSG.errorInstructorIdAlreadyExistsInList());
            }
        }
        if (MSG.actionDeleteInstructor().equals(this.op)) {
            this.doDelete();
            return "showList";
        }
        if (MSG.actionSelectInstructor().equals(this.op)) {
            String select = ((InstructorEditForm)this.form).getSearchSelect();
            if (select != null && select.trim().length() > 0) {
                if (select.equalsIgnoreCase("i2a2")) {
                    this.fillI2A2Info();
                } else {
                    this.fillStaffInfo();
                }
            }
            return "showEdit";
        }
        this.doLoad();
        BackTracker.markForBack(this.request, "instructorDetail.action?instructorId=" + ((InstructorEditForm)this.form).getInstructorId(), MSG.backInstructor(((InstructorEditForm)this.form).getName() == null ? "null" : ((InstructorEditForm)this.form).getName().trim()), true, false);
        return "showEdit";
    }

    private void doDelete() throws Exception {
        String instructorId = ((InstructorEditForm)this.form).getInstructorId();
        DepartmentalInstructorDAO idao = new DepartmentalInstructorDAO();
        this.sessionContext.checkPermission((Serializable)((Object)instructorId), "DepartmentalInstructor", Right.InstructorDelete);
        Session hibSession = idao.getSession();
        Transaction tx = null;
        try {
            tx = hibSession.beginTransaction();
            DepartmentalInstructor inst = (DepartmentalInstructor)idao.get(Long.valueOf(instructorId));
            ChangeLog.addChange(hibSession, this.sessionContext, inst, ChangeLog.Source.INSTRUCTOR_EDIT, ChangeLog.Operation.DELETE, null, inst.getDepartment());
            HashSet<Class_> updatedClasses = new HashSet<Class_>();
            for (ClassInstructor ci : inst.getClasses()) {
                Class_ c = ci.getClassInstructing();
                updatedClasses.add(c);
                c.getClassInstructors().remove(ci);
                hibSession.saveOrUpdate((Object)ci);
                hibSession.delete((Object)ci);
            }
            for (Exam exam : inst.getExams()) {
                exam.getInstructors().remove(inst);
                hibSession.saveOrUpdate((Object)exam);
            }
            for (Assignment a : inst.getAssignments()) {
                a.getInstructors().remove(inst);
                hibSession.saveOrUpdate((Object)a);
            }
            BaseDepartment d = null;
            if (inst.getDepartment() != null) {
                d = inst.getDepartment();
            }
            d.getInstructors().remove(inst);
            hibSession.delete((Object)inst);
            tx.commit();
            String className = ApplicationProperty.ExternalActionClassEdit.value();
            if (className != null && className.trim().length() > 0) {
                ExternalClassEditAction editAction = (ExternalClassEditAction)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                for (Class_ c : updatedClasses) {
                    editAction.performExternalClassEditAction(c, hibSession);
                }
            }
            hibSession.clear();
        }
        catch (Exception e) {
            Debug.error(e);
            try {
                if (tx != null && tx.isActive()) {
                    tx.rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    private void doLoad() {
        String instructorId = ((InstructorEditForm)this.form).getInstructorId();
        DepartmentalInstructorDAO idao = new DepartmentalInstructorDAO();
        DepartmentalInstructor inst = (DepartmentalInstructor)idao.get(Long.valueOf(instructorId));
        ((InstructorEditForm)this.form).setInstructorId(instructorId);
        ((InstructorEditForm)this.form).setName(Constants.toInitialCase(inst.getFirstName(), "-".toCharArray()) + " " + (inst.getMiddleName() == null ? "" : Constants.toInitialCase(inst.getMiddleName(), "-".toCharArray())) + " " + Constants.toInitialCase(inst.getLastName(), "-".toCharArray()));
        if (inst.getFirstName() != null) {
            ((InstructorEditForm)this.form).setFname(inst.getFirstName().trim());
        }
        if (inst.getMiddleName() != null) {
            ((InstructorEditForm)this.form).setMname(inst.getMiddleName().trim());
        }
        ((InstructorEditForm)this.form).setLname(inst.getLastName().trim());
        ((InstructorEditForm)this.form).setTitle(inst.getAcademicTitle());
        String puid = inst.getExternalUniqueId();
        if (puid != null) {
            ((InstructorEditForm)this.form).setPuId(puid);
        }
        ((InstructorEditForm)this.form).setEmail(inst.getEmail());
        ((InstructorEditForm)this.form).setDeptName(inst.getDepartment().getName().trim());
        if (inst.getPositionType() != null) {
            ((InstructorEditForm)this.form).setPosType(inst.getPositionType().getUniqueId().toString());
        }
        if (inst.getCareerAcct() != null && inst.getCareerAcct().length() > 0) {
            ((InstructorEditForm)this.form).setCareerAcct(inst.getCareerAcct().trim());
        } else if (puid != null && !puid.isEmpty() && DepartmentalInstructor.canLookupInstructor()) {
            try {
                ExternalUidLookup.UserInfo user = DepartmentalInstructor.lookupInstructor(puid);
                if (user != null && user.getUserName() != null) {
                    ((InstructorEditForm)this.form).setCareerAcct(user.getUserName());
                } else {
                    ((InstructorEditForm)this.form).setCareerAcct("");
                }
            }
            catch (Exception user) {
                // empty catch block
            }
        }
        if (inst.getNote() != null) {
            ((InstructorEditForm)this.form).setNote(inst.getNote().trim());
        }
        ((InstructorEditForm)this.form).setIgnoreDist(inst.isIgnoreToFar() == null ? false : inst.isIgnoreToFar());
        try {
            DepartmentalInstructor previous = inst.getPreviousDepartmentalInstructor(this.sessionContext, Right.InstructorEdit);
            ((InstructorEditForm)this.form).setPreviousId(previous == null ? null : previous.getUniqueId().toString());
            DepartmentalInstructor next = inst.getNextDepartmentalInstructor(this.sessionContext, Right.InstructorEdit);
            ((InstructorEditForm)this.form).setNextId(next == null ? null : next.getUniqueId().toString());
        }
        catch (Exception e) {
            Debug.error(e);
        }
    }
}

