/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.awt.image.BufferedImage;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.tiles.annotation.TilesDefinition;
import org.apache.struts2.tiles.annotation.TilesPutAttribute;
import org.unitime.commons.web.WebTable;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.ConstantsMessages;
import org.unitime.localization.messages.ExaminationMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.form.ExamListForm;
import org.unitime.timetable.model.BuildingPref;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.ExamOwner;
import org.unitime.timetable.model.ExamPeriodPref;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.MidtermPeriodPreferenceModel;
import org.unitime.timetable.model.PeriodPreferenceModel;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.RoomFeaturePref;
import org.unitime.timetable.model.RoomGroupPref;
import org.unitime.timetable.model.RoomPref;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.dao.ExamTypeDAO;
import org.unitime.timetable.model.dao.SubjectAreaDAO;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.exam.ExamSolverProxy;
import org.unitime.timetable.solver.exam.ui.ExamAssignment;
import org.unitime.timetable.solver.exam.ui.ExamRoomInfo;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.ExportUtils;
import org.unitime.timetable.util.IdValue;
import org.unitime.timetable.util.LookupTables;
import org.unitime.timetable.webutil.BackTracker;
import org.unitime.timetable.webutil.Navigation;
import org.unitime.timetable.webutil.PdfWebTable;
import org.unitime.timetable.webutil.RequiredTimeTable;

@Action(value="examList", results={@Result(name={"list"}, type="tiles", location="examList.tiles"), @Result(name={"addExam"}, type="redirect", location="/examEdit.action")})
@TilesDefinition(name="examList.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Examinations"), @TilesPutAttribute(name="body", value="/user/examList.jsp"), @TilesPutAttribute(name="showNavigation", value="true"), @TilesPutAttribute(name="showSolverWarnings", value="exams")})
public class ExamListAction
extends UniTimeAction<ExamListForm> {
    private static final long serialVersionUID = 1752223672961857285L;
    protected static final ConstantsMessages CONST = Localization.create(ConstantsMessages.class);
    protected static final ExaminationMessages MSG = Localization.create(ExaminationMessages.class);
    private String ord;

    public String getOrd() {
        return this.ord;
    }

    public void setOrd(String ord) {
        this.ord = ord;
    }

    public String execute() throws Exception {
        List<ExamType> types;
        String op;
        this.sessionContext.checkPermission(Right.Examinations);
        if (this.getForm() == null) {
            this.setForm(new ExamListForm());
        }
        String string = op = ((ExamListForm)this.getForm()).getOp() != null ? ((ExamListForm)this.getForm()).getOp() : this.request.getParameter("op");
        if (op == null && this.sessionContext.getAttribute(SessionAttribute.OfferingsSubjectArea) != null) {
            String subject = (String)this.sessionContext.getAttribute(SessionAttribute.OfferingsSubjectArea);
            if (subject.indexOf(44) >= 0) {
                subject = subject.substring(0, subject.indexOf(44));
            }
            if (Constants.ALL_OPTION_VALUE.equalsIgnoreCase(subject)) {
                ((ExamListForm)this.getForm()).setSubjectAreaId(-1L);
            } else {
                ((ExamListForm)this.getForm()).setSubjectAreaId(Long.valueOf(subject));
            }
            ((ExamListForm)this.getForm()).setCourseNbr((String)this.sessionContext.getAttribute(SessionAttribute.OfferingsCourseNumber));
        }
        if (op == null && this.sessionContext.getAttribute(SessionAttribute.ExamType) != null) {
            ((ExamListForm)this.getForm()).setExamType((Long)this.sessionContext.getAttribute(SessionAttribute.ExamType));
        }
        if (((ExamListForm)this.getForm()).getExamType() == null && !(types = ExamType.findAllUsedApplicable(this.sessionContext.getUser(), DepartmentStatusType.Status.ExamView, DepartmentStatusType.Status.ExamTimetable)).isEmpty()) {
            ((ExamListForm)this.getForm()).setExamType(types.get(0).getUniqueId());
        }
        WebTable.setOrder(this.sessionContext, "ExamList.ord", this.getOrd(), 1);
        if ("Search".equals(op) || "Export PDF".equals(op) || "Export CSV".equals(op) || MSG.buttonSearch().equals(op) || MSG.buttonExportPDF().equals(op) || MSG.buttonExportCSV().equals(op)) {
            if (((ExamListForm)this.getForm()).getSubjectAreaId() != null) {
                this.sessionContext.setAttribute(SessionAttribute.OfferingsSubjectArea, (Object)(((ExamListForm)this.getForm()).getSubjectAreaId() < 0L ? Constants.ALL_OPTION_VALUE : ((ExamListForm)this.getForm()).getSubjectAreaId().toString()));
                this.sessionContext.setAttribute(SessionAttribute.OfferingsCourseNumber, (Object)((ExamListForm)this.getForm()).getCourseNbr());
                this.sessionContext.setAttribute(SessionAttribute.ExamType, (Object)((ExamListForm)this.getForm()).getExamType());
            }
            if ("Export PDF".equals(op) || MSG.buttonExportPDF().equals(op)) {
                ExportUtils.exportPDF(this.getExamTable(false, true), WebTable.getOrder(this.sessionContext, "ExamList.ord"), this.response, "exams");
                return null;
            }
            if ("Export CSV".equals(op) || MSG.buttonExportCSV().equals(op)) {
                ExportUtils.exportCSV(this.getExamTable(false, false), WebTable.getOrder(this.sessionContext, "ExamList.ord"), this.response, "exams");
                return null;
            }
        }
        if ("Add Examination".equals(op) || MSG.buttonAddExamination().equals(op)) {
            return "addExam";
        }
        ArrayList<IdValue> subjects = new ArrayList<IdValue>();
        subjects.add(new IdValue(null, CONST.select()));
        if (this.sessionContext.hasPermission(Right.DepartmentIndependent)) {
            subjects.add(new IdValue(-1L, CONST.all()));
        }
        TreeSet<SubjectArea> userSubjectAreas = SubjectArea.getUserSubjectAreas(this.sessionContext.getUser(), false);
        for (SubjectArea sa : userSubjectAreas) {
            subjects.add(new IdValue(sa.getUniqueId(), sa.getSubjectAreaAbbreviation()));
        }
        ((ExamListForm)this.getForm()).setSubjectAreas(subjects);
        if (userSubjectAreas.size() == 1) {
            ((ExamListForm)this.getForm()).setSubjectAreaId(userSubjectAreas.first().getUniqueId());
        }
        if (((ExamListForm)this.getForm()).getSubjectAreaId() != null) {
            PdfWebTable table = this.getExamTable(true, false);
            if (table != null) {
                this.request.setAttribute("table", (Object)table.printTable(WebTable.getOrder(this.sessionContext, "ExamList.ord")));
                Vector<Long> ids = new Vector<Long>();
                Enumeration e = table.getLines().elements();
                while (e.hasMoreElements()) {
                    WebTable.WebTableLine line = (WebTable.WebTableLine)e.nextElement();
                    ids.add(Long.parseLong(line.getUniqueId()));
                }
                Navigation.set(this.sessionContext, Navigation.sInstructionalOfferingLevel, ids);
            } else {
                this.addActionError(MSG.errorNoMatchingExam());
            }
        }
        String subjectAreaName = "";
        try {
            subjectAreaName = ((SubjectArea)new SubjectAreaDAO().get(((ExamListForm)this.getForm()).getSubjectAreaId())).getSubjectAreaAbbreviation();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.request.getParameter("backId") != null) {
            this.request.setAttribute("hash", (Object)this.request.getParameter("backId"));
        }
        if (((ExamListForm)this.getForm()).getExamType() != null && ((ExamListForm)this.getForm()).getSubjectAreaId() != null && ((ExamListForm)this.getForm()).getCourseNbr() != null) {
            BackTracker.markForBack(this.request, "examList.action?form.op=" + MSG.buttonSearch() + "&form.examType=" + ((ExamListForm)this.getForm()).getExamType() + "&form.subjectAreaId=" + ((ExamListForm)this.getForm()).getSubjectAreaId() + "&form.courseNbr=" + URLEncoder.encode(((ExamListForm)this.getForm()).getCourseNbr(), "utf-8"), MSG.backExams(((ExamType)ExamTypeDAO.getInstance().get(((ExamListForm)this.getForm()).getExamType())).getLabel(), ((ExamListForm)this.getForm()).getSubjectAreaId() < 0L ? CONST.all() : subjectAreaName + (((ExamListForm)this.getForm()).getCourseNbr() == null || ((ExamListForm)this.getForm()).getCourseNbr().length() == 0 ? "" : " " + ((ExamListForm)this.getForm()).getCourseNbr())), true, true);
        }
        LookupTables.setupExamTypes(this.request, this.sessionContext.getUser(), DepartmentStatusType.Status.ExamView, DepartmentStatusType.Status.ExamTimetable);
        return "list";
    }

    public PdfWebTable getExamTable(boolean html, boolean color) {
        Collection exams;
        ExamSolverProxy examAssignment = this.getExaminationSolverService().getSolver();
        Collection collection = ((ExamListForm)this.getForm()).getSubjectAreaId() == null ? null : (exams = ((ExamListForm)this.getForm()).getSubjectAreaId() < 0L ? Exam.findAll(this.sessionContext.getUser().getCurrentAcademicSessionId(), ((ExamListForm)this.getForm()).getExamType()) : Exam.findExamsOfCourse(((ExamListForm)this.getForm()).getSubjectAreaId(), ((ExamListForm)this.getForm()).getCourseNbr(), ((ExamListForm)this.getForm()).getExamType()));
        if (exams == null || exams.isEmpty()) {
            return null;
        }
        if (examAssignment != null && !examAssignment.getExamTypeId().equals(((ExamListForm)this.getForm()).getExamType())) {
            examAssignment = null;
        }
        String nl = html ? "<br>" : "\n";
        boolean timeVertical = RequiredTimeTable.getTimeGridVertical(this.sessionContext.getUser());
        boolean timeText = RequiredTimeTable.getTimeGridAsText(this.sessionContext.getUser());
        String instructorNameFormat = UserProperty.NameFormat.get(this.sessionContext.getUser());
        ExamType type = (ExamType)ExamTypeDAO.getInstance().get(((ExamListForm)this.getForm()).getExamType());
        PdfWebTable table = new PdfWebTable(11, MSG.tableExaminations(type.getLabel()), "examList.action?ord=%%", new String[]{MSG.colExamOwner().replace("\n", nl), MSG.colExamLength().replace("\n", nl), MSG.colExamSeatingType().replace("\n", nl), MSG.colExamSize().replace("\n", nl), MSG.colExamMaxRooms().replace("\n", nl), MSG.colExamInstructor().replace("\n", nl), MSG.colExamPeriodPrefs().replace("\n", nl), MSG.colExamRoomPrefs().replace("\n", nl), MSG.colExamDistributionPrefs().replace("\n", nl), MSG.colExamAssignedPeriod().replace("\n", nl), MSG.colExamAssignedRoom().replace("\n", nl)}, new String[]{"left", "right", "center", "right", "right", "left", "left", "left", "left", "left", "left"}, new boolean[]{true, true, true, true, true, true, true, true, true, true});
        for (Exam exam : exams) {
            RequiredTimeTable rtt;
            ExamAssignment ea;
            String objects = "";
            String perPref = "";
            String roomPref = "";
            String distPref = "";
            String per = "";
            String rooms = "";
            Comparable perCmp = null;
            for (ExamOwner examOwner : new TreeSet<ExamOwner>(exam.getOwners())) {
                if (objects.length() > 0) {
                    objects = objects + nl;
                }
                objects = objects + examOwner.getLabel();
            }
            ExamAssignment examAssignment2 = examAssignment != null ? examAssignment.getAssignment(exam.getUniqueId()) : (ea = exam.getAssignedPeriod() != null ? new ExamAssignment(exam) : null);
            if (ea != null) {
                per = html ? ea.getPeriodAbbreviationWithPref() : (ea.getPeriodPref() == null || !color ? "" : "@@COLOR " + PreferenceLevel.prolog2color(ea.getPeriodPref()) + " ") + ea.getPeriodAbbreviation();
                perCmp = ea.getPeriodOrd();
                rooms = "";
                for (ExamRoomInfo room : ea.getRooms()) {
                    if (rooms.length() > 0) {
                        rooms = rooms + nl;
                    }
                    rooms = rooms + (html ? room.toString() : (color ? "@@COLOR " + PreferenceLevel.prolog2color(PreferenceLevel.int2prolog(room.getPreference())) + " " : "") + room.getName());
                }
            }
            if (html) {
                if ((roomPref = roomPref + exam.getEffectivePrefHtmlForPrefType(RoomPref.class)).length() > 0 && !roomPref.endsWith(nl)) {
                    roomPref = roomPref + nl;
                }
                if ((roomPref = roomPref + exam.getEffectivePrefHtmlForPrefType(BuildingPref.class)).length() > 0 && !roomPref.endsWith(nl)) {
                    roomPref = roomPref + nl;
                }
                if ((roomPref = roomPref + exam.getEffectivePrefHtmlForPrefType(RoomFeaturePref.class)).length() > 0 && !roomPref.endsWith(nl)) {
                    roomPref = roomPref + nl;
                }
                if ((roomPref = roomPref + exam.getEffectivePrefHtmlForPrefType(RoomGroupPref.class)).endsWith(nl)) {
                    roomPref = roomPref.substring(0, roomPref.length() - nl.length());
                }
                if (ApplicationProperty.LegacyPeriodPreferences.isTrue()) {
                    if (timeText || 1 == exam.getExamType().getType()) {
                        if (1 == exam.getExamType().getType()) {
                            MidtermPeriodPreferenceModel midtermPeriodPreferenceModel = new MidtermPeriodPreferenceModel(exam.getSession(), exam.getExamType());
                            midtermPeriodPreferenceModel.load(exam);
                            perPref = perPref + midtermPeriodPreferenceModel.toString(true);
                        } else {
                            perPref = perPref + exam.getEffectivePrefHtmlForPrefType(ExamPeriodPref.class);
                        }
                    } else {
                        PeriodPreferenceModel periodPreferenceModel = new PeriodPreferenceModel(exam.getSession(), ea, exam.getExamType().getUniqueId());
                        rtt = new RequiredTimeTable(periodPreferenceModel);
                        periodPreferenceModel.load(exam);
                        String hint = rtt.print(false, timeVertical).replace(");\n</script>", "").replace("<script language=\"javascript\">\ndocument.write(", "").replace("\n", " ");
                        perPref = "<img border='0' src='pattern?v=" + (timeVertical ? 1 : 0) + "&x=" + exam.getUniqueId() + (ea == null ? "" : "&ap=" + ea.getPeriodId()) + "' onmouseover=\"showGwtHint(this, " + hint + ");\" onmouseout=\"hideGwtHint();\">";
                    }
                } else if (timeText || 1 == exam.getExamType().getType()) {
                    if (1 == exam.getExamType().getType()) {
                        MidtermPeriodPreferenceModel midtermPeriodPreferenceModel = new MidtermPeriodPreferenceModel(exam.getSession(), exam.getExamType());
                        midtermPeriodPreferenceModel.load(exam);
                        perPref = perPref + "<span onmouseover=\"showGwtExamPeriodPreferencesHint(this, '" + exam.getUniqueId() + "', null);\" onmouseout=\"hideGwtPeriodPreferencesHint();\">" + midtermPeriodPreferenceModel.toString(true) + "</span>";
                    } else {
                        perPref = perPref + "<span onmouseover=\"showGwtExamPeriodPreferencesHint(this, '" + exam.getUniqueId() + "', null);\" onmouseout=\"hideGwtPeriodPreferencesHint();\">" + exam.getEffectivePrefHtmlForPrefType(ExamPeriodPref.class) + "</span>";
                    }
                } else {
                    perPref = "<img border='0' src='pattern?v=" + (timeVertical ? 1 : 0) + "&x=" + exam.getUniqueId() + (ea == null ? "" : "&ap=" + ea.getPeriodId()) + "' onmouseover=\"showGwtExamPeriodPreferencesHint(this, '" + exam.getUniqueId() + "', null);\" onmouseout=\"hideGwtPeriodPreferencesHint();\">";
                }
                distPref = distPref + exam.getEffectivePrefHtmlForPrefType(DistributionPref.class);
            } else {
                for (Preference pref : exam.effectivePreferences(RoomPref.class)) {
                    if (roomPref.length() > 0) {
                        roomPref = roomPref + nl;
                    }
                    roomPref = roomPref + (color ? "@@COLOR " + PreferenceLevel.prolog2color(pref.getPrefLevel().getPrefProlog()) + " " : "") + pref.getPrefLevel().getAbbreviation() + " " + pref.preferenceText();
                }
                for (Preference pref : exam.effectivePreferences(BuildingPref.class)) {
                    if (roomPref.length() > 0) {
                        roomPref = roomPref + nl;
                    }
                    roomPref = roomPref + (color ? "@@COLOR " + PreferenceLevel.prolog2color(pref.getPrefLevel().getPrefProlog()) + " " : "") + pref.getPrefLevel().getAbbreviation() + " " + pref.preferenceText();
                }
                for (Preference pref : exam.effectivePreferences(RoomFeaturePref.class)) {
                    if (roomPref.length() > 0) {
                        roomPref = roomPref + nl;
                    }
                    roomPref = roomPref + (color ? "@@COLOR " + PreferenceLevel.prolog2color(pref.getPrefLevel().getPrefProlog()) + " " : "") + pref.getPrefLevel().getAbbreviation() + " " + pref.preferenceText();
                }
                for (Preference pref : exam.effectivePreferences(RoomGroupPref.class)) {
                    if (roomPref.length() > 0) {
                        roomPref = roomPref + nl;
                    }
                    roomPref = roomPref + (color ? "@@COLOR " + PreferenceLevel.prolog2color(pref.getPrefLevel().getPrefProlog()) + " " : "") + pref.getPrefLevel().getAbbreviation() + " " + pref.preferenceText();
                }
                if (1 == exam.getExamType().getType()) {
                    MidtermPeriodPreferenceModel midtermPeriodPreferenceModel = new MidtermPeriodPreferenceModel(exam.getSession(), exam.getExamType());
                    midtermPeriodPreferenceModel.load(exam);
                    perPref = perPref + midtermPeriodPreferenceModel.toString(false, color);
                } else if (timeText || !color) {
                    for (Preference pref : exam.effectivePreferences(ExamPeriodPref.class)) {
                        if (perPref.length() > 0) {
                            perPref = perPref + nl;
                        }
                        perPref = perPref + (color ? "@@COLOR " + PreferenceLevel.prolog2color(pref.getPrefLevel().getPrefProlog()) + " " : "") + pref.getPrefLevel().getAbbreviation() + " " + pref.preferenceText();
                    }
                } else {
                    PeriodPreferenceModel periodPreferenceModel = new PeriodPreferenceModel(exam.getSession(), ea, exam.getExamType().getUniqueId());
                    periodPreferenceModel.load(exam);
                    rtt = new RequiredTimeTable(periodPreferenceModel);
                    BufferedImage image = rtt.createBufferedImage(timeVertical);
                    if (image != null) {
                        table.addImage(exam.getUniqueId().toString(), image);
                        perPref = perPref + "@@IMAGE " + exam.getUniqueId().toString() + " ";
                    } else {
                        for (Preference pref : exam.effectivePreferences(ExamPeriodPref.class)) {
                            if (perPref.length() > 0) {
                                perPref = perPref + nl;
                            }
                            perPref = perPref + (color ? "@@COLOR " + PreferenceLevel.prolog2color(pref.getPrefLevel().getPrefProlog()) + " " : "") + pref.getPrefLevel().getAbbreviation() + " " + pref.preferenceText();
                        }
                    }
                }
                for (Preference pref : exam.effectivePreferences(DistributionPref.class)) {
                    if (distPref.length() > 0) {
                        distPref = distPref + nl;
                    }
                    distPref = distPref + (color ? "@@COLOR " + PreferenceLevel.prolog2color(pref.getPrefLevel().getPrefProlog()) + " " : "") + pref.getPrefLevel().getAbbreviation() + " " + ((DistributionPref)pref).preferenceText(true, true, " (", ", ", ")").replaceAll("&lt;", "<").replaceAll("&gt;", ">");
                }
            }
            int n = exam.getSize();
            String instructors = "";
            for (DepartmentalInstructor instructor : new TreeSet<DepartmentalInstructor>(exam.getInstructors())) {
                if (instructors.length() > 0) {
                    instructors = instructors + nl;
                }
                instructors = instructors + instructor.getName(instructorNameFormat);
            }
            table.addLine("onClick=\"document.location='examDetail.action?examId=" + exam.getUniqueId() + "';\"", new String[]{(html ? "<a name='" + exam.getUniqueId() + "'>" : "") + objects + (html ? "</a>" : ""), exam.getLength().toString(), 0 == exam.getSeatingType() ? "Normal" : "Exam", String.valueOf(n), exam.getMaxNbrRooms().toString(), instructors, perPref, roomPref, distPref, per, rooms}, new Comparable[]{exam.firstOwner(), exam.getLength(), exam.getSeatingType(), Integer.valueOf(n), exam.getMaxNbrRooms(), instructors, perPref, roomPref, distPref, perCmp, rooms}, exam.getUniqueId().toString());
        }
        return table;
    }
}

