/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.tiles.annotation.TilesDefinition;
import org.apache.struts2.tiles.annotation.TilesPutAttribute;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.form.DistributionTypeEditForm;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DistributionType;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.dao.DepartmentDAO;
import org.unitime.timetable.model.dao.DistributionTypeDAO;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.ComboBoxLookup;

@Action(value="distributionTypeEdit", results={@Result(name={"showEdit"}, type="tiles", location="distributionTypeEdit.tiles"), @Result(name={"showDistributionTypeList"}, type="redirect", location="/distributionTypeList.action", params={"anchor", "${form.requirementId}"})})
@TilesDefinition(name="distributionTypeEdit.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Edit Distribution Type"), @TilesPutAttribute(name="body", value="/admin/distributionTypeEdit.jsp")})
public class DistributionTypeEditAction
extends UniTimeAction<DistributionTypeEditForm> {
    private static final long serialVersionUID = -1856283238950150575L;
    protected static CourseMessages MSG = Localization.create(CourseMessages.class);
    private Long id;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String execute() throws Exception {
        if (this.form == null) {
            this.form = new DistributionTypeEditForm();
        }
        this.sessionContext.checkPermission(Right.DistributionTypeEdit);
        if (this.op == null) {
            this.op = ((DistributionTypeEditForm)this.form).getOp();
        }
        Long sessionId = this.sessionContext.getUser().getCurrentAcademicSessionId();
        if (this.op == null) {
            ((DistributionTypeEditForm)this.form).setDistributionType((DistributionType)DistributionTypeDAO.getInstance().get(this.id), sessionId);
        }
        List list = DistributionTypeDAO.getInstance().getSession().createCriteria(Department.class).add((Criterion)Restrictions.eq((String)"session.uniqueId", (Object)sessionId)).addOrder(Order.asc((String)"deptCode")).list();
        ArrayList<ComboBoxLookup> availableDepts = new ArrayList<ComboBoxLookup>();
        for (Department d : list) {
            availableDepts.add(new ComboBoxLookup(d.getLabel(), d.getUniqueId().toString()));
        }
        this.request.setAttribute(Department.DEPT_ATTR_NAME, availableDepts);
        this.request.setAttribute(PreferenceLevel.PREF_LEVEL_ATTR_NAME, PreferenceLevel.getPreferenceLevelList());
        if (MSG.actionUpdateDistributionType().equals(this.op)) {
            DistributionTypeDAO dao = DistributionTypeDAO.getInstance();
            Transaction tx = null;
            try {
                Session hibSession = dao.getSession();
                if (hibSession.getTransaction() == null || !hibSession.getTransaction().isActive()) {
                    tx = hibSession.beginTransaction();
                }
                DistributionType distType = (DistributionType)dao.get(((DistributionTypeEditForm)this.form).getUniqueId());
                DistributionType x = ((DistributionTypeEditForm)this.form).getDistributionType();
                distType.setAbbreviation(x.getAbbreviation());
                distType.setAllowedPref(x.getAllowedPref());
                distType.setDescr(x.getDescr());
                distType.setInstructorPref(x.isInstructorPref() == null ? Boolean.FALSE : x.isInstructorPref());
                distType.setLabel(x.getLabel());
                distType.setVisible(x.isVisible() == null ? Boolean.FALSE : x.isVisible());
                HashSet<Department> oldDepts = new HashSet<Department>(distType.getDepartments());
                for (Long departmentId : ((DistributionTypeEditForm)this.form).getDepartmentIds()) {
                    Department d = (Department)new DepartmentDAO().get(departmentId, hibSession);
                    if (d == null || oldDepts.remove(d)) continue;
                    distType.getDepartments().add(d);
                }
                for (Department d : oldDepts) {
                    if (!d.getSessionId().equals(sessionId)) continue;
                    distType.getDepartments().remove(d);
                }
                hibSession.saveOrUpdate((Object)distType);
                ChangeLog.addChange(hibSession, this.sessionContext, distType, ChangeLog.Source.DIST_TYPE_EDIT, ChangeLog.Operation.UPDATE, null, null);
                if (tx != null) {
                    tx.commit();
                }
            }
            catch (Exception e) {
                if (tx != null) {
                    tx.rollback();
                }
                throw e;
            }
            return "showDistributionTypeList";
        }
        if (MSG.actionBackToDistributionTypes().equals(this.op)) {
            return "showDistributionTypeList";
        }
        if (MSG.actionAddDepartment().equals(this.op)) {
            if (((DistributionTypeEditForm)this.form).getDepartmentId() == null || ((DistributionTypeEditForm)this.form).getDepartmentId() < 0L) {
                this.addFieldError("form.department", MSG.errorNoDepartmentSelected());
            } else {
                boolean contains = ((DistributionTypeEditForm)this.form).getDepartmentIds().contains(((DistributionTypeEditForm)this.form).getDepartmentId());
                if (contains) {
                    this.addFieldError("form.department", MSG.errorDepartmentAlreadyListed());
                }
            }
            if (!this.hasFieldErrors()) {
                ((DistributionTypeEditForm)this.form).getDepartmentIds().add(((DistributionTypeEditForm)this.form).getDepartmentId());
            }
        }
        if (MSG.actionRemoveDepartment().equals(this.op)) {
            if (((DistributionTypeEditForm)this.form).getDepartmentId() == null || ((DistributionTypeEditForm)this.form).getDepartmentId() < 0L) {
                this.addFieldError("form.department", MSG.errorNoDepartmentSelected());
            } else {
                boolean contains = ((DistributionTypeEditForm)this.form).getDepartmentIds().contains(((DistributionTypeEditForm)this.form).getDepartmentId());
                if (!contains) {
                    this.addFieldError("form.department", MSG.errorDepartmentNotListed());
                }
            }
            if (!this.hasFieldErrors()) {
                ((DistributionTypeEditForm)this.form).getDepartmentIds().remove(((DistributionTypeEditForm)this.form).getDepartmentId());
            }
        }
        return "showEdit";
    }
}

