/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.tiles.annotation.TilesDefinition;
import org.apache.struts2.tiles.annotation.TilesDefinitions;
import org.apache.struts2.tiles.annotation.TilesPutAttribute;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.unitime.commons.Debug;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.form.DistributionPrefsForm;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DistributionObject;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.DistributionType;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.PreferenceGroup;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.StudentSectioningQueue;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.base.BaseDepartment;
import org.unitime.timetable.model.base.BasePreferenceGroup;
import org.unitime.timetable.model.base.BaseSchedulingSubpart;
import org.unitime.timetable.model.comparators.ClassComparator;
import org.unitime.timetable.model.comparators.SchedulingSubpartComparator;
import org.unitime.timetable.model.dao.Class_DAO;
import org.unitime.timetable.model.dao.DistributionPrefDAO;
import org.unitime.timetable.model.dao.DistributionTypeDAO;
import org.unitime.timetable.model.dao.InstructionalOfferingDAO;
import org.unitime.timetable.model.dao.SchedulingSubpartDAO;
import org.unitime.timetable.security.Qualifiable;
import org.unitime.timetable.security.permissions.Permission;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.ComboBoxLookup;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.ExportUtils;
import org.unitime.timetable.util.LookupTables;
import org.unitime.timetable.webutil.BackTracker;
import org.unitime.timetable.webutil.DistributionPrefsTableBuilder;

@Action(value="distributionPrefs", results={@Result(name={"list"}, type="tiles", location="distributionPrefs.tiles"), @Result(name={"add"}, type="tiles", location="addDistributionPref.tiles"), @Result(name={"edit"}, type="tiles", location="editDistributionPref.tiles")})
@TilesDefinitions(value={@TilesDefinition(name="distributionPrefs.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Distribution Preferences"), @TilesPutAttribute(name="body", value="/user/distributionPrefs.jsp"), @TilesPutAttribute(name="showNavigation", value="true")}), @TilesDefinition(name="addDistributionPref.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Add Distribution Preference"), @TilesPutAttribute(name="body", value="/user/distributionPrefs.jsp"), @TilesPutAttribute(name="showNavigation", value="true")}), @TilesDefinition(name="editDistributionPref.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Edit Distribution Preference"), @TilesPutAttribute(name="body", value="/user/distributionPrefs.jsp"), @TilesPutAttribute(name="showNavigation", value="true")})})
public class DistributionPrefsAction
extends UniTimeAction<DistributionPrefsForm> {
    private static final long serialVersionUID = 1926148300437111812L;
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    protected static GwtConstants CONST = Localization.create(GwtConstants.class);
    protected String op2;
    protected String reloadId;
    protected String reloadCause;
    protected String deleteId;
    protected String deleteType;
    protected String distPrefId;

    public String getOp2() {
        return this.op2;
    }

    public void setOp2(String op2) {
        this.op2 = op2;
    }

    public String getReloadId() {
        return this.reloadId;
    }

    public void setReloadId(String reloadId) {
        this.reloadId = reloadId;
    }

    public String getReloadCause() {
        return this.reloadCause;
    }

    public void setReloadCause(String reloadCause) {
        this.reloadCause = reloadCause;
    }

    public String getDeleteId() {
        return this.deleteId;
    }

    public void setDeleteId(String deleteId) {
        this.deleteId = deleteId;
    }

    public String getDeleteType() {
        return this.deleteType;
    }

    public void setDeleteType(String deleteType) {
        this.deleteType = deleteType;
    }

    public String getDp() {
        return this.distPrefId;
    }

    public void setDp(String distPrefId) {
        this.distPrefId = distPrefId;
    }

    public String execute() throws Exception {
        String subjectAreaId;
        if (this.form == null) {
            this.form = new DistributionPrefsForm();
        }
        this.sessionContext.checkPermission(Right.DistributionPreferences);
        if (this.op == null) {
            this.op = ((DistributionPrefsForm)this.form).getOp();
        }
        if (this.op2 != null && !this.op2.isEmpty()) {
            this.op = this.op2;
        }
        if (this.op == null || this.op.trim().isEmpty()) {
            this.op = "view";
        }
        ArrayList<ComboBoxLookup> subjects = new ArrayList<ComboBoxLookup>();
        subjects.add(new ComboBoxLookup(Constants.BLANK_OPTION_LABEL, Constants.BLANK_OPTION_VALUE));
        subjects.add(new ComboBoxLookup(Constants.ALL_OPTION_LABEL, Constants.ALL_OPTION_VALUE));
        TreeSet<SubjectArea> userSubjectAreas = SubjectArea.getUserSubjectAreas(this.sessionContext.getUser());
        for (SubjectArea sa : userSubjectAreas) {
            subjects.add(new ComboBoxLookup(sa.getSubjectAreaAbbreviation(), sa.getUniqueId().toString()));
        }
        ((DistributionPrefsForm)this.form).setFilterSubjectAreas(subjects);
        if ("DistTypeChange".equals(this.request.getParameter("op2")) || "GroupingChange".equals(this.request.getParameter("op2"))) {
            this.op = "reload pref";
        }
        Debug.debug("op: " + this.op);
        Debug.debug("deleteId: " + this.deleteId);
        Debug.debug("deleteType: " + this.deleteType);
        Debug.debug("reloadCause: " + this.reloadCause);
        Debug.debug("reloadId: " + this.reloadId);
        Debug.debug("distPrefId: " + this.distPrefId);
        if (this.reloadCause != null && this.reloadCause.length() > 0) {
            this.op = "reload";
        }
        if (MSG.actionCancel().equals(this.op)) {
            ((DistributionPrefsForm)this.form).reset();
            if (BackTracker.doBack(this.request, this.response)) {
                return null;
            }
            this.op = "view";
        }
        List<ComboBoxLookup> subjectAreaList = this.setupSubjectAreas();
        if (MSG.actionSaveNewDistributionPreference().equals(this.op) || MSG.actionUpdateDistributionPreference().equals(this.op)) {
            Debug.debug("Saving distribution pref ...");
            ((DistributionPrefsForm)this.form).setOp(this.op);
            ((DistributionPrefsForm)this.form).validate(this);
            if (!this.hasFieldErrors()) {
                try {
                    this.doAddOrUpdate();
                    if (((DistributionPrefsForm)this.form).getDistPrefId() != null) {
                        this.request.setAttribute("backType", (Object)"PreferenceGroup");
                        this.request.setAttribute("backId", (Object)((DistributionPrefsForm)this.form).getDistPrefId());
                    }
                    ((DistributionPrefsForm)this.form).reset();
                    if (BackTracker.doBack(this.request, this.response)) {
                        return null;
                    }
                    this.op = "view";
                }
                catch (Exception e) {
                    Debug.error(e);
                    this.addFieldError("classes", e.getMessage());
                }
            }
        }
        if (MSG.actionDeleteDistributionPreference().equals(this.op)) {
            if ("distObject".equals(this.deleteType)) {
                ((DistributionPrefsForm)this.form).removeFromLists(Integer.parseInt(this.deleteId));
            }
            if ("distPref".equals(this.deleteType)) {
                this.doDelete(((DistributionPrefsForm)this.form).getDistPrefId());
                ((DistributionPrefsForm)this.form).reset();
                if (BackTracker.doBack(this.request, this.response)) {
                    return null;
                }
                this.op = "view";
            }
        }
        if (MSG.actionAddDistributionPreference().equals(this.op) || MSG.actionAddNewDistributionPreference().equals(this.op)) {
            Debug.debug("Adding new Class via redirect ...");
            ((DistributionPrefsForm)this.form).setDistType("-");
            ((DistributionPrefsForm)this.form).setGrouping("-");
            if (this.request.getParameter("classId") != null) {
                Class_ clazz = (Class_)Class_DAO.getInstance().get(Long.valueOf(this.request.getParameter("classId")));
                if (clazz != null) {
                    ((DistributionPrefsForm)this.form).addToSubjectArea(clazz.getSchedulingSubpart().getControllingCourseOffering().getSubjectArea().getUniqueId().toString());
                    ((DistributionPrefsForm)this.form).addToItype(clazz.getSchedulingSubpart().getUniqueId().toString());
                    ((DistributionPrefsForm)this.form).addToCourseNbr(clazz.getSchedulingSubpart().getControllingCourseOffering().getUniqueId().toString());
                    ((DistributionPrefsForm)this.form).addToClassNumber(clazz.getUniqueId().toString());
                    this.request.setAttribute("addedClass", (Object)("" + (((DistributionPrefsForm)this.form).getSubjectArea().size() - 1)));
                }
            } else if (this.request.getParameter("subpartId") != null) {
                SchedulingSubpart subpart = (SchedulingSubpart)SchedulingSubpartDAO.getInstance().get(Long.valueOf(this.request.getParameter("subpartId")));
                if (subpart != null) {
                    ((DistributionPrefsForm)this.form).addToSubjectArea(subpart.getControllingCourseOffering().getSubjectArea().getUniqueId().toString());
                    ((DistributionPrefsForm)this.form).addToItype(subpart.getUniqueId().toString());
                    ((DistributionPrefsForm)this.form).addToCourseNbr(subpart.getControllingCourseOffering().getUniqueId().toString());
                    ((DistributionPrefsForm)this.form).addToClassNumber("-1");
                    this.request.setAttribute("addedClass", (Object)("" + (((DistributionPrefsForm)this.form).getSubjectArea().size() - 1)));
                }
            } else if (this.request.getAttribute("subjectAreaId") != null) {
                ((DistributionPrefsForm)this.form).addToSubjectArea(this.request.getAttribute("subjectAreaId").toString());
                ((DistributionPrefsForm)this.form).addToItype(this.request.getAttribute("schedSubpartId").toString());
                ((DistributionPrefsForm)this.form).addToCourseNbr(this.request.getAttribute("courseOffrId").toString());
                ((DistributionPrefsForm)this.form).addToClassNumber(this.request.getAttribute("classId").toString());
                this.request.setAttribute("addedClass", (Object)("" + (((DistributionPrefsForm)this.form).getSubjectArea().size() - 1)));
            } else {
                subjectAreaId = ((DistributionPrefsForm)this.form).getFilterSubjectAreaId();
                if (Constants.ALL_OPTION_VALUE.equals(subjectAreaId)) {
                    subjectAreaId = null;
                }
                ((DistributionPrefsForm)this.form).addNewClass(subjectAreaId);
            }
        }
        if (MSG.actionAddClassToDistribution().equals(this.op)) {
            Debug.debug("Adding new Class ...");
            String subjAreaId = null;
            if (subjectAreaList.size() == 1) {
                subjAreaId = subjectAreaList.get(0).getValue();
            }
            ((DistributionPrefsForm)this.form).addNewClass(subjAreaId);
            this.request.setAttribute("addedClass", (Object)("" + (((DistributionPrefsForm)this.form).getSubjectArea().size() - 1)));
        }
        if (MSG.actionSearchDistributionPreferences().equals(this.op) || MSG.actionExportPdf().equals(this.op) || MSG.actionExportCsv().equals(this.op)) {
            subjectAreaId = ((DistributionPrefsForm)this.form).getFilterSubjectAreaId();
            String courseNbr = ((DistributionPrefsForm)this.form).getFilterCourseNbr();
            if (subjectAreaId != null && subjectAreaId.length() > 0) {
                this.sessionContext.setAttribute(SessionAttribute.OfferingsSubjectArea, (Object)subjectAreaId);
            } else {
                this.sessionContext.removeAttribute(SessionAttribute.OfferingsSubjectArea);
            }
            if (courseNbr != null && courseNbr.length() > 0) {
                this.sessionContext.setAttribute(SessionAttribute.OfferingsCourseNumber, (Object)courseNbr);
            } else {
                this.sessionContext.removeAttribute(SessionAttribute.OfferingsCourseNumber);
            }
            this.op = MSG.actionExportPdf().equals(this.op) ? "export" : (MSG.actionExportCsv().equals(this.op) ? "export-csv" : "view");
        }
        if (this.op != null && (this.op.equals("view") || this.op.equals("export") || this.op.equals("export-csv")) && this.distPrefId != null && this.distPrefId.trim().length() > 0) {
            Debug.debug("Loading dist pref - " + this.distPrefId);
            ((DistributionPrefsForm)this.form).reset();
            this.doLoad(this.distPrefId);
        }
        if (this.op != null && this.op.equals("reload")) {
            if (this.reloadCause != null && this.reloadCause.equals("subjectArea")) {
                int index = Integer.parseInt(this.reloadId);
                Debug.debug("subj area changed ... " + this.reloadId + " - " + ((DistributionPrefsForm)this.form).getSubjectArea(index));
                ((DistributionPrefsForm)this.form).setCourseNbr(index, "-");
                ((DistributionPrefsForm)this.form).setItype(index, "-");
                ((DistributionPrefsForm)this.form).setClassNumber(index, "-");
            }
            if (this.reloadCause != null && this.reloadCause.equals("moveUp")) {
                int index = Integer.parseInt(this.reloadId);
                Debug.debug("moving up ... " + this.reloadId);
                ((DistributionPrefsForm)this.form).swap(index, index - 1);
            }
            if (this.reloadCause != null && this.reloadCause.equals("moveDown")) {
                int index = Integer.parseInt(this.reloadId);
                Debug.debug("moving down ... " + this.reloadId);
                ((DistributionPrefsForm)this.form).swap(index, index + 1);
            }
        }
        this.setLookupLists(subjectAreaList);
        if (((DistributionPrefsForm)this.form).getDistType() != null && !((DistributionPrefsForm)this.form).getDistType().equals("-")) {
            Vector<PreferenceLevel> prefs = new Vector<PreferenceLevel>();
            DistributionType dist = (DistributionType)new DistributionTypeDAO().get(Long.valueOf(((DistributionPrefsForm)this.form).getDistType()));
            ((DistributionPrefsForm)this.form).setDescription(dist.getDescr());
            boolean containsPref = false;
            for (PreferenceLevel pref : PreferenceLevel.getPreferenceLevelList()) {
                if (!dist.isAllowed(pref)) continue;
                prefs.addElement(pref);
                if (((DistributionPrefsForm)this.form).getPrefLevel() == null || ((DistributionPrefsForm)this.form).getPrefLevel().equals("-") || !pref.getPrefId().equals(Integer.valueOf(((DistributionPrefsForm)this.form).getPrefLevel()))) continue;
                containsPref = true;
            }
            if (!containsPref) {
                ((DistributionPrefsForm)this.form).setPrefLevel("-");
            }
            if (prefs.size() == 1) {
                ((DistributionPrefsForm)this.form).setPrefLevel(((PreferenceLevel)prefs.firstElement()).getPrefId().toString());
            }
            this.request.setAttribute(PreferenceLevel.PREF_LEVEL_ATTR_NAME, prefs);
            LookupTables.setupDistribTypes(this.request, this.sessionContext, dist);
        } else {
            this.request.setAttribute(PreferenceLevel.PREF_LEVEL_ATTR_NAME, new Vector(0));
            ((DistributionPrefsForm)this.form).setDescription("");
            LookupTables.setupDistribTypes(this.request, this.sessionContext, null);
        }
        if (((DistributionPrefsForm)this.form).getGrouping() != null && !((DistributionPrefsForm)this.form).getGrouping().equals("-")) {
            ((DistributionPrefsForm)this.form).setGroupingDescription(((DistributionPrefsForm)this.form).getStructure().getDescription());
        }
        if ("export".equals(this.op) && (((DistributionPrefsForm)this.form).getDistPrefId() == null || ((DistributionPrefsForm)this.form).getDistPrefId().length() == 0)) {
            OutputStream out = ExportUtils.getPdfOutputStream(this.response, "distprefs");
            new DistributionPrefsTableBuilder().getAllDistPrefsTableForCurrentUserAsPdf(out, this.sessionContext, ((DistributionPrefsForm)this.form).getFilterSubjectAreaId(), ((DistributionPrefsForm)this.form).getFilterCourseNbr());
            out.flush();
            out.close();
            return null;
        }
        if ("export-csv".equals(this.op) && (((DistributionPrefsForm)this.form).getDistPrefId() == null || ((DistributionPrefsForm)this.form).getDistPrefId().length() == 0)) {
            PrintWriter out = ExportUtils.getCsvWriter(this.response, "distprefs");
            new DistributionPrefsTableBuilder().getAllDistPrefsTableForCurrentUserAsCsv(out, this.sessionContext, ((DistributionPrefsForm)this.form).getFilterSubjectAreaId(), ((DistributionPrefsForm)this.form).getFilterCourseNbr());
            out.flush();
            out.close();
            return null;
        }
        this.request.setAttribute("listSize", (Object)(((DistributionPrefsForm)this.form).getSubjectArea() == null ? 0 : ((DistributionPrefsForm)this.form).getSubjectArea().size() - 1));
        if ("view".equals(this.op) && (((DistributionPrefsForm)this.form).getDistPrefId() == null || ((DistributionPrefsForm)this.form).getDistPrefId().isEmpty())) {
            String html;
            String subject = (String)this.sessionContext.getAttribute(SessionAttribute.OfferingsSubjectArea);
            if (subject != null && subject.indexOf(44) >= 0) {
                subject = subject.substring(0, subject.indexOf(44));
            }
            ((DistributionPrefsForm)this.form).setFilterSubjectAreaId(subject);
            ((DistributionPrefsForm)this.form).setFilterCourseNbr((String)this.sessionContext.getAttribute(SessionAttribute.OfferingsCourseNumber));
            DistributionPrefsTableBuilder tbl = new DistributionPrefsTableBuilder();
            if (((DistributionPrefsForm)this.form).getFilterSubjectAreaId() == null) {
                if (this.sessionContext.getUser().getCurrentAuthority().hasRight(Right.DepartmentIndependent)) {
                    ((DistributionPrefsForm)this.form).setFilterSubjectAreaId(Constants.BLANK_OPTION_VALUE);
                } else {
                    ((DistributionPrefsForm)this.form).setFilterSubjectAreaId(Constants.ALL_OPTION_VALUE);
                }
            }
            if ((html = tbl.getAllDistPrefsTableForCurrentUser(this.request, this.sessionContext, ((DistributionPrefsForm)this.form).getFilterSubjectAreaId(), ((DistributionPrefsForm)this.form).getFilterCourseNbr())) != null) {
                this.request.setAttribute("distPrefs", (Object)html);
            }
            BackTracker.markForBack(this.request, "distributionPrefs.action", MSG.backDistributionPreferences(), true, true);
            return "list";
        }
        return ((DistributionPrefsForm)this.form).getDistPrefId() == null || ((DistributionPrefsForm)this.form).getDistPrefId().length() == 0 ? "add" : "edit";
    }

    public List<ComboBoxLookup> setupSubjectAreas() throws Exception {
        TreeSet<SubjectArea> subjectAreas = SubjectArea.getUserSubjectAreas(this.sessionContext.getUser());
        if (subjectAreas == null) {
            return null;
        }
        ArrayList<ComboBoxLookup> v = new ArrayList<ComboBoxLookup>(subjectAreas.size());
        for (SubjectArea sa : subjectAreas) {
            v.add(new ComboBoxLookup(sa.getSubjectAreaAbbreviation(), sa.getUniqueId().toString()));
        }
        return v;
    }

    private void setLookupLists(List<ComboBoxLookup> subjectAreaList) {
        int ct = ((DistributionPrefsForm)this.form).getSubjectArea() == null ? 0 : ((DistributionPrefsForm)this.form).getSubjectArea().size();
        boolean suffix = ApplicationProperty.DistributionsShowClassSufix.isTrue();
        for (int index = 0; index < ct; ++index) {
            String subjectAreaId = ((DistributionPrefsForm)this.form).getSubjectArea(index);
            String courseNbr = ((DistributionPrefsForm)this.form).getCourseNbr(index);
            String subpart = ((DistributionPrefsForm)this.form).getItype(index);
            String classNumber = ((DistributionPrefsForm)this.form).getClassNumber(index);
            Vector<ComboBoxLookup> crsNumList = null;
            Vector<ComboBoxLookup> subpartList = null;
            Vector<ComboBoxLookup> classNumList = null;
            if (subjectAreaId != null) {
                if (subjectAreaId.equals("-") || subjectAreaId.equals(Constants.ALL_OPTION_VALUE)) {
                    crsNumList = new Vector<ComboBoxLookup>();
                    subpartList = new Vector<ComboBoxLookup>();
                    classNumList = new Vector<ComboBoxLookup>();
                } else {
                    ComboBoxLookup cbl;
                    Object a;
                    int i;
                    StringBuffer query = new StringBuffer();
                    query.append("select co.uniqueId, co.courseNbr, co.title ");
                    query.append("  from InstructionalOffering as io , CourseOffering co ");
                    query.append(" where co.subjectArea.uniqueId = :subjectAreaId ");
                    query.append("       and io.uniqueId = co.instructionalOffering.uniqueId ");
                    query.append("       and io.notOffered = false ");
                    query.append("       and co.isControl = true ");
                    query.append(" order by co.courseNbr ");
                    InstructionalOfferingDAO idao = new InstructionalOfferingDAO();
                    Session hibSession = idao.getSession();
                    Query q = hibSession.createQuery(query.toString());
                    q.setFetchSize(200);
                    q.setCacheable(true);
                    q.setLong("subjectAreaId", Long.parseLong(subjectAreaId));
                    List result = q.list();
                    crsNumList = new Vector();
                    if (result.size() > 0) {
                        for (i = 0; i < result.size(); ++i) {
                            a = (Object[])result.get(i);
                            cbl = new ComboBoxLookup(a[1].toString() + " - " + (a[2] == null ? "" : a[2].toString()), a[0].toString());
                            crsNumList.addElement(cbl);
                        }
                        if (result.size() == 1) {
                            ComboBoxLookup cbl2 = (ComboBoxLookup)crsNumList.elementAt(0);
                            ((DistributionPrefsForm)this.form).setCourseNbr(index, cbl2.getValue());
                            courseNbr = ((DistributionPrefsForm)this.form).getCourseNbr(index);
                        }
                    }
                    if (courseNbr.equals("-")) {
                        subpartList = new Vector();
                        classNumList = new Vector();
                    } else {
                        query = new StringBuffer();
                        query.append(" select distinct s ");
                        query.append("   from CourseOffering co, ");
                        query.append("        InstructionalOffering io, ");
                        query.append("        InstrOfferingConfig ioc, ");
                        query.append("        SchedulingSubpart s ");
                        query.append("  where co.uniqueId=:courseNbr ");
                        query.append("    and co.instructionalOffering.uniqueId=io.uniqueId ");
                        query.append("    and ioc.instructionalOffering.uniqueId=io.uniqueId ");
                        query.append("    and s.instrOfferingConfig.uniqueId=ioc.uniqueId ");
                        q = hibSession.createQuery(query.toString());
                        q.setFetchSize(200);
                        q.setCacheable(true);
                        q.setLong("courseNbr", Long.parseLong(courseNbr));
                        result = new Vector(q.list());
                        if (result != null && result.size() > 0) {
                            Collections.sort(result, new SchedulingSubpartComparator(subjectAreaId == null || subjectAreaId.length() == 0 ? null : Long.valueOf(subjectAreaId)));
                            subpartList = new Vector();
                            for (i = 0; i < result.size(); ++i) {
                                a = (SchedulingSubpart)result.get(i);
                                String ssid = ((BasePreferenceGroup)a).getUniqueId().toString();
                                String name = ((BaseSchedulingSubpart)a).getItype().getAbbv();
                                String sufix = ((SchedulingSubpart)a).getSchedulingSubpartSuffix();
                                while (((BaseSchedulingSubpart)a).getParentSubpart() != null) {
                                    name = "\u00a0\u00a0\u00a0\u00a0" + name;
                                    a = ((BaseSchedulingSubpart)a).getParentSubpart();
                                }
                                if (((BaseSchedulingSubpart)a).getInstrOfferingConfig().getInstructionalOffering().getInstrOfferingConfigs().size() > 1) {
                                    name = name + " [" + ((BaseSchedulingSubpart)a).getInstrOfferingConfig().getName() + "]";
                                }
                                ComboBoxLookup cbl3 = new ComboBoxLookup(name + (sufix == null || sufix.length() == 0 ? "" : " (" + sufix + ")"), ssid);
                                subpartList.addElement(cbl3);
                            }
                            if (subpartList.size() == 1) {
                                ComboBoxLookup cbl4 = (ComboBoxLookup)subpartList.elementAt(0);
                                ((DistributionPrefsForm)this.form).setItype(index, cbl4.getValue());
                                subpart = ((DistributionPrefsForm)this.form).getItype(index);
                            }
                        }
                        if (subpartList == null || subpartList.size() == 0) {
                            subpartList = new Vector();
                            this.addFieldError("classes", MSG.errorNoSupbartsExist());
                        }
                        if (subpart.equals("-")) {
                            classNumList = new Vector();
                        } else {
                            query = new StringBuffer();
                            query.append(" select distinct c ");
                            query.append("   from SchedulingSubpart s, ");
                            query.append("        Class_ c ");
                            query.append("  where s.uniqueId=:itype ");
                            query.append("    and s.uniqueId=c.schedulingSubpart.uniqueId ");
                            q = hibSession.createQuery(query.toString());
                            q.setFetchSize(200);
                            q.setCacheable(true);
                            q.setLong("itype", Long.parseLong(subpart));
                            result = q.list();
                            if (result != null && result.size() > 0) {
                                Collections.sort(result, new ClassComparator(5));
                                if (classNumber.equals("-")) {
                                    ((DistributionPrefsForm)this.form).setClassNumber(index, "-1");
                                }
                                classNumList = new Vector();
                                classNumList.addElement(new ComboBoxLookup(MSG.dropDistrPrefAll(), "-1"));
                                for (int i2 = 0; i2 < result.size(); ++i2) {
                                    String extId;
                                    Class_ clazz = (Class_)result.get(i2);
                                    cbl = new ComboBoxLookup(clazz.getSectionNumberString(), clazz.getUniqueId().toString());
                                    if (suffix && (extId = clazz.getClassSuffix(clazz.getSchedulingSubpart().getControllingCourseOffering())) != null && !extId.isEmpty() && !extId.equalsIgnoreCase(clazz.getSectionNumberString())) {
                                        cbl = new ComboBoxLookup(clazz.getSectionNumberString() + " - " + extId, clazz.getUniqueId().toString());
                                    }
                                    classNumList.addElement(cbl);
                                }
                            } else {
                                classNumList = new Vector();
                                this.addFieldError("classes", MSG.errorNoClassesExist());
                            }
                        }
                    }
                }
            }
            this.request.setAttribute("subjectAreaList" + index, subjectAreaList);
            this.request.setAttribute("courseNbrList" + index, crsNumList);
            this.request.setAttribute("itypeList" + index, subpartList);
            this.request.setAttribute("classNumList" + index, classNumList);
        }
    }

    private void doLoad(String distPrefId) {
        DistributionPrefDAO dpDao = new DistributionPrefDAO();
        DistributionPref dp = (DistributionPref)dpDao.get(Long.valueOf(distPrefId));
        ((DistributionPrefsForm)this.form).setDistType(dp.getDistributionType().getUniqueId().toString());
        ((DistributionPrefsForm)this.form).setStructure(dp.getStructure());
        ((DistributionPrefsForm)this.form).setOwner(dp.getOwner().getUniqueId().toString());
        ((DistributionPrefsForm)this.form).setPrefLevel(dp.getPrefLevel().getPrefId().toString());
        ((DistributionPrefsForm)this.form).setDistPrefId(distPrefId);
        for (DistributionObject dObj : new TreeSet<DistributionObject>(dp.getDistributionObjects())) {
            CourseOffering co;
            if (dObj.getPrefGroup() instanceof Class_) {
                Class_ c = (Class_)dObj.getPrefGroup();
                co = c.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getControllingCourseOffering();
                ((DistributionPrefsForm)this.form).getSubjectArea().add(co.getSubjectArea().getUniqueId().toString());
                ((DistributionPrefsForm)this.form).getCourseNbr().add(co.getUniqueId().toString());
                ((DistributionPrefsForm)this.form).getItype().add(c.getSchedulingSubpart().getUniqueId().toString());
                ((DistributionPrefsForm)this.form).getClassNumber().add(c.getUniqueId().toString());
                continue;
            }
            if (!(dObj.getPrefGroup() instanceof SchedulingSubpart)) continue;
            SchedulingSubpart ss = (SchedulingSubpart)dObj.getPrefGroup();
            co = ss.getInstrOfferingConfig().getInstructionalOffering().getControllingCourseOffering();
            ((DistributionPrefsForm)this.form).getSubjectArea().add(co.getSubjectArea().getUniqueId().toString());
            ((DistributionPrefsForm)this.form).getCourseNbr().add(co.getUniqueId().toString());
            ((DistributionPrefsForm)this.form).getItype().add(ss.getUniqueId().toString());
            ((DistributionPrefsForm)this.form).getClassNumber().add("-1");
        }
    }

    private void doAddOrUpdate() throws Exception {
        String distPrefId = ((DistributionPrefsForm)this.form).getDistPrefId();
        List<String> saList = ((DistributionPrefsForm)this.form).getSubjectArea();
        List<String> suList = ((DistributionPrefsForm)this.form).getItype();
        List<String> clList = ((DistributionPrefsForm)this.form).getClassNumber();
        DistributionPref dp = null;
        Department oldOwner = null;
        DistributionPrefDAO dpDao = new DistributionPrefDAO();
        Transaction tx = null;
        Session hibSession = dpDao.getSession();
        HashSet<InstructionalOffering> relatedInstructionalOfferings = new HashSet<InstructionalOffering>();
        try {
            tx = hibSession.beginTransaction();
            if (distPrefId != null && distPrefId.trim().length() > 0) {
                Long distPrefUid = Long.valueOf(distPrefId);
                if (distPrefUid > 0L) {
                    dp = (DistributionPref)dpDao.get(distPrefUid, hibSession);
                    Set<DistributionObject> s = dp.getDistributionObjects();
                    for (DistributionObject dObj : s) {
                        PreferenceGroup pg = dObj.getPrefGroup();
                        relatedInstructionalOfferings.add((pg instanceof Class_ ? ((Class_)pg).getSchedulingSubpart() : (SchedulingSubpart)pg).getInstrOfferingConfig().getInstructionalOffering());
                        pg.getDistributionObjects().remove(dObj);
                        hibSession.saveOrUpdate((Object)pg);
                    }
                    s.clear();
                    dp.setDistributionObjects(s);
                    oldOwner = (Department)dp.getOwner();
                }
            } else {
                dp = new DistributionPref();
            }
            dp.setDistributionType((DistributionType)new DistributionTypeDAO().get(Long.valueOf(((DistributionPrefsForm)this.form).getDistType()), hibSession));
            dp.setStructure(((DistributionPrefsForm)this.form).getStructure());
            dp.setPrefLevel(PreferenceLevel.getPreferenceLevel(Integer.parseInt(((DistributionPrefsForm)this.form).getPrefLevel())));
            BasePreferenceGroup owningDept = null;
            for (int i = 0; i < saList.size(); ++i) {
                String su = suList.get(i).toString();
                String cl = clList.get(i).toString();
                DistributionObject dObj = new DistributionObject();
                if (cl.equals("-1")) {
                    SchedulingSubpart subpart = (SchedulingSubpart)new SchedulingSubpartDAO().get(Long.valueOf(su), hibSession);
                    if (owningDept == null) {
                        owningDept = subpart.getManagingDept();
                    } else if (!owningDept.getUniqueId().equals(subpart.getManagingDept().getUniqueId())) {
                        if (((BaseDepartment)owningDept).getDistributionPrefPriority() < subpart.getManagingDept().getDistributionPrefPriority()) {
                            owningDept = subpart.getManagingDept();
                        } else if (((BaseDepartment)owningDept).getDistributionPrefPriority().intValue() == subpart.getManagingDept().getDistributionPrefPriority().intValue() && !this.sessionContext.getUser().getCurrentAuthority().hasQualifier((Qualifiable)((Object)owningDept)) && this.sessionContext.getUser().getCurrentAuthority().hasQualifier(subpart.getManagingDept())) {
                            owningDept = subpart.getManagingDept();
                        }
                    }
                    dObj.setPrefGroup(subpart);
                    relatedInstructionalOfferings.add(subpart.getInstrOfferingConfig().getInstructionalOffering());
                } else {
                    Class_ clazz = (Class_)new Class_DAO().get(Long.valueOf(cl), hibSession);
                    if (owningDept == null) {
                        owningDept = clazz.getManagingDept();
                    } else if (!((BaseDepartment)owningDept).equals(clazz.getManagingDept())) {
                        if (((BaseDepartment)owningDept).getDistributionPrefPriority() < clazz.getManagingDept().getDistributionPrefPriority()) {
                            owningDept = clazz.getManagingDept();
                        } else if (((BaseDepartment)owningDept).getDistributionPrefPriority().intValue() == clazz.getManagingDept().getDistributionPrefPriority().intValue() && !this.sessionContext.getUser().getCurrentAuthority().hasQualifier((Qualifiable)((Object)owningDept)) && this.sessionContext.getUser().getCurrentAuthority().hasQualifier(clazz.getManagingDept())) {
                            owningDept = clazz.getManagingDept();
                        }
                    }
                    relatedInstructionalOfferings.add(clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering());
                    dObj.setPrefGroup(clazz);
                }
                dObj.setSequenceNumber(i + 1);
                dObj.setDistributionPref(dp);
                dObj.getPrefGroup().getDistributionObjects().add(dObj);
                dp.addTodistributionObjects(dObj);
            }
            dp.setOwner((PreferenceGroup)owningDept);
            this.sessionContext.checkPermission(dp, Right.DistributionPreferenceEdit);
            hibSession.saveOrUpdate((Object)dp);
            Permission permissionOfferingLockNeeded = this.getPermission("permissionOfferingLockNeeded");
            ArrayList<Long> changedOfferingIds = new ArrayList<Long>();
            for (InstructionalOffering io : relatedInstructionalOfferings) {
                ChangeLog.addChange(hibSession, this.sessionContext, io, ChangeLog.Source.DIST_PREF_EDIT, distPrefId != null && distPrefId.trim().length() > 0 ? ChangeLog.Operation.UPDATE : ChangeLog.Operation.CREATE, io.getControllingCourseOffering().getSubjectArea(), null);
                if (!permissionOfferingLockNeeded.check(this.sessionContext.getUser(), io)) continue;
                changedOfferingIds.add(io.getUniqueId());
            }
            if (!changedOfferingIds.isEmpty()) {
                StudentSectioningQueue.offeringChanged(hibSession, this.sessionContext.getUser(), this.sessionContext.getUser().getCurrentAcademicSessionId(), changedOfferingIds);
            }
            tx.commit();
            hibSession.flush();
            hibSession.refresh((Object)dp.getOwner());
            if (oldOwner != null && !oldOwner.equals(dp.getOwner())) {
                hibSession.refresh((Object)oldOwner);
            }
            ((DistributionPrefsForm)this.form).setDistPrefId(dp.getUniqueId().toString());
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            hibSession.clear();
            throw e;
        }
    }

    private void doDelete(String distPrefId) {
        block7: {
            Transaction tx = null;
            try {
                DistributionPrefDAO dpDao = new DistributionPrefDAO();
                Session hibSession = dpDao.getSession();
                tx = hibSession.getTransaction();
                if (tx == null || !tx.isActive()) {
                    tx = hibSession.beginTransaction();
                }
                HashSet<InstructionalOffering> relatedInstructionalOfferings = new HashSet<InstructionalOffering>();
                DistributionPref dp = (DistributionPref)dpDao.get(Long.valueOf(distPrefId));
                this.sessionContext.checkPermission(dp, Right.DistributionPreferenceDelete);
                Department dept = (Department)dp.getOwner();
                dept.getPreferences().remove(dp);
                for (DistributionObject dObj : dp.getDistributionObjects()) {
                    PreferenceGroup pg = dObj.getPrefGroup();
                    relatedInstructionalOfferings.add((pg instanceof Class_ ? ((Class_)pg).getSchedulingSubpart() : (SchedulingSubpart)pg).getInstrOfferingConfig().getInstructionalOffering());
                    pg.getDistributionObjects().remove(dObj);
                    hibSession.saveOrUpdate((Object)pg);
                }
                hibSession.delete((Object)dp);
                hibSession.saveOrUpdate((Object)dept);
                Permission permissionOfferingLockNeeded = this.getPermission("permissionOfferingLockNeeded");
                ArrayList<Long> changedOfferingIds = new ArrayList<Long>();
                for (InstructionalOffering io : relatedInstructionalOfferings) {
                    ChangeLog.addChange(hibSession, this.sessionContext, io, ChangeLog.Source.DIST_PREF_EDIT, ChangeLog.Operation.DELETE, io.getControllingCourseOffering().getSubjectArea(), null);
                    if (!permissionOfferingLockNeeded.check(this.sessionContext.getUser(), io)) continue;
                    changedOfferingIds.add(io.getUniqueId());
                }
                if (!changedOfferingIds.isEmpty()) {
                    StudentSectioningQueue.offeringChanged(hibSession, this.sessionContext.getUser(), this.sessionContext.getUser().getCurrentAcademicSessionId(), changedOfferingIds);
                }
                if (tx != null && tx.isActive()) {
                    tx.commit();
                }
                hibSession.flush();
                hibSession.refresh((Object)dept);
            }
            catch (Exception e) {
                Debug.error(e);
                if (tx == null || !tx.isActive()) break block7;
                tx.rollback();
            }
        }
    }

    public String getFocusElement() {
        if (this.request.getAttribute("addedClass") != null) {
            return "subjectArea[" + this.request.getAttribute("addedClass").toString() + "]";
        }
        if (this.request.getAttribute("distPrefs") != null) {
            return null;
        }
        return "distType";
    }
}

