/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.util.Iterator;
import java.util.TreeSet;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.tiles.annotation.TilesDefinition;
import org.apache.struts2.tiles.annotation.TilesDefinitions;
import org.apache.struts2.tiles.annotation.TilesPutAttribute;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.unitime.commons.Debug;
import org.unitime.commons.web.WebTable;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.form.DeptStatusTypeEditForm;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.dao.DepartmentStatusTypeDAO;
import org.unitime.timetable.security.rights.Right;

@Action(value="deptStatusTypeEdit", results={@Result(name={"list"}, type="tiles", location="deptStatusTypes.tiles"), @Result(name={"add"}, type="tiles", location="deptStatusTypeAdd.tiles"), @Result(name={"edit"}, type="tiles", location="deptStatusTypeEdit.tiles")})
@TilesDefinitions(value={@TilesDefinition(name="deptStatusTypes.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Status Types"), @TilesPutAttribute(name="body", value="/admin/deptStatusTypeEdit.jsp")}), @TilesDefinition(name="deptStatusTypeAdd.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Add Status Type"), @TilesPutAttribute(name="body", value="/admin/deptStatusTypeEdit.jsp")}), @TilesDefinition(name="deptStatusTypeEdit.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Edit Status Type"), @TilesPutAttribute(name="body", value="/admin/deptStatusTypeEdit.jsp")})})
public class DeptStatusTypeEditAction
extends UniTimeAction<DeptStatusTypeEditForm> {
    private static final long serialVersionUID = -8502240944652360463L;
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    private Long id;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String execute() throws Exception {
        Session hibSession;
        Transaction tx;
        if (this.form == null) {
            this.form = new DeptStatusTypeEditForm();
        }
        this.sessionContext.checkPermission(Right.StatusTypes);
        if (this.op == null) {
            this.op = ((DeptStatusTypeEditForm)this.form).getOp();
        }
        if (this.op == null) {
            ((DeptStatusTypeEditForm)this.form).reset();
        }
        if (MSG.actionBackToStatusTypes().equals(this.op)) {
            ((DeptStatusTypeEditForm)this.form).reset();
        }
        if (MSG.actionAddStatusType().equals(this.op)) {
            ((DeptStatusTypeEditForm)this.form).load(null);
        }
        if (MSG.actionUpdateStatusType().equals(this.op) || MSG.actionSaveStatusType().equals(this.op)) {
            ((DeptStatusTypeEditForm)this.form).validate(this);
            if (this.hasFieldErrors()) {
                ((DeptStatusTypeEditForm)this.form).setOp(this.op);
            } else {
                tx = null;
                try {
                    hibSession = new DepartmentStatusTypeDAO().getSession();
                    if (hibSession.getTransaction() == null || !hibSession.getTransaction().isActive()) {
                        tx = hibSession.beginTransaction();
                    }
                    ((DeptStatusTypeEditForm)this.form).saveOrUpdate(hibSession);
                    if (tx != null) {
                        tx.commit();
                    }
                }
                catch (Exception e) {
                    if (tx != null) {
                        tx.rollback();
                    }
                    throw e;
                }
                ((DeptStatusTypeEditForm)this.form).reset();
            }
        }
        if ("Edit".equals(this.op)) {
            if (this.id == null) {
                this.addFieldError("form.uniqueId", MSG.errorRequiredField(MSG.fieldId()));
            } else {
                DepartmentStatusType s = (DepartmentStatusType)DepartmentStatusTypeDAO.getInstance().get(this.id);
                if (s == null) {
                    this.addFieldError("form.uniqueId", MSG.errorDoesNotExists(this.id.toString()));
                } else {
                    ((DeptStatusTypeEditForm)this.form).load(s);
                }
            }
        }
        if (MSG.actionDeleteStatusType().equals(this.op)) {
            tx = null;
            try {
                hibSession = new DepartmentStatusTypeDAO().getSession();
                if (hibSession.getTransaction() == null || !hibSession.getTransaction().isActive()) {
                    tx = hibSession.beginTransaction();
                }
                ((DeptStatusTypeEditForm)this.form).delete(hibSession);
                tx.commit();
            }
            catch (Exception e) {
                if (tx != null) {
                    tx.rollback();
                }
                throw e;
            }
            ((DeptStatusTypeEditForm)this.form).reset();
        }
        if ("Move Up".equals(this.op) || "Move Down".equals(this.op)) {
            tx = null;
            try {
                hibSession = new DepartmentStatusTypeDAO().getSession();
                if (hibSession.getTransaction() == null || !hibSession.getTransaction().isActive()) {
                    tx = hibSession.beginTransaction();
                }
                DepartmentStatusType curStatus = (DepartmentStatusType)new DepartmentStatusTypeDAO().get(this.id);
                if ("Move Up".equals(this.op)) {
                    boolean found = false;
                    for (DepartmentStatusType s : DepartmentStatusType.findAll()) {
                        if (s.getOrd() + 1 != curStatus.getOrd()) continue;
                        s.setOrd(s.getOrd() + 1);
                        hibSession.saveOrUpdate((Object)s);
                        found = true;
                    }
                    if (found) {
                        curStatus.setOrd(curStatus.getOrd() - 1);
                        ((DeptStatusTypeEditForm)this.form).setOrder(curStatus.getOrd());
                        hibSession.saveOrUpdate((Object)curStatus);
                    }
                } else {
                    boolean found = false;
                    for (DepartmentStatusType s : DepartmentStatusType.findAll()) {
                        if (s.getOrd() - 1 != curStatus.getOrd()) continue;
                        s.setOrd(s.getOrd() - 1);
                        hibSession.saveOrUpdate((Object)s);
                        found = true;
                    }
                    if (found) {
                        curStatus.setOrd(curStatus.getOrd() + 1);
                        ((DeptStatusTypeEditForm)this.form).setOrder(curStatus.getOrd());
                        hibSession.saveOrUpdate((Object)curStatus);
                    }
                }
                if (tx != null) {
                    tx.commit();
                }
            }
            catch (Exception e) {
                if (tx != null) {
                    tx.rollback();
                }
                Debug.error(e);
            }
            ((DeptStatusTypeEditForm)this.form).reset();
        }
        if ("List".equals(((DeptStatusTypeEditForm)this.form).getOp())) {
            return "list";
        }
        return ((DeptStatusTypeEditForm)this.form).getUniqueId() == null || ((DeptStatusTypeEditForm)this.form).getUniqueId() < 0L ? "add" : "edit";
    }

    public String getTable() {
        WebTable.setOrder(this.sessionContext, "deptStatusTypes.ord", this.request.getParameter("ord"), 2);
        WebTable webTable = new WebTable(5, null, "deptStatusTypeEdit.action?ord=%%", new String[]{"", MSG.fieldReference(), MSG.fieldLabel(), MSG.fieldApply(), MSG.fieldRights()}, new String[]{"left", "left", "left", "left", "left"}, null);
        TreeSet statuses = DepartmentStatusType.findAll();
        if (statuses.isEmpty()) {
            webTable.addLine(null, new String[]{MSG.infoNoStatusTypes()}, null, null);
        }
        int ord = 0;
        Iterator i = statuses.iterator();
        while (i.hasNext()) {
            String r;
            DepartmentStatusType s = (DepartmentStatusType)i.next();
            if (ord != s.getOrd()) {
                s.setOrd(ord);
                DepartmentStatusTypeDAO.getInstance().saveOrUpdate(s);
            }
            ++ord;
            String onClick = "onClick=\"document.location='deptStatusTypeEdit.action?op=Edit&id=" + s.getUniqueId() + "';\"";
            String rights = "";
            String apply = "";
            if (s.applyDepartment()) {
                apply = s.applySession() ? (s.applyExamStatus() ? MSG.applyToAll() : MSG.applyToSessionAndDepartment().replace("&", "&amp;")) : MSG.applyToDepartment();
            } else if (s.applySession()) {
                apply = MSG.applyToSession();
            } else if (s.applyExamStatus()) {
                apply = MSG.applyToExaminations();
            }
            if (s.isAllowRollForward()) {
                if (rights.length() > 0) {
                    rights = rights + "; ";
                }
                rights = rights + MSG.rightRollFoward();
            }
            if (s.canOwnerView() || s.canOwnerLimitedEdit() || s.canOwnerEdit()) {
                if (rights.length() > 0) {
                    rights = rights + "; ";
                }
                if (s.canOwnerView() && s.canOwnerEdit()) {
                    rights = rights + MSG.rightOwnerCan(MSG.rightViewAndEdit());
                } else {
                    r = null;
                    if (s.canOwnerView()) {
                        r = MSG.rightView();
                    }
                    if (s.canOwnerEdit()) {
                        r = r != null ? MSG.rightAnd(r, MSG.rightEdit()) : MSG.rightEdit();
                    } else if (s.canOwnerLimitedEdit()) {
                        r = r != null ? MSG.rightAnd(r, MSG.rightLimitedEdit()) : MSG.rightLimitedEdit();
                    }
                    rights = rights + MSG.rightOwnerCan(r);
                }
            }
            if (s.canManagerView() || s.canManagerLimitedEdit() || s.canManagerEdit()) {
                if (rights.length() > 0) {
                    rights = rights + "; ";
                }
                if (s.canManagerView() && s.canManagerEdit()) {
                    rights = rights + MSG.rightManagerCan(MSG.rightViewAndEdit());
                } else {
                    r = null;
                    if (s.canManagerView()) {
                        r = MSG.rightView();
                    }
                    if (s.canManagerEdit()) {
                        r = r != null ? MSG.rightAnd(r, MSG.rightEdit()) : MSG.rightEdit();
                    } else if (s.canManagerLimitedEdit()) {
                        r = r != null ? MSG.rightAnd(r, MSG.rightLimitedEdit()) : MSG.rightLimitedEdit();
                    }
                    rights = rights + MSG.rightManagerCan(r);
                }
            }
            if (s.canAudit()) {
                if (rights.length() > 0) {
                    rights = rights + "; ";
                }
                rights = rights + MSG.rightAudit();
            }
            if (s.canTimetable()) {
                if (rights.length() > 0) {
                    rights = rights + "; ";
                }
                rights = rights + MSG.rightTimetable();
            }
            if (s.canCommit()) {
                if (rights.length() > 0) {
                    rights = rights + "; ";
                }
                rights = rights + MSG.rightCommit();
            }
            if (s.canExamView() || s.canExamEdit() || s.canExamTimetable()) {
                if (rights.length() > 0) {
                    rights = rights + "; ";
                }
                if (s.canExamEdit() && s.canExamTimetable()) {
                    rights = rights + MSG.rightExam(MSG.rightEditAndTimetable());
                } else {
                    r = null;
                    if (s.canExamView()) {
                        r = MSG.rightView();
                    }
                    if (s.canExamEdit()) {
                        r = r != null ? MSG.rightAnd(r, MSG.rightEdit()) : MSG.rightEdit();
                    } else if (s.canExamTimetable()) {
                        r = r != null ? MSG.rightAnd(r, MSG.rightTimetable()) : MSG.rightTimetable();
                    }
                    rights = rights + MSG.rightExam(r);
                }
            }
            if (s.canOnlineSectionStudents()) {
                if (rights.length() > 0) {
                    rights = rights + "; ";
                }
                rights = rights + MSG.rightSectioning();
            } else if (s.canSectionAssistStudents()) {
                if (rights.length() > 0) {
                    rights = rights + "; ";
                }
                rights = rights + MSG.rightAssitant();
            } else if (s.canPreRegisterStudents()) {
                if (rights.length() > 0) {
                    rights = rights + "; ";
                }
                rights = rights + MSG.rightRegistration();
            }
            if (s.isEventManagement()) {
                if (rights.length() > 0) {
                    rights = rights + "; ";
                }
                rights = rights + MSG.rightEvents();
            }
            if (s.isAllowNoRole() || s.canNoRoleReportExamFinal() || s.canNoRoleReportExamMidterm() || s.canNoRoleReportClass()) {
                if (rights.length() > 0) {
                    rights = rights + "; ";
                }
                if (s.canNoRoleReportExamFinal() && s.canNoRoleReportExamMidterm() && s.canNoRoleReportClass()) {
                    rights = rights + MSG.rightNoRoleCan(MSG.rightSeeAllEvents());
                } else {
                    r = null;
                    if (s.canNoRoleReportClass()) {
                        r = MSG.rightSeeClasses();
                    }
                    if (s.canNoRoleReportExamFinal() && s.canNoRoleReportExamMidterm()) {
                        r = r != null ? MSG.rightAnd(r, MSG.rightSeeExams()) : MSG.rightSeeExams();
                    } else {
                        if (s.canNoRoleReportExamFinal()) {
                            r = r != null ? MSG.rightAnd(r, MSG.rightSeeFinalExams()) : MSG.rightSeeFinalExams();
                        }
                        if (s.canNoRoleReportExamMidterm()) {
                            r = r != null ? MSG.rightAnd(r, MSG.rightSeeMidtermExams()) : MSG.rightSeeMidtermExams();
                        }
                    }
                    if (r == null) {
                        r = "";
                    }
                    rights = rights + MSG.rightNoRoleCan(r);
                }
            }
            if (s.isTestSession()) {
                if (rights.length() > 0) {
                    rights = rights + "; ";
                }
                rights = rights + MSG.rightTestSession();
            }
            String ops = "";
            ops = s.getOrd() > 0 ? ops + "<img src='images/arrow_up.png' border='0' align='absmiddle' title='Move Up' onclick=\"document.getElementById('op').value='Move Up';document.getElementById('id').value='" + s.getUniqueId() + "'; submit(); event.cancelBubble=true;\">" : ops + "<img src='images/blank.png' border='0' align='absmiddle'>";
            ops = i.hasNext() ? ops + "<img src='images/arrow_down.png' border='0' align='absmiddle' title='Move Down' onclick=\"document.getElementById('op').value='Move Down';document.getElementById('id').value='" + s.getUniqueId() + "'; submit(); event.cancelBubble=true;\">" : ops + "<img src='images/blank.png' border='0' align='absmiddle'>";
            webTable.addLine(onClick, new String[]{ops, s.getReference(), s.getLabel(), apply, rights}, new Comparable[]{s.getOrd(), s.getOrd(), s.getLabel(), s.getApply(), s.getStatus()});
        }
        return webTable.printTable(WebTable.getOrder(this.sessionContext, "deptStatusTypes.ord"));
    }

    public int getLast() {
        return DepartmentStatusType.findAll().size() - 1;
    }
}

