/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.commons.jgroups;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Future;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.PhysicalAddress;
import org.jgroups.View;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.conf.PropertyConverters;
import org.jgroups.protocols.Discovery;
import org.jgroups.protocols.PingData;
import org.jgroups.protocols.PingHeader;
import org.jgroups.util.BoundedList;
import org.jgroups.util.Responses;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Tuple;
import org.jgroups.util.UUID;
import org.jgroups.util.Util;
import org.unitime.timetable.model.ClusterDiscovery;
import org.unitime.timetable.model.dao.ClusterDiscoveryDAO;

public class UniTimeClusterDiscovery
extends Discovery {
    protected Future<?> info_writer;
    @Property(description="Removes the table contents a view change. Enabling this can help removing crashed members that are still in the table, but generates more DB traffic")
    protected boolean clear_table_on_view_change = true;
    @Property(description="The max number of times my own information should be written to the DB after a view change")
    protected int info_writer_max_writes_after_view = 5;
    @Property(description="Interval (in ms) at which the info writer should kick in")
    protected long info_writer_sleep_time = 10000L;
    @Property(description="Number of additional ports to be probed for membership. A port_range of 0 does not probe additional ports. Example: initial_hosts=A[7800] port_range=0 probes A:7800, port_range=1 probes A:7800 and A:7801")
    private int port_range = 1;
    @Property(name="initial_hosts", description="Comma delimited list of hosts to be contacted for initial membership", converter=PropertyConverters.InitialHosts.class, dependsUpon="port_range", systemProperty={"jgroups.tcpping.initial_hosts"})
    private List<PhysicalAddress> initial_hosts = Collections.emptyList();
    @Property(description="max number of hosts to keep beyond the ones in initial_hosts")
    protected int max_dynamic_hosts = 2000;
    protected BoundedList<PhysicalAddress> dynamic_hosts;

    public boolean isDynamic() {
        return true;
    }

    @ManagedAttribute(description="Whether the InfoWriter task is running")
    public synchronized boolean isInfoWriterRunning() {
        return this.info_writer != null && !this.info_writer.isDone();
    }

    @ManagedOperation(description="Causes the member to write its own information into the DB, replacing an existing entry")
    public void writeInfo() {
        this.writeOwnInformation();
    }

    public List<PhysicalAddress> getInitialHosts() {
        return this.initial_hosts;
    }

    public void setInitialHosts(List<PhysicalAddress> initial_hosts) {
        this.initial_hosts = initial_hosts;
    }

    public int getPortRange() {
        return this.port_range;
    }

    public void setPortRange(int port_range) {
        this.port_range = port_range;
    }

    @ManagedAttribute
    public String getDynamicHostList() {
        return this.dynamic_hosts.toString();
    }

    @ManagedOperation
    public void clearDynamicHostList() {
        this.dynamic_hosts.clear();
    }

    @ManagedAttribute
    public String getInitialHostsList() {
        return this.initial_hosts.toString();
    }

    public void init() throws Exception {
        super.init();
        this.dynamic_hosts = new BoundedList(this.max_dynamic_hosts);
    }

    public void stop() {
        this.stopInfoWriter();
        this.deleteSelf();
        super.stop();
    }

    public Object down(Event evt) {
        switch (evt.getType()) {
            case 6: {
                View old_view = this.view;
                boolean previous_coord = this.is_coord;
                Object retval = super.down(evt);
                View new_view = (View)evt.getArg();
                this.handleView(new_view, old_view, previous_coord != this.is_coord);
                for (Address logical_addr : this.members) {
                    PhysicalAddress physical_addr = (PhysicalAddress)this.down_prot.down(new Event(87, (Object)logical_addr));
                    if (physical_addr == null || this.initial_hosts.contains(physical_addr)) continue;
                    this.dynamic_hosts.addIfAbsent((Object)physical_addr);
                }
                return retval;
            }
            case 89: {
                Object retval = super.down(evt);
                Tuple tuple = (Tuple)evt.getArg();
                PhysicalAddress physical_addr = (PhysicalAddress)tuple.getVal2();
                if (physical_addr != null && !this.initial_hosts.contains(physical_addr)) {
                    this.dynamic_hosts.addIfAbsent((Object)physical_addr);
                }
                return retval;
            }
        }
        return super.down(evt);
    }

    public void discoveryRequestReceived(Address sender, String logical_name, PhysicalAddress physical_addr) {
        super.discoveryRequestReceived(sender, logical_name, physical_addr);
        if (physical_addr != null && !this.initial_hosts.contains(physical_addr)) {
            this.dynamic_hosts.addIfAbsent((Object)physical_addr);
        }
    }

    public void findMembers(List<Address> members, boolean initial_discovery, Responses responses) {
        Collection list;
        PhysicalAddress physical_addr = (PhysicalAddress)this.down(new Event(87, (Object)this.local_addr));
        PingData data = new PingData(this.local_addr, false, UUID.get((Address)this.local_addr), physical_addr);
        PingHeader hdr = new PingHeader(1).clusterName(this.cluster_name);
        ArrayList<PhysicalAddress> cluster_members = new ArrayList<PhysicalAddress>(this.initial_hosts.size() + (this.dynamic_hosts != null ? this.dynamic_hosts.size() : 0) + 5);
        for (PhysicalAddress physicalAddress : this.initial_hosts) {
            if (cluster_members.contains(physicalAddress)) continue;
            cluster_members.add(physicalAddress);
        }
        if (this.dynamic_hosts != null) {
            for (PhysicalAddress physicalAddress : this.dynamic_hosts) {
                if (cluster_members.contains(physicalAddress)) continue;
                cluster_members.add(physicalAddress);
            }
        }
        if (this.use_disk_cache && (list = (Collection)this.down_prot.down(new Event(102))) != null) {
            for (PhysicalAddress phys_addr : list) {
                if (cluster_members.contains(phys_addr)) continue;
                cluster_members.add(phys_addr);
            }
        }
        for (PhysicalAddress physicalAddress : cluster_members) {
            if (physical_addr != null && physicalAddress.equals(physical_addr)) continue;
            final Message msg = new Message((Address)physicalAddress).setFlag(new Message.Flag[]{Message.Flag.INTERNAL, Message.Flag.DONT_BUNDLE, Message.Flag.OOB}).putHeader(this.id, (Header)hdr).setBuffer(UniTimeClusterDiscovery.marshal((PingData)data));
            if (this.async_discovery_use_separate_thread_per_request) {
                this.timer.execute(new Runnable(){

                    @Override
                    public void run() {
                        UniTimeClusterDiscovery.this.log.trace("%s: sending discovery request to %s", new Object[]{UniTimeClusterDiscovery.this.local_addr, msg.getDest()});
                        UniTimeClusterDiscovery.this.down_prot.down(new Event(1, (Object)msg));
                    }
                });
                continue;
            }
            this.log.trace("%s: sending discovery request to %s", new Object[]{this.local_addr, msg.getDest()});
            this.down_prot.down(new Event(1, (Object)msg));
        }
        this.readAll(members, responses);
        this.update(new PingData(this.local_addr, this.is_server, UUID.get((Address)this.local_addr), physical_addr).coord(this.is_coord));
    }

    protected void handleView(View new_view, View old_view, boolean coord_changed) {
        if (this.is_coord) {
            if (this.clear_table_on_view_change) {
                this.clearTable();
            } else if (old_view != null && new_view != null) {
                Address[] left_mbrs;
                Address[][] diff = View.diff((View)old_view, (View)new_view);
                for (Address left_mbr : left_mbrs = diff[1]) {
                    if (left_mbr == null || new_view.containsMember(left_mbr)) continue;
                    this.remove(left_mbr);
                }
            }
        }
        if (coord_changed || this.clear_table_on_view_change) {
            this.writeOwnInformation();
        }
        if (this.info_writer_max_writes_after_view > 0) {
            this.startInfoWriter();
        }
    }

    protected void writeOwnInformation() {
        PhysicalAddress physical_addr = (PhysicalAddress)this.down(new Event(87, (Object)this.local_addr));
        this.update(new PingData(this.local_addr, this.is_server, UUID.get((Address)this.local_addr), physical_addr).coord(this.is_coord));
    }

    protected synchronized void startInfoWriter() {
        if (this.info_writer == null || this.info_writer.isDone()) {
            this.info_writer = this.timer.scheduleWithDynamicInterval((TimeScheduler.Task)new InfoWriter(this.info_writer_max_writes_after_view, this.info_writer_sleep_time));
        }
    }

    protected synchronized void stopInfoWriter() {
        if (this.info_writer != null) {
            this.info_writer.cancel(false);
        }
    }

    protected void deleteSelf() {
        this.remove(this.local_addr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readAll(List<Address> members, Responses responses) {
        if (!ClusterDiscoveryDAO.isConfigured()) {
            return;
        }
        Transaction tx = null;
        try (Session hibSession = ClusterDiscoveryDAO.getInstance().createNewSession();){
            tx = hibSession.beginTransaction();
            for (ClusterDiscovery cluster : hibSession.createQuery("from ClusterDiscovery where clusterName = :clusterName").setString("clusterName", this.cluster_name).list()) {
                try {
                    PingData data = UniTimeClusterDiscovery.deserialize((byte[])cluster.getPingData());
                    if (data == null || members != null && !members.contains(data.getAddress())) continue;
                    responses.addResponse(data, false);
                    if (this.local_addr == null || this.local_addr.equals(data.getAddress())) continue;
                    this.addDiscoveryResponseToCaches(data.getAddress(), data.getLogicalName(), data.getPhysicalAddr());
                }
                catch (Exception e) {
                    hibSession.delete((Object)cluster);
                }
            }
            if (tx != null) {
                tx.commit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean contains(Address addr) {
        if (!ClusterDiscoveryDAO.isConfigured()) {
            return false;
        }
        String own_address = UniTimeClusterDiscovery.addressAsString((Address)addr);
        try (Session hibSession = ClusterDiscoveryDAO.getInstance().createNewSession();){
            ClusterDiscovery cluster = (ClusterDiscovery)ClusterDiscoveryDAO.getInstance().get(new ClusterDiscovery(own_address, this.cluster_name), hibSession);
            boolean bl = cluster != null;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove(Address addr) {
        if (!ClusterDiscoveryDAO.isConfigured()) {
            return;
        }
        Session hibSession = ClusterDiscoveryDAO.getInstance().createNewSession();
        String own_address = UniTimeClusterDiscovery.addressAsString((Address)addr);
        Transaction tx = null;
        try {
            tx = hibSession.beginTransaction();
            ClusterDiscovery cluster = (ClusterDiscovery)ClusterDiscoveryDAO.getInstance().get(new ClusterDiscovery(own_address, this.cluster_name), hibSession);
            if (cluster != null) {
                hibSession.delete((Object)cluster);
            }
            hibSession.flush();
            if (tx != null) {
                tx.commit();
            }
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            this.log.info("Failed to delete data for cluster " + this.cluster_name + ": " + e.getMessage());
        }
        finally {
            hibSession.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void update(PingData data) {
        if (!ClusterDiscoveryDAO.isConfigured()) {
            return;
        }
        Session hibSession = ClusterDiscoveryDAO.getInstance().createNewSession();
        String own_address = UniTimeClusterDiscovery.addressAsString((Address)data.getAddress());
        Transaction tx = null;
        try {
            tx = hibSession.beginTransaction();
            ClusterDiscovery cluster = (ClusterDiscovery)ClusterDiscoveryDAO.getInstance().get(new ClusterDiscovery(own_address, this.cluster_name), hibSession);
            if (cluster == null) {
                cluster = new ClusterDiscovery(own_address, this.cluster_name);
            }
            cluster.setPingData(this.serializeWithoutView(data));
            cluster.setTimeStamp(new Date());
            hibSession.saveOrUpdate((Object)cluster);
            hibSession.flush();
            if (tx != null) {
                tx.commit();
            }
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            this.log.info("Failed to update my data for cluster " + this.cluster_name + ": " + e.getMessage());
        }
        finally {
            hibSession.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearTable() {
        if (!ClusterDiscoveryDAO.isConfigured()) {
            return;
        }
        Transaction tx = null;
        try (Session hibSession = ClusterDiscoveryDAO.getInstance().createNewSession();){
            tx = hibSession.beginTransaction();
            hibSession.createQuery("delete ClusterDiscovery where clusterName = :clusterName").setString("clusterName", this.cluster_name).executeUpdate();
            if (tx != null) {
                tx.commit();
            }
        }
    }

    static {
        ClassConfigurator.addProtocol((short)666, UniTimeClusterDiscovery.class);
    }

    protected class InfoWriter
    implements TimeScheduler.Task {
        protected final int max_writes;
        protected int num_writes;
        protected final long sleep_interval;

        public InfoWriter(int max_writes, long sleep_interval) {
            this.max_writes = max_writes;
            this.sleep_interval = sleep_interval;
        }

        public long nextInterval() {
            if (++this.num_writes > this.max_writes) {
                return 0L;
            }
            return Math.max(1000L, Util.random((long)this.sleep_interval));
        }

        public void run() {
            if (!UniTimeClusterDiscovery.this.contains(UniTimeClusterDiscovery.this.local_addr)) {
                UniTimeClusterDiscovery.this.writeOwnInformation();
            }
        }
    }
}

