/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.commons.hibernate.blob;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.usertype.UserType;

public class XmlBlobType
implements UserType {
    protected static Log sLog = LogFactory.getLog(XmlBlobType.class);

    public Object nullSafeGet(ResultSet rs, String[] names, SessionImplementor session, Object owner) throws SQLException {
        Blob blob = rs.getBlob(names[0]);
        if (blob == null) {
            return null;
        }
        try {
            SAXReader reader = new SAXReader();
            GZIPInputStream gzipInput = new GZIPInputStream(blob.getBinaryStream());
            Document document = reader.read((InputStream)gzipInput);
            gzipInput.close();
            return document;
        }
        catch (IOException e) {
            throw new HibernateException(e.getMessage(), (Throwable)e);
        }
        catch (DocumentException e) {
            throw new HibernateException(e.getMessage(), (Throwable)e);
        }
    }

    public void nullSafeSet(PreparedStatement ps, Object value, int index, SessionImplementor session) throws SQLException, HibernateException {
        if (value == null) {
            ps.setNull(index, this.sqlTypes()[0]);
        } else {
            try {
                ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                XMLWriter writer = new XMLWriter((OutputStream)new GZIPOutputStream(bytes), OutputFormat.createCompactFormat());
                writer.write((Document)value);
                writer.flush();
                writer.close();
                ps.setBinaryStream(index, (InputStream)new ByteArrayInputStream(bytes.toByteArray(), 0, bytes.size()), bytes.size());
            }
            catch (IOException e) {
                throw new HibernateException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public Object deepCopy(Object value) {
        if (value == null) {
            return null;
        }
        return ((Document)value).clone();
    }

    public boolean isMutable() {
        return false;
    }

    public int[] sqlTypes() {
        return new int[]{2004};
    }

    public Class returnedClass() {
        return Document.class;
    }

    public boolean equals(Object x, Object y) {
        if (x == null) {
            return y == null;
        }
        if (y == null) {
            return false;
        }
        if (!x.getClass().getName().equals(y.getClass().getName())) {
            return false;
        }
        if (x instanceof Document) {
            Document a = (Document)x;
            Document b = (Document)y;
            return this.equals(a.getName(), b.getName()) && this.equals(a.getRootElement(), b.getRootElement());
        }
        if (x instanceof Element) {
            Element a = (Element)x;
            Element b = (Element)y;
            return this.equals(a.getName(), b.getName()) && this.equals(a.getText(), b.getText()) && this.equals(a.attributes(), b.attributes()) && this.equals(a.elements(), b.elements());
        }
        if (x instanceof Attribute) {
            Attribute a = (Attribute)x;
            Attribute b = (Attribute)y;
            return this.equals(a.getName(), b.getName()) && this.equals(a.getValue(), b.getValue());
        }
        if (x instanceof List) {
            List a = (List)x;
            List b = (List)y;
            if (a.size() != b.size()) {
                return false;
            }
            for (int i = 0; i < a.size(); ++i) {
                if (this.equals(a.get(i), b.get(i))) continue;
                return false;
            }
            return true;
        }
        return x.equals(y);
    }

    public Serializable disassemble(Object value) throws HibernateException {
        try {
            if (value == null) {
                return null;
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            XMLWriter writer = new XMLWriter((OutputStream)new GZIPOutputStream(out), OutputFormat.createCompactFormat());
            writer.write((Document)value);
            writer.flush();
            writer.close();
            return out.toByteArray();
        }
        catch (UnsupportedEncodingException e) {
            throw new HibernateException(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new HibernateException(e.getMessage(), (Throwable)e);
        }
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        try {
            if (cached == null) {
                return null;
            }
            ByteArrayInputStream in = new ByteArrayInputStream((byte[])cached);
            SAXReader reader = new SAXReader();
            GZIPInputStream gzipInput = new GZIPInputStream(in);
            Document document = reader.read((InputStream)gzipInput);
            gzipInput.close();
            return document;
        }
        catch (DocumentException e) {
            throw new HibernateException(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new HibernateException(e.getMessage(), (Throwable)e);
        }
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }

    public int hashCode(Object value) throws HibernateException {
        return ((Document)value).hashCode();
    }
}

