/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.commons.ant;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.dom4j.Attribute;
import org.dom4j.Comment;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class LowercaseTableNames
extends Task {
    private SAXReader iSAXReader = null;
    private String iSource = null;
    private String iConfig = "hibernate.cfg.xml";
    private EntityResolver iEntityResolver = new EntityResolver(){

        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            if (publicId.equals("-//Hibernate/Hibernate Mapping DTD 3.0//EN")) {
                return new InputSource(this.getClass().getClassLoader().getResourceAsStream("org/hibernate/hibernate-mapping-3.0.dtd"));
            }
            if (publicId.equals("-//Hibernate/Hibernate Configuration DTD 3.0//EN")) {
                return new InputSource(this.getClass().getClassLoader().getResourceAsStream("org/hibernate/hibernate-configuration-3.0.dtd"));
            }
            return null;
        }
    };
    private String[] sAttributes = new String[]{"table", "sequence", "column", "foreign-key", "order-by"};
    private String[] sFormulas = new String[]{"formula", "where"};

    public LowercaseTableNames() throws DocumentException, SAXException {
        this.iSAXReader = new SAXReader();
        this.iSAXReader.setEntityResolver(this.iEntityResolver);
        this.iSAXReader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
    }

    public void setSource(String source) {
        this.iSource = source;
    }

    public void setConfig(String config) {
        this.iConfig = config;
    }

    protected Document read(String resource) throws IOException, DocumentException {
        if (this.iSource == null) {
            this.info("  -- reading " + resource + " ...");
            return this.iSAXReader.read(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(resource));
        }
        this.info("  -- reading " + this.iSource + File.separator + resource + " ...");
        return this.iSAXReader.read(new File(this.iSource + File.separator + resource));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void write(String resource, Document document) throws IOException, DocumentException {
        File file = null;
        file = this.iSource == null ? new File(((Object)((Object)this)).getClass().getClassLoader().getResource(resource).getFile()) : new File(this.iSource + File.separator + resource);
        this.info("  -- writing " + file + " ...");
        FileOutputStream fos = new FileOutputStream(file);
        try {
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setIndentSize(4);
            format.setPadText(false);
            new MyXMLWriter(fos, format).write(document);
        }
        finally {
            fos.flush();
            fos.close();
        }
    }

    protected void pretty(File f) {
    }

    public void execute() throws BuildException {
        try {
            this.convert();
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void info(String message) {
        try {
            this.log(message);
        }
        catch (Exception e) {
            System.out.println(message);
        }
    }

    public void warn(String message) {
        try {
            this.log(message, 1);
        }
        catch (Exception e) {
            System.out.println(message);
        }
    }

    public void convert() throws IOException, DocumentException {
        this.info("Config: " + (this.iSource == null ? ((Object)((Object)this)).getClass().getClassLoader().getResource(this.iConfig) : this.iSource + File.separator + this.iConfig));
        File workDir = null;
        if (this.iSource == null) {
            workDir = new File(((Object)((Object)this)).getClass().getClassLoader().getResource(this.iConfig).getFile());
            while (workDir.getParentFile() != null && !"WebContent".equals(workDir.getName())) {
                workDir = workDir.getParentFile();
            }
            workDir = new File(workDir.getParentFile(), "JavaSource");
            workDir.mkdirs();
        } else {
            workDir = new File(this.iSource);
        }
        this.info("Working directory: " + workDir);
        this.info("Reading hibernate.cfg.xml ...");
        Document document = this.read(this.iConfig);
        Element root = document.getRootElement();
        Element sessionFactoryElement = root.element("session-factory");
        Iterator i = sessionFactoryElement.elementIterator("mapping");
        while (i.hasNext()) {
            Element m = (Element)i.next();
            String resource = m.attributeValue("resource");
            if (resource == null) continue;
            this.info("Processing " + resource + " ...");
            Document resDoc = this.read(resource);
            this.convert(resDoc.getRootElement());
            this.write(resource, resDoc);
        }
    }

    private String lowerFormula(String formula) {
        boolean quot = false;
        String ret = "";
        for (int i = 0; i < formula.length(); ++i) {
            char ch = formula.charAt(i);
            if (ch == '\'') {
                quot = !quot;
            }
            ret = ret + (quot ? ch : Character.toLowerCase(ch));
        }
        return ret.replace("%schema%", "%SCHEMA%").replace("/*+ rule */", "/*+ RULE */");
    }

    private void convert(Element element) {
        Object i = element.attributeIterator();
        while (i.hasNext()) {
            Attribute attribute = (Attribute)i.next();
            for (String name : this.sAttributes) {
                if (!name.equals(attribute.getName())) continue;
                if (!attribute.getValue().equals(attribute.getValue().toLowerCase())) {
                    this.info("  -- converting " + name + " " + attribute.getValue() + " to " + attribute.getValue().toLowerCase());
                }
                attribute.setValue(attribute.getValue().toLowerCase());
            }
            for (String name : this.sFormulas) {
                if (!name.equals(attribute.getName())) continue;
                if (!this.lowerFormula(attribute.getValue()).equals(attribute.getValue())) {
                    this.info("  -- converting " + name + ": " + attribute.getValue());
                    this.info("  -- into : " + this.lowerFormula(attribute.getValue()));
                }
                attribute.setValue(this.lowerFormula(attribute.getValue()));
            }
        }
        if (element.getName().equals("param")) {
            for (String name : this.sAttributes) {
                if (!name.equals(element.attributeValue("name", ""))) continue;
                if (!element.getText().equals(element.getText().toLowerCase())) {
                    this.info("  -- converting " + (String)name + " " + element.getText() + " to " + element.getText().toLowerCase());
                }
                element.setText(element.getText().toLowerCase());
            }
        }
        i = element.elementIterator();
        while (i.hasNext()) {
            this.convert((Element)i.next());
        }
    }

    public static void main(String[] args) {
        try {
            LowercaseTableNames ltn = new LowercaseTableNames();
            ltn.setSource("/Users/muller/Sources/UniTime/JavaSource");
            ltn.convert();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class MyXMLWriter
    extends XMLWriter {
        private OutputFormat format;
        private int indentLevel;

        public MyXMLWriter(OutputStream out, OutputFormat format) throws UnsupportedEncodingException {
            super(out, format);
            this.indentLevel = 0;
            this.format = format;
        }

        protected void indent() throws IOException {
            String indent = this.format.getIndent();
            if (indent != null && indent.length() > 0) {
                for (int i = 0; i < this.indentLevel; ++i) {
                    this.writer.write(indent);
                }
            }
        }

        protected void writeAttributes(Element element) throws IOException {
            int size = element.attributeCount();
            for (int i = 0; i < size; ++i) {
                Attribute attribute = element.attribute(i);
                char quote = this.format.getAttributeQuoteCharacter();
                if (element.attributeCount() > 2) {
                    this.writePrintln();
                    this.indent();
                    this.writer.write(this.format.getIndent());
                } else {
                    this.writer.write(" ");
                }
                this.writer.write(attribute.getQualifiedName());
                this.writer.write("=");
                this.writer.write(quote);
                this.writeEscapeAttributeEntities(attribute.getValue());
                this.writer.write(quote);
            }
        }

        protected void writeElement(Element element) throws IOException {
            int size = element.nodeCount();
            String qualifiedName = element.getQualifiedName();
            this.writePrintln();
            this.indent();
            this.writer.write("<");
            this.writer.write(qualifiedName);
            boolean textOnly = true;
            for (int i = 0; i < size; ++i) {
                Node node = element.node(i);
                if (node instanceof Element) {
                    textOnly = false;
                    continue;
                }
                if (!(node instanceof Comment)) continue;
                textOnly = false;
            }
            this.writeAttributes(element);
            this.lastOutputNodeType = 1;
            if (size <= 0) {
                this.writeEmptyElementClose(qualifiedName);
            } else {
                this.writer.write(">");
                if (textOnly) {
                    this.writeElementContent(element);
                } else {
                    if (element.attributeCount() > 3) {
                        this.writePrintln();
                    }
                    ++this.indentLevel;
                    this.writeElementContent(element);
                    --this.indentLevel;
                    this.writePrintln();
                    this.indent();
                }
                this.writer.write("</");
                this.writer.write(qualifiedName);
                this.writer.write(">");
            }
            if (element.attributeCount() > 2 && this.indentLevel > 0) {
                this.writePrintln();
            }
            this.lastOutputNodeType = 1;
        }
    }
}

