/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.online;

import java.util.Set;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.heuristics.RouletteWheelSelection;
import org.cpsolver.ifs.model.GlobalConstraint;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.online.OnlineSectioningModel;
import org.cpsolver.studentsct.online.expectations.OverExpectedCriterion;

public class MaxOverExpectedConstraint
extends GlobalConstraint<Request, Enrollment> {
    private double iMaxOverExpected;

    public MaxOverExpectedConstraint(double limit) {
        this.iMaxOverExpected = limit;
    }

    public void computeConflicts(Assignment<Request, Enrollment> assignment, Enrollment value, Set<Enrollment> conflicts) {
        if (!value.isCourseRequest()) {
            return;
        }
        CourseRequest cr = (CourseRequest)value.variable();
        OnlineSectioningModel model = (OnlineSectioningModel)this.getModel();
        double basePenalty = model.getOverExpected(assignment, value, value, conflicts);
        if (basePenalty > this.iMaxOverExpected) {
            conflicts.add(value);
            return;
        }
        RouletteWheelSelection selection = new RouletteWheelSelection();
        for (Request r : cr.getStudent().getRequests()) {
            double penalty;
            Enrollment e = (Enrollment)assignment.getValue((Variable)r);
            if (e == null || r.equals(value.variable()) || conflicts.contains((Object)e) || !e.isCourseRequest() || !((penalty = model.getOverExpected(assignment, e, value, conflicts)) > 0.0)) continue;
            selection.add((Object)e, penalty);
        }
        while (selection.getRemainingPoints() + basePenalty > this.iMaxOverExpected && selection.hasMoreElements()) {
            conflicts.add((Enrollment)((Object)selection.nextElement()));
        }
    }

    public boolean inConflict(Assignment<Request, Enrollment> assignment, Enrollment value) {
        if (!value.isCourseRequest()) {
            return false;
        }
        OverExpectedCriterion over = ((OnlineSectioningModel)this.getModel()).getOverExpectedCriterion();
        if (over == null) {
            return false;
        }
        double penalty = 0.0;
        for (Request r : value.getRequest().getStudent().getRequests()) {
            Enrollment e = r.equals(value.variable()) ? value : (Enrollment)assignment.getValue((Variable)r);
            if (e == null || !e.isCourseRequest()) continue;
            for (Section s : e.getSections()) {
                penalty += over.getOverExpected(assignment, s, e.getRequest());
            }
        }
        return penalty > this.iMaxOverExpected;
    }
}

