/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.heuristics.selection;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.heuristics.NeighbourSelection;
import org.cpsolver.ifs.model.InfoProvider;
import org.cpsolver.ifs.model.Neighbour;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.solver.SolverListener;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.JProf;
import org.cpsolver.ifs.util.Progress;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.heuristics.selection.ProblemStudentsProvider;
import org.cpsolver.studentsct.heuristics.studentord.StudentChoiceRealFirstOrder;
import org.cpsolver.studentsct.heuristics.studentord.StudentOrder;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Student;

public class SwapStudentSelection
implements NeighbourSelection<Request, Enrollment>,
ProblemStudentsProvider,
InfoProvider<Request, Enrollment>,
SolverListener<Request, Enrollment> {
    private static Logger sLog = LogManager.getLogger(SwapStudentSelection.class);
    private Set<Student> iProblemStudents = Collections.synchronizedSet(new HashSet());
    private LinkedList<Student> iStudents = null;
    private static DecimalFormat sDF = new DecimalFormat("0.00");
    private int iTimeout = 5000;
    private int iMaxValues = 100;
    public static boolean sDebug = false;
    protected StudentOrder iOrder = new StudentChoiceRealFirstOrder();
    private boolean iPreferPriorityStudents = true;
    protected Map<Student, Integer> iFailedCounter = new HashMap<Student, Integer>();
    protected long iNbrIterations = 0L;
    protected long iTotalTime = 0L;
    protected long iNbrTimeoutReached = 0L;
    protected long iNbrNoSolution = 0L;
    protected long iNbrStudents = 0L;

    public SwapStudentSelection(DataProperties properties) {
        this.iTimeout = properties.getPropertyInt("Neighbour.SwapStudentsTimeout", this.iTimeout);
        this.iMaxValues = properties.getPropertyInt("Neighbour.SwapStudentsMaxValues", this.iMaxValues);
        if (properties.getProperty("Neighbour.SwapStudentsOrder") != null) {
            try {
                this.iOrder = (StudentOrder)Class.forName(properties.getProperty("Neighbour.SwapStudentsOrder")).getConstructor(DataProperties.class).newInstance(properties);
            }
            catch (Exception e) {
                sLog.error("Unable to set student order, reason:" + e.getMessage(), (Throwable)e);
            }
        }
        this.iPreferPriorityStudents = properties.getPropertyBoolean("Sectioning.PriorityStudentsFirstSelection.AllIn", true);
    }

    public void init(Solver<Request, Enrollment> solver) {
        List<Student> students = this.iOrder.order(((StudentSectioningModel)solver.currentSolution().getModel()).getStudents());
        this.iStudents = new LinkedList<Student>(students);
        this.iProblemStudents.clear();
        this.iFailedCounter.clear();
        Progress.getInstance((Object)solver.currentSolution().getModel()).setPhase("Student swap...", (long)students.size());
        this.iNbrIterations = 0L;
        this.iNbrTimeoutReached = 0L;
        this.iNbrNoSolution = 0L;
        this.iTotalTime = 0L;
        this.iNbrStudents = this.iStudents.size();
    }

    protected synchronized Student nextStudent() {
        return this.iStudents.poll();
    }

    public synchronized void addStudent(Student student) {
        if (this.iStudents != null && student != null && !student.isDummy()) {
            Integer failed = this.iFailedCounter.getOrDefault(student, 0);
            this.iFailedCounter.put(student, 1 + failed);
            if (failed >= 10) {
                return;
            }
            if (student.getPriority().ordinal() < Student.StudentPriority.Normal.ordinal()) {
                ListIterator<Student> i = this.iStudents.listIterator();
                while (i.hasNext()) {
                    Student s = (Student)i.next();
                    if (s.getPriority().compareTo(student.getPriority()) <= 0) continue;
                    i.previous();
                    i.add(student);
                    return;
                }
            }
            this.iStudents.add(student);
        }
    }

    public Neighbour<Request, Enrollment> selectNeighbour(Solution<Request, Enrollment> solution) {
        Student student = null;
        block2: while ((student = this.nextStudent()) != null) {
            Progress p = Progress.getInstance((Object)solution.getModel());
            p.setProgress(this.iNbrStudents - (long)this.iStudents.size());
            if ((double)p.getProgress() > 2.0 * (double)p.getProgressMax()) {
                return null;
            }
            if (student.isComplete((Assignment<Request, Enrollment>)solution.getAssignment()) || student.nrAssignedRequests((Assignment<Request, Enrollment>)solution.getAssignment()) == 0) continue;
            for (int i = 0; i < 5; ++i) {
                try {
                    Selection selection = this.getSelection((Assignment<Request, Enrollment>)solution.getAssignment(), student);
                    SwapStudentNeighbour neighbour = selection.select();
                    if (neighbour != null) {
                        this.addStudent(student);
                        return neighbour;
                    }
                    this.iProblemStudents.addAll(selection.getProblemStudents());
                    continue block2;
                }
                catch (ConcurrentModificationException concurrentModificationException) {
                    continue;
                }
            }
        }
        return null;
    }

    @Override
    public Set<Student> getProblemStudents() {
        return this.iProblemStudents;
    }

    public Selection getSelection(Assignment<Request, Enrollment> assignment, Student student) {
        return new Selection(student, assignment);
    }

    public static Enrollment bestSwap(Assignment<Request, Enrollment> assignment, Enrollment conflict, Enrollment enrl, Set<Student> problematicStudents) {
        Enrollment bestEnrollment = null;
        double bestValue = 0.0;
        for (Enrollment enrollment : conflict.getRequest().values(assignment)) {
            if (((Request)conflict.variable()).getModel().inConflict(assignment, (Value)enrollment)) continue;
            double value = enrollment.toDouble(assignment);
            if (bestEnrollment != null && !(bestValue > value)) continue;
            bestEnrollment = enrollment;
            bestValue = value;
        }
        if (bestEnrollment == null && problematicStudents != null) {
            boolean added = false;
            for (Enrollment enrollment : conflict.getRequest().values(assignment)) {
                Set conflicts = ((Request)conflict.variable()).getModel().conflictValues(assignment, (Value)enrollment);
                for (Enrollment c : conflicts) {
                    if (enrl.getStudent().isDummy() && !c.getStudent().isDummy() || enrl.getStudent().equals(c.getStudent()) || conflict.getStudent().equals(c.getStudent())) continue;
                    problematicStudents.add(c.getStudent());
                }
            }
            if (!added && !enrl.getStudent().equals(conflict.getStudent())) {
                problematicStudents.add(conflict.getStudent());
            }
        }
        return bestEnrollment;
    }

    public void getInfo(Assignment<Request, Enrollment> assignment, Map<String, String> info) {
        if (this.iNbrIterations > 0L) {
            info.put("Timing of " + this.getClass().getSimpleName(), sDF.format((double)this.iTotalTime / (double)this.iNbrIterations) + " ms/it (" + this.iNbrIterations + " iterations, " + (this.iNbrNoSolution == 0L ? "" : sDF.format(100.0 * (double)this.iNbrNoSolution / (double)this.iNbrIterations) + "% no solution, ") + sDF.format(100.0 * (double)this.iNbrTimeoutReached / (double)this.iNbrIterations) + "% time limit of " + sDF.format((double)this.iTimeout / 1000.0) + " seconds reached)");
        }
    }

    public void getInfo(Assignment<Request, Enrollment> assignment, Map<String, String> info, Collection<Request> variables) {
    }

    public boolean variableSelected(Assignment<Request, Enrollment> assignment, long iteration, Request variable) {
        return false;
    }

    public boolean valueSelected(Assignment<Request, Enrollment> assignment, long iteration, Request variable, Enrollment value) {
        return false;
    }

    public boolean neighbourSelected(Assignment<Request, Enrollment> assignment, long iteration, Neighbour<Request, Enrollment> neighbour) {
        return false;
    }

    public void neighbourFailed(Assignment<Request, Enrollment> assignment, long iteration, Neighbour<Request, Enrollment> neighbour) {
        if (neighbour instanceof SwapStudentNeighbour) {
            this.addStudent(((SwapStudentNeighbour)neighbour).getStudent());
        }
    }

    public static class SwapStudentNeighbour
    implements Neighbour<Request, Enrollment> {
        private double iValue;
        private Enrollment iEnrollment;
        private List<Enrollment> iSwaps;

        public SwapStudentNeighbour(double value, Enrollment enrollment, List<Enrollment> swaps) {
            this.iValue = value;
            this.iEnrollment = enrollment;
            this.iSwaps = swaps;
        }

        public double value(Assignment<Request, Enrollment> assignment) {
            return this.iValue;
        }

        public Student getStudent() {
            return this.iEnrollment.getStudent();
        }

        public void assign(Assignment<Request, Enrollment> assignment, long iteration) {
            assignment.unassign(iteration, this.iEnrollment.variable());
            for (Enrollment swap : this.iSwaps) {
                assignment.unassign(iteration, swap.variable(), (Value)swap);
            }
            assignment.assign(iteration, (Value)this.iEnrollment);
            for (Enrollment swap : this.iSwaps) {
                assignment.assign(iteration, (Value)swap);
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("SwSt{");
            sb.append(" " + this.iEnrollment.getRequest().getStudent());
            sb.append(" (" + this.iValue + ")");
            sb.append("\n " + (Object)((Object)this.iEnrollment.getRequest()));
            sb.append(" " + (Object)((Object)this.iEnrollment));
            for (Enrollment swap : this.iSwaps) {
                sb.append("\n " + (Object)((Object)swap.getRequest()));
                sb.append(" -> " + (Object)((Object)swap));
            }
            sb.append("\n}");
            return sb.toString();
        }

        public Map<Request, Enrollment> assignments() {
            HashMap<Request, Enrollment> ret = new HashMap<Request, Enrollment>();
            ret.put((Request)this.iEnrollment.variable(), this.iEnrollment);
            for (Enrollment swap : this.iSwaps) {
                ret.put((Request)swap.variable(), swap);
            }
            return ret;
        }
    }

    public class Selection {
        private Student iStudent;
        private long iT0;
        private long iT1;
        private boolean iTimeoutReached;
        private Enrollment iBestEnrollment;
        private double iBestValue;
        private Set<Student> iProblemStudents;
        private List<Enrollment> iBestSwaps;
        private Assignment<Request, Enrollment> iAssignment;

        public Selection(Student student, Assignment<Request, Enrollment> assignment) {
            this.iStudent = student;
            this.iAssignment = assignment;
        }

        public boolean canUnassign(Enrollment enrollment, Enrollment conflict, Assignment<Request, Enrollment> assignment) {
            float credit;
            if (conflict.getRequest().isMPP() && conflict.equals(conflict.getRequest().getInitialAssignment()) && !enrollment.equals(enrollment.getRequest().getInitialAssignment())) {
                return false;
            }
            if (conflict.getRequest() instanceof CourseRequest && ((CourseRequest)conflict.getRequest()).getFixedValue() != null) {
                return false;
            }
            if (conflict.getRequest().getStudent().hasMinCredit() && (credit = conflict.getRequest().getStudent().getAssignedCredit(assignment) - conflict.getCredit()) < conflict.getRequest().getStudent().getMinCredit()) {
                return false;
            }
            if (!conflict.getRequest().isAlternative() && conflict.getRequest().getRequestPriority().isHigher(enrollment.getRequest())) {
                return false;
            }
            return !SwapStudentSelection.this.iPreferPriorityStudents && !conflict.getRequest().getRequestPriority().isSame(enrollment.getRequest()) || !conflict.getStudent().getPriority().isHigher(enrollment.getStudent());
        }

        public SwapStudentNeighbour select() {
            if (sDebug) {
                sLog.debug("select(S" + this.iStudent.getId() + ")");
            }
            this.iT0 = JProf.currentTimeMillis();
            this.iTimeoutReached = false;
            this.iBestEnrollment = null;
            this.iProblemStudents = new HashSet<Student>();
            Double initialValue = null;
            block0: for (Request request : this.iStudent.getRequests()) {
                if (initialValue == null) {
                    initialValue = request.getModel().getTotalValue(this.iAssignment);
                }
                if (SwapStudentSelection.this.iTimeout > 0 && JProf.currentTimeMillis() - this.iT0 > (long)SwapStudentSelection.this.iTimeout) {
                    if (this.iTimeoutReached) break;
                    if (sDebug) {
                        sLog.debug("  -- timeout reached");
                    }
                    this.iTimeoutReached = true;
                    break;
                }
                if (this.iAssignment.getValue((Variable)request) != null || !this.iStudent.canAssign(this.iAssignment, request)) continue;
                if (sDebug) {
                    sLog.debug("  -- checking request " + (Object)((Object)request));
                }
                List<Enrollment> values = null;
                values = SwapStudentSelection.this.iMaxValues > 0 && request instanceof CourseRequest ? ((CourseRequest)request).computeRandomEnrollments(this.iAssignment, SwapStudentSelection.this.iMaxValues) : request.values(this.iAssignment);
                block1: for (Enrollment enrollment : values) {
                    Enrollment conflict;
                    Set conflicts;
                    Object e;
                    if (enrollment.getCourse() != null && enrollment.getCourse().getParent() != null) {
                        Course parent = enrollment.getCourse().getParent();
                        for (Request r : this.iStudent.getRequests()) {
                            if (!r.hasCourse(parent) || (e = (Enrollment)this.iAssignment.getValue((Variable)r)) != null && parent.equals((Object)((Enrollment)((Object)e)).getCourse())) continue;
                            continue block1;
                        }
                    }
                    if (SwapStudentSelection.this.iTimeout > 0 && JProf.currentTimeMillis() - this.iT0 > (long)SwapStudentSelection.this.iTimeout) {
                        if (this.iTimeoutReached) continue block0;
                        if (sDebug) {
                            sLog.debug("  -- timeout reached");
                        }
                        this.iTimeoutReached = true;
                        continue block0;
                    }
                    if (sDebug) {
                        sLog.debug("      -- enrollment " + (Object)((Object)enrollment));
                    }
                    if ((conflicts = ((Request)enrollment.variable()).getModel().conflictValues(this.iAssignment, (Value)enrollment)).contains((Object)enrollment)) continue;
                    double bound = enrollment.toDouble(this.iAssignment);
                    e = conflicts.iterator();
                    while (e.hasNext()) {
                        conflict = (Enrollment)((Object)e.next());
                        bound += ((Request)conflict.variable()).getBound();
                        if (this.canUnassign(enrollment, conflict, this.iAssignment)) continue;
                        continue block1;
                    }
                    if (this.iBestEnrollment != null && bound >= this.iBestValue) continue;
                    e = conflicts.iterator();
                    while (e.hasNext()) {
                        conflict = (Enrollment)((Object)e.next());
                        this.iAssignment.unassign(0L, conflict.variable());
                    }
                    this.iAssignment.assign(0L, (Value)enrollment);
                    boolean allResolved = true;
                    ArrayList<Enrollment> swaps = new ArrayList<Enrollment>(conflicts.size());
                    for (Enrollment conflict2 : conflicts) {
                        Enrollment other;
                        if (sDebug) {
                            sLog.debug("        -- conflict " + (Object)((Object)conflict2));
                        }
                        if ((other = SwapStudentSelection.bestSwap(this.iAssignment, conflict2, enrollment, this.iProblemStudents)) == null) {
                            if (sDebug) {
                                sLog.debug("          -- unable to resolve");
                            }
                            allResolved = false;
                            break;
                        }
                        this.iAssignment.assign(0L, (Value)other);
                        swaps.add(other);
                        if (!sDebug) continue;
                        sLog.debug("          -- can be resolved by switching to " + other.getName());
                    }
                    double value = request.getModel().getTotalValue(this.iAssignment) - initialValue;
                    for (Enrollment other : swaps) {
                        this.iAssignment.unassign(0L, other.variable());
                    }
                    this.iAssignment.unassign(0L, enrollment.variable());
                    for (Enrollment conflict3 : conflicts) {
                        this.iAssignment.assign(0L, (Value)conflict3);
                    }
                    if (!allResolved || !(value <= 0.0) || this.iBestEnrollment != null && !(this.iBestValue > value)) continue;
                    this.iBestEnrollment = enrollment;
                    this.iBestValue = value;
                    this.iBestSwaps = swaps;
                }
            }
            this.iT1 = JProf.currentTimeMillis();
            ++SwapStudentSelection.this.iNbrIterations;
            SwapStudentSelection.this.iTotalTime += this.iT1 - this.iT0;
            if (this.iTimeoutReached) {
                ++SwapStudentSelection.this.iNbrTimeoutReached;
            }
            if (this.iBestEnrollment == null) {
                ++SwapStudentSelection.this.iNbrNoSolution;
            }
            if (sDebug) {
                sLog.debug("  -- done, best enrollment is " + (Object)((Object)this.iBestEnrollment));
            }
            if (this.iBestEnrollment == null) {
                if (this.iProblemStudents.isEmpty()) {
                    this.iProblemStudents.add(this.iStudent);
                }
                if (sDebug) {
                    sLog.debug("  -- problem students are: " + this.iProblemStudents);
                }
                return null;
            }
            if (sDebug) {
                sLog.debug("  -- value " + this.iBestValue);
            }
            Enrollment[] assignment = new Enrollment[this.iStudent.getRequests().size()];
            int idx = 0;
            for (Request request : this.iStudent.getRequests()) {
                assignment[idx++] = this.iBestEnrollment.getRequest().equals((Object)request) ? this.iBestEnrollment : (Enrollment)request.getAssignment(this.iAssignment);
            }
            return new SwapStudentNeighbour(this.iBestValue, this.iBestEnrollment, this.iBestSwaps);
        }

        public boolean isTimeoutReached() {
            return this.iTimeoutReached;
        }

        public long getTime() {
            return this.iT1 - this.iT0;
        }

        public Enrollment getBestEnrollment() {
            return this.iBestEnrollment;
        }

        public double getBestValue() {
            return this.iBestValue;
        }

        public Set<Student> getProblemStudents() {
            return this.iProblemStudents;
        }
    }
}

