/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.constraint;

import java.util.Set;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.GlobalConstraint;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.reservation.Reservation;

public class RequiredReservation
extends GlobalConstraint<Request, Enrollment> {
    public void computeConflicts(Assignment<Request, Enrollment> assignment, Enrollment enrollment, Set<Enrollment> conflicts) {
        if (this.inConflict(assignment, enrollment)) {
            conflicts.add(enrollment);
        }
    }

    public boolean inConflict(Assignment<Request, Enrollment> assignment, Enrollment enrollment) {
        Config config = enrollment.getConfig();
        if (config == null) {
            return false;
        }
        if (!config.getOffering().hasReservations()) {
            return false;
        }
        Reservation reservation = enrollment.getReservation();
        if (reservation != null && reservation.mustBeUsed()) {
            return false;
        }
        for (Reservation r : config.getOffering().getReservations()) {
            if (!r.mustBeUsed() || !r.isApplicable(enrollment.getStudent(), enrollment.getCourse())) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "RequiredReservation";
    }
}

